/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.gigaspaces.metadata.index.SpaceIndexType;
import com.gigaspaces.security.Authority;
import com.j_spaces.tools.spacebrowser.utils.IconsRepository;
import com.j_spaces.tools.spacebrowser.utils.TableChangedListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ClassIndexesDefinitionPanel
extends Box
implements ActionListener {
    private String[] _classProperties;
    private JTable _classIndexesTable;
    private ClassIndexesTableModel _classIndexesTableModel;
    private JButton _addClassIndexButton;
    private JButton _deleteClassIndexButton;
    private String[] _existingIndexes;
    private final JDialog _parentDialog;
    private List<TableChangedListener> _tableChangeListenersList = new ArrayList<TableChangedListener>();
    private final Dimension buttonSize = new Dimension(24, 24);

    public ClassIndexesDefinitionPanel(JDialog parentDialog, String[] classProperties, String[] existingIndexes) {
        super(1);
        this._parentDialog = parentDialog;
        this._classProperties = classProperties;
        this._existingIndexes = existingIndexes;
        this.init();
    }

    public void addTableChangeListener(TableChangedListener tableChangedListener) {
        this._tableChangeListenersList.add(tableChangedListener);
    }

    private void init() {
        this.add(Box.createVerticalStrut(6));
        Box classesTableBox = this.createIndexesTableBox();
        this.add(classesTableBox);
        this.add(Box.createVerticalStrut(3));
    }

    private Box createIndexesTableBox() {
        Box classIndexesTableBox = new Box(0);
        this._classIndexesTableModel = new ClassIndexesTableModel();
        this._classIndexesTable = new JTable(this._classIndexesTableModel);
        this._classIndexesTable.setRowHeight(17);
        this.setTableProperties(this._classIndexesTable);
        this._classIndexesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ClassIndexesDefinitionPanel.this.handleDeleteButtonState();
            }
        });
        this._classIndexesTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    ClassIndexesDefinitionPanel.this.deleteSelectedRows();
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this._classIndexesTable);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        classIndexesTableBox.add(scrollPane);
        this._addClassIndexButton = this.createAddRemoveButton(IconsRepository.getInstance().getIcon(200), "+", "Add index");
        this._deleteClassIndexButton = this.createAddRemoveButton(IconsRepository.getInstance().getIcon(201), "-", "Remove selected index(es)");
        this._addClassIndexButton.addActionListener(this);
        this._deleteClassIndexButton.addActionListener(this);
        Box buttonsBox = new Box(0);
        buttonsBox.add(Box.createHorizontalStrut(5));
        buttonsBox.add(this._addClassIndexButton);
        buttonsBox.add(Box.createHorizontalStrut(5));
        buttonsBox.add(this._deleteClassIndexButton);
        buttonsBox.add(Box.createHorizontalGlue());
        Box vertBox = new Box(1);
        vertBox.add(classIndexesTableBox);
        vertBox.add(Box.createVerticalStrut(4));
        vertBox.add(buttonsBox);
        return vertBox;
    }

    private JButton createAddRemoveButton(ImageIcon icon, String text, String tooltip) {
        JButton button = new JButton(text);
        button.setPreferredSize(this.buttonSize);
        button.setMinimumSize(this.buttonSize);
        button.setToolTipText(tooltip);
        return button;
    }

    private void setTableProperties(JTable table) {
        JTableHeader header = table.getTableHeader();
        header.setReorderingAllowed(false);
        table.setRowHeight(table.getRowHeight() + 3);
        TableColumnModel tableColumnModel = table.getColumnModel();
        TableColumn pathColumn = tableColumnModel.getColumn(0);
        TableColumn typeColumn = tableColumnModel.getColumn(1);
        JComboBox<String> classPropertiesComboBox = new JComboBox<String>(this._classProperties);
        pathColumn.setCellEditor(new DefaultCellEditor(classPropertiesComboBox));
        classPropertiesComboBox.setEditable(true);
        JComboBox<String> typeComboBox = new JComboBox<String>();
        typeComboBox.addItem(SpaceIndexType.EQUAL.name());
        typeComboBox.addItem(SpaceIndexType.ORDERED.name());
        typeComboBox.addItem(SpaceIndexType.EQUAL_AND_ORDERED.name());
        typeColumn.setCellEditor(new DefaultCellEditor(typeComboBox));
        typeColumn.setPreferredWidth(85);
        typeColumn.setMaxWidth(85);
        table.setAutoCreateColumnsFromModel(false);
        table.setAutoResizeMode(4);
        table.setAutoscrolls(true);
    }

    private void handleDeleteButtonState() {
        this._deleteClassIndexButton.setEnabled(this._classIndexesTable.getSelectedRows().length > 0);
    }

    public void clear() {
        this._deleteClassIndexButton.setEnabled(false);
        this._classIndexesTableModel.clear();
        this._classIndexesTable.setEditingColumn(-1);
        this._classIndexesTable.setEditingRow(-1);
        TableCellEditor cellEditor = this._classIndexesTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.cancelCellEditing();
        }
    }

    public List<ClassIndexWrapper> getClassIndexes() {
        return this._classIndexesTableModel.getClassIndexes();
    }

    /*
     * WARNING - void declaration
     */
    public boolean isDataValid() {
        if (!this.stopCellEditong()) {
            return false;
        }
        HashSet<String> definedIndexPath = new HashSet<String>();
        List<ClassIndexWrapper> classIndexes = this._classIndexesTableModel.getClassIndexes();
        for (ClassIndexWrapper classIndexWrapper : classIndexes) {
            String path = classIndexWrapper.getPath();
            if (!this.isIndexNameValid(path)) {
                this.showValidationMessage("Index path cannot be empty");
                return false;
            }
            if (definedIndexPath.add(path)) continue;
            this.showValidationMessage("Please define unique paths for each of the indexes you want to define");
            return false;
        }
        HashSet<String> duplicatedIndexPath = new HashSet<String>();
        for (String existingIndex : this._existingIndexes) {
            if (!definedIndexPath.contains(existingIndex)) continue;
            duplicatedIndexPath.add(existingIndex);
        }
        if (duplicatedIndexPath.size() > 0) {
            void var4_7;
            String string = "";
            for (String duplicatedIndex : duplicatedIndexPath) {
                String string2 = (String)var4_7 + duplicatedIndex + "<BR>";
            }
            this.showValidationMessage("<HTML>The following paths are already indexed in the space:<BR><FONT color='green'>" + (String)var4_7 + "</FONT></HTML>");
            return false;
        }
        return true;
    }

    private boolean stopCellEditong() {
        int editingColumn = this._classIndexesTable.getEditingColumn();
        TableCellEditor cellEditor = this._classIndexesTable.getCellEditor();
        if (editingColumn == 0 && cellEditor != null) {
            Component component = ((DefaultCellEditor)cellEditor).getComponent();
            String indexName = null;
            if (component instanceof JTextField) {
                JTextField textEditor = (JTextField)component;
                indexName = textEditor.getText();
            } else if (component instanceof JComboBox) {
                JComboBox comboBox = (JComboBox)component;
                indexName = comboBox.getSelectedItem().toString();
            }
            if (!this.isIndexNameValid(indexName)) {
                this.showValidationMessage("Index path cannot be empty.");
                return false;
            }
        }
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
        return true;
    }

    private void showValidationMessage(String message) {
        JOptionPane.showMessageDialog(this._parentDialog, message, "Cannot complete the indexing operation", 2);
    }

    private boolean isIndexNameValid(String className) {
        return className.trim().length() > 0;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source.equals(this._addClassIndexButton)) {
            if (this.stopCellEditong()) {
                String path = this._classProperties.length == 0 ? "" : this._classProperties[0];
                ClassIndexWrapper classIndexWrapper = new ClassIndexWrapper(path, SpaceIndexType.EQUAL);
                this._classIndexesTableModel.addClassIndex(classIndexWrapper);
            }
        } else if (source.equals(this._deleteClassIndexButton)) {
            this.deleteSelectedRows();
        }
    }

    private void deleteSelectedRows() {
        if (!this.stopCellEditong()) {
            return;
        }
        int[] selRows = this._classIndexesTable.getSelectedRows();
        this._classIndexesTableModel.removeClassIndexAt(selRows);
        if (this._classIndexesTable.getRowCount() > 0) {
            int minRow = selRows[0];
            int selRow = minRow == 0 ? 0 : minRow - 1;
            this._classIndexesTable.setRowSelectionInterval(selRow, selRow);
        }
    }

    public class ClassIndexWrapper {
        private String _path;
        private SpaceIndexType _type;

        public ClassIndexWrapper(String path, SpaceIndexType type) {
            this._path = path;
            this._type = type;
        }

        public void setPath(String path) {
            this._path = path;
        }

        public void setType(SpaceIndexType type) {
            this._type = type;
        }

        public String getPath() {
            return this._path;
        }

        public SpaceIndexType getType() {
            return this._type;
        }
    }

    private class ClassIndexesTableModel
    extends DefaultTableModel {
        private final String CN_INDEX_PATH = "Path";
        private final String CN_INDEX_TYPE = "Type";
        public static final int CI_INDEX_PATH = 0;
        public static final int CI_INDEX_TYPE = 1;
        protected String[] columnNames;
        private final List<ClassIndexWrapper> _curClassIndexesList = new ArrayList<ClassIndexWrapper>();

        public ClassIndexesTableModel() {
            this.initColumnNames();
        }

        public void addClassIndex(ClassIndexWrapper classIndex) {
            this._curClassIndexesList.add(classIndex);
            int newListSize = this._curClassIndexesList.size();
            this.fireTableRowsInserted(newListSize - 1, newListSize - 1);
        }

        protected void initColumnNames() {
            this.columnNames = new String[2];
            this.columnNames[1] = "Type";
            this.columnNames[0] = "Path";
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (row >= this._curClassIndexesList.size()) {
                return;
            }
            ClassIndexWrapper classIndexWrapper = this._curClassIndexesList.get(row);
            switch (column) {
                case 0: {
                    String newPath = (String)aValue;
                    classIndexWrapper.setPath(newPath);
                    break;
                }
                case 1: {
                    String type = (String)aValue;
                    classIndexWrapper.setType(SpaceIndexType.valueOf((String)type));
                }
            }
        }

        @Override
        public void fireTableDataChanged() {
            super.fireTableDataChanged();
            this.fireTableRowsChanged();
        }

        @Override
        public void fireTableRowsInserted(int firstRow, int lastRow) {
            super.fireTableRowsInserted(firstRow, lastRow);
            this.fireTableRowsChanged();
        }

        @Override
        public void fireTableRowsDeleted(int firstRow, int lastRow) {
            super.fireTableRowsDeleted(firstRow, lastRow);
            this.fireTableRowsChanged();
        }

        private void fireTableRowsChanged() {
            int rowCount = this.getRowCount();
            for (TableChangedListener tableChangedListener : ClassIndexesDefinitionPanel.this._tableChangeListenersList) {
                tableChangedListener.rowsNumChanged(rowCount);
            }
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }

        public void removeClassIndexAt(int row) {
            if (row >= 0 && row < this._curClassIndexesList.size()) {
                this._curClassIndexesList.remove(row);
                this.fireTableRowsChanged();
                this.fireTableRowsDeleted(row, row);
            }
        }

        @Override
        public Object getValueAt(int row, int column) {
            ClassIndexWrapper classIndexWrapper;
            if (row >= 0 && row < this._curClassIndexesList.size() && (classIndexWrapper = this._curClassIndexesList.get(row)) != null) {
                return this.getCellValue(classIndexWrapper, column);
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public Class getColumnClass(int columnIndex) {
            Object obj = this.getValueAt(0, columnIndex);
            if (obj != null) {
                return obj.getClass();
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this._curClassIndexesList == null ? 0 : this._curClassIndexesList.size();
        }

        private Object getCellValue(ClassIndexWrapper classIndexWrapper, int column) {
            switch (column) {
                case 1: {
                    return classIndexWrapper.getType().name();
                }
                case 0: {
                    return classIndexWrapper.getPath();
                }
            }
            return "";
        }

        public ClassIndexWrapper getClassIndexWrapperAt(int row) {
            if (row >= 0 && row < this._curClassIndexesList.size()) {
                return this._curClassIndexesList.get(row);
            }
            return null;
        }

        public List<ClassIndexWrapper> getClassIndexes() {
            return this._curClassIndexesList;
        }

        public void setClassIndexes(List<ClassIndexWrapper> classIndexesList) {
            int curListSize = this._curClassIndexesList.size();
            this._curClassIndexesList.addAll(classIndexesList);
            int listSize = classIndexesList.size();
            if (listSize > 0) {
                this.fireTableRowsInserted(curListSize, curListSize + listSize - 1);
            }
        }

        public void removeClassIndexAt(int ... rows) {
            for (int index = rows.length - 1; index >= 0; --index) {
                this._curClassIndexesList.remove(rows[index]);
            }
            this.fireTableDataChanged();
        }

        private Object getAuthoritiesRepresentation(Authority[] authoritiesArray) {
            String result = "";
            for (Authority authority : authoritiesArray) {
                if (result.length() != 0) {
                    result = result + ", ";
                }
                result = result + authority.getAuthority();
            }
            return result;
        }

        public void clear() {
            int curRowCount = this._curClassIndexesList.size();
            if (curRowCount > 0) {
                this.fireTableRowsDeleted(0, curRowCount - 1);
            }
            this._curClassIndexesList.clear();
        }
    }
}

