/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.util.UIHelper;
import com.gigaspaces.admin.ui.views.RefreshThread;
import com.gigaspaces.admin.ui.views.utils.BasicSortableTableModel;
import com.gigaspaces.admin.ui.views.utils.BasicTable;
import com.gigaspaces.admin.ui.views.utils.BasicWrapper;
import com.gigaspaces.async.AsyncFutureListener;
import com.gigaspaces.async.AsyncResult;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.metadata.PropertyInfo;
import com.gigaspaces.metadata.StorageType;
import com.gigaspaces.metadata.index.AddTypeIndexesResult;
import com.gigaspaces.metadata.index.SpaceIndex;
import com.gigaspaces.metadata.index.SpaceIndexType;
import com.j_spaces.core.admin.IInternalRemoteJSpaceAdmin;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.tools.cluster.view.ColumnSortListener;
import com.j_spaces.tools.spacebrowser.AddClassIndexDialog;
import com.j_spaces.tools.spacebrowser.SpaceRuntimePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ClassPropertiesPanel
extends JPanel
implements RefreshThread.RefreshableView {
    private ITypeDesc _basicTypeInfo;
    private ISpaceProxy _spaceProxy;
    private String _typeName;
    private JPanel classPropertiesPanel;
    private JPanel checkBoxesPanel;
    private JLabel classNameLabel;
    private JTextField classNameTF;
    private JCheckBox fifoModeCB;
    private JLabel fifoModeLabel;
    private JLabel superClassesListLabel;
    private JTextField superClassesListTF;
    private JCheckBox replicationModeCB;
    private JLabel replicationModeLabel;
    private JLabel routingFieldNameLabel;
    private JLabel routingFieldLabel;
    private JLabel idPropertyFieldNameLabel;
    private JLabel idPropertyFieldLabel;
    private JCheckBox blobStoreEnabledCB;
    private JLabel blobStoreEnabledLabel;
    public static String CN_NAME = "Name";
    public static String CN_INDEX = "Index";
    public static String CN_TYPE = "Type";
    public static String CN_INDICATION = "Indication";
    public static String CN_STORAGE_TYPE = "Storage Type";
    public static final int CI_INDEX = 0;
    public static final int CI_TYPE = 1;
    public static final int CI_INDICATION = 2;
    private String[] classPropertiesColumnNames;
    private String[] classIndexesColumnNames;
    private String[] processedClassIndexesColumnNames;
    private final ClassPropertiesTableModel classPropertiesTableModel;
    private JTable classPropertiesTable;
    private final ClassIndexesTableModel classIndexesTableModel;
    private final JTable classIndexesTable;
    private final ClassIndexesTableModel processedClassIndexesTableModel;
    private final JTable processedClassIndexesTable;
    protected static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui.spacebrowser");
    private ImageIcon _failedIcon;
    private ImageIcon _progressIcon;
    private String[] _curClassProperties;
    private JFrame _parentFrame;
    private SpaceRuntimePanel _spaceRuntimePanel;
    private JButton _addIndexButton;
    private JButton _removeIndexButton;
    private String EXISTING_INDEXES_TAB_NAME;
    private String IN_PROGRESS_INDEXES_TAB_NAME;
    private String IN_PROGRESS_INDICATION;
    private String FAILED_INDICATION;
    private JTabbedPane _classIndexesTabbedPane;
    private Map<ISpaceProxy, Map<String, Map<String, ProcessIndexWrapper>>> _processedIndexes;
    private IInternalRemoteJSpaceAdmin _spaceAdmin;

    public ClassPropertiesPanel(JFrame parentFrame, SpaceRuntimePanel spaceRuntimePanel) {
        block2: {
            this.classPropertiesPanel = new JPanel();
            this.checkBoxesPanel = new JPanel();
            this.classNameLabel = new JLabel();
            this.classNameTF = new JTextField();
            this.fifoModeCB = new JCheckBox();
            this.fifoModeLabel = new JLabel("FIFO Enabled");
            this.superClassesListLabel = new JLabel();
            this.superClassesListTF = new JTextField();
            this.replicationModeCB = new JCheckBox();
            this.replicationModeLabel = new JLabel("Partial Replication Enabled");
            this.routingFieldNameLabel = new JLabel("Routing Field:");
            this.routingFieldLabel = new JLabel();
            this.idPropertyFieldNameLabel = new JLabel("Id:");
            this.idPropertyFieldLabel = new JLabel();
            this.blobStoreEnabledCB = new JCheckBox();
            this.blobStoreEnabledLabel = new JLabel("Blob Store Enabled");
            this.classPropertiesColumnNames = new String[]{CN_NAME, CN_TYPE, CN_STORAGE_TYPE};
            this.classIndexesColumnNames = new String[]{CN_INDEX, CN_TYPE};
            this.processedClassIndexesColumnNames = new String[]{CN_INDEX, CN_TYPE, CN_INDICATION};
            this.classPropertiesTableModel = new ClassPropertiesTableModel(this.classPropertiesColumnNames);
            this.classIndexesTableModel = new ClassIndexesTableModel(this.classIndexesColumnNames);
            this.classIndexesTable = new BasicTable(this.classIndexesTableModel);
            this.processedClassIndexesTableModel = new ClassIndexesTableModel(this.processedClassIndexesColumnNames);
            this.processedClassIndexesTable = new BasicTable(this.processedClassIndexesTableModel);
            this.EXISTING_INDEXES_TAB_NAME = "Existing";
            this.IN_PROGRESS_INDEXES_TAB_NAME = "In Progress";
            this.IN_PROGRESS_INDICATION = "In Progress";
            this.FAILED_INDICATION = "Failed";
            this._processedIndexes = new HashMap<ISpaceProxy, Map<String, Map<String, ProcessIndexWrapper>>>();
            this._parentFrame = parentFrame;
            this._spaceRuntimePanel = spaceRuntimePanel;
            try {
                this.jbInit();
                this._failedIcon = UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/remove_enter.gif");
                this._progressIcon = UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/restore.gif");
                new RefreshThread("Class-Indexes-Refresh", this).start();
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.SEVERE)) break block2;
                _logger.log(Level.SEVERE, ex.toString(), ex);
            }
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.classNameLabel.setText("Data Type Name: ");
        this.classPropertiesPanel.setLayout(new GridBagLayout());
        this.classPropertiesPanel.setBorder(null);
        this.checkBoxesPanel.setLayout(new GridBagLayout());
        this.classNameTF.setText("");
        this.classNameTF.setEditable(false);
        this.superClassesListLabel.setText("Super Data Types List: ");
        this.superClassesListTF.setText("");
        this.superClassesListTF.setEditable(false);
        this.classPropertiesTable = new JTable(this.classPropertiesTableModel){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
                Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
                if (c instanceof JComponent) {
                    JComponent jc = (JComponent)c;
                    jc.setToolTipText((String)this.getValueAt(rowIndex, vColIndex));
                }
                return c;
            }
        };
        JScrollPane classPropertiesScrollPane = new JScrollPane(this.classPropertiesTable);
        ToolTipManager.sharedInstance().registerComponent(this.classPropertiesTable);
        this.classPropertiesTable.getTableHeader().setReorderingAllowed(false);
        this.classPropertiesTable.setAutoCreateColumnsFromModel(false);
        this.classPropertiesTable.setAutoResizeMode(1);
        this.classPropertiesTable.getTableHeader().addMouseListener(new ColumnSortListener());
        JScrollPane classIndexesScrollPane = new JScrollPane(this.classIndexesTable);
        this.classIndexesTable.getTableHeader().setReorderingAllowed(false);
        this.classIndexesTable.setAutoCreateColumnsFromModel(false);
        this.classIndexesTable.setAutoResizeMode(1);
        TableColumnModel columnModel = this.classPropertiesTable.getTableHeader().getColumnModel();
        TableColumn nameColumn = columnModel.getColumn(0);
        nameColumn.setPreferredWidth(100);
        this.fifoModeCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClassPropertiesPanel.this.fifoModeCB.setSelected(!ClassPropertiesPanel.this.fifoModeCB.isSelected());
            }
        });
        this.blobStoreEnabledCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClassPropertiesPanel.this.blobStoreEnabledCB.setSelected(!ClassPropertiesPanel.this.blobStoreEnabledCB.isSelected());
            }
        });
        this.replicationModeCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClassPropertiesPanel.this.replicationModeCB.setSelected(!ClassPropertiesPanel.this.replicationModeCB.isSelected());
            }
        });
        this.add((Component)this.classPropertiesPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.classPropertiesPanel.add((Component)this.classNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 7, 2, 2), 0, 0));
        this.classPropertiesPanel.add((Component)this.classNameTF, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.classPropertiesPanel.add((Component)this.superClassesListLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 7, 2, 2), 0, 0));
        this.classPropertiesPanel.add((Component)this.superClassesListTF, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.classPropertiesPanel.add((Component)this.checkBoxesPanel, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        Box classIndexesBox = new Box(0);
        JSplitPane splitPane = new JSplitPane(1, classPropertiesScrollPane, classIndexesBox);
        splitPane.setDividerLocation(400);
        splitPane.setBorder(null);
        this.classPropertiesPanel.add((Component)splitPane, new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 10, 1, new Insets(1, 2, 1, 2), 0, 0));
        Box classIndexesButtonsBox = new Box(1);
        classPropertiesScrollPane.setBorder(BorderFactory.createTitledBorder("Properties"));
        classIndexesBox.setBorder(BorderFactory.createTitledBorder("Indexes"));
        Dimension buttonSize = new Dimension(70, 21);
        this._addIndexButton = new JButton("Add");
        this._addIndexButton.setToolTipText("Add class index");
        this._addIndexButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int rowCount = ClassPropertiesPanel.this.classIndexesTableModel.getRowCount();
                String[] existingIndexes = new String[rowCount];
                for (int row = 0; row < rowCount; ++row) {
                    String indexPath;
                    existingIndexes[row] = indexPath = ClassPropertiesPanel.this.classIndexesTableModel.getValueAt(row, 0).toString();
                }
                AddClassIndexDialog addClassIndexDialog = new AddClassIndexDialog(ClassPropertiesPanel.this._parentFrame, ClassPropertiesPanel.this._curClassProperties, existingIndexes);
                addClassIndexDialog.setVisible(true);
                SpaceIndex[] spaceIndexes = addClassIndexDialog.getSpaceIndexes();
                if (spaceIndexes != null && spaceIndexes.length > 0) {
                    block4: {
                        AsyncFutureListenerImpl asyncFutureListener = new AsyncFutureListenerImpl(ClassPropertiesPanel.this._spaceProxy, ClassPropertiesPanel.this._typeName);
                        ClassPropertiesPanel.this.addProcessesIndexesMap(spaceIndexes);
                        try {
                            ClassPropertiesPanel.this._spaceProxy.asyncAddIndexes(ClassPropertiesPanel.this._typeName, spaceIndexes, (AsyncFutureListener)asyncFutureListener);
                        }
                        catch (Throwable t) {
                            if (!_logger.isLoggable(Level.SEVERE)) break block4;
                            _logger.log(Level.SEVERE, t.toString(), t);
                        }
                    }
                    ClassPropertiesPanel.this._classIndexesTabbedPane.setSelectedIndex(1);
                }
            }
        });
        this._removeIndexButton = new JButton("Remove");
        this._removeIndexButton.setToolTipText("Remove class index");
        this._removeIndexButton.setEnabled(false);
        classIndexesButtonsBox.setPreferredSize(new Dimension(70, 200));
        classIndexesButtonsBox.add(Box.createVerticalStrut(21));
        classIndexesButtonsBox.add(this._addIndexButton);
        classIndexesButtonsBox.add(Box.createVerticalStrut(3));
        classIndexesButtonsBox.add(Box.createVerticalGlue());
        this._addIndexButton.setPreferredSize(buttonSize);
        this._removeIndexButton.setPreferredSize(buttonSize);
        this._addIndexButton.setMinimumSize(buttonSize);
        this._removeIndexButton.setMinimumSize(buttonSize);
        this._addIndexButton.setMaximumSize(buttonSize);
        this._removeIndexButton.setMaximumSize(buttonSize);
        this.processedClassIndexesTable.getColumnModel().getColumn(2).setCellRenderer(new ProcessedIndexesCellRenderer());
        JScrollPane processedClassIndexesScrollPane = new JScrollPane(this.processedClassIndexesTable);
        this._classIndexesTabbedPane = new JTabbedPane();
        this._classIndexesTabbedPane.addTab(this.EXISTING_INDEXES_TAB_NAME, classIndexesScrollPane);
        this._classIndexesTabbedPane.addTab(this.IN_PROGRESS_INDEXES_TAB_NAME, processedClassIndexesScrollPane);
        this._classIndexesTabbedPane.setPreferredSize(new Dimension(1000, 500));
        this._classIndexesTabbedPane.setBorder(null);
        classIndexesBox.add(this._classIndexesTabbedPane);
        classIndexesBox.add(Box.createHorizontalStrut(3));
        classIndexesBox.add(classIndexesButtonsBox);
        this.checkBoxesPanel.add((Component)this.fifoModeCB, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.checkBoxesPanel.add((Component)this.fifoModeLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.checkBoxesPanel.add((Component)this.replicationModeCB, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 10, 2, 2), 0, 0));
        this.checkBoxesPanel.add((Component)this.replicationModeLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.checkBoxesPanel.add((Component)this.idPropertyFieldNameLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 20, 2, 2), 0, 0));
        this.checkBoxesPanel.add((Component)this.idPropertyFieldLabel, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.idPropertyFieldLabel.setPreferredSize(new Dimension(155, 20));
        this.idPropertyFieldLabel.setFont(this.idPropertyFieldLabel.getFont().deriveFont(1));
        this.checkBoxesPanel.add((Component)this.routingFieldNameLabel, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 40, 2, 2), 0, 0));
        this.checkBoxesPanel.add((Component)this.routingFieldLabel, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.routingFieldLabel.setPreferredSize(new Dimension(155, 20));
        this.routingFieldLabel.setFont(this.routingFieldLabel.getFont().deriveFont(1));
        this.checkBoxesPanel.add((Component)this.blobStoreEnabledCB, new GridBagConstraints(8, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 10, 2, 2), 0, 0));
        this.checkBoxesPanel.add((Component)this.blobStoreEnabledLabel, new GridBagConstraints(9, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
    }

    protected void addProcessesIndexesMap(SpaceIndex[] spaceIndexes) {
        Map<String, ProcessIndexWrapper> processedIndexesMap;
        Map<String, Map<String, ProcessIndexWrapper>> map = this._processedIndexes.get(this._spaceProxy);
        if (map == null) {
            map = new HashMap<String, Map<String, ProcessIndexWrapper>>();
            this._processedIndexes.put(this._spaceProxy, map);
        }
        if ((processedIndexesMap = map.get(this._typeName)) == null) {
            processedIndexesMap = new HashMap<String, ProcessIndexWrapper>();
            map.put(this._typeName, processedIndexesMap);
        }
        for (SpaceIndex spaceIndex : spaceIndexes) {
            ProcessIndexWrapper wrapper = new ProcessIndexWrapper(spaceIndex, ProcessClassIndexIndication.PROGRESS);
            processedIndexesMap.put(spaceIndex.getName(), wrapper);
        }
    }

    public void refresh() {
        block3: {
            try {
                this.clear(true);
                if (this._basicTypeInfo != null) {
                    this.refreshBasicTypeInfoProperties();
                    this.buildClassPropertiesDataTable(this.classPropertiesColumnNames.length);
                    this.refreshClassIndexes();
                }
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.SEVERE)) break block3;
                _logger.log(Level.SEVERE, ex.toString(), ex);
            }
        }
    }

    private void refreshBasicTypeInfoProperties() {
        SpaceConfig spaceConfig;
        boolean blobStoreEnabled;
        block2: {
            this.classNameTF.setText(this._basicTypeInfo.getTypeName());
            this.superClassesListTF.setText(ClassPropertiesPanel.getSuperClasses(this._basicTypeInfo.getSuperClassesNames()));
            this.fifoModeCB.setSelected(this._basicTypeInfo.isFifoSupported());
            this.replicationModeCB.setSelected(this._basicTypeInfo.isReplicable());
            String id = this._basicTypeInfo.getIdPropertyName();
            id = id == null ? "" : id;
            String routingPropertyName = this._basicTypeInfo.getRoutingPropertyName();
            routingPropertyName = routingPropertyName == null ? "" : routingPropertyName;
            blobStoreEnabled = this._basicTypeInfo.isBlobstoreEnabled();
            this.routingFieldLabel.setText(routingPropertyName);
            this.idPropertyFieldLabel.setText(id);
            spaceConfig = null;
            try {
                spaceConfig = Repository.addSpaceConfigToMap((IRemoteJSpaceAdmin)this._spaceAdmin);
            }
            catch (RemoteException e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block2;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
        int cachePolicy = spaceConfig != null ? Integer.parseInt(spaceConfig.getCachePolicy()) : -1;
        this.blobStoreEnabledCB.setSelected(cachePolicy == 3 && blobStoreEnabled);
    }

    private void buildClassPropertiesDataTable(int columnNumber) {
        Object[] data = new Object[columnNumber];
        int numOfProperties = this._basicTypeInfo.getNumOfFixedProperties();
        this._curClassProperties = new String[numOfProperties];
        for (int numRow = 0; numRow < numOfProperties; ++numRow) {
            PropertyInfo property = this._basicTypeInfo.getFixedProperty(numRow);
            data[0] = property.getName();
            data[1] = property.getTypeName();
            this._curClassProperties[numRow] = property.getName();
            StorageType storageType = property.getStorageType();
            data[2] = storageType == null ? "" : storageType.name();
            this._curClassProperties[numRow] = property.getName();
            this.classPropertiesTableModel.addRow(data);
            if (this._addIndexButton.isEnabled()) continue;
            this._addIndexButton.setEnabled(true);
        }
    }

    private void buildClassIndexesDataTable(ITypeDesc typeDesc) {
        this.clearCompletedClassIndexes(typeDesc);
        for (SpaceIndex spaceIndex : typeDesc.getIndexes().values()) {
            IndexWrapper indexWrapper = new IndexWrapper(spaceIndex.getName(), spaceIndex.getIndexType());
            this.classIndexesTableModel.addWrapper(indexWrapper);
        }
    }

    private static String getSuperClasses(String[] superClasses) {
        StringBuilder superClassesList = new StringBuilder();
        for (int i = 1; i < superClasses.length; ++i) {
            superClassesList.append(superClasses[i]);
            if (i == superClasses.length - 1) continue;
            superClassesList.append("  ;  ");
        }
        return superClassesList.toString();
    }

    public void clear(boolean isClearOnlyComponents) {
        if (!isClearOnlyComponents) {
            this._spaceProxy = null;
            this._spaceAdmin = null;
            this._typeName = null;
            this._basicTypeInfo = null;
        }
        this.classPropertiesTableModel.clear();
        this.processedClassIndexesTableModel.clear();
        this._addIndexButton.setEnabled(false);
        this.classNameTF.setText("");
        this.superClassesListTF.setText("");
        this.fifoModeCB.setSelected(false);
        this.replicationModeCB.setSelected(false);
        this.routingFieldLabel.setText("");
        this.idPropertyFieldLabel.setText("");
        this.blobStoreEnabledCB.setSelected(false);
        this.classIndexesTableModel.clear();
    }

    public String getTypeName() {
        return this._typeName;
    }

    public void setBasicTypeInfo(String typeName, ISpaceProxy spaceProxy, IInternalRemoteJSpaceAdmin spaceAdmin, ITypeDesc basicTypeInfo) {
        boolean isSpaceChanged = this._spaceProxy == null && spaceProxy != null || !this._spaceProxy.equals(spaceProxy);
        boolean isTypeNameChanged = this._typeName == null && typeName != null || !this._typeName.equals(typeName);
        this._spaceProxy = spaceProxy;
        this._spaceAdmin = spaceAdmin;
        this._basicTypeInfo = basicTypeInfo;
        this._typeName = typeName;
        if (isSpaceChanged) {
            this.refresh();
        } else {
            this.refreshClassIndexes();
            if (isTypeNameChanged) {
                this.refreshBasicTypeInfoProperties();
                this.classPropertiesTableModel.clear();
                this.classIndexesTableModel.clear();
                this.processedClassIndexesTableModel.clear();
                this.buildClassPropertiesDataTable(this.classPropertiesColumnNames.length);
            }
        }
    }

    public void refreshClassIndexes() {
        if (this._basicTypeInfo != null) {
            this.buildClassIndexesDataTable(this._basicTypeInfo);
            this.refreshProcessedClassIndexes();
        }
    }

    private void clearCompletedClassIndexes(ITypeDesc typeDesc) {
        Map<String, ProcessIndexWrapper> processedIndexesMap;
        Map<String, Map<String, ProcessIndexWrapper>> map = this._processedIndexes.get(this._spaceProxy);
        if (map != null && (processedIndexesMap = map.get(this._typeName)) != null && processedIndexesMap.size() > 0) {
            for (SpaceIndex spaceIndex : typeDesc.getIndexes().values()) {
                ProcessIndexWrapper removedWrapper = processedIndexesMap.remove(spaceIndex.getName());
                if (removedWrapper == null || removedWrapper.getIndexTableWrapper() == null) continue;
                this.processedClassIndexesTableModel.removeWrapper(removedWrapper.getIndexTableWrapper());
            }
        }
    }

    private void refreshProcessedClassIndexes() {
        this.buildProcessedClassIndexesDataTable();
    }

    private void buildProcessedClassIndexesDataTable() {
        Map<String, ProcessIndexWrapper> processedIndexesMap;
        Map<String, Map<String, ProcessIndexWrapper>> map = this._processedIndexes.get(this._spaceProxy);
        if (map != null && (processedIndexesMap = map.get(this._typeName)) != null) {
            for (ProcessIndexWrapper processIndexWrapper : processedIndexesMap.values()) {
                this.addProcessIndexRow(processIndexWrapper);
            }
        }
    }

    private void addProcessIndexRow(ProcessIndexWrapper processIndexWrapper) {
        ProcessClassIndexIndication indication = processIndexWrapper.getIndication();
        SpaceIndex spaceIndex = processIndexWrapper.getSpaceIndex();
        SpaceIndexType indexType = spaceIndex.getIndexType();
        String name = spaceIndex.getName();
        String indicationDescr = indication.equals((Object)ProcessClassIndexIndication.PROGRESS) ? this.IN_PROGRESS_INDICATION : this.FAILED_INDICATION;
        IndexWrapper indexWrapper = new IndexWrapper(name, indexType, indicationDescr);
        this.processedClassIndexesTableModel.addWrapper(indexWrapper);
        processIndexWrapper.setIndexTableWrapper(indexWrapper);
    }

    @Override
    public void updateRuntimeDetails() {
        block2: {
            try {
                this._basicTypeInfo = this._spaceAdmin.getClassDescriptor(this._typeName);
                this.refreshClassIndexes();
                this.refreshProcessedClassIndexes();
            }
            catch (RemoteException re) {
                if (!_logger.isLoggable(Level.SEVERE)) break block2;
                _logger.log(Level.SEVERE, re.toString(), re);
            }
        }
    }

    @Override
    public boolean shouldRefresh() {
        return !this._spaceRuntimePanel.isRunning() && this._spaceRuntimePanel.isInvokeRefresh() && this._spaceAdmin != null && this._spaceProxy != null && this._typeName != null;
    }

    @Override
    public Logger getLogger() {
        return _logger;
    }

    private class ProcessIndexWrapper {
        private ProcessClassIndexIndication _indication;
        private SpaceIndex _spaceIndex;
        private IndexWrapper _indexTableWrapper;

        ProcessIndexWrapper(SpaceIndex spaceIndex, ProcessClassIndexIndication indication) {
            this._spaceIndex = spaceIndex;
            this._indication = indication;
        }

        public void failed() {
            this._indication = ProcessClassIndexIndication.FAILED;
        }

        public SpaceIndex getSpaceIndex() {
            return this._spaceIndex;
        }

        public ProcessClassIndexIndication getIndication() {
            return this._indication;
        }

        public void setIndexTableWrapper(IndexWrapper indexWrapper) {
            this._indexTableWrapper = indexWrapper;
        }

        public IndexWrapper getIndexTableWrapper() {
            return this._indexTableWrapper;
        }
    }

    private static enum ProcessClassIndexIndication {
        PROGRESS,
        FAILED;

    }

    private class IndexWrapper
    extends BasicWrapper {
        private final String _indexName;
        private final SpaceIndexType _indexType;
        private final String _indication;

        IndexWrapper(String indexName, SpaceIndexType indexType) {
            this(indexName, indexType, null);
        }

        IndexWrapper(String indexName, SpaceIndexType indexType, String indication) {
            this._indexName = indexName;
            this._indexType = indexType;
            this._indication = indication;
        }

        public String getIndexName() {
            return this._indexName;
        }

        public SpaceIndexType getIndexType() {
            return this._indexType;
        }

        public String getIndication() {
            return this._indication;
        }

        @Override
        public boolean compareRuntimeDetails(BasicWrapper wrapper) {
            return false;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this._indexName == null ? 0 : this._indexName.hashCode());
            result = 31 * result + (this._indexType == null ? 0 : this._indexType.hashCode());
            result = 31 * result + (this._indication == null ? 0 : this._indication.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IndexWrapper other = (IndexWrapper)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this._indexName == null ? other._indexName != null : !this._indexName.equals(other._indexName)) {
                return false;
            }
            if (this._indexType != other._indexType) {
                return false;
            }
            return !(this._indication == null ? other._indication != null : !this._indication.equals(other._indication));
        }

        private ClassPropertiesPanel getOuterType() {
            return ClassPropertiesPanel.this;
        }
    }

    private class AsyncFutureListenerImpl
    implements AsyncFutureListener<AddTypeIndexesResult> {
        private ISpaceProxy _spaceProxy;
        private String _typeName;

        public AsyncFutureListenerImpl(ISpaceProxy spaceProxy, String typeName) {
            this._spaceProxy = spaceProxy;
            this._typeName = typeName;
        }

        public void onResult(AsyncResult<AddTypeIndexesResult> result) {
            Map processedIndexesMap;
            Map map;
            Exception exception = result.getException();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("RESULT:" + result.toString() + " ,exceptuion:" + result.getException() + " ,result:" + result.getResult());
            }
            if ((map = (Map)ClassPropertiesPanel.this._processedIndexes.get(this._spaceProxy)) != null && (processedIndexesMap = (Map)map.get(this._typeName)) != null) {
                for (ProcessIndexWrapper processIndexWrapper : processedIndexesMap.values()) {
                    if (exception == null) continue;
                    _logger.info("set faild indication to wrapper");
                    processIndexWrapper.failed();
                }
            }
        }
    }

    private class ProcessedIndexesCellRenderer
    extends DefaultTableCellRenderer {
        private ProcessedIndexesCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String val = value.toString();
            if (val.trim().length() > 0) {
                ImageIcon icon = val.equals(ClassPropertiesPanel.this.IN_PROGRESS_INDICATION) ? ClassPropertiesPanel.this._progressIcon : ClassPropertiesPanel.this._failedIcon;
                this.setIcon(icon);
            }
            return this;
        }
    }

    class ClassIndexesTableModel
    extends BasicSortableTableModel {
        public ClassIndexesTableModel(String[] columnNames) {
            this.columnNames = columnNames;
        }

        @Override
        protected void initColumnNames() {
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public Object getCellValue(BasicWrapper basicWrapper, int column) {
            IndexWrapper indexWrapper = (IndexWrapper)basicWrapper;
            switch (column) {
                case 0: {
                    return indexWrapper.getIndexName();
                }
                case 1: {
                    return indexWrapper.getIndexType();
                }
                case 2: {
                    return indexWrapper.getIndication();
                }
            }
            return null;
        }

        @Override
        protected int compareWrappers(BasicWrapper wrapper1, BasicWrapper wrapper2, int colIndex, boolean ascending) {
            IndexWrapper indexWrapper1 = (IndexWrapper)wrapper1;
            IndexWrapper indexWrapper2 = (IndexWrapper)wrapper2;
            switch (colIndex) {
                case 0: {
                    String indexName1 = indexWrapper1.getIndexName();
                    String indexName2 = indexWrapper2.getIndexName();
                    if (ascending) {
                        return indexName1.compareToIgnoreCase(indexName2);
                    }
                    return indexName2.compareToIgnoreCase(indexName1);
                }
                case 1: {
                    SpaceIndexType indexType1 = indexWrapper1.getIndexType();
                    SpaceIndexType indexType2 = indexWrapper2.getIndexType();
                    if (ascending) {
                        return indexType1.name().compareToIgnoreCase(indexType2.name());
                    }
                    return indexType2.name().compareToIgnoreCase(indexType1.name());
                }
                case 2: {
                    String indexIndication1 = indexWrapper1.getIndexName();
                    String indexIndication2 = indexWrapper2.getIndexName();
                    if (ascending) {
                        return indexIndication1.compareToIgnoreCase(indexIndication2);
                    }
                    return indexIndication2.compareToIgnoreCase(indexIndication1);
                }
            }
            return 0;
        }
    }

    class ClassPropertiesTableModel
    extends DefaultTableModel {
        public ClassPropertiesTableModel(String[] columnNames) {
            super(columnNames, 0);
        }

        public void clear() {
            int vSize = this.dataVector.size();
            this.dataVector.clear();
            if (vSize > 0) {
                this.fireTableRowsDeleted(0, vSize - 1);
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row < this.dataVector.size()) {
                return super.getValueAt(row, column);
            }
            return "";
        }
    }
}

