/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.grid.space.SearchEditor;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.lrmi.TransportProtocolHelper;
import com.gigaspaces.management.transport.TransportConstants;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.IJSpaceContainer;
import com.j_spaces.core.admin.ContainerConfig;
import com.j_spaces.core.admin.IJSpaceContainerAdmin;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.tools.cluster.view.ServiceManagerImpl;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.SpaceConnectionsPanel;
import com.j_spaces.tools.spacebrowser.utils.IndicationBox;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.swing.Box;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ClusterConnectionsPanel
extends SpaceConnectionsPanel {
    private String _curClusterName;
    private ServiceManagerImpl _serviceManagerImpl;
    private static final int CI_CLUSTER_CONNECT_MEMBER_NAME = 0;
    private static final int CI_CLUSTER_CONNECT_SERVER_IP_ADDRESS = 1;
    private static final int CI_CLUSTER_CONNECT_SERVER_PORT = 2;
    private static final int CI_CLUSTER_CONNECT_CLIENT_IP_ADDRESS = 3;
    private static final int CI_CLUSTER_CONNECT_CLIENT_PORT = 4;
    private static final int CI_CLUSTER_CONNECT_START_TIME = 5;
    private static final int CI_CLUSTER_CONNECT_DISCONNNECTION_TIME = 6;

    public ClusterConnectionsPanel(SpaceBrowser spaceBrowser, ServiceManagerImpl serviceManagerImpl) {
        super(spaceBrowser);
        this._serviceManagerImpl = serviceManagerImpl;
        this.refreshPanel.setSelectedRefreshRate(5000);
    }

    @Override
    protected void initTableAndTableModel() {
        this._connectionsTableModel = new ClusterConnectionsTableModel();
        this._connectionsTable = new JTable(this._connectionsTableModel);
        this._searchEditor = new SearchEditor(this._connectionsTableModel);
    }

    public void setCurrentClusterName(String clusterName) {
        if (this._curClusterName != null && !this._curClusterName.equals(clusterName)) {
            this._connectionsTableModel.clearModel();
        }
        this._curClusterName = clusterName;
        this._indicationBox.setVisible(false);
        this._connectionsTableModel.refresh();
    }

    @Override
    protected void setTableColumnSettings() {
        TableColumnModel tableColumnModel = this._connectionsTable.getColumnModel();
        TableColumn clustermemberNameTableColumn = tableColumnModel.getColumn(0);
        TableColumn serverIPAddressTableColumn = tableColumnModel.getColumn(1);
        TableColumn serverPortTableColumn = tableColumnModel.getColumn(2);
        TableColumn clientIPAddressTableColumn = tableColumnModel.getColumn(3);
        TableColumn clientPortTableColumn = tableColumnModel.getColumn(4);
        int portNumCoulmnWidth = 65;
        clientPortTableColumn.setPreferredWidth(65);
        serverPortTableColumn.setPreferredWidth(65);
        int ipAddressColumnNum = 110;
        serverIPAddressTableColumn.setPreferredWidth(110);
        clientIPAddressTableColumn.setPreferredWidth(110);
        clustermemberNameTableColumn.setPreferredWidth(170);
        SpaceConnectionsPanel.TransportConnectionTableCellRenderer cellRenderer = new SpaceConnectionsPanel.TransportConnectionTableCellRenderer(this);
        int columnCount = tableColumnModel.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            tableColumnModel.getColumn(i).setCellRenderer(cellRenderer);
        }
    }

    @Override
    protected void createIndicationBox() {
        this._indicationBox = new IndicationBox("Connections can't be displayed for cluster members with JMX support disabled", 1);
    }

    @Override
    protected Box createServerConnectionBox() {
        Box serverConnectionsBox = new Box(0);
        this.createCleanButton();
        serverConnectionsBox.add(Box.createHorizontalGlue());
        serverConnectionsBox.add(this.cleanDisconnectionsButton);
        serverConnectionsBox.add(Box.createHorizontalStrut(20));
        serverConnectionsBox.add(this._searchEditor);
        serverConnectionsBox.add(Box.createHorizontalStrut(2));
        this.addActionListenerToCleanButton();
        return serverConnectionsBox;
    }

    protected class ClusterConnectionsTableModel
    extends SpaceConnectionsPanel.ConnectionsTableModel {
        protected ClusterConnectionsTableModel() {
            super(ClusterConnectionsPanel.this);
        }

        @Override
        protected void initColumnNames() {
            this.columnNames = new String[7];
            this.columnNames[0] = "Cluster Member Name";
            this.columnNames[1] = "Source space IP Address";
            this.columnNames[2] = "Source space Port";
            this.columnNames[3] = "Destination client IP Address";
            this.columnNames[4] = "Destination client Port";
            this.columnNames[5] = "Start Time";
            this.columnNames[6] = "Disconnection Time";
        }

        @Override
        protected boolean isDisplayConnection(SpaceConnectionsPanel.TransportConnectionWrapper wrapper) {
            return wrapper.getClientIPAddress().startsWith(this._searchedText) || String.valueOf(wrapper.getClientPort()).startsWith(this._searchedText) || String.valueOf(wrapper.getServerPort()).startsWith(this._searchedText) || String.valueOf(wrapper.getMemberName()).toUpperCase().startsWith(this._searchedText.toUpperCase());
        }

        @Override
        public Object getCellValue(SpaceConnectionsPanel.TransportConnectionWrapper transportWrapper, int column, boolean isFormatDate) {
            switch (column) {
                case 0: {
                    return transportWrapper.getMemberName();
                }
                case 1: {
                    return transportWrapper.getServerIPAddress();
                }
                case 2: {
                    return transportWrapper.getServerPort();
                }
                case 3: {
                    return transportWrapper.getClientIPAddress();
                }
                case 4: {
                    return transportWrapper.getClientPort();
                }
                case 5: {
                    if (isFormatDate) {
                        return this.df.format(transportWrapper.getConnectTime());
                    }
                    return transportWrapper.getConnectTime();
                }
                case 6: {
                    Date disconnectionTime = transportWrapper.getDisconnectionTime();
                    if (!isFormatDate) {
                        return disconnectionTime;
                    }
                    if (disconnectionTime == null) {
                        return "";
                    }
                    return this.df.format(disconnectionTime);
                }
            }
            return "";
        }

        private void selectWrapper(SpaceConnectionsPanel.TransportConnectionWrapper selTransportConnectionWrapper) {
            int selIndex;
            if (selTransportConnectionWrapper != null && (selIndex = ClusterConnectionsPanel.this._connectionsTableModel.getWrapperIndex(selTransportConnectionWrapper)) >= 0) {
                ClusterConnectionsPanel.this._connectionsTable.setRowSelectionInterval(selIndex, selIndex);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ClusterConnectionsPanel.this._connectionsTable.scrollRectToVisible(ClusterConnectionsPanel.this._connectionsTable.getCellRect(selIndex, 0, true));
                    }
                });
            }
        }

        @Override
        public void refresh() {
            if (this._isRefreshInvoke) {
                ServiceManagerImpl.ClusterMember[] clusterMembersArray = ClusterConnectionsPanel.this._serviceManagerImpl.getClusterMembers(ClusterConnectionsPanel.this._curClusterName, true);
                int selRow = ClusterConnectionsPanel.this._connectionsTable.getSelectedRow();
                SpaceConnectionsPanel.TransportConnectionWrapper selTransportConnectionWrapper = null;
                if (selRow >= 0) {
                    selTransportConnectionWrapper = ClusterConnectionsPanel.this._connectionsTableModel.getWrapperAt(selRow);
                }
                ArrayList<SpaceConnectionsPanel.TransportConnectionWrapper> newConnectionWrapperslist = new ArrayList<SpaceConnectionsPanel.TransportConnectionWrapper>();
                try {
                    for (int i = 0; i < clusterMembersArray.length; ++i) {
                        ServiceManagerImpl.ClusterMember clusterMember = clusterMembersArray[i];
                        IJSpace spaceProxy = clusterMember.getRegularProxy();
                        IJSpaceContainer spaceContainer = spaceProxy.getDirectProxy().getContainer();
                        IJSpaceContainerAdmin spaceContainerAdmin = (IJSpaceContainerAdmin)spaceContainer;
                        String clusterMemberName = clusterMember.getClusterMemberName();
                        ContainerConfig containerConfig = Repository.addContainerToMap(spaceContainerAdmin);
                        if (containerConfig.isJMXEnabled()) {
                            IRemoteJSpaceAdmin remoteAdminSpace;
                            long remoteObjID;
                            MBeanServerConnection mBeanServerConnection = Repository.getMBeanServerConnection(spaceContainerAdmin);
                            if (mBeanServerConnection == null || (remoteObjID = TransportProtocolHelper.getRemoteObjID((Object)(remoteAdminSpace = (IRemoteJSpaceAdmin)((IDirectSpaceProxy)spaceProxy).getRemoteJSpace()))) <= 0L) continue;
                            String containerName = containerConfig.containerName;
                            ObjectName mBeanName = TransportConstants.createTransportMBeanObjectName((String)containerName);
                            ClusterConnectionsPanel.this.params[0] = new Long(remoteObjID);
                            this.retriveConnectionsAndAddToList(mBeanServerConnection, mBeanName, clusterMemberName, newConnectionWrapperslist);
                            continue;
                        }
                        ClusterConnectionsPanel.this._indicationBox.setVisible(true);
                    }
                    this.handleNewConnections(newConnectionWrapperslist, selTransportConnectionWrapper);
                }
                catch (RemoteException e) {
                    SpaceConnectionsPanel._logger.log(Level.FINE, e.toString(), e);
                }
                catch (Exception e) {
                    SpaceConnectionsPanel._logger.log(Level.SEVERE, e.toString(), e);
                }
            }
            this.updateCounts();
        }
    }
}

