/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.gigaspaces.admin.ui.AdminUIThreadPool;
import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.grid.UI;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.IInternalRemoteJSpaceAdmin;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.admin.SpaceRuntimeInfo;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.cluster.EditCluster;
import com.j_spaces.tools.cluster.view.ServiceManagerImpl;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.SpaceRuntimePanel;
import com.j_spaces.tools.spacebrowser.utils.ClusterUIUtils;
import com.j_spaces.tools.spacebrowser.utils.IndicationBox;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import net.jini.core.lookup.ServiceID;
import net.jini.space.InternalSpaceException;

public class ClusterSpaceRuntimePanel
extends SpaceRuntimePanel {
    private RuntimeSpaceWrapper[] _runtimeSpaceWrappersArray;
    private Map<String, RuntimeSpaceWrapper> _classNamesPerSpaceAdminMap;
    private final ServiceManagerImpl _serviceManagerImpl;
    private List<List<String>> _allReplicationGroups = new ArrayList<List<String>>();
    private String _curClusterName;
    private UI _uicomponent;

    public ClusterSpaceRuntimePanel(JFrame parentFrame, UI uicomponent, SpaceBrowser spaceBrowser, boolean isQueryExecutionEnabled, ServiceManagerImpl serviceManagerImpl) {
        super(parentFrame, spaceBrowser, isQueryExecutionEnabled);
        this._serviceManagerImpl = serviceManagerImpl;
        this._uicomponent = uicomponent;
        this.refreshPanel.setSelectedRefreshRate(5000);
    }

    public void setCurrentClusterDefinition(EditCluster editCluster) {
        this.clearRuntimeDialog();
        this.classPropertiesPanel.clear(false);
        this._allReplicationGroups = ClusterUIUtils.createReplicationsGroupsList(editCluster);
        if (this.refreshPanel.isStop()) {
            this.refreshPanel.setStartButtonEnabled(true);
        }
        this._curClusterName = editCluster.getClusterName();
        this.refresh();
    }

    @Override
    protected void createIndicationBox() {
        this._indicationBox = new IndicationBox("<HTML>Objects of one or more persistent LRU cluster spaces are not displayed. It can be changed by selecting <B>View > Display Persistent LRU Space Metrics</B> menu item</HTML>", 1);
    }

    @Override
    protected void refreshPropertiesTabPanel(int selectedRow) {
        String selectedClassName = (String)this.model.getValueAt(selectedRow, 0);
        RuntimeSpaceWrapper runtimeSpaceWrapper = this._classNamesPerSpaceAdminMap.get(selectedClassName);
        if (runtimeSpaceWrapper == null) {
            return;
        }
        IInternalRemoteJSpaceAdmin spaceAdmin = runtimeSpaceWrapper.getSpaceAdmin();
        ITypeDesc basicTypeInfo = null;
        try {
            basicTypeInfo = spaceAdmin.getClassDescriptor(selectedClassName);
        }
        catch (RemoteException exc) {
            _logger.log(Level.SEVERE, exc.toString(), exc);
        }
        if (this.classesPropsTab.getSelectedComponent().equals(this.templatesInfoPanel)) {
            try {
                List templatesInfoList = spaceAdmin.getTemplatesInfo(selectedClassName);
                this.templatesInfoPanel.displayTemplates(selectedClassName, basicTypeInfo, templatesInfoList);
            }
            catch (RemoteException exc) {
                _logger.log(Level.SEVERE, exc.toString(), exc);
            }
        }
        this.classPropertiesPanel.setBasicTypeInfo(selectedClassName, (ISpaceProxy)runtimeSpaceWrapper.getSpaceProxy(), spaceAdmin, basicTypeInfo);
    }

    @Override
    protected void queryRow() {
        try {
            int selRow = this.table.getSelectedRow();
            String querysSTR = "select uid,* from " + this.model.getValueAt(selRow, 0);
            if (this._uicomponent != null) {
                ServiceID spaceID = JSpaceUtilities.getSpaceServiceID((IJSpace)this._runtimeSpaceWrappersArray[0].getSpaceProxy());
                this._uicomponent.selectClusterOperationNode(spaceID, "Query", this._curClusterName);
                this._uicomponent.selectClusterSQLQueryPanel(this._curClusterName, querysSTR);
            } else {
                this.m_spaceBrowser.selectClusterOperationNode(this._curClusterName, "Query");
                this.m_spaceBrowser.selectClusterSQLQueryPanel(this._curClusterName, querysSTR);
            }
        }
        catch (Exception e) {
            SpaceBrowser.showException("Query", e);
        }
    }

    @Override
    protected void deleteRow() {
        try {
            String clazz = this.model.getValueAt(this.table.getSelectedRow(), 0).toString();
            String question = "<HTML><B>Are you sure you want to delete <FONT color=\"blue\">" + clazz + "</FONT><BR>definition and all its instances from all cluster members of <FONT color=\"green\">" + this._curClusterName + "</FONT> cluster?</B><FONT color=\"red\"><BR>Notice deleting a class definition will not trigger any notification and therefore<BR>any connected LocalView and LocalCache might get into inconsistent state.<BR>Consider using Clear instead.</FONT></HTML>";
            int pressed = JOptionPane.showConfirmDialog(this._parentFrame, question, "Delete", 0, 2);
            if (pressed == 0) {
                IJSpace[] spaces;
                for (IJSpace spaceProxy : spaces = ClusterUIUtils.getAllClusterSpacesExceptMirror(this._serviceManagerImpl, this._curClusterName, this._allReplicationGroups)) {
                    spaceProxy.dropClass(clazz);
                }
                int selRow = this.table.getSelectedRow();
                if (selRow >= 0) {
                    this.model.removeRow(selRow);
                    this.classPropertiesPanel.clear(false);
                    this.setControlEnabled(false);
                }
            }
        }
        catch (Exception e) {
            SpaceBrowser.showException("Deleting class", e);
        }
    }

    @Override
    protected void clearRow() {
        try {
            String clazz = this.model.getValueAt(this.table.getSelectedRow(), 0).toString();
            String clusteredSpaceQuestion = "All " + clazz + " instances will be\nremoved from all cluster members of \"" + this._curClusterName + "\" cluster.\nAre you sure you want to clean this class from cluster?";
            int returnVal = JOptionPane.showConfirmDialog(this._parentFrame, clusteredSpaceQuestion, "Clean", 0, 2);
            if (returnVal == 0) {
                for (int i = 0; i < this._runtimeSpaceWrappersArray.length; ++i) {
                    IJSpace spaceProxy = this._runtimeSpaceWrappersArray[i].getSpaceProxy();
                    this.clearSpace(spaceProxy, clazz);
                }
            }
        }
        catch (Exception e) {
            SpaceBrowser.showException("Cleaning class", e);
        }
    }

    private void setClusterSpaces(IJSpace[] spaceProxiesArray) {
        block4: {
            if (spaceProxiesArray == null || spaceProxiesArray.length == 0) {
                this._runtimeSpaceWrappersArray = null;
                return;
            }
            this._runtimeSpaceWrappersArray = new RuntimeSpaceWrapper[spaceProxiesArray.length];
            try {
                for (int i = 0; i < spaceProxiesArray.length; ++i) {
                    IJSpace space = spaceProxiesArray[i];
                    IInternalRemoteJSpaceAdmin spaceAdmin = (IInternalRemoteJSpaceAdmin)Repository.addSpaceAdminObjectToMap(space);
                    SpaceConfig spaceConfig = Repository.addSpaceConfigToMap((IRemoteJSpaceAdmin)spaceAdmin);
                    boolean isPersistentLRUSpace = spaceConfig.isPersistent() && spaceConfig.getCachePolicy().equals(String.valueOf(0));
                    this._runtimeSpaceWrappersArray[i] = new RuntimeSpaceWrapper(space, spaceAdmin, isPersistentLRUSpace);
                    if (i != 0) continue;
                    ServiceID serviceID = JSpaceUtilities.getSpaceServiceID((IJSpace)space);
                    this.updateSecuredOperationsState(space, serviceID);
                }
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block4;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    @Override
    public void refresh() {
        if (!this._isInvokeRefresh) {
            this._infoBox.setCount(this.model.getRowCount());
            return;
        }
        this.setClusterSpaces(ClusterUIUtils.getClusterSpacesForStatisticsCalculation(this._serviceManagerImpl, this._curClusterName, this._allReplicationGroups));
        if (this._runtimeSpaceWrappersArray != null && (this.refreshThreadTask == null || this.refreshThreadTask.isDone())) {
            this.refreshThreadTask = AdminUIThreadPool.getThreadPool().submit(new Runnable(){

                @Override
                public void run() {
                    block13: {
                        try {
                            ClusterSpaceRuntimePanel.this._indicationBox.setVisible(false);
                            boolean isIndicationPanelVisible = false;
                            SpaceRuntimeInfo spaceRuntimeInfo = null;
                            ClusterSpaceRuntimePanel.this._classNamesPerSpaceAdminMap = new HashMap();
                            for (int i = 0; i < ClusterSpaceRuntimePanel.this._runtimeSpaceWrappersArray.length; ++i) {
                                if (!ClusterSpaceRuntimePanel.this._runtimeSpaceWrappersArray[i].isPersistentLRUSpace() || ClusterSpaceRuntimePanel.this.m_spaceBrowser.isRetrieveRuntimeForPersistentLRUSpace()) {
                                    IInternalRemoteJSpaceAdmin spaceAdmin = ClusterSpaceRuntimePanel.this._runtimeSpaceWrappersArray[i].getSpaceAdmin();
                                    SpaceRuntimeInfo runtimeInfo = spaceAdmin.getRuntimeInfo();
                                    int classesAmount = runtimeInfo.m_ClassNames.size();
                                    for (int classesIndex = 0; classesIndex < classesAmount; ++classesIndex) {
                                        String className = (String)runtimeInfo.m_ClassNames.get(classesIndex);
                                        if (ClusterSpaceRuntimePanel.this._classNamesPerSpaceAdminMap.containsKey(className)) continue;
                                        ClusterSpaceRuntimePanel.this._classNamesPerSpaceAdminMap.put(className, ClusterSpaceRuntimePanel.this._runtimeSpaceWrappersArray[i]);
                                    }
                                    spaceRuntimeInfo = runtimeInfo.appendSpaceRuntimeInfo(spaceRuntimeInfo);
                                    continue;
                                }
                                isIndicationPanelVisible = true;
                            }
                            if (spaceRuntimeInfo != null) {
                                ClusterSpaceRuntimePanel.this.updateRuntimeTable(spaceRuntimeInfo);
                            } else {
                                ClusterSpaceRuntimePanel.this.clearRuntimeDialog();
                                ClusterSpaceRuntimePanel.this.classPropertiesPanel.clear(true);
                                ClusterSpaceRuntimePanel.this.setControlEnabled(false);
                            }
                            if (!ClusterSpaceRuntimePanel.this._indicationBox.isVisible() && isIndicationPanelVisible) {
                                ClusterSpaceRuntimePanel.this._indicationBox.setVisible(true);
                            }
                        }
                        catch (UnmarshalException ex) {
                            ClusterSpaceRuntimePanel.this.stopStatusRuntime();
                            if (ClusterSpaceRuntimePanel.this.m_spaceBrowser != null) {
                                ClusterSpaceRuntimePanel.this.m_spaceBrowser.conTree.repaint();
                                SpaceBrowser.showException("getting runtime information", ex);
                            }
                        }
                        catch (RemoteException ex) {
                            ClusterSpaceRuntimePanel.this.stopStatusRuntime();
                            if (ClusterSpaceRuntimePanel.this.m_spaceBrowser != null) {
                                ClusterSpaceRuntimePanel.this.m_spaceBrowser.conTree.repaint();
                                ClusterSpaceRuntimePanel.this.m_spaceBrowser.showStatus("Lost connection with space.");
                            }
                        }
                        catch (InternalSpaceException ex) {
                            ClusterSpaceRuntimePanel.this.stopStatusRuntime();
                            if (ClusterSpaceRuntimePanel.this.m_spaceBrowser == null) break block13;
                            ClusterSpaceRuntimePanel.this.m_spaceBrowser.showStatus("InternalSpaceError: " + ex.getMessage());
                            if (!SpaceRuntimePanel._logger.isLoggable(Level.FINE)) break block13;
                            SpaceRuntimePanel._logger.log(Level.FINE, ex.toString(), ex);
                        }
                    }
                    if (SpaceRuntimePanel._logger.isLoggable(Level.FINEST)) {
                        long time5 = System.currentTimeMillis();
                        SpaceRuntimePanel._logger.finest("> TIME6:" + time5);
                    }
                    ClusterSpaceRuntimePanel.this._infoBox.setCount(ClusterSpaceRuntimePanel.this.model.getRowCount());
                }
            });
        }
    }

    public class RuntimeSpaceWrapper {
        private final IJSpace _spaceProxy;
        private final IInternalRemoteJSpaceAdmin _spaceAdmin;
        private final boolean _isPersistentLRUSpace;

        public RuntimeSpaceWrapper(IJSpace spaceProxy, IInternalRemoteJSpaceAdmin spaceAdmin) {
            this(spaceProxy, spaceAdmin, false);
        }

        public RuntimeSpaceWrapper(IJSpace spaceProxy, IInternalRemoteJSpaceAdmin spaceAdmin, boolean isPersistentLRUSpace) {
            this._spaceProxy = spaceProxy;
            this._spaceAdmin = spaceAdmin;
            this._isPersistentLRUSpace = isPersistentLRUSpace;
        }

        public boolean isPersistentLRUSpace() {
            return this._isPersistentLRUSpace;
        }

        public IInternalRemoteJSpaceAdmin getSpaceAdmin() {
            return this._spaceAdmin;
        }

        public IJSpace getSpaceProxy() {
            return this._spaceProxy;
        }
    }
}

