/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.gigaspaces.admin.ui.grid.Repository;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.ContainerConfig;
import com.j_spaces.core.admin.IJSpaceContainerAdmin;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.cluster.view.ServiceManagerImpl;
import com.j_spaces.tools.spacebrowser.ISpacesView;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.SpacesViewPanel;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;

public class ClusterSpacesViewPanel
extends SpacesViewPanel {
    private String _clusterName;
    private ServiceManagerImpl _serviceManagerImpl;
    private static final Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");
    private static List<String> _spacesViewColumnNames;

    public ClusterSpacesViewPanel(JFrame parentFrame) {
        super(parentFrame);
    }

    public void setClusterName(String clusterName, ServiceManagerImpl serviceManagerImpl) {
        this._serviceManagerImpl = serviceManagerImpl;
        if (this._clusterName == null) {
            this.setColumnNames(_spacesViewColumnNames);
        }
        if (this._clusterName == null || !this._clusterName.equals(clusterName)) {
            this._clusterName = clusterName;
        }
        this.refreshClusterSpaces();
    }

    public SpacesViewPanel.SpaceViewWrapper getWrapperAt(int row) {
        return this._spacesViewTableModel.getWrapperAt(row);
    }

    public int getSpacesCount() {
        return this._spacesViewTableModel.getRowCount();
    }

    public void refreshClusterSpaces() {
        this.clear();
        List<SpacesViewPanel.SpaceViewWrapper> allSpacesList = SpaceBrowser.getInstance().getAllSpaces();
        for (SpacesViewPanel.SpaceViewWrapper spaceViewWrapper : allSpacesList) {
            String spaceName;
            String containerName;
            String clusterMemberName;
            if (spaceViewWrapper.isClustered()) {
                String clusterName = spaceViewWrapper.getSpaceConfig().getClusterInfo().getClusterName();
                if (!clusterName.equals(this._clusterName)) continue;
                this.addSpace(spaceViewWrapper);
                continue;
            }
            if (!spaceViewWrapper.getSpaceConfig().isMirrorServiceEnabled() || this._serviceManagerImpl.getClusterMember(clusterMemberName = JSpaceUtilities.createFullSpaceName((String)(containerName = spaceViewWrapper.getContainerName()), (String)(spaceName = spaceViewWrapper.getSpaceName()))) == null) continue;
            this.addSpace(spaceViewWrapper);
        }
    }

    private void addSpace(SpacesViewPanel.SpaceViewWrapper spaceViewWrapper) {
        IJSpace space = spaceViewWrapper.getSpaceProxy();
        IRemoteJSpaceAdmin spaceAdmin = spaceViewWrapper.getSpaceAdmin();
        ServiceID spaceID = spaceViewWrapper.getServiceID();
        SpaceConfig spaceConfig = spaceViewWrapper.getSpaceConfig();
        ContainerConfig containerConfig = spaceViewWrapper.getContainerConfig();
        boolean isSecuredSpace = spaceViewWrapper.isSecuredSpace();
        this.addSpace(space, spaceAdmin, spaceID, spaceConfig, containerConfig, isSecuredSpace);
    }

    @Override
    public void removeSpace(ServiceID spaceID) {
        super.removeSpace(spaceID);
    }

    public void spaceAdded(ServiceItem item) {
        block9: {
            String clusterName = JSpaceUtilities.retriveClusterName((Entry[])item.attributeSets);
            if (this._clusterName != null && this._clusterName.equals(clusterName)) {
                IJSpace space = (IJSpace)item.service;
                IJSpaceContainerAdmin containerAdmin = (IJSpaceContainerAdmin)space.getDirectProxy().getContainer();
                try {
                    ContainerConfig containerConfig = Repository.addContainerToMap(containerAdmin);
                    IRemoteJSpaceAdmin spaceAdmin = Repository.addSpaceAdminObjectToMap(space);
                    SpaceConfig spaceConfig = Repository.addSpaceConfigToMap(spaceAdmin);
                    this.addSpace(space, spaceAdmin, item.serviceID, spaceConfig, containerConfig, space.isSecured());
                }
                catch (Exception exc) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, exc.toString(), exc);
                    }
                    break block9;
                }
            }
            if (clusterName == null) {
                IJSpace space = (IJSpace)item.service;
                try {
                    SpaceConfig spaceConfig;
                    IRemoteJSpaceAdmin spaceAdmin = Repository.addSpaceAdminObjectToMap(space);
                    if (spaceAdmin != null && (spaceConfig = Repository.addSpaceConfigToMap(spaceAdmin)).isMirrorServiceEnabled()) {
                        String containerName = spaceAdmin.getName();
                        String spaceName = space.getName();
                        String clusterMemberName = JSpaceUtilities.createFullSpaceName((String)containerName, (String)spaceName);
                        if (this._serviceManagerImpl != null && this._serviceManagerImpl.getClusterMember(clusterMemberName) != null) {
                            IJSpaceContainerAdmin containerAdmin = (IJSpaceContainerAdmin)space.getDirectProxy().getContainer();
                            ContainerConfig containerConfig = Repository.addContainerToMap(containerAdmin);
                            this.addSpace(space, spaceAdmin, item.serviceID, spaceConfig, containerConfig, space.isSecured());
                        }
                    }
                }
                catch (Exception exc) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block9;
                    LOGGER.log(Level.SEVERE, exc.toString(), exc);
                }
            }
        }
    }

    static {
        Properties serializing = Repository.getInstance().getProperties();
        String clusterViewColumns = (String)serializing.get("SPACES_NETWORK_VIEW_COLUMNS");
        _spacesViewColumnNames = new ArrayList<String>(5);
        if (clusterViewColumns != null) {
            StringTokenizer strTokenizer = new StringTokenizer(clusterViewColumns, ";", false);
            while (strTokenizer.hasMoreTokens()) {
                String columnName = strTokenizer.nextToken();
                _spacesViewColumnNames.add(columnName);
            }
            if (!_spacesViewColumnNames.get(0).equals("\u00a0")) {
                _spacesViewColumnNames.add(0, "\u00a0");
            }
        }
        if (_spacesViewColumnNames.size() == 0) {
            for (String columnName : ISpacesView.DEFAULT_COLUMN_NAMES) {
                _spacesViewColumnNames.add(columnName);
            }
        }
    }
}

