/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.views.utils.BasicWrapper;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.IInternalRemoteJSpaceAdmin;
import com.j_spaces.core.client.TransactionInfo;
import com.j_spaces.core.client.UnderTxnLockedObject;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.cluster.view.ServiceManagerImpl;
import com.j_spaces.tools.spacebrowser.SpaceTransactionsPanel;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JFrame;
import javax.swing.table.TableColumn;

public class ClusterTransactionsPanel
extends SpaceTransactionsPanel {
    private String _curClusterName;
    private ServiceManagerImpl _serviceManagerImpl;
    private static final int CI_CLUSTER_TRANSACTION_MEMBER_NAME = 0;
    private static final int CI_CLUSTER_TRANSACTION_ID = 1;
    private static final int CI_CLUSTER_TRANSACTION_TYPE = 2;
    private static final int CI_CLUSTER_TRANSACTION_STATUS = 3;
    private static final int CI_CLUSTER_TRANSACTION_START_TIME = 4;
    private static final int CI_CLUSTER_TRANSACTION_END_TIME = 5;
    private static final int CI_CLUSTER_TRANS_NUMBER_OF_LOCKED_OBJECTS = 6;

    public ClusterTransactionsPanel(JFrame parentFrame, ServiceManagerImpl serviceManagerImpl) {
        super(parentFrame);
        this._serviceManagerImpl = serviceManagerImpl;
        this.refreshPanel.setSelectedRefreshRate(5000);
        TableColumn memberNameTableColumn = this._transactionsTable.getColumnModel().getColumn(0);
        memberNameTableColumn.setPreferredWidth(180);
    }

    @Override
    protected void initTableModel() {
        this._transactionsTableModel = new ClusterTransactionsTableModel();
    }

    public void setCurrentClusterName(String clusterName) {
        this._curClusterName = clusterName;
        this._transactionsTableModel.refresh();
    }

    @Override
    public void setInvokeRefresh(boolean isRefresh) {
        this._transactionsTableModel.setInvokeRefresh(isRefresh);
    }

    @Override
    protected List<UnderTxnLockedObject> retrieveLockedObjects(TransactionInfo transactionInfo) throws RemoteException {
        IInternalRemoteJSpaceAdmin spaceAdmin = ((ClusterTransactionInfo)transactionInfo).getSpaceAdmin();
        return spaceAdmin.getLockedObjects(transactionInfo.getTrasaction());
    }

    protected class ClusterTransactionInfo
    extends TransactionInfo {
        private final IInternalRemoteJSpaceAdmin _spaceAdmin;
        private final String _clusterMemberName;

        public ClusterTransactionInfo(TransactionInfo transactionInfo, IInternalRemoteJSpaceAdmin spaceAdmin, String clusterMemberName) {
            super(transactionInfo.getType(), transactionInfo.getStatus(), transactionInfo.getTrasaction(), transactionInfo.getLease(), transactionInfo.getStartTime(), transactionInfo.getNumberOfLockedObjects());
            this._spaceAdmin = spaceAdmin;
            this._clusterMemberName = clusterMemberName;
        }

        public IInternalRemoteJSpaceAdmin getSpaceAdmin() {
            return this._spaceAdmin;
        }

        public String getClusterMemberName() {
            return this._clusterMemberName;
        }

        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this._clusterMemberName == null ? 0 : this._clusterMemberName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            ClusterTransactionInfo other = (ClusterTransactionInfo)((Object)obj);
            return super.equals((Object)other) && this._clusterMemberName.equals(other._clusterMemberName);
        }

        private ClusterTransactionsPanel getOuterType() {
            return ClusterTransactionsPanel.this;
        }
    }

    public class ClusterTransactionsTableModel
    extends SpaceTransactionsPanel.TransactionsTableModel {
        public ClusterTransactionsTableModel() {
            super(ClusterTransactionsPanel.this);
        }

        @Override
        protected void initColumnNames() {
            this.columnNames = new String[7];
            this.columnNames[0] = "Cluster Member Name";
            this.columnNames[1] = "ID";
            this.columnNames[2] = "Type";
            this.columnNames[3] = "Status";
            this.columnNames[4] = "Start Time";
            this.columnNames[5] = "End Time";
            this.columnNames[6] = "Locked Objects";
        }

        @Override
        protected boolean isDisplayTransaction(TransactionInfo transactionInfo) {
            return ((ClusterTransactionInfo)transactionInfo).getClusterMemberName().toUpperCase().contains(this._searchedText.toUpperCase()) || super.isDisplayTransaction(transactionInfo);
        }

        @Override
        protected int compareWrappers(BasicWrapper wrapper1, BasicWrapper wrapper2, int colIndex, boolean ascending) {
            switch (colIndex) {
                case 0: {
                    SpaceTransactionsPanel.TransactionWrapper transactionWrapper1 = (SpaceTransactionsPanel.TransactionWrapper)wrapper1;
                    SpaceTransactionsPanel.TransactionWrapper transactionWrapper2 = (SpaceTransactionsPanel.TransactionWrapper)wrapper2;
                    ClusterTransactionInfo transactionInfo1 = (ClusterTransactionInfo)transactionWrapper1.getTransactionInfo();
                    ClusterTransactionInfo transactionInfo2 = (ClusterTransactionInfo)transactionWrapper2.getTransactionInfo();
                    String clusterMemberName1 = transactionInfo1.getClusterMemberName();
                    String clusterMemberName2 = transactionInfo2.getClusterMemberName();
                    if (ascending) {
                        return clusterMemberName1.compareToIgnoreCase(clusterMemberName2);
                    }
                    return clusterMemberName2.compareToIgnoreCase(clusterMemberName1);
                }
                case 6: {
                    return super.compareWrappers(wrapper1, wrapper2, 5, ascending);
                }
                case 5: {
                    return super.compareWrappers(wrapper1, wrapper2, 4, ascending);
                }
                case 1: {
                    return super.compareWrappers(wrapper1, wrapper2, 0, ascending);
                }
                case 4: {
                    return super.compareWrappers(wrapper1, wrapper2, 3, ascending);
                }
                case 3: {
                    return super.compareWrappers(wrapper1, wrapper2, 2, ascending);
                }
                case 2: {
                    return super.compareWrappers(wrapper1, wrapper2, 1, ascending);
                }
            }
            return super.compareWrappers(wrapper1, wrapper2, colIndex, ascending);
        }

        @Override
        public Object getCellValue(BasicWrapper basicWrapper, int column) {
            TransactionInfo transactionInfo = ((SpaceTransactionsPanel.TransactionWrapper)basicWrapper).getTransactionInfo();
            switch (column) {
                case 0: {
                    return ((ClusterTransactionInfo)transactionInfo).getClusterMemberName();
                }
                case 1: {
                    return String.valueOf(transactionInfo.getTxnId());
                }
                case 2: {
                    return JSpaceUtilities.getTransactionTypeName((int)transactionInfo.getType());
                }
                case 3: {
                    return JSpaceUtilities.getTransactionStatusName((int)transactionInfo.getStatus());
                }
                case 4: {
                    return this.df.format(new Date(transactionInfo.getStartTime()));
                }
                case 5: {
                    long lease = transactionInfo.getLease();
                    if (lease < 0L) {
                        return " - ";
                    }
                    return this.df.format(new Date(transactionInfo.getStartTime() + lease));
                }
                case 6: {
                    return String.valueOf(transactionInfo.getNumberOfLockedObjects());
                }
            }
            return "";
        }

        @Override
        protected TransactionInfo createTransactionInfo(TransactionInfo transactionInfo, int lockedObjectCount) {
            ClusterTransactionInfo clusterTransactionInfo = (ClusterTransactionInfo)transactionInfo;
            return new ClusterTransactionInfo(clusterTransactionInfo, clusterTransactionInfo.getSpaceAdmin(), clusterTransactionInfo.getClusterMemberName());
        }

        @Override
        public void refresh() {
            if (this._isInvokeRefresh) {
                ServiceManagerImpl.ClusterMember[] clusterMembersArray = ClusterTransactionsPanel.this._serviceManagerImpl.getClusterMembers(ClusterTransactionsPanel.this._curClusterName, true);
                int selRow = ClusterTransactionsPanel.this._transactionsTable.getSelectedRow();
                SpaceTransactionsPanel.TransactionWrapper selTransactionWrapper = null;
                if (selRow >= 0) {
                    selTransactionWrapper = (SpaceTransactionsPanel.TransactionWrapper)ClusterTransactionsPanel.this._transactionsTableModel.getWrapperAt(selRow);
                }
                ArrayList<SpaceTransactionsPanel.TransactionWrapper> newTransactionInfoList = new ArrayList<SpaceTransactionsPanel.TransactionWrapper>();
                for (ServiceManagerImpl.ClusterMember clusterMember : clusterMembersArray) {
                    TransactionInfo[] transactionInfoArray = null;
                    IInternalRemoteJSpaceAdmin spaceAdmin = null;
                    String clusterMemberName = clusterMember.getClusterMemberName();
                    try {
                        IJSpace spaceProxy = clusterMember.getRegularProxy();
                        spaceAdmin = (IInternalRemoteJSpaceAdmin)Repository.addSpaceAdminObjectToMap(spaceProxy);
                        transactionInfoArray = spaceAdmin.getTransactionsInfo(0, 1);
                        ClusterTransactionsPanel.this.curSpaceProxy = clusterMember.getClusteredProxy();
                    }
                    catch (RemoteException e) {
                        SpaceTransactionsPanel._logger.log(Level.FINE, e.toString(), e);
                    }
                    catch (Exception e) {
                        SpaceTransactionsPanel._logger.log(Level.SEVERE, e.toString(), e);
                    }
                    if (transactionInfoArray == null) continue;
                    for (TransactionInfo transactionInfo : transactionInfoArray) {
                        ClusterTransactionInfo clusterTransactionInfo = new ClusterTransactionInfo(transactionInfo, spaceAdmin, clusterMemberName);
                        newTransactionInfoList.add(new SpaceTransactionsPanel.TransactionWrapper(ClusterTransactionsPanel.this, clusterTransactionInfo));
                    }
                }
                this.handleCurrentTransactionsList(newTransactionInfoList, selTransactionWrapper);
                ClusterTransactionsPanel.this._infoBox.setCount(ClusterTransactionsPanel.this._transactionsTableModel.getRowCount());
            }
        }
    }
}

