/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.gigaspaces.admin.ui.grid.Repository;
import com.j_spaces.core.ContainerConfigFactory;
import com.j_spaces.core.admin.ContainerConfig;
import com.j_spaces.core.admin.IJSpaceContainerAdmin;
import com.j_spaces.kernel.Environment;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.StaleContainerService;
import com.j_spaces.tools.spacebrowser.XMLFileFilter;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;

public class ContainerConfigPanel
extends JPanel
implements ActionListener {
    private static final String DIALOG_CONTAINERCONFIG_LABEL = "dialog.containerconfig.labels";
    private static final String DIALOG_CONTAINERCONFIG_TOOLTIP = "dialog.containerconfig.tooltip";
    private static final String DIALOG_CONTAINERCONFIG_BUTTON = "dialog.containerconfig.button";
    String[] resLabel;
    String[] resButton;
    String[] resTooltip;
    JTabbedPane tabPanContainer = new JTabbedPane();
    private JPanel generalPropsPanel = new JPanel(new BorderLayout());
    private JPanel directoryServicesPanel = new JPanel(new BorderLayout());
    private JPanel jmsServicesPanel = new JPanel(new BorderLayout());
    JPanel panControlButtons = new JPanel();
    JPanel panDirServices = new JPanel();
    JPanel panGeneral = new JPanel();
    JPanel panJndiOptions = new JPanel();
    JPanel panLookupOptions = new JPanel();
    JPanel panJms = new JPanel();
    JCheckBox jndiCheckBox = new JCheckBox();
    JCheckBox lusCheckBox = new JCheckBox();
    JCheckBox unicastCheckBox = new JCheckBox();
    private final JTextField unicastHostTextField = new JTextField();
    private final JTextField jndiUrlTextField = new JTextField();
    private final JTextField groupTextField = new JTextField();
    private final JTextField licenseTextField = new JTextField();
    private final JTextField homeDirTextField = new JTextField();
    private final JTextField containerNameTxtField = new JTextField();
    private final JTextField hostNameTxtField = new JTextField();
    JLabel unicastLabel = new JLabel();
    JLabel groupLabel = new JLabel();
    JLabel jndiUrlLabel = new JLabel();
    JLabel licenseLabel = new JLabel();
    JLabel homeDirLabel = new JLabel();
    ButtonGroup rbuttonGroup = new ButtonGroup();
    private final JButton saveAsButton = new JButton();
    JCheckBox chboxJmsExtJndiEnabled = new JCheckBox();
    JCheckBox chboxJmsEnabled = new JCheckBox();
    JCheckBox chboxJmsIntJndiEnabled = new JCheckBox();
    private final SpaceBrowser m_spaceBrowser;
    private final JFrame _parentFrame;
    static final int JNDI_MODE = 1;
    static final int LUS_MODE = 2;
    static final int JNDI_MODE_AND_LUS_MODE = 3;
    private JFileChooser fileChooser;
    private static final String CONTAINER_SCHEMA_POSTFIX_FILE_NAME = "*-container-schema.xml";
    private final XMLFileFilter containerSchemaFileFilter = new XMLFileFilter("Schema File( *-container-schema.xml )");

    public ContainerConfigPanel(JFrame parentFrame, SpaceBrowser spaceBrowser) {
        this.m_spaceBrowser = spaceBrowser;
        this._parentFrame = parentFrame;
        try {
            this.init();
            this.cleanup();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.saveAsButton) {
            this.invokeSaveAs();
        } else if (source == this.chboxJmsEnabled) {
            this.chboxJmsExtJndiEnabled.setEnabled(this.chboxJmsEnabled.isSelected());
            this.chboxJmsIntJndiEnabled.setEnabled(this.chboxJmsEnabled.isSelected());
        } else if (source == this.jndiCheckBox) {
            this.jndiCheckBox.setSelected(!this.jndiCheckBox.isSelected());
        } else if (source == this.lusCheckBox) {
            this.lusCheckBox.setSelected(!this.lusCheckBox.isSelected());
        } else if (source == this.unicastCheckBox) {
            this.unicastCheckBox.setSelected(!this.unicastCheckBox.isSelected());
        }
    }

    public void init() throws Exception {
        this.resLabel = JSpaceUIUtils.getResources(DIALOG_CONTAINERCONFIG_LABEL);
        this.resButton = JSpaceUIUtils.getResources(DIALOG_CONTAINERCONFIG_BUTTON);
        this.resTooltip = JSpaceUIUtils.getResources(DIALOG_CONTAINERCONFIG_TOOLTIP);
        this.saveAsButton.setText(this.resButton[1]);
        this.saveAsButton.setEnabled(false);
        this.panControlButtons.setLayout(new GridBagLayout());
        this.homeDirLabel.setText(this.resLabel[1]);
        this.licenseLabel.setText(this.resLabel[2]);
        this.groupLabel.setText(this.resLabel[7]);
        this.unicastLabel.setText(this.resLabel[9]);
        this.homeDirTextField.setEditable(false);
        this.containerNameTxtField.setEditable(false);
        this.hostNameTxtField.setEditable(false);
        this.groupTextField.setEditable(false);
        this.unicastHostTextField.setEditable(false);
        this.jndiUrlTextField.setEditable(false);
        this.licenseTextField.setEditable(false);
        this.homeDirTextField.setToolTipText(this.resTooltip[0]);
        this.licenseTextField.setToolTipText(this.resTooltip[1]);
        this.jndiCheckBox.setToolTipText(this.resTooltip[2]);
        this.jndiUrlTextField.setToolTipText(this.resTooltip[3]);
        this.lusCheckBox.setToolTipText(this.resTooltip[4]);
        this.groupTextField.setToolTipText(this.resTooltip[5]);
        this.unicastCheckBox.setToolTipText(this.resTooltip[6]);
        this.unicastHostTextField.setToolTipText(this.resTooltip[7]);
        this.jndiUrlLabel.setText(this.resLabel[5]);
        this.jndiCheckBox.setText(this.resLabel[4]);
        this.lusCheckBox.setText(this.resLabel[6]);
        this.unicastCheckBox.setText(this.resLabel[8]);
        this.panGeneral.setLayout(new GridBagLayout());
        this.panDirServices.setLayout(new GridBagLayout());
        this.panLookupOptions.setLayout(new GridBagLayout());
        this.panJndiOptions.setLayout(new BorderLayout());
        this.panJms.setLayout(new GridBagLayout());
        this.panJndiOptions.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "JNDI Options"), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.panLookupOptions.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "Lookup Service Options"), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.panDirServices.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), this.resLabel[3]), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.unicastCheckBox.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
        this.jndiUrlLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        this.panGeneral.add((Component)new JLabel("Container name: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panGeneral.add((Component)this.containerNameTxtField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 2), 0, 0));
        this.panGeneral.add((Component)new JLabel("Host name: "), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panGeneral.add((Component)this.hostNameTxtField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 2), 0, 0));
        this.panGeneral.add((Component)this.homeDirLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panGeneral.add((Component)this.licenseLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panGeneral.add((Component)this.homeDirTextField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 2), 0, 0));
        this.panGeneral.add((Component)this.licenseTextField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 2), 0, 0));
        this.panJndiOptions.add((Component)this.jndiUrlLabel, "West");
        this.panJndiOptions.add((Component)this.jndiUrlTextField, "Center");
        this.panLookupOptions.add((Component)this.groupLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panLookupOptions.add((Component)this.unicastCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.panLookupOptions.add((Component)this.unicastLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panLookupOptions.add((Component)this.groupTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panLookupOptions.add((Component)this.unicastHostTextField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panDirServices.add((Component)this.jndiCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.panDirServices.add((Component)this.panJndiOptions, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panDirServices.add((Component)this.lusCheckBox, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 0, 5, 0), 0, 0));
        this.panDirServices.add((Component)this.panLookupOptions, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.chboxJmsEnabled.setText("JMS Enabled");
        this.chboxJmsIntJndiEnabled.setText("Internal JNDI Enabled");
        this.chboxJmsExtJndiEnabled.setText("External JNDI Enabled");
        this.panJms.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(156, 156, 158)), "JMS"), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.panJms.setLayout(new GridBagLayout());
        this.panJms.add((Component)this.chboxJmsEnabled, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.panJms.add((Component)this.chboxJmsIntJndiEnabled, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.panJms.add((Component)this.chboxJmsExtJndiEnabled, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.chboxJmsEnabled.addActionListener(this);
        this.generalPropsPanel.add((Component)this.panGeneral, "North");
        this.directoryServicesPanel.add((Component)this.panDirServices, "North");
        this.jmsServicesPanel.add((Component)this.panJms, "North");
        this.tabPanContainer.add((Component)this.generalPropsPanel, "General");
        this.tabPanContainer.add((Component)this.directoryServicesPanel, "Directory Services");
        this.tabPanContainer.add((Component)this.jmsServicesPanel, "JMS");
        this.panControlButtons.add(this.saveAsButton);
        this.setLayout(new BorderLayout());
        this.add((Component)this.panControlButtons, "South");
        this.add((Component)this.tabPanContainer, "Center");
        this.jndiCheckBox.setSelected(true);
        this.lusCheckBox.setSelected(true);
        this.unicastCheckBox.setRequestFocusEnabled(false);
        this.lusCheckBox.setRequestFocusEnabled(false);
        this.jndiCheckBox.setRequestFocusEnabled(false);
        this.saveAsButton.addActionListener(this);
        this.jndiCheckBox.addActionListener(this);
        this.lusCheckBox.addActionListener(this);
        this.unicastCheckBox.addActionListener(this);
    }

    private ContainerConfig getConfig(String containerNodeName) {
        ContainerConfig config = Repository.getContainerConfig(containerNodeName);
        if (config == null) {
            return null;
        }
        config.homeDir = this.homeDirTextField.getText();
        config.containerHostName = this.hostNameTxtField.getText();
        if (this.jndiUrlTextField.getText().trim().length() != 0) {
            config.jndiUrl = this.jndiUrlTextField.getText();
        }
        if (this.groupTextField.getText().trim().length() != 0) {
            config.lookupGroups = this.groupTextField.getText();
        }
        if (this.licenseTextField.getText().trim().length() != 0) {
            config.license = this.licenseTextField.getText();
        }
        config.setJndiEnabled(this.jndiCheckBox.isSelected());
        config.setJiniLusEnabled(this.lusCheckBox.isSelected());
        config.unicastEnabled = this.unicastCheckBox.isEnabled() && this.unicastCheckBox.isSelected();
        if (this.unicastHostTextField.getText().trim().length() != 0) {
            config.unicastURL = this.unicastHostTextField.getText();
        }
        config.jmsEnabled = this.chboxJmsEnabled.isSelected();
        config.jmsInternalJndiEnabled = this.chboxJmsIntJndiEnabled.isSelected();
        config.jmsExtJndiEnabled = this.chboxJmsExtJndiEnabled.isSelected();
        return config;
    }

    private void invokeSaveAs() {
        if (this.fileChooser == null) {
            try {
                this._parentFrame.setCursor(Cursor.getPredefinedCursor(3));
                this.fileChooser = new JFileChooser();
                this.fileChooser.addChoosableFileFilter(this.containerSchemaFileFilter);
                this.fileChooser.setAcceptAllFileFilterUsed(false);
                this.fileChooser.setDialogTitle("Save Container As");
                this.fileChooser.setFileFilter(this.containerSchemaFileFilter);
                String schemasFolder = Environment.createSchemasFolderIfNotExists();
                this.fileChooser.setCurrentDirectory(new File(schemasFolder));
            }
            finally {
                this._parentFrame.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        this.fileChooser.showSaveDialog(this._parentFrame);
        FileFilter selectedFileFilter = this.fileChooser.getFileFilter();
        File selFile = this.fileChooser.getSelectedFile();
        DefaultMutableTreeNode conNode = this.m_spaceBrowser.getSelectedTreeNode();
        if (conNode == null) {
            return;
        }
        Object nodeObject = conNode.getUserObject();
        if (nodeObject instanceof StaleContainerService) {
            return;
        }
        ContainerConfig config = this.getConfig(conNode.toString());
        if (selFile != null) {
            String selFileName = selFile.getName();
            String selPath = selFile.getPath();
            if (selectedFileFilter.equals(this.containerSchemaFileFilter)) {
                selPath = selPath + "-container-schema.xml";
            }
            ContainerConfigFactory.performSaveAs((String)selFileName, (String)selPath, (ContainerConfig)config);
        }
    }

    public void updateConfig(IJSpaceContainerAdmin admin) {
        if (admin == null) {
            return;
        }
        this.saveAsButton.setEnabled(true);
        String containerName = null;
        try {
            containerName = admin.getName();
            ContainerConfig config = Repository.addContainerToMap(admin);
            this.jndiCheckBox.setSelected(false);
            this.lusCheckBox.setSelected(false);
            boolean isJndiEnabled = config.isJndiEnabled();
            boolean isJiniLUSEnabled = config.isJiniLusEnabled();
            this.jndiCheckBox.setSelected(isJndiEnabled);
            JSpaceUIUtils.setAWTComponentsStatus(this.panJndiOptions, isJndiEnabled);
            this.lusCheckBox.setSelected(isJiniLUSEnabled);
            JSpaceUIUtils.setAWTComponentsStatus(this.panLookupOptions, isJiniLUSEnabled);
            this.containerNameTxtField.setText(containerName);
            this.hostNameTxtField.setText(config.containerHostName);
            this.homeDirTextField.setText(config.homeDir);
            this.licenseTextField.setText(config.license);
            this.jndiUrlTextField.setText(config.getJndiPublicURL());
            this.groupTextField.setText(config.lookupGroups);
            this.unicastCheckBox.setSelected(config.unicastEnabled);
            this.unicastHostTextField.setText(config.unicastURL);
            this.chboxJmsEnabled.setSelected(config.jmsEnabled);
            this.chboxJmsIntJndiEnabled.setSelected(config.jmsInternalJndiEnabled);
            this.chboxJmsExtJndiEnabled.setSelected(config.jmsExtJndiEnabled);
            JSpaceUIUtils.setAWTComponentsStatus(this.panJms, this.chboxJmsEnabled.isSelected());
        }
        catch (Exception ex) {
            this.saveAsButton.setEnabled(false);
            SpaceBrowser.expDialog.showException("updating container configuration", ex);
        }
    }

    void cleanup() {
        this.saveAsButton.setEnabled(false);
        this.jndiCheckBox.setSelected(true);
        this.lusCheckBox.setSelected(true);
        this.unicastCheckBox.setSelected(false);
        this.unicastCheckBox.setEnabled(false);
        this.unicastHostTextField.setEditable(false);
        this.containerNameTxtField.setText("");
        this.hostNameTxtField.setText("");
        this.homeDirTextField.setText("");
        this.licenseTextField.setText("");
        this.groupTextField.setText("");
        this.jndiUrlTextField.setText("");
        this.unicastHostTextField.setText("");
        JSpaceUIUtils.setAWTComponentsStatus(this.panJms, this.chboxJmsEnabled.isSelected());
    }

    public String getContainerName() {
        return this.containerNameTxtField.getText();
    }
}

