/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.gigaspaces.admin.ui.util.EscapeDialog;
import com.j_spaces.tools.general.GSCheckBoxCellRenderer;
import com.j_spaces.tools.spacebrowser.ISpacesView;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class CustomizeViewDialog
extends EscapeDialog
implements ActionListener,
ISpacesView {
    private JButton _okButton = new JButton("OK");
    private JButton _cancelButton = new JButton("Cancel");
    private CustomizeViewBox _customizeViewBox;
    private Dimension _buttonSize = new Dimension(110, 22);
    private List<String> _selectedNamesList;

    public CustomizeViewDialog(JFrame parentFrame) {
        super(parentFrame, "Select Columns", true);
        Container contentPane = this.getContentPane();
        Box buttonPanel = this.createButtonsPanel();
        Box topPanel = this.createTopPanel();
        contentPane.add((Component)topPanel, "Center");
        contentPane.add((Component)buttonPanel, "South");
        this.setSize(300, 438);
    }

    private Box createButtonsPanel() {
        Box buttonsBox = new Box(1);
        Box horizBox = new Box(0);
        this._okButton.setPreferredSize(this._buttonSize);
        this._cancelButton.setPreferredSize(this._buttonSize);
        horizBox.add(Box.createHorizontalGlue());
        horizBox.add(this._okButton);
        horizBox.add(Box.createHorizontalStrut(10));
        horizBox.add(this._cancelButton);
        horizBox.add(Box.createHorizontalGlue());
        this._okButton.addActionListener(this);
        this._cancelButton.addActionListener(this);
        buttonsBox.add(Box.createVerticalStrut(5));
        buttonsBox.add(horizBox);
        buttonsBox.add(Box.createVerticalStrut(5));
        return buttonsBox;
    }

    public List<String> getSelectedNames() {
        return this._selectedNamesList;
    }

    public void initDialog(List<String> curSelectedColumnNames) {
        this._customizeViewBox.initPanel(curSelectedColumnNames);
    }

    private Box createTopPanel() {
        this._customizeViewBox = new CustomizeViewBox();
        return this._customizeViewBox;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this._okButton) {
            this._selectedNamesList = this._customizeViewBox.getSelectedNames();
            if (this.isSelectionValid()) {
                this.dispose();
            }
        } else if (source == this._cancelButton) {
            this.closeDialog();
        }
    }

    private boolean isSelectionValid() {
        if (this._selectedNamesList.size() == 0) {
            JOptionPane.showMessageDialog(this, "Unable to continue. At least one option must be selected.");
            return false;
        }
        return true;
    }

    private void closeDialog() {
        this._selectedNamesList = null;
        this.setVisible(false);
    }

    public static void main(String[] args) {
        JFrame parentFrame = new JFrame("Test");
        CustomizeViewDialog customizeViewDialog = new CustomizeViewDialog(parentFrame);
        customizeViewDialog.setVisible(true);
    }

    public class CustomizeViewTableModel
    extends DefaultTableModel {
        private final String[] columnNames = new String[]{"Include", "Column Name"};

        public CustomizeViewTableModel() {
            for (String optionName : ISpacesView.ALL_COLUMN_NAMES) {
                Vector<Object> rowVector = new Vector<Object>(2);
                rowVector.add(true);
                if (optionName.equals("\u0394")) {
                    optionName = "\u0394 Objects Count Delta";
                }
                rowVector.add(optionName);
                this.dataVector.add(rowVector);
            }
            this.fireTableRowsInserted(0, ISpacesView.ALL_COLUMN_NAMES.length - 1);
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            super.setValueAt(aValue, row, column);
            if (this.getValueAt(row, 1).equals("Objects Count") && column == 0 && !((Boolean)aValue).booleanValue()) {
                super.setValueAt(aValue, 3, 0);
            }
        }

        public void selectAllOptions(boolean select) {
            int rowCount = this.getRowCount();
            for (int rowNum = 0; rowNum < rowCount; ++rowNum) {
                if (!select && (this.getValueAt(rowNum, 1).equals("Name") || this.getValueAt(rowNum, 1).equals("Container Name") || this.getValueAt(rowNum, 1).equals("\u00a0"))) continue;
                this.setValueAt(select, rowNum, 0);
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public Class getColumnClass(int c) {
            if (c == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(c);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            Object val = this.getValueAt(row, 1);
            if (col == 0 && (val.equals("Name") || val.equals("Container Name") || val.equals("\u00a0"))) {
                return false;
            }
            return col == 0;
        }

        public boolean isAllOptionsSelected() {
            int rowCount = this.getRowCount();
            for (int rowNum = 0; rowNum < rowCount; ++rowNum) {
                if (((Boolean)this.getValueAt(rowNum, 0)).booleanValue()) continue;
                return false;
            }
            return true;
        }

        public void initModel(List<String> curSelectedColumnNames) {
            int rowCount = this.getRowCount();
            for (int rowNum = 0; rowNum < rowCount; ++rowNum) {
                String optionName = this.getValueAt(rowNum, 1).toString();
                if (optionName.equals("\u0394 Objects Count Delta")) {
                    optionName = "\u0394";
                }
                this.setValueAt(curSelectedColumnNames.contains(optionName), rowNum, 0);
            }
        }
    }

    private class CustomizeViewBox
    extends Box {
        private JTable _optionsTable;
        private CustomizeViewTableModel _optionsTableModel;
        private JButton _selectorButton;
        private static final String DE_SELECT_ALL_TEXT = "De-Select All";
        private static final String SELECT_ALL_TEXT = "Select All";

        public CustomizeViewBox() {
            super(1);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Available Options"), BorderFactory.createEmptyBorder(0, 2, 0, 0)));
            this.add(Box.createVerticalStrut(3));
            this._optionsTableModel = new CustomizeViewTableModel();
            this._optionsTable = new JTable(this._optionsTableModel);
            JTableHeader tableHeader = this._optionsTable.getTableHeader();
            TableColumnModel columnModel = tableHeader.getColumnModel();
            int minWidth = 40;
            TableColumn firstColumn = columnModel.getColumn(0);
            firstColumn.setPreferredWidth(minWidth);
            firstColumn.setMaxWidth(minWidth);
            firstColumn.setCellRenderer(new GSCheckBoxCellRenderer());
            tableHeader.setReorderingAllowed(false);
            this._optionsTable.setAutoCreateColumnsFromModel(true);
            this._optionsTable.setSelectionMode(0);
            this._optionsTable.setAutoResizeMode(1);
            this._optionsTable.setAutoscrolls(true);
            JLabel explLabel = new JLabel("<HTML>Select the columns that will be appear<BR>in the Space Network View<HTML>");
            Box explBox = new Box(0);
            explBox.add(explLabel);
            explBox.add(Box.createHorizontalGlue());
            this.add(explBox);
            this.add(Box.createVerticalStrut(3));
            this.add(new JScrollPane(this._optionsTable));
            this.add(Box.createVerticalStrut(5));
            this._selectorButton = new JButton(SELECT_ALL_TEXT);
            this._selectorButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean select = CustomizeViewBox.this._selectorButton.getText().startsWith(CustomizeViewBox.SELECT_ALL_TEXT);
                    CustomizeViewBox.this._selectorButton.setText(select ? CustomizeViewBox.DE_SELECT_ALL_TEXT : CustomizeViewBox.SELECT_ALL_TEXT);
                    CustomizeViewBox.this._optionsTableModel.selectAllOptions(select);
                }
            });
            this._selectorButton.setPreferredSize(CustomizeViewDialog.this._buttonSize);
            this._selectorButton.setMinimumSize(CustomizeViewDialog.this._buttonSize);
            Box selectBox = new Box(0);
            selectBox.add(this._selectorButton);
            selectBox.add(Box.createHorizontalGlue());
            this.add(selectBox);
            this.add(Box.createVerticalGlue());
        }

        public void initPanel(List<String> curSelectedColumnNames) {
            this._optionsTableModel.initModel(curSelectedColumnNames);
            if (this._optionsTableModel.isAllOptionsSelected()) {
                this._selectorButton.setText(DE_SELECT_ALL_TEXT);
            }
        }

        public List<String> getSelectedNames() {
            ArrayList<String> selNamesList = new ArrayList<String>();
            int rowCount = this._optionsTable.getRowCount();
            for (int rowNum = 0; rowNum < rowCount; ++rowNum) {
                if (!((Boolean)this._optionsTable.getValueAt(rowNum, 0)).booleanValue()) continue;
                selNamesList.add(this._optionsTable.getValueAt(rowNum, 1).toString());
            }
            return selNamesList;
        }
    }
}

