/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.j_spaces.core.JSpaceAttributes;
import com.j_spaces.tools.spacebrowser.WholeNumberField;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class DistributedCachePanel
extends JPanel {
    private JLabel labConfigName = new JLabel();
    private JLabel labDelayBetweenRetries = new JLabel();
    private JLabel labUpdatePolicy = new JLabel();
    private JLabel labMaxObjectsInCache = new JLabel();
    private JLabel labMaxObjectTimeout = new JLabel();
    private JLabel labHighWatermarkPercentage = new JLabel();
    private JLabel labLowWatermarkPercentage = new JLabel();
    private JLabel labEvictionBatchSize = new JLabel();
    private JTextField txtfConfigName = new JTextField();
    private JTextField txtfMaxObjectsInCache = new WholeNumberField();
    private JTextField txtfDelayBetweenRetries = new WholeNumberField();
    private JTextField txtfRetryConnections = new WholeNumberField();
    private JTextField txtfMaxObjectTimeout = new WholeNumberField();
    private JTextField txtfHighWatermarkPercentage = new WholeNumberField(false);
    private JTextField txtfLowWatermarkPercentage = new WholeNumberField(false);
    private JTextField txtfEvictionBatchSize = new WholeNumberField();
    private JButton butConfigFile = new JButton();
    private JCheckBox chboxVersionedCache = new JCheckBox();
    private JCheckBox chboxMemoryUsageEnable = new JCheckBox();
    private JCheckBox chBoxPutFirst = new JCheckBox("Put First");
    private JTextField txtUpdatePolicy;
    private JTextField txtEvictionPolicy;
    private JTextField txtEvictionStrategy;
    private JTextField txtCompression;
    private String UPDATE_POLICY_PULL = "Pull";
    private String UPDATE_POLICY_PUSH = "Push";
    private String EVICTION_POLICY_LRU = "LRU";
    private String EVICTION_POLICY_ALL_IN_CACHE = "All in Cache";
    private String EVICTION_POLICY_CUSTOM = "Custom";
    private String EVICTION_POLICY_BLOB_STORE = "Blob Store";
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();

    public DistributedCachePanel() {
        try {
            this.txtUpdatePolicy = new JTextField();
            this.txtEvictionPolicy = new JTextField();
            this.txtEvictionStrategy = new JTextField();
            this.txtCompression = new JTextField();
            this.jbInit();
            this.createListeners();
            this.clean();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void createListeners() {
        this.chboxMemoryUsageEnable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DistributedCachePanel.this.chboxMemoryUsageEnable.setSelected(!DistributedCachePanel.this.chboxMemoryUsageEnable.isSelected());
            }
        });
        this.chboxVersionedCache.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DistributedCachePanel.this.chboxVersionedCache.setSelected(!DistributedCachePanel.this.chboxVersionedCache.isSelected());
            }
        });
        this.chBoxPutFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DistributedCachePanel.this.chBoxPutFirst.setSelected(!DistributedCachePanel.this.chBoxPutFirst.isSelected());
            }
        });
    }

    private void setMemoryUsageCompEnable(boolean b) {
        this.labHighWatermarkPercentage.setEnabled(b);
        this.labLowWatermarkPercentage.setEnabled(b);
        this.labEvictionBatchSize.setEnabled(b);
        this.txtfHighWatermarkPercentage.setEnabled(b);
        this.txtfLowWatermarkPercentage.setEnabled(b);
        this.txtfEvictionBatchSize.setEnabled(b);
    }

    void jbInit() throws Exception {
        this.labConfigName.setText("Configuration Name:");
        this.butConfigFile.setText("...");
        this.chboxVersionedCache.setText("Versioned Cache");
        this.labUpdatePolicy.setText("Update Policy:");
        this.labMaxObjectsInCache.setText("Maximum Number of Objects in the Cache:");
        this.labMaxObjectTimeout.setText("Maximum Object Timeout:");
        this.labHighWatermarkPercentage.setText("High Watermark Percentage:");
        this.labLowWatermarkPercentage.setText("Low Watermark Percentage:");
        this.labEvictionBatchSize.setText("Eviction Batch Size:");
        JPanel panCommunication = this.createCommunicationPanel();
        this.labDelayBetweenRetries.setText("Delay Between Retries:");
        this.chboxMemoryUsageEnable.setText("Memory Usage Control");
        JPanel panMemUtilization = this.createMemoryUtilizationPanel();
        JPanel standardCachePanel = this.createStandardCachePanel();
        JPanel lightCachePanel = this.createLightCachePanel();
        this.setLayout(this.gridBagLayout1);
        this.add((Component)this.labConfigName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 2, 2), 0, 0));
        this.add((Component)this.txtfConfigName, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 2, 2, 2), 0, 0));
        this.add((Component)this.chboxVersionedCache, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
        this.add((Component)this.labUpdatePolicy, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 0, 2), 0, 0));
        this.add((Component)this.txtUpdatePolicy, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)standardCachePanel, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)lightCachePanel, new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)panMemUtilization, new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)panCommunication, new GridBagConstraints(0, 8, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.txtfConfigName.setEditable(false);
        this.txtfMaxObjectsInCache.setEditable(false);
        this.txtfDelayBetweenRetries.setEditable(false);
        this.txtfRetryConnections.setEditable(false);
        this.txtfMaxObjectTimeout.setEditable(false);
        this.txtfHighWatermarkPercentage.setEditable(false);
        this.txtfLowWatermarkPercentage.setEditable(false);
        this.txtfEvictionBatchSize.setEditable(false);
        this.txtEvictionPolicy.setEditable(false);
        this.txtUpdatePolicy.setEditable(false);
        this.txtCompression.setEditable(false);
        this.txtEvictionStrategy.setEditable(false);
    }

    private JPanel createMemoryUtilizationPanel() {
        JPanel panMemUtilization = new JPanel();
        panMemUtilization.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "Memory Utilization"));
        panMemUtilization.setLayout(this.gridBagLayout2);
        panMemUtilization.add((Component)this.labMaxObjectsInCache, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 0, 2), 0, 0));
        panMemUtilization.add((Component)this.txtfMaxObjectsInCache, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 0), 0, 0));
        panMemUtilization.add((Component)this.labMaxObjectTimeout, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 2, new Insets(2, 2, 2, 2), 0, 0));
        panMemUtilization.add((Component)this.txtfMaxObjectTimeout, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 0), 0, 0));
        panMemUtilization.add((Component)this.chboxMemoryUsageEnable, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        panMemUtilization.add((Component)this.labHighWatermarkPercentage, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        panMemUtilization.add((Component)this.txtfHighWatermarkPercentage, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 0), 0, 0));
        panMemUtilization.add((Component)this.labLowWatermarkPercentage, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        panMemUtilization.add((Component)this.txtfLowWatermarkPercentage, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 0), 0, 0));
        panMemUtilization.add((Component)this.labEvictionBatchSize, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        panMemUtilization.add((Component)this.txtfEvictionBatchSize, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 0), 0, 0));
        return panMemUtilization;
    }

    private JPanel createCommunicationPanel() {
        JPanel panCommunication = new JPanel();
        Border border1 = BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142));
        TitledBorder titledBorder1 = new TitledBorder(border1, "Communication");
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        panCommunication.setBorder(titledBorder1);
        panCommunication.setLayout(gridBagLayout3);
        JLabel labRetryConnections = new JLabel();
        labRetryConnections.setText("Retry Connections:");
        panCommunication.add((Component)labRetryConnections, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        panCommunication.add((Component)this.txtfRetryConnections, new GridBagConstraints(1, 0, 1, 2, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 0), 0, 0));
        panCommunication.add((Component)this.labDelayBetweenRetries, new GridBagConstraints(0, 1, 1, 2, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        panCommunication.add((Component)this.txtfDelayBetweenRetries, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 0), 0, 0));
        return panCommunication;
    }

    private JPanel createStandardCachePanel() {
        JPanel standardCachePanel = new JPanel();
        Border border = BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142));
        TitledBorder titledBorder = new TitledBorder(border, "Standard Cache");
        GridBagLayout gridBagLayout = new GridBagLayout();
        standardCachePanel.setBorder(titledBorder);
        standardCachePanel.setLayout(gridBagLayout);
        JLabel labEvictionPolicy = new JLabel();
        labEvictionPolicy.setText("Eviction Policy:");
        standardCachePanel.add((Component)labEvictionPolicy, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        standardCachePanel.add((Component)this.txtEvictionPolicy, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        return standardCachePanel;
    }

    private JPanel createLightCachePanel() {
        JPanel lightCachePanel = new JPanel();
        Border border = BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142));
        TitledBorder titledBorder = new TitledBorder(border, "Light Cache");
        GridBagLayout gridBagLayout = new GridBagLayout();
        lightCachePanel.setBorder(titledBorder);
        lightCachePanel.setLayout(gridBagLayout);
        JLabel evictionStrategyLabel = new JLabel("Eviction Strategy:");
        JLabel compressionLabel = new JLabel("Compression:");
        lightCachePanel.add((Component)this.chBoxPutFirst, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 2, 0), 0, 0));
        lightCachePanel.add((Component)compressionLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 2, 2, 2), 0, 0));
        lightCachePanel.add((Component)this.txtCompression, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        lightCachePanel.add((Component)evictionStrategyLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 2, 2, 2), 0, 0));
        lightCachePanel.add((Component)this.txtEvictionStrategy, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        return lightCachePanel;
    }

    public void clean() {
        JSpaceUIUtils.cleanAWTContainer(this);
        this.txtfConfigName.setText("DefaultConfig");
    }

    public void setConfig(JSpaceAttributes config) {
        JSpaceAttributes dcacheProperties = config.getDCacheProperties();
        this.txtfConfigName.setText(config.getDCacheConfigName());
        this.txtfDelayBetweenRetries.setText(dcacheProperties.getProperty("space-config.dist-cache.delay-between-retries"));
        this.txtfMaxObjectsInCache.setText(dcacheProperties.getProperty("space-config.engine.cache_size"));
        this.txtfMaxObjectTimeout.setText(dcacheProperties.getProperty("space-config.dist-cache.max-object-timeout"));
        this.txtfHighWatermarkPercentage.setText(dcacheProperties.getProperty("space-config.engine.memory_usage.high_watermark_percentage"));
        this.txtfLowWatermarkPercentage.setText(dcacheProperties.getProperty("space-config.engine.memory_usage.low_watermark_percentage"));
        this.txtfRetryConnections.setText(dcacheProperties.getProperty("space-config.dist-cache.retry-connections"));
        this.chboxVersionedCache.setSelected(Boolean.parseBoolean(dcacheProperties.getProperty("space-config.dist-cache.versioned")));
        this.chboxMemoryUsageEnable.setSelected(Boolean.parseBoolean(dcacheProperties.getProperty("space-config.engine.memory_usage.enabled")));
        this.txtfEvictionBatchSize.setText(dcacheProperties.getProperty("space-config.engine.memory_usage.eviction_batch_size"));
        String putFirstProp = dcacheProperties.getProperty("space-config.dist-cache.put-first");
        this.chBoxPutFirst.setSelected(Boolean.parseBoolean(putFirstProp));
        this.initCompressionCombo(config);
        this.initEvictionStrategyClassCombo(config);
        this.setMemoryUsageCompEnable(this.chboxMemoryUsageEnable.isSelected());
        int index = 0;
        try {
            index = Integer.parseInt(dcacheProperties.getProperty("space-config.engine.cache_policy"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String cachePolicyVal = "";
        switch (index) {
            case 0: {
                cachePolicyVal = this.EVICTION_POLICY_LRU;
                break;
            }
            case 1: {
                cachePolicyVal = this.EVICTION_POLICY_ALL_IN_CACHE;
                break;
            }
            case 2: {
                cachePolicyVal = this.EVICTION_POLICY_CUSTOM;
                break;
            }
            case 3: {
                cachePolicyVal = this.EVICTION_POLICY_BLOB_STORE;
            }
        }
        this.txtEvictionPolicy.setText(cachePolicyVal);
        index = 0;
        try {
            index = Integer.parseInt(dcacheProperties.getProperty("space-config.dist-cache.update-mode"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.txtUpdatePolicy.setText(index == 1 ? this.UPDATE_POLICY_PULL : this.UPDATE_POLICY_PUSH);
    }

    private void initCompressionCombo(JSpaceAttributes config) {
        String compressionStr = config.getDCacheProperties().getProperty("space-config.dist-cache.compression");
        if (compressionStr == null) {
            return;
        }
        int compressionType = Integer.parseInt(compressionStr);
        switch (compressionType) {
            case 0: {
                this.txtCompression.setText("None");
                break;
            }
            case 1: {
                this.txtCompression.setText("Zip");
            }
        }
    }

    private void initEvictionStrategyClassCombo(JSpaceAttributes config) {
        String evictionStartegyStr = config.getDCacheProperties().getProperty("space-config.dist-cache.eviction-strategy");
        this.txtEvictionStrategy.setText(evictionStartegyStr);
    }
}

