/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.gigaspaces.admin.ui.util.EscapeDialog;
import com.j_spaces.core.client.CacheException;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class ExceptionDialog
extends EscapeDialog {
    private JTextArea expTextArea = new JTextArea();
    private JTextPane detailTextArea = new JTextPane();
    private JButton detailButton = new JButton();
    private JButton closeButton = new JButton();
    private JPanel buttonPanel = new JPanel();
    private JPanel detailPanel = new JPanel();
    private JPanel bigExcPanel = new JPanel();
    private JPanel excepPanel = new JPanel();
    private JPanel mainPanel = new JPanel();
    private Border border1;
    private JLabel icon = new JLabel();
    private Component parent;
    private static final int DEFAULT_HEIGHT = 400;
    private static final int DEFAULT_WIDTH = 450;

    public ExceptionDialog(Component parent, String resourceDir) throws Exception {
        super((JFrame)parent, "Error Message", false);
        this.jbInit(resourceDir);
        this.setSize(450, this.getSize().height);
    }

    private void jbInit(String resourceDir) throws Exception {
        this.border1 = BorderFactory.createEmptyBorder();
        this.excepPanel.setLayout(new BorderLayout());
        this.getContentPane().setLayout(new BorderLayout());
        ImageIcon expIcon = new ImageIcon(this.getClass().getResource(resourceDir + "/exceptionIcon.gif"));
        this.icon.setIcon(expIcon);
        this.excepPanel.setBorder(BorderFactory.createCompoundBorder(new TitledBorder("Exception Information"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this.mainPanel.setLayout(new BorderLayout());
        this.expTextArea.setEditable(false);
        this.expTextArea.setFont(new Font("Dialog", 1, 12));
        this.expTextArea.setBorder(this.border1);
        this.expTextArea.setWrapStyleWord(true);
        this.expTextArea.setLineWrap(true);
        this.expTextArea.setRows(4);
        Dimension textAreaSize = new Dimension(750, 50);
        this.expTextArea.setPreferredSize(textAreaSize);
        this.expTextArea.setMaximumSize(textAreaSize);
        this.detailButton.setText("Details...");
        this.detailTextArea.setBorder(BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(124, 124, 124), new Color(178, 178, 178)));
        this.detailTextArea.setText("Stack Trace...");
        this.detailTextArea.setEditable(false);
        this.detailPanel.setLayout(new BorderLayout());
        this.detailPanel.setBorder(new TitledBorder("Details Information"));
        this.bigExcPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.buttonPanel.add((Component)this.detailButton, null);
        this.buttonPanel.add((Component)this.closeButton, null);
        this.detailPanel.add((Component)new JScrollPane(this.detailTextArea), "Center");
        this.mainPanel.add((Component)this.bigExcPanel, "North");
        this.bigExcPanel.add((Component)this.excepPanel, "North");
        this.bigExcPanel.add((Component)this.buttonPanel, "East");
        this.excepPanel.add((Component)this.expTextArea, "Center");
        this.excepPanel.add((Component)this.icon, "East");
        this.closeButton.setText("Close");
        this.setResizable(false);
        this.detailButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExceptionDialog.this.pressDetailButton();
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExceptionDialog.this.pressCloseButton();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent wEvent) {
                ExceptionDialog.this.pressCloseButton();
            }
        });
    }

    private void showAdvancePanel() {
        if (!this.mainPanel.isAncestorOf(this.detailPanel)) {
            this.setResizable(true);
            this.setSize(this.getSize().width, 400);
            this.mainPanel.add((Component)this.detailPanel, "Center");
        } else {
            this.setResizable(false);
            Dimension prevSize = this.getSize();
            this.mainPanel.remove(this.detailPanel);
            this.pack();
            this.setSize(prevSize.width, this.getSize().height);
        }
        this.validate();
    }

    public void showException(String stepName, Throwable throwable) {
        this.showException(" Exception occured during ", stepName, throwable);
    }

    public void showException(String messagePrefix, String stepName, Throwable throwable) {
        if (throwable instanceof CacheException) {
            CacheException throwableTemp = (CacheException)throwable;
            throwable = throwableTemp.getCause();
            this.detailTextArea.setText("CacheException" + throwable.getMessage() + " " + JSpaceUtilities.getStackTrace((Throwable)throwable));
        } else {
            this.detailTextArea.setText(JSpaceUtilities.getStackTrace((Throwable)throwable));
        }
        this.expTextArea.setText(messagePrefix + stepName + ".   \n For more information press 'Details...' button.   ");
        JSpaceUIUtils.setLocationRelativeTo(this, this.parent);
        this.pack();
        this.setVisible(true);
    }

    void pressDetailButton() {
        this.showAdvancePanel();
    }

    void pressCloseButton() {
        this.setResizable(false);
        Dimension prevSize = this.getSize();
        this.dispose();
        this.mainPanel.remove(this.detailPanel);
        this.setSize(prevSize);
    }
}

