/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.TransactionInfo;
import com.j_spaces.core.client.UnderTxnLockedObject;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import org.pf.joi.Inspector;

public class LockedObjectsViewPanel
extends JPanel {
    private JFrame _parentFrame;
    private JTable _objectsTable;
    private LockedObjectsTableModel _objectsTableModel;
    private IJSpace _selSpaceProxy;
    private Object _selTransactionID;
    private static final int CI_UID = 0;
    private static final int CI_CLASS_NAME = 1;
    private static final int CI_OPERATION_TYPE = 2;
    private static final int CI_LOCK_TYPE = 3;
    private JTextField _transactionIDField = new JTextField();
    private JTextField _transactionTypeField = new JTextField();
    private JTextField _transactionStatusField = new JTextField();
    private JTextField _lockedObjectsAmountField = new JTextField();
    private Object obj;

    public LockedObjectsViewPanel(JFrame parentFrame) {
        this._parentFrame = parentFrame;
        this.initUI();
    }

    private void initUI() {
        this._objectsTableModel = new LockedObjectsTableModel();
        this._objectsTable = new JTable(this._objectsTableModel);
        JTableHeader header = this._objectsTable.getTableHeader();
        header.setReorderingAllowed(false);
        this._objectsTable.setAutoCreateColumnsFromModel(false);
        this._objectsTable.setSelectionMode(0);
        this._objectsTable.setAutoResizeMode(1);
        this._objectsTable.setAutoscrolls(true);
        TableColumnModel tableColummModel = this._objectsTable.getColumnModel();
        tableColummModel.getColumn(2).setPreferredWidth(100);
        tableColummModel.getColumn(3).setPreferredWidth(100);
        tableColummModel.getColumn(1).setPreferredWidth(400);
        tableColummModel.getColumn(0).setPreferredWidth(200);
        JScrollPane tableScrollPane = new JScrollPane(this._objectsTable);
        Box northBox = this.createLabelsNorthBox();
        this.setLayout(new BorderLayout());
        this.add((Component)northBox, "North");
        this.add((Component)tableScrollPane, "Center");
        this.addMouseListenerToTable();
        this.setPreferredSize(new Dimension(500, 80));
    }

    private Box createLabelsNorthBox() {
        this._transactionIDField.setEditable(false);
        this._lockedObjectsAmountField.setEditable(false);
        this._transactionStatusField.setEditable(false);
        this._transactionTypeField.setEditable(false);
        Dimension fieldSize = new Dimension(180, 21);
        this._transactionIDField.setPreferredSize(fieldSize);
        this._lockedObjectsAmountField.setPreferredSize(fieldSize);
        this._transactionStatusField.setPreferredSize(fieldSize);
        this._transactionTypeField.setPreferredSize(fieldSize);
        Box northBox = new Box(1);
        JLabel transactionIdLabel = new JLabel("Transaction ID:");
        JLabel lockedObjectsAmountLabel = new JLabel("Locked Objects:");
        JLabel transactionTypeLabel = new JLabel("Type:");
        JLabel transactionStatusLabel = new JLabel("Status:");
        Dimension labelSize1 = new Dimension(105, 21);
        Dimension labelSize2 = new Dimension(45, 21);
        transactionIdLabel.setPreferredSize(labelSize1);
        lockedObjectsAmountLabel.setPreferredSize(labelSize1);
        transactionTypeLabel.setPreferredSize(labelSize2);
        transactionStatusLabel.setPreferredSize(labelSize2);
        Box firstHorizBox = new Box(0);
        Box secondHorizBox = new Box(0);
        firstHorizBox.add(Box.createHorizontalStrut(3));
        firstHorizBox.add(transactionIdLabel);
        firstHorizBox.add(Box.createHorizontalStrut(3));
        firstHorizBox.add(this._transactionIDField);
        firstHorizBox.add(Box.createHorizontalStrut(10));
        firstHorizBox.add(transactionStatusLabel);
        firstHorizBox.add(Box.createHorizontalStrut(3));
        firstHorizBox.add(this._transactionStatusField);
        firstHorizBox.add(Box.createHorizontalStrut(5));
        secondHorizBox.add(Box.createHorizontalStrut(3));
        secondHorizBox.add(lockedObjectsAmountLabel);
        secondHorizBox.add(Box.createHorizontalStrut(3));
        secondHorizBox.add(this._lockedObjectsAmountField);
        secondHorizBox.add(Box.createHorizontalStrut(10));
        secondHorizBox.add(transactionTypeLabel);
        secondHorizBox.add(Box.createHorizontalStrut(3));
        secondHorizBox.add(this._transactionTypeField);
        secondHorizBox.add(Box.createHorizontalStrut(5));
        northBox.add(Box.createVerticalStrut(4));
        northBox.add(firstHorizBox);
        northBox.add(Box.createVerticalStrut(4));
        northBox.add(secondHorizBox);
        northBox.add(Box.createVerticalStrut(4));
        return northBox;
    }

    public void clear() {
        this._transactionIDField.setText("");
        this._transactionTypeField.setText("");
        this._transactionStatusField.setText("");
        this._lockedObjectsAmountField.setText("");
        this._selTransactionID = null;
        this._objectsTableModel.clear();
    }

    private void addMouseListenerToTable() {
        this._objectsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    int clickedRow = LockedObjectsViewPanel.this._objectsTable.rowAtPoint(event.getPoint());
                    UnderTxnLockedObject lockedObject = LockedObjectsViewPanel.this._objectsTableModel.getLockedObjectAt(clickedRow);
                    if (lockedObject != null) {
                        final Object uid = lockedObject.getUid();
                        LockedObjectsViewPanel.this.obj = null;
                        try {
                            LockedObjectsViewPanel.this.obj = JSpaceUtilities.getObjectFromSpaceByUid((IJSpace)LockedObjectsViewPanel.this._selSpaceProxy, (String)uid.toString());
                        }
                        catch (ClassNotFoundException nfe) {
                            JOptionPane.showMessageDialog(LockedObjectsViewPanel.this._parentFrame, "The following class was not found. Please add it to the classpath:" + JSpaceUtilities.LINE_SEPARATOR + nfe.getMessage(), "Class Not Found", 2);
                            return;
                        }
                        catch (Exception e) {
                            SpaceBrowser.showException(e.toString(), e);
                            return;
                        }
                        if (LockedObjectsViewPanel.this.obj == null) {
                            JOptionPane.showMessageDialog(LockedObjectsViewPanel.this._parentFrame, "Unable to inspect object. It can not be found, probably was already been removed from the space.", "Object not found", 1);
                            return;
                        }
                        final String className = LockedObjectsViewPanel.this.obj.getClass().getName();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    LockedObjectsViewPanel.this._parentFrame.setCursor(Cursor.getPredefinedCursor(3));
                                    Inspector.inspect(uid.toString(), LockedObjectsViewPanel.this.obj, null, className);
                                }
                                finally {
                                    LockedObjectsViewPanel.this._parentFrame.setCursor(Cursor.getPredefinedCursor(0));
                                }
                            }
                        });
                    }
                }
            }
        });
    }

    public void displayLockedObjects(IJSpace spaceProxy, List<UnderTxnLockedObject> lockedObjectList, TransactionInfo selectedTransactionInfo) {
        this._selSpaceProxy = spaceProxy;
        this._selTransactionID = selectedTransactionInfo.getTxnId();
        this._transactionIDField.setText(selectedTransactionInfo.getTxnId().toString());
        this._lockedObjectsAmountField.setText(String.valueOf(lockedObjectList.size()));
        int transactionStatus = selectedTransactionInfo.getStatus();
        int transactionType = selectedTransactionInfo.getType();
        this._transactionTypeField.setText(JSpaceUtilities.getTransactionTypeName((int)transactionType));
        this._transactionStatusField.setText(JSpaceUtilities.getTransactionStatusName((int)transactionStatus));
        this._objectsTableModel.setLockedObjectsList(lockedObjectList);
    }

    public Object getSelectedTransactionID() {
        return this._selTransactionID;
    }

    private class LockedObjectsTableModel
    extends DefaultTableModel {
        private String[] columnNames = new String[]{"UID", "Class Name", "Operation Type", "Lock Type"};
        private List<UnderTxnLockedObject> _lockedObjectsList = new ArrayList<UnderTxnLockedObject>();

        private LockedObjectsTableModel() {
        }

        public void clear() {
            int listSize = this._lockedObjectsList.size();
            if (listSize > 0) {
                this._lockedObjectsList.clear();
                this.fireTableRowsDeleted(0, listSize - 1);
            }
        }

        @Override
        public Object getValueAt(int row, int column) {
            UnderTxnLockedObject lockedObjectInfo = null;
            if (row >= 0 && row < this._lockedObjectsList.size() && (lockedObjectInfo = this._lockedObjectsList.get(row)) != null) {
                return this.getCellValue(lockedObjectInfo, column);
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public Class getColumnClass(int columnIndex) {
            Object obj = this.getValueAt(0, columnIndex);
            if (obj != null) {
                return obj.getClass();
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this._lockedObjectsList == null ? 0 : this._lockedObjectsList.size();
        }

        public List<UnderTxnLockedObject> getLockedObjectsList() {
            return this._lockedObjectsList;
        }

        public UnderTxnLockedObject getLockedObjectAt(int row) {
            return this._lockedObjectsList.get(row);
        }

        public String getCellValue(UnderTxnLockedObject lockedObject, int column) {
            switch (column) {
                case 0: {
                    return String.valueOf(lockedObject.getUid());
                }
                case 1: {
                    return String.valueOf(lockedObject.getClassName());
                }
                case 3: {
                    return JSpaceUtilities.getTransactionLockTypeName((UnderTxnLockedObject)lockedObject);
                }
                case 2: {
                    return JSpaceUtilities.getTransactionLockOperationTypeName((UnderTxnLockedObject)lockedObject);
                }
            }
            return "";
        }

        public void setLockedObjectsList(List<UnderTxnLockedObject> lockedObjectsList) {
            int initialListSize1 = this._lockedObjectsList.size();
            int initialListSize2 = lockedObjectsList.size();
            if (initialListSize1 > 0) {
                this.fireTableRowsDeleted(0, initialListSize1 - 1);
            }
            this._lockedObjectsList = lockedObjectsList;
            if (initialListSize2 > 0) {
                this.fireTableRowsInserted(0, initialListSize2 - 1);
            }
        }
    }
}

