/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

class MenuWithIcon
extends JMenuItem {
    static char mnemonics = (char)32;

    public MenuWithIcon(String text, String iconName) {
        char mnem = MenuWithIcon.getMnemonics(text);
        if (mnem != mnemonics) {
            this.setMnemonic(mnem);
        }
        this.setText(MenuWithIcon.getMenuNameWithoutMnemonicsChar(text));
        URL url = this.getClass().getResource("/image/browser/" + iconName);
        if (url != null) {
            this.setIcon(new ImageIcon(url));
        }
        if (mnem != mnemonics) {
            KeyStroke ks = KeyStroke.getKeyStroke((int)Character.toUpperCase(mnem), 2);
            this.setAccelerator(ks);
        }
    }

    public static char getMnemonics(String text) {
        char mnem = ' ';
        int idx = text.indexOf("&");
        if (idx != -1) {
            mnem = text.charAt(idx + 1);
        }
        return mnem;
    }

    public static String getMenuNameWithoutMnemonicsChar(String menuName) {
        int idx = 0;
        idx = menuName.indexOf("&");
        if (idx != -1) {
            menuName = new StringBuilder(menuName).deleteCharAt(idx).toString();
        }
        return menuName;
    }
}

