/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.gigaspaces.admin.ui.util.UIHelper;
import com.gigaspaces.start.SystemInfo;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.utils.FindTextComponent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.UIManager;

public class ShowDumpResultsFrame
extends JFrame {
    private final JTextArea textArea = new JTextArea();
    private final JScrollPane scrollPane = new JScrollPane(this.textArea);
    private final JButton saveAsButton = new JButton("Save As...");
    private final FindTextComponent _findTextComponent = new FindTextComponent(this.textArea);
    private JFileChooser fileChooser;
    private String curContainerName;

    public ShowDumpResultsFrame() {
        this.init();
        this.setSize(750, 450);
    }

    private void init() {
        this.setIconImage(UIHelper.getImageIcon("image/browser/jspacesIcon.png").getImage());
        this.textArea.setEditable(false);
        this.textArea.setFont(UIManager.getFont("JTextField.font"));
        this.getContentPane().add((Component)this.scrollPane, "Center");
        Box closeButtonBox = this.createCloseButtonBox();
        this.getContentPane().add((Component)closeButtonBox, "South");
        this.getContentPane().add((Component)this._findTextComponent, "North");
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.getKeyCode() == 27) {
                    ShowDumpResultsFrame.this.setVisible(false);
                }
            }
        });
    }

    private Box createCloseButtonBox() {
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ShowDumpResultsFrame.this.setVisible(false);
            }
        });
        this.saveAsButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent event) {
                if (ShowDumpResultsFrame.this.fileChooser == null) {
                    ShowDumpResultsFrame.this.fileChooser = new JFileChooser(SystemInfo.singleton().getXapHome());
                }
                ShowDumpResultsFrame.this.curContainerName = ShowDumpResultsFrame.this.curContainerName.replace(':', '_');
                ShowDumpResultsFrame.this.fileChooser.setSelectedFile(new File(ShowDumpResultsFrame.this.curContainerName + ".txt"));
                int returnVal = ShowDumpResultsFrame.this.fileChooser.showSaveDialog(ShowDumpResultsFrame.this);
                if (returnVal == 0) {
                    File selFile = ShowDumpResultsFrame.this.fileChooser.getSelectedFile();
                    try {
                        ShowDumpResultsFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                        FileOutputStream fos = new FileOutputStream(selFile);
                        fos.write(ShowDumpResultsFrame.this.textArea.getText().getBytes());
                        fos.flush();
                        fos.close();
                    }
                    catch (Exception e) {
                        SpaceBrowser.showException(e.toString(), e);
                    }
                    finally {
                        ShowDumpResultsFrame.this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            }
        });
        JToolBar closeToolBar = new JToolBar();
        closeToolBar.setFloatable(false);
        closeToolBar.setRollover(true);
        closeToolBar.setBorderPainted(false);
        closeToolBar.add(this.saveAsButton);
        closeToolBar.add(Box.createHorizontalStrut(10));
        closeToolBar.add(closeButton);
        Box closeButtonBox = new Box(0);
        Box vertBox = new Box(1);
        vertBox.add(Box.createVerticalStrut(2));
        vertBox.add(closeToolBar);
        vertBox.add(Box.createVerticalStrut(2));
        closeButtonBox.add(Box.createHorizontalGlue());
        closeButtonBox.add(vertBox);
        closeButtonBox.add(Box.createHorizontalGlue());
        return closeButtonBox;
    }

    public void setDump(String dump, String containerName) {
        this.curContainerName = containerName;
        this.textArea.setText(dump);
        this.textArea.select(0, 0);
        this.setTitle("Configuration report results for <" + containerName + ">");
    }
}

