/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.gigaspaces.admin.security.AuthenticationListener;
import com.gigaspaces.admin.security.SecurityServicesRepository;
import com.gigaspaces.admin.ui.AdminUIThreadPool;
import com.gigaspaces.admin.ui.IServiceGridUIComponent;
import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.admin.ui.ResourceBundleHandler;
import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.grid.views.NoPermissionsView;
import com.gigaspaces.cluster.activeelection.InactiveSpaceException;
import com.gigaspaces.cluster.activeelection.SpaceMode;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.cluster.SpaceClusterInfo;
import com.gigaspaces.internal.jmx.JMXUtilities;
import com.gigaspaces.security.Authentication;
import com.gigaspaces.security.authorities.MonitorAuthority;
import com.gigaspaces.security.authorities.Privilege;
import com.gigaspaces.security.authorities.SpaceAuthority;
import com.gigaspaces.security.service.SecuredService;
import com.gigaspaces.server.space.suspend.SuspendInfo;
import com.gigaspaces.server.space.suspend.SuspendType;
import com.gigaspaces.start.SystemInfo;
import com.j_spaces.core.Constants;
import com.j_spaces.core.CreateException;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.IJSpaceContainer;
import com.j_spaces.core.NoSuchNameException;
import com.j_spaces.core.admin.ContainerConfig;
import com.j_spaces.core.admin.IInternalRemoteJSpaceAdmin;
import com.j_spaces.core.admin.IJSpaceContainerAdmin;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.LostConnectionException;
import com.j_spaces.core.admin.RuntimeHolder;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.client.JSpaceContainerProxyWrapper;
import com.j_spaces.core.client.JSpaceProxyWrapper;
import com.j_spaces.core.cluster.ClusterMemberInfo;
import com.j_spaces.examples.benchmark.BenchmarkListener;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.IServiceManager;
import com.j_spaces.tools.LookupServiceListener;
import com.j_spaces.tools.PrimaryBackupIndicationListener;
import com.j_spaces.tools.cluster.EditCluster;
import com.j_spaces.tools.cluster.FileFilterExt;
import com.j_spaces.tools.cluster.view.ClusterTree;
import com.j_spaces.tools.cluster.view.ClusterViewDlg;
import com.j_spaces.tools.cluster.view.ServiceManagerImpl;
import com.j_spaces.tools.spacebrowser.AddressBarDialog;
import com.j_spaces.tools.spacebrowser.ButtonWithFixedTooltip;
import com.j_spaces.tools.spacebrowser.ClusterConnectionsPanel;
import com.j_spaces.tools.spacebrowser.ClusterSpaceRuntimePanel;
import com.j_spaces.tools.spacebrowser.ClusterTransactionsPanel;
import com.j_spaces.tools.spacebrowser.ContainerConfigPanel;
import com.j_spaces.tools.spacebrowser.ExceptionDialog;
import com.j_spaces.tools.spacebrowser.ISpacesView;
import com.j_spaces.tools.spacebrowser.MenuWithIcon;
import com.j_spaces.tools.spacebrowser.ProgressMonitorBar;
import com.j_spaces.tools.spacebrowser.ShowDumpResultsFrame;
import com.j_spaces.tools.spacebrowser.SpaceConfigPanel;
import com.j_spaces.tools.spacebrowser.SpaceConnectionsPanel;
import com.j_spaces.tools.spacebrowser.SpaceRuntimePanel;
import com.j_spaces.tools.spacebrowser.SpaceTransactionsPanel;
import com.j_spaces.tools.spacebrowser.SpaceTreeNode;
import com.j_spaces.tools.spacebrowser.SpacesViewPanel;
import com.j_spaces.tools.spacebrowser.SrvManager;
import com.j_spaces.tools.spacebrowser.StaleContainerService;
import com.j_spaces.tools.spacebrowser.StaleServiceCleanerThread;
import com.j_spaces.tools.spacebrowser.StaleSpaceService;
import com.j_spaces.tools.spacebrowser.benchmark.BenchMarkPanel;
import com.j_spaces.tools.spacebrowser.benchmark.BenchMarkPanelFactory;
import com.j_spaces.tools.spacebrowser.benchmark.ClusterBenchMarkPanel;
import com.j_spaces.tools.spacebrowser.statistics.ClusterStatisticPanel;
import com.j_spaces.tools.spacebrowser.statistics.StatisticPanel;
import com.j_spaces.tools.spacebrowser.statistics.space_operations.SpaceColorMap;
import com.j_spaces.tools.spacebrowser.utils.IconsRepository;
import com.j_spaces.tools.spacebrowser.utils.JConsoleUIUtils;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import com.j_spaces.tools.spacebrowser.utils.ProgressThread;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.RootWindow;
import net.infonode.docking.SplitWindow;
import net.infonode.docking.View;
import net.infonode.docking.properties.RootWindowProperties;
import net.infonode.docking.theme.ShapedGradientDockingTheme;
import net.infonode.docking.util.AbstractViewMap;
import net.infonode.docking.util.DockingUtil;
import net.infonode.docking.util.ViewMap;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.ui.MainFrame;
import org.w3c.dom.Document;

public class SpaceBrowser
implements Constants.LookupManager,
ActionListener,
AuthenticationListener,
BenchmarkListener {
    protected Vector<JComponent> spaceEnableComp;
    protected Vector<JComponent> containerEnableComp;
    private DefaultMutableTreeNode curSelectedNode;
    private TreePath curSelPath;
    private ViewMap viewMap;
    private StaleServiceCleanerThread m_StaleServiceCleaner;
    private final Map<DefaultMutableTreeNode, String> m_containerMutableNode;
    private final Hashtable<ServiceID, DefaultMutableTreeNode> m_serviceIDtable;
    final Hashtable<Object, DefaultMutableTreeNode> m_proxyServiceTable;
    private static final String TOOLBAR_ICONS = "toolbar.icons";
    private static final String TOOLBAR_TIPS = "toolbar.tips";
    private static final String CONTAINER_MENU = "container.menu";
    private static final String CONTAINER_MENU_ICON = "container.menu.icon";
    private static final String SPACE_MENU = "space.menu";
    private static final String SPACE_MENU_ICON = "space.menu.icon";
    private static final String SPACE_CONFIG = "space.config";
    private static final String CONFIG_LABEL = "config.label";
    public static final String CLASSES_LABEL = "Data Types";
    public static final String TRANSACTIONS_LABEL = "Transactions";
    public static final String SQL_LABEL = "Query";
    public static final String STATISTICS_LABEL = "Statistics";
    public static final String CONNECTIONS_LABEL = "Connections";
    public static final String BENCHMARK_LABEL = "Benchmark";
    public static final String OPERATIONS_NODE_LABEL = "Operations";
    private static final String SPACES_LABEL = "Spaces";
    public static final String CLUSTER_ROOT = "Clusters";
    public static final String SELECT = "SELECT * FROM SYSTABLES";
    public static final String QUERY_CLUSTER_LIMIT = " WHERE rownum<5000";
    public static final String PERSISTENT_LRU_MENU_ITEM_NAME = "Display Persistent LRU Space Metrics";
    public static final String SAVE_LOCATORS_MENU_ITEM_NAME = "Save Locators Details";
    public static final String MESSAGE_OBJECT_DOES_NOT_EXIST = "Unable to inspect object. It can not be found, probably was already been removed from the space.";
    public static final SpaceAuthority.SpacePrivilege[] SPACE_PRIVILIGIES = new SpaceAuthority.SpacePrivilege[]{SpaceAuthority.SpacePrivilege.ALTER, SpaceAuthority.SpacePrivilege.EXECUTE, SpaceAuthority.SpacePrivilege.READ, SpaceAuthority.SpacePrivilege.TAKE, SpaceAuthority.SpacePrivilege.WRITE, SpaceAuthority.SpacePrivilege.CREATE};
    ImageIcon QUESTION_ICON;
    ImageIcon EXCEPTION_ICON;
    String localhost;
    private SpaceTreeNode selectedSpaceNode;
    private final Map<Object, StatisticPanel> statisticsPerSpace;
    private final Map<String, ClusterStatisticPanel> statisticsPerCluster;
    private final Map<String, BenchMarkPanel> benchmarkPanelsPerCluster;
    private final Map<String, Set<IJSpace>> _allClusteredSpaces;
    private final Map<String, DefaultMutableTreeNode> _availableClusteredSpaceTreeNodeMap;
    private final Map<IJSpaceContainer, String> _rmiContainersMap;
    private final SpaceBrowserMainContainer mainContainer;
    private final JPanel mainConfigPanel;
    public static ExceptionDialog expDialog;
    private SpaceRuntimePanel runtimePanel;
    private SpaceTransactionsPanel spaceTransactionsPanel;
    private SpaceConnectionsPanel spaceConnectionsPanel;
    private ClusterTransactionsPanel clusterTransactionPanel;
    private ClusterSpaceRuntimePanel clusterRuntimePanel;
    private ClusterConnectionsPanel clusterConnectionsPanel;
    private NoPermissionsView noMonitorPUPermissionsView;
    private NoPermissionsView noSpacePermissionsView;
    ContainerConfigPanel containerConfigPanel;
    SpaceConfigPanel spaceConfigPanel;
    private SpacesViewPanel spacesViewPanel;
    private JButton pingButton;
    private JLabel _statusBar;
    private final JLabel configLabel;
    private final JTextArea configText;
    JTree conTree;
    private DefaultTreeModel conTreeModel;
    private final BorderLayout mainConBorderLayout;
    private final BorderLayout configConBorderLayout;
    private final JPopupMenu popupTree;
    private final JPopupMenu clusterManagementPopupMenu;
    private JMenuItem showDumpPopupMenuItem;
    private JMenuItem launchJConsoleMenuItem;
    private JMenuItem launchJVisualVmMenuItem;
    private JMenuItem closeClusterMenuItem;
    JMenu spaceMenu;
    private JMenuItem pingMenuItem;
    JMenuItem pingPopupMenuItem;
    private ClusterViewDlg _clusterViewApplications;
    private ClusterViewDlg _clusterViewBrowser;
    JFileChooser m_fileChooser;
    IServiceManager m_srvManager;
    private MainFrame _iSQLPane;
    private static SpaceBrowser instance;
    public static final String PROP_SPACE_NETWORK_VIEW_COLUMNS = "SPACES_NETWORK_VIEW_COLUMNS";
    private static final Hashtable<String, DefaultMutableTreeNode> containerTreeNodeTable;
    private final Map<ServiceID, String> _mirrorSpacesMap;
    private final DefaultMutableTreeNode spacesRoot;
    private final DefaultMutableTreeNode clusterRoot;
    private ShowDumpResultsFrame dumpResultsFrame;
    private EditCluster currentCluster;
    private static Logger _logger;
    private JMenu[] _menusArray;
    private JButton[] _toolbarButtonsArray;
    private MainUI _parentFrame;
    private View treeView;
    private View serviceView;
    private RootWindowProperties rootWindowProperties;
    private RootWindow rootWindow;
    private String _calculatedJavaHome;
    private List<String> spacesViewColumnNames;
    private LookupServiceListener sdmListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SpaceBrowser(MainUI parentFrame, ClusterViewDlg clusterViewApplications) {
        block14: {
            this.m_containerMutableNode = new HashMap<DefaultMutableTreeNode, String>();
            this.m_serviceIDtable = new Hashtable();
            this.m_proxyServiceTable = new Hashtable();
            this.selectedSpaceNode = null;
            this.statisticsPerSpace = new Hashtable<Object, StatisticPanel>();
            this.statisticsPerCluster = new Hashtable<String, ClusterStatisticPanel>();
            this.benchmarkPanelsPerCluster = new Hashtable<String, BenchMarkPanel>();
            this._allClusteredSpaces = new Hashtable<String, Set<IJSpace>>();
            this._availableClusteredSpaceTreeNodeMap = new HashMap<String, DefaultMutableTreeNode>(1);
            this._rmiContainersMap = new Hashtable<IJSpaceContainer, String>();
            this.mainContainer = new SpaceBrowserMainContainer();
            this.mainConfigPanel = new JPanel();
            this._statusBar = new JLabel();
            this.configLabel = new JLabel();
            this.configText = new JTextArea();
            this.mainConBorderLayout = new BorderLayout();
            this.configConBorderLayout = new BorderLayout();
            this.popupTree = new JPopupMenu();
            this.clusterManagementPopupMenu = new JPopupMenu();
            this._mirrorSpacesMap = new HashMap<ServiceID, String>(1);
            this.spacesRoot = new DefaultMutableTreeNode(SPACES_LABEL);
            this.clusterRoot = new DefaultMutableTreeNode(CLUSTER_ROOT);
            this.currentCluster = null;
            this.sdmListener = null;
            SpaceBrowser.prepareRmiGC();
            try {
                this._parentFrame = parentFrame;
                this._clusterViewApplications = clusterViewApplications;
                URL questionIconName = this.getClass().getResource("/image/cluster-wizard/question.gif");
                URL exceptionIconName = this.getClass().getResource("/image/browser/exceptionIcon.gif");
                this.QUESTION_ICON = new ImageIcon(questionIconName);
                this.EXCEPTION_ICON = new ImageIcon(exceptionIconName);
                this.jbInit();
                Properties serializing = new Properties();
                try {
                    serializing = Repository.getInstance().getProperties();
                    String spacesNetworkViewColumns = (String)serializing.get(PROP_SPACE_NETWORK_VIEW_COLUMNS);
                    this.spacesViewColumnNames = new ArrayList<String>(5);
                    if (spacesNetworkViewColumns != null) {
                        StringTokenizer strTokenizer = new StringTokenizer(spacesNetworkViewColumns, ";", false);
                        while (strTokenizer.hasMoreTokens()) {
                            String columnName = strTokenizer.nextToken();
                            this.spacesViewColumnNames.add(columnName);
                        }
                        if (!this.spacesViewColumnNames.get(0).equals("\u00a0")) {
                            this.spacesViewColumnNames.add(0, "\u00a0");
                        }
                    }
                    if (this.spacesViewColumnNames.size() == 0) {
                        for (String columnName : ISpacesView.DEFAULT_COLUMN_NAMES) {
                            this.spacesViewColumnNames.add(columnName);
                        }
                    }
                }
                catch (Exception e) {
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, e.toString(), e);
                    }
                }
                finally {
                    this.spacesViewPanel.setColumnNames(this.spacesViewColumnNames);
                }
                this.setSelectedTreeNode(this.spacesRoot, true, false);
                this.discoveryListenerInit();
                this.m_StaleServiceCleaner = new StaleServiceCleanerThread(this);
                new Thread((Runnable)this.m_StaleServiceCleaner, "GS-UI-stale-service-cleaner").start();
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block14;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
        SecurityServicesRepository.getInstance().addAuthenticationListener(this);
        this._clusterViewApplications.setSpaceBrowser(this);
    }

    public static void addTreeNodeToContainerTreeNodeTable(DefaultMutableTreeNode treeNode, String containerDisplayName) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("-- ADD container node to map for container: " + containerDisplayName);
        }
        containerTreeNodeTable.put(containerDisplayName, treeNode);
    }

    public static DefaultMutableTreeNode removeTreeNodeFromContainerTreeNodeTable(String containerDisplayName) {
        return containerTreeNodeTable.remove(containerDisplayName);
    }

    public static SpaceBrowser getInstance() {
        return instance;
    }

    public MainUI getParentFrame() {
        return this._parentFrame;
    }

    public SpaceTreeNode getSelectedSpaceNode() {
        return this.selectedSpaceNode;
    }

    public DatabaseConnection getClusterDBConnection(String clusterName) {
        DefaultMutableTreeNode spaceTreeNode = this._availableClusteredSpaceTreeNodeMap.get(clusterName);
        IJSpace[] curClusterSpaceProxies = this._clusterViewBrowser.getServiceManager().getClusterMemberProxies(clusterName, false);
        int index = 0;
        if (_logger.isLoggable(Level.FINER)) {
            _logger.log(Level.FINER, "getClusterDBConnection(), curClusterSpaceProxies length=" + curClusterSpaceProxies.length + ", spaceTreeNode=" + spaceTreeNode);
        }
        while (spaceTreeNode == null || !(spaceTreeNode.getUserObject() instanceof SpaceTreeNode) || ((SpaceTreeNode)spaceTreeNode.getUserObject()).getSpaceMode() == 3) {
            if (_logger.isLoggable(Level.FINER)) {
                _logger.log(Level.FINER, "Within while, spaceTreeNode=" + spaceTreeNode);
            }
            if (index >= curClusterSpaceProxies.length) break;
            spaceTreeNode = this.m_proxyServiceTable.get(curClusterSpaceProxies[index++]);
            if (!_logger.isLoggable(Level.FINER)) continue;
            _logger.log(Level.FINER, "Within while, spaceTreeNode=" + spaceTreeNode);
            if (spaceTreeNode == null || !(spaceTreeNode.getUserObject() instanceof SpaceTreeNode)) continue;
            _logger.log(Level.FINER, "Within while, spaceMode=" + ((SpaceTreeNode)spaceTreeNode.getUserObject()).getSpaceMode());
        }
        if (!this._availableClusteredSpaceTreeNodeMap.containsKey(clusterName) && spaceTreeNode != null) {
            this._availableClusteredSpaceTreeNodeMap.put(clusterName, spaceTreeNode);
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.log(Level.FINER, "getClusterDBConnection, Before return spaceTreeNode=" + spaceTreeNode);
        }
        if (spaceTreeNode == null && _logger.isLoggable(Level.WARNING)) {
            _logger.log(Level.WARNING, "No primary space was found in [" + clusterName + "] cluster");
        }
        return spaceTreeNode == null ? null : ((SpaceTreeNode)spaceTreeNode.getUserObject()).getConnection();
    }

    private static synchronized DefaultMutableTreeNode createSpaceNode(IJSpace spaceProxy) {
        SpaceTreeNode spaceNode = new SpaceTreeNode(spaceProxy);
        DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(spaceNode);
        return treeNode;
    }

    public synchronized void showQueryPanel(String query, DatabaseConnection dbConnection, String spaceName) {
        block3: {
            try {
                if (this._iSQLPane == null) {
                    this._iSQLPane = new MainFrame();
                    this._iSQLPane.getWorkBench().setQueryString(spaceName, SELECT);
                }
                this._iSQLPane.getWorkBench().setMultiSpaceQueryEnabled(true);
                this._iSQLPane.setDBConnection(dbConnection);
                this._iSQLPane.getWorkBench().setMultiSpaceQuerySelected(this._iSQLPane.getWorkBench().isMultiSpaceQuerySelectedForRegularSpace());
                this.initQueryPanel(query, null, spaceName);
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block3;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    public synchronized void showClusterQueryPanel(String query, String clusterName) {
        block3: {
            try {
                if (this._iSQLPane == null) {
                    this._iSQLPane = new MainFrame();
                    this._iSQLPane.getWorkBench().setQueryString(clusterName, SELECT);
                }
                this._iSQLPane.getWorkBench().setMultiSpaceQuerySelected(true);
                this._iSQLPane.getWorkBench().setMultiSpaceQueryEnabled(false);
                this.initQueryPanel(query, clusterName, "CLUSTER [" + clusterName + "]");
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block3;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    private void initQueryPanel(String query, String clusterName, String spaceName) {
        this._iSQLPane.setClusterName(clusterName);
        this.mainConfigPanel.removeAll();
        this.mainConfigPanel.add((Component)this._iSQLPane.getPanel(), "Center");
        this.mainConfigPanel.validate();
        this.mainConfigPanel.repaint();
        if (query.equals(SELECT)) {
            this._iSQLPane.getWorkBench().setSpaceName(spaceName);
        } else {
            this._iSQLPane.getWorkBench().runQuery(spaceName, query + QUERY_CLUSTER_LIMIT);
        }
    }

    public MainFrame getISQLPane() {
        return this._iSQLPane;
    }

    private void discoveryListenerInit() {
        block2: {
            try {
                this.sdmListener = new LookupServiceListener();
                this.m_srvManager = new SrvManager(this);
                this.sdmListener.addServiceManager(this._clusterViewBrowser.getServiceManager());
                this.sdmListener.addServiceManager(this._clusterViewApplications.getServiceManager());
                this.sdmListener.addServiceManager(this.m_srvManager);
            }
            catch (Exception ex2) {
                if (!_logger.isLoggable(Level.FINE)) break block2;
                _logger.log(Level.FINE, ex2.toString(), ex2);
            }
        }
    }

    private void jbInit() throws Exception {
        this.mainContainer.setLayout(this.mainConBorderLayout);
        this.mainConfigPanel.setLayout(this.configConBorderLayout);
        this.configText.setBorder(BorderFactory.createEtchedBorder());
        this.configLabel.setPreferredSize(new Dimension(140, 27));
        this.createDialogs();
        this.createToolbar();
        this.createMenus();
        this.initLabels();
        this.createTree();
        this.initActions();
        this.createClusterManagementPopuMenu();
        this.initEnabledComponts();
        Dimension mainConfigPanelSize = new Dimension(570, 450);
        this.mainConfigPanel.setPreferredSize(mainConfigPanelSize);
        JScrollPane rightComponent = new JScrollPane(this.mainConfigPanel);
        rightComponent.setBorder(null);
        this.viewMap = new ViewMap();
        Icon titleIcon = JSpaceUIUtils.getDockTitleIcon();
        this.treeView = new View("Grid Tree", titleIcon, (Component)new JScrollPane(this.conTree));
        this.serviceView = new View("Service View", titleIcon, (Component)rightComponent);
        this.viewMap.addView(0, this.treeView);
        this.viewMap.addView(1, this.serviceView);
        this.rootWindowProperties = new RootWindowProperties();
        ShapedGradientDockingTheme currentTheme = new ShapedGradientDockingTheme();
        this.rootWindowProperties.addSuperObject(currentTheme.getRootWindowProperties());
        this.rootWindowProperties.getDockingWindowProperties().setCloseEnabled(false);
        this.rootWindowProperties.getDockingWindowProperties().setMaximizeEnabled(true);
        this.rootWindow = DockingUtil.createRootWindow((AbstractViewMap)this.viewMap, (boolean)false);
        this.initRootWindow();
        this.spacesViewPanel = new SpacesViewPanel(this._parentFrame);
        this.setEnable(this.spaceEnableComp, false);
        this.setEnable(this.containerEnableComp, false);
    }

    private void initRootWindow() {
        this.rootWindow.getRootWindowProperties().addSuperObject(this.rootWindowProperties);
        this.rootWindow.setWindow((DockingWindow)new SplitWindow(true, 0.25f, (DockingWindow)this.treeView, (DockingWindow)this.serviceView));
        this.mainContainer.add((Component)this.rootWindow, "Center");
    }

    private void createClusterManagementPopuMenu() {
        this.closeClusterMenuItem = new MenuWithIcon("Close", null);
        this.closeClusterMenuItem.addActionListener(this);
        this.clusterManagementPopupMenu.add(this.closeClusterMenuItem);
    }

    private void initLabels() {
        this.configLabel.setText(" " + JSpaceUIUtils.getResource().getString(CONFIG_LABEL));
        this._statusBar = new JLabel();
    }

    private void createDialogs() throws Exception {
        expDialog = new ExceptionDialog((Component)this._parentFrame, "/image/browser");
        this.runtimePanel = new SpaceRuntimePanel(this._parentFrame, this, true);
        this.containerConfigPanel = new ContainerConfigPanel(this._parentFrame, this);
        this.spaceConfigPanel = new SpaceConfigPanel(this._parentFrame, this);
        this._clusterViewBrowser = new ClusterViewDlg(this._parentFrame, this);
        this.spaceTransactionsPanel = new SpaceTransactionsPanel(this._parentFrame);
        this.spaceConnectionsPanel = new SpaceConnectionsPanel(this);
        this.noMonitorPUPermissionsView = new NoPermissionsView(MonitorAuthority.MonitorPrivilege.MONITOR_PU.toString());
        this.noSpacePermissionsView = new NoPermissionsView("Space Operation");
    }

    private void createMenus() {
        String[] conMenus = JSpaceUIUtils.getResources(CONTAINER_MENU);
        String[] conMenuIcons = JSpaceUIUtils.getResources(CONTAINER_MENU_ICON);
        String[] spaceMenus = JSpaceUIUtils.getResources(SPACE_MENU);
        String[] spaceMenuIcons = JSpaceUIUtils.getResources(SPACE_MENU_ICON);
        this.spaceMenu = new JMenu(MenuWithIcon.getMenuNameWithoutMnemonicsChar(spaceMenus[0]));
        this.spaceMenu.setMnemonic(MenuWithIcon.getMnemonics(spaceMenus[0]));
        this.pingMenuItem = new MenuWithIcon(spaceMenus[2], spaceMenuIcons[2]);
        this.spaceMenu.add(this.pingMenuItem);
        ArrayList<JMenu> menusList = new ArrayList<JMenu>(1);
        menusList.add(this.spaceMenu);
        this._menusArray = new JMenu[menusList.size()];
        menusList.toArray(this._menusArray);
        this.showDumpPopupMenuItem = new MenuWithIcon(conMenus[5], conMenuIcons[5]);
        this.launchJConsoleMenuItem = new MenuWithIcon(conMenus[6], conMenuIcons[6]);
        this.launchJVisualVmMenuItem = new MenuWithIcon("Launch VisualVM...", null);
        this.pingPopupMenuItem = new MenuWithIcon(spaceMenus[2], spaceMenuIcons[2]);
        this.popupTree.add(this.pingPopupMenuItem);
        this.popupTree.addSeparator();
        this.popupTree.add(this.showDumpPopupMenuItem);
        this.popupTree.add(this.launchJConsoleMenuItem);
        this.popupTree.add(this.launchJVisualVmMenuItem);
        this._calculatedJavaHome = JConsoleUIUtils.manageJConsoleMenuItem(this._parentFrame, this.launchJConsoleMenuItem, "", true, _logger, false, false, this._parentFrame);
        JConsoleUIUtils.manageJVisualVmMenuItem(this._parentFrame, this.launchJVisualVmMenuItem, "", _logger, false, false, this._parentFrame, false);
    }

    public boolean isRetrieveRuntimeForPersistentLRUSpace() {
        return this._parentFrame.isRetrieveRuntimeForPersistentLRUSpace();
    }

    private void createToolbar() {
        String[] tooltipText = JSpaceUIUtils.getResources(TOOLBAR_TIPS);
        String[] icons = JSpaceUIUtils.getResources(TOOLBAR_ICONS);
        this.pingButton = new ButtonWithFixedTooltip(icons[5], tooltipText[5]);
        ArrayList<JButton> buttonsList = new ArrayList<JButton>(1);
        buttonsList.add(this.pingButton);
        this._toolbarButtonsArray = new JButton[buttonsList.size()];
        buttonsList.toArray(this._toolbarButtonsArray);
    }

    private void createTree() {
        String[] spaceConfig = JSpaceUIUtils.getResources(SPACE_CONFIG);
        this.localhost = SystemInfo.singleton().network().getHostId();
        DefaultMutableTreeNode hiddenRoot = new DefaultMutableTreeNode("Hidden Root");
        this.conTree = new JTree(hiddenRoot);
        this.conTree.setRootVisible(false);
        this.conTreeModel = (DefaultTreeModel)this.conTree.getModel();
        this.conTreeModel.insertNodeInto(this.spacesRoot, hiddenRoot, hiddenRoot.getChildCount());
        this.conTreeModel.insertNodeInto(this.clusterRoot, hiddenRoot, hiddenRoot.getChildCount());
        this.conTreeModel.reload();
        this.conTree.setCellRenderer(new TreeRenderer());
        this.conTree.setAutoscrolls(true);
    }

    private void doSave() {
        Properties serializing = SpaceColorMap.instance().getProperties();
        if (AddressBarDialog.isInstanceInitialized()) {
            AddressBarDialog.getInstance(this._parentFrame).saveProperties();
        }
        String[] columnNames = this.spacesViewPanel.getColumnNames();
        String resultColumnNamesStr = "";
        for (String columnName : columnNames) {
            resultColumnNamesStr = resultColumnNamesStr + columnName + ";";
        }
        serializing.put(PROP_SPACE_NETWORK_VIEW_COLUMNS, resultColumnNamesStr);
        Repository.getInstance().setProperties(serializing);
    }

    private void initActions() {
        PingSpaceAL pingSpaceAL = new PingSpaceAL();
        this.pingMenuItem.addActionListener(pingSpaceAL);
        this.pingPopupMenuItem.addActionListener(pingSpaceAL);
        ShowContainerDumpAction showDumpAL = new ShowContainerDumpAction();
        this.showDumpPopupMenuItem.addActionListener(showDumpAL);
        LaunchJConsoleAction launchJConsoleAction = new LaunchJConsoleAction();
        this.launchJConsoleMenuItem.addActionListener(launchJConsoleAction);
        LaunchVisualVmAction launchVisualVmAction = new LaunchVisualVmAction();
        this.launchJVisualVmMenuItem.addActionListener(launchVisualVmAction);
        this.pingButton.addActionListener(pingSpaceAL);
        this.conTree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                int keyCode = evt.getKeyCode();
                if (keyCode == 40 || keyCode == 38 || keyCode == 34 || keyCode == 33) {
                    try {
                        SpaceBrowser.this._parentFrame.setCursor(Cursor.getPredefinedCursor(3));
                        Toolkit.getDefaultToolkit().sync();
                        SpaceBrowser.this.doNodeSelected(SpaceBrowser.this.conTree.getSelectionPath());
                    }
                    finally {
                        SpaceBrowser.this._parentFrame.setCursor(new Cursor(0));
                    }
                }
            }
        });
        this.conTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TreePath selPath = SpaceBrowser.this.conTree.getPathForLocation(e.getX(), e.getY());
                if (selPath == null) {
                    return;
                }
                try {
                    SpaceBrowser.this._parentFrame.setCursor(Cursor.getPredefinedCursor(3));
                    SpaceBrowser.this.conTree.setSelectionPath(selPath);
                    SpaceBrowser.this.doNodeSelected(SpaceBrowser.this.conTree.getSelectionPath());
                }
                finally {
                    SpaceBrowser.this._parentFrame.setCursor(new Cursor(0));
                }
                if (SwingUtilities.isRightMouseButton(e)) {
                    if (selPath != null) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getPath()[selPath.getPath().length - 1];
                        Object objNode = node.getUserObject();
                        Object parentObjNode = null;
                        Object granObjNode = null;
                        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
                        DefaultMutableTreeNode granNode = null;
                        if (parentNode != null) {
                            granNode = (DefaultMutableTreeNode)parentNode.getParent();
                            parentObjNode = parentNode.getUserObject();
                        }
                        if (granNode != null) {
                            granObjNode = granNode.getUserObject();
                        }
                        if (objNode instanceof JSpaceProxyWrapper) {
                            JSpaceProxyWrapper proxyWrapper = (JSpaceProxyWrapper)objNode;
                            objNode = proxyWrapper.proxy();
                        }
                        if (objNode instanceof StaleSpaceService || objNode instanceof StaleContainerService) {
                            SpaceBrowser.this.setSelectedTreeNode(null);
                        } else {
                            SpaceBrowser.this.setSelectedTreeNode(node);
                            if (objNode instanceof IJSpaceContainer) {
                                SpaceBrowser.this.setEnable(SpaceBrowser.this.spaceEnableComp, false);
                                SpaceBrowser.this.setEnable(SpaceBrowser.this.containerEnableComp, true);
                            } else if (objNode instanceof IJSpace) {
                                SpaceBrowser.this.setEnable(SpaceBrowser.this.containerEnableComp, false);
                            }
                        }
                        if (objNode instanceof EditCluster) {
                            SpaceBrowser.this.handleClusterMenuState();
                            String clusterName = ((EditCluster)objNode).getClusterName();
                            ServiceManagerImpl.ClusterMember[] aliveClusterMembers = SpaceBrowser.this._clusterViewBrowser.getServiceManager().getClusterMembers(clusterName, false);
                            if (aliveClusterMembers.length > 0) {
                                SpaceBrowser.this.clusterManagementPopupMenu.show(SpaceBrowser.this.conTree, e.getX(), e.getY());
                            }
                        } else if (!(objNode.equals(SpaceBrowser.CLASSES_LABEL) || objNode.equals(SpaceBrowser.TRANSACTIONS_LABEL) || objNode.equals(SpaceBrowser.SQL_LABEL) || objNode.equals(SpaceBrowser.STATISTICS_LABEL) || objNode.equals(SpaceBrowser.CONNECTIONS_LABEL) || objNode.equals(SpaceBrowser.SPACES_LABEL) || objNode.equals(SpaceBrowser.BENCHMARK_LABEL) || parentObjNode instanceof EditCluster || granObjNode instanceof EditCluster || node.equals(SpaceBrowser.this.clusterRoot))) {
                            if (JSpaceUtilities.isJDK_1_4Runtime()) {
                                SpaceBrowser.this.launchJConsoleMenuItem.setEnabled(false);
                                SpaceBrowser.this.launchJVisualVmMenuItem.setEnabled(false);
                            } else {
                                SpaceTreeNode spaceUserObj = null;
                                if (node.getUserObject() instanceof JSpaceContainerProxyWrapper && ((JSpaceContainerProxyWrapper)node.getUserObject()).proxy() instanceof IJSpaceContainer && node.getChildCount() > 0) {
                                    DefaultMutableTreeNode spaceNode = (DefaultMutableTreeNode)node.getChildAt(0);
                                    spaceUserObj = (SpaceTreeNode)spaceNode.getUserObject();
                                    objNode = spaceUserObj.proxy();
                                    SpaceBrowser.this.setEnable(SpaceBrowser.this.containerEnableComp, true);
                                    SpaceBrowser.this.setEnable(SpaceBrowser.this.spaceEnableComp, false);
                                } else if (node.getUserObject() instanceof SpaceTreeNode) {
                                    spaceUserObj = (SpaceTreeNode)node.getUserObject();
                                    SpaceBrowser.this.setEnable(SpaceBrowser.this.containerEnableComp, false);
                                    SpaceBrowser.this.setEnable(SpaceBrowser.this.spaceEnableComp, true);
                                }
                                if (spaceUserObj != null && objNode instanceof IJSpace) {
                                    boolean isSpaceSecured = spaceUserObj.isSecured();
                                    SpaceBrowser.this.launchJConsoleMenuItem.setEnabled(JSpaceUIUtils.isSpaceHasPermittedPermission(spaceUserObj.getServiceID(), isSpaceSecured, (Privilege)MonitorAuthority.MonitorPrivilege.MONITOR_JVM));
                                    SpaceBrowser.this.showDumpPopupMenuItem.setEnabled(JSpaceUIUtils.isSpaceHasPermittedPermission(spaceUserObj.getServiceID(), isSpaceSecured, (Privilege)MonitorAuthority.MonitorPrivilege.MONITOR_PU));
                                }
                            }
                            SpaceBrowser.this.popupTree.show(SpaceBrowser.this.conTree, e.getX(), e.getY());
                        }
                    } else {
                        SpaceBrowser.this.conTree.clearSelection();
                    }
                }
            }
        });
    }

    public void findRMIServices(String[] findURLs) {
        for (String url : findURLs) {
            ProgressThread findThread = new ProgressThread(this._parentFrame);
            try {
                findThread.setURL(url);
                AdminUIThreadPool.getThreadPool().execute((Runnable)((Object)findThread));
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) continue;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    public void addRMIContainer(IJSpaceContainer containerProxy, String url) {
        this._rmiContainersMap.put(containerProxy, url);
    }

    public String[] removeRMIContainers() {
        HashSet<String> rmiURLsSet = new HashSet<String>();
        Iterator<Map.Entry<IJSpaceContainer, String>> iterator = this._rmiContainersMap.entrySet().iterator();
        int size = this._rmiContainersMap.size();
        ArrayList<IJSpaceContainerAdmin> removedContainersList = new ArrayList<IJSpaceContainerAdmin>(size);
        while (iterator.hasNext()) {
            Map.Entry<IJSpaceContainer, String> mapEntry = iterator.next();
            rmiURLsSet.add(mapEntry.getValue());
            IJSpaceContainerAdmin containerAdmin = (IJSpaceContainerAdmin)mapEntry.getKey();
            removedContainersList.add(containerAdmin);
        }
        for (int index = size - 1; index >= 0; --index) {
            this.removeContainerTree((IJSpaceContainerAdmin)removedContainersList.get(index));
        }
        String[] resultArray = new String[rmiURLsSet.size()];
        rmiURLsSet.toArray(resultArray);
        return resultArray;
    }

    private void handleClusterMenuState() {
        ClusterMemberInfo[] clusterMemberInfoArray = this.currentCluster.getClusterMembers();
        boolean isAtLeastOneClusterMemberAlive = false;
        boolean isAtLeastOneClusterMemberUnreachable = false;
        for (int i = 0; i < clusterMemberInfoArray.length; ++i) {
            ClusterMemberInfo clusterMemberInfo;
            String memberName = clusterMemberInfo.memberName;
            clusterMemberInfo = clusterMemberInfoArray[i];
            boolean isMirror = clusterMemberInfo.isMirror();
            String status = ServiceManagerImpl.getMemberStatus(memberName, isMirror);
            if ((status.equals("Alive") || status.equals("MirrorAlive")) && !isAtLeastOneClusterMemberAlive) {
                isAtLeastOneClusterMemberAlive = true;
                if (isAtLeastOneClusterMemberUnreachable) break;
            }
            if (!status.equals("Unreachable") && !status.equals("MirrorUnreachable") || isAtLeastOneClusterMemberUnreachable) continue;
            isAtLeastOneClusterMemberUnreachable = true;
            if (isAtLeastOneClusterMemberAlive) break;
        }
    }

    private void onClose() {
        this.doSave();
        this.exit(0);
    }

    public void doNodeSelected(TreePath selPath) {
        this.curSelPath = selPath;
        final DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)selPath.getPath()[selPath.getPath().length - 1];
        this._parentFrame.getTreeSelectionsExecutor().submit(selectedNode, new Runnable(){

            @Override
            public void run() {
                SpaceBrowser.this.doNodeSelected(selectedNode);
            }
        });
    }

    public void doNodeSelected(DefaultMutableTreeNode selNode) {
        block72: {
            try {
                ServiceID serviceID;
                IJSpace space;
                ServiceManagerImpl serviceManagerImpl;
                String clusterName;
                EditCluster edCluster;
                EditCluster editCluster;
                ClusterStatisticPanel selectedclusterStatisticPanel;
                Object objNode;
                if (selNode.equals(this.curSelectedNode)) {
                    return;
                }
                this.curSelectedNode = selNode;
                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)selNode.getParent();
                DefaultMutableTreeNode granNode = null;
                this.runtimePanel.setControlEnabled(false);
                Object parentObj = null;
                if (parentNode != null) {
                    granNode = (DefaultMutableTreeNode)parentNode.getParent();
                    parentObj = parentNode.getUserObject();
                }
                if ((objNode = selNode.getUserObject()) instanceof SpaceTreeNode) {
                    this.selectedSpaceNode = (SpaceTreeNode)objNode;
                } else if (parentObj instanceof SpaceTreeNode) {
                    this.selectedSpaceNode = (SpaceTreeNode)parentObj;
                }
                if (!(objNode instanceof EditCluster || parentObj instanceof EditCluster || granNode != null && granNode.getUserObject() instanceof EditCluster)) {
                    this._clusterViewBrowser.getServiceManager().paused(true, true);
                }
                this.spaceTransactionsPanel.setInvokeRefresh(objNode.equals(TRANSACTIONS_LABEL));
                this.spaceConnectionsPanel.setInvokeRefresh(objNode.equals(CONNECTIONS_LABEL));
                this.runtimePanel.setInvokeRefresh(objNode.equals(CLASSES_LABEL));
                if (this.clusterRuntimePanel != null) {
                    this.clusterRuntimePanel.setInvokeRefresh(objNode.equals(CLASSES_LABEL) && parentObj != null && parentObj.equals(OPERATIONS_NODE_LABEL));
                }
                if (this.clusterConnectionsPanel != null) {
                    this.clusterConnectionsPanel.setInvokeRefresh(objNode.equals(CONNECTIONS_LABEL) && parentObj != null && parentObj.equals(OPERATIONS_NODE_LABEL));
                }
                if (this.clusterTransactionPanel != null) {
                    this.clusterTransactionPanel.setInvokeRefresh(objNode.equals(TRANSACTIONS_LABEL) && parentObj != null && parentObj.equals(OPERATIONS_NODE_LABEL));
                }
                String curClusterName = null;
                if (objNode.equals(STATISTICS_LABEL) && parentObj != null && parentObj.equals(OPERATIONS_NODE_LABEL) && parentNode.getParent() != null && this.clusterRoot.equals(parentNode.getParent().getParent()) && (selectedclusterStatisticPanel = this.statisticsPerCluster.get(curClusterName = (editCluster = (EditCluster)granNode.getUserObject()).getClusterName())) != null) {
                    selectedclusterStatisticPanel.setInvokeRefresh(true);
                }
                if (this.statisticsPerCluster.size() > 0) {
                    Set<Map.Entry<String, ClusterStatisticPanel>> statisticsEntrySet = this.statisticsPerCluster.entrySet();
                    for (Map.Entry<String, ClusterStatisticPanel> mapEntry : statisticsEntrySet) {
                        String clusterName2 = mapEntry.getKey();
                        if (clusterName2.equals(curClusterName)) continue;
                        mapEntry.getValue().setInvokeRefresh(false);
                    }
                }
                this.spacesViewPanel.setInvokeRefresh(selNode.equals(this.spacesRoot));
                if (!(objNode instanceof IJSpaceContainerAdmin) && !(objNode instanceof IJSpace)) {
                    this.setEnable(this.spaceEnableComp, false);
                    this.setEnable(this.containerEnableComp, false);
                }
                if (objNode instanceof EditCluster) {
                    edCluster = (EditCluster)objNode;
                    this.showClusterPanel(edCluster, false, false, true);
                    clusterName = edCluster.getClusterName();
                    this._clusterViewBrowser.getClusterTree(clusterName).showHighLevelNode(selNode, null);
                    this.mainConfigPanel.validate();
                    this.mainConfigPanel.repaint();
                    serviceManagerImpl = this._clusterViewBrowser.getServiceManager();
                    serviceManagerImpl.awakeThread();
                    return;
                }
                if (parentObj instanceof EditCluster) {
                    if (selNode.toString().equals(OPERATIONS_NODE_LABEL)) {
                        this.clearRightSplitPanel();
                        this.setEnable(this.spaceEnableComp, false);
                        this.setEnable(this.containerEnableComp, false);
                        this.currentCluster = null;
                        return;
                    }
                    try {
                        edCluster = (EditCluster)parentObj;
                        this.showClusterPanel(edCluster, false, false, true);
                        clusterName = edCluster.getClusterName();
                        this._clusterViewBrowser.getClusterTree(clusterName).performNodeAction(this.curSelPath);
                        this.mainConfigPanel.validate();
                        this.mainConfigPanel.repaint();
                        serviceManagerImpl = this._clusterViewBrowser.getServiceManager();
                        serviceManagerImpl.awakeThread();
                    }
                    catch (Exception e) {
                        SpaceBrowser.showException(e.toString(), e);
                    }
                    return;
                }
                if (granNode != null && granNode.getUserObject() instanceof EditCluster) {
                    edCluster = (EditCluster)granNode.getUserObject();
                    if (parentNode.toString().equals(OPERATIONS_NODE_LABEL)) {
                        ClusterMemberInfo[] clusterMemberInfo = edCluster.getClusterMembers();
                        this._clusterViewBrowser.getServiceManager().setCurrentClusterMembers(clusterMemberInfo, false);
                        String clusterName3 = edCluster.getClusterName();
                        ServiceManagerImpl.ClusterMember[] aliveClusterMembers = this._clusterViewBrowser.getServiceManager().getClusterMembers(clusterName3, false);
                        if (aliveClusterMembers.length > 0) {
                            IJSpace space2 = aliveClusterMembers[0].getClusteredProxy();
                            ServiceID serviceID2 = aliveClusterMembers[0].getServiceID();
                            if (selNode.toString().equals(CLASSES_LABEL) || selNode.toString().equals(TRANSACTIONS_LABEL) || selNode.toString().equals(CONNECTIONS_LABEL) || selNode.toString().equals(STATISTICS_LABEL)) {
                                if (this.handleSecuredServiceView(space2, serviceID2, (Privilege)MonitorAuthority.MonitorPrivilege.MONITOR_PU)) {
                                    if (selNode.toString().equals(CLASSES_LABEL)) {
                                        this.selectClusterRuntimePanel(edCluster);
                                    } else if (selNode.toString().equals(TRANSACTIONS_LABEL)) {
                                        this.selectClusterTransactionsPanel(clusterName3);
                                    } else if (selNode.toString().equals(CONNECTIONS_LABEL)) {
                                        this.selectClusterConnectionsPanel(clusterName3);
                                    } else if (selNode.toString().equals(STATISTICS_LABEL)) {
                                        ServiceManagerImpl.ClusterMember[] curClusterMembers = this._clusterViewBrowser.getServiceManager().getClusterMembers(clusterName3, false);
                                        if (curClusterMembers.length == 0) {
                                            JOptionPane.showMessageDialog(this._parentFrame, "Unable to display Cluster Statistics since there are no any alive cluster member in cluster.", "Cluster Statistics", 2);
                                            return;
                                        }
                                        this.selectClusterStatisticsPanel(edCluster);
                                    }
                                }
                            } else if ((selNode.toString().equals(SQL_LABEL) || selNode.toString().equals(BENCHMARK_LABEL)) && this.handleSecuredServiceView(space2, serviceID2, (Privilege[])SPACE_PRIVILIGIES)) {
                                if (selNode.toString().equals(SQL_LABEL)) {
                                    this.selectClusterSQLQueryPanel(clusterName3, SELECT);
                                } else if (selNode.toString().equals(BENCHMARK_LABEL)) {
                                    this.selectClusterBenchmarkPanel(edCluster);
                                }
                            }
                        }
                        this.currentCluster = null;
                        return;
                    }
                    try {
                        if (this.currentCluster == null || this.currentCluster != edCluster) {
                            this.showClusterPanel(edCluster, true, false, true);
                        }
                        clusterName = edCluster.getClusterName();
                        this._clusterViewBrowser.getClusterTree(clusterName).performNodeAction(this.curSelPath);
                        this.mainConfigPanel.validate();
                        this.mainConfigPanel.repaint();
                        serviceManagerImpl = this._clusterViewBrowser.getServiceManager();
                        serviceManagerImpl.awakeThread();
                    }
                    catch (Exception e) {
                        SpaceBrowser.showException(e.toString(), e);
                    }
                    this.currentCluster = edCluster;
                    return;
                }
                if (objNode.equals(TRANSACTIONS_LABEL) || objNode.equals(CONNECTIONS_LABEL) || objNode.equals(STATISTICS_LABEL) || objNode.equals(CLASSES_LABEL)) {
                    space = this.selectedSpaceNode.getSpaceProxy();
                    if (this.handleSecuredServiceView(space, serviceID = this.selectedSpaceNode.getServiceID(), (Privilege)MonitorAuthority.MonitorPrivilege.MONITOR_PU)) {
                        if (objNode.equals(CLASSES_LABEL)) {
                            this.selectRuntimePanel(this.selectedSpaceNode);
                        } else if (objNode.equals(TRANSACTIONS_LABEL)) {
                            this.selectTransactionsPanel(this.selectedSpaceNode);
                        } else if (objNode.equals(CONNECTIONS_LABEL)) {
                            this.selectConnectionsPanel(this.selectedSpaceNode, (IJSpaceContainerAdmin)((JSpaceContainerProxyWrapper)granNode.getUserObject()).proxy());
                        } else if (objNode.equals(STATISTICS_LABEL)) {
                            this.selectStatisticsPanel(this.selectedSpaceNode);
                        }
                    }
                } else if (objNode.equals(SQL_LABEL)) {
                    space = this.selectedSpaceNode.getSpaceProxy();
                    if (this.handleSecuredServiceView(space, serviceID = this.selectedSpaceNode.getServiceID(), (Privilege[])SPACE_PRIVILIGIES)) {
                        this.selectSQLQueryPanel(this.selectedSpaceNode);
                    }
                } else if (selNode.equals(this.clusterRoot)) {
                    this.clearRightSplitPanel();
                    this.setEnable(this.spaceEnableComp, false);
                    this.setEnable(this.containerEnableComp, false);
                } else if (selNode.equals(this.spacesRoot)) {
                    this.mainConfigPanel.removeAll();
                    this.mainConfigPanel.add((Component)this.spacesViewPanel, "Center");
                    this.spacesViewPanel.refresh();
                    this.mainConfigPanel.validate();
                    this.mainConfigPanel.repaint();
                    this.currentCluster = null;
                } else if (objNode.equals(BENCHMARK_LABEL)) {
                    space = this.selectedSpaceNode.getSpaceProxy();
                    if (this.handleSecuredServiceView(space, serviceID = this.selectedSpaceNode.getServiceID(), (Privilege[])SPACE_PRIVILIGIES)) {
                        this.mainConfigPanel.removeAll();
                        SpaceTreeNode spaceTreeNode = this.getSelectedSpaceNode();
                        BenchMarkPanel benchMarkPanel = BenchMarkPanelFactory.instance().getPanel(this._parentFrame, spaceTreeNode.getSpaceProxy());
                        this.mainConfigPanel.add((Component)benchMarkPanel, "Center");
                        this.mainConfigPanel.validate();
                        this.mainConfigPanel.repaint();
                    }
                    this.currentCluster = null;
                }
                if (objNode instanceof JSpaceProxyWrapper) {
                    JSpaceProxyWrapper proxyWrapper = (JSpaceProxyWrapper)objNode;
                    objNode = proxyWrapper.proxy();
                    this.currentCluster = null;
                }
                if (objNode instanceof StaleSpaceService || objNode instanceof StaleContainerService) {
                    this.setSelectedTreeNode(null);
                    this.currentCluster = null;
                    return;
                }
                this.setSelectedTreeNode(selNode);
                if (objNode instanceof JSpaceContainerProxyWrapper) {
                    try {
                        this.updateContainerConfig((IJSpaceContainerAdmin)((JSpaceContainerProxyWrapper)objNode).proxy());
                    }
                    catch (LostConnectionException ex) {
                        this.removeContainerTree(selNode, false);
                    }
                } else if (objNode instanceof IJSpace) {
                    try {
                        this.updateSpaceConfig(selNode.getParent().toString(), (IJSpace)objNode);
                    }
                    catch (LostConnectionException ex) {
                        this.removeSpaceNode(selNode);
                    }
                } else {
                    if (selNode.getParent() == null) {
                        return;
                    }
                    Object o = ((DefaultMutableTreeNode)selNode.getParent()).getUserObject();
                    if (o instanceof StaleContainerService || o instanceof StaleSpaceService) {
                        this.setSelectedTreeNode(null);
                        return;
                    }
                    this.currentCluster = null;
                }
            }
            catch (Throwable t) {
                if (!_logger.isLoggable(Level.SEVERE)) break block72;
                _logger.log(Level.SEVERE, t.toString(), t);
            }
        }
    }

    private boolean handleSecuredServiceView(IJSpace space, ServiceID serviceId, Privilege permittedPrivilege) {
        if (space == null || !JSpaceUIUtils.hasPermittedPermission((SecuredService)space, serviceId, permittedPrivilege, space.isSecured())) {
            this.setEnable(this.spaceEnableComp, false);
            this.setEnable(this.containerEnableComp, false);
            this.mainConfigPanel.removeAll();
            this.mainConfigPanel.add((Component)this.noMonitorPUPermissionsView, "Center");
            this.mainConfigPanel.validate();
            this.mainConfigPanel.repaint();
            return false;
        }
        return true;
    }

    private boolean handleSecuredServiceView(IJSpace space, ServiceID serviceId, Privilege[] permittedPrivilegesArray) {
        Privilege privilege;
        boolean isAtLeastOneSpaceOperationPermitted = false;
        Privilege[] privilegeArray = permittedPrivilegesArray;
        int n = privilegeArray.length;
        for (int i = 0; i < n && !(isAtLeastOneSpaceOperationPermitted = JSpaceUIUtils.hasPermittedPermission((SecuredService)space, serviceId, privilege = privilegeArray[i], space.isSecured())); ++i) {
        }
        if (!isAtLeastOneSpaceOperationPermitted) {
            this.setEnable(this.spaceEnableComp, false);
            this.setEnable(this.containerEnableComp, false);
            this.mainConfigPanel.removeAll();
            this.mainConfigPanel.add((Component)this.noSpacePermissionsView, "Center");
            this.mainConfigPanel.validate();
            this.mainConfigPanel.repaint();
            return false;
        }
        return true;
    }

    private void selectRuntimePanel(SpaceTreeNode spaceNode) {
        ServiceID spaceID;
        IJSpace spaceProxy;
        IRemoteJSpaceAdmin spaceAdmin;
        block4: {
            spaceAdmin = null;
            this.setEnable(this.spaceEnableComp, false);
            this.setEnable(this.containerEnableComp, false);
            this.mainConfigPanel.removeAll();
            this.mainConfigPanel.add((Component)this.runtimePanel, "Center");
            this.mainConfigPanel.validate();
            this.mainConfigPanel.repaint();
            if (spaceNode == null) {
                return;
            }
            spaceProxy = (IJSpace)spaceNode.proxy();
            spaceID = null;
            try {
                spaceAdmin = Repository.addSpaceAdminObjectToMap(spaceProxy);
            }
            catch (RemoteException re) {
                if (!_logger.isLoggable(Level.SEVERE)) break block4;
                _logger.log(Level.SEVERE, re.toString(), re);
            }
        }
        spaceID = spaceNode.getServiceID();
        if (spaceAdmin != null) {
            this.runtimePanel.setSpaceAdmin(spaceProxy, spaceAdmin, spaceID, spaceNode);
        }
    }

    private void selectClusterRuntimePanel(EditCluster editCluster) {
        if (this.clusterRuntimePanel == null) {
            this.clusterRuntimePanel = new ClusterSpaceRuntimePanel(this._parentFrame, null, this, true, this._clusterViewBrowser.getServiceManager());
            this.clusterRuntimePanel.setInvokeRefresh(true);
        }
        this.clusterRuntimePanel.setCurrentClusterDefinition(editCluster);
        this.setEnable(this.spaceEnableComp, false);
        this.setEnable(this.containerEnableComp, false);
        this.mainConfigPanel.removeAll();
        this.mainConfigPanel.add((Component)this.clusterRuntimePanel, "Center");
        this.mainConfigPanel.validate();
        this.mainConfigPanel.repaint();
        this._clusterViewBrowser.getServiceManager().awakeThread();
    }

    private void selectClusterConnectionsPanel(String clusterName) {
        if (this.clusterConnectionsPanel == null) {
            this.clusterConnectionsPanel = new ClusterConnectionsPanel(this, this._clusterViewBrowser.getServiceManager());
            this.clusterConnectionsPanel.setInvokeRefresh(true);
        }
        this.clusterConnectionsPanel.setCurrentClusterName(clusterName);
        this.setEnable(this.spaceEnableComp, false);
        this.setEnable(this.containerEnableComp, false);
        this.mainConfigPanel.removeAll();
        this.mainConfigPanel.add((Component)this.clusterConnectionsPanel, "Center");
        this.mainConfigPanel.validate();
        this.mainConfigPanel.repaint();
        this._clusterViewBrowser.getServiceManager().awakeThread();
    }

    private void selectConnectionsPanel(SpaceTreeNode spaceNode, IJSpaceContainerAdmin containerProxy) {
        block2: {
            this.selectedSpaceNode = spaceNode;
            this.mainConfigPanel.removeAll();
            this.mainConfigPanel.add((Component)this.spaceConnectionsPanel, "Center");
            this.mainConfigPanel.validate();
            this.mainConfigPanel.repaint();
            try {
                IJSpace spaceProxy = (IJSpace)spaceNode.proxy();
                MBeanServerConnection mBeanServerConnection = Repository.getMBeanServerConnection(containerProxy);
                this.spaceConnectionsPanel.initPanel(mBeanServerConnection, spaceProxy);
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block2;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
        this.currentCluster = null;
    }

    private void selectStatisticsPanel(SpaceTreeNode spaceTreeNode) {
        block3: {
            try {
                this.selectedSpaceNode = spaceTreeNode;
                this.mainConfigPanel.removeAll();
                StatisticPanel statistic = this.statisticsPerSpace.get(this.selectedSpaceNode.getSpaceObjectID());
                if (statistic == null) {
                    statistic = new StatisticPanel(this._parentFrame);
                    statistic.setSpace((IJSpace)spaceTreeNode.proxy(), spaceTreeNode.getProxyName());
                    this.statisticsPerSpace.put(this.selectedSpaceNode.getSpaceObjectID(), statistic);
                }
                this.mainConfigPanel.add((Component)statistic, "Center");
                this.mainConfigPanel.validate();
                this.mainConfigPanel.repaint();
                this.currentCluster = null;
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.FINE)) break block3;
                _logger.log(Level.FINE, e.toString(), e);
            }
        }
    }

    private void selectClusterStatisticsPanel(EditCluster editCluster) {
        block3: {
            try {
                String clusterName = editCluster.getClusterName();
                this.mainConfigPanel.removeAll();
                ClusterStatisticPanel statistic = this.statisticsPerCluster.get(clusterName);
                if (statistic == null) {
                    statistic = new ClusterStatisticPanel(this._parentFrame, this._clusterViewBrowser.getServiceManager(), editCluster);
                    this.statisticsPerCluster.put(clusterName, statistic);
                }
                statistic.startRefresh();
                this._clusterViewBrowser.getServiceManager().awakeThread();
                this.mainConfigPanel.add((Component)statistic, "Center");
                this.mainConfigPanel.validate();
                this.mainConfigPanel.repaint();
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.FINE)) break block3;
                _logger.log(Level.FINE, e.toString(), e);
            }
        }
    }

    private void selectClusterBenchmarkPanel(EditCluster editCluster) {
        block3: {
            try {
                String clusterName = editCluster.getClusterName();
                this.mainConfigPanel.removeAll();
                BenchMarkPanel benchmarkPanel = this.benchmarkPanelsPerCluster.get(clusterName);
                if (benchmarkPanel == null) {
                    benchmarkPanel = new ClusterBenchMarkPanel((JFrame)this._parentFrame, this._clusterViewBrowser.getServiceManager(), clusterName);
                    this.benchmarkPanelsPerCluster.put(clusterName, benchmarkPanel);
                }
                this._clusterViewBrowser.getServiceManager().awakeThread();
                this.mainConfigPanel.add((Component)benchmarkPanel, "Center");
                this.mainConfigPanel.validate();
                this.mainConfigPanel.repaint();
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.FINE)) break block3;
                _logger.log(Level.FINE, e.toString(), e);
            }
        }
    }

    private void selectSQLQueryPanel(SpaceTreeNode spaceNode) {
        this.selectedSpaceNode = spaceNode;
        this.showQueryPanel(SELECT, spaceNode.getConnection(), spaceNode.toString());
        this.currentCluster = null;
    }

    protected void selectClusterSQLQueryPanel(String clusterName, String query) {
        this.showClusterQueryPanel(query, clusterName);
    }

    private void selectTransactionsPanel(SpaceTreeNode spaceNode) {
        this.selectedSpaceNode = spaceNode;
        this.mainConfigPanel.removeAll();
        this.mainConfigPanel.add((Component)this.spaceTransactionsPanel, "Center");
        this.mainConfigPanel.validate();
        this.mainConfigPanel.repaint();
        IJSpace spaceProxy = (IJSpace)spaceNode.proxy();
        this.spaceTransactionsPanel.setSpace(spaceProxy);
        this.currentCluster = null;
    }

    private void selectClusterTransactionsPanel(String clusterName) {
        this.mainConfigPanel.removeAll();
        if (this.clusterTransactionPanel == null) {
            this.clusterTransactionPanel = new ClusterTransactionsPanel(this._parentFrame, this._clusterViewBrowser.getServiceManager());
            this.clusterTransactionPanel.setInvokeRefresh(true);
        }
        this.clusterTransactionPanel.setCurrentClusterName(clusterName);
        this.mainConfigPanel.add((Component)this.clusterTransactionPanel, "Center");
        this.mainConfigPanel.validate();
        this.mainConfigPanel.repaint();
    }

    private void clearRightSplitPanel() {
        this.mainConfigPanel.removeAll();
        this.mainConfigPanel.validate();
        this.mainConfigPanel.repaint();
    }

    public File chooseFile() {
        if (this.m_fileChooser == null) {
            this.m_fileChooser = new JFileChooser(SystemInfo.singleton().locations().config());
            FileFilterExt xmlFilter = new FileFilterExt("xml", "Cluster XML file");
            this.m_fileChooser.addChoosableFileFilter(xmlFilter);
        }
        int state = this.m_fileChooser.showOpenDialog(this._parentFrame);
        File file = this.m_fileChooser.getSelectedFile();
        if (file == null || state != 0) {
            return null;
        }
        return file;
    }

    private void initEnabledComponts() {
        this.spaceEnableComp = new Vector();
        this.containerEnableComp = new Vector();
        this.spaceEnableComp.add(this.pingButton);
        this.spaceEnableComp.add(this.pingMenuItem);
        this.spaceEnableComp.add(this.pingPopupMenuItem);
    }

    void updateContainerConfig(IJSpaceContainerAdmin containerProxy) {
        this.setEnable(this.spaceEnableComp, false);
        this.setEnable(this.containerEnableComp, containerProxy != null);
        if (containerProxy != null) {
            this.containerConfigPanel.updateConfig(containerProxy);
        } else {
            this.containerConfigPanel.cleanup();
        }
        this.mainConfigPanel.removeAll();
        this.mainConfigPanel.add((Component)this.containerConfigPanel, "Center");
        this.mainConfigPanel.validate();
        this.mainConfigPanel.repaint();
    }

    void updateSpaceConfig(String containerName, IJSpace spaceProxy) {
        this.setEnableSpaceControls(spaceProxy);
        this.setEnable(this.containerEnableComp, false);
        if (spaceProxy != null) {
            this.spaceConfigPanel.updateDialog(containerName, spaceProxy);
        } else {
            this.spaceConfigPanel.cleanup();
        }
        this.mainConfigPanel.removeAll();
        this.mainConfigPanel.add((Component)this.spaceConfigPanel, "Center");
        this.mainConfigPanel.validate();
        this.mainConfigPanel.repaint();
    }

    public boolean isProxyExists(Object proxy) {
        return this.m_proxyServiceTable.containsKey(proxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContainerTree(IJSpaceContainer containerProxy, String containerName, String protocolName, boolean isSelectContainerNode) {
        block30: {
            String[] spaceNames = null;
            DefaultTreeModel defaultTreeModel = this.conTreeModel;
            synchronized (defaultTreeModel) {
                DefaultMutableTreeNode conNode;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("> Add container: " + containerName);
                }
                if ((conNode = this.m_proxyServiceTable.get(containerProxy)) != null) {
                    block29: {
                        try {
                            if (_logger.isLoggable(Level.FINE)) {
                                _logger.fine("addContainerTree: This container already exists: " + containerProxy.getName());
                            }
                            if (containerName != null) {
                                this.m_containerMutableNode.put(conNode, containerName);
                                return;
                            }
                            if (_logger.isLoggable(Level.FINE)) {
                                _logger.fine("add space nodes 1");
                            }
                            this.addSpaceNodes(this.conTreeModel, conNode, containerProxy, protocolName, isSelectContainerNode);
                            if (this.runtimePanel.isStop()) {
                                this.containerConfigPanel.updateConfig((IJSpaceContainerAdmin)containerProxy);
                            }
                            if (isSelectContainerNode) {
                                this.setSelectedTreeNode(conNode, true, true);
                                this.setEnable(this.spaceEnableComp, false);
                                this.setEnable(this.containerEnableComp, true);
                            }
                        }
                        catch (Exception ex) {
                            if (!_logger.isLoggable(Level.FINE)) break block29;
                            _logger.log(Level.FINE, ex.toString(), ex);
                        }
                    }
                    return;
                }
            }
            try {
                String hostName = Repository.addContainerToMap((IJSpaceContainerAdmin)((IJSpaceContainerAdmin)containerProxy)).containerHostName;
                DefaultMutableTreeNode containerTreeNode = new DefaultMutableTreeNode(new JSpaceContainerProxyWrapper(containerProxy, containerName, hostName));
                DefaultTreeModel ex = this.conTreeModel;
                synchronized (ex) {
                    boolean isFound = false;
                    if (this.spacesRoot.getChildCount() == 0) {
                        spaceNames = this.addSpaceNodes(this.conTreeModel, containerTreeNode, containerProxy, protocolName, isSelectContainerNode);
                        SpaceBrowser.addTreeNodeToContainerTreeNodeTable(containerTreeNode, containerTreeNode.toString());
                        this.conTreeModel.insertNodeInto(containerTreeNode, this.spacesRoot, this.spacesRoot.getChildCount());
                        this.m_proxyServiceTable.put(containerProxy, containerTreeNode);
                    } else {
                        for (int i = 0; i < this.spacesRoot.getChildCount(); ++i) {
                            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)this.spacesRoot.getChildAt(i);
                            if (childNode.getUserObject() instanceof StaleContainerService || !containerTreeNode.toString().equals(childNode.toString()) || !containerProxy.equals(((JSpaceContainerProxyWrapper)childNode.getUserObject()).proxy())) continue;
                            containerTreeNode = childNode;
                            if (!this.m_proxyServiceTable.containsKey(containerProxy)) {
                                this.m_proxyServiceTable.put(containerProxy, containerTreeNode);
                                spaceNames = this.addSpaceNodes(this.conTreeModel, childNode, containerProxy, protocolName, isSelectContainerNode);
                            }
                            isFound = true;
                            break;
                        }
                        if (!isFound) {
                            spaceNames = this.addSpaceNodes(this.conTreeModel, containerTreeNode, containerProxy, protocolName, isSelectContainerNode);
                            SpaceBrowser.addTreeNodeToContainerTreeNodeTable(containerTreeNode, containerTreeNode.toString());
                            this.m_proxyServiceTable.put(containerProxy, containerTreeNode);
                            this.conTreeModel.insertNodeInto(containerTreeNode, this.spacesRoot, this.spacesRoot.getChildCount());
                        }
                    }
                    if (spaceNames != null && _logger.isLoggable(Level.FINE)) {
                        _logger.fine("containerTree=" + containerTreeNode + " spaceNames=" + Arrays.asList(spaceNames));
                    }
                }
                if (containerName != null) {
                    this.m_containerMutableNode.put(containerTreeNode, containerName);
                }
                if (this.runtimePanel.isStop() && isSelectContainerNode) {
                    this.containerConfigPanel.updateConfig((IJSpaceContainerAdmin)containerProxy);
                }
                Object[] pn = this.conTreeModel.getPathToRoot(containerTreeNode);
                TreePath containerPath = new TreePath(pn);
                this.conTree.expandPath(containerPath);
                TreePath selPath = this.conTree.getSelectionPath();
                DefaultMutableTreeNode selNode = null;
                if (selPath != null) {
                    selNode = (DefaultMutableTreeNode)selPath.getPath()[selPath.getPath().length - 1];
                }
                this.setEnable(this.spaceEnableComp, false);
                if (selNode != null && selNode.getUserObject() instanceof IJSpaceContainerAdmin) {
                    this.setEnable(this.containerEnableComp, true);
                } else {
                    this.setEnable(this.containerEnableComp, false);
                }
                if (isSelectContainerNode || selNode == null) {
                    this.setSelectedTreeNode(containerTreeNode, true, true);
                }
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.SEVERE)) break block30;
                _logger.log(Level.SEVERE, ex.toString(), ex);
            }
        }
    }

    void removeContainerTree(ServiceID serviceID) {
        DefaultMutableTreeNode removedNode = this.m_serviceIDtable.remove(serviceID);
        if (removedNode != null) {
            this.removeContainerTree(removedNode, false);
        }
    }

    public void removeContainerTree(IJSpaceContainerAdmin proxy) {
        this.removeContainerTree(this.m_proxyServiceTable.get(proxy), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeContainerTree(DefaultMutableTreeNode containerNode, boolean isShutdownOperation) {
        JSpaceContainerProxyWrapper containerWrapperProxy;
        if (containerNode == null) {
            return;
        }
        if (containerNode.getUserObject() instanceof StaleContainerService) {
            return;
        }
        DefaultTreeModel defaultTreeModel = this.conTreeModel;
        synchronized (defaultTreeModel) {
            containerWrapperProxy = (JSpaceContainerProxyWrapper)containerNode.getUserObject();
            containerNode.setUserObject(new StaleContainerService(containerWrapperProxy.toString()));
            this.m_proxyServiceTable.remove(containerWrapperProxy.proxy());
            this._rmiContainersMap.remove(containerWrapperProxy.proxy());
            Repository.removeMBeanServerConnectionFromMap((IJSpaceContainerAdmin)containerWrapperProxy.proxy());
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("removeContainerTree() - ContainerName: " + containerWrapperProxy.getProxyName());
            }
            if (_logger.isLoggable(Level.FINER)) {
                _logger.finer("removeContainerTree() - DEBUG: " + JSpaceUtilities.getStackTrace((Throwable)new Exception("DEBUG")));
            }
            Repository.removeContainerConfigFromMap((IJSpaceContainerAdmin)containerWrapperProxy.proxy());
            for (int i = 0; i < containerNode.getChildCount(); ++i) {
                DefaultMutableTreeNode removedSpaceNode = (DefaultMutableTreeNode)containerNode.getChildAt(i);
                this.removeSpaceNode(removedSpaceNode);
            }
        }
        this.conTreeModel.removeNodeFromParent(containerNode);
        this.cleanContainerTables(containerWrapperProxy.toString(), false);
        this.conTree.repaint();
        boolean isSelectionEmpty = this.conTree.isSelectionEmpty();
        if (isSelectionEmpty) {
            this.setSelectedTreeNode(this.spacesRoot, true, false);
        }
    }

    void cleanContainerTables(String containerId, boolean isRemoveObjectFromProxiesMap) {
        Repository.removeContainerConfigFromMap(containerId);
        this.spaceConfigPanel.conConfigTable.remove(containerId);
        DefaultMutableTreeNode tn = SpaceBrowser.removeTreeNodeFromContainerTreeNodeTable(containerId);
        if (tn != null) {
            this.m_containerMutableNode.remove(tn);
            if (isRemoveObjectFromProxiesMap) {
                Object userObject = tn.getUserObject();
                if (userObject instanceof JSpaceContainerProxyWrapper) {
                    JSpaceContainerProxyWrapper wrapper = (JSpaceContainerProxyWrapper)userObject;
                    this.m_proxyServiceTable.remove(wrapper.proxy());
                    Repository.removeMBeanServerConnectionFromMap((IJSpaceContainerAdmin)wrapper.proxy());
                } else {
                    this.m_proxyServiceTable.remove(userObject);
                    Repository.removeMBeanServerConnectionFromMap((IJSpaceContainerAdmin)userObject);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.closeClusterMenuItem) {
            this.closeCluster(this.currentCluster.getClusterMembers(), this.curSelectedNode, true);
        }
    }

    private void closeCluster(ClusterMemberInfo[] clusterMemberInfoArray, MutableTreeNode selectedCluster, boolean isSelectNode) {
        String clusterName = selectedCluster.toString();
        this.closeClusterServices(clusterMemberInfoArray, clusterName);
        this.stopClusterStatisticsPanel(clusterName);
        TreePath selectPath = null;
        if (this.curSelPath != null) {
            selectPath = this.curSelPath.getParentPath();
        }
        this._clusterViewBrowser.removeCluster(selectedCluster.toString());
        this.conTreeModel.removeNodeFromParent(selectedCluster);
        if (selectPath != null && isSelectNode) {
            this.conTree.setSelectionPath(selectPath);
            this.doNodeSelected(selectPath);
        }
    }

    private void closeClusterServices(ClusterMemberInfo[] clusterMemberInfoArray, String clusterName) {
        ServiceManagerImpl serviceManagerImpl = this._clusterViewBrowser.getServiceManager();
        serviceManagerImpl.setCurrentClusterMembers(null, true);
        for (int i = 0; i < clusterMemberInfoArray.length; ++i) {
            ServiceID serviceId = this.getServiceId(serviceManagerImpl, clusterMemberInfoArray[i]);
            if (serviceId == null) continue;
            serviceManagerImpl.removeService(serviceId, clusterName);
        }
    }

    private ServiceID getServiceId(ServiceManagerImpl serviceManagerImpl, ClusterMemberInfo clusterMemberInfo) {
        String memberName = clusterMemberInfo.memberName;
        ServiceManagerImpl.ClusterMember clusterMember = serviceManagerImpl.getClusterMember(memberName);
        ServiceID serviceID = null;
        if (clusterMember != null) {
            serviceID = clusterMember.getServiceID();
        }
        return serviceID;
    }

    public IRemoteJSpaceAdmin getSpaceAdminObject(ServiceID spaceServiceID) {
        return this.spacesViewPanel.getSpaceAdminObject(spaceServiceID);
    }

    public String getJndiURL(ServiceID spaceServiceID) {
        return this.spacesViewPanel.getJndiURL(spaceServiceID);
    }

    public DefaultMutableTreeNode getServiceTreeeNode(ServiceID serviceID) {
        return this.m_serviceIDtable.get(serviceID);
    }

    public IJSpace getSpace(ServiceID serviceID) {
        Object userObject;
        DefaultMutableTreeNode treeNode = this.m_serviceIDtable.get(serviceID);
        IJSpace space = null;
        if (treeNode != null && (userObject = treeNode.getUserObject()) instanceof SpaceTreeNode) {
            space = ((SpaceTreeNode)userObject).getSpaceProxy();
        }
        return space;
    }

    public boolean isPersistentLRUSpace(ServiceID spaceServiceID) {
        return this.spacesViewPanel.isPersistentLRUSpace(spaceServiceID);
    }

    public boolean isMirrorService(ServiceID spaceServiceID) {
        return this.spacesViewPanel.isMirrorService(spaceServiceID);
    }

    public List<SpacesViewPanel.SpaceViewWrapper> getAllSpaces() {
        return this.spacesViewPanel.getAllSpaces();
    }

    public void showClusterPanel(EditCluster editCluster, boolean isClusterMemberSelected, boolean isServiceManagerThreadPaused, boolean isAddOperationsNode) {
        this.currentCluster = editCluster;
        this.mainConfigPanel.removeAll();
        this._clusterViewBrowser.setClusterView(editCluster, true, isClusterMemberSelected, isServiceManagerThreadPaused, isAddOperationsNode);
        this.mainConfigPanel.add((Component)this._clusterViewBrowser.getClusterPanel(), "Center");
        this.mainConfigPanel.validate();
    }

    public boolean isClustersTreeNodeSelected() {
        return JSpaceUIUtils.isRootInHierarchyOfSelectedNode(this.clusterRoot, this.conTree);
    }

    public void addClusterTree(ClusterTree clusterTree, DefaultMutableTreeNode clusterTreeNode, EditCluster editCluster, boolean isSelectAddedClusterNode) {
        String clusterName = editCluster.getClusterName();
        if (this.isClusterHasOnlyInactiveMembers(clusterName, true)) {
            this.conTreeModel.insertNodeInto(clusterTreeNode, this.clusterRoot, this.clusterRoot.getChildCount());
            this._clusterViewBrowser.putCluster(editCluster, clusterTree);
        } else {
            isSelectAddedClusterNode = false;
        }
        Object[] pn = this.conTreeModel.getPathToRoot(clusterTreeNode);
        TreePath clusterTreeNodePath = new TreePath(pn);
        this.conTree.expandPath(clusterTreeNodePath);
        if (isSelectAddedClusterNode) {
            this.conTree.setSelectionPath(clusterTreeNodePath);
        }
    }

    private boolean isClusterHasOnlyInactiveMembers(String clusterName, boolean closeClusterNodeIfNeed) {
        boolean returnedVal = true;
        if (this._clusterViewBrowser.containsCluster(clusterName)) {
            int childrenNodesCount = this.clusterRoot.getChildCount();
            for (int i = 0; i < childrenNodesCount; ++i) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)this.clusterRoot.getChildAt(i);
                if (!treeNode.toString().equals(clusterName)) continue;
                Object objNode = treeNode.getUserObject();
                EditCluster editCluster = (EditCluster)objNode;
                long curTime = System.currentTimeMillis();
                if (curTime - editCluster.getCreationTime() > 25000L) {
                    ClusterMemberInfo[] clusterMemberInfoArray = editCluster.getClusterMembers();
                    for (int j = 0; j < clusterMemberInfoArray.length; ++j) {
                        ClusterMemberInfo clusterMemberInfo = clusterMemberInfoArray[j];
                        ServiceID spaceMemberID = clusterMemberInfo.getSpaceID();
                        if (spaceMemberID == null || !this.m_serviceIDtable.containsKey(spaceMemberID) && !this._mirrorSpacesMap.containsKey(spaceMemberID)) continue;
                        returnedVal = false;
                        break;
                    }
                    if (!returnedVal || !closeClusterNodeIfNeed) break;
                    this.closeCluster(clusterMemberInfoArray, treeNode, false);
                    break;
                }
                returnedVal = false;
                break;
            }
        }
        return returnedVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] addSpaceNodes(DefaultTreeModel treeModel, DefaultMutableTreeNode containerNode, IJSpaceContainer containerProxy, String protocolName, boolean isRestructNodes) throws LostConnectionException, RemoteException, NoSuchNameException {
        for (int i = 0; i < containerNode.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)containerNode.getChildAt(i);
            Object obj = node.getUserObject();
            if (obj == null || !(obj instanceof JSpaceProxyWrapper)) continue;
            this.m_proxyServiceTable.remove(((JSpaceProxyWrapper)obj).proxy());
        }
        containerNode.removeAllChildren();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Protocol Name:" + protocolName);
        }
        if (protocolName.startsWith("jini:")) {
            return null;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Bringing spaces from container");
        }
        Object[] spaceNames = containerProxy.getSpaceNames();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("> added spaceNames: " + Arrays.toString(spaceNames) + " to container node:" + containerNode + ", THERAD: " + Thread.currentThread().toString());
        }
        DefaultTreeModel defaultTreeModel = this.conTreeModel;
        synchronized (defaultTreeModel) {
            if (isRestructNodes) {
                treeModel.reload(containerNode);
            }
            Repository.removeContainerConfigFromMap(containerNode.toString());
            this.spaceConfigPanel.conConfigTable.remove(containerNode.toString());
            IJSpaceContainerAdmin containerAdmin = (IJSpaceContainerAdmin)containerProxy;
            ContainerConfig containerConfig = Repository.addContainerToMap(containerAdmin);
            for (int i = 0; i < spaceNames.length; ++i) {
                IJSpace spaceProxy = null;
                Object spaceName = spaceNames[i];
                if (this.getChildTreeNodeByName(containerNode, (String)spaceName) != null) continue;
                try {
                    spaceProxy = containerProxy.getClusteredSpace((String)spaceName);
                }
                catch (Throwable e) {
                    String msg = "Failed to retrieve space proxy for \"" + (String)spaceName + "\" space:\n" + e.toString();
                    if (e instanceof Error || e instanceof ConnectException) {
                        if (!_logger.isLoggable(Level.SEVERE)) continue;
                        _logger.log(Level.SEVERE, msg, e);
                        continue;
                    }
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    _logger.log(Level.FINE, msg, e);
                    continue;
                }
                if (spaceProxy == null) {
                    spaceProxy = containerProxy.getSpace((String)spaceName);
                }
                if (this.m_proxyServiceTable.containsKey(spaceProxy)) continue;
                try {
                    boolean addSpaceOperationsNodes;
                    DefaultMutableTreeNode spaceTreeNode = SpaceBrowser.createSpaceNode(spaceProxy);
                    Repository.getInstance().addNonJiniManagedService(spaceProxy, spaceProxy.getName());
                    ServiceID spaceID = null;
                    if (spaceTreeNode.getUserObject() instanceof JSpaceProxyWrapper) {
                        spaceID = ((JSpaceProxyWrapper)spaceTreeNode.getUserObject()).getServiceID();
                    }
                    IRemoteJSpaceAdmin spaceAdmin = null;
                    SpaceConfig spaceConfig = null;
                    boolean isSecuredSpace = spaceProxy.isSecured();
                    spaceAdmin = Repository.addSpaceAdminObjectToMap(spaceProxy);
                    spaceConfig = Repository.addSpaceConfigToMap(spaceAdmin);
                    this.spacesViewPanel.addSpace(spaceProxy, spaceAdmin, spaceID, spaceConfig, containerConfig, isSecuredSpace);
                    boolean bl = addSpaceOperationsNodes = spaceConfig == null || !spaceConfig.isMirrorServiceEnabled();
                    if (addSpaceOperationsNodes) {
                        DefaultMutableTreeNode runtimeLeaf = new DefaultMutableTreeNode(CLASSES_LABEL);
                        treeModel.insertNodeInto(runtimeLeaf, spaceTreeNode, spaceTreeNode.getChildCount());
                        DefaultMutableTreeNode transactionsLeaf = new DefaultMutableTreeNode(TRANSACTIONS_LABEL);
                        treeModel.insertNodeInto(transactionsLeaf, spaceTreeNode, spaceTreeNode.getChildCount());
                        DefaultMutableTreeNode queryLeaf = new DefaultMutableTreeNode(SQL_LABEL);
                        treeModel.insertNodeInto(queryLeaf, spaceTreeNode, spaceTreeNode.getChildCount());
                        DefaultMutableTreeNode statisticsLeaf = new DefaultMutableTreeNode(STATISTICS_LABEL);
                        treeModel.insertNodeInto(statisticsLeaf, spaceTreeNode, spaceTreeNode.getChildCount());
                    }
                    DefaultMutableTreeNode connectionsLeaf = new DefaultMutableTreeNode(CONNECTIONS_LABEL);
                    treeModel.insertNodeInto(connectionsLeaf, spaceTreeNode, spaceTreeNode.getChildCount());
                    if (addSpaceOperationsNodes) {
                        DefaultMutableTreeNode benchMarkLeaf = new DefaultMutableTreeNode(BENCHMARK_LABEL);
                        treeModel.insertNodeInto(benchMarkLeaf, spaceTreeNode, spaceTreeNode.getChildCount());
                    }
                    if (_logger.isLoggable(Level.FINER)) {
                        _logger.finer("> insert space: " + spaceTreeNode + " to container node:" + containerNode + ", spaceID: " + spaceID);
                    }
                    treeModel.insertNodeInto(spaceTreeNode, containerNode, containerNode.getChildCount());
                    this.m_serviceIDtable.put(spaceID, spaceTreeNode);
                    this.checkForClusterdSpaceAndAddClusterToTree(spaceProxy, spaceID);
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine("addSpaceNodes:  ContainerName: [" + containerProxy.getName() + "] SpaceName: [" + spaceProxy.getName() + "] HashCode: " + spaceProxy.hashCode());
                    }
                    if (spaceTreeNode.getUserObject() instanceof JSpaceProxyWrapper) {
                        JSpaceProxyWrapper spaceProxyWrapper = (JSpaceProxyWrapper)spaceTreeNode.getUserObject();
                        SpaceMode spaceModeVal = PrimaryBackupIndicationListener.getInstance().getSpaceMode(spaceID);
                        short newSpaceMode = JSpaceUIUtils.getSpaceModeValue(spaceModeVal);
                        spaceProxyWrapper.setSpaceMode(newSpaceMode);
                    }
                    this.m_proxyServiceTable.put(spaceProxy, spaceTreeNode);
                    continue;
                }
                catch (Exception e) {
                    if (!_logger.isLoggable(Level.SEVERE)) continue;
                    _logger.log(Level.SEVERE, "*** addSpaceNodes(), adding space node " + JSpaceUtilities.createFullSpaceName((String)containerNode.toString(), (String)spaceName) + " + failed:" + e.toString(), e);
                }
            }
        }
        return spaceNames == null ? new String[]{} : spaceNames;
    }

    private synchronized DefaultMutableTreeNode getChildTreeNodeByName(TreeNode parentNode, String nameToAdd) {
        boolean isChildNodeAlreadyExists = false;
        DefaultMutableTreeNode childNode = null;
        for (int nodeIndex = 0; nodeIndex < parentNode.getChildCount(); ++nodeIndex) {
            childNode = (DefaultMutableTreeNode)parentNode.getChildAt(nodeIndex);
            if (!childNode.toString().equals(nameToAdd)) continue;
            isChildNodeAlreadyExists = true;
            break;
        }
        return isChildNodeAlreadyExists ? childNode : null;
    }

    void removeSpaceNode(ServiceID spaceID) {
        this._clusterViewBrowser.removeSpace(spaceID);
        this.spacesViewPanel.removeSpace(spaceID);
        this._mirrorSpacesMap.remove(spaceID);
        DefaultMutableTreeNode spaceNode = this.m_serviceIDtable.remove(spaceID);
        if (spaceNode != null) {
            this.removeSpaceNode(spaceNode);
        }
    }

    void removeSpaceNode(IJSpace spaceProxy) {
        this.removeSpaceNode(this.m_proxyServiceTable.get(spaceProxy));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSpaceNode(DefaultMutableTreeNode spaceNode) {
        String containerName;
        if (spaceNode == null) {
            return;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("%%% Space Node removed:" + spaceNode.toString() + " Space node hash code:" + spaceNode.hashCode());
            String callTrace = JSpaceUtilities.getStackTrace((Throwable)new Exception());
            _logger.finest("%%% Debug call trace during space node removing \"" + spaceNode.toString() + "\":" + callTrace);
        }
        IJSpace removedProxy = null;
        ServiceID spaceID = null;
        DefaultTreeModel defaultTreeModel = this.conTreeModel;
        synchronized (defaultTreeModel) {
            Object conProxy;
            Object spaceId;
            StatisticPanel statisticsPanel;
            if (spaceNode.getUserObject() instanceof StaleSpaceService) {
                return;
            }
            if (this._availableClusteredSpaceTreeNodeMap.containsValue(spaceNode)) {
                Set<Map.Entry<String, DefaultMutableTreeNode>> entriesSet = this._availableClusteredSpaceTreeNodeMap.entrySet();
                for (Map.Entry<String, DefaultMutableTreeNode> mapEntry : entriesSet) {
                    if (!spaceNode.equals(mapEntry.getValue())) continue;
                    this._availableClusteredSpaceTreeNodeMap.remove(mapEntry.getKey());
                    break;
                }
            }
            Object spaceProxy = spaceNode.getUserObject();
            DefaultMutableTreeNode conNode = (DefaultMutableTreeNode)spaceNode.getParent();
            if (conNode == null) {
                return;
            }
            this.conTreeModel.removeNodeFromParent(spaceNode);
            if (spaceProxy instanceof SpaceTreeNode && (statisticsPanel = this.statisticsPerSpace.get(spaceId = ((SpaceTreeNode)spaceProxy).getSpaceObjectID())) != null) {
                statisticsPanel.stopRefresh();
                this.statisticsPerSpace.remove(spaceId);
            }
            containerName = (conProxy = conNode.getUserObject()) instanceof JSpaceContainerProxyWrapper ? ((JSpaceContainerProxyWrapper)conProxy).getProxyName() : ((StaleContainerService)conProxy).getContainerName();
            if (spaceProxy instanceof JSpaceProxyWrapper) {
                removedProxy = (IJSpace)((JSpaceProxyWrapper)spaceProxy).proxy();
                spaceID = ((JSpaceProxyWrapper)spaceProxy).getServiceID();
            }
            this._clusterViewBrowser.removeSpace(spaceID);
            PrimaryBackupIndicationListener.getInstance().removeSpace(spaceID);
            this.cleanDestroyedSpaceFromInternalMaps(removedProxy, spaceID, containerName);
            this.spacesViewPanel.removeSpace(spaceID);
            this._mirrorSpacesMap.remove(spaceID);
            spaceNode.setUserObject(new StaleSpaceService(removedProxy.getName(), containerName));
            this.removeContainerTree(conNode, false);
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.finer("removeSpaceNode() - ContainerName: " + containerName + " SpaceName: " + removedProxy.getName() + ", spaceID:" + spaceID);
        }
        this.m_StaleServiceCleaner.addServiceNode(spaceNode);
        this.conTree.repaint();
        boolean isSelectionEmpty = this.conTree.isSelectionEmpty();
        if (isSelectionEmpty) {
            this.setSelectedTreeNode(this.spacesRoot, true, false);
        }
    }

    private void cleanDestroyedSpaceFromInternalMaps(IJSpace removedProxy, ServiceID spaceID, String containerName) {
        this.m_proxyServiceTable.remove(removedProxy);
        this.m_serviceIDtable.remove(spaceID);
        Hashtable<String, SpaceConfig> spaceConfigTable = this.spaceConfigPanel.conConfigTable.get(containerName);
        if (spaceConfigTable != null) {
            spaceConfigTable.remove(removedProxy.getName());
        }
        IRemoteJSpaceAdmin removedSpaceAdmin = Repository.removeSpaceAdminObjectFromMap(removedProxy);
        Collection<ClusterStatisticPanel> clusterStaticPanels = this.statisticsPerCluster.values();
        for (ClusterStatisticPanel clusterStatisticPanel : clusterStaticPanels) {
            clusterStatisticPanel.removedSpace(spaceID);
        }
        Set<Map.Entry<String, Set<IJSpace>>> allSpacesEntriesSet = this._allClusteredSpaces.entrySet();
        for (Map.Entry<String, Set<IJSpace>> mapEntry : allSpacesEntriesSet) {
            Set<IJSpace> set = mapEntry.getValue();
            if (!set.remove(removedProxy)) continue;
            if (set.size() != 0) break;
            String clusterName = mapEntry.getKey();
            this.stopClusterStatisticsPanel(clusterName);
            this.removeClusterNode(clusterName);
            break;
        }
    }

    private void stopClusterStatisticsPanel(String clusterName) {
        ClusterStatisticPanel clusterStatisticPanel = this.statisticsPerCluster.get(clusterName);
        if (clusterStatisticPanel != null) {
            clusterStatisticPanel.stopRefresh();
        }
    }

    private void removeClusterNode(String clusterName) {
        ClusterTree clusterTree = this._clusterViewBrowser.getClusterTree(clusterName);
        DefaultMutableTreeNode clusterNode = clusterTree.getRoot();
        this.conTreeModel.removeNodeFromParent(clusterNode);
        this._clusterViewBrowser.removeCluster(clusterName);
        this._clusterViewApplications.removeCluster(clusterName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSpaceNode(IJSpaceContainer containerProxy, String containerName, IJSpace spaceProxy, ServiceID spaceID, String protocolName) throws RemoteException {
        this.addContainerTree(containerProxy, containerName, protocolName, false);
        DefaultMutableTreeNode spaceTreeNode = null;
        DefaultMutableTreeNode conNode = this.m_proxyServiceTable.get(containerProxy);
        if (conNode == null) {
            return;
        }
        String spaceName = spaceProxy.getName();
        DefaultTreeModel defaultTreeModel = this.conTreeModel;
        synchronized (defaultTreeModel) {
            boolean addSpaceOperationsNodes;
            spaceTreeNode = this.getChildTreeNodeByName(conNode, spaceName);
            if (spaceTreeNode != null) {
                if (spaceID != null) {
                    this.m_serviceIDtable.put(spaceID, spaceTreeNode);
                }
                this.m_proxyServiceTable.put(spaceProxy, spaceTreeNode);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("> before RETURN 1:" + spaceID + " , for second check if hashtable contains space: " + this.m_proxyServiceTable.containsKey(spaceProxy));
                }
                return;
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("addSpaceNode: ContainerName: " + conNode.toString() + " SpaceName: " + spaceProxy.getName() + " HashCode: " + spaceProxy.hashCode());
            }
            if (this.m_proxyServiceTable.containsKey(spaceProxy)) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("> before RETURN 2:" + spaceID);
                }
                return;
            }
            spaceTreeNode = SpaceBrowser.createSpaceNode(spaceProxy);
            this.m_proxyServiceTable.put(spaceProxy, spaceTreeNode);
            this.m_serviceIDtable.put(spaceID, spaceTreeNode);
            IJSpaceContainerAdmin containerAdmin = (IJSpaceContainerAdmin)containerProxy;
            ContainerConfig containerConfig = Repository.addContainerToMap(containerAdmin);
            IRemoteJSpaceAdmin spaceAdmin = null;
            SpaceConfig spaceConfig = null;
            boolean isSecuredSpace = spaceProxy.isSecured();
            spaceAdmin = Repository.addSpaceAdminObjectToMap(spaceProxy);
            spaceConfig = Repository.addSpaceConfigToMap(spaceAdmin);
            DefaultMutableTreeNode runtimeLeaf = new DefaultMutableTreeNode(CLASSES_LABEL);
            DefaultMutableTreeNode transactionsLeaf = new DefaultMutableTreeNode(TRANSACTIONS_LABEL);
            DefaultMutableTreeNode queryLeaf = new DefaultMutableTreeNode(SQL_LABEL);
            DefaultMutableTreeNode statisticsLeaf = new DefaultMutableTreeNode(STATISTICS_LABEL);
            DefaultMutableTreeNode connectionsLeaf = new DefaultMutableTreeNode(CONNECTIONS_LABEL);
            boolean bl = addSpaceOperationsNodes = spaceConfig == null || !spaceConfig.isMirrorServiceEnabled();
            if (addSpaceOperationsNodes) {
                spaceTreeNode.add(runtimeLeaf);
                spaceTreeNode.add(transactionsLeaf);
                spaceTreeNode.add(queryLeaf);
                spaceTreeNode.add(statisticsLeaf);
            }
            spaceTreeNode.add(connectionsLeaf);
            if (addSpaceOperationsNodes) {
                DefaultMutableTreeNode benchmarkLeaf = new DefaultMutableTreeNode(BENCHMARK_LABEL);
                spaceTreeNode.add(benchmarkLeaf);
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("> before addSpace to spaces list, insert space: " + spaceID);
            }
            this.spacesViewPanel.addSpace(spaceProxy, spaceAdmin, spaceID, spaceConfig, containerConfig, isSecuredSpace);
            int nodeIndex = conNode.getChildCount();
            if (_logger.isLoggable(Level.FINER)) {
                _logger.finer("> addSpaceNode, insert space: " + spaceTreeNode + " to container node: " + conNode + ", THERAD: " + Thread.currentThread().toString());
            }
            this.conTreeModel.insertNodeInto(spaceTreeNode, conNode, nodeIndex);
            this.checkForClusterdSpaceAndAddClusterToTree(spaceProxy, spaceID);
        }
        Object[] nodes = this.conTreeModel.getPathToRoot(conNode);
        TreePath path = new TreePath(nodes);
        if (!this.conTree.isExpanded(path)) {
            this.conTree.expandPath(path);
        }
    }

    private void addSpaceToAllClusteredSpacesHashtable(IJSpace space, String clusterName) {
        Set<IJSpace> clusterdSpacesSet = this._allClusteredSpaces.get(clusterName);
        if (clusterdSpacesSet == null) {
            clusterdSpacesSet = new HashSet<IJSpace>();
            this._allClusteredSpaces.put(clusterName, clusterdSpacesSet);
        }
        clusterdSpacesSet.add(space);
    }

    private void checkForClusterdSpaceAndAddClusterToTree(IJSpace spaceProxy, ServiceID spaceID) {
        block17: {
            if (spaceProxy == null) {
                return;
            }
            try {
                IRemoteJSpaceAdmin adminObj = Repository.addSpaceAdminObjectToMap(spaceProxy);
                SpaceConfig spaceConfig = Repository.addSpaceConfigToMap(adminObj);
                IJSpaceContainerAdmin containerAdmin = (IJSpaceContainerAdmin)spaceProxy.getDirectProxy().getContainer();
                ContainerConfig containerConfig = Repository.addContainerToMap(containerAdmin);
                if (spaceConfig == null || spaceConfig.isPrivate() || !spaceConfig.isClustered()) {
                    if (spaceConfig != null && spaceConfig.isMirrorServiceEnabled()) {
                        String memberName = JSpaceUtilities.createFullSpaceName((String)containerConfig.containerName, (String)spaceConfig.getSpaceName());
                        this._clusterViewBrowser.setSpaceID(spaceID, memberName);
                        this._clusterViewApplications.setSpaceID(spaceID, memberName);
                        this._mirrorSpacesMap.put(spaceID, memberName);
                    }
                    return;
                }
                SpaceClusterInfo clusterInfo = spaceConfig.getClusterInfo();
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, ">> add cluster=" + spaceID + ", jini enabled:" + containerConfig.isJiniLusEnabled() + ", is clustered: " + clusterInfo.isClustered());
                }
                if (clusterInfo.isClustered()) {
                    EditCluster curSelectedCluster;
                    String selctedClusterName;
                    String clusterName = clusterInfo.getClusterName();
                    if (containerConfig.isJiniLusEnabled()) {
                        PrimaryBackupIndicationListener.getInstance().addSpace(spaceProxy, spaceID);
                    } else {
                        ServiceItem serviceItem = JSpaceUIUtils.createSpaceServiceItem(spaceProxy, spaceID, spaceConfig.getSpaceName(), containerConfig.containerName, clusterName);
                        Repository.getInstance().addService(serviceItem);
                        this._clusterViewBrowser.getServiceManager().addService(serviceItem);
                    }
                    if (this.curSelectedNode != null && this.curSelectedNode.getUserObject() instanceof EditCluster && clusterName.equals(selctedClusterName = (curSelectedCluster = (EditCluster)this.curSelectedNode.getUserObject()).getClusterName())) {
                        this._clusterViewBrowser.refreshClusterSpaces();
                    }
                    if (this.isClusterHasOnlyInactiveMembers(clusterName, true)) {
                        byte[] array = ((IInternalRemoteJSpaceAdmin)adminObj).getClusterConfigFile();
                        if (array != null) {
                            boolean isUnmanagedSpace;
                            if (_logger.isLoggable(Level.FINEST)) {
                                _logger.finest("Cluster config file for cluster [" + clusterName + "], is [" + new String(array) + "]");
                            }
                            ByteArrayInputStream in = new ByteArrayInputStream(array);
                            String clusterConfigUrl = spaceConfig.getClusterConfigURL();
                            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                            DocumentBuilder docBuilder = factory.newDocumentBuilder();
                            Document doc = docBuilder.parse(in);
                            boolean bl = isUnmanagedSpace = !spaceProxy.isStartedWithinGSC();
                            if (!this._clusterViewBrowser.containsCluster(clusterName) || !this._clusterViewApplications.containsCluster(clusterName)) {
                                EditCluster editCluster = new EditCluster(clusterConfigUrl, doc, spaceConfig);
                                this._clusterViewBrowser.addCluster(editCluster, clusterName, false, spaceID, isUnmanagedSpace);
                                this._clusterViewApplications.addCluster(editCluster, clusterName, false, spaceID, isUnmanagedSpace);
                            }
                            for (Map.Entry<ServiceID, String> mapEntry : this._mirrorSpacesMap.entrySet()) {
                                ServiceID mirrorServiceID = mapEntry.getKey();
                                String mirrorMemberName = mapEntry.getValue();
                                this._clusterViewBrowser.setSpaceID(mirrorServiceID, mirrorMemberName);
                                this._clusterViewApplications.setSpaceID(mirrorServiceID, mirrorMemberName);
                            }
                        }
                    } else {
                        this.expandClusterTree(clusterName);
                    }
                    String memberName = JSpaceUtilities.createFullSpaceName((String)containerConfig.containerName, (String)spaceConfig.getSpaceName());
                    this._clusterViewBrowser.setSpaceID(clusterName, spaceID, memberName);
                    this._clusterViewApplications.setSpaceID(clusterName, spaceID, memberName);
                    this.addSpaceToAllClusteredSpacesHashtable(spaceProxy, clusterName);
                }
            }
            catch (CreateException e) {
                SpaceBrowser.showException(e.toString(), e);
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block17;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    private void expandClusterTree(String clusterName) {
        int childCount = this.clusterRoot.getChildCount();
        TreeNode desiredClusterNode = this.clusterRoot;
        for (int i = 0; i < childCount; ++i) {
            TreeNode clusterNode = this.clusterRoot.getChildAt(i);
            String name = clusterNode.toString();
            if (!name.equals(clusterName)) continue;
            desiredClusterNode = clusterNode;
            break;
        }
        Object[] pn = this.conTreeModel.getPathToRoot(desiredClusterNode);
        TreePath clusterTreeNodePath = new TreePath(pn);
        this.conTree.expandPath(clusterTreeNodePath);
    }

    void setEnable(Vector<JComponent> componets, boolean enabled) {
        for (JComponent comp : componets) {
            comp.setEnabled(enabled);
        }
    }

    public boolean isServicesDisplayed() {
        return this.spacesRoot.getChildCount() > 0;
    }

    private void setEnableSpaceControls(IJSpace spaceProxy) {
        Object userObj;
        if (spaceProxy == null) {
            return;
        }
        int state = 4;
        DefaultMutableTreeNode treeNode = this.m_proxyServiceTable.get(spaceProxy);
        if (treeNode instanceof DefaultMutableTreeNode && (userObj = treeNode.getUserObject()) instanceof JSpaceProxyWrapper) {
            JSpaceProxyWrapper proxyWrapper = (JSpaceProxyWrapper)userObj;
            state = proxyWrapper.getState();
        }
        boolean started = state == 1;
        this.setEnable(this.spaceEnableComp, started);
    }

    void showStatus(String message) {
    }

    public DefaultMutableTreeNode getSelectedTreeNode() {
        if (this.curSelectedNode != null && !(this.curSelectedNode.getUserObject() instanceof StaleSpaceService) && !(this.curSelectedNode.getUserObject() instanceof StaleContainerService)) {
            return this.curSelectedNode;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectSpaceOperationNode(ServiceID spaceID, String childNodeName) {
        block5: {
            try {
                this._parentFrame.setCursor(Cursor.getPredefinedCursor(3));
                this._parentFrame.selectSpaceBrowserTab();
                DefaultMutableTreeNode spaceNode = this.m_serviceIDtable.get(spaceID);
                if (spaceNode == null) break block5;
                if (childNodeName == null) {
                    this.setSelectedTreeNode(spaceNode, true, true);
                    break block5;
                }
                int childCount = spaceNode.getChildCount();
                for (int childIndex = 0; childIndex < childCount; ++childIndex) {
                    TreeNode childNode = spaceNode.getChildAt(childIndex);
                    if (!childNode.toString().equals(childNodeName)) continue;
                    this.setSelectedTreeNode((DefaultMutableTreeNode)childNode, true, true);
                    break;
                }
            }
            finally {
                this._parentFrame.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectClusterOperationNode(String clusterName, String childNodeName) {
        try {
            TreeNode searchedOperationNode;
            TreeNode operationsNode;
            this._parentFrame.setCursor(Cursor.getPredefinedCursor(3));
            TreeNode clusterNode = JSpaceUIUtils.getChildTreeNode(this.clusterRoot, clusterName);
            if (clusterNode != null && (operationsNode = JSpaceUIUtils.getChildTreeNode(clusterNode, OPERATIONS_NODE_LABEL)) != null && (searchedOperationNode = JSpaceUIUtils.getChildTreeNode(operationsNode, childNodeName)) != null) {
                this.setSelectedTreeNode((DefaultMutableTreeNode)searchedOperationNode, true, true);
            }
        }
        finally {
            this._parentFrame.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void selectSpaceNode(String hostName, String containerName, String spaceName) {
        String containerDisplayName = JSpaceUtilities.createContainerPresentName((String)hostName, (String)containerName);
        DefaultMutableTreeNode containerNode = containerTreeNodeTable.get(containerDisplayName);
        if (containerNode != null) {
            int childCount = containerNode.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                DefaultMutableTreeNode spaceNode = (DefaultMutableTreeNode)containerNode.getChildAt(i);
                if (!spaceNode.toString().equals(spaceName)) continue;
                this.setSelectedTreeNode(spaceNode, true, true);
                break;
            }
        }
    }

    public short getSpaceMode(ServiceID serviceID) {
        Object userObject;
        short spaceMode = -1;
        DefaultMutableTreeNode treeNode = this.m_serviceIDtable.get(serviceID);
        if (treeNode != null && (userObject = treeNode.getUserObject()) instanceof JSpaceProxyWrapper) {
            JSpaceProxyWrapper spaceProxyWrapper = (JSpaceProxyWrapper)userObject;
            spaceMode = spaceProxyWrapper.getSpaceMode();
        }
        return spaceMode;
    }

    public void setSpaceMode(ServiceID spaceID, short spaceMode) {
        Object userObject;
        DefaultMutableTreeNode treeNode = this.m_serviceIDtable.get(spaceID);
        if (treeNode != null && (userObject = treeNode.getUserObject()) instanceof JSpaceProxyWrapper) {
            JSpaceProxyWrapper spaceProxyWrapper = (JSpaceProxyWrapper)userObject;
            spaceProxyWrapper.setSpaceMode(spaceMode);
        }
    }

    public void setSelectedTreeNode(DefaultMutableTreeNode selectedNode, boolean isSelectTreeNode, boolean isExpandTreeNode) {
        TreePath selPath = null;
        if (selectedNode == null) {
            this.setEnable(this.spaceEnableComp, false);
            this.setEnable(this.containerEnableComp, false);
            return;
        }
        if (isSelectTreeNode) {
            Object[] pn = this.conTreeModel.getPathToRoot(selectedNode);
            selPath = new TreePath(pn);
            this.conTree.scrollPathToVisible(selPath);
            this.conTree.setSelectionPath(selPath);
            this.doNodeSelected(selPath);
        }
        if (selPath != null && isExpandTreeNode && !this.conTree.isExpanded(selPath)) {
            this.conTree.expandPath(selPath);
        }
    }

    public void setSelectedTreeNode(DefaultMutableTreeNode selectedNode) {
        this.setSelectedTreeNode(selectedNode, false, false);
    }

    private void runCommand(String[] commandArray) {
        block3: {
            if (commandArray != null) {
                try {
                    Runtime.getRuntime().exec(commandArray);
                }
                catch (IOException ioe) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block3;
                    _logger.log(Level.SEVERE, ioe.toString(), ioe);
                }
            }
        }
    }

    private void exit(int status) {
        this._clusterViewBrowser.getServiceManager().shutdown();
    }

    public void debug(Throwable th) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, th.getMessage(), th);
        }
    }

    public static void showException(String msg, Throwable ex) {
        if (expDialog != null) {
            expDialog.showException(msg, ex);
        }
    }

    public static void showException(String messagePrefix, String msg, Throwable ex) {
        if (expDialog != null) {
            expDialog.showException(messagePrefix, msg, ex);
        }
    }

    public JTree getContainerTree() {
        return this.conTree;
    }

    public static SpaceBrowserMainContainer getMainPanel(MainUI parentFrame, ClusterViewDlg clusterViewDialog) {
        _logger = Logger.getLogger("com.gigaspaces.admin.ui.spacebrowser");
        if (instance == null) {
            instance = new SpaceBrowser(parentFrame, clusterViewDialog);
        }
        return instance.getMainContainer();
    }

    private static void prepareRmiGC() {
        block4: {
            try {
                if (System.getProperty("sun.rmi.dgc.client.gcInterval") == null) {
                    System.setProperty("sun.rmi.dgc.client.gcInterval", "36000000");
                }
                if (System.getProperty("sun.rmi.dgc.server.gcInterval") == null) {
                    System.setProperty("sun.rmi.dgc.server.gcInterval", "36000000");
                }
            }
            catch (Exception secExc) {
                if (!_logger.isLoggable(Level.WARNING)) break block4;
                _logger.log(Level.WARNING, "Failed to set sun.rmi.dgc.xxx system properties. \n", secExc);
            }
        }
    }

    public SpaceBrowserMainContainer getMainContainer() {
        return this.mainContainer;
    }

    public void serviceAuthenticated(ServiceItem serviceItem, boolean isLoginSucceed, Authentication authentication, String failureMessage) {
        DefaultMutableTreeNode parentParentTreeNode;
        DefaultMutableTreeNode parentTreeNode;
        DefaultMutableTreeNode selTreeNode;
        TreePath selTreePath = this.conTree.getSelectionPath();
        if (serviceItem.service instanceof IJSpace && selTreePath != null && (selTreeNode = (DefaultMutableTreeNode)selTreePath.getLastPathComponent()) != null && (parentTreeNode = (DefaultMutableTreeNode)selTreeNode.getParent()) != null && (parentParentTreeNode = (DefaultMutableTreeNode)parentTreeNode.getParent()) != null) {
            Object userParentObj = parentTreeNode.getUserObject();
            Object userParentParentObj = parentParentTreeNode.getUserObject();
            if (userParentObj.equals(OPERATIONS_NODE_LABEL) && userParentParentObj instanceof EditCluster || userParentObj instanceof SpaceTreeNode && ((SpaceTreeNode)userParentObj).getServiceID().equals((Object)serviceItem.serviceID)) {
                this.curSelectedNode = null;
                this.setSelectedTreeNode(selTreeNode, true, false);
            }
        }
    }

    public void clearBenchmarks() {
        this.benchmarkPanelsPerCluster.clear();
        BenchMarkPanelFactory.instance().clear();
    }

    public void onError(String description, Throwable exc) {
        expDialog.showException(description, exc);
    }

    public void onStopTest() {
    }

    public static String getSuspendTypeName(IInternalRemoteJSpaceAdmin admin) throws RemoteException {
        String retValue;
        block8: {
            retValue = "";
            try {
                RuntimeHolder runtimeHolder = admin.getRuntimeHolder();
                SuspendInfo suspendInfo = runtimeHolder.getSuspendInfo();
                if (suspendInfo != null) {
                    SuspendType suspendType = suspendInfo.getSuspendType();
                    switch (suspendType) {
                        case QUIESCED: {
                            retValue = ResourceBundleHandler.getInstance().getResource("spaceSuspendTypeQuiesced");
                            break;
                        }
                        case DEMOTING: {
                            retValue = ResourceBundleHandler.getInstance().getResource("spaceSuspendTypeDemoting");
                            break;
                        }
                        case DISCONNECTED: {
                            retValue = ResourceBundleHandler.getInstance().getResource("spaceSuspendTypeDisconnected");
                        }
                    }
                }
            }
            catch (InactiveSpaceException ise) {
                if (!_logger.isLoggable(Level.FINER)) break block8;
                _logger.log(Level.FINER, ise.toString(), ise);
            }
        }
        return retValue;
    }

    static {
        containerTreeNodeTable = new Hashtable(3);
    }

    public class SpaceBrowserMainContainer
    extends JPanel
    implements IServiceGridUIComponent {
        public void serviceAdded(ServiceItem item) {
            if (item.service instanceof IJSpace || item.service instanceof IJSpaceContainer) {
                SpaceBrowser.this.sdmListener.serviceAdded(item);
            }
        }

        public void serviceRemoved(ServiceItem item) {
            if (item.service instanceof IJSpace || item.service instanceof IJSpaceContainer) {
                SpaceBrowser.this.sdmListener.serviceRemoved(item);
            }
        }

        public void serviceChanged(ServiceItem item) {
        }

        @Override
        public JMenu[] getMenus() {
            return SpaceBrowser.this._menusArray;
        }

        @Override
        public JLabel getStatusBar() {
            return SpaceBrowser.this._statusBar;
        }

        @Override
        public JButton[] getToolBarButtons() {
            return SpaceBrowser.this._toolbarButtonsArray;
        }

        @Override
        public String getComponentName() {
            return "Space Browser";
        }

        @Override
        public String getComponentToolTip() {
            return "Space View";
        }

        @Override
        public void closeServices() {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("!!!! closeServices()");
            }
            SpaceBrowser.this.onClose();
        }

        @Override
        public void resetInternalWindows() {
            SpaceBrowser.this.mainContainer.removeAll();
            SpaceBrowser.this.initRootWindow();
            SpaceBrowser.this._clusterViewBrowser.getGroupPanel().resetView();
        }
    }

    class LaunchVisualVmAction
    implements ActionListener {
        LaunchVisualVmAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent event) {
            IJSpaceContainerAdmin containerAdmin;
            Object proxyObject;
            DefaultMutableTreeNode selectedServiceNode = SpaceBrowser.this.getSelectedTreeNode();
            if (selectedServiceNode == null) {
                return;
            }
            Object userObject = selectedServiceNode.getUserObject();
            if (userObject instanceof JSpaceProxyWrapper) {
                proxyObject = ((JSpaceProxyWrapper)userObject).proxy();
                containerAdmin = (IJSpaceContainerAdmin)((IJSpace)proxyObject).getDirectProxy().getContainer();
            } else if (userObject instanceof JSpaceContainerProxyWrapper) {
                proxyObject = ((JSpaceContainerProxyWrapper)userObject).proxy();
                containerAdmin = (IJSpaceContainerAdmin)proxyObject;
            } else {
                return;
            }
            try {
                SpaceBrowser.this._parentFrame.setCursor(Cursor.getPredefinedCursor(3));
                ContainerConfig containerConfig = Repository.getContainerConfig(containerAdmin);
                String jndiURL = containerConfig.jndiUrl;
                String jmxServiceURL = JMXUtilities.createJMXUrl((String)jndiURL);
                JConsoleUIUtils.VisualVmFileVerifierWrapper visualVmFileVerifierWrapper = JConsoleUIUtils.checkJVisualVMFile(SpaceBrowser.this._parentFrame, _logger);
                if (visualVmFileVerifierWrapper.exists()) {
                    String[] commandArray = JConsoleUIUtils.createJVisualVmCommand(jmxServiceURL, SpaceBrowser.this._calculatedJavaHome, visualVmFileVerifierWrapper.getjVisualVmAppFile());
                    SpaceBrowser.this.runCommand(commandArray);
                } else if (visualVmFileVerifierWrapper.isShowMessage()) {
                    JConsoleUIUtils.showVisualVmFileNotFoundMessage(SpaceBrowser.this._parentFrame, visualVmFileVerifierWrapper);
                }
            }
            catch (Exception e) {
                expDialog.showException(e.toString(), e);
            }
            finally {
                SpaceBrowser.this._parentFrame.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    class LaunchJConsoleAction
    implements ActionListener {
        LaunchJConsoleAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent event) {
            IJSpaceContainerAdmin containerAdmin;
            Object proxyObject;
            DefaultMutableTreeNode selectedServiceNode = SpaceBrowser.this.getSelectedTreeNode();
            if (selectedServiceNode == null) {
                return;
            }
            Object userObject = selectedServiceNode.getUserObject();
            if (userObject instanceof JSpaceProxyWrapper) {
                proxyObject = ((JSpaceProxyWrapper)userObject).proxy();
                containerAdmin = (IJSpaceContainerAdmin)((IJSpace)proxyObject).getDirectProxy().getContainer();
            } else if (userObject instanceof JSpaceContainerProxyWrapper) {
                proxyObject = ((JSpaceContainerProxyWrapper)userObject).proxy();
                containerAdmin = (IJSpaceContainerAdmin)proxyObject;
            } else {
                return;
            }
            try {
                SpaceBrowser.this._parentFrame.setCursor(Cursor.getPredefinedCursor(3));
                ContainerConfig containerConfig = Repository.getContainerConfig(containerAdmin);
                String jndiURL = containerConfig.jndiUrl;
                String jmxServiceURL = JMXUtilities.createJMXUrl((String)jndiURL);
                String[] commandArray = JConsoleUIUtils.createJConsoleCommand(SpaceBrowser.this.getParentFrame(), jmxServiceURL, SpaceBrowser.this._calculatedJavaHome, true);
                SpaceBrowser.this.runCommand(commandArray);
            }
            catch (Exception e) {
                expDialog.showException(e.toString(), e);
            }
            finally {
                SpaceBrowser.this._parentFrame.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    class ShowContainerDumpAction
    implements ActionListener {
        ShowContainerDumpAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent event) {
            DefaultMutableTreeNode selTreeNode = SpaceBrowser.this.getSelectedTreeNode();
            if (selTreeNode == null) {
                return;
            }
            DefaultMutableTreeNode containerNode = null;
            Object userObject = selTreeNode.getUserObject();
            Object proxy = null;
            if (userObject instanceof JSpaceProxyWrapper) {
                proxy = ((IDirectSpaceProxy)((JSpaceProxyWrapper)userObject).proxy()).getContainer();
                containerNode = (DefaultMutableTreeNode)selTreeNode.getParent();
            } else {
                proxy = ((JSpaceContainerProxyWrapper)userObject).proxy();
                containerNode = selTreeNode;
            }
            IJSpaceContainerAdmin containerAdmin = (IJSpaceContainerAdmin)proxy;
            try {
                SpaceBrowser.this._parentFrame.setCursor(Cursor.getPredefinedCursor(3));
                if (SpaceBrowser.this.dumpResultsFrame == null) {
                    SpaceBrowser.this.dumpResultsFrame = new ShowDumpResultsFrame();
                    SpaceBrowser.this.dumpResultsFrame.setLocationRelativeTo(SpaceBrowser.this._parentFrame);
                }
                String dumpStr = containerAdmin.getRuntimeConfigReport();
                SpaceBrowser.this.dumpResultsFrame.setDump(dumpStr, containerNode.toString());
                SpaceBrowser.this.dumpResultsFrame.setVisible(true);
            }
            catch (Exception e) {
                expDialog.showException("Configuration report results for <" + containerNode.toString() + " >", e);
            }
            finally {
                SpaceBrowser.this._parentFrame.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    class PingSpaceAL
    implements ActionListener {
        PingSpaceAL() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final DefaultMutableTreeNode spaceNode = SpaceBrowser.this.getSelectedTreeNode();
            if (spaceNode == null) {
                return;
            }
            final IJSpace spaceAdmin = (IJSpace)((JSpaceProxyWrapper)spaceNode.getUserObject()).proxy();
            final ProgressMonitorBar pb = new ProgressMonitorBar(SpaceBrowser.this._parentFrame, "Ping to space:", spaceNode.toString());
            Thread pingThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        spaceAdmin.ping();
                        pb.terminate();
                        SpaceBrowser.this.showStatus(spaceNode + " space is alive!");
                        JOptionPane.showMessageDialog(SpaceBrowser.this._parentFrame, spaceNode + " space is alive!", "Ping to Server...", 1);
                    }
                    catch (Exception ex) {
                        SpaceBrowser.this.showStatus("Ping to " + spaceNode + " space failed: " + ex.getMessage());
                        pb.terminate();
                        expDialog.showException("ping to " + spaceNode + " space", ex);
                    }
                }
            });
            pb.start();
            pingThread.start();
        }
    }

    class TreeRenderer
    extends DefaultTreeCellRenderer {
        final ImageIcon spacesRootIcon;
        final ImageIcon containerTreeIcon;
        final ImageIcon runtimeIcon;
        final ImageIcon containerStaleIcon;
        final ImageIcon spaceStaleIcon;
        final ImageIcon transactionsIcon;
        final ImageIcon sqlIcon;
        final ImageIcon statisticsIcon;
        final ImageIcon connectionsIcon;
        final ImageIcon benchmarkIcon;
        final ImageIcon clustersRootIcon;
        final ImageIcon operationsIcon;
        final ImageIcon clusterIcon;
        final ImageIcon groupIcon;

        public TreeRenderer() {
            String[] treeIcons = JSpaceUIUtils.getResources("tree.icons");
            this.runtimeIcon = new ImageIcon(this.getClass().getResource("/image/browser/" + treeIcons[0]));
            this.containerTreeIcon = new ImageIcon(this.getClass().getResource("/image/browser/" + treeIcons[1]));
            this.containerStaleIcon = new ImageIcon(this.getClass().getResource("/image/browser/" + treeIcons[3]));
            this.spaceStaleIcon = new ImageIcon(this.getClass().getResource("/image/browser/" + treeIcons[4]));
            this.transactionsIcon = new ImageIcon(this.getClass().getResource("/image/browser/" + treeIcons[10]));
            this.sqlIcon = new ImageIcon(this.getClass().getResource("/image/browser/" + treeIcons[6]));
            this.statisticsIcon = new ImageIcon(this.getClass().getResource("/image/browser/" + treeIcons[7]));
            this.connectionsIcon = new ImageIcon(this.getClass().getResource("/image/browser/" + treeIcons[11]));
            this.benchmarkIcon = new ImageIcon(this.getClass().getResource("/image/browser/" + treeIcons[8]));
            this.clusterIcon = new ImageIcon(this.getClass().getResource("/image/cluster-wizard/clustered_space.gif"));
            this.groupIcon = new ImageIcon(this.getClass().getResource("/image/cluster-wizard/cluster_groups.gif"));
            this.operationsIcon = new ImageIcon(this.getClass().getResource("/image/cluster-wizard/operations.gif"));
            this.spacesRootIcon = new ImageIcon(this.getClass().getResource("/image/browser/spaces.gif"));
            this.clustersRootIcon = new ImageIcon(this.getClass().getResource("/image/cluster-wizard/clustersRoot.gif"));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            try {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                ImageIcon icon = this.getIcon(value);
                this.setIcon(icon);
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                Object objNode = node.getUserObject();
                if (objNode instanceof EditCluster) {
                    this.setText(objNode.toString() + " [Space Cluster]");
                }
            }
            catch (LostConnectionException lostConnectionException) {
                // empty catch block
            }
            return this;
        }

        private ImageIcon getIcon(Object value) {
            ImageIcon icon = null;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object objNode = node.getUserObject();
            int state = 2;
            short spaceMode = 1;
            if (value.equals(SpaceBrowser.this.spacesRoot)) {
                icon = this.spacesRootIcon;
                return icon;
            }
            if (value.equals(SpaceBrowser.this.clusterRoot)) {
                icon = this.clustersRootIcon;
                return icon;
            }
            if (objNode instanceof JSpaceProxyWrapper) {
                JSpaceProxyWrapper proxyWrapper = (JSpaceProxyWrapper)objNode;
                objNode = proxyWrapper.proxy();
                state = proxyWrapper.getState();
                spaceMode = proxyWrapper.getSpaceMode();
            }
            if (objNode instanceof EditCluster) {
                icon = this.clusterIcon;
            }
            if (objNode instanceof JSpaceContainerProxyWrapper) {
                icon = this.containerTreeIcon;
            } else if (objNode instanceof IJSpace) {
                icon = JSpaceUIUtils.getSpaceIcon(spaceMode, ((SpaceTreeNode)node.getUserObject()).isSecured(), ((SpaceTreeNode)node.getUserObject()).getServiceID());
            } else if (objNode instanceof StaleContainerService) {
                icon = this.containerStaleIcon;
            } else if (objNode instanceof StaleSpaceService) {
                icon = this.spaceStaleIcon;
            } else if (objNode instanceof String) {
                String str = (String)objNode;
                icon = SpaceBrowser.SQL_LABEL.equals(str) ? this.sqlIcon : (SpaceBrowser.TRANSACTIONS_LABEL.equals(str) ? this.transactionsIcon : (SpaceBrowser.STATISTICS_LABEL.equals(str) ? this.statisticsIcon : (SpaceBrowser.CONNECTIONS_LABEL.equals(str) ? this.connectionsIcon : (SpaceBrowser.BENCHMARK_LABEL.equals(str) ? this.benchmarkIcon : (SpaceBrowser.CLASSES_LABEL.equals(str) ? this.runtimeIcon : (node.isLeaf() ? IconsRepository.getInstance().getIcon(50) : (value.toString().equals(SpaceBrowser.OPERATIONS_NODE_LABEL) && node.getParent() != null && SpaceBrowser.this.clusterRoot.equals(node.getParent().getParent()) ? this.operationsIcon : this.groupIcon)))))));
            }
            return icon;
        }
    }
}

