/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.gigaspaces.metadata.StorageType;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.JSpaceAttributes;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.tools.cluster.ViewFileDialog;
import com.j_spaces.tools.spacebrowser.DistributedCachePanel;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.SpaceConfigException;
import com.j_spaces.tools.spacebrowser.SpaceConfigPanel;
import com.j_spaces.tools.spacebrowser.SpaceConfigStandardPanel;
import com.j_spaces.tools.spacebrowser.WholeNumberField;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.basic.BasicComboBoxEditor;

public class SpaceConfigAdvancedPanel
extends JPanel {
    private final SpaceConfigPanel m_owner;
    public SpaceBrowser m_spaceBrowser;
    private Hashtable m_uiComponentMap;
    private final JTabbedPane tabbedPanel = new JTabbedPane();
    private final JScrollPane scrollPanPerformance = new JScrollPane();
    private final JScrollPane scrollPanCluster = new JScrollPane();
    private final JScrollPane scrollPanGeneral = new JScrollPane();
    private final JScrollPane scrollPanPersistence = new JScrollPane();
    private final JScrollPane scrollPanMemory = new JScrollPane();
    private final JScrollPane scrollPanDCache = new JScrollPane();
    private final JScrollPane scrollPanJms = new JScrollPane();
    private final JScrollPane scrollBlobStore = new JScrollPane();
    private final JPanel panCacheManager = new JPanel();
    private final JPanel panPerformCenter = new JPanel(new BorderLayout());
    private final JPanel panGeneral = new JPanel();
    private final JPanel panSA = new JPanel();
    private final JPanel panEngine = new JPanel();
    private final JPanel panCluster = new JPanel();
    private final JPanel panPerformance = new JPanel();
    private final JPanel panPersistence = new JPanel();
    private final JPanel panClusterCenter = new JPanel(new BorderLayout());
    private final JPanel panPersCenter = new JPanel(new BorderLayout());
    private final JPanel panGenCenter = new JPanel(new BorderLayout());
    private final JPanel panLeaseManager = new JPanel();
    private final JPanel panMemoryUsage = new JPanel();
    private final JPanel panMemCenter = new JPanel(new BorderLayout());
    private final JPanel panMemory = new JPanel();
    private final JPanel panDistCacheCenter = new JPanel(new BorderLayout());
    private final JPanel panJmsCenter = new JPanel(new BorderLayout());
    private final JPanel panJms = new JPanel();
    private final JPanel panBlobStoreCenter = new JPanel(new BorderLayout());
    private final JPanel panBlobStore = new JPanel();
    private final DistributedCachePanel panDistCache = new DistributedCachePanel();
    private JLabel labCacheSize = new JLabel();
    private JLabel labLruEvictionBatchSize = new JLabel();
    private final JButton butEditClusterConfigURL = new JButton();
    private final JTextField txtfCacheSize = new WholeNumberField();
    private final JTextField txtfConnectionRetries = new WholeNumberField();
    private final JTextField txtfExpTimeInterval = new WholeNumberField();
    private final JTextField txtfMinThreads = new WholeNumberField();
    private final JTextField txtfMaxThreads = new WholeNumberField();
    private final JTextField txtfNotifyRetries = new WholeNumberField();
    private final WholeNumberField txtfHighWatermarkPercentage = new WholeNumberField(false);
    private final WholeNumberField txtfLowWatermarkPercentage = new WholeNumberField(false);
    private final WholeNumberField txtfEvictionBatchSize = new WholeNumberField();
    private final WholeNumberField txtfMemUsageRetryCount = new WholeNumberField();
    private final WholeNumberField txtfWriteOnlyBlockPercentage = new WholeNumberField(false);
    private final WholeNumberField txtfWriteOnlyCheckPercentage = new WholeNumberField(false);
    private final JTextField txtfJmsRMIPort = new WholeNumberField(true);
    private final JTextField txtfJmsTopicNames = new JTextField();
    private final JTextField txtfJmsQueueNames = new JTextField();
    private final JCheckBox chboxMemoryUsageEnable = new JCheckBox();
    private final JTextField txtCachePolicy = new JTextField();
    private final JTextField txtSerialType = new JTextField();
    JTextField textClusterConfigURL = new JTextField();
    private final JLabel labSerializationType = new JLabel();
    private final JLabel labSAClass = new JLabel();
    private final GridBagLayout gridBagLayout1 = new GridBagLayout();
    private final GridBagLayout gridBagLayout3 = new GridBagLayout();
    private final GridBagLayout gridBagLayout4 = new GridBagLayout();
    private final GridBagLayout gridBagLayout5 = new GridBagLayout();
    private final GridBagLayout gridBagLayout7 = new GridBagLayout();
    private final GridBagLayout gridBagLayout8 = new GridBagLayout();
    private final GridBagLayout gridBagLayout12 = new GridBagLayout();
    private final GridBagLayout gridBagLayout14 = new GridBagLayout();
    private final GridBagLayout gridBagLayout18 = new GridBagLayout();
    private final GridBagLayout gridBagLayout19 = new GridBagLayout();
    private final GridBagLayout gridBagLayout20 = new GridBagLayout();
    private final JFrame _parentFrame;
    private static final int TAB_INDEX_GENERAL = 0;
    private static final int TAB_INDEX_PERFOMANCE = 1;
    private static final int TAB_INDEX_PERSISTENCE = 2;
    private static final int TAB_INDEX_CLUSTER = 3;
    private static final int TAB_INDEX_MEMORY_MANAGEMENT = 4;
    private static final int TAB_INDEX_MASTER_LOCAL_CACHE = 5;
    private static final int TAB_INDEX_JMS = 6;
    private static final int TAB_INDEX_BLOB_STORE = 7;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui.spacebrowser");
    private String adminPass;
    private IJSpace _spaceProxy;
    private SpaceConfig curSpaceConfig;

    public SpaceConfigAdvancedPanel(SpaceConfigPanel owner, JFrame parentFrame, SpaceBrowser browser) {
        this.m_owner = owner;
        this.m_spaceBrowser = browser;
        this._parentFrame = parentFrame;
        try {
            this.jbInit();
            this.init();
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, e.toString(), e);
        }
    }

    private void init() throws Exception {
        this.chboxMemoryUsageEnable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpaceConfigAdvancedPanel.this.chboxMemoryUsageEnable.setSelected(!SpaceConfigAdvancedPanel.this.chboxMemoryUsageEnable.isSelected());
            }
        });
        this.butEditClusterConfigURL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String fileURL = SpaceConfigAdvancedPanel.this.textClusterConfigURL.getText().trim();
                if (fileURL.length() == 0 || fileURL.equals("none") || !fileURL.endsWith(".xml")) {
                    File f = SpaceConfigAdvancedPanel.this.m_spaceBrowser.chooseFile();
                    if (f != null) {
                        SpaceConfigAdvancedPanel.this.textClusterConfigURL.setText(f.getPath().replace('\\', '/'));
                    }
                } else {
                    try {
                        ViewFileDialog view = new ViewFileDialog(SpaceConfigAdvancedPanel.this._parentFrame, fileURL);
                        view.show();
                    }
                    catch (Exception ex) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, ex.toString(), ex);
                        }
                        JOptionPane.showConfirmDialog(SpaceConfigAdvancedPanel.this._parentFrame, ex.getClass().getName() + " " + ex.getMessage(), "Can't read the file", -1, 0);
                    }
                }
            }
        });
        Font f = this.txtfCacheSize.getFont();
        this.textClusterConfigURL.setFont(f);
        this.txtfConnectionRetries.setToolTipText("Maximum number of times the proxy may retry connecting to the space.");
        this.txtfNotifyRetries.setToolTipText("Maximum number of times the space may try reconnecting to the proxy.");
        this.txtfExpTimeInterval.setToolTipText("Specifies how often the server deletes Entries whose lease has expired, in milliseconds.");
        this.txtfNotifyRetries.setEditable(false);
        this.txtfConnectionRetries.setEditable(false);
        this.txtfExpTimeInterval.setEditable(false);
        this.txtfMinThreads.setEditable(false);
        this.txtfMaxThreads.setEditable(false);
        this.txtfHighWatermarkPercentage.setEditable(false);
        this.txtfLowWatermarkPercentage.setEditable(false);
        this.txtfEvictionBatchSize.setEditable(false);
        this.txtfMemUsageRetryCount.setEditable(false);
        this.txtfWriteOnlyBlockPercentage.setEditable(false);
        this.txtfWriteOnlyCheckPercentage.setEditable(false);
        this.txtfJmsRMIPort.setEditable(false);
        this.txtfJmsTopicNames.setEditable(false);
        this.txtfJmsQueueNames.setEditable(false);
        this.txtCachePolicy.setEditable(false);
        this.chboxMemoryUsageEnable.setEnabled(false);
        this.txtfMinThreads.setToolTipText("This is the number of threads initialized when the server is loaded.");
        this.txtfMaxThreads.setToolTipText("Maximum number of threads the GigaSpaces engine may run per space.");
        this.txtfCacheSize.setToolTipText("The maximum number of Entries that will be cached for speedy reuse.");
        this.textClusterConfigURL.setToolTipText("Specifies the path to the XML configuration file of the cluster to which this space belongs to.");
        this.txtfWriteOnlyBlockPercentage.setToolTipText("Specifies a lower threshold for blocking write-type operations. Above this level only read/take operations are allowed.");
        this.txtfWriteOnlyCheckPercentage.setToolTipText("Specifies an upper threshold for checking only write-type operations. Above this level all operations are checked.");
        this.txtfMemUsageRetryCount.setToolTipText("Number of retries to lower the memory level below the low watermark percentage");
    }

    public SpaceConfig getConfig(String spaceName) throws SpaceConfigException {
        if (spaceName == null) {
            spaceName = this.m_owner.getSpaceName().trim();
        }
        SpaceConfig config = new SpaceConfig(spaceName, this.m_owner.getContainerName());
        if (this.txtfConnectionRetries.getText().trim().length() != 0) {
            config.setConnectionRetries(this.txtfConnectionRetries.getText());
        }
        if (this.txtfNotifyRetries.getText().trim().length() != 0) {
            config.setNotifyRetries(this.txtfNotifyRetries.getText());
        }
        if (this.txtfExpTimeInterval.getText().trim().length() != 0) {
            config.setExpirationTimeInterval(this.txtfExpTimeInterval.getText());
        }
        if (this.txtfMinThreads.getText().trim().length() != 0) {
            config.setEngineMinThreads(this.txtfMinThreads.getText());
        }
        if (this.txtfMaxThreads.getText().trim().length() != 0) {
            config.setEngineMaxThreads(this.txtfMaxThreads.getText());
        }
        config.setSerializationType(this.curSpaceConfig.getSerializationType());
        config.setQPAutoCommit(this.curSpaceConfig.isQPAutoCommit());
        config.setQPParserCaseSensetivity(this.curSpaceConfig.isQPParserCaseSensetivity());
        config.setQpSpaceReadLeaseTime(this.curSpaceConfig.getQpSpaceReadLeaseTime());
        config.setQpSpaceWriteLeaseTime(this.curSpaceConfig.getQpSpaceWriteLeaseTime());
        config.setQPTraceExecTime(this.curSpaceConfig.isQPTraceExecTime());
        config.setQpTransactionTimeout(this.curSpaceConfig.getQpTransactionTimeout());
        config.setQpDateFormat(this.curSpaceConfig.getQpDateFormat());
        config.setQpDateTimeFormat(this.curSpaceConfig.getQpDateTimeFormat());
        config.setQpTimeFormat(this.curSpaceConfig.getQpTimeFormat());
        if (this.m_owner.chboxClustered.isSelected()) {
            config.setClustered(true);
            String text = this.textClusterConfigURL.getText().trim();
            if (text.length() != 0 && !text.equals("none")) {
                config.setClusterConfigURL(text);
            } else {
                throw new SpaceConfigException("Please define cluster configuration file name.");
            }
        }
        if (this.txtfCacheSize.getText().trim().length() != 0) {
            config.setCacheManagerSize(this.txtfCacheSize.getText());
        }
        config.setCachePolicy(this.curSpaceConfig.getCachePolicy());
        boolean isMemoryUsageEnabled = this.chboxMemoryUsageEnable.isSelected();
        config.setEngineMemoryUsageEnabled(String.valueOf(isMemoryUsageEnabled));
        if (isMemoryUsageEnabled) {
            float highWatermark = this.txtfHighWatermarkPercentage.getValueFloat();
            float lowWatermark = this.txtfLowWatermarkPercentage.getValueFloat();
            float writeOnlyBlock = this.txtfWriteOnlyBlockPercentage.getValueFloat();
            float writeOnlyCheck = this.txtfWriteOnlyCheckPercentage.getValueFloat();
            int evictionBatchSize = this.txtfEvictionBatchSize.getValueInt();
            int retryCount = this.txtfMemUsageRetryCount.getValueInt();
            this.verifyMemoryUsageSettings((JSpaceAttributes)config, highWatermark, lowWatermark, writeOnlyBlock, writeOnlyCheck, evictionBatchSize, retryCount);
        }
        String rmiPort = this.txtfJmsRMIPort.getText().trim();
        String jmsTopicName = this.txtfJmsTopicNames.getText().trim();
        String jmsQueueName = this.txtfJmsQueueNames.getText().trim();
        config.setJMSRmiPort(rmiPort);
        config.setJMSTopicNames(jmsTopicName);
        config.setJMSQueueNames(jmsQueueName);
        return config;
    }

    public void cleanup() {
        JSpaceUIUtils.cleanAWTContainer(this);
    }

    private boolean verifyMemoryUsageSettings(JSpaceAttributes config, float highWatermark, float lowWatermark, float writeOnlyBlock, float writeOnlyCheck, int evictionBatchSize, int retryCount) throws SpaceConfigException {
        if (highWatermark > 0.0f) {
            if (!(highWatermark <= 100.0f)) {
                throw new SpaceConfigException("The High Watermark Percentage must be less or equals to 100.");
            }
        } else {
            throw new SpaceConfigException("Wrong High Watermark Percentage value.");
        }
        config.setEngineMemoryUsageHighPercentageRatio(String.valueOf(highWatermark));
        if (writeOnlyBlock >= writeOnlyCheck) {
            if (!(writeOnlyBlock <= highWatermark)) {
                throw new SpaceConfigException("Define <Write Only Block Percentage> less or equals than <High Watermark>");
            }
        } else {
            throw new SpaceConfigException("Wrong Write Only Block Percentage value.");
        }
        config.setEngineMemoryUsageWriteOnlyBlockPercentageRatio(String.valueOf(writeOnlyBlock));
        if (writeOnlyCheck >= lowWatermark) {
            if (!(writeOnlyCheck <= writeOnlyBlock)) {
                throw new SpaceConfigException("Define <Write Only Check Percentage> less or equals than <Write Only Block Percentage>");
            }
        } else {
            throw new SpaceConfigException("Wrong Write Only Check Percentage value.");
        }
        config.setEngineMemoryWriteOnlyCheckPercentageRatio(String.valueOf(writeOnlyCheck));
        if (lowWatermark >= 0.0f) {
            if (!(lowWatermark <= writeOnlyCheck)) {
                throw new SpaceConfigException("Define <Low Watermark Percentage> less or equals than <Write Only Check Percentage>");
            }
        } else {
            throw new SpaceConfigException("Wrong Low Watermark Percentage value.");
        }
        config.setEngineMemoryUsageLowPercentageRatio(String.valueOf(lowWatermark));
        if (evictionBatchSize <= 0) {
            throw new SpaceConfigException("Wrong Eviction Batch Size value.");
        }
        config.setEngineMemoryUsageEvictionBatchSize(String.valueOf(evictionBatchSize));
        if (retryCount < 1) {
            throw new SpaceConfigException("Wrong Retry Count value.");
        }
        config.setEngineMemoryUsageRetryCount(String.valueOf(retryCount));
        return true;
    }

    public void setPersistenceTabEnabled(boolean enable) {
        if (!enable) {
            this.removePersistenceTab();
        }
    }

    public void setClusterTabEnabled(boolean enable) {
        if (!enable) {
            this.removeClusterTab();
            this.addMasterLocalCacheTab();
        }
    }

    public void setDCacheTabEnabled(boolean enable) {
        if (!enable) {
            this.removeMasterLocalCacheTab();
        }
    }

    public IJSpace getSpaceProxy() {
        return this.m_owner.getSpaceProxy();
    }

    public void setAdminPass(String pass) {
        this.adminPass = pass;
    }

    public String getAdminPass() {
        return this.adminPass;
    }

    public void copySettingsTo(SpaceConfigStandardPanel panel) {
        panel.textClusterConfigURL.setText(this.textClusterConfigURL.getText());
    }

    public void updateSettings(SpaceConfig config, boolean resetMode) {
        this.addChangebleTabs();
        this.curSpaceConfig = config;
        int cachePolicy = Integer.parseInt(config.getCachePolicy());
        boolean isLRUCachePolicy = false;
        boolean isBlobStorePolicy = false;
        switch (cachePolicy) {
            case 1: {
                this.txtCachePolicy.setText("All In Cache");
                this.txtCachePolicy.setToolTipText("Cache manager should store all the space's information in memory.");
                break;
            }
            case 0: {
                this.txtCachePolicy.setText("LRU");
                this.txtCachePolicy.setToolTipText("Cache manager should operate on a least recently used basis.");
                isLRUCachePolicy = true;
                break;
            }
            case 2: {
                this.txtCachePolicy.setText("Custom");
                this.txtCachePolicy.setToolTipText("Custom.");
                break;
            }
            case 3: {
                this.txtCachePolicy.setText("Blob Store");
                this.txtCachePolicy.setToolTipText("Blob Store");
                isBlobStorePolicy = true;
                break;
            }
            default: {
                this.txtCachePolicy.setText("n/a");
                this.txtCachePolicy.setToolTipText("n/a");
            }
        }
        this.txtfConnectionRetries.setText(String.valueOf(config.getConnectionRetries()));
        this.txtfNotifyRetries.setText(String.valueOf(config.getNotifyRetries()));
        this.txtfExpTimeInterval.setText(String.valueOf(config.getExpirationTimeInterval()));
        int serializationType = config.getSerializationType();
        if (serializationType == StorageType.OBJECT.getCode()) {
            this.txtSerialType.setText(StorageType.OBJECT.toString());
        } else if (serializationType == StorageType.BINARY.getCode()) {
            this.txtSerialType.setText(StorageType.BINARY.toString());
        } else if (serializationType == StorageType.COMPRESSED.getCode()) {
            this.txtSerialType.setText(StorageType.COMPRESSED.toString());
        }
        this.txtfMinThreads.setText(String.valueOf(config.getEngineMinThreads()));
        this.txtfMaxThreads.setText(String.valueOf(config.getEngineMaxThreads()));
        this.setPersistenceTabEnabled(config.isPersistent() ? !resetMode : false);
        this.textClusterConfigURL.setText(config.getClusterConfigURL());
        this.setClusterTabEnabled(config.isClustered());
        boolean isMemoryUsageEnabled = Boolean.valueOf(config.isEngineMemoryUsageEnabled());
        this.chboxMemoryUsageEnable.setSelected(isMemoryUsageEnabled);
        this.txtfHighWatermarkPercentage.setText(String.valueOf(config.getEngineMemoryUsageHighPercentageRatio()));
        this.txtfLowWatermarkPercentage.setText(String.valueOf(config.getEngineMemoryUsageLowPercentageRatio()));
        this.txtfWriteOnlyBlockPercentage.setText(String.valueOf(config.getEngineMemoryUsageWriteOnlyBlockPercentageRatio()));
        this.txtfWriteOnlyCheckPercentage.setText(String.valueOf(config.getEngineMemoryWriteOnlyCheckPercentageRatio()));
        this.txtfMemUsageRetryCount.setText(String.valueOf(config.getEngineMemoryUsageRetryCount()));
        JSpaceUIUtils.setAWTComponentsStatus(this.panMemoryUsage, isMemoryUsageEnabled);
        this.chboxMemoryUsageEnable.setEnabled(true);
        if (config.getDCacheProperties() != null) {
            this.panDistCache.setConfig((JSpaceAttributes)config);
        } else {
            this.panDistCache.setConfig((JSpaceAttributes)this.m_owner.m_defaultSpaceConfig);
        }
        this.setDCacheTabEnabled(!config.isClustered());
        String rmiPort = config.getJMSRmiPort();
        String jmsTopicName = config.getJMSTopicNames();
        String jmsQueueName = config.getJMSQueueNames();
        this.txtfJmsRMIPort.setText(rmiPort);
        this.txtfJmsTopicNames.setText(jmsTopicName);
        this.txtfJmsQueueNames.setText(jmsQueueName);
        this.txtfCacheSize.setText(isLRUCachePolicy ? String.valueOf(config.getCacheManagerSize()) : "");
        this.txtfEvictionBatchSize.setText(isLRUCachePolicy ? String.valueOf(config.getEngineMemoryUsageEvictionBatchSize()) : "");
        this.txtfCacheSize.setEnabled(isLRUCachePolicy);
        this.txtfEvictionBatchSize.setEnabled(isLRUCachePolicy);
        this.txtfCacheSize.setEditable(false);
        this.txtfEvictionBatchSize.setEditable(false);
        this.labCacheSize.setEnabled(isLRUCachePolicy);
        this.labLruEvictionBatchSize.setEnabled(isLRUCachePolicy);
        if (isBlobStorePolicy) {
            Properties blobStoreProperties = config.getBlobStoreProperties();
            this.panBlobStore.removeAll();
            Set<Map.Entry<Object, Object>> entries = blobStoreProperties.entrySet();
            int row = 0;
            for (Map.Entry<Object, Object> entry : entries) {
                String key = entry.getKey().toString();
                Object value = entry.getValue();
                this.createBlobStoreField(key, value, row);
                ++row;
            }
            this.addBlobStoreTab();
        } else {
            this.removeBlobStoreTab();
        }
    }

    private void jbInit() throws Exception {
        JLabel labMaxTheads = new JLabel();
        JLabel labMinThreads = new JLabel();
        JLabel labExpTimeInterval = new JLabel();
        JLabel labClusterConfigURL = new JLabel();
        JLabel labCachePolicy = new JLabel();
        JLabel labConnectionRetries = new JLabel();
        JLabel labNotifyRetries = new JLabel();
        JLabel labSSLPort = new JLabel();
        JLabel labHighWatermarkPercentage = new JLabel();
        JLabel labLowWatermarkPercentage = new JLabel();
        JLabel labWriteOnlyBlockPercentage = new JLabel();
        JLabel labWriteOnlyCheckPercentage = new JLabel();
        JLabel labMemUsageRetryCount = new JLabel();
        JLabel labJmsRMIPort = new JLabel();
        JLabel labJmsTopicNames = new JLabel();
        JLabel labJmsQueueNames = new JLabel();
        labMaxTheads.setText("Maximum Threads:");
        labMinThreads.setText("Minimum Threads:");
        labExpTimeInterval.setText("Expiration Time Interval:");
        labClusterConfigURL.setText("Cluster Config URL:");
        labCachePolicy.setText("Cache Policy:");
        this.labSAClass.setText("Storage Adapter Class:");
        labSSLPort.setText("Port:");
        this.labCacheSize.setText("Cache Size:");
        this.butEditClusterConfigURL.setText("...");
        this.labSerializationType.setText("Serialization Type:");
        labConnectionRetries.setText("Connection Retries (Client):");
        labNotifyRetries.setText("Notify Retries (Server):");
        labHighWatermarkPercentage.setText("High Watermark Percentage:");
        labLowWatermarkPercentage.setText("Low Watermark Percentage:");
        labWriteOnlyBlockPercentage.setText("Write Only Block Percentage:");
        labWriteOnlyCheckPercentage.setText("Write Only Check Percentage:");
        labMemUsageRetryCount.setText("Retry count:");
        this.chboxMemoryUsageEnable.setText("Enabled");
        this.labLruEvictionBatchSize.setText("LRU Eviction Batch Size:");
        labJmsRMIPort.setText("RMI Port:");
        labJmsQueueNames.setText("Administrated Queue Names:");
        labJmsTopicNames.setText("Administrated Topic Names:");
        this.textClusterConfigURL.setEditable(false);
        this.panGeneral.setLayout(this.gridBagLayout1);
        this.panPerformance.setLayout(this.gridBagLayout3);
        this.panCacheManager.setLayout(this.gridBagLayout4);
        this.panSA.setLayout(this.gridBagLayout5);
        this.panEngine.setLayout(this.gridBagLayout7);
        this.panCluster.setLayout(this.gridBagLayout8);
        this.panPersistence.setLayout(this.gridBagLayout12);
        this.panLeaseManager.setLayout(this.gridBagLayout14);
        this.panMemoryUsage.setLayout(this.gridBagLayout18);
        this.panMemory.setLayout(this.gridBagLayout19);
        this.panJms.setLayout(this.gridBagLayout20);
        this.panCacheManager.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "Cache Manager"), BorderFactory.createEmptyBorder(5, 2, 5, 2)));
        this.panSA.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "Storage Adapter"), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.panEngine.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "Engine Scalability"), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.panLeaseManager.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "Lease Manager"), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.panMemoryUsage.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "Memory Usage Control"), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.scrollPanCluster.getViewport().add((Component)this.panClusterCenter, null);
        this.panClusterCenter.add((Component)this.panCluster, "North");
        this.panCluster.add((Component)labClusterConfigURL, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 2, 2), 0, 0));
        this.panCluster.add((Component)this.butEditClusterConfigURL, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 2, 5), -9, -4));
        this.panCluster.add((Component)this.textClusterConfigURL, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 2, 2, 2), 1, -3));
        this.scrollPanPersistence.getViewport().add((Component)this.panPersCenter, null);
        this.panPersCenter.add((Component)this.panPersistence, "North");
        this.panCacheManager.add((Component)this.labCacheSize, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 5), 0, 0));
        this.panCacheManager.add((Component)this.txtfCacheSize, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 1, 0));
        this.panCacheManager.add((Component)labCachePolicy, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 5), 0, 0));
        this.panCacheManager.add((Component)this.txtCachePolicy, new GridBagConstraints(1, 1, 3, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 1, 0));
        this.panPersistence.add((Component)this.panSA, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 2, 2, 2), 1, 0));
        this.createPersistenceFields();
        this.scrollPanPerformance.getViewport().add((Component)this.panPerformCenter, null);
        this.panPerformCenter.add((Component)this.panPerformance, "North");
        this.panPerformance.add((Component)this.panEngine, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 11, 2, new Insets(2, 2, 2, 2), 1, 0));
        this.panEngine.add((Component)labMinThreads, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 5), 0, 0));
        this.panEngine.add((Component)this.txtfMinThreads, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 1, 0));
        this.panEngine.add((Component)labMaxTheads, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 5), 0, 0));
        this.panEngine.add((Component)this.txtfMaxThreads, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 1, 0));
        JPanel panSerialization = this.createSerializationPanel();
        this.panPerformance.add((Component)panSerialization, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 1, 0));
        this.scrollPanGeneral.getViewport().add((Component)this.panGenCenter, null);
        this.panGenCenter.add((Component)this.panGeneral, "North");
        this.panGeneral.add((Component)labConnectionRetries, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 2, 2), 0, 0));
        this.panGeneral.add((Component)this.txtfConnectionRetries, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 2, 2, 4), 1, 0));
        this.panGeneral.add((Component)new JLabel(""), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.panGeneral.add((Component)labNotifyRetries, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 2), 0, 0));
        this.panGeneral.add((Component)this.txtfNotifyRetries, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 4), 0, 0));
        this.panGeneral.add((Component)new JLabel(""), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, -2));
        this.panGeneral.add((Component)this.panLeaseManager, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 0, 2), 1, 0));
        this.panLeaseManager.add((Component)labExpTimeInterval, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 5), 0, 0));
        this.panLeaseManager.add((Component)this.txtfExpTimeInterval, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 0), 1, 0));
        this.panMemoryUsage.add((Component)this.chboxMemoryUsageEnable, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 0), 0, 0));
        this.panMemoryUsage.add((Component)labHighWatermarkPercentage, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.panMemoryUsage.add((Component)this.txtfHighWatermarkPercentage, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.panMemoryUsage.add((Component)labLowWatermarkPercentage, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.panMemoryUsage.add((Component)this.txtfLowWatermarkPercentage, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.panMemoryUsage.add((Component)labWriteOnlyBlockPercentage, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.panMemoryUsage.add((Component)this.txtfWriteOnlyBlockPercentage, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.panMemoryUsage.add((Component)labWriteOnlyCheckPercentage, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.panMemoryUsage.add((Component)this.txtfWriteOnlyCheckPercentage, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.panMemoryUsage.add((Component)this.labLruEvictionBatchSize, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.panMemoryUsage.add((Component)this.txtfEvictionBatchSize, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.panMemoryUsage.add((Component)labMemUsageRetryCount, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.panMemoryUsage.add((Component)this.txtfMemUsageRetryCount, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.scrollPanMemory.getViewport().add((Component)this.panMemCenter, null);
        this.panMemCenter.add((Component)this.panMemory, "North");
        this.panMemory.add((Component)this.panCacheManager, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 1, 0));
        this.panMemory.add((Component)this.panMemoryUsage, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 1, 0));
        this.scrollPanDCache.getViewport().add((Component)this.panDistCacheCenter, null);
        this.panDistCacheCenter.add((Component)this.panDistCache, "North");
        this.scrollPanJms.getViewport().add((Component)this.panJmsCenter, null);
        this.panJmsCenter.add((Component)this.panJms, "North");
        this.panJms.add((Component)labJmsRMIPort, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.panJms.add((Component)labJmsTopicNames, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.panJms.add((Component)labJmsQueueNames, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.panJms.add((Component)this.txtfJmsRMIPort, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.panJms.add((Component)this.txtfJmsTopicNames, new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.panJms.add((Component)this.txtfJmsQueueNames, new GridBagConstraints(0, 9, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.panBlobStore.setLayout(this.gridBagLayout1);
        this.scrollBlobStore.getViewport().add((Component)this.panBlobStoreCenter, null);
        this.panBlobStoreCenter.add((Component)this.panBlobStore, "North");
        this.tabbedPanel.add(this.scrollPanGeneral, "General", 0);
        this.tabbedPanel.add(this.scrollPanPerformance, "Performance", 1);
        this.addChangebleTabs();
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPanel, "Center");
    }

    private void createBlobStoreField(String labelProp, Object value, int rowNum) {
        JLabel label = new JLabel(JSpaceUIUtils.getBlobStorePropertyLabel(labelProp) + ":");
        JTextField textField = new JTextField();
        textField.setEditable(false);
        textField.setText(value instanceof Boolean ? (((Boolean)value).booleanValue() ? "Yes" : "No") : value.toString());
        this.panBlobStore.add((Component)label, new GridBagConstraints(0, rowNum, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 2, 2), 0, 0));
        this.panBlobStore.add((Component)textField, new GridBagConstraints(1, rowNum, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 2, 2, 4), 1, 0));
    }

    private void addChangebleTabs() {
        this.addPersistenceTab();
        this.addClusterTab();
        this.addMemoryManagementTab();
        this.addMasterLocalCacheTab();
        this.addJmsTab();
        this.addBlobStoreTab();
    }

    private void addPersistenceTab() {
        if (this.tabbedPanel.indexOfComponent(this.scrollPanPersistence) < 0) {
            this.tabbedPanel.add(this.scrollPanPersistence, "Persistence", 2);
        }
    }

    private void removePersistenceTab() {
        this.tabbedPanel.remove(this.scrollPanPersistence);
    }

    private void addClusterTab() {
        if (this.tabbedPanel.indexOfComponent(this.scrollPanCluster) < 0) {
            this.tabbedPanel.add(this.scrollPanCluster, "Cluster", 3);
        }
    }

    private void removeClusterTab() {
        this.tabbedPanel.remove(this.scrollPanCluster);
    }

    private void addMemoryManagementTab() {
        if (this.tabbedPanel.indexOfComponent(this.scrollPanMemory) < 0) {
            this.tabbedPanel.add(this.scrollPanMemory, "Memory Management", 4);
        }
    }

    private void addMasterLocalCacheTab() {
        if (this.tabbedPanel.indexOfComponent(this.scrollPanDCache) < 0) {
            this.tabbedPanel.add(this.scrollPanDCache, "Master-Local Cache", 5);
        }
    }

    private void removeMasterLocalCacheTab() {
        this.tabbedPanel.remove(this.scrollPanDCache);
    }

    private void addJmsTab() {
        if (this.tabbedPanel.indexOfComponent(this.scrollPanJms) < 0) {
            this.tabbedPanel.add(this.scrollPanJms, "JMS", 6);
        }
    }

    private void addBlobStoreTab() {
        if (this.tabbedPanel.indexOfComponent(this.scrollBlobStore) < 0) {
            this.tabbedPanel.add(this.scrollBlobStore, "Blob Store", 7);
        }
    }

    private void removeBlobStoreTab() {
        this.tabbedPanel.remove(this.scrollBlobStore);
    }

    private void createPersistenceFields() {
        this.panSA.add((Component)this.labSAClass, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 14, 0, new Insets(2, 2, 2, 5), 0, 0));
    }

    private JPanel createSerializationPanel() {
        JPanel panSerialization = new JPanel();
        panSerialization.setLayout(new BoxLayout(panSerialization, 0));
        panSerialization.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "Serialization Performance"), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        Dimension textFieldSize = new Dimension(160, 21);
        this.txtSerialType.setPreferredSize(textFieldSize);
        this.txtSerialType.setMaximumSize(textFieldSize);
        this.txtSerialType.setEditable(false);
        panSerialization.add(Box.createHorizontalStrut(2));
        panSerialization.add(this.labSerializationType);
        panSerialization.add(Box.createHorizontalStrut(2));
        panSerialization.add(this.txtSerialType);
        panSerialization.add(Box.createHorizontalGlue());
        return panSerialization;
    }

    private class CustomComboBoxEditor
    extends BasicComboBoxEditor {
        private CustomComboBoxEditor() {
        }

        @Override
        public void setItem(Object anObject) {
            try {
                super.setItem(anObject);
            }
            catch (RuntimeException ex) {
                super.setItem(anObject);
            }
        }
    }
}

