/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.internal.jmx.JMXUtilities;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.JSpaceAttributes;
import com.j_spaces.core.SpaceConfigFactory;
import com.j_spaces.core.admin.ContainerConfig;
import com.j_spaces.core.admin.IInternalRemoteJSpaceAdmin;
import com.j_spaces.core.admin.IJSpaceContainerAdmin;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.kernel.Environment;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.SpaceConfigAdvancedPanel;
import com.j_spaces.tools.spacebrowser.SpaceConfigException;
import com.j_spaces.tools.spacebrowser.SpaceConfigStandardPanel;
import com.j_spaces.tools.spacebrowser.XMLFileFilter;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;

public class SpaceConfigPanel
extends JPanel
implements ActionListener {
    private final String MODE_STANDARD = "Standard";
    private final String MODE_ADVANCED = "Advanced";
    public static final String MSG_ERROR_SA = "Please define storage adapter class and url value.";
    public static final String MSG_ERROR_CLUSTER_URL = "Please define cluster configuration file name.";
    public static final String MSG_ERROR_CLUSTER_REPLICATION_GROUP = "Please define replication group for dynamic member.";
    private final JPanel panNorth = new JPanel();
    private final JPanel panAttributes = new JPanel();
    private final JPanel panSouth = new JPanel();
    private final JPanel panCenter = new JPanel();
    private final JLabel labSpaceName = new JLabel();
    JTextField txtfSpaceName = new JTextField();
    private final JTextField schemaTextField = new JTextField();
    private final JButton butViewMode = new JButton();
    private final JButton saveAsButton = new JButton();
    private final JCheckBox chboxPrivate = new JCheckBox();
    JCheckBox chboxPersistent = new JCheckBox();
    JCheckBox chboxClustered = new JCheckBox();
    private final JCheckBox chboxLoadOnStartup = new JCheckBox();
    private final BorderLayout borderLayout1 = new BorderLayout();
    private final GridBagLayout gridBagLayout_NorthPanel = new GridBagLayout();
    private final GridBagLayout gridBagLayout_AttributesPanel = new GridBagLayout();
    private final GridBagLayout gridBagLayout_SouthPanel = new GridBagLayout();
    private final CardLayout cardLayout_panCenter = new CardLayout();
    private TitledBorder titledBorder1;
    private final JTextField schemaFilePathField = new JTextField();
    private final JTextField jmxServiceUrlField = new JTextField();
    private final JTextField suspendTypeField = new JTextField();
    private final SpaceBrowser m_spaceBrowser;
    private final JFrame _parentFrame;
    private boolean m_isAdvancedMode;
    SpaceConfigAdvancedPanel advancedPanel;
    private SpaceConfigStandardPanel standardPanel;
    private String[] storAdapterClasses;
    Hashtable<String, Hashtable<String, SpaceConfig>> conConfigTable = new Hashtable();
    SpaceConfig m_defaultSpaceConfig;
    private IJSpace m_spaceProxy;
    private SpaceConfig curSpaceConfig;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui.spacebrowser");
    private JFileChooser fileChooser;
    private static final String SPACE_SCHEMA_POSTFIX_FILE_NAME = "*-space-schema.xml";
    private final XMLFileFilter spaceSchemaFileFilter = new XMLFileFilter("Schema File( *-space-schema.xml )");

    public SpaceConfigPanel(JFrame parentFrame, SpaceBrowser browser) {
        this.m_spaceBrowser = browser;
        this._parentFrame = parentFrame;
        try {
            this.jbInit();
            this.init();
            this.setFirstEnableComponentsMode();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.panNorth.setLayout(this.gridBagLayout_NorthPanel);
        this.panSouth.setLayout(this.gridBagLayout_SouthPanel);
        this.labSpaceName.setText("Space Name:");
        this.butViewMode.setText("Advanced");
        this.chboxPrivate.setText("Private");
        this.chboxPersistent.setText("Persistent");
        this.chboxClustered.setText("Clustered");
        this.chboxLoadOnStartup.setText("Load On Startup");
        this.chboxLoadOnStartup.setMnemonic('L');
        this.chboxPrivate.setMnemonic('v');
        this.saveAsButton.setText("Save As...");
        this.panNorth.add((Component)this.labSpaceName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.panNorth.add((Component)this.txtfSpaceName, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 3), 0, 0));
        JLabel schemasLabel = new JLabel("Schema:");
        this.panNorth.add((Component)schemasLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 6), 0, 0));
        this.panNorth.add((Component)this.schemaTextField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 2, 0, 3), 0, 0));
        JLabel explSchemaPathLabel = new JLabel("Schema loaded from:");
        this.panNorth.add((Component)explSchemaPathLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.panNorth.add((Component)this.schemaFilePathField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 3), 0, 0));
        JLabel jmxServiceUrlLabel = new JLabel("JMX service URL:");
        this.panNorth.add((Component)jmxServiceUrlLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.panNorth.add((Component)this.jmxServiceUrlField, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 3), 0, 0));
        JLabel suspendTypeLabel = new JLabel("Suspend Type:");
        this.panNorth.add((Component)suspendTypeLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.panNorth.add((Component)this.suspendTypeField, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 3), 0, 0));
        this.panNorth.add((Component)this.panAttributes, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panAttributes.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "Attributes"));
        this.panAttributes.setLayout(this.gridBagLayout_AttributesPanel);
        this.panAttributes.add((Component)this.chboxPrivate, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.panAttributes.add((Component)this.chboxPersistent, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.panAttributes.add((Component)this.chboxClustered, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.panAttributes.add((Component)this.chboxLoadOnStartup, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        this.panSouth.add((Component)this.butViewMode, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.panSouth.add((Component)this.saveAsButton, gridBagConstraints);
        this.titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), "Space Configuration - Standard");
        this.setBorder(this.titledBorder1);
        this.setLayout(this.borderLayout1);
        this.add((Component)this.panNorth, "North");
        this.add((Component)this.panSouth, "South");
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.saveAsButton) {
            this.invokeSaveAs();
        }
    }

    private void init() throws Exception {
        this.advancedPanel = new SpaceConfigAdvancedPanel(this, this._parentFrame, this.m_spaceBrowser);
        this.standardPanel = new SpaceConfigStandardPanel(this, this._parentFrame, this.m_spaceBrowser);
        this.panCenter.setLayout(this.cardLayout_panCenter);
        this.panCenter.add("Standard", this.standardPanel);
        this.panCenter.add("Advanced", this.advancedPanel);
        this.add((Component)this.panCenter, "Center");
        this.saveAsButton.addActionListener(this);
        this.chboxClustered.setMnemonic(84);
        this.chboxClustered.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpaceConfigPanel.this.chboxClustered.setSelected(!SpaceConfigPanel.this.chboxClustered.isSelected());
            }
        });
        this.chboxPersistent.setMnemonic(80);
        this.chboxPersistent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpaceConfigPanel.this.chboxPersistent.setSelected(!SpaceConfigPanel.this.chboxPersistent.isSelected());
            }
        });
        this.butViewMode.setMnemonic(65);
        this.butViewMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String mode = SpaceConfigPanel.this.butViewMode.getText();
                SpaceConfigPanel.this.cardLayout_panCenter.show(SpaceConfigPanel.this.panCenter, mode);
                String newMode = mode.equals("Standard") ? "Advanced" : "Standard";
                SpaceConfigPanel.this.butViewMode.setText(newMode);
                SpaceConfigPanel.this.titledBorder1.setTitle("Space Configuration - " + mode);
                SpaceConfigPanel.this.m_isAdvancedMode = !SpaceConfigPanel.this.m_isAdvancedMode;
                if (mode.equals("Standard")) {
                    SpaceConfigPanel.this.advancedPanel.copySettingsTo(SpaceConfigPanel.this.standardPanel);
                } else {
                    SpaceConfigPanel.this.standardPanel.copySettingsTo(SpaceConfigPanel.this.advancedPanel);
                }
                SpaceConfigPanel.this.validate();
                SpaceConfigPanel.this.repaint();
            }
        });
        this.chboxPrivate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpaceConfigPanel.this.chboxPrivate.setSelected(!SpaceConfigPanel.this.chboxPrivate.isSelected());
            }
        });
        this.chboxPrivate.setToolTipText("A private space is a space that does not allow users to access it using an rmi or Jini address.");
        this.chboxPersistent.setToolTipText("A persistent space keeps its data in a persistent backend and can therefore survive server crashes.");
        this.chboxClustered.setToolTipText("Allows building clustered spaces with Replication, Fail Over and Load Balancing schemes.");
        this.chboxLoadOnStartup.setToolTipText("Automatically start up space within container when container starts");
    }

    private void setFirstEnableComponentsMode() {
        this.txtfSpaceName.setEditable(false);
        this.schemaTextField.setEditable(false);
        this.schemaFilePathField.setEditable(false);
        this.jmxServiceUrlField.setEditable(false);
        this.suspendTypeField.setEditable(false);
        this.advancedPanel.setPersistenceTabEnabled(this.chboxPersistent.isSelected());
        this.standardPanel.setPersistenceEnabled(this.chboxPersistent.isSelected());
        this.advancedPanel.setClusterTabEnabled(this.chboxClustered.isSelected());
        this.standardPanel.setClusterEnabled(this.chboxClustered.isSelected());
    }

    public SpaceConfig getConfig() {
        return this.getConfig(null);
    }

    public SpaceConfig getConfig(String spaceName) {
        SpaceConfig config = null;
        try {
            if (!this.m_isAdvancedMode) {
                this.standardPanel.copySettingsTo(this.advancedPanel);
            }
            config = this.advancedPanel.getConfig(spaceName);
            if (!this.m_isAdvancedMode) {
                this.standardPanel.updateConfig(config);
            }
        }
        catch (SpaceConfigException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage());
            this.saveAsButton.setEnabled(true);
            return null;
        }
        config.setPrivate(this.chboxPrivate.isSelected());
        config.setSpaceName(this.txtfSpaceName.getText().trim());
        config.setSchemaName(this.curSpaceConfig.getSchemaName());
        config.setLoadOnStartup(this.chboxLoadOnStartup.isSelected());
        config.setPersistent(this.chboxPersistent.isSelected());
        return config;
    }

    public SpaceConfigAdvancedPanel getAdvanced() {
        return this.advancedPanel;
    }

    public SpaceConfigStandardPanel getStandard() {
        return this.standardPanel;
    }

    private void invokeSaveAs() {
        if (this.fileChooser == null) {
            this._parentFrame.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.fileChooser = new JFileChooser();
                this.fileChooser.addChoosableFileFilter(this.spaceSchemaFileFilter);
                this.fileChooser.setAcceptAllFileFilterUsed(false);
                this.fileChooser.setFileFilter(this.spaceSchemaFileFilter);
                this.fileChooser.setDialogTitle("Save Space As");
                File schemasDir = new File(Environment.createSchemasFolderIfNotExists());
                this.fileChooser.setCurrentDirectory(schemasDir);
            }
            finally {
                this._parentFrame.setCursor(Cursor.getDefaultCursor());
            }
        }
        this.fileChooser.showSaveDialog(this._parentFrame);
        FileFilter selectedFileFilter = this.fileChooser.getFileFilter();
        File selFile = this.fileChooser.getSelectedFile();
        String spaceName = null;
        if (selFile != null) {
            String selPath = selFile.getPath();
            String schemaName = "";
            if (selectedFileFilter.equals(this.spaceSchemaFileFilter)) {
                selPath = selPath + "-space-schema.xml";
                spaceName = this.txtfSpaceName.getText();
                schemaName = selFile.getName();
            }
            SpaceConfig selSpaceAttributes = this.getConfig(spaceName);
            selSpaceAttributes.setProperty("space-config.schema", schemaName);
            selSpaceAttributes.setSchemaName(schemaName);
            selFile = new File(selPath);
            SpaceConfigFactory.performSaveAs((File)selFile, (String)spaceName, (String)this.curSpaceConfig.getContainerName(), (JSpaceAttributes)selSpaceAttributes);
        }
    }

    public void updateDialog(String containerName, IJSpace spaceProxy) {
        this.updateDialog(containerName, spaceProxy, true);
    }

    public void updateDialog(String containerName, IJSpace spaceProxy, boolean cacheConfiguration) {
        this.m_spaceProxy = spaceProxy;
        this.saveAsButton.setEnabled(true);
        try {
            String spaceName = spaceProxy.getName();
            Hashtable<String, Object> spaceConfigTable = this.conConfigTable.get(containerName);
            if (spaceConfigTable == null) {
                spaceConfigTable = new Hashtable();
                this.conConfigTable.put(containerName, spaceConfigTable);
            }
            SpaceConfig spaceConfig = spaceConfigTable.get(spaceName);
            if (!cacheConfiguration || spaceConfig == null) {
                IRemoteJSpaceAdmin spaceAdmin = Repository.addSpaceAdminObjectToMap(spaceProxy);
                spaceConfig = Repository.addSpaceConfigToMap(spaceAdmin);
                spaceConfigTable.put(spaceName, spaceConfig);
            }
            this.schemaFilePathField.setText(spaceConfig.getSchemaPath());
            this.updateDialog(spaceProxy, spaceConfig, false);
        }
        catch (Exception ex) {
            this.saveAsButton.setEnabled(false);
            SpaceBrowser.expDialog.showException("updating space configuration", ex);
        }
    }

    public IJSpace getSpaceProxy() {
        return this.m_spaceProxy;
    }

    public String getSpaceName() {
        return this.txtfSpaceName.getText();
    }

    public String getContainerName() {
        return this.curSpaceConfig.getContainerName();
    }

    public void updateDialog(IJSpace space, SpaceConfig spaceConfig, boolean resetMode) {
        block4: {
            try {
                this.curSpaceConfig = spaceConfig;
                this.txtfSpaceName.setText(spaceConfig.getSpaceName());
                this.chboxPrivate.setSelected(spaceConfig.isPrivate());
                this.chboxClustered.setSelected(spaceConfig.isClustered());
                this.schemaFilePathField.setText(spaceConfig.getSchemaPath());
                this.chboxLoadOnStartup.setSelected(spaceConfig.isLoadOnStartup());
                this.chboxPersistent.setSelected(spaceConfig.isPersistent() ? !resetMode : false);
                String schemaName = spaceConfig.getSchemaName();
                if (schemaName != null) {
                    this.schemaTextField.setText(schemaName);
                } else {
                    this.saveAsButton.setEnabled(false);
                }
                this.setJmxServiceURL(space);
                IInternalRemoteJSpaceAdmin spaceAdmin = (IInternalRemoteJSpaceAdmin)Repository.addSpaceAdminObjectToMap(space);
                this.setSuspendInfo(spaceAdmin);
                this.advancedPanel.updateSettings(spaceConfig, resetMode);
                this.standardPanel.updateSettings(spaceConfig, resetMode);
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block4;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    private void setJmxServiceURL(IJSpace space) {
        IJSpaceContainerAdmin containerAdmin = (IJSpaceContainerAdmin)space.getDirectProxy().getContainer();
        ContainerConfig containerConfig = Repository.getContainerConfig(containerAdmin);
        String jndiURL = containerConfig.getJndiPublicURL();
        String jmxServiceURL = JMXUtilities.createJMXUrl((String)jndiURL);
        this.jmxServiceUrlField.setText(jmxServiceURL);
    }

    private void setSuspendInfo(IInternalRemoteJSpaceAdmin admin) throws Exception {
        this.suspendTypeField.setText(SpaceBrowser.getSuspendTypeName(admin));
    }

    public void cleanup() {
        this.conConfigTable.clear();
        this.advancedPanel.cleanup();
        this.standardPanel.cleanup();
        this.txtfSpaceName.setText("");
        this.schemaFilePathField.setText("");
        this.jmxServiceUrlField.setText("");
        this.suspendTypeField.setText("");
        JSpaceUIUtils.cleanAWTContainer(this.panAttributes);
        this.saveAsButton.setEnabled(false);
    }
}

