/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.tools.cluster.ViewFileDialog;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.SpaceConfigAdvancedPanel;
import com.j_spaces.tools.spacebrowser.SpaceConfigException;
import com.j_spaces.tools.spacebrowser.SpaceConfigPanel;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class SpaceConfigStandardPanel
extends JPanel {
    private SpaceConfigPanel m_owner;
    private SpaceBrowser m_spaceBrowser;
    private JFrame _parentFrame;
    private JPanel panNorth = new JPanel();
    private JPanel panPersistence = new JPanel();
    private JPanel panCluster = new JPanel();
    private JButton butEditClusterConfigURL = new JButton();
    private JLabel labSAClass = new JLabel();
    private JLabel labSAURL = new JLabel();
    private JLabel labClusterConfigURL = new JLabel();
    private JComboBox cmboxSAUrl = new JComboBox();
    JTextField textClusterConfigURL = new JTextField();
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui.spacebrowser");

    public SpaceConfigStandardPanel(SpaceConfigPanel owner, JFrame parentFrame, SpaceBrowser browser) {
        this.m_owner = owner;
        this.m_spaceBrowser = browser;
        this._parentFrame = parentFrame;
        try {
            this.jbInit();
            this.init();
            this.setFirstEnableComponentsMode();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.butEditClusterConfigURL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String fileURL = SpaceConfigStandardPanel.this.textClusterConfigURL.getText().trim();
                if (fileURL.length() == 0 || fileURL.equals("none") || !fileURL.endsWith(".xml")) {
                    File f = SpaceConfigStandardPanel.this.m_spaceBrowser.chooseFile();
                    if (f != null) {
                        SpaceConfigStandardPanel.this.textClusterConfigURL.setText(f.getPath().replace('\\', '/'));
                    }
                } else {
                    try {
                        ViewFileDialog view = new ViewFileDialog(SpaceConfigStandardPanel.this._parentFrame, fileURL);
                        view.show();
                    }
                    catch (Exception ex) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, ex.toString(), ex);
                        }
                        JOptionPane.showConfirmDialog(SpaceConfigStandardPanel.this._parentFrame, ex.getClass().getName() + " " + ex.getMessage(), "Can't read the file", -1, 0);
                    }
                }
            }
        });
        Font f = new JTextField().getFont();
        this.cmboxSAUrl.setFont(f);
        this.textClusterConfigURL.setFont(f);
    }

    public void cleanup() {
        JSpaceUIUtils.cleanAWTContainer(this);
        this.setFirstEnableComponentsMode();
    }

    public void setPersistenceEnabled(boolean b) {
        JSpaceUIUtils.setAWTComponentsStatus(this.panPersistence, b);
        this.cmboxSAUrl.setEnabled(false);
    }

    public void setClusterEnabled(boolean b) {
        JSpaceUIUtils.setAWTComponentsStatus(this.panCluster, b);
    }

    public void updateSettings(SpaceConfig config, boolean resetMode) {
        this.setPersistenceEnabled(config.isPersistent() ? !resetMode : false);
        this.textClusterConfigURL.setText(config.getClusterConfigURL());
        this.setClusterEnabled(config.isClustered());
    }

    public void updateConfig(SpaceConfig config) throws SpaceConfigException {
        if (this.m_owner.chboxClustered.isSelected()) {
            String url = this.textClusterConfigURL.getText().trim();
            if (url.length() == 0 && url.equals("none")) {
                throw new SpaceConfigException("Please define cluster configuration file name.");
            }
            config.setClusterConfigURL(url);
            config.setClustered(true);
        }
    }

    private void setFirstEnableComponentsMode() {
        JSpaceUIUtils.setAWTComponentsStatus(this.panPersistence, false);
        JSpaceUIUtils.setAWTComponentsStatus(this.panCluster, false);
    }

    public void copySettingsTo(SpaceConfigAdvancedPanel panel) {
        String val = this.textClusterConfigURL.getText().trim();
        panel.textClusterConfigURL.setText(val);
    }

    private void jbInit() throws Exception {
        this.labSAClass.setText("Storage Adapter Class:");
        this.labSAURL.setText("Storage Adapter URL:");
        this.cmboxSAUrl.setEditable(true);
        this.butEditClusterConfigURL.setText("...");
        this.labClusterConfigURL.setText("Cluster Config URL:");
        this.textClusterConfigURL.setEditable(false);
        this.panNorth.setLayout(new GridBagLayout());
        this.panNorth.add((Component)this.panPersistence, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panNorth.add((Component)this.panCluster, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panPersistence.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "Persistent Options"), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.panPersistence.setLayout(new GridBagLayout());
        this.panPersistence.add((Component)this.labSAClass, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 0, 5), 0, 0));
        this.panPersistence.add((Component)this.labSAURL, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 5), 0, 0));
        this.panPersistence.add((Component)this.cmboxSAUrl, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, -3));
        this.panCluster.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "Cluster Options"), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.panCluster.setLayout(new GridBagLayout());
        this.panCluster.add((Component)this.textClusterConfigURL, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, -3));
        this.panCluster.add((Component)this.labClusterConfigURL, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 1, 0));
        this.panCluster.add((Component)this.butEditClusterConfigURL, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 0, 2, 0), -9, -4));
        this.setLayout(new BorderLayout());
        this.add((Component)this.panNorth, "North");
    }
}

