/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.grid.space.ISearchComponent;
import com.gigaspaces.admin.ui.grid.space.SearchEditor;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.lrmi.TransportProtocolHelper;
import com.gigaspaces.management.local_time.LocalTimeConstants;
import com.gigaspaces.management.transport.ITransportConnection;
import com.gigaspaces.management.transport.TransportConstants;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.IJSpaceContainer;
import com.j_spaces.core.admin.ContainerConfig;
import com.j_spaces.core.admin.IJSpaceContainerAdmin;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.IRefreshable;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.utils.IndicationBox;
import com.j_spaces.tools.spacebrowser.utils.InstancesInfoBox;
import com.j_spaces.tools.spacebrowser.utils.RefreshPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SpaceConnectionsPanel
extends JPanel {
    private SpaceBrowser _spaceBrowser;
    protected ConnectionsTableModel _connectionsTableModel;
    protected JTable _connectionsTable;
    protected RefreshPanel refreshPanel;
    protected Object[] params;
    protected String[] signature;
    private JTextField serverIPField;
    protected JButton cleanDisconnectionsButton;
    protected InstancesInfoBox _infoBox;
    protected IndicationBox _indicationBox;
    protected Map<Long, TransportConnectionWrapper> allConnectionsMap = new HashMap<Long, TransportConnectionWrapper>();
    protected Map<Long, TransportConnectionWrapper> disconnectedConnectionsMap = new HashMap<Long, TransportConnectionWrapper>();
    private static final int CI_IP_ADDRESS = 0;
    private static final int CI_PORT = 1;
    private static final int CI_START_TIME = 2;
    private static final int CI_DISCONNNECTION_TIME = 3;
    protected SearchEditor _searchEditor;
    protected static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui.spacebrowser");
    protected TableColumnSortListener _tableColumnSortListener;

    public SpaceConnectionsPanel(SpaceBrowser spaceBrowser) {
        this._spaceBrowser = spaceBrowser;
        this.initTableAndTableModel();
        try {
            this.initJMX();
            this.initUI();
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, e.toString(), e);
        }
    }

    protected void initTableAndTableModel() {
        this._connectionsTableModel = new ConnectionsTableModel();
        this._connectionsTable = new JTable(this._connectionsTableModel);
        this._searchEditor = new SearchEditor(this._connectionsTableModel);
    }

    public void initPanel(MBeanServerConnection beanServerConnection, IJSpace spaceProxy) {
        block2: {
            IRemoteJSpaceAdmin remoteAdminSpace = (IRemoteJSpaceAdmin)((IDirectSpaceProxy)spaceProxy).getRemoteJSpace();
            long curRemoteObjID = TransportProtocolHelper.getRemoteObjID((Object)remoteAdminSpace);
            try {
                this._connectionsTableModel.initModel(beanServerConnection, curRemoteObjID, Repository.addContainerToMap((IJSpaceContainerAdmin)((IJSpaceContainerAdmin)spaceProxy.getDirectProxy().getContainer())).containerName);
                IJSpaceContainer spaceCOntainer = spaceProxy.getDirectProxy().getContainer();
                ContainerConfig containerConfig = Repository.addContainerToMap((IJSpaceContainerAdmin)spaceCOntainer);
                this._indicationBox.setVisible(!containerConfig.isJMXEnabled());
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block2;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    public void setInvokeRefresh(boolean invokeRefresh) {
        this._connectionsTableModel.setInvokeRefresh(invokeRefresh);
    }

    private void initJMX() throws Exception {
        this.params = new Long[1];
        this.signature = new String[1];
        this.signature[0] = Long.TYPE.getName();
    }

    private void initUI() {
        this.setBorder(new TitledBorder("Connections"));
        this.setTableColumnSettings();
        JScrollPane tableScrollPane = new JScrollPane(this._connectionsTable);
        tableScrollPane.setPreferredSize(new Dimension(500, 300));
        CustomizeTableHeader header = new CustomizeTableHeader(this._connectionsTable.getColumnModel());
        this._connectionsTable.setTableHeader(header);
        this._tableColumnSortListener = new TableColumnSortListener(this._connectionsTable, this._connectionsTableModel);
        header.addMouseListener(this._tableColumnSortListener);
        header.setReorderingAllowed(false);
        this._connectionsTable.setAutoCreateColumnsFromModel(false);
        this._connectionsTable.setSelectionMode(0);
        this._connectionsTable.setAutoResizeMode(1);
        this._connectionsTable.setAutoscrolls(true);
        this.refreshPanel = new RefreshPanel(this._connectionsTableModel, false);
        this.refreshPanel.setSelectedRefreshRate(5000);
        this._infoBox = new InstancesInfoBox("connection", "disconnection");
        Box serverConnectionPropsBox = this.createServerConnectionBox();
        this.createIndicationBox();
        Box northBox = new Box(1);
        northBox.add(this.refreshPanel);
        northBox.add(Box.createVerticalStrut(1));
        northBox.add(this._indicationBox);
        northBox.add(Box.createVerticalStrut(1));
        northBox.add(Box.createVerticalStrut(3));
        northBox.add(serverConnectionPropsBox);
        northBox.add(Box.createVerticalStrut(3));
        this.setLayout(new BorderLayout());
        this.add((Component)northBox, "North");
        this.add((Component)tableScrollPane, "Center");
        this.add((Component)this._infoBox, "South");
    }

    protected void createIndicationBox() {
        this._indicationBox = new IndicationBox("The connections feature is disabled since the JMX support is disabled", 1);
    }

    protected void setTableColumnSettings() {
        TableColumnModel tableColumnModel = this._connectionsTable.getColumnModel();
        TableColumn ipTableColumn = tableColumnModel.getColumn(0);
        TableColumn portTableColumn = tableColumnModel.getColumn(1);
        TableColumn startTimeTableColumn = tableColumnModel.getColumn(2);
        TableColumn disconnectionTimeTableColumn = tableColumnModel.getColumn(3);
        portTableColumn.setPreferredWidth(85);
        TransportConnectionTableCellRenderer cellRenderer = new TransportConnectionTableCellRenderer();
        ipTableColumn.setCellRenderer(cellRenderer);
        portTableColumn.setCellRenderer(cellRenderer);
        startTimeTableColumn.setCellRenderer(cellRenderer);
        disconnectionTimeTableColumn.setCellRenderer(cellRenderer);
    }

    protected Box createServerConnectionBox() {
        Box serverConnectionsBox = new Box(0);
        JLabel serverIPLabel = new JLabel("Source space IP Address:");
        this.serverIPField = new JTextField();
        this.serverIPField.setEditable(false);
        this.createCleanButton();
        serverConnectionsBox.add(Box.createHorizontalStrut(5));
        serverConnectionsBox.add(serverIPLabel);
        serverConnectionsBox.add(Box.createHorizontalStrut(5));
        serverConnectionsBox.add(this.serverIPField);
        serverConnectionsBox.add(Box.createHorizontalStrut(20));
        serverConnectionsBox.add(this.cleanDisconnectionsButton);
        serverConnectionsBox.add(Box.createHorizontalStrut(20));
        serverConnectionsBox.add(this._searchEditor);
        serverConnectionsBox.add(Box.createHorizontalStrut(2));
        this.addActionListenerToCleanButton();
        return serverConnectionsBox;
    }

    protected void createCleanButton() {
        this.cleanDisconnectionsButton = new JButton("Clean Disconnected");
        this.cleanDisconnectionsButton.setMnemonic('d');
    }

    protected void addActionListenerToCleanButton() {
        this.cleanDisconnectionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEVent) {
                SpaceConnectionsPanel.this._connectionsTableModel.cleanAllDisconnectedConnections();
                SpaceConnectionsPanel.this._connectionsTableModel.refresh();
            }
        });
    }

    protected class TableColumnSortListener
    extends MouseAdapter {
        private boolean _ascending = false;
        private int _sortedColumnIndex = -1;
        private JTable _table;
        private ConnectionsTableModel _tableModel;
        private TableColumnModel _columnModel;

        public TableColumnSortListener(JTable table, ConnectionsTableModel tableModel) {
            this._table = table;
            this._tableModel = tableModel;
            this._columnModel = this._table.getColumnModel();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this._sortedColumnIndex = this._columnModel.getColumnIndexAtX(e.getX());
            this.sortAllRowsBy(this._sortedColumnIndex, this._ascending);
            this._ascending = !this._ascending;
        }

        private void sortAllRowsBy(int colIndex, boolean ascending) {
            int selRow = this._table.getSelectedRow();
            TransportConnectionWrapper selTransportConnectionWrapper = null;
            if (selRow >= 0) {
                selTransportConnectionWrapper = this._tableModel.getWrapperAt(selRow);
            }
            Collections.sort(this._tableModel.getConnectionWrappersList(), new ColumnSorter(colIndex, ascending));
            this._tableModel.fireTableStructureChanged();
            this.selectTableRow(selTransportConnectionWrapper);
        }

        protected void sortAllRows() {
            if (this._sortedColumnIndex >= 0) {
                this.sortAllRowsBy(this._sortedColumnIndex, !this._ascending);
            }
        }

        private void selectTableRow(TransportConnectionWrapper selTransportConnectionWrapper) {
            int wrapperIndex;
            if (selTransportConnectionWrapper != null && (wrapperIndex = this._tableModel.getWrapperIndex(selTransportConnectionWrapper)) != -1) {
                this._table.setRowSelectionInterval(wrapperIndex, wrapperIndex);
            }
        }

        private class ColumnSorter
        implements Comparator {
            private int colIndex;
            private boolean ascending;

            public ColumnSorter(int colIndex, boolean ascending) {
                this.colIndex = colIndex;
                this.ascending = ascending;
            }

            public int compare(Object a, Object b) {
                TransportConnectionWrapper transportConnectionWrapper1 = (TransportConnectionWrapper)a;
                TransportConnectionWrapper transportConnectionWrapper2 = (TransportConnectionWrapper)b;
                Object obj1 = TableColumnSortListener.this._tableModel.getCellValue(transportConnectionWrapper1, this.colIndex, false);
                Object obj2 = TableColumnSortListener.this._tableModel.getCellValue(transportConnectionWrapper2, this.colIndex, false);
                if (obj1 == null && obj2 == null) {
                    return 0;
                }
                if (this.ascending) {
                    if (obj1 == null && obj2 != null) {
                        return -1;
                    }
                    if (obj1 != null && obj2 == null) {
                        return 1;
                    }
                    return ((Comparable)obj1).compareTo(obj2);
                }
                if (obj2 == null && obj1 != null) {
                    return -1;
                }
                if (obj2 != null && obj1 == null) {
                    return 1;
                }
                return ((Comparable)obj2).compareTo(obj1);
            }
        }
    }

    public class TransportConnectionWrapper {
        private ITransportConnection connection;
        private Date disconnectionTime;
        private MBeanServerConnection mBeanServerConnection;
        private String memberName;

        public TransportConnectionWrapper(ITransportConnection connection, MBeanServerConnection mBeanServerConnection, String memberName) {
            this(connection, mBeanServerConnection);
            this.memberName = memberName;
        }

        public TransportConnectionWrapper(ITransportConnection connection, MBeanServerConnection mBeanServerConnection) {
            this.connection = connection;
            this.mBeanServerConnection = mBeanServerConnection;
        }

        public MBeanServerConnection getMBeanServerConnection() {
            return this.mBeanServerConnection;
        }

        public String getMemberName() {
            return this.memberName;
        }

        public Date getConnectTime() {
            return this.connection.getConnectTime();
        }

        public Date getDisconnectionTime() {
            return this.disconnectionTime;
        }

        public void setDisconnectionTime(Date disconnectionTime) {
            this.disconnectionTime = disconnectionTime;
        }

        public String getClientIPAddress() {
            return this.connection.getClientIPAddress();
        }

        public int getClientPort() {
            return this.connection.getClientPort();
        }

        public String getServerIPAddress() {
            return this.connection.getServerIPAddress();
        }

        public int getServerPort() {
            return this.connection.getServerPort();
        }

        public long getConnectionID() {
            return this.connection.getConnectionID();
        }

        public synchronized int hashCode() {
            int hashCode = 0;
            long connectionId = this.getConnectionID();
            hashCode ^= Long.valueOf(connectionId).hashCode();
            if (this.disconnectionTime != null) {
                hashCode ^= this.disconnectionTime.hashCode();
            }
            return hashCode;
        }

        public boolean equals(Object obj) {
            TransportConnectionWrapper connectionWrapper = (TransportConnectionWrapper)obj;
            return this.getConnectionID() == connectionWrapper.getConnectionID() && JSpaceUtilities.isObjectEquals((Object)this.getDisconnectionTime(), (Object)connectionWrapper.getDisconnectionTime());
        }
    }

    private class CustomizeTableHeader
    extends JTableHeader {
        public CustomizeTableHeader(TableColumnModel tableColumnModel) {
            super(tableColumnModel);
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            Point p = e.getPoint();
            int index = this.columnModel.getColumnIndexAtX(p.x);
            TableColumn tableColumn = this.columnModel.getColumn(index);
            int realIndex = tableColumn.getModelIndex();
            return this.table.getModel().getColumnName(realIndex);
        }
    }

    public class TransportConnectionTableCellRenderer
    extends DefaultTableCellRenderer {
        private Color backgroundColor = new Color(255, 108, 108);

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            TransportConnectionWrapper connectionWrapper = ((ConnectionsTableModel)table.getModel()).getWrapperAt(row);
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                if (connectionWrapper != null && connectionWrapper.getDisconnectionTime() != null) {
                    this.setBackground(this.backgroundColor);
                } else {
                    this.setBackground(table.getBackground());
                }
            }
            this.setFont(table.getFont());
            if (hasFocus) {
                Border border = null;
                if (isSelected) {
                    border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
                }
                this.setBorder(border);
                if (!isSelected && table.isCellEditable(row, column)) {
                    Color col = UIManager.getColor("Table.focusCellForeground");
                    if (col != null) {
                        super.setForeground(col);
                    }
                    if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                        super.setBackground(col);
                    }
                }
            }
            this.setValue(value);
            return this;
        }
    }

    public class ConnectionsTableModel
    extends DefaultTableModel
    implements IRefreshable,
    ISearchComponent {
        protected static final String CN_CLIENT_IP_ADDRESS = "Destination client IP Address";
        protected static final String CN_CLIENT_PORT = "Destination client Port";
        protected static final String CN_START_TIME = "Start Time";
        protected static final String CN_DISCONNECTION_TIME = "Disconnection Time";
        protected String[] columnNames;
        protected List<TransportConnectionWrapper> connectionsInfoList = Collections.synchronizedList(new ArrayList());
        protected List<TransportConnectionWrapper> filteredConnectionsInfoList = Collections.synchronizedList(new ArrayList());
        private MBeanServerConnection _mBeanServerConnection;
        private long _spaceUID;
        private String _containerName;
        protected DateFormat df = DateFormat.getDateTimeInstance(2, 1);
        protected boolean _isRefreshInvoke;
        protected String _searchedText = "";

        public ConnectionsTableModel() {
            this.initColumnNames();
        }

        protected void initColumnNames() {
            this.columnNames = new String[4];
            this.columnNames[0] = CN_CLIENT_IP_ADDRESS;
            this.columnNames[1] = CN_CLIENT_PORT;
            this.columnNames[2] = CN_START_TIME;
            this.columnNames[3] = CN_DISCONNECTION_TIME;
        }

        public void initModel(MBeanServerConnection beanServerConnection, long spaceUID, String containerName) {
            if (spaceUID == this._spaceUID && beanServerConnection != null && beanServerConnection.equals(this._mBeanServerConnection)) {
                this.refresh();
                return;
            }
            this._mBeanServerConnection = beanServerConnection;
            this._spaceUID = spaceUID;
            this._containerName = containerName;
            SpaceConnectionsPanel.this.serverIPField.setText("");
            this.clearModel();
            SpaceConnectionsPanel.this.allConnectionsMap.clear();
            SpaceConnectionsPanel.this.disconnectedConnectionsMap.clear();
            this.refresh();
        }

        protected void clearModel() {
            int initialListSize = this.filteredConnectionsInfoList.size();
            this.filteredConnectionsInfoList = new ArrayList<TransportConnectionWrapper>();
            SpaceConnectionsPanel.this.allConnectionsMap.clear();
            SpaceConnectionsPanel.this.disconnectedConnectionsMap.clear();
            if (initialListSize > 0) {
                this.fireTableRowsDeleted(0, initialListSize - 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleanAllDisconnectedConnections() {
            int disconnectedItemsCount = SpaceConnectionsPanel.this.disconnectedConnectionsMap.size();
            if (disconnectedItemsCount > 0) {
                List<TransportConnectionWrapper> list = this.filteredConnectionsInfoList;
                synchronized (list) {
                    int listSize = this.filteredConnectionsInfoList.size();
                    this.filteredConnectionsInfoList.removeAll(SpaceConnectionsPanel.this.disconnectedConnectionsMap.values());
                    this.fireTableRowsDeleted(listSize - disconnectedItemsCount, listSize - 1);
                }
            }
            SpaceConnectionsPanel.this.allConnectionsMap.clear();
            SpaceConnectionsPanel.this.disconnectedConnectionsMap.clear();
        }

        @Override
        public Object getValueAt(int row, int column) {
            TransportConnectionWrapper transporWrapper = this.getWrapperAt(row);
            if (transporWrapper != null) {
                return this.getCellValue(transporWrapper, column, true);
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public Class getColumnClass(int columnIndex) {
            Object obj = this.getValueAt(0, columnIndex);
            if (obj != null) {
                return obj.getClass();
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this.filteredConnectionsInfoList == null ? 0 : this.filteredConnectionsInfoList.size();
        }

        public Object getCellValue(TransportConnectionWrapper transportWrapper, int column, boolean isFormatDate) {
            switch (column) {
                case 0: {
                    return transportWrapper.getClientIPAddress();
                }
                case 1: {
                    return transportWrapper.getClientPort();
                }
                case 2: {
                    if (isFormatDate) {
                        return this.df.format(transportWrapper.getConnectTime());
                    }
                    return transportWrapper.getConnectTime();
                }
                case 3: {
                    Date disconnectionTime = transportWrapper.getDisconnectionTime();
                    if (!isFormatDate) {
                        return disconnectionTime;
                    }
                    if (disconnectionTime == null) {
                        return "";
                    }
                    return this.df.format(disconnectionTime);
                }
            }
            return "";
        }

        public TransportConnectionWrapper getWrapperAt(int row) {
            if (row < this.filteredConnectionsInfoList.size()) {
                return this.filteredConnectionsInfoList.get(row);
            }
            return null;
        }

        public int getWrapperIndex(TransportConnectionWrapper connectionWrapper) {
            return this.filteredConnectionsInfoList.indexOf(connectionWrapper);
        }

        @Override
        public void setInvokeRefresh(boolean invokeRefresh) {
            this._isRefreshInvoke = invokeRefresh;
        }

        @Override
        public void search(String searchedText) {
            this._searchedText = searchedText;
            this.filterList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void filterList() {
            int filteredListSize;
            int selRow = SpaceConnectionsPanel.this._connectionsTable.getSelectedRow();
            TransportConnectionWrapper selTransportConnectionWrapper = null;
            if (selRow >= 0) {
                selTransportConnectionWrapper = this.getWrapperAt(selRow);
            }
            if (this._searchedText.length() == 0) {
                for (TransportConnectionWrapper connectionWrapper : this.connectionsInfoList) {
                    if (this.filteredConnectionsInfoList.contains(connectionWrapper)) continue;
                    this.filteredConnectionsInfoList.add(connectionWrapper);
                    int index = this.filteredConnectionsInfoList.indexOf(connectionWrapper);
                    this.fireTableRowsInserted(index, index);
                }
                filteredListSize = this.filteredConnectionsInfoList.size();
                for (int index = filteredListSize - 1; index >= 0; --index) {
                    if (this.connectionsInfoList.contains(this.filteredConnectionsInfoList.get(index))) continue;
                    this.filteredConnectionsInfoList.remove(index);
                    this.fireTableRowsDeleted(index, index);
                }
            } else {
                filteredListSize = this.filteredConnectionsInfoList.size();
                for (int index = filteredListSize - 1; index >= 0; --index) {
                    TransportConnectionWrapper connectionWrapper = this.filteredConnectionsInfoList.get(index);
                    if (this.isDisplayConnection(connectionWrapper)) continue;
                    this.filteredConnectionsInfoList.remove(connectionWrapper);
                    this.fireTableRowsDeleted(index, index);
                }
                List<TransportConnectionWrapper> list = this.connectionsInfoList;
                synchronized (list) {
                    for (TransportConnectionWrapper connectionWrapper : this.connectionsInfoList) {
                        if (!this.isDisplayConnection(connectionWrapper) || this.filteredConnectionsInfoList.contains(connectionWrapper)) continue;
                        this.filteredConnectionsInfoList.add(connectionWrapper);
                        int index = this.filteredConnectionsInfoList.indexOf(connectionWrapper);
                        this.fireTableRowsInserted(index, index);
                    }
                }
            }
            if (SpaceConnectionsPanel.this.serverIPField != null && this.filteredConnectionsInfoList.size() > 0) {
                TransportConnectionWrapper wr = this.filteredConnectionsInfoList.get(0);
                if (!SpaceConnectionsPanel.this.serverIPField.getText().equals(wr.getServerIPAddress())) {
                    SpaceConnectionsPanel.this.serverIPField.setText(wr.getServerIPAddress() + ":" + wr.getServerPort());
                }
            } else if (SpaceConnectionsPanel.this.serverIPField != null) {
                SpaceConnectionsPanel.this.serverIPField.setText("");
            }
            if (selTransportConnectionWrapper != null) {
                this.selectWrapper(selTransportConnectionWrapper);
            }
        }

        protected boolean isDisplayConnection(TransportConnectionWrapper wrapper) {
            return wrapper.getClientIPAddress().startsWith(this._searchedText) || String.valueOf(wrapper.getClientPort()).startsWith(this._searchedText);
        }

        @Override
        public void refresh() {
            if (this._isRefreshInvoke && this._mBeanServerConnection != null) {
                int selRow = SpaceConnectionsPanel.this._connectionsTable.getSelectedRow();
                TransportConnectionWrapper selTransportConnectionWrapper = null;
                if (selRow >= 0) {
                    selTransportConnectionWrapper = SpaceConnectionsPanel.this._connectionsTableModel.getWrapperAt(selRow);
                }
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "@@@ Refresh Space Connections Table. ");
                }
                if (this._spaceUID < 0L) {
                    this.updateCounts();
                    return;
                }
                SpaceConnectionsPanel.this.serverIPField.setText("");
                try {
                    SpaceConnectionsPanel.this.params[0] = new Long(this._spaceUID);
                    ObjectName transportMBeanName = TransportConstants.createTransportMBeanObjectName((String)this._containerName);
                    ArrayList<TransportConnectionWrapper> newConnectionWrapperslist = new ArrayList<TransportConnectionWrapper>();
                    this.retriveConnectionsAndAddToList(this._mBeanServerConnection, transportMBeanName, null, newConnectionWrapperslist);
                    this.handleNewConnections(newConnectionWrapperslist, selTransportConnectionWrapper);
                }
                catch (RemoteException e) {
                    _logger.log(Level.FINE, e.toString(), e);
                }
                catch (InstanceNotFoundException exc) {
                    _logger.log(Level.FINE, exc.toString(), exc);
                }
                catch (Exception e) {
                    _logger.log(Level.SEVERE, e.toString(), e);
                }
                this.updateCounts();
            }
        }

        protected void retriveConnectionsAndAddToList(MBeanServerConnection mBeanServerConnection, ObjectName mBeanName, String clusterMemberName, List<TransportConnectionWrapper> newConnectionWrapperslist) throws Exception {
            List list = (List)mBeanServerConnection.invoke(mBeanName, "getTransportConnections", SpaceConnectionsPanel.this.params, SpaceConnectionsPanel.this.signature);
            if (list != null) {
                for (ITransportConnection transportConnection : list) {
                    newConnectionWrapperslist.add(new TransportConnectionWrapper(transportConnection, mBeanServerConnection, clusterMemberName));
                }
            }
        }

        protected void handleNewConnections(List<TransportConnectionWrapper> newConnectionWrapperslist, TransportConnectionWrapper selTransportConnectionWrapper) throws Exception {
            int curListSize = this.connectionsInfoList.size();
            for (int listIndex = curListSize - 1; listIndex >= 0; --listIndex) {
                TransportConnectionWrapper transportConnectionWrapper = this.connectionsInfoList.get(listIndex);
                if (newConnectionWrapperslist.indexOf(transportConnectionWrapper) >= 0) continue;
                this.connectionsInfoList.remove(transportConnectionWrapper);
            }
            int listSize = newConnectionWrapperslist.size();
            for (int listIndex = listSize - 1; listIndex >= 0; --listIndex) {
                TransportConnectionWrapper newTransportWrapper = newConnectionWrapperslist.get(listIndex);
                if (this.connectionsInfoList.contains(newTransportWrapper)) continue;
                this.connectionsInfoList.add(newTransportWrapper);
            }
            this.handleDisconnectedConnections(this.connectionsInfoList);
            this.filterList();
            this.selectWrapper(selTransportConnectionWrapper);
            SpaceConnectionsPanel.this._tableColumnSortListener.sortAllRows();
        }

        protected void updateCounts() {
            SpaceConnectionsPanel.this._infoBox.setCount(this.connectionsInfoList.size() - SpaceConnectionsPanel.this.disconnectedConnectionsMap.size());
            SpaceConnectionsPanel.this._infoBox.setCount2(SpaceConnectionsPanel.this.disconnectedConnectionsMap.size());
        }

        private void selectWrapper(TransportConnectionWrapper selTransportConnectionWrapper) {
            int selIndex;
            if (selTransportConnectionWrapper != null && (selIndex = SpaceConnectionsPanel.this._connectionsTableModel.getWrapperIndex(selTransportConnectionWrapper)) >= 0) {
                SpaceConnectionsPanel.this._connectionsTable.setRowSelectionInterval(selIndex, selIndex);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpaceConnectionsPanel.this._connectionsTable.scrollRectToVisible(SpaceConnectionsPanel.this._connectionsTable.getCellRect(selIndex, 0, true));
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleDisconnectedConnections(List<TransportConnectionWrapper> list) throws Exception {
            HashMap<Long, TransportConnectionWrapper> clonedMap = new HashMap<Long, TransportConnectionWrapper>(SpaceConnectionsPanel.this.allConnectionsMap);
            for (TransportConnectionWrapper transportConnection : list) {
                Long key = new Long(transportConnection.getConnectionID());
                if (!SpaceConnectionsPanel.this.allConnectionsMap.containsKey(key)) {
                    SpaceConnectionsPanel.this.allConnectionsMap.put(key, transportConnection);
                }
                clonedMap.remove(key);
            }
            Iterator iterator = clonedMap.values().iterator();
            List<TransportConnectionWrapper> list2 = this.connectionsInfoList;
            synchronized (list2) {
                while (iterator.hasNext()) {
                    TransportConnectionWrapper disconnectedConnection = (TransportConnectionWrapper)iterator.next();
                    Long connectionID = new Long(disconnectedConnection.getConnectionID());
                    if (!SpaceConnectionsPanel.this.disconnectedConnectionsMap.containsKey(connectionID)) {
                        MBeanServerConnection mBeanServerConnectionTimeSynch = disconnectedConnection.getMBeanServerConnection();
                        ObjectName localTimeMBeanName = LocalTimeConstants.MBEAN_NAME;
                        Date localMBeanServerTime = (Date)mBeanServerConnectionTimeSynch.invoke(localTimeMBeanName, "localCurrentTime", null, null);
                        disconnectedConnection.setDisconnectionTime(localMBeanServerTime);
                        SpaceConnectionsPanel.this.disconnectedConnectionsMap.put(connectionID, disconnectedConnection);
                    }
                    this.connectionsInfoList.add(disconnectedConnection);
                }
            }
        }

        public List<TransportConnectionWrapper> getConnectionWrappersList() {
            return this.filteredConnectionsInfoList;
        }

        @Override
        public boolean isRunning() {
            return !SpaceConnectionsPanel.this.refreshPanel.isStop();
        }

        @Override
        public void start() {
        }

        @Override
        public void stop() {
        }
    }
}

