/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.gigaspaces.admin.security.SecurityServicesRepository;
import com.gigaspaces.admin.ui.AdminUIThreadPool;
import com.gigaspaces.admin.ui.grid.IConnectionProvider;
import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.grid.space.ISearchComponent;
import com.gigaspaces.admin.ui.grid.space.SearchEditor;
import com.gigaspaces.admin.ui.views.utils.BasicSortableTableModel;
import com.gigaspaces.admin.ui.views.utils.BasicTable;
import com.gigaspaces.admin.ui.views.utils.BasicWrapper;
import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.security.authorities.Privilege;
import com.gigaspaces.security.authorities.SpaceAuthority;
import com.gigaspaces.security.service.SecuredService;
import com.j_spaces.core.DropClassException;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.IInternalRemoteJSpaceAdmin;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.admin.SpaceRuntimeInfo;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.IRefreshable;
import com.j_spaces.tools.spacebrowser.ClassPropertiesPanel;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.TemplatesInfoPanel;
import com.j_spaces.tools.spacebrowser.utils.IndicationBox;
import com.j_spaces.tools.spacebrowser.utils.InstancesInfoBox;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import com.j_spaces.tools.spacebrowser.utils.RefreshPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import net.jini.core.lookup.ServiceID;
import net.jini.space.InternalSpaceException;

public class SpaceRuntimePanel
extends JPanel
implements IRefreshable {
    private SpaceRuntimeInfo runtime;
    private final JPanel runtimePanel = new JPanel();
    private final Border border1;
    private final TitledBorder titledBorder1;
    private final BorderLayout borderLayout1 = new BorderLayout();
    private final BorderLayout borderLayout2 = new BorderLayout();
    private final JSplitPane tableSplitPane;
    protected ClassPropertiesPanel classPropertiesPanel;
    protected TemplatesInfoPanel templatesInfoPanel;
    protected SpaceBrowser m_spaceBrowser;
    protected JFrame _parentFrame;
    private IInternalRemoteJSpaceAdmin spaceAdmin;
    private IJSpace _spaceProxy;
    private IConnectionProvider _connectionProvider;
    private ServiceID _spaceID;
    private static final String DIALOG_RUNTIME_COLUMN = "dialog.runtime.columnname";
    private final JButton queryButton;
    private final JButton deleteButton;
    private final JButton clearButton;
    private final JPanel tablePanel;
    private final Box tableControlPanel;
    static int clickCount = 0;
    protected JTabbedPane classesPropsTab;
    protected IndicationBox _indicationBox;
    private final JPopupMenu rightMenu;
    private final JMenuItem deleteMenu;
    private final JMenuItem clearMenu;
    private final JMenuItem queryMenu;
    protected BasicTable table;
    protected RuntimeTableModel model;
    private final boolean isQueryExecutionEnabled;
    protected RefreshPanel refreshPanel;
    protected boolean _isInvokeRefresh;
    private final SearchEditor _searchEditor;
    protected InstancesInfoBox _infoBox;
    private boolean _isPersistentLRUSpace = false;
    protected final int CI_CLASS_NAME = 0;
    protected final int CI_INSTANCES_COUNT = 1;
    protected final int CI_TEMPLATES_COUNT = 2;
    protected static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui.spacebrowser");
    protected volatile Future<?> refreshThreadTask;
    private boolean _isAlterPermitted;
    private boolean _isTakePermitted;
    private boolean _isReadPermitted;

    public SpaceRuntimePanel(JFrame parentFrame, SpaceBrowser spaceBrowser, boolean isQueryExecutionEnabled) {
        this.isQueryExecutionEnabled = isQueryExecutionEnabled;
        this.rightMenu = new JPopupMenu();
        this.deleteMenu = new JMenuItem("Delete");
        this.clearMenu = new JMenuItem("Clear");
        this.queryMenu = new JMenuItem("Query");
        this.rightMenu.add(this.clearMenu);
        this.rightMenu.add(this.queryMenu);
        this.m_spaceBrowser = spaceBrowser;
        this._parentFrame = parentFrame;
        this.model = new RuntimeTableModel();
        this.table = new BasicTable(this.model);
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new BorderLayout());
        this.queryButton = new JButton("Query");
        this.deleteButton = new JButton("Delete");
        this.clearButton = new JButton("Clear");
        this.setControlEnabled(false);
        this.refreshPanel = new RefreshPanel(this, false);
        this.queryMenu.setEnabled(isQueryExecutionEnabled);
        this.queryButton.setEnabled(isQueryExecutionEnabled);
        this.border1 = BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142));
        this._searchEditor = new SearchEditor(this.model);
        JTableHeader tableHeader = this.table.getTableHeader();
        TableColumnModel tableColummModel = this.table.getColumnModel();
        tableColummModel.getColumn(1).setPreferredWidth(140);
        tableColummModel.getColumn(1).setMaxWidth(140);
        tableColummModel.getColumn(2).setPreferredWidth(135);
        tableColummModel.getColumn(2).setMaxWidth(135);
        tableHeader.setReorderingAllowed(false);
        this.table.setAutoscrolls(true);
        this.table.setSelectionMode(0);
        this.table.setAutoCreateColumnsFromModel(false);
        this.table.setAutoResizeMode(1);
        this.setBorder(null);
        this.titledBorder1 = new TitledBorder(this.border1, "Data Types List");
        this.setLayout(this.borderLayout2);
        this.runtimePanel.setLayout(this.borderLayout1);
        this.runtimePanel.setBorder(this.titledBorder1);
        this.add((Component)this.runtimePanel, "Center");
        this.classPropertiesPanel = new ClassPropertiesPanel(this._parentFrame, this);
        this.templatesInfoPanel = new TemplatesInfoPanel(this._parentFrame);
        this.classPropertiesPanel.setPreferredSize(new Dimension(600, 300));
        this.tableControlPanel = new Box(0);
        this.queryButton.addActionListener(new QueryActionListener());
        this.deleteButton.addActionListener(new DeleteClassActionListener());
        this.clearButton.addActionListener(new ClearClassActionListener());
        this.queryMenu.addActionListener(new QueryActionListener());
        this.deleteMenu.addActionListener(new DeleteClassActionListener());
        this.clearMenu.addActionListener(new ClearClassActionListener());
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (SwingUtilities.isRightMouseButton(evt)) {
                    int rowPoint = SpaceRuntimePanel.this.table.rowAtPoint(evt.getPoint());
                    SpaceRuntimePanel.this.table.setRowSelectionInterval(rowPoint, rowPoint);
                    if (SpaceRuntimePanel.this.table.getSelectedRow() > -1) {
                        SpaceRuntimePanel.this.rightMenu.show(SpaceRuntimePanel.this.table, evt.getX(), evt.getY());
                    }
                }
            }
        });
        if (this.m_spaceBrowser != null) {
            this.tableControlPanel.add(this.queryButton);
        }
        this.tableControlPanel.add(Box.createHorizontalStrut(7));
        this.tableControlPanel.add(this.clearButton);
        this.tableControlPanel.add(Box.createHorizontalGlue());
        this.tableControlPanel.setBorder(null);
        this._infoBox = new InstancesInfoBox("data type");
        Box bottomBox = new Box(0);
        bottomBox.add(this._infoBox);
        bottomBox.add(this.tableControlPanel);
        this.tablePanel.add((Component)new JScrollPane(this.table), "Center");
        this.tablePanel.add((Component)bottomBox, "South");
        this.classesPropsTab = new JTabbedPane();
        this.classesPropsTab.addTab("Data Types Info", this.classPropertiesPanel);
        this.classesPropsTab.addTab("Notify Templates Info", this.templatesInfoPanel);
        this.tableSplitPane = new JSplitPane(0, this.tablePanel, this.classesPropsTab);
        this.classesPropsTab.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int selRow;
                if (SpaceRuntimePanel.this.classesPropsTab.getSelectedComponent().equals(SpaceRuntimePanel.this.templatesInfoPanel) && (selRow = SpaceRuntimePanel.this.table.getSelectedRow()) >= 0) {
                    SpaceRuntimePanel.this.refreshPropertiesTabPanel(selRow);
                }
            }
        });
        this.tableSplitPane.setOneTouchExpandable(true);
        this.tableSplitPane.setDividerLocation(170);
        ListSelectionModel tableRowSM = this.table.getSelectionModel();
        this.setPreferredSize(new Dimension(600, 600));
        tableRowSM.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (!lsm.isSelectionEmpty()) {
                    SpaceRuntimePanel.this.setControlEnabled(SpaceRuntimePanel.this.m_spaceBrowser != null);
                    int selectedRow = lsm.getMinSelectionIndex();
                    SpaceRuntimePanel.this.refreshPropertiesTabPanel(selectedRow);
                }
            }
        });
        this.createIndicationBox();
        Box searchBox = new Box(0);
        searchBox.add(Box.createHorizontalGlue());
        searchBox.add(this._searchEditor);
        Box northRefreshBox = new Box(0);
        northRefreshBox.add(this.refreshPanel);
        northRefreshBox.add(Box.createVerticalStrut(1));
        northRefreshBox.add(this._indicationBox);
        northRefreshBox.add(searchBox);
        northRefreshBox.add(Box.createVerticalStrut(5));
        this.runtimePanel.add((Component)northRefreshBox, "North");
        this.runtimePanel.add((Component)this.tableSplitPane, "Center");
    }

    protected void createIndicationBox() {
        this._indicationBox = new IndicationBox("<HTML>Objects of persistent LRU space are not displayed. It can be changed by selecting <B>View > Display Persistent LRU Space Metrics</B> menu item</HTML>", 1);
    }

    protected void refreshPropertiesTabPanel(int selectedRow) {
        String selectedClassName = (String)this.model.getValueAt(selectedRow, 0);
        ITypeDesc basicTypeInfo = null;
        try {
            basicTypeInfo = this.spaceAdmin.getClassDescriptor(selectedClassName);
        }
        catch (RemoteException exc) {
            _logger.log(Level.SEVERE, exc.toString(), exc);
        }
        if (this.classesPropsTab.getSelectedComponent().equals(this.templatesInfoPanel)) {
            try {
                List templatesInfoList = this.spaceAdmin.getTemplatesInfo(selectedClassName);
                this.templatesInfoPanel.displayTemplates(selectedClassName, basicTypeInfo, templatesInfoList);
            }
            catch (RemoteException exc) {
                _logger.log(Level.SEVERE, exc.toString(), exc);
            }
        }
        this.classPropertiesPanel.setBasicTypeInfo(selectedClassName, (ISpaceProxy)this._spaceProxy, this.spaceAdmin, basicTypeInfo);
    }

    protected void queryRow() {
        try {
            int selRow = this.table.getSelectedRow();
            String querysSTR = "select uid,* from " + this.model.getValueAt(selRow, 0);
            this.m_spaceBrowser.selectSpaceOperationNode(this._spaceID, "Query");
            this.m_spaceBrowser.showQueryPanel(querysSTR, this._connectionProvider.getConnection(), this.m_spaceBrowser.getSelectedSpaceNode().toString());
        }
        catch (Exception e) {
            SpaceBrowser.showException("Query", e);
        }
    }

    protected void deleteRow() {
        try {
            String clazz = this.model.getValueAt(this.table.getSelectedRow(), 0).toString();
            String question = "<HTML><B>Are you sure you want to delete <FONT color=\"blue\">" + clazz + "</FONT><BR>definition and all its instances from space <FONT color=\"green\">" + this._spaceProxy.getName() + "</FONT>?</B><BR><FONT color=\"red\">Notice deleting a class definition will not trigger any notification and therefore<BR>any connected LocalView and LocalCache might get into inconsistent state.<BR>Consider using Clear instead.</FONT></HTML>";
            int pressed = JOptionPane.showConfirmDialog(this._parentFrame, question, "Delete Class", 0, 2);
            if (pressed == 0) {
                this.deleteEntriesFromSpace(this._spaceProxy, clazz);
            }
        }
        catch (Exception e) {
            SpaceBrowser.showException("Deleting class", e);
        }
    }

    private void deleteEntriesFromSpace(IJSpace space, String clazz) throws DropClassException, RemoteException {
        space.dropClass(clazz);
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow >= 0 && selectedRow < this.table.getRowCount()) {
            this.model.removeRow(selectedRow);
        }
        this.classPropertiesPanel.clear(false);
        this.setControlEnabled(false);
    }

    protected void clearRow() {
        try {
            String clazz = this.model.getValueAt(this.table.getSelectedRow(), 0).toString();
            String spaceName = this._spaceProxy.getName();
            if (((ISpaceProxy)this._spaceProxy).isClustered()) {
                String clusteredSpaceQuestion = "All " + clazz + " instances will be removed from \"" + spaceName + "\" space.\nSpace \"" + spaceName + "\" is clustered.Please select operation target:";
                Object[] options = new String[]{"All Cluster members", "Space \"" + spaceName + "\"", "Cancel"};
                int returnVal = JOptionPane.showOptionDialog(this._parentFrame, clusteredSpaceQuestion, "Clear Class", 2, 2, null, options, options[1]);
                if (returnVal == 0) {
                    this.clearSpace(this._spaceProxy, clazz);
                } else if (returnVal == 1) {
                    IJSpace space = this._spaceProxy.getDirectProxy().getNonClusteredProxy();
                    SecurityServicesRepository.getInstance().authenticateUsingExistngAuthentication(space);
                    this.clearSpace(space, clazz);
                }
            } else {
                String question = "Are you sure you want to delete all " + clazz + " instances from space \"" + spaceName + "\"?";
                int pressed = JOptionPane.showConfirmDialog(this._parentFrame, question, "Clean", 0, 2);
                if (pressed == 0) {
                    this.clearSpace(this._spaceProxy, clazz);
                }
            }
            this.refresh();
        }
        catch (Exception e) {
            SpaceBrowser.showException("Cleaning class", e);
        }
    }

    protected void clearSpace(IJSpace space, String typeName) throws Exception {
        space.clear((Object)new SpaceDocument(typeName), null);
    }

    public void setControlEnabled(boolean en) {
        if (this.isQueryExecutionEnabled && this._isReadPermitted) {
            this.queryButton.setEnabled(en);
            this.queryMenu.setEnabled(en);
        }
        if (this._isAlterPermitted) {
            this.deleteButton.setEnabled(en);
            this.deleteMenu.setEnabled(en);
        }
        if (this._isTakePermitted) {
            this.clearButton.setEnabled(en);
            this.clearMenu.setEnabled(en);
        }
    }

    public void stopStatusRuntime() {
        this.refreshPanel.stopStatusRuntime();
    }

    public void clearRuntimeDialog() {
        this.model.clear();
    }

    public void setSpaceAdmin(IJSpace spaceProxy, IRemoteJSpaceAdmin spaceAdmin, ServiceID spaceID, IConnectionProvider connectionProvider) {
        block4: {
            if (spaceAdmin == null) {
                this._isPersistentLRUSpace = false;
                return;
            }
            this.spaceAdmin = (IInternalRemoteJSpaceAdmin)spaceAdmin;
            this._spaceID = spaceID;
            this._spaceProxy = spaceProxy;
            this._connectionProvider = connectionProvider;
            this.updateSecuredOperationsState(this._spaceProxy, this._spaceID);
            try {
                SpaceConfig spaceConfig = Repository.addSpaceConfigToMap(spaceAdmin);
                this._isPersistentLRUSpace = spaceConfig.isPersistent() && spaceConfig.getCachePolicy().equals(String.valueOf(0));
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block4;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
        this.clearRuntimeDialog();
        this.classPropertiesPanel.clear(false);
        if (this.refreshPanel.isStop()) {
            this.refreshPanel.setStartButtonEnabled(true);
        }
        this.refresh();
    }

    public boolean isStop() {
        return this.refreshPanel.isStop();
    }

    public ImageIcon getStopIcon() {
        return this.refreshPanel.getStopIcon();
    }

    @Override
    public void refresh() {
        if (this.table.getSelectedRow() >= 0) {
            this.classPropertiesPanel.refreshClassIndexes();
        }
        if (this._isPersistentLRUSpace && !this.m_spaceBrowser.isRetrieveRuntimeForPersistentLRUSpace()) {
            this.clearRuntimeDialog();
            this.classPropertiesPanel.clear(true);
            this._infoBox.setCount(this.model.getRowCount());
            this._indicationBox.setVisible(true);
            return;
        }
        this._indicationBox.setVisible(false);
        if (!this._isInvokeRefresh) {
            this._infoBox.setCount(this.model.getRowCount());
            return;
        }
        if (this.refreshThreadTask == null || this.refreshThreadTask.isDone()) {
            this.refreshThreadTask = AdminUIThreadPool.getThreadPool().submit(new Runnable(){

                @Override
                public void run() {
                    block8: {
                        try {
                            if (_logger.isLoggable(Level.FINEST)) {
                                _logger.log(Level.FINEST, "@@@ Refresh Space Classes Table. ");
                                _logger.finest(" ------- in refresh() Calling spaceAdmin.getRuntimeInfo() ------");
                                long time1 = System.currentTimeMillis();
                                _logger.finest("> TIME1:" + time1);
                            }
                            SpaceRuntimePanel.this.runtime = SpaceRuntimePanel.this.spaceAdmin.getRuntimeInfo();
                            SpaceRuntimePanel.this.updateRuntimeTable(SpaceRuntimePanel.this.runtime);
                        }
                        catch (UnmarshalException ex) {
                            SpaceRuntimePanel.this.stopStatusRuntime();
                            if (SpaceRuntimePanel.this.m_spaceBrowser != null) {
                                SpaceRuntimePanel.this.m_spaceBrowser.conTree.repaint();
                                SpaceBrowser.showException("getting runtime information", ex);
                            }
                        }
                        catch (RemoteException ex) {
                            SpaceRuntimePanel.this.stopStatusRuntime();
                            if (SpaceRuntimePanel.this.m_spaceBrowser != null) {
                                SpaceRuntimePanel.this.m_spaceBrowser.conTree.repaint();
                                SpaceRuntimePanel.this.m_spaceBrowser.showStatus("Lost connection with space.");
                            }
                        }
                        catch (InternalSpaceException ex) {
                            SpaceRuntimePanel.this.stopStatusRuntime();
                            if (SpaceRuntimePanel.this.m_spaceBrowser == null) break block8;
                            SpaceRuntimePanel.this.m_spaceBrowser.showStatus("InternalSpaceError: " + ex.getMessage());
                            if (!_logger.isLoggable(Level.FINE)) break block8;
                            _logger.log(Level.FINE, ex.toString(), ex);
                        }
                    }
                    if (_logger.isLoggable(Level.FINEST)) {
                        long time5 = System.currentTimeMillis();
                        _logger.finest("> TIME6:" + time5);
                    }
                    SpaceRuntimePanel.this._infoBox.setCount(SpaceRuntimePanel.this.model.getRowCount());
                }
            });
        }
    }

    protected void updateRuntimeTable(SpaceRuntimeInfo spaceRuntimeInfo) {
        String className;
        if (_logger.isLoggable(Level.FINEST)) {
            long time2 = System.currentTimeMillis();
            _logger.finest("> TIME2:" + time2);
        }
        if (spaceRuntimeInfo.m_NumOFEntries.size() == 0 && this.model.getRowCount() != 0) {
            this.clearRuntimeDialog();
            this.classPropertiesPanel.clear(true);
        }
        if (this.table.getSelectedRow() < 0) {
            this.setControlEnabled(false);
        }
        int[] existEntryArray = new int[spaceRuntimeInfo.m_NumOFEntries.size()];
        if (_logger.isLoggable(Level.FINEST)) {
            long time3 = System.currentTimeMillis();
            _logger.finest("> TIME3:" + time3);
        }
        boolean isTableModelChanged = false;
        boolean isRuntimeDataChanged = false;
        for (int numRow = 0; numRow < this.model.getRowCount(); ++numRow) {
            int inxObj;
            RuntimeInfoWrapper runtimeInfoWrapper = (RuntimeInfoWrapper)this.model.getWrapperAt(numRow);
            className = runtimeInfoWrapper.getClassName();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(">>>> runtime.m_ClassNames=" + spaceRuntimeInfo.m_ClassNames);
            }
            if ((inxObj = spaceRuntimeInfo.m_ClassNames.indexOf(className)) != -1) {
                Object templatesNum;
                existEntryArray[inxObj] = -1;
                Object newEntryNum = spaceRuntimeInfo.m_NumOFEntries.get(inxObj);
                if (!newEntryNum.equals(this.model.getValueAt(numRow, 1))) {
                    runtimeInfoWrapper.setInstancesCount((Integer)newEntryNum);
                    isRuntimeDataChanged = true;
                    this.model.fireTableRowsUpdated(numRow, numRow);
                }
                if ((templatesNum = spaceRuntimeInfo.m_NumOFTemplates.get(inxObj)).equals(this.model.getValueAt(numRow, 2))) continue;
                runtimeInfoWrapper.setTemplatesCount((Integer)templatesNum);
                isRuntimeDataChanged = true;
                this.model.fireTableRowsUpdated(numRow, numRow);
                continue;
            }
            this.model.removeRow(numRow);
            isTableModelChanged = true;
            if (!JSpaceUtilities.isStringEqualsIgnoreCase((String)this.classPropertiesPanel.getTypeName(), (String)className)) continue;
            this.classPropertiesPanel.clear(true);
        }
        if (_logger.isLoggable(Level.FINEST)) {
            long time4 = System.currentTimeMillis();
            _logger.finest("> TIME4:" + time4);
        }
        for (int c = 0; c < existEntryArray.length; ++c) {
            Object newEntryNum = spaceRuntimeInfo.m_NumOFEntries.get(c);
            Object templateNum = spaceRuntimeInfo.m_NumOFTemplates.get(c);
            if (existEntryArray[c] == -1) continue;
            className = (String)spaceRuntimeInfo.m_ClassNames.get(c);
            RuntimeInfoWrapper runtimeInfoWrapper = new RuntimeInfoWrapper(className, (Integer)newEntryNum, (Integer)templateNum);
            this.model.addRuntimeInfoWrapper(runtimeInfoWrapper);
            isTableModelChanged = true;
        }
        if (isTableModelChanged || isRuntimeDataChanged) {
            this.model.sortAllRows();
        }
        if (isTableModelChanged) {
            this.model.filterList();
        } else {
            this.refreshClassesAndTemplatesTables();
        }
    }

    private void refreshClassesAndTemplatesTables() {
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow < 0) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("> TIME5_1:");
            }
            this.classPropertiesPanel.clear(true);
            this.templatesInfoPanel.clear();
        } else {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("> TIME5_2:");
            }
            this.refreshPropertiesTabPanel(selectedRow);
        }
    }

    @Override
    public boolean isRunning() {
        return !this.refreshPanel.isStop();
    }

    @Override
    public void start() {
        if (this.table.getSelectedRow() < 0) {
            this.setControlEnabled(false);
        }
    }

    @Override
    public void setInvokeRefresh(boolean invokeRefresh) {
        this._isInvokeRefresh = invokeRefresh;
    }

    public boolean isInvokeRefresh() {
        return this._isInvokeRefresh;
    }

    @Override
    public void stop() {
    }

    protected void updateSecuredOperationsState(IJSpace spaceProxy, ServiceID serviceID) {
        if (spaceProxy != null) {
            this._isAlterPermitted = JSpaceUIUtils.hasPermittedPermission((SecuredService)spaceProxy, serviceID, (Privilege)SpaceAuthority.SpacePrivilege.ALTER, spaceProxy.isSecured());
            this._isTakePermitted = JSpaceUIUtils.hasPermittedPermission((SecuredService)spaceProxy, serviceID, (Privilege)SpaceAuthority.SpacePrivilege.TAKE, spaceProxy.isSecured());
            this._isReadPermitted = JSpaceUIUtils.hasPermittedPermission((SecuredService)spaceProxy, serviceID, (Privilege)SpaceAuthority.SpacePrivilege.READ, spaceProxy.isSecured());
            this.clearButton.setEnabled(this._isTakePermitted);
            this.clearMenu.setEnabled(this._isTakePermitted);
            this.queryButton.setEnabled(this._isReadPermitted);
            this.queryMenu.setEnabled(this._isReadPermitted);
            this.deleteButton.setEnabled(this._isAlterPermitted);
            this.deleteMenu.setEnabled(this._isAlterPermitted);
        }
    }

    private class RuntimeInfoWrapper
    extends BasicWrapper {
        private final String className;
        private Integer instancesCount;
        private Integer templatesCount;

        RuntimeInfoWrapper(String className) {
            this(className, 0, 0);
        }

        RuntimeInfoWrapper(String className, Integer instancesCount, Integer templatesCount) {
            this.className = className;
            this.instancesCount = instancesCount;
            this.templatesCount = templatesCount;
        }

        public Integer getInstancesCount() {
            return this.instancesCount;
        }

        public void setInstancesCount(Integer instancesCount) {
            this.instancesCount = instancesCount;
        }

        public Integer getTemplatesCount() {
            return this.templatesCount;
        }

        public void setTemplatesCount(Integer templatesCount) {
            this.templatesCount = templatesCount;
        }

        public String getClassName() {
            return this.className;
        }

        public boolean equals(Object object) {
            RuntimeInfoWrapper runtimeInfoWrapper = (RuntimeInfoWrapper)object;
            return this.className.equals(runtimeInfoWrapper.getClassName());
        }

        @Override
        public boolean compareRuntimeDetails(BasicWrapper wrapper) {
            if (wrapper instanceof RuntimeInfoWrapper) {
                RuntimeInfoWrapper runtimeWrapper = (RuntimeInfoWrapper)wrapper;
                return this.equals(runtimeWrapper) && runtimeWrapper.getInstancesCount().intValue() == this.instancesCount.intValue() && runtimeWrapper.getTemplatesCount().intValue() == this.templatesCount.intValue();
            }
            return false;
        }
    }

    private class DeleteClassActionListener
    implements ActionListener {
        private DeleteClassActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AdminUIThreadPool.getThreadPool().submit(new Runnable(){

                @Override
                public void run() {
                    SpaceRuntimePanel.this.deleteRow();
                }
            });
        }
    }

    private class ClearClassActionListener
    implements ActionListener {
        private ClearClassActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AdminUIThreadPool.getThreadPool().submit(new Runnable(){

                @Override
                public void run() {
                    SpaceRuntimePanel.this.clearRow();
                }
            });
        }
    }

    private class QueryActionListener
    implements ActionListener {
        private QueryActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AdminUIThreadPool.getThreadPool().submit(new Runnable(){

                @Override
                public void run() {
                    SpaceRuntimePanel.this.queryRow();
                }
            });
        }
    }

    class RuntimeTableModel
    extends BasicSortableTableModel
    implements ISearchComponent {
        protected List<RuntimeInfoWrapper> runtimeInfoList = Collections.synchronizedList(new ArrayList());
        private String _searchedText = "";

        RuntimeTableModel() {
        }

        @Override
        public void clear() {
            int listSize = this.getRowCount();
            super.clear();
            this.runtimeInfoList.clear();
            if (listSize > 0) {
                this.fireTableRowsDeleted(0, listSize - 1);
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public void addRuntimeInfoWrapper(RuntimeInfoWrapper runtimeInfoWrapper) {
            this.runtimeInfoList.add(runtimeInfoWrapper);
            super.addWrapper(runtimeInfoWrapper);
        }

        @Override
        public void removeRow(int rowNum) {
            RuntimeInfoWrapper removedRuntimeInfoWrapper = (RuntimeInfoWrapper)this.removeWrapperAt(rowNum);
            this.runtimeInfoList.remove(removedRuntimeInfoWrapper);
        }

        @Override
        public void search(String searchedText) {
            this._searchedText = searchedText;
            this.filterList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void filterList() {
            int selRow = SpaceRuntimePanel.this.table.getSelectedRow();
            RuntimeInfoWrapper selRuntimeInfoWrapper = null;
            if (selRow >= 0) {
                selRuntimeInfoWrapper = (RuntimeInfoWrapper)this.getWrapperAt(selRow);
            }
            if (this._searchedText.length() == 0) {
                for (RuntimeInfoWrapper runtimeInfoWrapper : this.runtimeInfoList) {
                    if (this.containsWrapper(runtimeInfoWrapper)) continue;
                    this.addWrapper(runtimeInfoWrapper);
                    int index = this.getWrapperIndex(runtimeInfoWrapper);
                    this.fireTableRowsInserted(index, index);
                }
                int filteredListSize = this.getRowCount();
                for (int index = filteredListSize - 1; index >= 0; --index) {
                    if (this.runtimeInfoList.contains(this.getWrapperAt(index))) continue;
                    this.removeWrapperAt(index);
                    this.fireTableRowsDeleted(index, index);
                }
            } else {
                int filteredListSize = this.getRowCount();
                for (int index = filteredListSize - 1; index >= 0; --index) {
                    RuntimeInfoWrapper runtimeInfoWrapper = (RuntimeInfoWrapper)this.getWrapperAt(index);
                    if (this.isDisplayRuntimeClassInfo(runtimeInfoWrapper) && this.runtimeInfoList.contains(runtimeInfoWrapper)) continue;
                    this.removeWrapper(runtimeInfoWrapper);
                    this.fireTableRowsDeleted(index, index);
                }
                List<RuntimeInfoWrapper> list = this.runtimeInfoList;
                synchronized (list) {
                    for (RuntimeInfoWrapper runtimeInfoWrapper : this.runtimeInfoList) {
                        if (!this.isDisplayRuntimeClassInfo(runtimeInfoWrapper) || this.containsWrapper(runtimeInfoWrapper)) continue;
                        this.addWrapper(runtimeInfoWrapper);
                        int index = this.getWrapperIndex(runtimeInfoWrapper);
                        this.fireTableRowsInserted(index, index);
                    }
                }
            }
            if (selRuntimeInfoWrapper != null) {
                this.selectWrapper(selRuntimeInfoWrapper);
            }
            SpaceRuntimePanel.this.refreshClassesAndTemplatesTables();
        }

        private boolean isDisplayRuntimeClassInfo(RuntimeInfoWrapper runtimeInfoWrapper) {
            return runtimeInfoWrapper.getClassName().toUpperCase().indexOf(this._searchedText.toUpperCase()) >= 0;
        }

        private void selectWrapper(RuntimeInfoWrapper selRuntimeInfoWrapper) {
            int selIndex;
            if (selRuntimeInfoWrapper != null && (selIndex = this.getWrapperIndex(selRuntimeInfoWrapper)) >= 0) {
                SpaceRuntimePanel.this.table.setRowSelectionInterval(selIndex, selIndex);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpaceRuntimePanel.this.table.scrollRectToVisible(SpaceRuntimePanel.this.table.getCellRect(selIndex, -1, true));
                    }
                });
            }
        }

        @Override
        protected int compareWrappers(BasicWrapper wrapper1, BasicWrapper wrapper2, int colIndex, boolean ascending) {
            RuntimeInfoWrapper runtimeWrapper1 = (RuntimeInfoWrapper)wrapper1;
            RuntimeInfoWrapper runtimeWrapper2 = (RuntimeInfoWrapper)wrapper2;
            switch (colIndex) {
                case 0: {
                    String className1 = runtimeWrapper1.getClassName();
                    String className2 = runtimeWrapper2.getClassName();
                    if (ascending) {
                        return className1.compareToIgnoreCase(className2);
                    }
                    return className2.compareToIgnoreCase(className1);
                }
                case 1: {
                    int instancesCount1 = runtimeWrapper1.getInstancesCount();
                    int instancesCount2 = runtimeWrapper2.getInstancesCount();
                    if (ascending) {
                        return instancesCount1 < instancesCount2 ? -1 : (instancesCount1 == instancesCount2 ? 0 : 1);
                    }
                    return instancesCount2 < instancesCount1 ? -1 : (instancesCount2 == instancesCount1 ? 0 : 1);
                }
                case 2: {
                    int templatesCount1 = runtimeWrapper1.getTemplatesCount();
                    int templatesCount2 = runtimeWrapper2.getTemplatesCount();
                    if (ascending) {
                        return templatesCount1 < templatesCount2 ? -1 : (templatesCount1 == templatesCount2 ? 0 : 1);
                    }
                    return templatesCount2 < templatesCount1 ? -1 : (templatesCount2 == templatesCount1 ? 0 : 1);
                }
            }
            return 0;
        }

        @Override
        public Object getCellValue(BasicWrapper basicWrapper, int column) {
            RuntimeInfoWrapper runtimeInforWrapper = (RuntimeInfoWrapper)basicWrapper;
            switch (column) {
                case 0: {
                    return runtimeInforWrapper.getClassName();
                }
                case 1: {
                    return runtimeInforWrapper.getInstancesCount();
                }
                case 2: {
                    return runtimeInforWrapper.getTemplatesCount();
                }
            }
            return "";
        }

        @Override
        protected void initColumnNames() {
            this.columnNames = JSpaceUIUtils.getResources(SpaceRuntimePanel.DIALOG_RUNTIME_COLUMN);
        }
    }
}

