/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.grid.space.ISearchComponent;
import com.gigaspaces.admin.ui.grid.space.SearchEditor;
import com.gigaspaces.admin.ui.grid.space.SpaceMonitorTransactionsPanel;
import com.gigaspaces.admin.ui.views.utils.BasicSortableTableModel;
import com.gigaspaces.admin.ui.views.utils.BasicTable;
import com.gigaspaces.admin.ui.views.utils.BasicWrapper;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.IInternalRemoteJSpaceAdmin;
import com.j_spaces.core.client.TransactionInfo;
import com.j_spaces.core.client.UnderTxnLockedObject;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.IRefreshable;
import com.j_spaces.tools.spacebrowser.LockedObjectsViewPanel;
import com.j_spaces.tools.spacebrowser.utils.InstancesInfoBox;
import com.j_spaces.tools.spacebrowser.utils.RefreshPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;

public class SpaceTransactionsPanel
extends JPanel {
    protected BasicTable _transactionsTable;
    protected TransactionsTableModel _transactionsTableModel;
    protected static final int CI_TRANSACTION_ID = 0;
    protected static final int CI_TRANSACTION_TYPE = 1;
    protected static final int CI_TRANSACTION_STATUS = 2;
    protected static final int CI_TRANSACTION_START_TIME = 3;
    protected static final int CI_TRANSACTION_END_TIME = 4;
    protected static final int CI_NUMBER_OF_LOCKED_OBJECTS = 5;
    private LockedObjectsViewPanel _lockedObjectsViewPanel;
    protected IJSpace curSpaceProxy;
    protected RefreshPanel refreshPanel;
    private IInternalRemoteJSpaceAdmin spaceAdmin;
    protected InstancesInfoBox _infoBox;
    private JFrame _parentFrame;
    private SearchEditor _searchEditor;
    protected static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui.spacebrowser");

    public SpaceTransactionsPanel(JFrame parentFrame) {
        this._parentFrame = parentFrame;
        this.init();
    }

    public void setInvokeRefresh(boolean isRefresh) {
        this._transactionsTableModel.setInvokeRefresh(isRefresh);
    }

    public void setSpace(IJSpace spaceProxy) {
        block2: {
            this.curSpaceProxy = spaceProxy;
            this._lockedObjectsViewPanel.clear();
            try {
                this.spaceAdmin = (IInternalRemoteJSpaceAdmin)Repository.addSpaceAdminObjectToMap(spaceProxy);
            }
            catch (RemoteException re) {
                if (!_logger.isLoggable(Level.SEVERE)) break block2;
                _logger.log(Level.SEVERE, re.toString(), re);
            }
        }
        this._transactionsTableModel.refresh();
    }

    protected void initTableModel() {
        this._transactionsTableModel = new TransactionsTableModel();
    }

    private void init() {
        this.setBorder(new TitledBorder("Active Transactions"));
        this.initTableModel();
        this._transactionsTable = new BasicTable(this._transactionsTableModel);
        this._searchEditor = new SearchEditor(this._transactionsTableModel);
        JPanel topPanel = new JPanel(new BorderLayout());
        JScrollPane tableScrollPane = new JScrollPane(this._transactionsTable);
        tableScrollPane.setPreferredSize(new Dimension(500, 300));
        JTableHeader header = this._transactionsTable.getTableHeader();
        header.setReorderingAllowed(false);
        this._transactionsTable.setAutoCreateColumnsFromModel(false);
        this._transactionsTable.setSelectionMode(0);
        this._transactionsTable.setAutoResizeMode(1);
        this._transactionsTable.setAutoscrolls(true);
        this.refreshPanel = new RefreshPanel(this._transactionsTableModel, false);
        this._lockedObjectsViewPanel = new LockedObjectsViewPanel(this._parentFrame);
        this._infoBox = new InstancesInfoBox("transaction");
        this.setLayout(new BorderLayout());
        Box searchBox = new Box(0);
        searchBox.add(Box.createHorizontalGlue());
        searchBox.add(this._searchEditor);
        searchBox.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        Box northBox = new Box(0);
        northBox.add(this.refreshPanel);
        northBox.add(searchBox);
        topPanel.add((Component)northBox, "North");
        topPanel.add((Component)tableScrollPane, "Center");
        topPanel.add((Component)this._infoBox, "South");
        JSplitPane splitPane = new JSplitPane(0, topPanel, this._lockedObjectsViewPanel);
        splitPane.setDividerLocation(0.6);
        this.add((Component)splitPane, "Center");
        this.addSelectionListenerToTable();
    }

    private void addSelectionListenerToTable() {
        ListSelectionModel tableRowSelModel = this._transactionsTable.getSelectionModel();
        tableRowSelModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (!lsm.isSelectionEmpty()) {
                    int selRow = e.getFirstIndex();
                    TransactionInfo selectedTransactionInfo = ((TransactionWrapper)SpaceTransactionsPanel.this._transactionsTableModel.getWrapperAt(selRow)).getTransactionInfo();
                    SpaceTransactionsPanel.this.updateLockedObjectsView(selectedTransactionInfo);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int updateLockedObjectsView(TransactionInfo transactionInfo) {
        if (transactionInfo != null) {
            try {
                this._parentFrame.setCursor(Cursor.getPredefinedCursor(3));
                List<UnderTxnLockedObject> lockedObjectList = this.retrieveLockedObjects(transactionInfo);
                this._lockedObjectsViewPanel.displayLockedObjects(this.curSpaceProxy, lockedObjectList, transactionInfo);
                int n = lockedObjectList.size();
                return n;
            }
            catch (RemoteException exc) {
                _logger.log(Level.SEVERE, exc.toString(), exc);
            }
            finally {
                this._parentFrame.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        return -1;
    }

    protected List<UnderTxnLockedObject> retrieveLockedObjects(TransactionInfo transactionInfo) throws RemoteException {
        return this.spaceAdmin.getLockedObjects(transactionInfo.getTrasaction());
    }

    protected class TransactionsTableModel
    extends BasicSortableTableModel
    implements ISearchComponent,
    IRefreshable {
        protected final String CN_TRANSACTION_ID = "ID";
        protected final String CN_TRANSACTION_TYPE = "Type";
        protected final String CN_TRANSACTION_STATUS = "Status";
        protected final String CN_TRANSACTION_START_TIME = "Start Time";
        protected final String CN_TRANSACTION_END_TIME = "End Time";
        protected final String CN_TRANSACTION_LOCKED_OBJECTS = "Locked Objects";
        protected String[] columnNames;
        protected List<TransactionWrapper> _transactionWrappersList = new ArrayList<TransactionWrapper>();
        protected DateFormat df = DateFormat.getDateTimeInstance(2, 2);
        protected boolean _isInvokeRefresh = true;
        protected String _searchedText = "";

        public TransactionsTableModel() {
            this.initColumnNames();
        }

        @Override
        protected void initColumnNames() {
            this.columnNames = new String[6];
            this.columnNames[0] = "ID";
            this.columnNames[1] = "Type";
            this.columnNames[2] = "Status";
            this.columnNames[3] = "Start Time";
            this.columnNames[4] = "End Time";
            this.columnNames[5] = "Locked Objects";
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public Class getColumnClass(int columnIndex) {
            Object obj = this.getValueAt(0, columnIndex);
            if (obj != null) {
                return obj.getClass();
            }
            return null;
        }

        @Override
        public void setInvokeRefresh(boolean invokeRefresh) {
            this._isInvokeRefresh = invokeRefresh;
        }

        @Override
        public void refresh() {
            if (this._isInvokeRefresh && SpaceTransactionsPanel.this.spaceAdmin != null) {
                int selRow = SpaceTransactionsPanel.this._transactionsTable.getSelectedRow();
                TransactionWrapper selTransactionWrapper = null;
                if (selRow >= 0) {
                    selTransactionWrapper = (TransactionWrapper)SpaceTransactionsPanel.this._transactionsTableModel.getWrapperAt(selRow);
                }
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "@@@ Refresh Space Transactions Table. ");
                }
                TransactionInfo[] transactionInfoArray = null;
                try {
                    transactionInfoArray = SpaceTransactionsPanel.this.spaceAdmin.getTransactionsInfo(0, 1);
                }
                catch (RemoteException e) {
                    _logger.log(Level.FINE, e.toString(), e);
                    SpaceTransactionsPanel.this.refreshPanel.stopStatusRuntime();
                }
                catch (Exception e) {
                    _logger.log(Level.SEVERE, e.toString(), e);
                    SpaceTransactionsPanel.this.refreshPanel.stopStatusRuntime();
                }
                if (transactionInfoArray == null) {
                    transactionInfoArray = new TransactionInfo[]{};
                }
                ArrayList<TransactionWrapper> newTransactionInfoList = new ArrayList<TransactionWrapper>(transactionInfoArray.length);
                for (TransactionInfo newTransactionInfo : transactionInfoArray) {
                    newTransactionInfoList.add(new TransactionWrapper(newTransactionInfo));
                }
                this.handleCurrentTransactionsList(newTransactionInfoList, selTransactionWrapper);
            }
            SpaceTransactionsPanel.this._infoBox.setCount(SpaceTransactionsPanel.this._transactionsTableModel.getRowCount());
        }

        protected void handleCurrentTransactionsList(List<TransactionWrapper> newTransactionWrapperList, TransactionWrapper selTransactionWrapper) {
            int index;
            TransactionInfo selTransactionInfo;
            int curLockedObjectAmount;
            int curListSize = this._transactionWrappersList.size();
            boolean isTableModelChanged = false;
            boolean isTableModelUpdated = false;
            for (int listIndex = curListSize - 1; listIndex >= 0; --listIndex) {
                TransactionWrapper transactionWrapper = this._transactionWrappersList.get(listIndex);
                if (newTransactionWrapperList.indexOf(transactionWrapper) < 0) {
                    Object removedTransactionID = transactionWrapper.getTxnId();
                    this._transactionWrappersList.remove(transactionWrapper);
                    if (SpaceTransactionsPanel.this._lockedObjectsViewPanel.getSelectedTransactionID() != null && SpaceTransactionsPanel.this._lockedObjectsViewPanel.getSelectedTransactionID().equals(removedTransactionID)) {
                        SpaceTransactionsPanel.this._lockedObjectsViewPanel.clear();
                    }
                    isTableModelChanged = true;
                    continue;
                }
                TransactionWrapper updateTransactionWrapper = newTransactionWrapperList.get(newTransactionWrapperList.indexOf(transactionWrapper));
                this._transactionWrappersList.set(listIndex, updateTransactionWrapper);
                isTableModelUpdated = true;
            }
            int listSize = newTransactionWrapperList.size();
            for (int listIndex = listSize - 1; listIndex >= 0; --listIndex) {
                TransactionWrapper newTransactionWrapper = newTransactionWrapperList.get(listIndex);
                if (this._transactionWrappersList.contains(newTransactionWrapper)) continue;
                this._transactionWrappersList.add(newTransactionWrapper);
                isTableModelChanged = true;
            }
            if (selTransactionWrapper != null && (curLockedObjectAmount = SpaceTransactionsPanel.this.updateLockedObjectsView(selTransactionInfo = selTransactionWrapper.getTransactionInfo())) != selTransactionInfo.getNumberOfLockedObjects() && (index = this._transactionWrappersList.indexOf(selTransactionWrapper)) >= 0) {
                TransactionInfo transactionInfo = this.createTransactionInfo(selTransactionInfo, curLockedObjectAmount);
                TransactionWrapper transactionWrapper = new TransactionWrapper(transactionInfo);
                this._transactionWrappersList.set(index, transactionWrapper);
            }
            if (isTableModelChanged || isTableModelUpdated) {
                this.filterList(isTableModelUpdated);
            }
            this.selectWrapper(selTransactionWrapper);
            if (listSize == 0) {
                SpaceTransactionsPanel.this._lockedObjectsViewPanel.clear();
            }
        }

        protected TransactionInfo createTransactionInfo(TransactionInfo transactionInfo, int numberOfLockedObjects) {
            return new TransactionInfo(transactionInfo.getType(), transactionInfo.getStatus(), transactionInfo.getTrasaction(), transactionInfo.getLease(), transactionInfo.getStartTime(), numberOfLockedObjects);
        }

        @Override
        public void search(String searchedText) {
            this._searchedText = searchedText;
            this.filterList(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void filterList(boolean isTableModelUpdated) {
            int selRow = SpaceTransactionsPanel.this._transactionsTable.getSelectedRow();
            TransactionWrapper selTransactionWrapper = null;
            if (selRow >= 0) {
                selTransactionWrapper = (TransactionWrapper)this.getWrapperAt(selRow);
            }
            if (this._searchedText.length() == 0) {
                for (TransactionWrapper transactionWrapper : this._transactionWrappersList) {
                    if (!this.containsWrapper(transactionWrapper)) {
                        this.addWrapper(transactionWrapper);
                        continue;
                    }
                    if (!isTableModelUpdated) continue;
                    int index = this.getWrapperIndex(transactionWrapper);
                    this.setWrapperAt(transactionWrapper, index);
                }
                int filteredListSize = this.getRowCount();
                for (int index = filteredListSize - 1; index >= 0; --index) {
                    if (this._transactionWrappersList.contains(this.getWrapperAt(index))) continue;
                    this.removeWrapperAt(index);
                }
            } else {
                int filteredListSize = this.getRowCount();
                for (int index = filteredListSize - 1; index >= 0; --index) {
                    TransactionWrapper transactionWrapper = (TransactionWrapper)this.getWrapperAt(index);
                    if (this.isDisplayTransaction(transactionWrapper.getTransactionInfo()) && this._transactionWrappersList.contains(transactionWrapper)) continue;
                    this.removeWrapper(transactionWrapper);
                }
                List<TransactionWrapper> list = this._transactionWrappersList;
                synchronized (list) {
                    for (TransactionWrapper transactionWrapper : this._transactionWrappersList) {
                        int index;
                        if (!this.isDisplayTransaction(transactionWrapper.getTransactionInfo())) continue;
                        if (!this.containsWrapper(transactionWrapper)) {
                            this.addWrapper(transactionWrapper);
                            index = this.getWrapperIndex(transactionWrapper);
                            this.fireTableRowsInserted(index, index);
                            continue;
                        }
                        if (!isTableModelUpdated) continue;
                        index = this.getWrapperIndex(transactionWrapper);
                        this.setWrapperAt(transactionWrapper, index);
                    }
                }
            }
            if (selTransactionWrapper != null) {
                this.selectWrapper(selTransactionWrapper);
            }
        }

        private void selectWrapper(TransactionWrapper selTransactionWrapper) {
            int selIndex;
            if (selTransactionWrapper != null && (selIndex = SpaceTransactionsPanel.this._transactionsTableModel.getWrapperIndex(selTransactionWrapper)) >= 0) {
                SpaceTransactionsPanel.this._transactionsTable.setRowSelectionInterval(selIndex, selIndex);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpaceTransactionsPanel.this._transactionsTable.scrollRectToVisible(SpaceTransactionsPanel.this._transactionsTable.getCellRect(selIndex, -1, true));
                    }
                });
            }
        }

        protected boolean isDisplayTransaction(TransactionInfo transactionInfo) {
            return SpaceMonitorTransactionsPanel.getTransactionTypeName(transactionInfo.getType()).toUpperCase().contains(this._searchedText.toUpperCase()) || SpaceMonitorTransactionsPanel.getTransactionStatusName(transactionInfo.getStatus()).toUpperCase().startsWith(this._searchedText.toUpperCase()) || String.valueOf(transactionInfo.getTxnId()).toUpperCase().startsWith(this._searchedText.toUpperCase());
        }

        @Override
        public boolean isRunning() {
            return !SpaceTransactionsPanel.this.refreshPanel.isStop();
        }

        @Override
        public void start() {
        }

        @Override
        public void stop() {
        }

        @Override
        public Object getCellValue(BasicWrapper basicWrapper, int column) {
            TransactionInfo transactionInfo = ((TransactionWrapper)basicWrapper).getTransactionInfo();
            switch (column) {
                case 1: {
                    return JSpaceUtilities.getTransactionTypeName((int)transactionInfo.getType());
                }
                case 2: {
                    return JSpaceUtilities.getTransactionStatusName((int)transactionInfo.getStatus());
                }
                case 5: {
                    return String.valueOf(transactionInfo.getNumberOfLockedObjects());
                }
                case 0: {
                    return String.valueOf(transactionInfo.getTxnId());
                }
                case 4: {
                    long lease = transactionInfo.getLease();
                    if (lease < 0L) {
                        return " - ";
                    }
                    return this.df.format(new Date(System.currentTimeMillis() + lease));
                }
                case 3: {
                    return this.df.format(new Date(transactionInfo.getStartTime()));
                }
            }
            return "";
        }

        @Override
        protected int compareWrappers(BasicWrapper wrapper1, BasicWrapper wrapper2, int colIndex, boolean ascending) {
            TransactionWrapper transactionWrapper1 = (TransactionWrapper)wrapper1;
            TransactionWrapper transactionWrapper2 = (TransactionWrapper)wrapper2;
            switch (colIndex) {
                case 0: {
                    Object txnId1 = transactionWrapper1.getTxnId();
                    Object txnId2 = transactionWrapper2.getTxnId();
                    if (txnId1 instanceof Comparable && txnId2 instanceof Comparable) {
                        if (ascending) {
                            return ((Comparable)txnId1).compareTo(txnId2);
                        }
                        return ((Comparable)txnId2).compareTo(txnId1);
                    }
                }
                case 5: {
                    int lockedObjects1 = transactionWrapper1.getTransactionInfo().getNumberOfLockedObjects();
                    int lockedObjects2 = transactionWrapper2.getTransactionInfo().getNumberOfLockedObjects();
                    if (ascending) {
                        return lockedObjects1 < lockedObjects2 ? -1 : (lockedObjects1 == lockedObjects2 ? 0 : 1);
                    }
                    return lockedObjects2 < lockedObjects1 ? -1 : (lockedObjects2 == lockedObjects1 ? 0 : 1);
                }
                case 3: {
                    long startTime1 = transactionWrapper1.getTransactionInfo().getStartTime();
                    long startTime2 = transactionWrapper2.getTransactionInfo().getStartTime();
                    if (ascending) {
                        return startTime1 < startTime2 ? -1 : (startTime1 == startTime2 ? 0 : 1);
                    }
                    return startTime2 < startTime1 ? -1 : (startTime2 == startTime1 ? 0 : 1);
                }
                case 4: {
                    long endTime2;
                    long endTime1 = transactionWrapper1.getTransactionInfo().getLease() < 0L ? -1L : System.currentTimeMillis() + transactionWrapper1.getTransactionInfo().getLease();
                    long l = endTime2 = transactionWrapper2.getTransactionInfo().getLease() < 0L ? -1L : System.currentTimeMillis() + transactionWrapper2.getTransactionInfo().getLease();
                    if (ascending) {
                        return endTime1 < endTime2 ? -1 : (endTime1 == endTime2 ? 0 : 1);
                    }
                    return endTime2 < endTime1 ? -1 : (endTime2 == endTime1 ? 0 : 1);
                }
                case 2: {
                    int status1 = transactionWrapper1.getTransactionInfo().getStatus();
                    int status2 = transactionWrapper2.getTransactionInfo().getStatus();
                    if (ascending) {
                        return status1 < status2 ? -1 : (status1 == status2 ? 0 : 1);
                    }
                    return status2 < status1 ? -1 : (status2 == status1 ? 0 : 1);
                }
                case 1: {
                    int type1 = transactionWrapper1.getTransactionInfo().getType();
                    int type2 = transactionWrapper2.getTransactionInfo().getType();
                    if (ascending) {
                        return type1 < type2 ? -1 : (type1 == type2 ? 0 : 1);
                    }
                    return type2 < type1 ? -1 : (type2 == type1 ? 0 : 1);
                }
            }
            return 0;
        }
    }

    class TransactionWrapper
    extends BasicWrapper {
        private final TransactionInfo _transactionInfo;
        private Object _txnId;

        public TransactionWrapper(TransactionInfo transactionInfo) {
            this._transactionInfo = transactionInfo;
            this._txnId = this._transactionInfo.getTxnId();
        }

        public TransactionInfo getTransactionInfo() {
            return this._transactionInfo;
        }

        public Object getTxnId() {
            return this._txnId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this._transactionInfo == null ? 0 : this._transactionInfo.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TransactionWrapper other = (TransactionWrapper)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this._transactionInfo == null ? other._transactionInfo != null : !this._transactionInfo.equals((Object)other._transactionInfo));
        }

        @Override
        public boolean compareRuntimeDetails(BasicWrapper wrapper) {
            TransactionWrapper transactionWrapper = (TransactionWrapper)wrapper;
            return this._transactionInfo.getLease() == transactionWrapper.getTransactionInfo().getLease() && this._transactionInfo.getNumberOfLockedObjects() == transactionWrapper.getTransactionInfo().getNumberOfLockedObjects() && this._transactionInfo.getTxnId().equals(transactionWrapper.getTransactionInfo().getTxnId());
        }

        private SpaceTransactionsPanel getOuterType() {
            return SpaceTransactionsPanel.this;
        }
    }
}

