/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.gigaspaces.admin.ui.grid.IConnectionProvider;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.JSpaceProxyWrapper;
import com.j_spaces.jdbc.driver.GDriver;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import java.sql.Driver;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.isqlviewer.sql.DatabaseConnection;

public class SpaceTreeNode
extends JSpaceProxyWrapper
implements IConnectionProvider {
    private static int spaceCounter = 0;
    private int spaceID = spaceCounter++;
    private Integer spaceObjectID;
    private IJSpace _proxy;
    private DatabaseConnection _dbConnect;
    private boolean _isSecured;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui.spacebrowser");

    public SpaceTreeNode(IJSpace proxy) {
        super(proxy);
        this._proxy = proxy;
        this.spaceObjectID = new Integer(this.spaceID);
        this._isSecured = this._proxy.isSecured();
    }

    @Override
    public synchronized DatabaseConnection getConnection() {
        if (this._dbConnect == null) {
            try {
                Properties props = JSpaceUIUtils.createSecuredContextProperties();
                this._dbConnect = new DatabaseConnection((Driver)new GDriver(), props, this._proxy);
                this._dbConnect.gsConnect();
            }
            catch (Exception ex) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, "Exception in method getConnection() of SpaceTreeNode class:" + JSpaceUtilities.LINE_SEPARATOR + ex.toString(), ex);
                }
                SpaceBrowser.showException(ex.toString(), ex);
            }
        }
        return this._dbConnect;
    }

    public IJSpace getSpaceProxy() {
        return (IJSpace)this.proxy();
    }

    public int getSpaceID() {
        return this.spaceID;
    }

    public Object getSpaceObjectID() {
        return this.spaceObjectID;
    }

    public boolean isSecured() {
        return this._isSecured;
    }
}

