/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.cluster.activeelection.ElectionInProcessException;
import com.gigaspaces.cluster.activeelection.InactiveSpaceException;
import com.gigaspaces.cluster.activeelection.SpaceMode;
import com.gigaspaces.cluster.replication.async.mirror.MirrorStatistics;
import com.gigaspaces.grid.zone.GridZoneProvider;
import com.gigaspaces.internal.jmx.JMXUtilities;
import com.gigaspaces.internal.jvm.JVMInfoProvider;
import com.gigaspaces.internal.jvm.JVMStatistics;
import com.gigaspaces.management.client.MBeanServerConnectionFactory;
import com.gigaspaces.security.authorities.MonitorAuthority;
import com.gigaspaces.security.authorities.Privilege;
import com.gigaspaces.security.service.SecuredService;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.ContainerConfig;
import com.j_spaces.core.admin.IInternalRemoteJSpaceAdmin;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.admin.SpaceRuntimeInfo;
import com.j_spaces.core.admin.StatisticsAdmin;
import com.j_spaces.core.exception.SpaceConfigurationException;
import com.j_spaces.core.exception.SpaceStoppedException;
import com.j_spaces.core.exception.SpaceUnavailableException;
import com.j_spaces.core.filters.ReplicationStatistics;
import com.j_spaces.core.filters.StatisticsContext;
import com.j_spaces.core.filters.StatisticsHolder;
import com.j_spaces.kernel.IConsumerObject;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.kernel.WorkingGroup;
import com.j_spaces.tools.IRefreshable;
import com.j_spaces.tools.PrimaryBackupIndicationListener;
import com.j_spaces.tools.spacebrowser.CustomizeViewDialog;
import com.j_spaces.tools.spacebrowser.ISpacesView;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.statistics.space_operations.ISpaceStatistics;
import com.j_spaces.tools.spacebrowser.utils.InstancesInfoBox;
import com.j_spaces.tools.spacebrowser.utils.JConsoleUIUtils;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import com.j_spaces.tools.spacebrowser.utils.RefreshPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.jini.core.lookup.ServiceID;

public class SpacesViewPanel
extends JPanel
implements ActionListener,
IRefreshable {
    private JFrame _parentFrame;
    protected final SpacesViewTableModel _spacesViewTableModel;
    private final SpacesViewTable _spacesViewTable;
    private final JTableHeader _tableHeader;
    private static final String YES_VAL = "Yes";
    private static final String NO_VAL = "No";
    private static final String COUNT_BLANK_VALUE = "-";
    private JPopupMenu spaceManagementPopupMenu;
    private JMenuItem classesMenuItem;
    private JMenuItem transactionsMenuItem;
    private JMenuItem queryMenuItem;
    private JMenuItem statisticsMenuItem;
    private JMenuItem connectionsMenuItem;
    private JMenuItem benchmarkMenuItem;
    private JMenuItem launchJConsoleMenuItem;
    private JMenuItem launchJVisualVmMenuItem;
    private JMenuItem selMemberNameMenuItem;
    private JPopupMenu tableHeaderPopupMenu;
    private JMenuItem _selectColumnsMenuItem;
    private RefreshPanel refreshPanel;
    private ColumnSortListener _columnSortListener;
    private WorkingGroup<SpaceViewWrapper> _workingGroup;
    private InstancesInfoBox _infoBox;
    private CustomizeViewDialog _customizeViewDialog;
    private List<String> _selColumnNames;
    private boolean _isInvokeRefresh;
    private boolean _isCalculateObjectsCount;
    private boolean _isCalculateTemplatesCount;
    private boolean _isCalculateZones;
    private boolean _isCalculateStatistics;
    private boolean _isCalculateMemoryUsage;
    private boolean _isCalculateCPUUsage;
    private boolean _isCalculateSuspendInfo;
    private String _calculatedJavaHome;
    private static String _jvmVersion = System.getProperty("java.version");
    private static String JMX_USAGE_WITH_JDK_1_4 = "N/A - JDK 1.4";
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui.spacebrowser");
    private static NumberFormat nf = new DecimalFormat();
    private static DecimalFormat nfForCPU;

    public SpacesViewPanel(JFrame parentFrame) {
        this(parentFrame, true);
    }

    public SpacesViewPanel(JFrame parentFrame, boolean isStartRefreshImmediately) {
        this._parentFrame = parentFrame;
        this.setLayout(new BorderLayout());
        this._spacesViewTableModel = new SpacesViewTableModel(this);
        this._spacesViewTable = new SpacesViewTable(this._spacesViewTableModel);
        this.refreshPanel = new RefreshPanel(this, isStartRefreshImmediately);
        this.refreshPanel.setSelectedRefreshRate(5000);
        JScrollPane tableScrollPane = new JScrollPane(this._spacesViewTable);
        this._infoBox = new InstancesInfoBox("space");
        tableScrollPane.setPreferredSize(new Dimension(500, 400));
        this.add((Component)this.refreshPanel, "North");
        this.add((Component)tableScrollPane, "Center");
        this.add((Component)this._infoBox, "South");
        this._columnSortListener = new ColumnSortListener(this._spacesViewTable, this._spacesViewTableModel);
        this._tableHeader = new CustomizeTableHeader(this._spacesViewTable.getColumnModel());
        this._spacesViewTable.setTableHeader(this._tableHeader);
        this._tableHeader.addMouseListener(this._columnSortListener);
        this._tableHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    SpacesViewPanel.this.tableHeaderPopupMenu.show(SpacesViewPanel.this._tableHeader, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this._tableHeader.setReorderingAllowed(false);
        this._spacesViewTable.setAutoCreateColumnsFromModel(true);
        this._spacesViewTable.setSelectionMode(0);
        this._spacesViewTable.setAutoResizeMode(1);
        this._spacesViewTable.setAutoscrolls(true);
        this.addMouseListenerToTable();
        this.createPopupMenus();
        this._workingGroup = new WorkingGroup((IConsumerObject)new ReloadRuntimeConsumer(), 5, "UI-ReloadRuntimeInfo - Spaces Network View ", 1, 20, 15000L);
        this._workingGroup.start();
    }

    protected void defineColumnWidthAndRenderers() {
        TableColumnModel columnModel = this._tableHeader.getColumnModel();
        int minWidth = 65;
        if (SpacesViewTableModel.CI_SPACE_ICON >= 0) {
            TableColumn spaceIconColumn = columnModel.getColumn(SpacesViewTableModel.CI_SPACE_ICON);
            spaceIconColumn.setPreferredWidth(35);
            spaceIconColumn.setWidth(35);
            spaceIconColumn.setMaxWidth(35);
            spaceIconColumn.setCellRenderer(new SpaceIndicationColumnClassRenderer());
        }
        if (SpacesViewTableModel.CI_PERSISTENT >= 0) {
            TableColumn persistColumn = columnModel.getColumn(SpacesViewTableModel.CI_PERSISTENT);
            persistColumn.setPreferredWidth(minWidth);
            persistColumn.setWidth(minWidth);
        }
        if (SpacesViewTableModel.CI_CLUSTERED >= 0) {
            TableColumn clusteredColumn = columnModel.getColumn(SpacesViewTableModel.CI_CLUSTERED);
            clusteredColumn.setPreferredWidth(minWidth);
            clusteredColumn.setWidth(minWidth);
        }
        if (SpacesViewTableModel.CI_OBJECTS_COUNT >= 0) {
            TableColumn countColumn = columnModel.getColumn(SpacesViewTableModel.CI_OBJECTS_COUNT);
            countColumn.setPreferredWidth(85);
            countColumn.setWidth(85);
        }
        if (SpacesViewTableModel.CI_TEMPLATES_COUNT >= 0) {
            TableColumn templatesCountColumn = columnModel.getColumn(SpacesViewTableModel.CI_TEMPLATES_COUNT);
            templatesCountColumn.setPreferredWidth(90);
            templatesCountColumn.setWidth(90);
        }
        if (SpacesViewTableModel.CI_DELTA >= 0) {
            TableColumn deltaObjectsCountColumn = columnModel.getColumn(SpacesViewTableModel.CI_DELTA);
            deltaObjectsCountColumn.setPreferredWidth(80);
            deltaObjectsCountColumn.setWidth(80);
            deltaObjectsCountColumn.setCellRenderer(new DeltaColumnClassRenderer());
        }
        if (SpacesViewTableModel.CI_MEMORY_USAGE >= 0) {
            TableColumn memoryUsageColumn = columnModel.getColumn(SpacesViewTableModel.CI_MEMORY_USAGE);
            memoryUsageColumn.setCellRenderer(new MemoryColumnClassRenderer());
        }
        if (SpacesViewTableModel.CI_SUSPEND_TYPE >= 0) {
            TableColumn suspendTypeColumn = columnModel.getColumn(SpacesViewTableModel.CI_SUSPEND_TYPE);
            suspendTypeColumn.setPreferredWidth(95);
            suspendTypeColumn.setWidth(95);
        }
        if (SpacesViewTableModel.CI_PRIMARY_INDICATION >= 0) {
            TableColumn spaceModeColumn = columnModel.getColumn(SpacesViewTableModel.CI_PRIMARY_INDICATION);
            spaceModeColumn.setPreferredWidth(80);
            spaceModeColumn.setWidth(80);
        }
    }

    private void addMouseListenerToTable() {
        this._spacesViewTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    int selRow = SpacesViewPanel.this._spacesViewTable.getSelectedRow();
                    SpaceViewWrapper selSpaceViewWrapper = SpacesViewPanel.this._spacesViewTableModel.getWrapperAt(selRow);
                    ServiceID spaceID = selSpaceViewWrapper.getServiceID();
                    SpaceBrowser.getInstance().selectSpaceOperationNode(spaceID, null);
                }
            }

            @Override
            public void mousePressed(MouseEvent event) {
                if (SwingUtilities.isRightMouseButton(event)) {
                    int x = event.getX();
                    int y = event.getY();
                    int selRow = SpacesViewPanel.this._spacesViewTable.rowAtPoint(new Point(x, y));
                    SpacesViewPanel.this._spacesViewTable.setRowSelectionInterval(selRow, selRow);
                    if (selRow >= 0) {
                        SpaceViewWrapper spaceViewWrapper = SpacesViewPanel.this._spacesViewTableModel.getWrapperAt(selRow);
                        boolean hasMonitorJVMPermission = JSpaceUIUtils.isSpaceHasPermittedPermission(spaceViewWrapper.getServiceID(), spaceViewWrapper.isSecuredSpace(), (Privilege)MonitorAuthority.MonitorPrivilege.MONITOR_JVM);
                        SpacesViewPanel.this.launchJConsoleMenuItem.setEnabled(hasMonitorJVMPermission);
                        SpacesViewPanel.this.launchJVisualVmMenuItem.setEnabled(hasMonitorJVMPermission);
                        String contName = spaceViewWrapper.getContainerName();
                        String spaceName = spaceViewWrapper.getSpaceName();
                        SpacesViewPanel.this.selMemberNameMenuItem.setText(contName + ":" + spaceName);
                        SpacesViewPanel.this.spaceManagementPopupMenu.show(SpacesViewPanel.this._spacesViewTable, x, y);
                    }
                }
            }
        });
    }

    private void createPopupMenus() {
        this.tableHeaderPopupMenu = new JPopupMenu();
        this._selectColumnsMenuItem = new JMenuItem("Select Columns...");
        this.tableHeaderPopupMenu.add(this._selectColumnsMenuItem);
        this._selectColumnsMenuItem.addActionListener(new SelectColumnsAction());
        this.spaceManagementPopupMenu = new JPopupMenu();
        this.selMemberNameMenuItem = new JMenuItem();
        this.classesMenuItem = new JMenuItem("Data Types");
        this.transactionsMenuItem = new JMenuItem("Transactions");
        this.queryMenuItem = new JMenuItem("Query");
        this.statisticsMenuItem = new JMenuItem("Statistics");
        this.connectionsMenuItem = new JMenuItem("Connections");
        this.benchmarkMenuItem = new JMenuItem("Benchmark");
        this.launchJConsoleMenuItem = new JMenuItem("Launch JConsole...");
        this.launchJVisualVmMenuItem = new JMenuItem("Launch VisualVM...");
        Font curFont = this.selMemberNameMenuItem.getFont();
        this.selMemberNameMenuItem.setFont(curFont.deriveFont(1));
        this.selMemberNameMenuItem.addActionListener(this);
        this.classesMenuItem.addActionListener(this);
        this.queryMenuItem.addActionListener(this);
        this.transactionsMenuItem.addActionListener(this);
        this.statisticsMenuItem.addActionListener(this);
        this.connectionsMenuItem.addActionListener(this);
        this.benchmarkMenuItem.addActionListener(this);
        this.launchJConsoleMenuItem.addActionListener(this);
        this.launchJVisualVmMenuItem.addActionListener(this);
        this._calculatedJavaHome = JConsoleUIUtils.manageJConsoleMenuItem(this._parentFrame, this.launchJConsoleMenuItem, "", true, _logger, false, false, this._parentFrame);
        JConsoleUIUtils.manageJVisualVmMenuItem(this._parentFrame, this.launchJVisualVmMenuItem, "", _logger, false, false, this._parentFrame, false);
        JMenuItem selectColumnMenuItem = new JMenuItem(this._selectColumnsMenuItem.getText());
        selectColumnMenuItem.addActionListener(new SelectColumnsAction());
        this.spaceManagementPopupMenu.add(this.selMemberNameMenuItem);
        this.spaceManagementPopupMenu.addSeparator();
        this.spaceManagementPopupMenu.add(this.classesMenuItem);
        this.spaceManagementPopupMenu.add(this.transactionsMenuItem);
        this.spaceManagementPopupMenu.add(this.queryMenuItem);
        this.spaceManagementPopupMenu.add(this.statisticsMenuItem);
        this.spaceManagementPopupMenu.add(this.connectionsMenuItem);
        this.spaceManagementPopupMenu.add(this.benchmarkMenuItem);
        this.spaceManagementPopupMenu.add(this.launchJConsoleMenuItem);
        this.spaceManagementPopupMenu.add(this.launchJVisualVmMenuItem);
        this.spaceManagementPopupMenu.addSeparator();
        this.spaceManagementPopupMenu.add(selectColumnMenuItem);
    }

    private void showCustomizeViewDialog() {
        if (this._customizeViewDialog == null) {
            this._customizeViewDialog = new CustomizeViewDialog(this._parentFrame);
            this._customizeViewDialog.setLocationRelativeTo(this._parentFrame);
        }
        this._customizeViewDialog.initDialog(this._selColumnNames);
        this._customizeViewDialog.setVisible(true);
        if (this._customizeViewDialog.getSelectedNames() != null) {
            this.setColumnNames(this._customizeViewDialog.getSelectedNames());
        }
    }

    public void setColumnNames(List<String> selColumnNames) {
        int deltaIndex;
        if (selColumnNames == null) {
            selColumnNames = new ArrayList<String>(ISpacesView.DEFAULT_COLUMN_NAMES.length);
            for (String columnName : ISpacesView.DEFAULT_COLUMN_NAMES) {
                selColumnNames.add(columnName);
            }
        }
        if ((deltaIndex = selColumnNames.indexOf("\u0394 Objects Count Delta")) >= 0) {
            selColumnNames.set(deltaIndex, "\u0394");
        }
        this._selColumnNames = selColumnNames;
        this._isCalculateObjectsCount = selColumnNames.contains("Objects Count");
        this._isCalculateTemplatesCount = selColumnNames.contains("Templates Count");
        this._isCalculateZones = selColumnNames.contains("Zones");
        this._isCalculateStatistics = selColumnNames.contains("Write") || selColumnNames.contains("Update") || selColumnNames.contains("Read") || selColumnNames.contains("Take") || selColumnNames.contains("Notify Sent") || selColumnNames.contains("Notify Ack.") || selColumnNames.contains("Notify Registration") || selColumnNames.contains("Execute") || selColumnNames.contains("Replicat. Redo Log") || selColumnNames.contains("Repl. Packets Disk") || selColumnNames.contains("Repl. Packets Disk Usage (Bytes)") || selColumnNames.contains("Repl. Packets Mem.") || selColumnNames.contains("Mirror Total Operations") || selColumnNames.contains("Mirror Successful Operations") || selColumnNames.contains("Mirror In Progress Operations") || selColumnNames.contains("Mirror Failed Operations") || selColumnNames.contains("Mirror Discarded Operations");
        this._isCalculateMemoryUsage = selColumnNames.contains("Used Memory (MB)");
        this._isCalculateCPUUsage = selColumnNames.contains("Used CPU (%)");
        this._isCalculateSuspendInfo = selColumnNames.contains("Suspend Type");
        this._spacesViewTableModel.updateColumnNames(this._selColumnNames);
    }

    public String[] getColumnNames() {
        return this._spacesViewTableModel.getColumnNames();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        int selRow = this._spacesViewTable.getSelectedRow();
        SpaceViewWrapper spaceViewWrapper = this._spacesViewTableModel.getWrapperAt(selRow);
        if (source.equals(this.launchJConsoleMenuItem)) {
            String jndiURL = spaceViewWrapper.getJndiURL();
            String jmxServiceURL = JMXUtilities.createJMXUrl((String)jndiURL);
            String[] commandArray = JConsoleUIUtils.createJConsoleCommand(this._parentFrame, jmxServiceURL, this._calculatedJavaHome, true);
            this.runCommand(commandArray);
        } else if (source.equals(this.launchJVisualVmMenuItem)) {
            String jndiURL = spaceViewWrapper.getJndiURL();
            String jmxServiceURL = JMXUtilities.createJMXUrl((String)jndiURL);
            JConsoleUIUtils.VisualVmFileVerifierWrapper visualVmFileVerifierWrapper = JConsoleUIUtils.checkJVisualVMFile(this._parentFrame, _logger);
            if (visualVmFileVerifierWrapper.exists()) {
                String[] commandArray = JConsoleUIUtils.createJVisualVmCommand(jmxServiceURL, this._calculatedJavaHome, visualVmFileVerifierWrapper.getjVisualVmAppFile());
                this.runCommand(commandArray);
            } else if (visualVmFileVerifierWrapper.isShowMessage()) {
                JConsoleUIUtils.showVisualVmFileNotFoundMessage(this._parentFrame, visualVmFileVerifierWrapper);
            }
        } else {
            ServiceID spaceID = spaceViewWrapper.getServiceID();
            SpaceBrowser.getInstance().selectSpaceOperationNode(spaceID, source == this.selMemberNameMenuItem ? null : ((JMenuItem)source).getText());
        }
    }

    private void runCommand(String[] commandArray) {
        block3: {
            if (commandArray != null) {
                try {
                    Runtime.getRuntime().exec(commandArray);
                }
                catch (IOException ioe) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block3;
                    _logger.log(Level.SEVERE, ioe.toString(), ioe);
                }
            }
        }
    }

    public void addSpace(IJSpace space, IRemoteJSpaceAdmin spaceAdmin, ServiceID serviceID, SpaceConfig spaceConfig, ContainerConfig containerConfig, boolean isSecuredSpace) {
        SpaceViewWrapper spaceViewWrapper;
        if (this._spacesViewTableModel.containsSpace(serviceID)) {
            return;
        }
        String spaceName = null;
        String schemaName = COUNT_BLANK_VALUE;
        String isClusteredStrVal = COUNT_BLANK_VALUE;
        String isPersistentStrVal = COUNT_BLANK_VALUE;
        String isMemoryManagerEnabled = COUNT_BLANK_VALUE;
        String memoryWriteOnlyBlockPercentageRatio = COUNT_BLANK_VALUE;
        String memoryUsageLowPercentageRatio = COUNT_BLANK_VALUE;
        String cachePolicy = COUNT_BLANK_VALUE;
        if (spaceConfig != null) {
            spaceName = spaceConfig.getSpaceName();
            schemaName = spaceConfig.getSchemaName();
            isClusteredStrVal = spaceConfig.isClustered() ? YES_VAL : NO_VAL;
            isPersistentStrVal = spaceConfig.isPersistent() ? YES_VAL : NO_VAL;
            isMemoryManagerEnabled = spaceConfig.isEngineMemoryUsageEnabled();
            memoryWriteOnlyBlockPercentageRatio = spaceConfig.getEngineMemoryUsageWriteOnlyBlockPercentageRatio();
            memoryUsageLowPercentageRatio = spaceConfig.getEngineMemoryUsageLowPercentageRatio();
            cachePolicy = spaceConfig.getCachePolicy();
        } else {
            try {
                spaceName = space.getName();
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
        String containerName = containerConfig.containerName;
        String hostName = containerConfig.containerHostName;
        String locators = containerConfig.unicastURL;
        String jndiURL = containerConfig.jndiUrl;
        String jiniGroup = COUNT_BLANK_VALUE;
        String count = COUNT_BLANK_VALUE;
        String templatesCount = COUNT_BLANK_VALUE;
        if (containerConfig.isJiniLusEnabled() && spaceAdmin != null) {
            try {
                jiniGroup = JSpaceUtilities.getJiniGroupRepresentation((IRemoteJSpaceAdmin)spaceAdmin);
            }
            catch (ConnectException ce) {
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.log(Level.WARNING, ce.toString(), ce);
                }
            }
            catch (RemoteException e) {
                if (JSpaceUtilities.getCauseExceptionMessageFromHierarchy((Exception)e, SpaceConfigurationException.class) == null) {
                    if (e instanceof SpaceStoppedException || JSpaceUtilities.getCauseExceptionMessageFromHierarchy((Exception)e, SpaceStoppedException.class) != null) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, e.toString(), e);
                        }
                    } else {
                        SpaceBrowser.showException(e.toString(), e);
                    }
                }
                SpaceBrowser.getInstance().debug(e);
            }
        }
        if (this._spacesViewTableModel.addSpaceWrapper(spaceViewWrapper = new SpaceViewWrapper(spaceConfig, containerConfig, space, spaceAdmin, serviceID, spaceName, containerName, hostName, jiniGroup, schemaName, isClusteredStrVal, isPersistentStrVal, count, templatesCount, locators, jndiURL, Boolean.parseBoolean(isMemoryManagerEnabled), memoryWriteOnlyBlockPercentageRatio, memoryUsageLowPercentageRatio, cachePolicy, containerConfig.isJMXEnabled(), isSecuredSpace))) {
            spaceViewWrapper.reload();
            this._columnSortListener.sortAllRows();
            this.updateCount();
        }
    }

    private static String countTemplates(SpaceRuntimeInfo info) {
        long count = 0L;
        for (Integer intObj : info.m_NumOFTemplates) {
            count += (long)intObj.intValue();
        }
        return String.valueOf(count);
    }

    public void clear() {
        this._spacesViewTableModel.clear();
        this._infoBox.setCount(this._spacesViewTableModel.getRowCount());
    }

    public void removeSpace(ServiceID spaceID) {
        this._spacesViewTableModel.removeSpace(spaceID);
        this.updateCount();
    }

    private void updateCount() {
        this._infoBox.setCount(this._spacesViewTableModel.getRowCount());
    }

    @Override
    public void refresh() {
        if (this._isInvokeRefresh) {
            this._spacesViewTableModel.reload();
            this._columnSortListener.sortAllRows();
            int rowCount = this._spacesViewTableModel.getRowCount();
            this._infoBox.setCount(rowCount);
            if (_logger.isLoggable(Level.FINER) && this.getClass().equals(SpacesViewPanel.class)) {
                _logger.log(Level.FINER, "~~~ WITHIN REFRESH, spaces count=" + rowCount + ", total gsc count=" + Repository.getInstance().getGSCCount());
            }
        }
    }

    @Override
    public boolean isRunning() {
        return false;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    public IRemoteJSpaceAdmin getSpaceAdminObject(ServiceID spaceServiceID) {
        SpaceViewWrapper spaceViewWrapper = this._spacesViewTableModel.getWrapper(spaceServiceID);
        if (spaceViewWrapper != null) {
            return spaceViewWrapper.getSpaceAdmin();
        }
        return null;
    }

    public String getJndiURL(ServiceID spaceServiceID) {
        SpaceViewWrapper spaceViewWrapper = this._spacesViewTableModel.getWrapper(spaceServiceID);
        if (spaceViewWrapper != null) {
            return spaceViewWrapper.getJndiURL();
        }
        return null;
    }

    public boolean isPersistentLRUSpace(ServiceID spaceServiceID) {
        SpaceViewWrapper spaceViewWrapper = this._spacesViewTableModel.getWrapper(spaceServiceID);
        if (spaceViewWrapper != null) {
            return spaceViewWrapper.isPersistentLRUSpace();
        }
        return false;
    }

    public boolean isMirrorService(ServiceID spaceServiceID) {
        SpaceViewWrapper spaceViewWrapper = this._spacesViewTableModel.getWrapper(spaceServiceID);
        if (spaceViewWrapper != null) {
            return spaceViewWrapper.isMirrorService();
        }
        return false;
    }

    public List<SpaceViewWrapper> getAllSpaces() {
        return this._spacesViewTableModel.getWrappersList();
    }

    @Override
    public void setInvokeRefresh(boolean invokeRefresh) {
        this._isInvokeRefresh = invokeRefresh;
    }

    static {
        nf.setMaximumFractionDigits(2);
        nfForCPU = new DecimalFormat();
        nfForCPU.setMaximumFractionDigits(1);
    }

    private class MemoryColumnClassRenderer
    extends DefaultTableCellRenderer {
        private Color unselectedForeground;
        private Color unselectedBackground;
        private final Color _orangeColor = new Color(250, 150, 84);

        public MemoryColumnClassRenderer() {
            this.setHorizontalTextPosition(2);
        }

        @Override
        public void setForeground(Color c) {
            super.setForeground(c);
            this.unselectedForeground = c;
        }

        @Override
        public void setBackground(Color c) {
            super.setBackground(c);
            this.unselectedBackground = c;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                super.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
                super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
            }
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            SpaceViewWrapper spaceViewWrapper = SpacesViewPanel.this._spacesViewTableModel.getWrapperAt(row);
            if (spaceViewWrapper == null) {
                this.setIcon(null);
                this.setText("" + value);
                return this;
            }
            long maxMemory = spaceViewWrapper.getMaxMemory();
            long memoryUsage = spaceViewWrapper.getMemoryUsage();
            if (spaceViewWrapper.isMemoryManagerEnabled()) {
                float memoryWriteBlockPercentageRatio = spaceViewWrapper.getMemoryWriteBlockPercentageRatio();
                float memoryUsageLowPercentageRatio = spaceViewWrapper.getMemoryUsageLowPercentageRatio();
                if (memoryWriteBlockPercentageRatio > 0.0f && memoryUsageLowPercentageRatio > 0.0f && (float)memoryUsage >= memoryUsageLowPercentageRatio * (float)maxMemory && maxMemory > 0L) {
                    Color color = (float)memoryUsage >= memoryWriteBlockPercentageRatio * (float)maxMemory ? Color.RED : this._orangeColor;
                    super.setBackground(color);
                }
            }
            this.setText(spaceViewWrapper.getMemoryUsageStr());
            return this;
        }
    }

    private class DeltaColumnClassRenderer
    extends DefaultTableCellRenderer {
        private Color unselectedForeground;
        private Color unselectedBackground;

        public DeltaColumnClassRenderer() {
            this.setHorizontalTextPosition(2);
        }

        @Override
        public void setForeground(Color c) {
            super.setForeground(c);
            this.unselectedForeground = c;
        }

        @Override
        public void setBackground(Color c) {
            super.setBackground(c);
            this.unselectedBackground = c;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                super.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
                super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
            }
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            SpaceViewWrapper spaceViewWrapper = SpacesViewPanel.this._spacesViewTableModel.getWrapperAt(row);
            if (spaceViewWrapper == null) {
                this.setIcon(null);
                this.setText("" + value);
                return this;
            }
            short delta = spaceViewWrapper.getDeltaCountObjects();
            if (delta != 0) {
                String val = delta > 0 ? String.valueOf(delta) : "(-) " + String.valueOf(-1 * delta);
                Color color = delta > 0 ? Color.GREEN : Color.RED;
                this.setText(val);
                super.setBackground(color);
            } else {
                this.setText("");
            }
            return this;
        }
    }

    private class SpaceIndicationColumnClassRenderer
    extends DefaultTableCellRenderer {
        private SpaceIndicationColumnClassRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            SpaceViewWrapper spaceViewWrapper = SpacesViewPanel.this._spacesViewTableModel.getWrapperAt(row);
            if (spaceViewWrapper != null) {
                boolean isSecuredSpace = spaceViewWrapper.isSecuredSpace();
                ServiceID serviceID = spaceViewWrapper.getServiceID();
                short spaceMode = SpaceBrowser.getInstance().getSpaceMode(serviceID);
                ServiceID spaceID = spaceViewWrapper.getServiceID();
                this.setIcon(JSpaceUIUtils.getSpaceIcon(spaceMode, isSecuredSpace, spaceID));
            }
            return this;
        }
    }

    private class ReloadRuntimeConsumer
    implements IConsumerObject<SpaceViewWrapper> {
        private ReloadRuntimeConsumer() {
        }

        public void cleanUp() {
        }

        public void dispatch(SpaceViewWrapper o) {
            if (!o.isRuntimeReloading()) {
                o.reloadRuntimeInfoData();
            }
            o.reloadCPUUsage();
            o.reloadMemoryUsage();
            o.reloadStatisticsData();
            o.calculateZones();
            o.reloadSuspendInfo();
        }
    }

    private class CustomizeTableHeader
    extends JTableHeader {
        public CustomizeTableHeader(TableColumnModel tableColumnModel) {
            super(tableColumnModel);
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            Point p = e.getPoint();
            int index = this.columnModel.getColumnIndexAtX(p.x);
            if (SpacesViewTableModel.CI_DELTA >= 0 && index == SpacesViewTableModel.CI_DELTA) {
                return "Delta of Increasing/Decreasing the number of objects in space";
            }
            if (SpacesViewTableModel.CI_TEMPLATES_COUNT >= 0 && index == SpacesViewTableModel.CI_TEMPLATES_COUNT) {
                return "Notification Templates Count";
            }
            TableColumn tableColumn = this.columnModel.getColumn(index);
            int realIndex = tableColumn.getModelIndex();
            return this.table.getModel().getColumnName(realIndex);
        }
    }

    private class SelectColumnsAction
    implements ActionListener {
        private SelectColumnsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            SpacesViewPanel.this.showCustomizeViewDialog();
        }
    }

    private class ColumnSortListener
    extends MouseAdapter {
        private boolean _ascending = false;
        private int _sortedColumnIndex = -1;
        private JTable _table;
        private SpacesViewTableModel _tableModel;
        private TableColumnModel _columnModel;

        public ColumnSortListener(JTable table, SpacesViewTableModel tableModel) {
            this._table = table;
            this._tableModel = tableModel;
            this._columnModel = this._table.getColumnModel();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                this._sortedColumnIndex = this._columnModel.getColumnIndexAtX(e.getX());
                this.sortAllRowsBy(this._sortedColumnIndex, this._ascending);
                this._tableModel.fireTableDataChanged();
                this._ascending = !this._ascending;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sortAllRowsBy(int colIndex, boolean ascending) {
            List<SpaceViewWrapper> wrappersList;
            int selRow = this._table.getSelectedRow();
            SpaceViewWrapper selSpaceWrapper = null;
            if (selRow >= 0) {
                selSpaceWrapper = this._tableModel.getWrapperAt(selRow);
            }
            List<SpaceViewWrapper> list = wrappersList = this._tableModel.getWrappersList();
            synchronized (list) {
                Collections.sort(wrappersList, new ColumnSorter(colIndex, ascending));
            }
            this.selectTableRow(selSpaceWrapper);
        }

        protected void sortAllRows() {
            if (this._sortedColumnIndex >= 0) {
                this.sortAllRowsBy(this._sortedColumnIndex, !this._ascending);
            }
        }

        private void selectTableRow(SpaceViewWrapper selSpaceWrapper) {
            ServiceID selServiceID;
            int wrapperIndex;
            if (selSpaceWrapper != null && (wrapperIndex = this._tableModel.getWrapperIndex(selServiceID = selSpaceWrapper.getServiceID())) != -1) {
                this._table.setRowSelectionInterval(wrapperIndex, wrapperIndex);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ColumnSortListener.this._table.scrollRectToVisible(ColumnSortListener.this._table.getCellRect(wrapperIndex, -1, true));
                    }
                });
            }
        }

        private class ColumnSorter
        implements Comparator {
            private int colIndex;
            private boolean ascending;

            public ColumnSorter(int colIndex, boolean ascending) {
                this.colIndex = colIndex;
                this.ascending = ascending;
            }

            public int compare(Object a, Object b) {
                SpaceViewWrapper spaceViewWrapper1 = (SpaceViewWrapper)a;
                SpaceViewWrapper spaceViewWrapper2 = (SpaceViewWrapper)b;
                String obj1 = SpacesViewPanel.this._spacesViewTableModel.getCellValue(spaceViewWrapper1, this.colIndex);
                String obj2 = SpacesViewPanel.this._spacesViewTableModel.getCellValue(spaceViewWrapper2, this.colIndex);
                if (this.colIndex == SpacesViewTableModel.CI_OBJECTS_COUNT || this.colIndex == SpacesViewTableModel.CI_TEMPLATES_COUNT || this.colIndex == SpacesViewTableModel.CI_STAT_WRITE || this.colIndex == SpacesViewTableModel.CI_STAT_UPDATE || this.colIndex == SpacesViewTableModel.CI_STAT_READ || this.colIndex == SpacesViewTableModel.CI_STAT_TAKE || this.colIndex == SpacesViewTableModel.CI_STAT_NOTIFY_SENT || this.colIndex == SpacesViewTableModel.CI_STAT_NOTIFY_ACK || this.colIndex == SpacesViewTableModel.CI_STAT_NOTIFY_REGISTR || this.colIndex == SpacesViewTableModel.CI_STAT_EXECUTE || this.colIndex == SpacesViewTableModel.CI_REPLICATION_REDO_LOG || this.colIndex == SpacesViewTableModel.CI_REPLICATION_REDO_LOG_EXTERNAL_STORAGE_PACKET_COUNT || this.colIndex == SpacesViewTableModel.CI_REPLICATION_REDO_LOG_EXTERNAL_STORAGE_SPACE_USED || this.colIndex == SpacesViewTableModel.CI_REPLICATION_REDO_LOG_MEMORY_PACKET_COUNT) {
                    long longVal1 = 0L;
                    long longVal2 = 0L;
                    try {
                        longVal1 = Long.parseLong(obj1);
                    }
                    catch (NumberFormatException nfe) {
                        return this.ascending ? -1 : 1;
                    }
                    try {
                        longVal2 = Long.parseLong(obj2);
                    }
                    catch (NumberFormatException nfe) {
                        return this.ascending ? 1 : -1;
                    }
                    if (this.ascending) {
                        return longVal1 < longVal2 ? -1 : (longVal1 == longVal2 ? 0 : 1);
                    }
                    return longVal2 < longVal1 ? -1 : (longVal2 == longVal1 ? 0 : 1);
                }
                if (this.colIndex == SpacesViewTableModel.CI_MEMORY_USAGE) {
                    if (this.ascending) {
                        return (int)(spaceViewWrapper1.getMemoryUsage() - spaceViewWrapper2.getMemoryUsage());
                    }
                    return (int)(spaceViewWrapper2.getMemoryUsage() - spaceViewWrapper1.getMemoryUsage());
                }
                if (this.colIndex == SpacesViewTableModel.CI_SPACE_ICON) {
                    short spaceMode1 = SpaceBrowser.getInstance().getSpaceMode(spaceViewWrapper1.getServiceID());
                    short spaceMode2 = SpaceBrowser.getInstance().getSpaceMode(spaceViewWrapper2.getServiceID());
                    if (this.ascending) {
                        return spaceMode1 - spaceMode2;
                    }
                    return spaceMode2 - spaceMode1;
                }
                if (this.colIndex == SpacesViewTableModel.CI_CPU_USAGE) {
                    if (this.ascending) {
                        return (int)(spaceViewWrapper1.getCPUUsage() - spaceViewWrapper2.getCPUUsage());
                    }
                    return (int)(spaceViewWrapper2.getCPUUsage() - spaceViewWrapper1.getCPUUsage());
                }
                if (this.colIndex == SpacesViewTableModel.CI_DELTA) {
                    if (this.ascending) {
                        return spaceViewWrapper1.getDeltaCountObjects() - spaceViewWrapper2.getDeltaCountObjects();
                    }
                    return spaceViewWrapper2.getDeltaCountObjects() - spaceViewWrapper1.getDeltaCountObjects();
                }
                if (this.ascending) {
                    return obj1.compareTo(obj2);
                }
                return obj2.compareTo(obj1);
            }
        }
    }

    public class SpaceViewWrapper
    implements ISpaceStatistics {
        private IRemoteJSpaceAdmin _spaceAdmin;
        private IJSpace _spaceProxy;
        private ServiceID _serviceID;
        private String _spaceName;
        private String _containerName;
        private String _hostName;
        private String _jiniGroup;
        private String _schemaName;
        private String _persistent;
        private String _clustered;
        private String _objectsCount;
        private String _templatesCount;
        private String _primary;
        private String _locators;
        private boolean _isMemoryManagerEnabled;
        private String _memoryUsageStr = "";
        private String _memoryUsagePercentageStr = "";
        private long _memoryUsage;
        private double _cpuUsage = -1.0;
        private long _maxMemory = -1L;
        private float _memoryWriteBlockCheckRatio = 0.0f;
        private float _memoryUsageLowPercentageRatio = 0.0f;
        private String _jndiURL;
        private boolean _isJMXEnabled;
        private String _zonesRepresentation = "";
        private MBeanServerConnection _mBeanServerConnection;
        private Boolean _isStatisticsAvailable = null;
        private String _amountOfWriteOperations = "-";
        private String _amountOfUpdateOperations = "-";
        private String _amountOfReadOperations = "-";
        private String _amountOfTakeOperations = "-";
        private String _amountOfNotifySentOperations = "-";
        private String _amountOfNotifyAckOperations = "-";
        private String _amountOfNotifyRegistrationOperations = "-";
        private String _amountOfExecuteOperations = "-";
        private String _replicationRedoLogSize = "-";
        private String _replicationRedoLogExternalStoragePacketCount = "-";
        private String _replicationRedoLogExternalStorageSpaceUsed = "-";
        private String _replicationRedoLogMemoryPacketCount = "-";
        private String _mirrorTotalOperations = "-";
        private String _mirrorSuccessfulOperations = "-";
        private String _mirrorFailedOperations = "-";
        private String _mirrorInProgressOperations = "-";
        private String _mirrorDiscardedOperations = "-";
        private String _suspendType = "-";
        private short _countObjectsDelta;
        private boolean _isPersistentLRUSpace;
        private boolean _isMirrorService;
        private volatile boolean _isRuntimeReloading;
        private boolean _isSecuredSpace;
        private SpaceConfig _spaceConfig;
        private ContainerConfig _containerConfig;
        private JVMStatistics lastJvmStatistics;

        public SpaceViewWrapper(SpaceConfig spaceConfig, ContainerConfig containerConfig, IJSpace spaceProxy, IRemoteJSpaceAdmin spaceAdmin, ServiceID serviceID, String spaceName, String containerName, String hostName, String jiniGroup, String schemaName, String isClusteredStrVal, String isPersistentStrVal, String entriesCount, String templatesCount, String locators, String jndiURL, boolean isMemoryManagerEnabled, String memoryWriteOnlyBlockRatio, String memoryUsageLowPercentageRatio, String cachePolicy, boolean isJMXEnabled, boolean isSecuredSpace) {
            this._spaceConfig = spaceConfig;
            this._containerConfig = containerConfig;
            this._containerName = containerName;
            this._hostName = hostName;
            this._jiniGroup = jiniGroup;
            this._schemaName = schemaName;
            this._serviceID = serviceID;
            this._spaceAdmin = spaceAdmin;
            this._spaceProxy = spaceProxy;
            this._spaceName = spaceName;
            this._clustered = isClusteredStrVal;
            this._persistent = isPersistentStrVal;
            this._objectsCount = entriesCount;
            this._templatesCount = templatesCount;
            this._locators = locators;
            this._jndiURL = jndiURL;
            this._isJMXEnabled = isJMXEnabled;
            this._isSecuredSpace = isSecuredSpace;
            if (!memoryWriteOnlyBlockRatio.equals(SpacesViewPanel.COUNT_BLANK_VALUE)) {
                this._memoryWriteBlockCheckRatio = Float.parseFloat(memoryWriteOnlyBlockRatio) / 100.0f;
            }
            if (!memoryUsageLowPercentageRatio.equals(SpacesViewPanel.COUNT_BLANK_VALUE)) {
                this._memoryUsageLowPercentageRatio = Float.parseFloat(memoryUsageLowPercentageRatio) / 100.0f;
            }
            this._isMemoryManagerEnabled = isMemoryManagerEnabled;
            boolean isLRUCachePolicy = cachePolicy.equals(String.valueOf(0));
            this._isPersistentLRUSpace = this._persistent.equals(SpacesViewPanel.YES_VAL) && isLRUCachePolicy;
            this._isMirrorService = spaceConfig.isMirrorServiceEnabled();
            this.initPrimaryIndication();
        }

        public String getZones() {
            return this._zonesRepresentation;
        }

        public SpaceConfig getSpaceConfig() {
            return this._spaceConfig;
        }

        public ContainerConfig getContainerConfig() {
            return this._containerConfig;
        }

        public String getContainerName() {
            return this._containerName;
        }

        public String getHostName() {
            return this._hostName;
        }

        public String getJiniGroup() {
            return this._jiniGroup;
        }

        public String getSchemaName() {
            return this._schemaName;
        }

        public ServiceID getServiceID() {
            return this._serviceID;
        }

        public String getSpaceName() {
            return this._spaceName;
        }

        public IJSpace getSpaceProxy() {
            return this._spaceProxy;
        }

        public String getClustered() {
            return this._clustered;
        }

        public String getPersistent() {
            return this._persistent;
        }

        public String getObjectsCount() {
            return this._objectsCount;
        }

        public String getTemplatesCount() {
            return this._templatesCount;
        }

        public String getPrimaryIndication() {
            return this._primary;
        }

        public IRemoteJSpaceAdmin getSpaceAdmin() {
            return this._spaceAdmin;
        }

        public short getDeltaCountObjects() {
            return this._countObjectsDelta;
        }

        public boolean isSecuredSpace() {
            return this._isSecuredSpace;
        }

        public boolean isClustered() {
            return this._clustered.equals(SpacesViewPanel.YES_VAL);
        }

        public void reload() {
            this.initPrimaryIndication();
            SpacesViewPanel.this._workingGroup.enqueueBlocked((Object)this);
        }

        public void reloadCPUUsage() {
            if (SpacesViewPanel.this._isCalculateCPUUsage && this._spaceAdmin instanceof JVMInfoProvider) {
                double cpuPerc;
                block5: {
                    JVMInfoProvider jvmInfoProvider = (JVMInfoProvider)this._spaceAdmin;
                    cpuPerc = -1.0;
                    try {
                        JVMStatistics jvmStatistics = jvmInfoProvider.getJVMStatistics();
                        if (jvmStatistics != null) {
                            if (this.lastJvmStatistics != null) {
                                cpuPerc = jvmStatistics.computeCpuPerc(this.lastJvmStatistics);
                            }
                            this.lastJvmStatistics = jvmStatistics;
                        }
                    }
                    catch (Exception e) {
                        if (!_logger.isLoggable(Level.SEVERE)) break block5;
                        _logger.log(Level.SEVERE, e.toString(), e);
                    }
                }
                this._cpuUsage = cpuPerc;
            }
        }

        public void reloadSuspendInfo() {
            if (SpacesViewPanel.this._isCalculateSuspendInfo) {
                String suspendTypeStr;
                block3: {
                    suspendTypeStr = "";
                    IInternalRemoteJSpaceAdmin admin = (IInternalRemoteJSpaceAdmin)this._spaceAdmin;
                    try {
                        suspendTypeStr = SpaceBrowser.getSuspendTypeName(admin);
                    }
                    catch (Exception e) {
                        if (!_logger.isLoggable(Level.SEVERE)) break block3;
                        _logger.log(Level.SEVERE, e.toString(), e);
                    }
                }
                this._suspendType = suspendTypeStr;
            }
        }

        public void reloadMemoryUsage() {
            if (!this._isJMXEnabled) {
                this._memoryUsageStr = SpacesViewPanel.COUNT_BLANK_VALUE;
                return;
            }
            if (_jvmVersion.startsWith("1.4")) {
                this._memoryUsageStr = JMX_USAGE_WITH_JDK_1_4;
                this._memoryUsagePercentageStr = JMX_USAGE_WITH_JDK_1_4;
                return;
            }
            if (!this.hasPermission((Privilege)MonitorAuthority.MonitorPrivilege.MONITOR_JVM)) {
                this._memoryUsageStr = "****";
                this._memoryUsagePercentageStr = "****";
                return;
            }
            if (SpacesViewPanel.this._isCalculateMemoryUsage) {
                if (this._mBeanServerConnection == null) {
                    try {
                        this._mBeanServerConnection = MBeanServerConnectionFactory.createMBeanServerConnection((String)this._jndiURL);
                    }
                    catch (ConnectException ce) {
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.log(Level.FINEST, "Space \"" + this._spaceName + "\" is not available. " + ce.toString());
                        }
                    }
                    catch (ConnectIOException exc) {
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.log(Level.FINEST, "Space \"" + this._spaceName + "\" is not available. " + exc.toString());
                        }
                    }
                    catch (Exception e) {
                        _logger.log(Level.SEVERE, e.toString(), e);
                    }
                }
                if (this._mBeanServerConnection != null) {
                    try {
                        MemoryMXBean memoryMXBean = ManagementFactory.newPlatformMXBeanProxy(this._mBeanServerConnection, "java.lang:type=Memory", MemoryMXBean.class);
                        MemoryUsage memoryUsage = memoryMXBean.getHeapMemoryUsage();
                        this._memoryUsage = memoryUsage.getUsed();
                        this._memoryUsageStr = String.valueOf(this._memoryUsage / 0x100000L);
                        this._memoryUsagePercentageStr = this.calculatedUsedMemoryPercentage() + "%";
                        this._memoryUsageStr = this._memoryUsageStr + " ( " + this._memoryUsagePercentageStr + " )";
                        if (this._maxMemory <= 0L) {
                            this._maxMemory = memoryUsage.getMax();
                        }
                    }
                    catch (ConnectException ce) {
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.log(Level.FINEST, "Space \"" + this._spaceName + "\" is not available. " + ce.toString());
                        }
                    }
                    catch (ConnectIOException exc) {
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.log(Level.FINEST, "Space \"" + this._spaceName + "\" is not available. " + exc.toString());
                        }
                    }
                    catch (IOException ioe) {
                        _logger.log(Level.SEVERE, ioe.toString(), ioe);
                    }
                    catch (NoSuchMethodError er) {
                        SpacesViewPanel.this._isCalculateMemoryUsage = false;
                        this._memoryUsageStr = JMX_USAGE_WITH_JDK_1_4;
                        this._memoryUsagePercentageStr = JMX_USAGE_WITH_JDK_1_4;
                    }
                }
            }
        }

        private boolean hasPermission(Privilege permittedPrivilege) {
            return JSpaceUIUtils.hasPermittedPermission((SecuredService)this._spaceProxy, this._serviceID, permittedPrivilege, this._spaceProxy.isSecured());
        }

        public void reloadStatisticsData() {
            block14: {
                if (this._spaceAdmin == null) {
                    return;
                }
                StatisticsAdmin stats = (StatisticsAdmin)this._spaceAdmin;
                if (!this.hasPermission((Privilege)MonitorAuthority.MonitorPrivilege.MONITOR_PU)) {
                    this._amountOfWriteOperations = "****";
                    this._amountOfUpdateOperations = "****";
                    this._amountOfReadOperations = "****";
                    this._amountOfTakeOperations = "****";
                    this._amountOfNotifySentOperations = "****";
                    this._amountOfNotifyAckOperations = "****";
                    this._amountOfNotifyRegistrationOperations = "****";
                    this._amountOfExecuteOperations = "****";
                    this._replicationRedoLogSize = "****";
                    this._replicationRedoLogExternalStoragePacketCount = "****";
                    this._replicationRedoLogExternalStorageSpaceUsed = "****";
                    this._replicationRedoLogMemoryPacketCount = "****";
                    this._mirrorTotalOperations = "****";
                    this._mirrorSuccessfulOperations = "****";
                    this._mirrorFailedOperations = "****";
                    this._mirrorInProgressOperations = "****";
                    this._mirrorDiscardedOperations = "****";
                    return;
                }
                try {
                    if (SpacesViewPanel.this._isCalculateStatistics) {
                        if (this._isStatisticsAvailable == null) {
                            this._isStatisticsAvailable = stats.isStatisticsAvailable();
                        }
                        if (this._isStatisticsAvailable.booleanValue()) {
                            MirrorStatistics mirrorStatistics;
                            ReplicationStatistics.OutgoingReplication outgoingReplication;
                            Map statisticsMap = stats.getStatistics(_statisticsCodes);
                            StatisticsHolder statisticsHolder = stats.getHolder();
                            ReplicationStatistics replicationStatistics = statisticsHolder.getReplicationStatistics();
                            if (replicationStatistics != null && (outgoingReplication = replicationStatistics.getOutgoingReplication()) != null) {
                                this._replicationRedoLogSize = String.valueOf(outgoingReplication.getRedoLogSize());
                                this._replicationRedoLogExternalStoragePacketCount = String.valueOf(outgoingReplication.getRedoLogExternalStoragePacketCount());
                                this._replicationRedoLogExternalStorageSpaceUsed = String.valueOf(outgoingReplication.getRedoLogExternalStorageSpaceUsed());
                                this._replicationRedoLogMemoryPacketCount = String.valueOf(outgoingReplication.getRedoLogMemoryPacketCount());
                            }
                            if ((mirrorStatistics = statisticsHolder.getMirrorStatistics()) != null) {
                                this._mirrorTotalOperations = String.valueOf(mirrorStatistics.getOperationCount());
                                this._mirrorSuccessfulOperations = String.valueOf(mirrorStatistics.getSuccessfulOperationCount());
                                this._mirrorFailedOperations = String.valueOf(mirrorStatistics.getFailedOperationCount());
                                this._mirrorInProgressOperations = String.valueOf(mirrorStatistics.getInProgressOperationCount());
                                this._mirrorDiscardedOperations = String.valueOf(mirrorStatistics.getDiscardedOperationCount());
                            }
                            StatisticsContext readStat = (StatisticsContext)statisticsMap.get(OC_BEFORE_READ);
                            StatisticsContext readMStat = (StatisticsContext)statisticsMap.get(OC_AFTER_READ_MULTIPLE);
                            StatisticsContext writeStat = (StatisticsContext)statisticsMap.get(OC_BEFORE_WRITE);
                            StatisticsContext updateStat = (StatisticsContext)statisticsMap.get(OC_BEFORE_UPDATE);
                            StatisticsContext notifyRegistrationStat = (StatisticsContext)statisticsMap.get(OC_BEFORE_NOTIFY);
                            StatisticsContext notifySentStat = (StatisticsContext)statisticsMap.get(OC_BEFORE_NOTIFY_TRIGGER);
                            StatisticsContext notifyAcknowledgeStat = (StatisticsContext)statisticsMap.get(OC_AFTER_NOTIFY_TRIGGER);
                            StatisticsContext takeStat = (StatisticsContext)statisticsMap.get(OC_BEFORE_TAKE);
                            StatisticsContext takeMStat = (StatisticsContext)statisticsMap.get(OC_AFTER_TAKE_MULTIPLE);
                            StatisticsContext executorsStat = (StatisticsContext)statisticsMap.get(OC_BEFORE_EXECUTE);
                            int readValue = readStat == null ? 0 : (int)readStat.getCurrentCount();
                            int readMValue = readMStat == null ? 0 : (int)readMStat.getCurrentCount();
                            int writeValue = writeStat == null ? 0 : (int)writeStat.getCurrentCount();
                            int updateValue = updateStat == null ? 0 : (int)updateStat.getCurrentCount();
                            int takeValue = takeStat == null ? 0 : (int)takeStat.getCurrentCount();
                            int takeMValue = takeMStat == null ? 0 : (int)takeMStat.getCurrentCount();
                            int notifyRegistrationValue = notifyRegistrationStat == null ? 0 : (int)notifyRegistrationStat.getCurrentCount();
                            int notifySentValue = notifySentStat == null ? 0 : (int)notifySentStat.getCurrentCount();
                            int notifyAckValue = notifyAcknowledgeStat == null ? 0 : (int)notifyAcknowledgeStat.getCurrentCount();
                            int executorsValue = executorsStat == null ? 0 : (int)executorsStat.getCurrentCount();
                            this._amountOfWriteOperations = String.valueOf(writeValue);
                            this._amountOfUpdateOperations = String.valueOf(updateValue);
                            this._amountOfReadOperations = String.valueOf(readValue += readMValue);
                            this._amountOfTakeOperations = String.valueOf(takeValue += takeMValue);
                            this._amountOfNotifySentOperations = String.valueOf(notifySentValue);
                            this._amountOfNotifyAckOperations = String.valueOf(notifyAckValue);
                            this._amountOfNotifyRegistrationOperations = String.valueOf(notifyRegistrationValue);
                            this._amountOfExecuteOperations = String.valueOf(executorsValue);
                        }
                    } else {
                        this._amountOfWriteOperations = SpacesViewPanel.COUNT_BLANK_VALUE;
                        this._amountOfUpdateOperations = SpacesViewPanel.COUNT_BLANK_VALUE;
                        this._amountOfReadOperations = SpacesViewPanel.COUNT_BLANK_VALUE;
                        this._amountOfTakeOperations = SpacesViewPanel.COUNT_BLANK_VALUE;
                        this._amountOfNotifySentOperations = SpacesViewPanel.COUNT_BLANK_VALUE;
                        this._amountOfNotifyAckOperations = SpacesViewPanel.COUNT_BLANK_VALUE;
                        this._amountOfNotifyRegistrationOperations = SpacesViewPanel.COUNT_BLANK_VALUE;
                        this._amountOfExecuteOperations = SpacesViewPanel.COUNT_BLANK_VALUE;
                        this._replicationRedoLogSize = SpacesViewPanel.COUNT_BLANK_VALUE;
                        this._replicationRedoLogExternalStoragePacketCount = SpacesViewPanel.COUNT_BLANK_VALUE;
                        this._replicationRedoLogExternalStorageSpaceUsed = SpacesViewPanel.COUNT_BLANK_VALUE;
                        this._replicationRedoLogMemoryPacketCount = SpacesViewPanel.COUNT_BLANK_VALUE;
                        this._mirrorTotalOperations = SpacesViewPanel.COUNT_BLANK_VALUE;
                        this._mirrorSuccessfulOperations = SpacesViewPanel.COUNT_BLANK_VALUE;
                        this._mirrorFailedOperations = SpacesViewPanel.COUNT_BLANK_VALUE;
                        this._mirrorInProgressOperations = SpacesViewPanel.COUNT_BLANK_VALUE;
                        this._mirrorDiscardedOperations = SpacesViewPanel.COUNT_BLANK_VALUE;
                    }
                }
                catch (ConnectException ce) {
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, "Space \"" + this._spaceName + "\" is not available. " + ce.toString());
                    }
                }
                catch (ConnectIOException exc) {
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, "Space \"" + this._spaceName + "\" is not available. " + exc.toString());
                    }
                }
                catch (RemoteException re) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block14;
                    _logger.log(Level.SEVERE, re.toString(), re);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reloadRuntimeInfoData() {
            block38: {
                if (this._spaceAdmin == null) {
                    return;
                }
                if (!SpaceBrowser.getInstance().isRetrieveRuntimeForPersistentLRUSpace() && this._isPersistentLRUSpace) {
                    this._objectsCount = SpacesViewPanel.COUNT_BLANK_VALUE;
                    this._templatesCount = SpacesViewPanel.COUNT_BLANK_VALUE;
                    return;
                }
                try {
                    this._isRuntimeReloading = true;
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest("------- BEFORE RuntimeInfo reload: , _isCalculateObjectsCount:" + SpacesViewPanel.this._isCalculateObjectsCount + ", _isCalculateTemplatesCount:" + SpacesViewPanel.this._isCalculateTemplatesCount + ", _isCalculateSuspendInfo:" + SpacesViewPanel.this._isCalculateSuspendInfo);
                    }
                    if (!this.hasPermission((Privilege)MonitorAuthority.MonitorPrivilege.MONITOR_PU)) {
                        this._objectsCount = "****";
                        this._templatesCount = "****";
                        return;
                    }
                    SpaceMode spaceMode = PrimaryBackupIndicationListener.getInstance().getSpaceMode(this._serviceID);
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest(">>reloadRuntimeInfoData, space [" + this._containerName + SpacesViewPanel.COUNT_BLANK_VALUE + this._spaceName + "], spaceMode=" + spaceMode);
                    }
                    if ((SpacesViewPanel.this._isCalculateObjectsCount || SpacesViewPanel.this._isCalculateTemplatesCount) && (spaceMode != null && !spaceMode.equals((Object)SpaceMode.NONE) || !this._spaceConfig.isClustered())) {
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest("------- RELOAD of: \"" + this._containerName + ":" + this._spaceName + "\" -------");
                            _logger.finest("--Time before calling to getRuntimeInfo():" + System.currentTimeMillis());
                        }
                        SpaceRuntimeInfo spaceRuntimeInfo = this._spaceAdmin.getRuntimeInfo();
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest("--Time after calling to getRuntimeInfo():" + System.currentTimeMillis());
                        }
                        if (SpacesViewPanel.this._isCalculateObjectsCount) {
                            long currentCount = JSpaceUtilities.countSpaceObjects((SpaceRuntimeInfo)spaceRuntimeInfo);
                            try {
                                long prevCount = Integer.parseInt(this._objectsCount);
                                this._countObjectsDelta = (short)(currentCount - prevCount);
                            }
                            catch (NumberFormatException nfe) {
                                this._countObjectsDelta = 0;
                            }
                            this._objectsCount = String.valueOf(currentCount);
                        } else {
                            this._objectsCount = SpacesViewPanel.COUNT_BLANK_VALUE;
                        }
                        String string = this._templatesCount = SpacesViewPanel.this._isCalculateTemplatesCount ? SpacesViewPanel.countTemplates(spaceRuntimeInfo) : SpacesViewPanel.COUNT_BLANK_VALUE;
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest("--Time after receiving both entries and templates counters:" + System.currentTimeMillis());
                            _logger.finest("------- Entries Count= " + this._objectsCount + ", Templates Count=" + this._templatesCount + "\" -------\n");
                        }
                        break block38;
                    }
                    this._objectsCount = SpacesViewPanel.COUNT_BLANK_VALUE;
                    this._templatesCount = SpacesViewPanel.COUNT_BLANK_VALUE;
                }
                catch (ConnectException exc) {
                    this._objectsCount = SpacesViewPanel.COUNT_BLANK_VALUE;
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, "Space \"" + this._spaceName + "\" is not available. " + exc.toString());
                    }
                }
                catch (ConnectIOException exc) {
                    this._objectsCount = SpacesViewPanel.COUNT_BLANK_VALUE;
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, "Space \"" + this._spaceName + "\" is not available. " + exc.toString());
                    }
                }
                catch (ElectionInProcessException exc) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, exc.toString(), exc);
                    }
                }
                catch (InactiveSpaceException exc) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, exc.toString(), exc);
                    }
                }
                catch (Exception exc) {
                    this._objectsCount = SpacesViewPanel.COUNT_BLANK_VALUE;
                    if (exc instanceof NoSuchObjectException || exc instanceof SpaceUnavailableException || JSpaceUtilities.getCauseExceptionMessageFromHierarchy((Exception)exc, SpaceUnavailableException.class) != null) {
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest("Space \"" + this._spaceName + "\" is not available. Shutdown or other abort operation in process.");
                        }
                    } else if (exc instanceof SpaceStoppedException || JSpaceUtilities.getCauseExceptionMessageFromHierarchy((Exception)exc, SpaceStoppedException.class) != null) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, exc.toString(), exc);
                        }
                        PrimaryBackupIndicationListener.getInstance().removeSpace(this._serviceID);
                    } else if (_logger.isLoggable(Level.WARNING)) {
                        _logger.log(Level.WARNING, "Exception while trying to retrieve runtime information from space \"" + this._spaceName + "\"." + exc.toString(), exc);
                    }
                }
                finally {
                    this._isRuntimeReloading = false;
                }
            }
        }

        public String calculatedUsedMemoryPercentage() {
            if (this._memoryUsage <= 0L || this._maxMemory <= 0L) {
                return String.valueOf(0);
            }
            float usedMemoryPercent = (float)this._memoryUsage * 100.0f / (float)this._maxMemory;
            return nf.format(usedMemoryPercent);
        }

        private void initPrimaryIndication() {
            SpaceMode spaceMode = PrimaryBackupIndicationListener.getInstance().getSpaceMode(this._serviceID);
            this._primary = spaceMode == null ? SpacesViewPanel.COUNT_BLANK_VALUE : (spaceMode.equals((Object)SpaceMode.PRIMARY) ? SpacesViewPanel.YES_VAL : SpacesViewPanel.NO_VAL);
        }

        public boolean isRuntimeReloading() {
            return this._isRuntimeReloading;
        }

        public String getAmountOfWriteOperations() {
            return this._amountOfWriteOperations;
        }

        public String getAmountOfUpdateOperations() {
            return this._amountOfUpdateOperations;
        }

        public String getAmountOfReadOperations() {
            return this._amountOfReadOperations;
        }

        public String getAmountOfTakeOperations() {
            return this._amountOfTakeOperations;
        }

        public String getAmountOfNotifySentOperations() {
            return this._amountOfNotifySentOperations;
        }

        public String getAmountOfNotifyAckOperations() {
            return this._amountOfNotifyAckOperations;
        }

        public String getAmountOfNotifyRegistrationOperations() {
            return this._amountOfNotifyRegistrationOperations;
        }

        public String getAmountOfExecuteOperations() {
            return this._amountOfExecuteOperations;
        }

        public String getReplicationRedoLogSize() {
            return this._replicationRedoLogSize;
        }

        public String getReplicationRedoLogExternalStoragePacketCount() {
            return this._replicationRedoLogExternalStoragePacketCount;
        }

        public String getReplicationRedoLogExternalStorageSpaceUsed() {
            return this._replicationRedoLogExternalStorageSpaceUsed;
        }

        public String getReplicationRedoLogMemoryPacketCount() {
            return this._replicationRedoLogMemoryPacketCount;
        }

        public String getMirrorTotalOperations() {
            return this._mirrorTotalOperations;
        }

        public String getMirrorSuccessfulOperations() {
            return this._mirrorSuccessfulOperations;
        }

        public String getMirrorFailedOperations() {
            return this._mirrorFailedOperations;
        }

        public String getMirrorInProgressOperations() {
            return this._mirrorInProgressOperations;
        }

        public String getMirrorDiscardedOperations() {
            return this._mirrorDiscardedOperations;
        }

        public String getSuspendType() {
            return this._suspendType;
        }

        public String getLocators() {
            return this._locators;
        }

        public String getMemoryUsageStr() {
            return this._memoryUsageStr;
        }

        public double getCPUUsage() {
            return this._cpuUsage;
        }

        public long getMemoryUsage() {
            return this._memoryUsage;
        }

        public String getJndiURL() {
            return this._jndiURL;
        }

        public float getMemoryWriteBlockPercentageRatio() {
            return this._memoryWriteBlockCheckRatio;
        }

        public float getMemoryUsageLowPercentageRatio() {
            return this._memoryUsageLowPercentageRatio;
        }

        public long getMaxMemory() {
            return this._maxMemory;
        }

        public boolean isMemoryManagerEnabled() {
            return this._isMemoryManagerEnabled;
        }

        public String getMemoryUsagePercentageStr() {
            return this._memoryUsagePercentageStr;
        }

        public boolean isPersistentLRUSpace() {
            return this._isPersistentLRUSpace;
        }

        public boolean isMirrorService() {
            return this._isMirrorService;
        }

        public boolean isJMXEnabled() {
            return this._isJMXEnabled;
        }

        public void calculateZones() {
            if (SpacesViewPanel.this._isCalculateZones && JSpaceUtilities.isEmpty((String)this._zonesRepresentation, (boolean)true) && this._spaceAdmin instanceof GridZoneProvider) {
                try {
                    String[] zones = ((GridZoneProvider)this._spaceAdmin).getZones();
                    this._zonesRepresentation = JSpaceUtilities.getZonesStringRepresentation((String[])zones);
                }
                catch (RemoteException re) {
                    if (_logger.isLoggable(Level.SEVERE)) {
                        _logger.log(Level.SEVERE, re.toString(), re);
                    }
                    this._zonesRepresentation = "";
                }
            }
        }
    }

    public static class SpacesViewTableModel
    extends DefaultTableModel
    implements ISpacesView {
        private List<SpaceViewWrapper> _wrappersList = Collections.synchronizedList(new ArrayList());
        private Map<ServiceID, SpaceViewWrapper> wrappersMap = new HashMap<ServiceID, SpaceViewWrapper>();
        private SpacesViewPanel _spacesViewPanel;
        private static int CI_SPACE_ICON = 0;
        private static int CI_SPACE_NAME = 1;
        private static int CI_CONTAINER_NAME = 2;
        private static int CI_OBJECTS_COUNT = 3;
        private static int CI_DELTA = 4;
        private static int CI_TEMPLATES_COUNT = 5;
        private static int CI_HOST_NAME = 6;
        private static int CI_JINI_GROUP = 7;
        private static int CI_LOCATORS = 8;
        private static int CI_ZONES = 9;
        private static int CI_SCHEMA_NAME = 10;
        private static int CI_PERSISTENT = 11;
        private static int CI_CLUSTERED = 12;
        private static int CI_PRIMARY_INDICATION = 13;
        private static int CI_MEMORY_USAGE = 14;
        private static int CI_CPU_USAGE = 15;
        private static int CI_STAT_WRITE = 16;
        private static int CI_STAT_UPDATE = 17;
        private static int CI_STAT_READ = 18;
        private static int CI_STAT_TAKE = 19;
        private static int CI_STAT_NOTIFY_SENT = 20;
        private static int CI_STAT_NOTIFY_ACK = 21;
        private static int CI_STAT_NOTIFY_REGISTR = 22;
        private static int CI_STAT_EXECUTE = 23;
        private static int CI_REPLICATION_REDO_LOG = 24;
        private static int CI_REPLICATION_REDO_LOG_EXTERNAL_STORAGE_PACKET_COUNT = 25;
        private static int CI_REPLICATION_REDO_LOG_EXTERNAL_STORAGE_SPACE_USED = 26;
        private static int CI_REPLICATION_REDO_LOG_MEMORY_PACKET_COUNT = 27;
        private static int CI_MIRROR_TOTAL_OPERATIONS = 28;
        private static int CI_MIRROR_SUCCESSFUL_OPERATIONS = 29;
        private static int CI_MIRROR_FAILED_OPERATIONS = 30;
        private static int CI_MIRROR_IN_PROGRESS_OPERATIONS = 31;
        private static int CI_MIRROR_DISCARDED_OPERATIONS = 32;
        private static int CI_SUSPEND_TYPE = 33;
        private String[] columnNames = DEFAULT_COLUMN_NAMES;

        public SpacesViewTableModel(SpacesViewPanel spacesViewPanel) {
            this._spacesViewPanel = spacesViewPanel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            List<SpaceViewWrapper> list = this._wrappersList;
            synchronized (list) {
                int listSize = this._wrappersList.size();
                this._wrappersList.clear();
                this.wrappersMap.clear();
                if (listSize > 0) {
                    this.fireTableRowsDeleted(0, listSize - 1);
                }
            }
        }

        public String[] getColumnNames() {
            return this.columnNames;
        }

        protected boolean containsSpace(ServiceID spaceID) {
            return this.wrappersMap.containsKey(spaceID);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addSpaceWrapper(SpaceViewWrapper spaceViewWrapper) {
            ServiceID spaceID = spaceViewWrapper.getServiceID();
            if (!this.containsSpace(spaceID)) {
                this.wrappersMap.put(spaceID, spaceViewWrapper);
                List<SpaceViewWrapper> list = this._wrappersList;
                synchronized (list) {
                    this._wrappersList.add(spaceViewWrapper);
                    this.fireTableRowsInserted(this._wrappersList.size(), this._wrappersList.size());
                }
                return true;
            }
            return false;
        }

        public void updateColumnNames(List<String> newColumnNames) {
            this.columnNames = newColumnNames.toArray(new String[newColumnNames.size()]);
            CI_SPACE_NAME = newColumnNames.indexOf("Name");
            CI_CONTAINER_NAME = newColumnNames.indexOf("Container Name");
            CI_OBJECTS_COUNT = newColumnNames.indexOf("Objects Count");
            CI_DELTA = newColumnNames.indexOf("\u0394");
            CI_TEMPLATES_COUNT = newColumnNames.indexOf("Templates Count");
            CI_HOST_NAME = newColumnNames.indexOf("Host Name");
            CI_JINI_GROUP = newColumnNames.indexOf("Jini Group");
            CI_LOCATORS = newColumnNames.indexOf("Locators");
            CI_ZONES = newColumnNames.indexOf("Zones");
            CI_SCHEMA_NAME = newColumnNames.indexOf("Schema Name");
            CI_PERSISTENT = newColumnNames.indexOf("Persistent");
            CI_CLUSTERED = newColumnNames.indexOf("Clustered");
            CI_PRIMARY_INDICATION = newColumnNames.indexOf("Primary");
            CI_MEMORY_USAGE = newColumnNames.indexOf("Used Memory (MB)");
            CI_CPU_USAGE = newColumnNames.indexOf("Used CPU (%)");
            CI_STAT_WRITE = newColumnNames.indexOf("Write");
            CI_STAT_UPDATE = newColumnNames.indexOf("Update");
            CI_STAT_READ = newColumnNames.indexOf("Read");
            CI_STAT_TAKE = newColumnNames.indexOf("Take");
            CI_STAT_NOTIFY_SENT = newColumnNames.indexOf("Notify Sent");
            CI_STAT_NOTIFY_ACK = newColumnNames.indexOf("Notify Ack.");
            CI_STAT_NOTIFY_REGISTR = newColumnNames.indexOf("Notify Registration");
            CI_STAT_EXECUTE = newColumnNames.indexOf("Execute");
            CI_REPLICATION_REDO_LOG = newColumnNames.indexOf("Replicat. Redo Log");
            CI_REPLICATION_REDO_LOG_EXTERNAL_STORAGE_PACKET_COUNT = newColumnNames.indexOf("Repl. Packets Disk");
            CI_REPLICATION_REDO_LOG_EXTERNAL_STORAGE_SPACE_USED = newColumnNames.indexOf("Repl. Packets Disk Usage (Bytes)");
            CI_REPLICATION_REDO_LOG_MEMORY_PACKET_COUNT = newColumnNames.indexOf("Repl. Packets Mem.");
            CI_MIRROR_TOTAL_OPERATIONS = newColumnNames.indexOf("Mirror Total Operations");
            CI_MIRROR_SUCCESSFUL_OPERATIONS = newColumnNames.indexOf("Mirror Successful Operations");
            CI_MIRROR_IN_PROGRESS_OPERATIONS = newColumnNames.indexOf("Mirror In Progress Operations");
            CI_MIRROR_DISCARDED_OPERATIONS = newColumnNames.indexOf("Mirror Discarded Operations");
            CI_MIRROR_FAILED_OPERATIONS = newColumnNames.indexOf("Mirror Failed Operations");
            CI_SUSPEND_TYPE = newColumnNames.indexOf("Suspend Type");
            this.fireTableStructureChanged();
            this._spacesViewPanel.defineColumnWidthAndRenderers();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSpace(ServiceID spaceID) {
            SpaceViewWrapper removedWrapper = this.wrappersMap.remove(spaceID);
            if (removedWrapper != null) {
                List<SpaceViewWrapper> list = this._wrappersList;
                synchronized (list) {
                    int index = this._wrappersList.indexOf(removedWrapper);
                    this._wrappersList.remove(removedWrapper);
                    if (index != -1) {
                        this.fireTableRowsDeleted(index, index);
                    }
                }
            }
        }

        public SpaceViewWrapper getWrapper(ServiceID spaceID) {
            return this.wrappersMap.get(spaceID);
        }

        public int getWrapperIndex(ServiceID serviceID) {
            SpaceViewWrapper wrapper = this.getWrapper(serviceID);
            if (wrapper != null) {
                return this._wrappersList.indexOf(wrapper);
            }
            return -1;
        }

        @Override
        public Object getValueAt(int row, int column) {
            SpaceViewWrapper spaceViewWrapper;
            if (row < this._wrappersList.size() && (spaceViewWrapper = this._wrappersList.get(row)) != null) {
                return this.getCellValue(spaceViewWrapper, column);
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public Class getColumnClass(int columnIndex) {
            Object obj = this.getValueAt(0, columnIndex);
            if (obj != null) {
                return obj.getClass();
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this._wrappersList == null ? 0 : this._wrappersList.size();
        }

        public List<SpaceViewWrapper> getWrappersList() {
            return this._wrappersList;
        }

        public SpaceViewWrapper getWrapperAt(int row) {
            if (row < 0 || row >= this._wrappersList.size()) {
                return null;
            }
            return this._wrappersList.get(row);
        }

        public String getCellValue(SpaceViewWrapper spaceViewWrapper, int column) {
            if (column == CI_SPACE_ICON) {
                return "";
            }
            if (column == CI_SPACE_NAME) {
                return spaceViewWrapper.getSpaceName();
            }
            if (column == CI_CONTAINER_NAME) {
                return spaceViewWrapper.getContainerName();
            }
            if (column == CI_HOST_NAME) {
                return spaceViewWrapper.getHostName();
            }
            if (column == CI_JINI_GROUP) {
                return spaceViewWrapper.getJiniGroup();
            }
            if (column == CI_ZONES) {
                return spaceViewWrapper.getZones();
            }
            if (column == CI_SCHEMA_NAME) {
                return spaceViewWrapper.getSchemaName();
            }
            if (column == CI_PERSISTENT) {
                return spaceViewWrapper.getPersistent();
            }
            if (column == CI_CLUSTERED) {
                return spaceViewWrapper.getClustered();
            }
            if (column == CI_OBJECTS_COUNT) {
                return spaceViewWrapper.getObjectsCount();
            }
            if (column == CI_DELTA) {
                return "";
            }
            if (column == CI_TEMPLATES_COUNT) {
                return spaceViewWrapper.getTemplatesCount();
            }
            if (column == CI_PRIMARY_INDICATION) {
                return spaceViewWrapper.getPrimaryIndication();
            }
            if (column == CI_LOCATORS) {
                return spaceViewWrapper.getLocators();
            }
            if (column == CI_STAT_WRITE) {
                return spaceViewWrapper.getAmountOfWriteOperations();
            }
            if (column == CI_STAT_UPDATE) {
                return spaceViewWrapper.getAmountOfUpdateOperations();
            }
            if (column == CI_STAT_READ) {
                return spaceViewWrapper.getAmountOfReadOperations();
            }
            if (column == CI_STAT_TAKE) {
                return spaceViewWrapper.getAmountOfTakeOperations();
            }
            if (column == CI_STAT_NOTIFY_SENT) {
                return spaceViewWrapper.getAmountOfNotifySentOperations();
            }
            if (column == CI_STAT_NOTIFY_ACK) {
                return spaceViewWrapper.getAmountOfNotifyAckOperations();
            }
            if (column == CI_STAT_NOTIFY_REGISTR) {
                return spaceViewWrapper.getAmountOfNotifyRegistrationOperations();
            }
            if (column == CI_STAT_EXECUTE) {
                return spaceViewWrapper.getAmountOfExecuteOperations();
            }
            if (column == CI_MEMORY_USAGE) {
                return spaceViewWrapper.getMemoryUsageStr();
            }
            if (column == CI_CPU_USAGE) {
                return spaceViewWrapper.getCPUUsage() < 0.0 ? "n/a" : nfForCPU.format(spaceViewWrapper.getCPUUsage() * 100.0);
            }
            if (column == CI_REPLICATION_REDO_LOG) {
                return spaceViewWrapper.getReplicationRedoLogSize();
            }
            if (column == CI_REPLICATION_REDO_LOG_EXTERNAL_STORAGE_PACKET_COUNT) {
                return spaceViewWrapper.getReplicationRedoLogExternalStoragePacketCount();
            }
            if (column == CI_REPLICATION_REDO_LOG_EXTERNAL_STORAGE_SPACE_USED) {
                return spaceViewWrapper.getReplicationRedoLogExternalStorageSpaceUsed();
            }
            if (column == CI_REPLICATION_REDO_LOG_MEMORY_PACKET_COUNT) {
                return spaceViewWrapper.getReplicationRedoLogMemoryPacketCount();
            }
            if (column == CI_MIRROR_DISCARDED_OPERATIONS) {
                return spaceViewWrapper.getMirrorDiscardedOperations();
            }
            if (column == CI_MIRROR_FAILED_OPERATIONS) {
                return spaceViewWrapper.getMirrorFailedOperations();
            }
            if (column == CI_MIRROR_IN_PROGRESS_OPERATIONS) {
                return spaceViewWrapper.getMirrorInProgressOperations();
            }
            if (column == CI_MIRROR_SUCCESSFUL_OPERATIONS) {
                return spaceViewWrapper.getMirrorSuccessfulOperations();
            }
            if (column == CI_MIRROR_TOTAL_OPERATIONS) {
                return spaceViewWrapper.getMirrorTotalOperations();
            }
            if (column == CI_SUSPEND_TYPE) {
                return spaceViewWrapper.getSuspendType();
            }
            return SpacesViewPanel.COUNT_BLANK_VALUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reload() {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "@@@ Refresh Spaces Network Table. ");
            }
            List<SpaceViewWrapper> list = this._wrappersList;
            synchronized (list) {
                for (SpaceViewWrapper spaceViewWrapper : this._wrappersList) {
                    spaceViewWrapper.reload();
                }
                if (!this._wrappersList.isEmpty()) {
                    this.fireTableRowsUpdated(0, this._wrappersList.size() - 1);
                }
            }
        }
    }

    public class SpacesViewTable
    extends JTable
    implements ISpacesView {
        private SpacesViewTableModel _tableModel;

        public SpacesViewTable(SpacesViewTableModel tableModel) {
            super(tableModel);
            this._tableModel = tableModel;
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            int rowIndex;
            SpaceViewWrapper spaceViewWrapper;
            Point p;
            int columnIndex;
            if (!_jvmVersion.startsWith("1.4") && (columnIndex = this.columnAtPoint(p = event.getPoint())) >= 0 && columnIndex == SpacesViewTableModel.CI_MEMORY_USAGE && (spaceViewWrapper = this._tableModel.getWrapperAt(rowIndex = this.rowAtPoint(p))) != null) {
                if (!spaceViewWrapper.isJMXEnabled()) {
                    return "<HTML>The connections feature is disabled<BR>since the JMX support is disabled</HTML>";
                }
                String usedMemoryPercentStr = spaceViewWrapper.getMemoryUsagePercentageStr();
                String usedMemoryStatement = "Used memory " + usedMemoryPercentStr + ".";
                if (spaceViewWrapper.isMemoryManagerEnabled()) {
                    float memoryWriteBlockPercentageRatio = spaceViewWrapper.getMemoryWriteBlockPercentageRatio();
                    float memoryUsageLowPercentageRatio = spaceViewWrapper.getMemoryUsageLowPercentageRatio();
                    long maxMemory = spaceViewWrapper.getMaxMemory();
                    long memoryUsage = spaceViewWrapper.getMemoryUsage();
                    if (memoryWriteBlockPercentageRatio > 0.0f && memoryUsageLowPercentageRatio > 0.0f && (float)memoryUsage >= memoryUsageLowPercentageRatio * (float)maxMemory) {
                        if ((float)memoryUsage >= memoryWriteBlockPercentageRatio * (float)maxMemory) {
                            return "<HTML>" + usedMemoryStatement + "<BR>Breached the " + memoryWriteBlockPercentageRatio * 100.0f + "% write only block percentage.<HTML>";
                        }
                        return "<HTML>" + usedMemoryStatement + "<BR>Breached the " + memoryUsageLowPercentageRatio * 100.0f + "% low watermark percentage.</HTML>";
                    }
                }
                return usedMemoryStatement;
            }
            return null;
        }
    }
}

