/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.JSpaceProxyWrapper;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.lookup.entry.ContainerName;
import com.j_spaces.tools.IServiceManager;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;

public class SrvManager
extends GSThread
implements IServiceManager {
    final SpaceBrowser m_browser;
    final Vector<ServiceID> removedServices;
    final Hashtable<Object, ServiceItem> addedServices;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui.spacebrowser");

    public SrvManager(String threadName, SpaceBrowser browser) {
        super(threadName);
        this.m_browser = browser;
        this.removedServices = new Vector();
        this.addedServices = new Hashtable();
        this.start();
    }

    public SrvManager(SpaceBrowser browser) {
        this("UI-service-manager", browser);
    }

    @Override
    public void addService(ServiceItem si) {
        if (si.service != null) {
            if (_logger.isLoggable(Level.FINER)) {
                _logger.finer("%%% IN IF Add to removed services internal list: " + si);
            }
            this.addedServices.put(si.service, si);
            this.removedServices.remove(si.serviceID);
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.finer("%%% ADD SERVICE ! Add to added services internal list: " + si);
            String callTrace = JSpaceUtilities.getStackTrace((Throwable)new Exception());
            _logger.finer("%%% Before IF Debug call trace during adding service: " + callTrace);
        }
    }

    @Override
    public void removeService(ServiceID srvID, String clusterName) {
        Enumeration<ServiceItem> iter = this.addedServices.elements();
        while (iter.hasMoreElements()) {
            ServiceItem si = iter.nextElement();
            if (!si.serviceID.equals((Object)srvID)) continue;
            if (_logger.isLoggable(Level.FINER)) {
                _logger.finer("%%% SrvManager, REMOVE SERVICE, remove from added services: " + srvID);
            }
            this.addedServices.remove(si.service);
        }
        if (!this.removedServices.contains(srvID)) {
            if (_logger.isLoggable(Level.FINER)) {
                _logger.finer("%%% SrvManager, REMOVE SERVICE ! Add to removed services internal list: " + srvID);
                String callTrace = JSpaceUtilities.getStackTrace((Throwable)new Exception());
                _logger.finer("%%% SrvManager, Debug call trace during removing service: " + callTrace);
            }
            this.removedServices.add(srvID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block15: while (true) {
            try {
                if (!this.addedServices.isEmpty()) {
                    Enumeration<ServiceItem> iter = this.addedServices.elements();
                    while (iter.hasMoreElements()) {
                        Object service;
                        ServiceItem si = iter.nextElement();
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest("%%% WITHIN for() block, run method, service item: " + si);
                        }
                        if (this.m_browser.m_proxyServiceTable.containsKey(service = si.service)) continue;
                        try {
                            String containerName = ((ContainerName)JSpaceUtilities.getServiceItemLookupAttributeName((ServiceItem)si, ContainerName.class)).name;
                            if (containerName == null) continue;
                            try {
                                if (_logger.isLoggable(Level.FINER)) {
                                    _logger.finer("%%%^^ ADD SPACE NODE, service ID: " + si);
                                }
                                IDirectSpaceProxy space = (IDirectSpaceProxy)service;
                                this.m_browser.addSpaceNode(space.getContainer(), containerName, (IJSpace)space, si.serviceID, "jini:");
                                this.removeServiceFromAddedServicesMap(si);
                            }
                            catch (Exception ex) {
                                if (!_logger.isLoggable(Level.SEVERE)) continue;
                                _logger.log(Level.SEVERE, ex.toString(), ex);
                            }
                        }
                        catch (Exception ex) {
                            if (!_logger.isLoggable(Level.SEVERE)) continue;
                            _logger.log(Level.SEVERE, "Failed to add service to the browser space/cotainer tree: " + ex.toString(), ex);
                        }
                    }
                }
                if (this.removedServices.isEmpty()) continue;
                int i = 0;
                while (true) {
                    if (i >= this.removedServices.size()) continue block15;
                    ServiceID srvID = this.removedServices.remove(i);
                    DefaultMutableTreeNode serviceNode = this.m_browser.getServiceTreeeNode(srvID);
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest("%%%^^ IN FOR FOR REMOVED SERVICES, service ID: " + srvID + " , serviceNode=" + serviceNode);
                    }
                    if (serviceNode == null) {
                        this.removeServiceFromBrowser(srvID);
                    } else {
                        Object proxy = serviceNode.getUserObject();
                        if (!(proxy instanceof JSpaceProxyWrapper)) {
                            this.removeServiceFromBrowser(srvID);
                        } else {
                            if (_logger.isLoggable(Level.FINEST)) {
                                _logger.finest("%%%^^ REMOVE SPACE NODE, service ID: " + srvID);
                            }
                            this.m_browser.removeSpaceNode(srvID);
                        }
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.log(Level.FINE, ex.toString(), ex);
                continue;
            }
            finally {
                try {
                    if (this.addedServices.isEmpty() && this.removedServices.isEmpty()) {
                        Thread.sleep(1000L);
                        continue;
                    }
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
    }

    private void removeServiceFromBrowser(ServiceID serviceID) {
        this.m_browser.removeContainerTree(serviceID);
        this.m_browser.removeSpaceNode(serviceID);
    }

    private void removeServiceFromAddedServicesMap(ServiceItem si) {
        ServiceItem removedServiceItem = this.addedServices.remove(si.service);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("--Service Item was successfully removed from addedServices hashtable: " + removedServiceItem);
        }
    }
}

