/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.IJSpaceContainerAdmin;
import com.j_spaces.core.admin.LostConnectionException;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.client.JSpaceContainerProxyWrapper;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.StaleContainerService;
import com.j_spaces.tools.spacebrowser.StaleSpaceService;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;

public class StaleServiceCleanerThread
implements Runnable {
    private SpaceBrowser m_browser;
    private MainUI _mainUI;
    boolean m_pause;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui.spacebrowser");
    private Vector staleServiceTable = new Vector();

    public StaleServiceCleanerThread(SpaceBrowser sb) {
        this.m_browser = sb;
        this._mainUI = this.m_browser.getParentFrame();
    }

    public synchronized void wakeUp() {
        this.m_pause = false;
        this.notify();
    }

    public void gotoSleep() {
        this.m_pause = true;
    }

    public void addServiceNode(DefaultMutableTreeNode staleNode) {
        this.staleServiceTable.add(staleNode);
    }

    public void pingRegisteredProxy() {
        Hashtable proxyTable = (Hashtable)this.m_browser.m_proxyServiceTable.clone();
        ArrayList staleSrv = new ArrayList(proxyTable.size());
        for (Object serviceProxy : proxyTable.keySet()) {
            if (!(serviceProxy instanceof IDirectSpaceProxy)) continue;
            try {
                ((IJSpace)serviceProxy).ping();
            }
            catch (Exception ex) {
                this.m_browser.debug(ex);
                if (!(ex instanceof RuntimeException) && !(ex instanceof RemoteException) && !(ex instanceof LostConnectionException)) continue;
                staleSrv.add(serviceProxy);
            }
        }
        for (IJSpace space : staleSrv) {
            ServiceID spaceServiceID = JSpaceUtilities.getSpaceServiceID((IJSpace)space);
            ServiceItem spaceServiceItem = Repository.getInstance().getServiceItem(spaceServiceID);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(">>> StaleServiceContainer, ping failed for space, service ServiceID=" + spaceServiceID + ", space service item=" + spaceServiceItem);
            }
            if (spaceServiceItem != null) {
                this._mainUI.serviceRemoved(spaceServiceItem, true, false);
                continue;
            }
            this.m_browser.removeSpaceNode(space);
        }
        staleSrv.clear();
        proxyTable.clear();
        proxyTable = null;
        staleSrv = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Object removedNode;
                    block25: {
                        DefaultMutableTreeNode root;
                        block27: {
                            DefaultMutableTreeNode parentOfRemovedNode;
                            block26: {
                                Object staleService;
                                StaleServiceCleanerThread staleServiceCleanerThread = this;
                                synchronized (staleServiceCleanerThread) {
                                    if (this.m_pause) {
                                        this.wait();
                                    }
                                    if (this.staleServiceTable.size() <= 0) break block25;
                                }
                                parentOfRemovedNode = null;
                                DefaultTreeModel model = (DefaultTreeModel)this.m_browser.conTree.getModel();
                                root = (DefaultMutableTreeNode)model.getRoot();
                                for (int i = 0; i < this.staleServiceTable.size(); ++i) {
                                    removedNode = (DefaultMutableTreeNode)this.staleServiceTable.remove(i);
                                    staleService = ((DefaultMutableTreeNode)removedNode).getUserObject();
                                    if (staleService instanceof StaleSpaceService) {
                                        Hashtable<String, SpaceConfig> hashtable = this.m_browser.spaceConfigPanel.conConfigTable.get(((StaleSpaceService)staleService).getContainerName());
                                        if (hashtable != null) {
                                            hashtable.remove(((StaleSpaceService)staleService).getSpaceName());
                                        }
                                        this.m_browser.showStatus("<" + ((StaleSpaceService)staleService).getSpaceName() + "> space was destroyed in <" + ((StaleSpaceService)staleService).getContainerName() + "> container.");
                                    } else {
                                        this.m_browser.cleanContainerTables(((StaleContainerService)staleService).getContainerName(), true);
                                        this.m_browser.showStatus("<" + ((StaleContainerService)staleService).getContainerName() + "> container was shutdowned.");
                                    }
                                    DefaultTreeModel defaultTreeModel = model;
                                    synchronized (defaultTreeModel) {
                                        parentOfRemovedNode = (DefaultMutableTreeNode)((DefaultMutableTreeNode)removedNode).getParent();
                                        if (parentOfRemovedNode != null) {
                                            if (_logger.isLoggable(Level.FINEST)) {
                                                int childCount = parentOfRemovedNode.getChildCount();
                                                _logger.finest("1. CHILD COUNT:" + childCount);
                                                _logger.finest("%%%^^ REMOVE NODE FROM TREE MODEL:" + removedNode + " , hashCode:" + removedNode.hashCode());
                                                if (childCount > 0) {
                                                    _logger.finest("%%%^^ CURRENT CHILD NODE HASH CODE:" + parentOfRemovedNode.getChildAt(0).hashCode());
                                                }
                                            }
                                            model.removeNodeFromParent((MutableTreeNode)removedNode);
                                            if (_logger.isLoggable(Level.FINEST)) {
                                                _logger.finest("2. CHILD COUNT:" + parentOfRemovedNode.getChildCount());
                                            }
                                        }
                                        continue;
                                    }
                                }
                                DefaultMutableTreeNode selectedNode = this.m_browser.getSelectedTreeNode();
                                if (selectedNode != null && !(selectedNode.getUserObject() instanceof StaleContainerService) && !(selectedNode.getUserObject() instanceof StaleSpaceService) && !(((DefaultMutableTreeNode)selectedNode.getParent()).getUserObject() instanceof StaleSpaceService)) continue;
                                if (root.getChildCount() != 0) break block26;
                                staleService = model;
                                synchronized (staleService) {
                                    root.removeAllChildren();
                                    root.setUserObject(this.m_browser.localhost);
                                    this.m_browser.conTree.setRootVisible(true);
                                    model.reload();
                                    this.m_browser.updateContainerConfig(null);
                                }
                                this.m_browser.showStatus("Connection with Server lost! Reason: The Server may be shudowned or restarted.");
                                break block25;
                            }
                            if (parentOfRemovedNode.isRoot()) break block27;
                            this.m_browser.setSelectedTreeNode(parentOfRemovedNode, true, true);
                            Object parentUserObject = parentOfRemovedNode.getUserObject();
                            if (parentUserObject instanceof JSpaceContainerProxyWrapper) {
                                void var7_15;
                                IJSpaceContainerAdmin iJSpaceContainerAdmin = (IJSpaceContainerAdmin)((JSpaceContainerProxyWrapper)parentUserObject).proxy();
                                try {
                                    iJSpaceContainerAdmin.getName();
                                }
                                catch (Exception ex) {
                                    Object var7_14 = null;
                                }
                                this.m_browser.updateContainerConfig((IJSpaceContainerAdmin)var7_15);
                            }
                            break block25;
                        }
                        DefaultMutableTreeNode firstNode = (DefaultMutableTreeNode)root.getFirstChild();
                        this.m_browser.setSelectedTreeNode(firstNode, true, true);
                        Object object = firstNode.getUserObject();
                        if (object instanceof JSpaceContainerProxyWrapper) {
                            this.m_browser.updateContainerConfig((IJSpaceContainerAdmin)((JSpaceContainerProxyWrapper)object).proxy());
                        }
                    }
                    this.pingRegisteredProxy();
                    this.m_browser.getParentFrame().repaint();
                    removedNode = this;
                    synchronized (removedNode) {
                        this.wait(5000L);
                    }
                }
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.log(Level.FINE, ex.toString(), ex);
                continue;
            }
            break;
        }
    }

    private boolean isNodeInPath(TreePath treePath, DefaultMutableTreeNode node) {
        if (treePath != null) {
            Object[] selPath = treePath.getPath();
            for (int i = 0; i < selPath.length; ++i) {
                if (!node.equals(selPath[i])) continue;
                return true;
            }
        }
        return false;
    }
}

