/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.gigaspaces.internal.metadata.ITypeDesc;
import com.j_spaces.core.admin.TemplateInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import org.pf.joi.Inspector;

public class TemplatesInfoPanel
extends JPanel {
    private JTable _templatesTable;
    private TemplatesTableModel _templatesTableModel;
    private static final int CI_LEASE = 0;
    private static final int CI_IS_FIFO = 1;
    private static final int CI_WAITING_UID = 2;
    private JTextField _classNameField = new JTextField();
    private JTextField _templatesCountField = new JTextField();
    private JFrame _parentFrame;
    private ITypeDesc _basicTypeInfo;
    private String _className;
    private DateFormat df = DateFormat.getDateTimeInstance(2, 1);

    public TemplatesInfoPanel(JFrame parentFrame) {
        this._parentFrame = parentFrame;
        this.initUI();
    }

    private void initUI() {
        this._templatesTableModel = new TemplatesTableModel();
        this._templatesTable = new JTable(this._templatesTableModel);
        JTableHeader header = this._templatesTable.getTableHeader();
        header.setReorderingAllowed(false);
        this._templatesTable.setAutoCreateColumnsFromModel(false);
        this._templatesTable.setSelectionMode(0);
        this._templatesTable.setAutoResizeMode(1);
        this._templatesTable.setAutoscrolls(true);
        TableColumnModel tableColummModel = this._templatesTable.getColumnModel();
        tableColummModel.getColumn(0).setPreferredWidth(50);
        tableColummModel.getColumn(1).setPreferredWidth(50);
        JScrollPane tableScrollPane = new JScrollPane(this._templatesTable);
        Box northBox = this.createLabelsNorthBox();
        this.setLayout(new BorderLayout());
        this.add((Component)northBox, "North");
        this.add((Component)tableScrollPane, "Center");
        this.addMouseListenerToTable();
        this.setPreferredSize(new Dimension(500, 170));
    }

    private Box createLabelsNorthBox() {
        this._classNameField.setEditable(false);
        this._templatesCountField.setEditable(false);
        Dimension fieldSize = new Dimension(280, 21);
        this._classNameField.setPreferredSize(fieldSize);
        this._templatesCountField.setPreferredSize(fieldSize);
        Box northBox = new Box(1);
        JLabel classNameLabel = new JLabel("Data Type Name:");
        JLabel templatesCountLabel = new JLabel("Templates Count:");
        Dimension labelSize1 = new Dimension(105, 21);
        classNameLabel.setPreferredSize(labelSize1);
        templatesCountLabel.setPreferredSize(labelSize1);
        Box firstHorizBox = new Box(0);
        Box secondHorizBox = new Box(0);
        firstHorizBox.add(Box.createHorizontalStrut(3));
        firstHorizBox.add(classNameLabel);
        firstHorizBox.add(Box.createHorizontalStrut(3));
        firstHorizBox.add(this._classNameField);
        firstHorizBox.add(Box.createHorizontalStrut(5));
        secondHorizBox.add(Box.createHorizontalStrut(3));
        secondHorizBox.add(templatesCountLabel);
        secondHorizBox.add(Box.createHorizontalStrut(3));
        secondHorizBox.add(this._templatesCountField);
        secondHorizBox.add(Box.createHorizontalStrut(5));
        northBox.add(Box.createVerticalStrut(4));
        northBox.add(firstHorizBox);
        northBox.add(Box.createVerticalStrut(4));
        northBox.add(secondHorizBox);
        northBox.add(Box.createVerticalStrut(4));
        return northBox;
    }

    public void clear() {
        this._classNameField.setText("");
        this._templatesCountField.setText("");
        this._templatesTableModel.clear();
    }

    private void addMouseListenerToTable() {
        this._templatesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    int clickedRow = TemplatesInfoPanel.this._templatesTable.rowAtPoint(event.getPoint());
                    TemplateInfo selectedTemplateInfo = TemplatesInfoPanel.this._templatesTableModel.getTemplateInfoAt(clickedRow);
                    if (selectedTemplateInfo != null) {
                        final Object[] valuesArray = selectedTemplateInfo.getValues();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    String[] fieldNames = TemplatesInfoPanel.this._basicTypeInfo.getPropertiesNames();
                                    String[] fieldTypes = TemplatesInfoPanel.this._basicTypeInfo.getPropertiesTypes();
                                    TemplatesInfoPanel.this._parentFrame.setCursor(Cursor.getPredefinedCursor(3));
                                    Inspector.inspect("Template", valuesArray, fieldNames, fieldTypes, TemplatesInfoPanel.this._className);
                                }
                                finally {
                                    TemplatesInfoPanel.this._parentFrame.setCursor(Cursor.getPredefinedCursor(0));
                                }
                            }
                        });
                    }
                }
            }
        });
    }

    public void displayTemplates(String className, ITypeDesc basicTypeInfo, List<TemplateInfo> templateInfoList) {
        this._classNameField.setText(className);
        this._templatesCountField.setText(String.valueOf(templateInfoList.size()));
        this._basicTypeInfo = basicTypeInfo;
        this._className = className;
        this._templatesTableModel.setTemplatesList(templateInfoList);
    }

    private class TemplatesTableModel
    extends DefaultTableModel {
        private String[] _columnNames = new String[]{"Expires At", "Is Fifo", "Waiting UID"};
        private List<TemplateInfo> _templatesInfoList = new ArrayList<TemplateInfo>(1);

        private TemplatesTableModel() {
        }

        public void clear() {
            int listSize = this._templatesInfoList.size();
            if (listSize > 0) {
                this._templatesInfoList.clear();
                this.fireTableRowsDeleted(0, listSize - 1);
            }
        }

        @Override
        public Object getValueAt(int row, int column) {
            TemplateInfo templateInfo = this._templatesInfoList.get(row);
            if (templateInfo != null) {
                return this.getCellValue(templateInfo, column);
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public int getColumnCount() {
            return this._columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this._columnNames[column];
        }

        public Class getColumnClass(int columnIndex) {
            Object obj = this.getValueAt(0, columnIndex);
            if (obj != null) {
                return obj.getClass();
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this._templatesInfoList == null ? 0 : this._templatesInfoList.size();
        }

        public TemplateInfo getTemplateInfoAt(int row) {
            return this._templatesInfoList.get(row);
        }

        private String getCellValue(TemplateInfo templateInfo, int column) {
            switch (column) {
                case 0: {
                    Date expiredAtDate = templateInfo.getExpiresAt();
                    return expiredAtDate == null ? "" : TemplatesInfoPanel.this.df.format(expiredAtDate);
                }
                case 1: {
                    return templateInfo.isFIFO() ? "Yes" : "No";
                }
                case 2: {
                    return templateInfo.getWaitingUID() == null ? "" : templateInfo.getWaitingUID();
                }
            }
            return "";
        }

        public void setTemplatesList(List<TemplateInfo> templateInfoList) {
            int initialListSize1 = this._templatesInfoList.size();
            int initialListSize2 = templateInfoList.size();
            if (initialListSize1 > 0) {
                this._templatesInfoList.clear();
                this.fireTableRowsDeleted(0, initialListSize1 - 1);
            }
            this._templatesInfoList = templateInfoList;
            if (initialListSize2 > 0) {
                this.fireTableRowsInserted(0, initialListSize2 - 1);
            }
        }
    }
}

