/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import java.awt.Toolkit;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class WholeNumberField
extends JTextField {
    private static Toolkit toolkit;
    private static NumberFormat integerFormatter;
    private boolean integerOnly;
    private int _minPossibleValue = -1;
    private int _maxPossibleValue = -1;

    public WholeNumberField(boolean integerOnly, int minPossibleValue, int maxPossibleValue) {
        this.integerOnly = integerOnly;
        integerFormatter = NumberFormat.getNumberInstance(Locale.US);
        integerFormatter.setParseIntegerOnly(integerOnly);
        toolkit = Toolkit.getDefaultToolkit();
        if (minPossibleValue >= 0) {
            this._minPossibleValue = minPossibleValue;
        }
        if (maxPossibleValue >= 0) {
            this._maxPossibleValue = maxPossibleValue;
        }
    }

    public WholeNumberField(boolean integerOnly, int minPossibleValue) {
        this(integerOnly, minPossibleValue, -1);
    }

    public WholeNumberField(boolean integerOnly) {
        this(integerOnly, -1);
    }

    public WholeNumberField() {
        this(true);
    }

    public float getValueFloat() {
        float retVal = 0.0f;
        try {
            retVal = integerFormatter.parse(this.getText()).floatValue();
        }
        catch (ParseException e) {
            toolkit.beep();
        }
        return retVal;
    }

    public int getValueInt() {
        int retVal = 0;
        try {
            retVal = integerFormatter.parse(this.getText()).intValue();
        }
        catch (ParseException e) {
            toolkit.beep();
        }
        return retVal;
    }

    public void setValueInt(int value) {
        this.setText(integerFormatter.format(value));
    }

    public void setValueFloat(float value) {
        this.setText(integerFormatter.format(value));
    }

    @Override
    protected Document createDefaultModel() {
        return new WholeNumberDocument();
    }

    protected class WholeNumberDocument
    extends PlainDocument {
        protected WholeNumberDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            char[] source = str.toCharArray();
            char[] result = new char[source.length];
            int j = 0;
            if (this.isNumberGreaterThanMinPossibleValue(str) && this.isNumberLessThanMaxPossibleValue(str)) {
                for (int i = 0; i < result.length; ++i) {
                    if (Character.isDigit(source[i]) || source[i] == '.' && !WholeNumberField.this.integerOnly) {
                        result[j++] = source[i];
                        continue;
                    }
                    if (source[i] == ',') continue;
                    toolkit.beep();
                }
                super.insertString(offs, new String(result, 0, j), a);
            } else {
                toolkit.beep();
            }
        }

        private boolean isNumberGreaterThanMinPossibleValue(String str) throws BadLocationException {
            if (WholeNumberField.this._minPossibleValue > -1) {
                String compareVal = "";
                compareVal = this.getLength() == 0 ? str : this.getText(0, this.getLength()) + str;
                boolean returnedVal = false;
                try {
                    int num = Integer.parseInt(compareVal);
                    returnedVal = num >= WholeNumberField.this._minPossibleValue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return returnedVal;
            }
            return true;
        }

        private boolean isNumberLessThanMaxPossibleValue(String str) throws BadLocationException {
            if (WholeNumberField.this._maxPossibleValue > -1) {
                String compareVal = "";
                compareVal = this.getLength() == 0 ? str : this.getText(0, this.getLength()) + str;
                boolean returnedVal = false;
                try {
                    int num = Integer.parseInt(compareVal);
                    returnedVal = num <= WholeNumberField.this._maxPossibleValue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return returnedVal;
            }
            return true;
        }
    }
}

