/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser.benchmark;

import com.gigaspaces.admin.cli.RuntimeInfo;
import com.gigaspaces.admin.security.SecurityServicesRepository;
import com.gigaspaces.admin.ui.AdminUIThreadPool;
import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.SpaceProxyImpl;
import com.gigaspaces.security.service.SecuredService;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.IJSpaceContainerAdmin;
import com.j_spaces.core.client.SpaceFinder;
import com.j_spaces.examples.benchmark.BenchmarkListener;
import com.j_spaces.examples.benchmark.BenchmarkOutput;
import com.j_spaces.examples.benchmark.BenchmarkTest;
import com.j_spaces.examples.benchmark.BenchmarkUtils;
import com.j_spaces.examples.benchmark.MessageAdaptor;
import com.j_spaces.examples.benchmark.MessageAdaptors;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.map.CacheFinder;
import com.j_spaces.map.IMap;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.benchmark.BenchMarkPanel;
import com.j_spaces.tools.spacebrowser.benchmark.BenchmarkGUIConfiguration;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.traces.Trace2DLtd;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GigaBenchmark
implements BenchmarkOutput,
ActionListener,
ItemListener,
BenchmarkListener {
    private JLabel commitLabel2;
    private JLabel commitLabel1;
    private JFrame parentFrame;
    private JButton stopBtn;
    private JButton startBtn;
    private JButton clearConsoleBtn;
    private JButton chooseBtn;
    private JTextArea consoleOutput;
    private JTextField fNameTextField;
    private JSpinner timeout;
    private JSpinner entrySize;
    private JSpinner batchSize;
    private JSpinner noOfIterations;
    private JSpinner noOfThreads;
    private JSpinner showRate;
    private JSpinner noOfReadOps;
    private JSpinner commitEveryTx;
    private JSpinner samplesBufferSize;
    private JSpinner leaseTime;
    private JTable table;
    private DefaultTableModel tableModel;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private ButtonGroup buttonGroup_2 = new ButtonGroup();
    private ButtonGroup operationGroup = new ButtonGroup();
    private JCheckBox cleanSpace;
    private JCheckBox parallelOps;
    private JCheckBox saveToFileCB;
    private JCheckBox displayThreadsTP;
    private JCheckBox masterLocalCacheCB;
    private JCheckBox returnLeaseCB;
    private JCheckBox foreverLease;
    private JCheckBox clusteredProxyCheckBox;
    private JComboBox objectTypesCombo;
    private JRadioButton writeTakeOp;
    private JRadioButton writeReadOp;
    private JRadioButton writeNotifyOp;
    private JRadioButton writeOp;
    private JRadioButton takeOp;
    private JRadioButton readOp;
    private JRadioButton noTX;
    private JRadioButton embeddedTX;
    private JRadioButton distributedTX;
    private JTextField txnManagerHostNameField;
    private JLabel txnManagerHostNameLabel;
    private ButtonGroup mapGroup;
    private JRadioButton putRadio;
    private JRadioButton getRadio;
    private JRadioButton removeRadio;
    private JRadioButton putRemRadio;
    private JRadioButton putGetRadio;
    private JRadioButton javaSpaceRadio;
    private JRadioButton mapRadio;
    private JLabel fNameLabel;
    private JLabel noOfReadLabel;
    private JLabel samplsLabel = new JLabel("Sampling rate:");
    private JLabel samplingRateUnitLabel = new JLabel("000");
    private JLabel batchsLabel = new JLabel("Batches:");
    private JProgressBar progressBar;
    private Chart2D chart;
    private Trace2DLtd globalTrace;
    private final HashMap<String, Trace2DLtd> threadTraces = new HashMap();
    private String theURL;
    private static final int INIT_PROGRESS_VALUE = 10;
    private JButton saveConfigurationButton;
    int _noOfIterations = 0;
    int _noOfReadOps = 0;
    int totalOperations = 0;
    static final int componentHeight = 20;
    private final PrintStream aPrintStream = new PrintStream(new FilteredStream(new ByteArrayOutputStream()));
    BenchmarkTest benchmark = null;
    private JLabel graphLabel = new JLabel();
    private static DefaultComboBoxModel comboBoxModel;
    private JComboBox configurationsCombo;
    private JButton renameConfigurationButton;
    private JButton newConfigurationButton;
    private JButton deleteConfigurationButton;
    private JTextArea objectTypeDescription = new JTextArea();
    private static final String OP_NAME_JAVASPACE = "JavaSpace";
    private static final String OP_NAME_MAP = "Map";
    private static final String ARGUMENT_NAME_TAKE = "-take";
    private static final String ARGUMENT_NAME_READ = "-read";
    private static final String ARGUMENT_NAME_NOTIFY = "-notify";
    private static final String ARGUMENT_NAME_MAP = "-map";
    private static final String ARGUMENT_NAME_ONLY = "-execute";
    private static final String ARGUMENT_NAME_SECOND = "second";
    private static final String ARGUMENT_NAME_FIRST = "first";
    public static GigaBenchmark window;
    private ArrayList<String> args = new ArrayList();
    private final ArrayList<Color> colors = new ArrayList();
    private Iterator<Color> colorsIterator;
    private IJSpace theSpace = null;
    private IJSpace regularSpaceProxy = null;
    private SpaceProxyImpl clusteredSpaceProxy = null;
    private String _spaceName;
    private String _containerName;
    private String _hostName = "localhost";
    private String _curSpaceURL;
    private IMap theCache = null;
    private static final int LABEL_WITH = 110;
    private static final int LABEL_HIGH = 20;
    private static final int SPINNER_WITH = 70;
    private static final int SPINNER_HIGH = 20;
    private static final Integer DEFAULT_REGULAR_TIMEOUT;
    private static final Integer DEFAULT_PARALLEL_TIMEOUT;
    private static final Map<String, BenchmarkGUIConfiguration> allConfigurationsMap;
    private static final Vector<String> allConfigNamesVector;
    private static final String locationDirPath;
    private static final String configFileExtension = ".xml";
    private static final String DEFAULT_CONFIG_NAME = "default";
    private static final String ROOT_NAME = "benchmarkConfig";
    private static final String ELEMENT_NAME = "name";
    private static final String OPTION_TAG_NAME = "option";
    private static final String NAME_ATTR_NAME = "name";
    private static final String VALUE_ATTR_NAME = "value";
    private static final String NAME_THREADS = "Threads";
    private static final String NAME_ITERATIONS = "Iterations";
    private static final String NAME_ENTRY_SIZE = "EntrySize";
    private static final String NAME_SAMPLING_RATE = "SamplingRate";
    private static final String NAME_BATCH_SIZE = "BatchSize";
    private static final String NAME_READ_TAKE_TIMEOUT = "ReadTakeTimeout";
    private static final String NAME_OBJECT_TYPE = "ObjectType";
    private static final String NAME_NO_WRITE_LEASE = "NoWriteLease";
    private static final String NAME_FOREVER_LEASE = "ForeverLease";
    private static final String NAME_LEASE_TIME = "LeaseTime";
    private static final String NAME_CLUSTERED_PROXY = "ClusteredProxy";
    private static final String NAME_DISPLAY_THREADS_THROUGHPUT = "DisplayThreadsThroughput";
    private static final String NAME_CLEAN_SPACE = "CleanSpace";
    private static final String NAME_OPERATION_TYPE = "OperationType";
    private static final String NAME_OPERATION_NAME = "OperationName";
    private static final String NAME_PARALLEL_OPERATIONS = "ParallelOperations";
    private static final String NAME_REPEAT_READ = "RepeatRead";
    private static final String NAME_TRANSACTION_TYPE = "TransactionType";
    private static final String NAME_COMMIT_EVERY = "CommitEvery";
    private static final String NAME_DISTRIB_TXN_MANAGER_URL = "DistribTransactionManagerURL";
    private static final String NAME_MASTER_LOCAL_CACHE = "MasterLocalCache";
    private static final String NAME_CACHE_TYPE = "CacheType";
    private final ObjectTypeItem[] objectTypeItems = this.initTypeItems();
    private final Map<String, ObjectTypeItem> objectTypeItemsMap = new HashMap<String, ObjectTypeItem>();
    private static final Logger _logger;
    private static final String NAME_SAVE_RESULTS_TO_FILE = "SaveResultsToFile";
    private static final String NAME_FILE_NAME = "FileName";
    private ConfigurationNameDialog renameConfigurationDialog;
    private ConfigurationNameDialog newConfigurationDialog;
    private static DocumentBuilderFactory factory;
    private static DocumentBuilder builder;
    private BenchMarkPanel _benchMarkPanel;
    private boolean _isClusterView;
    private static JFileChooser chooser;
    private boolean isBatchOperation;

    private ObjectTypeItem[] initTypeItems() {
        MessageAdaptor[] adaptors = MessageAdaptors.getMessageAdaptors();
        ObjectTypeItem[] items = new ObjectTypeItem[adaptors.length];
        for (int i = 0; i < items.length; ++i) {
            items[i] = new ObjectTypeItem(adaptors[i]);
        }
        return items;
    }

    public void restore() {
        window = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GigaBenchmark(JFrame parentFrame, BenchMarkPanel parentPanel, IJSpace spaceProxy, boolean isClusterView) {
        window = this;
        this.parentFrame = parentFrame;
        this._benchMarkPanel = parentPanel;
        this._isClusterView = isClusterView;
        for (ObjectTypeItem objectTypeItem : this.objectTypeItems) {
            this.objectTypeItemsMap.put(objectTypeItem.getMessageTypeParameterName(), objectTypeItem);
        }
        boolean isClustered = isClusterView;
        try {
            if (spaceProxy != null) {
                isClustered = this.initSpaceProxies(spaceProxy);
            }
            this.initialize(parentPanel, isClustered);
        }
        catch (Exception ex) {
            SpaceBrowser.showException(ex.toString(), ex);
        }
        finally {
            if (!isClustered) {
                this.clusteredProxyCheckBox.setSelected(false);
            }
        }
        this.colors.add(Color.BLUE);
        this.colors.add(Color.GREEN);
        this.colors.add(Color.YELLOW);
        this.colors.add(Color.MAGENTA);
        this.colors.add(Color.CYAN);
        this.colors.add(Color.DARK_GRAY);
        this.colors.add(Color.ORANGE);
        this.colors.add(Color.PINK);
        this.colorsIterator = this.colors.iterator();
    }

    protected boolean initSpaceProxies(IJSpace spaceProxy) throws Exception {
        boolean isClustered = false;
        if (spaceProxy != null) {
            this._spaceName = spaceProxy.getName();
            IJSpaceContainerAdmin containerAdmin = (IJSpaceContainerAdmin)spaceProxy.getDirectProxy().getContainer();
            this._containerName = containerAdmin.getName();
            if (((ISpaceProxy)spaceProxy).isClustered()) {
                this.clusteredSpaceProxy = (SpaceProxyImpl)spaceProxy;
                this.regularSpaceProxy = this.clusteredSpaceProxy.getNonClusteredProxy();
                isClustered = true;
            } else {
                this.regularSpaceProxy = spaceProxy;
            }
        }
        return isClustered;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object source = itemEvent.getSource();
        if (source == this.configurationsCombo) {
            if (itemEvent.getStateChange() == 1) {
                String selName = itemEvent.getItem().toString();
                boolean isDefaultConfigSelected = selName.equals(DEFAULT_CONFIG_NAME);
                this.renameConfigurationButton.setEnabled(!isDefaultConfigSelected);
                this.deleteConfigurationButton.setEnabled(!isDefaultConfigSelected);
                BenchmarkGUIConfiguration benchmarkGUIConfiguration = allConfigurationsMap.get(selName);
                this.initPanel(benchmarkGUIConfiguration);
            }
        } else if (source == this.objectTypesCombo && itemEvent.getStateChange() == 1) {
            String selTypeDescription = ((ObjectTypeItem)itemEvent.getItem()).getMessageTypeParameterDescription();
            this.objectTypeDescription.setText(selTypeDescription);
        }
    }

    private void initPanel(BenchmarkGUIConfiguration benchmarkGUIConfiguration) {
        if (benchmarkGUIConfiguration == null) {
            return;
        }
        this.noOfThreads.setValue(benchmarkGUIConfiguration.getThreadsNumber());
        this.noOfIterations.setValue(benchmarkGUIConfiguration.getIterationsNumber());
        this.entrySize.setValue(benchmarkGUIConfiguration.getEntrySize());
        this.showRate.setValue(benchmarkGUIConfiguration.getSamplingRate());
        this.batchSize.setValue(benchmarkGUIConfiguration.getBatchesNumber());
        this.timeout.setValue(benchmarkGUIConfiguration.getReadTakeTimeout());
        ObjectTypeItem objType = this.objectTypeItemsMap.get(benchmarkGUIConfiguration.getObjectType());
        if (objType == null) {
            this.objectTypesCombo.setSelectedIndex(0);
        } else {
            this.objectTypesCombo.setSelectedItem(objType);
        }
        boolean isForeverLease = benchmarkGUIConfiguration.isForeverLease();
        this.returnLeaseCB.setSelected(benchmarkGUIConfiguration.isNoWriteLease());
        this.foreverLease.setSelected(isForeverLease);
        this.leaseTime.setEnabled(!isForeverLease);
        if (!isForeverLease) {
            this.leaseTime.setValue(benchmarkGUIConfiguration.getLeaseTime());
        } else {
            this.leaseTime.setValue(((SpinnerNumberModel)this.leaseTime.getModel()).getMinimum());
        }
        this.clusteredProxyCheckBox.setSelected(benchmarkGUIConfiguration.isClusteredProxy());
        this.displayThreadsTP.setSelected(benchmarkGUIConfiguration.isDisplayThreadsThroughput());
        this.cleanSpace.setSelected(benchmarkGUIConfiguration.isCleanSpace());
        String operationType = benchmarkGUIConfiguration.getOperationType();
        String operationName = benchmarkGUIConfiguration.getOperationName();
        if (operationType.equals(OP_NAME_JAVASPACE)) {
            this.javaSpaceRadio.setSelected(true);
            if (operationName.equals("Write")) {
                this.writeOp.setSelected(true);
            } else if (operationName.equals("Read")) {
                this.readOp.setSelected(true);
            } else if (operationName.equals("Take")) {
                this.takeOp.setSelected(true);
            } else if (operationName.equals("WriteAndRead")) {
                this.writeReadOp.setSelected(true);
            } else if (operationName.equals("WriteAndTake")) {
                this.writeTakeOp.setSelected(true);
            } else if (operationName.equals("WriteAndNotify")) {
                this.writeNotifyOp.setSelected(true);
            }
            this.selectJavaSpaceRB();
        } else {
            this.mapRadio.setSelected(true);
            if (operationName.equals("Put")) {
                this.putRadio.setSelected(true);
            } else if (operationName.equals("Get")) {
                this.getRadio.setSelected(true);
            } else if (operationName.equals("Remove")) {
                this.removeRadio.setSelected(true);
            } else if (operationName.equals("PutAndGet")) {
                this.putGetRadio.setSelected(true);
            } else if (operationName.equals("PutAndRemove")) {
                this.putRemRadio.setSelected(true);
            }
            this.selectMapRB();
        }
        this.parallelOps.setSelected(benchmarkGUIConfiguration.isParallelOperations());
        this.noOfReadOps.setValue(benchmarkGUIConfiguration.getRepeatOperationsNumber());
        String transactionType = benchmarkGUIConfiguration.getTransactionType();
        if (transactionType.equals("None")) {
            this.noTX.setSelected(true);
            this.commitEveryTx.setEnabled(false);
        } else if (transactionType.equals("Embedded")) {
            this.embeddedTX.setSelected(true);
            this.commitEveryTx.setEnabled(true);
        } else {
            this.distributedTX.setSelected(true);
            this.commitEveryTx.setEnabled(true);
        }
        boolean isDistribTxnManager = transactionType.equals("Distributed");
        this.txnManagerHostNameField.setEnabled(isDistribTxnManager);
        this.txnManagerHostNameLabel.setEnabled(isDistribTxnManager);
        this.txnManagerHostNameField.setText(isDistribTxnManager ? benchmarkGUIConfiguration.getDistribTxnManagerURL() : "");
        if (!transactionType.equals("None")) {
            this.commitEveryTx.setValue(benchmarkGUIConfiguration.getCommitFrequency());
        } else {
            this.commitEveryTx.setValue(((SpinnerNumberModel)this.commitEveryTx.getModel()).getMinimum());
        }
        boolean isMasterLocalCache = benchmarkGUIConfiguration.isMasterLocalCache();
        this.masterLocalCacheCB.setSelected(isMasterLocalCache);
        boolean isSaveResultsToFile = benchmarkGUIConfiguration.isSaveResultsToFile();
        this.saveToFileCB.setSelected(isSaveResultsToFile);
        this.fNameTextField.setText(benchmarkGUIConfiguration.getFileName());
        this.fNameLabel.setEnabled(isSaveResultsToFile);
        this.fNameTextField.setEnabled(isSaveResultsToFile);
        this.chooseBtn.setEnabled(isSaveResultsToFile);
        this.handleSamplingRateState();
    }

    private void handleSamplingRateState() {
        int bathcesAmount = (Integer)this.batchSize.getValue();
        this.showRate.setEnabled(bathcesAmount == 0);
        this.samplingRateUnitLabel.setEnabled(bathcesAmount == 0);
        this.samplsLabel.setEnabled(bathcesAmount == 0);
    }

    private void selectJavaSpaceRB() {
        this.setButtonGroupEnabled(this.buttonGroup, true);
        this.setButtonGroupEnabled(this.mapGroup, false);
        this.batchsLabel.setEnabled(true);
        this.batchSize.setEnabled(true);
        this.handleSamplingRateState();
        this.objectTypesCombo.setEnabled(true);
        boolean isDoubleOperation = this.writeReadOp.isSelected() || this.writeTakeOp.isSelected() || this.writeNotifyOp.isSelected();
        this.parallelOps.setEnabled(isDoubleOperation);
        if (!isDoubleOperation) {
            this.parallelOps.setSelected(false);
            this.timeout.setValue(DEFAULT_REGULAR_TIMEOUT);
        }
        if (this.writeOp.isSelected() || this.writeTakeOp.isSelected() || this.takeOp.isSelected()) {
            this.noOfReadOps.setEnabled(false);
            this.noOfReadLabel.setEnabled(false);
        } else {
            this.noOfReadOps.setEnabled(true);
            this.noOfReadLabel.setEnabled(true);
        }
    }

    private void selectMapRB() {
        this.setButtonGroupEnabled(this.buttonGroup, false);
        this.setButtonGroupEnabled(this.mapGroup, true);
        this.batchsLabel.setEnabled(false);
        this.batchSize.setEnabled(false);
        this.samplingRateUnitLabel.setEnabled(true);
        this.samplsLabel.setEnabled(true);
        this.showRate.setEnabled(true);
        this.objectTypesCombo.setEnabled(false);
        boolean isDoubleOperation = this.putGetRadio.isSelected() || this.putRemRadio.isSelected();
        this.parallelOps.setEnabled(isDoubleOperation);
        if (!isDoubleOperation) {
            this.parallelOps.setSelected(false);
            this.timeout.setValue(DEFAULT_REGULAR_TIMEOUT);
        }
        if (this.putRadio.isSelected() || this.removeRadio.isSelected() || this.putRemRadio.isSelected()) {
            this.noOfReadOps.setEnabled(false);
            this.noOfReadLabel.setEnabled(false);
        } else {
            this.noOfReadOps.setEnabled(true);
            this.noOfReadLabel.setEnabled(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.javaSpaceRadio) {
            this.selectJavaSpaceRB();
        } else if (source == this.mapRadio) {
            this.selectMapRB();
        } else if (source == this.foreverLease) {
            this.leaseTime.setEnabled(!this.foreverLease.isSelected());
        } else if (source == this.clearConsoleBtn) {
            this.consoleOutput.setText("");
        } else if (source == this.stopBtn) {
            this.benchmark.stop();
            this.onStopTest();
        } else if (source == this.saveConfigurationButton) {
            this.saveConfiguration((String)this.configurationsCombo.getSelectedItem());
        } else if (source == this.renameConfigurationButton) {
            this.renameSelectedConfiguration();
        } else if (source == this.newConfigurationButton) {
            this.createNewConfiguration();
        } else if (source == this.deleteConfigurationButton) {
            this.deleteConfiguration();
        } else if (source == this.masterLocalCacheCB) {
            int readOperNum = (Integer)this.noOfReadOps.getValue();
            if (this.masterLocalCacheCB.isSelected() && readOperNum < 2) {
                this.noOfReadOps.setValue(new Integer(2));
            } else if (!this.masterLocalCacheCB.isSelected() && readOperNum > 1) {
                this.noOfReadOps.setValue(new Integer(1));
            }
        }
    }

    private void createNewConfiguration() {
        if (this.newConfigurationDialog == null) {
            this.newConfigurationDialog = new ConfigurationNameDialog(this.parentFrame, "New Configuration");
            JSpaceUIUtils.setCenterAWTWindow(this.newConfigurationDialog);
        }
        String curSelConfigName = (String)this.configurationsCombo.getSelectedItem();
        this.newConfigurationDialog.setVisible("");
        String newConfigName = this.newConfigurationDialog.getNewName();
        if (newConfigName == null) {
            return;
        }
        allConfigNamesVector.add(newConfigName);
        comboBoxModel = new DefaultComboBoxModel<String>(allConfigNamesVector);
        this.configurationsCombo.setModel(comboBoxModel);
        this.configurationsCombo.setSelectedItem(newConfigName);
        this.saveConfiguration(newConfigName);
        this.saveConfigurationButton.setEnabled(true);
        this.renameConfigurationButton.setEnabled(true);
        this.deleteConfigurationButton.setEnabled(true);
    }

    private boolean isConfigNameExists(String configName) {
        return allConfigNamesVector.contains(configName);
    }

    private void renameSelectedConfiguration() {
        if (this.renameConfigurationDialog == null) {
            this.renameConfigurationDialog = new ConfigurationNameDialog(this.parentFrame, "Rename Configuration");
            JSpaceUIUtils.setCenterAWTWindow(this.renameConfigurationDialog);
        }
        String curSelConfigName = (String)this.configurationsCombo.getSelectedItem();
        this.renameConfigurationDialog.setVisible(curSelConfigName);
        String newConfigName = this.renameConfigurationDialog.getNewName();
        if (newConfigName == null) {
            return;
        }
        int curSelConfigIndex = allConfigNamesVector.indexOf(curSelConfigName);
        allConfigNamesVector.setElementAt(newConfigName, curSelConfigIndex);
        comboBoxModel = new DefaultComboBoxModel<String>(allConfigNamesVector);
        this.configurationsCombo.setModel(comboBoxModel);
        this.configurationsCombo.setSelectedIndex(curSelConfigIndex);
        File file = new File(locationDirPath + curSelConfigName + configFileExtension);
        boolean isDeleted = file.delete();
        this.saveConfiguration(newConfigName);
    }

    private void deleteConfiguration() {
        String curSelConfigName = (String)this.configurationsCombo.getSelectedItem();
        String message = "Are you sure you want to delete '" + curSelConfigName + "' Configuration?";
        int returnValue = JOptionPane.showConfirmDialog(this.parentFrame, message, "Delete Configuration", 0, 2);
        if (returnValue == 0) {
            allConfigNamesVector.remove(curSelConfigName);
            comboBoxModel = new DefaultComboBoxModel<String>(allConfigNamesVector);
            this.configurationsCombo.setModel(comboBoxModel);
            int itemsCount = comboBoxModel.getSize();
            String newSelName = (String)this.configurationsCombo.getSelectedItem();
            if (itemsCount == 0) {
                this.renameConfigurationButton.setEnabled(false);
                this.saveConfigurationButton.setEnabled(false);
                this.deleteConfigurationButton.setEnabled(false);
            } else {
                boolean isDefaultConfigSelected = newSelName.equals(DEFAULT_CONFIG_NAME);
                this.renameConfigurationButton.setEnabled(!isDefaultConfigSelected);
                this.deleteConfigurationButton.setEnabled(!isDefaultConfigSelected);
            }
            if (newSelName != null) {
                BenchmarkGUIConfiguration benchmarkGUIConfiguration = allConfigurationsMap.get(newSelName);
                this.initPanel(benchmarkGUIConfiguration);
            }
            File file = new File(locationDirPath + curSelConfigName + configFileExtension);
            file.delete();
        }
    }

    private void setButtonGroupEnabled(ButtonGroup group, boolean isEnable) {
        Enumeration<AbstractButton> e = group.getElements();
        while (e.hasMoreElements()) {
            ((JRadioButton)e.nextElement()).setEnabled(isEnable);
        }
        if (this.parallelOps != null) {
            this.parallelOps.setEnabled(false);
            this.timeout.setValue(DEFAULT_REGULAR_TIMEOUT);
        }
    }

    public void alert(String error) {
        JOptionPane.showMessageDialog(this.parentFrame, error, "Invalid parameter", 0);
        this.onStopTest();
    }

    public void onStopTest() {
        this.startBtn.setEnabled(true);
        this.stopBtn.setEnabled(false);
        this.progressBar.setValue(0);
    }

    public void addThreadTPSample(String iterationNo, String operation, String threadNo, double threadTP, String globalTP, String freeMem, boolean isSecondOperation) {
        this.tableModel.insertRow(0, new Object[]{iterationNo, operation, threadNo, BenchmarkUtils.format((double)threadTP), globalTP, freeMem});
        if (this.displayThreadsTP.isSelected()) {
            Trace2DLtd threadTrace = this.threadTraces.get(threadNo);
            if (threadTrace == null) {
                threadTrace = new Trace2DLtd();
                threadTrace.setPhysicalUnits(NAME_ITERATIONS, "TP, msg/sec");
                if (!this.colorsIterator.hasNext()) {
                    this.colorsIterator = this.colors.iterator();
                }
                threadTrace.setColor(this.colorsIterator.next());
                threadTrace.setName(threadNo + " - Throughput");
                this.threadTraces.put(threadNo, threadTrace);
                this.chart.addTrace((ITrace2D)threadTrace);
                if (!isSecondOperation) {
                    threadTrace.addPoint(0.0, 0.0);
                } else {
                    threadTrace.addPoint((double)this._noOfIterations, 0.0);
                }
            }
            try {
                double iNo = new Double(iterationNo);
                if (isSecondOperation) {
                    iNo += (double)this._noOfIterations;
                }
                if (threadTrace.getMaxX() <= iNo) {
                    threadTrace.addPoint(iNo, threadTP);
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void addGlobalTPSample(String iterationNo, double globalTP, int repeatCount, boolean isSecondOperation, boolean isParallel) throws Exception {
        block11: {
            try {
                if (this.globalTrace == null) {
                    int bufferSize = (Integer)this.samplesBufferSize.getValue();
                    this.globalTrace = new Trace2DLtd(bufferSize);
                    this.globalTrace.setPhysicalUnits(NAME_ITERATIONS, "TP, msg/sec");
                    this.globalTrace.setColor(Color.RED);
                    this.globalTrace.setName("Global Throughput");
                    this.chart.addTrace((ITrace2D)this.globalTrace);
                    this.globalTrace.addPoint(0.0, 0.0);
                }
                if (this.masterLocalCacheCB.isSelected()) {
                    double iNo = new Double(this.totalOperations);
                    double xValue = new Double(iterationNo);
                    if (isSecondOperation) {
                        xValue += (double)this._noOfIterations;
                    }
                    if (this.globalTrace.getMaxX() < iNo) {
                        this.globalTrace.addPoint(xValue, Double.valueOf(globalTP).doubleValue());
                    }
                    int newProgressValue = isParallel ? 2 * (int)xValue : (!isSecondOperation ? (int)xValue : this.progressBar.getMaximum() / 2 + (int)xValue);
                    int curValue = this.progressBar.getValue();
                    if (curValue < newProgressValue && (curValue >= 10 || this.isBatchOperation)) {
                        this.progressBar.setValue(newProgressValue);
                    }
                } else {
                    double iNo = Double.valueOf(iterationNo);
                    if (isSecondOperation) {
                        iNo += (double)this._noOfIterations;
                    }
                    if (this.globalTrace.getMaxX() <= iNo) {
                        double doubleVal = globalTP;
                        this.globalTrace.addPoint(iNo, doubleVal);
                    }
                    int newProgressValue = isParallel ? 2 * new Integer(iterationNo) : (!isSecondOperation ? new Integer(iterationNo) : this.progressBar.getMaximum() / 2 + new Integer(iterationNo));
                    int curValue = this.progressBar.getValue();
                    if (curValue < newProgressValue && (curValue >= 10 || this.isBatchOperation)) {
                        this.progressBar.setValue(newProgressValue);
                    }
                }
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block11;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    public void cleanup() {
        Set traces = this.chart.getTraces();
        Iterator iterator = traces.iterator();
        int tracesSize = traces.size();
        ArrayList allTracesList = new ArrayList();
        while (iterator.hasNext()) {
            allTracesList.add(iterator.next());
        }
        for (int i = tracesSize - 1; i > -1; --i) {
            this.chart.removeTrace((ITrace2D)allTracesList.get(i));
        }
        this.threadTraces.clear();
        this.globalTrace = null;
        this.progressBar.setValue(0);
        this.tableModel.setRowCount(0);
    }

    public void showException(String msg, Throwable ex) {
        SpaceBrowser.showException(msg, ex);
    }

    public void showException(String messagePrefix, String msg, Throwable ex) {
        SpaceBrowser.showException(messagePrefix, msg, ex);
    }

    private void launchBenchmark(IJSpace theSpace) throws Exception {
        Integer batchSizeInt;
        this.theSpace = theSpace;
        this.cleanup();
        String masterLocaltype = String.valueOf(this.masterLocalCacheCB.isSelected());
        String protocol = "jini:";
        if (this._isClusterView) {
            IJSpace activeClusteredProxy = this._benchMarkPanel.getActiveSpace();
            this.initSpaceProxies(activeClusteredProxy);
        }
        if (this.regularSpaceProxy.isEmbedded()) {
            protocol = "java:";
        }
        this.theURL = protocol + "//" + this._hostName + '/' + this._containerName + '/' + this._spaceName + '?' + "useLocalCache" + "=" + masterLocaltype;
        try {
            SpaceProxyImpl spaceProxy;
            Object object = spaceProxy = this.clusteredProxyCheckBox.isSelected() ? this.clusteredSpaceProxy : this.regularSpaceProxy;
            if (this.mapRadio.isSelected()) {
                this.theCache = (IMap)CacheFinder.find((String)this.theURL);
                if (this.theCache != null) {
                    this.theCache.setVersioned(false);
                    this.theSpace = this.theCache.getMasterSpace();
                }
            } else {
                this.theSpace = this.masterLocalCacheCB.isSelected() ? (IJSpace)SpaceFinder.find((String)this.theURL) : spaceProxy;
                if (this.theSpace.equals(this.regularSpaceProxy) && ((SecuredService)this.theSpace).isServiceSecured()) {
                    ServiceID spaceServiceID = JSpaceUtilities.getSpaceServiceID((IJSpace)this.theSpace);
                    ServiceItem spaceServiceItem = Repository.getInstance().getServiceItem(spaceServiceID);
                    if (spaceServiceItem != null && SecurityServicesRepository.getInstance().isUserLoggedIn()) {
                        spaceServiceItem.service = this.theSpace;
                        SecurityServicesRepository.getInstance().authenticateUsingExistngAuthentication(spaceServiceItem, true);
                    }
                }
            }
        }
        catch (Exception e) {
            this.showException("Can't start benchmark", e);
            return;
        }
        String graphTitle = "";
        this.args.clear();
        if (this.mapRadio.isSelected()) {
            this.args.add(this.theURL);
        } else {
            this.args.add(this._curSpaceURL);
        }
        if (this.cleanSpace.isSelected()) {
            this.args.add("-clean");
        }
        this.args.add("-tr");
        this.args.add(this.noOfThreads.getValue().toString());
        this.args.add("-i");
        long i_noOfIterations = (long)((Integer)this.noOfIterations.getValue()).intValue() * 1000L;
        this.args.add(String.valueOf(i_noOfIterations));
        if (this.batchSize.isEnabled() && (batchSizeInt = (Integer)this.batchSize.getValue()) > 0) {
            this.args.add("-m");
            this.args.add(batchSizeInt.toString());
        }
        this.args.add("-s");
        this.args.add(this.entrySize.getValue().toString());
        if (!this.clusteredProxyCheckBox.isSelected()) {
            this.args.add("-usesinglespace");
        }
        if (this.embeddedTX.isSelected()) {
            this.args.add("-tx");
            this.args.add(this.commitEveryTx.getValue().toString());
        }
        if (this.distributedTX.isSelected()) {
            this.args.add("-dtx");
            this.args.add(this.commitEveryTx.getValue().toString());
            this.args.add("-dtx-manager-url");
            this.args.add(this.txnManagerHostNameField.getText());
        }
        if (this.masterLocalCacheCB.isSelected()) {
            this.args.add("-cache");
        }
        if (this.noOfReadOps.isEnabled()) {
            Integer noOfReadsInt = (Integer)this.noOfReadOps.getValue();
            this.args.add("-repeatsecond");
            this.args.add(noOfReadsInt.toString());
        }
        boolean twoOps = false;
        if (this.returnLeaseCB.isSelected()) {
            this.args.add("-returnlease");
        }
        if (this.javaSpaceRadio.isSelected()) {
            if (this.writeTakeOp.isSelected()) {
                this.args.add(ARGUMENT_NAME_TAKE);
                graphTitle = "JavaSpace,Write & Take";
                twoOps = true;
            } else if (this.writeReadOp.isSelected()) {
                this.args.add(ARGUMENT_NAME_READ);
                graphTitle = "JavaSpace,Write & Read";
                twoOps = true;
            } else if (this.writeOp.isSelected()) {
                this.args.add(ARGUMENT_NAME_ONLY);
                this.args.add(ARGUMENT_NAME_FIRST);
                graphTitle = "JavaSpace,Write";
            } else if (this.readOp.isSelected()) {
                this.args.add(ARGUMENT_NAME_READ);
                this.args.add(ARGUMENT_NAME_ONLY);
                this.args.add(ARGUMENT_NAME_SECOND);
                graphTitle = "JavaSpace,Read";
            } else if (this.takeOp.isSelected()) {
                this.args.add(ARGUMENT_NAME_TAKE);
                this.args.add(ARGUMENT_NAME_ONLY);
                this.args.add(ARGUMENT_NAME_SECOND);
                graphTitle = "JavaSpace,Take";
            } else if (this.writeNotifyOp.isSelected()) {
                this.args.add(ARGUMENT_NAME_NOTIFY);
                graphTitle = "JavaSpace,Write & Notify";
                twoOps = true;
            }
        }
        if (this.parallelOps.isSelected()) {
            this.args.add("-parallel");
        }
        if (this.objectTypesCombo.isEnabled()) {
            ObjectTypeItem selMessageTypeItem = (ObjectTypeItem)this.objectTypesCombo.getSelectedItem();
            this.args.add("-objecttype");
            this.args.add(selMessageTypeItem.getMessageTypeParameterName());
        } else {
            this.args.add("-objecttype");
            this.args.add("pojo");
        }
        Integer timeoutStr = (Integer)this.timeout.getValue();
        this.args.add("-t");
        this.args.add(timeoutStr.toString());
        this.args.add("-showrate");
        int samplingrate = Integer.valueOf(this.showRate.getValue().toString()) * 1000;
        this.args.add(String.valueOf(samplingrate));
        this.args.add("-showthreadrate");
        samplingrate = Integer.valueOf(this.showRate.getValue().toString()) * 1000;
        this.args.add(String.valueOf(samplingrate));
        if (this.saveToFileCB.isSelected()) {
            this.args.add("-f");
            this.args.add(this.fNameTextField.getText());
        }
        this.args.add("-gui");
        if (this.mapRadio.isSelected()) {
            if (this.putRadio.isSelected()) {
                this.args.add(ARGUMENT_NAME_MAP);
                this.args.add(ARGUMENT_NAME_ONLY);
                this.args.add(ARGUMENT_NAME_FIRST);
                graphTitle = "Map,Put";
            } else if (this.getRadio.isSelected()) {
                this.args.add(ARGUMENT_NAME_MAP);
                this.args.add(ARGUMENT_NAME_READ);
                this.args.add(ARGUMENT_NAME_ONLY);
                this.args.add(ARGUMENT_NAME_SECOND);
                graphTitle = "Map,Get";
            } else if (this.removeRadio.isSelected()) {
                this.args.add(ARGUMENT_NAME_MAP);
                this.args.add(ARGUMENT_NAME_TAKE);
                this.args.add(ARGUMENT_NAME_ONLY);
                this.args.add(ARGUMENT_NAME_SECOND);
                graphTitle = "Map,Remove";
            } else if (this.putRemRadio.isSelected()) {
                this.args.add(ARGUMENT_NAME_MAP);
                this.args.add(ARGUMENT_NAME_TAKE);
                graphTitle = "Map,Put & Remove";
                twoOps = true;
            } else if (this.putGetRadio.isSelected()) {
                this.args.add(ARGUMENT_NAME_MAP);
                this.args.add(ARGUMENT_NAME_READ);
                graphTitle = "Map,Put & Get";
                twoOps = true;
            }
        }
        this.args.add("-lease");
        if (this.foreverLease.isSelected()) {
            this.args.add(String.valueOf(Long.MAX_VALUE));
        } else {
            this.args.add(this.leaseTime.getValue().toString());
        }
        String argsString = this.args.toString();
        this.aPrintStream.println("Launching benchmark with arguments:");
        this.aPrintStream.println(argsString);
        this.progressBar.setValue(0);
        this._noOfIterations = Integer.valueOf(this.noOfIterations.getValue().toString()) * 1000;
        this._noOfReadOps = 1;
        if (this.noOfReadOps.isEnabled()) {
            this._noOfReadOps = Integer.valueOf(this.noOfReadOps.getValue().toString());
        }
        graphTitle = graphTitle + " Number of Iteration:" + this._noOfIterations;
        this.totalOperations = this._noOfIterations * this._noOfReadOps;
        int threadsNum = (Integer)this.noOfThreads.getValue();
        if (twoOps) {
            this.totalOperations += this._noOfIterations;
        }
        int batchesSize = (Integer)this.batchSize.getValue();
        this.isBatchOperation = false;
        if (batchesSize > 0 && this.javaSpaceRadio.isSelected()) {
            if (threadsNum != 0) {
                batchesSize = threadsNum * batchesSize;
            }
            this.progressBar.setMaximum(batchesSize);
            this.isBatchOperation = true;
        } else {
            if (threadsNum != 0) {
                this.totalOperations = threadsNum * this.totalOperations;
            }
            this.progressBar.setMaximum(this.totalOperations);
            this.progressBar.setValue(10);
        }
        this.graphLabel.setText(graphTitle);
        this.aPrintStream.println("---------------------------------------------------");
        this.aPrintStream.println("Benchmark Start Time:" + new Date(System.currentTimeMillis()));
        this.aPrintStream.println("System Info:" + RuntimeInfo.getEnvironmentInfo());
        AdminUIThreadPool.getThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                String[] argsArray = GigaBenchmark.this.args.toArray(new String[0]);
                try {
                    GigaBenchmark.this.benchmark = new BenchmarkTest();
                    GigaBenchmark.this.benchmark.runBenchmark(argsArray, GigaBenchmark.this.aPrintStream, GigaBenchmark.this.theSpace, GigaBenchmark.this.theCache, (BenchmarkListener)GigaBenchmark.this, (BenchmarkOutput)GigaBenchmark.this);
                }
                catch (Throwable e) {
                    GigaBenchmark.this.showException("Failed to run Benchmark", e);
                }
            }
        });
    }

    private JPanel createOperationsPanel() {
        JPanel operationsPanel = new JPanel();
        operationsPanel.setLayout(new GridBagLayout());
        operationsPanel.setBorder(new TitledBorder(new EtchedBorder(), "Operations", 0, 0, null, null));
        this.javaSpaceRadio = new JRadioButton(OP_NAME_JAVASPACE);
        this.mapRadio = new JRadioButton(OP_NAME_MAP);
        this.mapGroup = new ButtonGroup();
        this.operationGroup = new ButtonGroup();
        this.operationGroup.add(this.javaSpaceRadio);
        this.operationGroup.add(this.mapRadio);
        this.javaSpaceRadio.addActionListener(this);
        this.mapRadio.addActionListener(this);
        ActionListener enableParOps = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (GigaBenchmark.this.javaSpaceRadio.isSelected()) {
                    GigaBenchmark.this.parallelOps.setEnabled(GigaBenchmark.this.writeTakeOp.isSelected() || GigaBenchmark.this.writeReadOp.isSelected() || GigaBenchmark.this.writeNotifyOp.isSelected());
                } else if (GigaBenchmark.this.mapRadio.isSelected()) {
                    GigaBenchmark.this.parallelOps.setEnabled(GigaBenchmark.this.putGetRadio.isSelected() || GigaBenchmark.this.putRemRadio.isSelected());
                }
                if (!GigaBenchmark.this.parallelOps.isEnabled()) {
                    GigaBenchmark.this.parallelOps.setSelected(false);
                    GigaBenchmark.this.timeout.setValue(DEFAULT_REGULAR_TIMEOUT);
                }
                boolean isRepeatOperationEnabled = source != GigaBenchmark.this.writeOp && source != GigaBenchmark.this.putRadio && source != GigaBenchmark.this.writeTakeOp && source != GigaBenchmark.this.takeOp && source != GigaBenchmark.this.removeRadio && source != GigaBenchmark.this.putRemRadio;
                GigaBenchmark.this.noOfReadOps.setEnabled(isRepeatOperationEnabled);
                GigaBenchmark.this.noOfReadLabel.setEnabled(isRepeatOperationEnabled);
            }
        };
        this.putRadio = new JRadioButton("Put");
        this.putRadio.setSelected(true);
        this.getRadio = new JRadioButton("Get");
        this.removeRadio = new JRadioButton("Remove");
        this.putRemRadio = new JRadioButton("Put and Remove");
        this.putGetRadio = new JRadioButton("Put and Get");
        this.putRadio.addActionListener(enableParOps);
        this.getRadio.addActionListener(enableParOps);
        this.removeRadio.addActionListener(enableParOps);
        this.putGetRadio.addActionListener(enableParOps);
        this.putRemRadio.addActionListener(enableParOps);
        this.mapGroup.add(this.putRadio);
        this.mapGroup.add(this.getRadio);
        this.mapGroup.add(this.removeRadio);
        this.mapGroup.add(this.putRemRadio);
        this.mapGroup.add(this.putGetRadio);
        this.javaSpaceRadio.setSelected(true);
        this.setButtonGroupEnabled(this.mapGroup, false);
        this.writeNotifyOp = new JRadioButton("Write and Notify");
        this.writeNotifyOp.addActionListener(enableParOps);
        this.buttonGroup.add(this.writeNotifyOp);
        this.writeOp = new JRadioButton("Write", true);
        this.writeOp.addActionListener(enableParOps);
        this.buttonGroup.add(this.writeOp);
        this.takeOp = new JRadioButton("Take");
        this.takeOp.addActionListener(enableParOps);
        this.buttonGroup.add(this.takeOp);
        this.readOp = new JRadioButton("Read");
        this.readOp.addActionListener(enableParOps);
        this.buttonGroup.add(this.readOp);
        this.writeTakeOp = new JRadioButton("Write and Take");
        this.writeTakeOp.addActionListener(enableParOps);
        this.buttonGroup.add(this.writeTakeOp);
        this.writeReadOp = new JRadioButton("Write and Read");
        this.writeReadOp.addActionListener(enableParOps);
        this.buttonGroup.add(this.writeReadOp);
        this.parallelOps = new JCheckBox("Parallel operations", false);
        this.parallelOps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (GigaBenchmark.this.parallelOps.isSelected()) {
                    GigaBenchmark.this.timeout.setValue(DEFAULT_PARALLEL_TIMEOUT);
                } else {
                    GigaBenchmark.this.timeout.setValue(DEFAULT_REGULAR_TIMEOUT);
                }
            }
        });
        int leftAllignment1 = 3;
        int leftAllignment2 = 15;
        GridBagConstraints componentConstrains = new GridBagConstraints(0, 0, 1, 1, 0.7, 0.0, 21, 1, new Insets(1, 3, 1, 1), 0, 3);
        operationsPanel.add((Component)this.javaSpaceRadio, componentConstrains);
        componentConstrains.gridy = 1;
        componentConstrains.insets.left = 15;
        operationsPanel.add((Component)this.writeOp, componentConstrains);
        componentConstrains.insets.left = 15;
        componentConstrains.gridy = 2;
        operationsPanel.add((Component)this.readOp, componentConstrains);
        componentConstrains.insets.left = 15;
        componentConstrains.gridy = 3;
        operationsPanel.add((Component)this.takeOp, componentConstrains);
        componentConstrains.insets.left = 15;
        componentConstrains.gridy = 4;
        operationsPanel.add((Component)this.writeReadOp, componentConstrains);
        componentConstrains.insets.left = 15;
        componentConstrains.gridy = 5;
        operationsPanel.add((Component)this.writeTakeOp, componentConstrains);
        componentConstrains.insets.left = 15;
        componentConstrains.gridy = 6;
        operationsPanel.add((Component)this.writeNotifyOp, componentConstrains);
        componentConstrains.gridy = 7;
        componentConstrains.insets.left = 3;
        operationsPanel.add((Component)this.mapRadio, componentConstrains);
        componentConstrains.insets.left = 15;
        componentConstrains.gridy = 8;
        operationsPanel.add((Component)this.putRadio, componentConstrains);
        componentConstrains.insets.left = 15;
        componentConstrains.gridy = 9;
        operationsPanel.add((Component)this.getRadio, componentConstrains);
        componentConstrains.insets.left = 15;
        componentConstrains.gridy = 10;
        operationsPanel.add((Component)this.removeRadio, componentConstrains);
        componentConstrains.insets.left = 15;
        componentConstrains.gridy = 11;
        operationsPanel.add((Component)this.putGetRadio, componentConstrains);
        componentConstrains.insets.left = 15;
        componentConstrains.gridy = 12;
        operationsPanel.add((Component)this.putRemRadio, componentConstrains);
        componentConstrains.insets.left = 3;
        componentConstrains.gridy = 13;
        componentConstrains.insets.top = 11;
        operationsPanel.add((Component)this.parallelOps, componentConstrains);
        Box noOfReadBox = new Box(0);
        this.noOfReadLabel = new JLabel();
        this.noOfReadLabel.setText("Repeat Read/Get Operation:");
        this.noOfReadOps = new JSpinner();
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel();
        spinnerNumberModel.setMaximum(null);
        spinnerNumberModel.setStepSize(1);
        spinnerNumberModel.setValue(1);
        spinnerNumberModel.setMinimum(Integer.valueOf(1));
        this.noOfReadOps.setModel(spinnerNumberModel);
        noOfReadBox.add(this.noOfReadLabel);
        noOfReadBox.add(Box.createHorizontalStrut(5));
        noOfReadBox.add(this.noOfReadOps);
        noOfReadBox.add(Box.createHorizontalGlue());
        componentConstrains.gridy = 14;
        componentConstrains.insets.left = 3;
        componentConstrains.insets.top = 8;
        componentConstrains.insets.bottom = 5;
        operationsPanel.add((Component)noOfReadBox, componentConstrains);
        operationsPanel.setMinimumSize(new Dimension(100, 240));
        operationsPanel.add(Box.createVerticalGlue());
        return operationsPanel;
    }

    private JPanel createTBDPanel(boolean isClusteredProxy, int minWidth, int prefWidth) {
        JPanel tbdPanel = new JPanel();
        tbdPanel.setLayout(new GridBagLayout());
        tbdPanel.setBorder(new TitledBorder(new EtchedBorder(), "Settings", 0, 0, null, null));
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 1, new Insets(2, 10, 2, 3), 0, 3);
        this.cleanSpace = new JCheckBox("Clean Space");
        this.cleanSpace.setToolTipText("Clean space before the test");
        this.displayThreadsTP = new JCheckBox("Display Thread TP", false);
        this.displayThreadsTP.setEnabled(false);
        this.clusteredProxyCheckBox = new JCheckBox("Use Clustered Proxy", isClusteredProxy);
        this.clusteredProxyCheckBox.setEnabled(false);
        tbdPanel.add((Component)this.clusteredProxyCheckBox, constraints);
        constraints.gridy = 1;
        tbdPanel.add((Component)this.cleanSpace, constraints);
        constraints.gridy = 2;
        tbdPanel.add((Component)this.displayThreadsTP, constraints);
        tbdPanel.setMinimumSize(new Dimension(minWidth, 80));
        tbdPanel.setPreferredSize(new Dimension(prefWidth, 80));
        return tbdPanel;
    }

    private JPanel createResultsOutputPanel() {
        JPanel resultsOuputPanel = new JPanel();
        resultsOuputPanel.setLayout(new BoxLayout(resultsOuputPanel, 1));
        Dimension panelSize = new Dimension(500, 150);
        resultsOuputPanel.setPreferredSize(panelSize);
        resultsOuputPanel.setMaximumSize(panelSize);
        resultsOuputPanel.setMinimumSize(new Dimension(500, 50));
        resultsOuputPanel.setBorder(new TitledBorder(new EtchedBorder(), "Results Output", 0, 0, null, null));
        this.saveToFileCB = new JCheckBox();
        this.saveToFileCB.setText("Save results to file");
        this.saveToFileCB.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean enable = GigaBenchmark.this.saveToFileCB.isSelected();
                GigaBenchmark.this.fNameLabel.setEnabled(enable);
                GigaBenchmark.this.fNameTextField.setEnabled(enable);
                GigaBenchmark.this.chooseBtn.setEnabled(enable);
                if (!GigaBenchmark.this.fNameTextField.isEnabled()) {
                    GigaBenchmark.this.fNameTextField.setText("");
                }
            }
        });
        this.fNameLabel = new JLabel();
        this.fNameLabel.setEnabled(false);
        this.fNameLabel.setText("File name:");
        this.fNameTextField = new JTextField();
        this.fNameTextField.setEnabled(false);
        this.fNameTextField.setPreferredSize(new Dimension(200, 20));
        this.fNameTextField.setMaximumSize(new Dimension(1000, 20));
        this.chooseBtn = new JButton();
        this.chooseBtn.setEnabled(false);
        this.chooseBtn.setText("...");
        this.chooseBtn.addActionListener(new ResultsFileHandler());
        this.chooseBtn.setPreferredSize(new Dimension(20, 20));
        this.chooseBtn.setMaximumSize(new Dimension(20, 20));
        Box checkBoxBox = new Box(0);
        Box fileSelectionBox = new Box(0);
        checkBoxBox.add(Box.createHorizontalStrut(2));
        checkBoxBox.add(this.saveToFileCB);
        checkBoxBox.add(Box.createHorizontalGlue());
        fileSelectionBox.add(Box.createHorizontalStrut(5));
        fileSelectionBox.add(this.fNameLabel);
        fileSelectionBox.add(Box.createHorizontalStrut(5));
        fileSelectionBox.add(this.fNameTextField);
        fileSelectionBox.add(this.chooseBtn);
        fileSelectionBox.add(Box.createHorizontalStrut(5));
        resultsOuputPanel.add(Box.createVerticalStrut(10));
        resultsOuputPanel.add(checkBoxBox);
        resultsOuputPanel.add(Box.createVerticalStrut(5));
        resultsOuputPanel.add(fileSelectionBox);
        resultsOuputPanel.add(Box.createVerticalStrut(10));
        return resultsOuputPanel;
    }

    private JPanel createMasterLocalPanel() {
        JPanel masterLocalPanel = new JPanel();
        masterLocalPanel.setLayout(null);
        Dimension panelSize = new Dimension(500, 80);
        masterLocalPanel.setPreferredSize(panelSize);
        masterLocalPanel.setMaximumSize(panelSize);
        masterLocalPanel.setBorder(new TitledBorder(new EtchedBorder(), "Master-Local", 0, 0, null, null));
        this.masterLocalCacheCB = new JCheckBox("Use Local Cache");
        this.masterLocalCacheCB.setBounds(15, 20, 140, 20);
        masterLocalPanel.add(this.masterLocalCacheCB);
        this.masterLocalCacheCB.addActionListener(this);
        return masterLocalPanel;
    }

    private JPanel createConfigurationPanel() {
        JPanel configurationPanel = new JPanel();
        Dimension panelSize = new Dimension(1000, 170);
        configurationPanel.setPreferredSize(panelSize);
        configurationPanel.setMaximumSize(panelSize);
        configurationPanel.setBorder(new TitledBorder(new EtchedBorder(), "Configuration", 0, 0, null, null));
        this.saveConfigurationButton = new JButton("Save");
        this.saveConfigurationButton.addActionListener(this);
        this.renameConfigurationButton = new JButton("Rename");
        this.renameConfigurationButton.addActionListener(this);
        this.newConfigurationButton = new JButton("New");
        this.newConfigurationButton.addActionListener(this);
        this.deleteConfigurationButton = new JButton("Delete");
        this.deleteConfigurationButton.addActionListener(this);
        configurationPanel.setLayout(new BoxLayout(configurationPanel, 1));
        this.configurationsCombo = new JComboBox(comboBoxModel);
        Object selItem = this.configurationsCombo.getSelectedItem();
        if (selItem != null && !selItem.equals(DEFAULT_CONFIG_NAME)) {
            this.renameConfigurationButton.setEnabled(true);
            this.deleteConfigurationButton.setEnabled(true);
        } else {
            this.renameConfigurationButton.setEnabled(false);
            this.deleteConfigurationButton.setEnabled(false);
        }
        if (allConfigNamesVector.size() > 0) {
            this.saveConfigurationButton.setEnabled(true);
        } else {
            this.saveConfigurationButton.setEnabled(false);
        }
        this.configurationsCombo.addItemListener(this);
        Dimension buttonSize = new Dimension(75, 23);
        Dimension comboSize = new Dimension(245, 22);
        this.configurationsCombo.setPreferredSize(comboSize);
        this.configurationsCombo.setMaximumSize(comboSize);
        this.saveConfigurationButton.setPreferredSize(new Dimension(100, 25));
        this.saveConfigurationButton.setMaximumSize(new Dimension(75, 25));
        this.renameConfigurationButton.setPreferredSize(buttonSize);
        this.renameConfigurationButton.setMaximumSize(buttonSize);
        this.deleteConfigurationButton.setPreferredSize(buttonSize);
        this.deleteConfigurationButton.setMaximumSize(buttonSize);
        this.newConfigurationButton.setPreferredSize(buttonSize);
        this.newConfigurationButton.setMaximumSize(buttonSize);
        Box configurationComboBox = new Box(0);
        Box buttonsConfigurationBox = new Box(0);
        Box saveButtonBox = new Box(0);
        configurationComboBox.add(Box.createHorizontalGlue());
        configurationComboBox.add(this.configurationsCombo);
        configurationComboBox.add(Box.createHorizontalGlue());
        buttonsConfigurationBox.add(Box.createHorizontalGlue());
        buttonsConfigurationBox.add(this.newConfigurationButton);
        buttonsConfigurationBox.add(Box.createHorizontalStrut(10));
        buttonsConfigurationBox.add(this.deleteConfigurationButton);
        buttonsConfigurationBox.add(Box.createHorizontalStrut(10));
        buttonsConfigurationBox.add(this.renameConfigurationButton);
        buttonsConfigurationBox.add(Box.createHorizontalGlue());
        saveButtonBox.add(Box.createHorizontalGlue());
        saveButtonBox.add(this.saveConfigurationButton);
        saveButtonBox.add(Box.createHorizontalGlue());
        Box comboOperationsBox = new Box(1);
        comboOperationsBox.add(Box.createVerticalStrut(1));
        comboOperationsBox.add(configurationComboBox);
        comboOperationsBox.add(Box.createVerticalStrut(5));
        comboOperationsBox.add(buttonsConfigurationBox);
        comboOperationsBox.add(Box.createVerticalStrut(1));
        comboOperationsBox.setBorder(new TitledBorder(new EtchedBorder(), "", 0, 0, null, null));
        configurationPanel.add(comboOperationsBox);
        configurationPanel.add(Box.createVerticalStrut(6));
        configurationPanel.add(saveButtonBox);
        configurationPanel.add(Box.createVerticalGlue());
        return configurationPanel;
    }

    private JPanel createTransactionPanel() {
        JPanel transactionPanel = new JPanel();
        Dimension panelSize = new Dimension(220, 180);
        transactionPanel.setPreferredSize(panelSize);
        transactionPanel.setMinimumSize(panelSize);
        transactionPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 1, new Insets(2, 5, 2, 0), 0, 3);
        ChangeListener enableTX = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (GigaBenchmark.this.noTX != null && GigaBenchmark.this.commitLabel1 != null && GigaBenchmark.this.commitEveryTx != null && GigaBenchmark.this.commitLabel2 != null) {
                    GigaBenchmark.this.commitLabel1.setEnabled(!GigaBenchmark.this.noTX.isSelected());
                    GigaBenchmark.this.commitEveryTx.setEnabled(!GigaBenchmark.this.noTX.isSelected());
                    GigaBenchmark.this.commitLabel2.setEnabled(!GigaBenchmark.this.noTX.isSelected());
                    GigaBenchmark.this.txnManagerHostNameField.setEnabled(GigaBenchmark.this.distributedTX.isSelected());
                    GigaBenchmark.this.txnManagerHostNameLabel.setEnabled(GigaBenchmark.this.distributedTX.isSelected());
                }
            }
        };
        this.noTX = new JRadioButton();
        transactionPanel.setBorder(new TitledBorder(new EtchedBorder(1), "Transaction", 0, 0, null, null));
        transactionPanel.add((Component)this.noTX, constraints);
        this.buttonGroup_2.add(this.noTX);
        this.noTX.setText("None");
        this.noTX.addChangeListener(enableTX);
        this.noTX.setSelected(true);
        this.embeddedTX = new JRadioButton();
        constraints.gridy = 1;
        transactionPanel.add((Component)this.embeddedTX, constraints);
        this.buttonGroup_2.add(this.embeddedTX);
        this.embeddedTX.setText("Embedded");
        this.embeddedTX.addChangeListener(enableTX);
        this.distributedTX = new JRadioButton();
        this.buttonGroup_2.add(this.distributedTX);
        this.distributedTX.setText("Distributed");
        this.distributedTX.addChangeListener(enableTX);
        constraints.gridy = 2;
        transactionPanel.add((Component)this.distributedTX, constraints);
        this.txnManagerHostNameLabel = new JLabel("Txn Manager URL:");
        this.txnManagerHostNameLabel.setEnabled(false);
        this.txnManagerHostNameField = new JTextField("");
        this.txnManagerHostNameField.setEnabled(false);
        this.txnManagerHostNameField.setToolTipText("Examples: thunder1:3393 or 162.163.11.111:3393. URLs can be separated by comma.");
        this.txnManagerHostNameField.setPreferredSize(new Dimension(250, 22));
        this.txnManagerHostNameField.setMaximumSize(new Dimension(500, 22));
        Box distribTxnHostNameBoxBox = new Box(0);
        distribTxnHostNameBoxBox.add(this.txnManagerHostNameLabel);
        distribTxnHostNameBoxBox.add(Box.createHorizontalStrut(4));
        distribTxnHostNameBoxBox.add(this.txnManagerHostNameField);
        distribTxnHostNameBoxBox.add(Box.createHorizontalStrut(5));
        constraints.insets.left = 15;
        constraints.gridy = 3;
        transactionPanel.add((Component)distribTxnHostNameBoxBox, constraints);
        constraints.insets.left = 5;
        Box distributedTransactionBox = new Box(0);
        this.commitLabel1 = new JLabel();
        this.commitLabel1.setEnabled(false);
        distributedTransactionBox.add(this.commitLabel1);
        this.commitLabel1.setText("Commit every");
        this.commitEveryTx = new JSpinner();
        this.commitEveryTx.setEnabled(false);
        distributedTransactionBox.add(Box.createHorizontalStrut(4));
        distributedTransactionBox.add(this.commitEveryTx);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel();
        spinnerNumberModel.setMaximum(null);
        spinnerNumberModel.setStepSize(1000);
        spinnerNumberModel.setValue(1);
        spinnerNumberModel.setMinimum(Integer.valueOf(1));
        this.commitEveryTx.setModel(spinnerNumberModel);
        this.commitEveryTx.setMaximumSize(new Dimension(80, 22));
        this.commitLabel2 = new JLabel();
        this.commitLabel2.setEnabled(false);
        distributedTransactionBox.add(Box.createHorizontalStrut(4));
        distributedTransactionBox.add(this.commitLabel2);
        this.commitLabel2.setText("operations");
        constraints.gridy = 4;
        constraints.insets.top = 25;
        transactionPanel.add((Component)distributedTransactionBox, constraints);
        return transactionPanel;
    }

    private JPanel createLeasePanel(int minWidth) {
        JPanel leasePanel = new JPanel();
        leasePanel.setLayout(new GridBagLayout());
        leasePanel.setBorder(new TitledBorder(new EtchedBorder(), "Lease", 0, 0, null, null));
        this.returnLeaseCB = new JCheckBox("Return Lease", false);
        this.foreverLease = new JCheckBox("FOREVER Lease", true);
        JLabel leaseTimeLabel = new JLabel("Lease Time[ms]:");
        this.leaseTime = new JSpinner();
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel();
        this.leaseTime.setModel(spinnerNumberModel);
        spinnerNumberModel.setStepSize(100);
        spinnerNumberModel.setValue(10000);
        spinnerNumberModel.setMinimum(Integer.valueOf(1));
        this.leaseTime.setEnabled(false);
        this.foreverLease.addActionListener(this);
        GridBagConstraints leftLabelConstains = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 1, new Insets(2, 10, 2, 3), 0, 3);
        leasePanel.add((Component)this.returnLeaseCB, leftLabelConstains);
        leftLabelConstains.gridy = 1;
        leasePanel.add((Component)this.foreverLease, leftLabelConstains);
        leftLabelConstains.gridy = 2;
        leasePanel.add((Component)leaseTimeLabel, leftLabelConstains);
        leasePanel.add((Component)this.leaseTime, new GridBagConstraints(1, 2, 1, 1, 0.7, 0.0, 21, 1, new Insets(2, 1, 2, 55), 0, 3));
        leasePanel.setMinimumSize(new Dimension(minWidth, 60));
        return leasePanel;
    }

    private JPanel createOptionsPanel(int minWidth) {
        JPanel optionsPanel = new JPanel(new GridBagLayout());
        optionsPanel.setBorder(new TitledBorder(new EtchedBorder(), "Options", 0, 0, null, null));
        this.noOfThreads = new JSpinner();
        this.noOfThreads.setToolTipText("Number of threads");
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel();
        spinnerNumberModel.setValue(1);
        spinnerNumberModel.setStepSize(1);
        spinnerNumberModel.setMaximum(null);
        spinnerNumberModel.setMinimum(Integer.valueOf(1));
        this.noOfThreads.setModel(spinnerNumberModel);
        this.noOfThreads.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int threadNumber = (Integer)GigaBenchmark.this.noOfThreads.getValue();
                GigaBenchmark.this.displayThreadsTP.setEnabled(threadNumber != 1);
                if (threadNumber == 1) {
                    GigaBenchmark.this.displayThreadsTP.setSelected(false);
                }
            }
        });
        this.noOfIterations = new JSpinner();
        this.noOfIterations.setToolTipText("Number of iterations");
        this.batchSize = new JSpinner();
        this.batchSize.setToolTipText("Number of multiple operations of readMultiple/takeMultiple/writeMultiple (0 if single operations are used)");
        SpinnerNumberModel batchSizeSpinnerNumberModel = new SpinnerNumberModel();
        batchSizeSpinnerNumberModel.setMaximum(null);
        batchSizeSpinnerNumberModel.setValue(0);
        batchSizeSpinnerNumberModel.setStepSize(1);
        batchSizeSpinnerNumberModel.setMinimum(Integer.valueOf(0));
        this.batchSize.setModel(batchSizeSpinnerNumberModel);
        this.batchSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GigaBenchmark.this.handleSamplingRateState();
            }
        });
        this.entrySize = new JSpinner();
        SpinnerNumberModel entrySizeSpinnerNumberModel = new SpinnerNumberModel();
        entrySizeSpinnerNumberModel.setValue(128);
        entrySizeSpinnerNumberModel.setStepSize(128);
        entrySizeSpinnerNumberModel.setMinimum(Integer.valueOf(1));
        this.entrySize.setModel(entrySizeSpinnerNumberModel);
        this.showRate = new JSpinner();
        this.showRate.setToolTipText("Display throughput every N iterations");
        SpinnerNumberModel showRateSpinnerNumberModel = new SpinnerNumberModel();
        showRateSpinnerNumberModel.setMaximum(Integer.valueOf(10000000));
        showRateSpinnerNumberModel.setStepSize(1);
        showRateSpinnerNumberModel.setMinimum(Integer.valueOf(1));
        showRateSpinnerNumberModel.setValue(2);
        this.showRate.setModel(showRateSpinnerNumberModel);
        JLabel threadLabel = new JLabel("Threads:");
        JLabel iterationLabel = new JLabel("Iterations:");
        JLabel entryLabel = new JLabel("Entry size:");
        JLabel itarationUnitLabel = new JLabel("000");
        JLabel entrySizeUnitLabel = new JLabel("Bytes");
        JLabel timeOutLabel = new JLabel("Read/Take timeout:");
        this.noOfIterations.setValue(10);
        SpinnerNumberModel spinnerNumberModelx = new SpinnerNumberModel();
        spinnerNumberModelx.setMaximum(null);
        spinnerNumberModelx.setStepSize(1);
        spinnerNumberModelx.setValue(10);
        spinnerNumberModelx.setMinimum(Integer.valueOf(1));
        this.noOfIterations.setModel(spinnerNumberModelx);
        this.timeout = new JSpinner();
        SpinnerNumberModel timeOutSpinnerNumberModel = new SpinnerNumberModel();
        timeOutSpinnerNumberModel.setValue(0);
        timeOutSpinnerNumberModel.setMinimum(Integer.valueOf(0));
        this.timeout.setModel(timeOutSpinnerNumberModel);
        itarationUnitLabel.setBounds(this.noOfIterations.getX() + this.noOfIterations.getWidth(), 50, 110, 20);
        this.samplingRateUnitLabel.setBounds(this.showRate.getX() + this.showRate.getWidth(), 90, 110, 20);
        entrySizeUnitLabel.setBounds(this.entrySize.getX() + this.entrySize.getWidth(), 70, 70, 20);
        GridBagConstraints leftLabelConstains = new GridBagConstraints(0, 0, 3, 1, 0.7, 0.0, 21, 1, new Insets(2, 10, 2, 3), 0, 3);
        GridBagConstraints middleComponentsConstains = new GridBagConstraints(3, 0, 1, 1, 0.5, 0.0, 21, 1, new Insets(2, 1, 2, 1), 0, 3);
        GridBagConstraints rightComponentsConstains = new GridBagConstraints(4, 0, 2, 1, 0.5, 0.0, 21, 1, new Insets(2, 1, 2, 1), 0, 3);
        Dimension maxSpinSize = new Dimension(80, 22);
        Dimension prefSpinSize = new Dimension(80, 22);
        Dimension maxSecondLabelSize = new Dimension(25, 22);
        entrySizeUnitLabel.setMaximumSize(maxSecondLabelSize);
        entrySizeUnitLabel.setPreferredSize(maxSecondLabelSize);
        this.noOfThreads.setPreferredSize(prefSpinSize);
        this.noOfThreads.setMaximumSize(maxSpinSize);
        this.noOfIterations.setPreferredSize(prefSpinSize);
        this.noOfIterations.setMaximumSize(maxSpinSize);
        this.entrySize.setPreferredSize(prefSpinSize);
        this.entrySize.setMaximumSize(maxSpinSize);
        this.showRate.setPreferredSize(prefSpinSize);
        this.showRate.setMaximumSize(maxSpinSize);
        this.batchSize.setPreferredSize(prefSpinSize);
        this.batchSize.setMaximumSize(maxSpinSize);
        this.timeout.setPreferredSize(prefSpinSize);
        this.timeout.setMaximumSize(maxSpinSize);
        leftLabelConstains.gridy = 0;
        middleComponentsConstains.gridy = 0;
        optionsPanel.add((Component)threadLabel, leftLabelConstains);
        optionsPanel.add((Component)this.noOfThreads, middleComponentsConstains);
        leftLabelConstains.gridy = 1;
        middleComponentsConstains.gridy = 1;
        rightComponentsConstains.gridy = 1;
        optionsPanel.add((Component)iterationLabel, leftLabelConstains);
        optionsPanel.add((Component)this.noOfIterations, middleComponentsConstains);
        optionsPanel.add((Component)itarationUnitLabel, rightComponentsConstains);
        leftLabelConstains.gridy = 2;
        middleComponentsConstains.gridy = 2;
        rightComponentsConstains.gridy = 2;
        optionsPanel.add((Component)entryLabel, leftLabelConstains);
        optionsPanel.add((Component)this.entrySize, middleComponentsConstains);
        optionsPanel.add((Component)entrySizeUnitLabel, rightComponentsConstains);
        leftLabelConstains.gridy = 3;
        middleComponentsConstains.gridy = 3;
        rightComponentsConstains.gridy = 3;
        optionsPanel.add((Component)this.samplsLabel, leftLabelConstains);
        optionsPanel.add((Component)this.showRate, middleComponentsConstains);
        optionsPanel.add((Component)this.samplingRateUnitLabel, rightComponentsConstains);
        leftLabelConstains.gridy = 4;
        middleComponentsConstains.gridy = 4;
        optionsPanel.add((Component)this.batchsLabel, leftLabelConstains);
        optionsPanel.add((Component)this.batchSize, middleComponentsConstains);
        leftLabelConstains.gridy = 5;
        middleComponentsConstains.gridy = 5;
        rightComponentsConstains.gridy = 5;
        optionsPanel.add((Component)timeOutLabel, leftLabelConstains);
        optionsPanel.add((Component)this.timeout, middleComponentsConstains);
        optionsPanel.add((Component)new JLabel("[ms]"), rightComponentsConstains);
        return optionsPanel;
    }

    private JPanel createObjectTypePanel(int minWidth, int prefWidth) {
        JPanel objectTypesPanel = new JPanel(new GridBagLayout());
        objectTypesPanel.setBorder(new TitledBorder(new EtchedBorder(), "Object Type", 0, 0, null, null));
        this.objectTypesCombo = new JComboBox<ObjectTypeItem>(this.objectTypeItems);
        this.objectTypesCombo.addItemListener(this);
        this.objectTypeDescription.setLineWrap(true);
        this.objectTypeDescription.setWrapStyleWord(true);
        this.objectTypeDescription.setEditable(false);
        this.objectTypeDescription.setRows(7);
        this.objectTypeDescription.setFont(UIManager.getFont("Label.font"));
        this.objectTypeDescription.setBackground(UIManager.getColor("Label.background"));
        JScrollPane scrollPanObjectTypeDescription = new JScrollPane(this.objectTypeDescription);
        Dimension textAreaScrollPaneSize = new Dimension(100, 135);
        scrollPanObjectTypeDescription.setPreferredSize(textAreaScrollPaneSize);
        scrollPanObjectTypeDescription.setMinimumSize(new Dimension(100, 85));
        scrollPanObjectTypeDescription.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(156, 156, 158)), "Description"));
        Dimension objectTypesComboSize = new Dimension(210, 19);
        this.objectTypesCombo.setPreferredSize(objectTypesComboSize);
        this.objectTypesCombo.setMaximumSize(objectTypesComboSize);
        GridBagConstraints leftLabelConstains = new GridBagConstraints(0, 0, 1, 1, 0.7, 0.0, 21, 1, new Insets(1, 2, 0, 0), 0, 0);
        GridBagConstraints middleComponentsConstains = new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 21, 1, new Insets(0, 1, 1, 1), 0, 3);
        middleComponentsConstains.gridy = 0;
        objectTypesPanel.add((Component)this.objectTypesCombo, middleComponentsConstains);
        leftLabelConstains.gridy = 1;
        leftLabelConstains.gridwidth = 2;
        leftLabelConstains.insets = new Insets(2, 0, 2, 0);
        objectTypesPanel.add((Component)scrollPanObjectTypeDescription, leftLabelConstains);
        objectTypesPanel.setPreferredSize(new Dimension(prefWidth, 160));
        objectTypesPanel.setMinimumSize(new Dimension(minWidth, 85));
        this.objectTypeDescription.setText(((ObjectTypeItem)this.objectTypesCombo.getSelectedItem()).getMessageTypeParameterDescription());
        return objectTypesPanel;
    }

    private void initialize(JPanel content, boolean isClusteredProxy) {
        String spaceUrlString;
        content.setLayout(new BorderLayout());
        JPanel operationsPanel = this.createOperationsPanel();
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setTabPlacement(3);
        Dimension tabbedPanelSize = new Dimension(760, 600);
        tabbedPane.setPreferredSize(tabbedPanelSize);
        tabbedPane.setMinimumSize(tabbedPanelSize);
        JScrollPane jScrollPane = new JScrollPane(tabbedPane);
        jScrollPane.setBorder(null);
        content.add((Component)jScrollPane, "Center");
        JPanel settingsPanel = new JPanel();
        settingsPanel.setLayout(new GridLayout(1, 3));
        Box leftBox = new Box(1);
        Box middleBox = new Box(1);
        Box rightBox = new Box(1);
        int minWidth = 110;
        int prefWidth = 200;
        JPanel objectTypePanel = this.createObjectTypePanel(110, 200);
        JPanel optionsPanel = this.createOptionsPanel(110);
        JPanel leasePanel = this.createLeasePanel(110);
        JPanel tbdPanel = this.createTBDPanel(isClusteredProxy, 110, 200);
        leftBox.add(objectTypePanel);
        leftBox.add(Box.createVerticalStrut(5));
        leftBox.add(optionsPanel);
        leftBox.add(Box.createVerticalStrut(5));
        leftBox.add(leasePanel);
        leftBox.add(Box.createVerticalStrut(2));
        settingsPanel.add(leftBox);
        tabbedPane.addTab("Settings", null, settingsPanel, null);
        this._curSpaceURL = spaceUrlString = "jini://" + this._hostName + "/" + this._containerName + "/" + this._spaceName;
        middleBox.add(operationsPanel);
        middleBox.add(tbdPanel);
        settingsPanel.add(middleBox);
        settingsPanel.add(rightBox);
        JPanel transactionPanel = this.createTransactionPanel();
        JPanel masterLocalPanel = this.createMasterLocalPanel();
        JPanel resultsOutputPanel = this.createResultsOutputPanel();
        JPanel configurationPanel = this.createConfigurationPanel();
        rightBox.add(transactionPanel);
        rightBox.add(Box.createVerticalStrut(7));
        rightBox.add(masterLocalPanel);
        rightBox.add(Box.createVerticalStrut(7));
        rightBox.add(resultsOutputPanel);
        rightBox.add(Box.createVerticalStrut(7));
        rightBox.add(configurationPanel);
        if (this.configurationsCombo.getModel().getSize() > 0) {
            this.initPanel(allConfigurationsMap.get(this.configurationsCombo.getSelectedItem()));
        }
        this.tableModel = new DefaultTableModel(new Object[]{"Iteration #", "Operation", "Thread #", "Thread Throughput, msg/sec", "Global Throughput, msg/sec", "Free Memory, Mb"}, 0){

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.table = new JTable(this.tableModel);
        this.table.setAutoResizeMode(4);
        this.table.setShowGrid(true);
        this.table.setBorder(new LineBorder(Color.LIGHT_GRAY, 1, false));
        JScrollPane tableScrollPanel = new JScrollPane(this.table);
        tableScrollPanel.setViewportBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BorderLayout());
        tablePanel.add((Component)tableScrollPanel, "Center");
        tabbedPane.addTab("Table", null, tablePanel, null);
        JPanel panel_1 = new JPanel();
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(2);
        panel_1.setLayout(flowLayout);
        tablePanel.add((Component)panel_1, "South");
        JButton button = new JButton();
        button.setPreferredSize(new Dimension(84, 28));
        panel_1.add(button);
        button.setText("Clear");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GigaBenchmark.this.cleanup();
            }
        });
        JPanel graphTabPanel = new JPanel();
        graphTabPanel.setBorder(new EmptyBorder(3, 3, 0, 3));
        this.chart = new Chart2D();
        this.chart.setBorder((Border)new LineBorder(new Color(127, 157, 185), 1, false));
        this.chart.getAxisX().setPaintGrid(true);
        this.chart.getAxisY().setPaintGrid(true);
        this.chart.setGridColor(Color.LIGHT_GRAY);
        graphTabPanel.setLayout(new BorderLayout());
        graphTabPanel.add((Component)this.chart, "Center");
        graphTabPanel.add((Component)this.graphLabel, "North");
        this.chart.setBounds(5, 5, 565, 430);
        JPanel panel_12 = new JPanel();
        FlowLayout flowLayout2 = new FlowLayout();
        flowLayout2.setAlignment(2);
        panel_12.setLayout(flowLayout2);
        panel_12.setAlignmentX(1.0f);
        JButton button2 = new JButton();
        button2.setPreferredSize(new Dimension(84, 28));
        panel_12.add(button2);
        button2.setText("Clear");
        button2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GigaBenchmark.this.cleanup();
            }
        });
        JLabel label = new JLabel();
        label.setPreferredSize(new Dimension(10, 0));
        panel_12.add(label);
        JSeparator separator = new JSeparator();
        separator.setOrientation(1);
        separator.setPreferredSize(new Dimension(2, 20));
        panel_12.add(separator);
        label = new JLabel();
        label.setPreferredSize(new Dimension(10, 0));
        panel_12.add(label);
        label = new JLabel();
        label.setBounds(394, 442, 60, 20);
        panel_12.add(label);
        label.setText("Display last");
        this.samplesBufferSize = new JSpinner();
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel();
        spinnerNumberModel.setValue(100);
        spinnerNumberModel.setStepSize(10);
        spinnerNumberModel.setMaximum(Integer.valueOf(1000));
        spinnerNumberModel.setMinimum(Integer.valueOf(10));
        this.samplesBufferSize.setModel(spinnerNumberModel);
        this.samplesBufferSize.setBounds(458, 442, 60, 20);
        panel_12.add(this.samplesBufferSize);
        this.samplesBufferSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Set traces = GigaBenchmark.this.chart.getTraces();
                for (ITrace2D trace : traces) {
                    trace.addPoint(0.0, 0.0);
                    if (!(trace instanceof Trace2DLtd)) continue;
                    ((Trace2DLtd)trace).setMaxSize(((Integer)GigaBenchmark.this.samplesBufferSize.getValue()).intValue());
                }
            }
        });
        JLabel label1 = new JLabel();
        label1.setBounds(523, 442, 44, 20);
        panel_12.add(label1);
        label1.setText("samples");
        graphTabPanel.add((Component)panel_12, "South");
        tabbedPane.addTab("Graph", null, graphTabPanel, null);
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(5, 5, 0, 5));
        panel.setLayout(new BorderLayout());
        tabbedPane.addTab("Summary", null, panel, null);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBounds(2, 2, 570, 430);
        panel.add(scrollPane);
        this.consoleOutput = new JTextArea();
        Font curFont = this.consoleOutput.getFont();
        this.consoleOutput.setFont(new Font(curFont.getName(), curFont.getStyle(), curFont.getSize() + 3));
        scrollPane.setViewportView(this.consoleOutput);
        this.consoleOutput.setEditable(false);
        this.consoleOutput.setBorder(new LineBorder(Color.LIGHT_GRAY, 1, false));
        panel_12 = new JPanel();
        flowLayout2 = new FlowLayout();
        flowLayout2.setAlignment(2);
        panel_12.setLayout(flowLayout2);
        panel.add((Component)panel_12, "South");
        this.clearConsoleBtn = new JButton();
        this.clearConsoleBtn.setPreferredSize(new Dimension(84, 28));
        panel_12.add(this.clearConsoleBtn);
        this.clearConsoleBtn.setText("Clear");
        this.clearConsoleBtn.addActionListener(this);
        JPanel panel_13 = new JPanel();
        panel_13.setBorder(null);
        FlowLayout flowLayout3 = new FlowLayout();
        flowLayout3.setVgap(7);
        flowLayout3.setHgap(10);
        flowLayout3.setAlignment(2);
        panel_13.setLayout(flowLayout3);
        content.add((Component)panel_13, "South");
        this.progressBar = new JProgressBar();
        this.progressBar.setPreferredSize(new Dimension(400, 20));
        panel_13.add(this.progressBar);
        this.startBtn = new JButton("Start");
        panel_13.add(this.startBtn);
        this.startBtn.setPreferredSize(new Dimension(84, 28));
        this.startBtn.setToolTipText("Start benchmark");
        this.startBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String message;
                if (GigaBenchmark.this.cleanSpace.isSelected()) {
                    message = "Space will be cleaned since you have \"Clean Space\" option selected.\nAre you sure you want to continue?";
                    if (JOptionPane.showConfirmDialog(GigaBenchmark.this.parentFrame, message, "Warning", 0, 2) != 0) {
                        return;
                    }
                }
                if (GigaBenchmark.this.distributedTX.isSelected() && JSpaceUtilities.isEmpty((String)GigaBenchmark.this.txnManagerHostNameField.getText(), (boolean)true)) {
                    message = "Unable to continue." + JSpaceUtilities.LINE_SEPARATOR + "Hostname:Port for Distributed Transaction Manager must be defined.";
                    JOptionPane.showMessageDialog(GigaBenchmark.this.parentFrame, message, "Warning", 2);
                    return;
                }
                GigaBenchmark.this.startBtn.setEnabled(false);
                GigaBenchmark.this.stopBtn.setEnabled(true);
                try {
                    GigaBenchmark.this.launchBenchmark(GigaBenchmark.this.theSpace);
                }
                catch (Exception e) {
                    GigaBenchmark.this.showException("Benchmark", e);
                }
            }
        });
        this.stopBtn = new JButton("Stop");
        this.stopBtn.setPreferredSize(new Dimension(84, 28));
        panel_13.add(this.stopBtn);
        this.stopBtn.setEnabled(false);
        this.stopBtn.setToolTipText("Stop benchmark");
        this.stopBtn.addActionListener(this);
    }

    private static String initConfiguration(File configFile) {
        String configName = null;
        try {
            FileInputStream fis = new FileInputStream(configFile);
            Document optionsDoc = builder.parse(fis);
            Element top = optionsDoc.getDocumentElement();
            configName = top.getAttribute("name");
            BenchmarkGUIConfiguration benchmarkConfiguration = new BenchmarkGUIConfiguration();
            NodeList nl = top.getElementsByTagName(OPTION_TAG_NAME);
            for (int i = 0; i < nl.getLength(); ++i) {
                Element nextOption = (Element)nl.item(i);
                String optionName = nextOption.getAttribute("name");
                String optionValue = nextOption.getAttribute(VALUE_ATTR_NAME);
                GigaBenchmark.fillConfigurationInstance(benchmarkConfiguration, optionName, optionValue);
            }
            allConfigurationsMap.put(configName, benchmarkConfiguration);
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        return configName;
    }

    private static void fillConfigurationInstance(BenchmarkGUIConfiguration benchmarkConfiguration, String optionName, String optionValue) {
        if (optionName.equals(NAME_THREADS)) {
            benchmarkConfiguration.setThreadsNumber(Integer.valueOf(optionValue));
        } else if (optionName.equals(NAME_ITERATIONS)) {
            benchmarkConfiguration.setIterationsNumber(Integer.valueOf(optionValue) / 1000);
        } else if (optionName.equals(NAME_ENTRY_SIZE)) {
            benchmarkConfiguration.setEntrySize(Integer.valueOf(optionValue));
        } else if (optionName.equals(NAME_SAMPLING_RATE)) {
            benchmarkConfiguration.setSamplingRate(Integer.valueOf(optionValue) / 1000);
        } else if (optionName.equals(NAME_BATCH_SIZE)) {
            benchmarkConfiguration.setBatchesNumber(Integer.valueOf(optionValue));
        } else if (optionName.equals(NAME_READ_TAKE_TIMEOUT)) {
            benchmarkConfiguration.setReadTakeTimeout(Integer.valueOf(optionValue));
        } else if (optionName.equals(NAME_OBJECT_TYPE)) {
            benchmarkConfiguration.setObjectType(optionValue);
        } else if (optionName.equals(NAME_NO_WRITE_LEASE)) {
            benchmarkConfiguration.setNoWriteLease(Boolean.valueOf(optionValue));
        } else if (optionName.equals(NAME_FOREVER_LEASE)) {
            benchmarkConfiguration.setForeverLease(Boolean.valueOf(optionValue));
        } else if (optionName.equals(NAME_LEASE_TIME)) {
            benchmarkConfiguration.setLeaseTime(Integer.valueOf(optionValue));
        } else if (optionName.equals(NAME_CLUSTERED_PROXY)) {
            benchmarkConfiguration.setClusteredProxy(Boolean.valueOf(optionValue));
        } else if (optionName.equals(NAME_DISPLAY_THREADS_THROUGHPUT)) {
            benchmarkConfiguration.setDisplayThreadsThroughput(Boolean.valueOf(optionValue));
        } else if (optionName.equals(NAME_CLEAN_SPACE)) {
            benchmarkConfiguration.setCleanSpace(Boolean.valueOf(optionValue));
        } else if (optionName.equals(NAME_OPERATION_TYPE)) {
            benchmarkConfiguration.setOperationType(optionValue);
        } else if (optionName.equals(NAME_OPERATION_NAME)) {
            benchmarkConfiguration.setOperationName(optionValue);
        } else if (optionName.equals(NAME_PARALLEL_OPERATIONS)) {
            benchmarkConfiguration.setParallelOperations(Boolean.valueOf(optionValue));
        } else if (optionName.equals(NAME_REPEAT_READ)) {
            benchmarkConfiguration.setRepeatOperationsNumber(Integer.valueOf(optionValue));
        } else if (optionName.equals(NAME_TRANSACTION_TYPE)) {
            benchmarkConfiguration.setTransactionType(optionValue);
        } else if (optionName.equals(NAME_COMMIT_EVERY)) {
            benchmarkConfiguration.setCommitFrequency(Integer.valueOf(optionValue));
        } else if (optionName.equals(NAME_DISTRIB_TXN_MANAGER_URL)) {
            benchmarkConfiguration.setDistribTxnManagerURL(optionValue);
        } else if (optionName.equals(NAME_MASTER_LOCAL_CACHE)) {
            benchmarkConfiguration.setMasterLocalCache(Boolean.valueOf(optionValue));
        } else if (optionName.equals(NAME_CACHE_TYPE)) {
            benchmarkConfiguration.setMasterLocalCacheType(optionValue);
        } else if (optionName.equals(NAME_SAVE_RESULTS_TO_FILE)) {
            benchmarkConfiguration.setSaveResultsToFile(Boolean.valueOf(optionValue));
        } else if (optionName.equals(NAME_FILE_NAME)) {
            benchmarkConfiguration.setFileName(optionValue);
        }
    }

    private void saveConfiguration(String configName) {
        File file = new File(locationDirPath + configName + configFileExtension);
        try {
            Document optionsDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element rootElement = optionsDocument.createElement(ROOT_NAME);
            rootElement.setAttribute("name", configName);
            optionsDocument.appendChild(rootElement);
            Element e = optionsDocument.createElement(OPTION_TAG_NAME);
            e.setAttribute("name", NAME_THREADS);
            e.setAttribute(VALUE_ATTR_NAME, this.noOfThreads.getValue().toString());
            rootElement.appendChild(e);
            e = optionsDocument.createElement(OPTION_TAG_NAME);
            e.setAttribute("name", NAME_ITERATIONS);
            e.setAttribute(VALUE_ATTR_NAME, String.valueOf((Integer)this.noOfIterations.getValue() * 1000));
            rootElement.appendChild(e);
            e = optionsDocument.createElement(OPTION_TAG_NAME);
            e.setAttribute("name", NAME_ENTRY_SIZE);
            e.setAttribute(VALUE_ATTR_NAME, this.entrySize.getValue().toString());
            rootElement.appendChild(e);
            e = optionsDocument.createElement(OPTION_TAG_NAME);
            e.setAttribute("name", NAME_SAMPLING_RATE);
            e.setAttribute(VALUE_ATTR_NAME, String.valueOf((Integer)this.showRate.getValue() * 1000));
            rootElement.appendChild(e);
            e = optionsDocument.createElement(OPTION_TAG_NAME);
            e.setAttribute("name", NAME_BATCH_SIZE);
            e.setAttribute(VALUE_ATTR_NAME, this.batchSize.isEnabled() ? this.batchSize.getValue().toString() : String.valueOf(0));
            rootElement.appendChild(e);
            e = optionsDocument.createElement(OPTION_TAG_NAME);
            e.setAttribute("name", NAME_READ_TAKE_TIMEOUT);
            e.setAttribute(VALUE_ATTR_NAME, this.timeout.getValue().toString());
            rootElement.appendChild(e);
            e = optionsDocument.createElement(OPTION_TAG_NAME);
            e.setAttribute("name", NAME_OBJECT_TYPE);
            e.setAttribute(VALUE_ATTR_NAME, ((ObjectTypeItem)this.objectTypesCombo.getSelectedItem()).getMessageTypeParameterName());
            rootElement.appendChild(e);
            e = optionsDocument.createElement(OPTION_TAG_NAME);
            e.setAttribute("name", NAME_NO_WRITE_LEASE);
            e.setAttribute(VALUE_ATTR_NAME, String.valueOf(this.returnLeaseCB.isSelected()));
            rootElement.appendChild(e);
            e = optionsDocument.createElement(OPTION_TAG_NAME);
            e.setAttribute("name", NAME_FOREVER_LEASE);
            e.setAttribute(VALUE_ATTR_NAME, String.valueOf(this.foreverLease.isSelected()));
            rootElement.appendChild(e);
            if (this.leaseTime.isEnabled()) {
                e = optionsDocument.createElement(OPTION_TAG_NAME);
                e.setAttribute("name", NAME_LEASE_TIME);
                e.setAttribute(VALUE_ATTR_NAME, this.leaseTime.getValue().toString());
                rootElement.appendChild(e);
            }
            e = optionsDocument.createElement(OPTION_TAG_NAME);
            e.setAttribute("name", NAME_CLUSTERED_PROXY);
            e.setAttribute(VALUE_ATTR_NAME, String.valueOf(this.clusteredProxyCheckBox.isSelected()));
            rootElement.appendChild(e);
            e = optionsDocument.createElement(OPTION_TAG_NAME);
            e.setAttribute("name", NAME_DISPLAY_THREADS_THROUGHPUT);
            e.setAttribute(VALUE_ATTR_NAME, String.valueOf(this.displayThreadsTP.isSelected()));
            rootElement.appendChild(e);
            e = optionsDocument.createElement(OPTION_TAG_NAME);
            e.setAttribute("name", NAME_CLEAN_SPACE);
            e.setAttribute(VALUE_ATTR_NAME, String.valueOf(this.cleanSpace.isSelected()));
            rootElement.appendChild(e);
            e = optionsDocument.createElement(OPTION_TAG_NAME);
            e.setAttribute("name", NAME_OPERATION_TYPE);
            if (this.javaSpaceRadio.isSelected()) {
                e.setAttribute(VALUE_ATTR_NAME, OP_NAME_JAVASPACE);
            } else {
                e.setAttribute(VALUE_ATTR_NAME, OP_NAME_MAP);
            }
            rootElement.appendChild(e);
            e = optionsDocument.createElement(OPTION_TAG_NAME);
            e.setAttribute("name", NAME_OPERATION_NAME);
            if (this.javaSpaceRadio.isSelected()) {
                if (this.writeTakeOp.isSelected()) {
                    e.setAttribute(VALUE_ATTR_NAME, "WriteAndTake");
                } else if (this.writeReadOp.isSelected()) {
                    e.setAttribute(VALUE_ATTR_NAME, "WriteAndRead");
                } else if (this.writeNotifyOp.isSelected()) {
                    e.setAttribute(VALUE_ATTR_NAME, "WriteAndNotify");
                } else if (this.writeOp.isSelected()) {
                    e.setAttribute(VALUE_ATTR_NAME, "Write");
                } else if (this.readOp.isSelected()) {
                    e.setAttribute(VALUE_ATTR_NAME, "Read");
                } else if (this.takeOp.isSelected()) {
                    e.setAttribute(VALUE_ATTR_NAME, "Take");
                }
            } else {
                if (this.putRadio.isSelected()) {
                    e.setAttribute(VALUE_ATTR_NAME, "Put");
                } else if (this.getRadio.isSelected()) {
                    e.setAttribute(VALUE_ATTR_NAME, "Get");
                }
                if (this.removeRadio.isSelected()) {
                    e.setAttribute(VALUE_ATTR_NAME, "Remove");
                }
                if (this.putGetRadio.isSelected()) {
                    e.setAttribute(VALUE_ATTR_NAME, "PutAndGet");
                }
                if (this.putRemRadio.isSelected()) {
                    e.setAttribute(VALUE_ATTR_NAME, "PutAndRemove");
                }
            }
            rootElement.appendChild(e);
            e = optionsDocument.createElement(OPTION_TAG_NAME);
            e.setAttribute("name", NAME_PARALLEL_OPERATIONS);
            e.setAttribute(VALUE_ATTR_NAME, String.valueOf(this.parallelOps.isSelected()));
            rootElement.appendChild(e);
            e = optionsDocument.createElement(OPTION_TAG_NAME);
            e.setAttribute("name", NAME_REPEAT_READ);
            e.setAttribute(VALUE_ATTR_NAME, this.noOfReadOps.getValue().toString());
            rootElement.appendChild(e);
            e = optionsDocument.createElement(OPTION_TAG_NAME);
            e.setAttribute("name", NAME_TRANSACTION_TYPE);
            if (this.noTX.isSelected()) {
                e.setAttribute(VALUE_ATTR_NAME, "None");
            } else if (this.embeddedTX.isSelected()) {
                e.setAttribute(VALUE_ATTR_NAME, "Embedded");
            } else {
                e.setAttribute(VALUE_ATTR_NAME, "Distributed");
            }
            rootElement.appendChild(e);
            if (this.commitEveryTx.isEnabled()) {
                e = optionsDocument.createElement(OPTION_TAG_NAME);
                e.setAttribute("name", NAME_COMMIT_EVERY);
                e.setAttribute(VALUE_ATTR_NAME, this.commitEveryTx.getValue().toString());
                rootElement.appendChild(e);
            }
            if (this.distributedTX.isSelected()) {
                e = optionsDocument.createElement(OPTION_TAG_NAME);
                e.setAttribute("name", NAME_DISTRIB_TXN_MANAGER_URL);
                e.setAttribute(VALUE_ATTR_NAME, this.txnManagerHostNameField.getText());
                rootElement.appendChild(e);
            }
            e = optionsDocument.createElement(OPTION_TAG_NAME);
            e.setAttribute("name", NAME_MASTER_LOCAL_CACHE);
            e.setAttribute(VALUE_ATTR_NAME, String.valueOf(this.masterLocalCacheCB.isSelected()));
            rootElement.appendChild(e);
            if (this.masterLocalCacheCB.isSelected()) {
                e = optionsDocument.createElement(OPTION_TAG_NAME);
                e.setAttribute("name", NAME_CACHE_TYPE);
                rootElement.appendChild(e);
            }
            e = optionsDocument.createElement(OPTION_TAG_NAME);
            e.setAttribute("name", NAME_SAVE_RESULTS_TO_FILE);
            e.setAttribute(VALUE_ATTR_NAME, String.valueOf(this.saveToFileCB.isSelected()));
            rootElement.appendChild(e);
            e = optionsDocument.createElement(OPTION_TAG_NAME);
            e.setAttribute("name", NAME_FILE_NAME);
            e.setAttribute(VALUE_ATTR_NAME, this.fNameTextField.getText());
            rootElement.appendChild(e);
            PrintStream printStream = new PrintStream(new FileOutputStream(file));
            JSpaceUtilities.domWriter((Node)rootElement, (PrintStream)printStream, (String)"");
            printStream.close();
            GigaBenchmark.initConfiguration(file);
        }
        catch (FileNotFoundException e) {
            this.showException("File not found", e);
        }
        catch (ParserConfigurationException e) {
            this.showException("ParserConfigurationException", e);
        }
    }

    public void onError(String description, Throwable exc) {
    }

    static {
        File[] configFiles;
        window = null;
        DEFAULT_REGULAR_TIMEOUT = 0;
        DEFAULT_PARALLEL_TIMEOUT = 10000;
        _logger = Logger.getLogger("com.gigaspaces.admin.ui.spacebrowser");
        factory = DocumentBuilderFactory.newInstance();
        locationDirPath = System.getProperty("user.home") + File.separator + "benchmarkConfigurations" + File.separator;
        File locationDir = new File(locationDirPath);
        if (!locationDir.exists()) {
            locationDir.mkdir();
        }
        int length = (configFiles = locationDir.listFiles()) == null ? 0 : configFiles.length;
        allConfigNamesVector = new Vector(length);
        allConfigurationsMap = new HashMap<String, BenchmarkGUIConfiguration>(length);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < length; ++i) {
            File configFile = configFiles[i];
            String pfName = configFile.getName();
            if (!pfName.endsWith(configFileExtension)) continue;
            String configName = GigaBenchmark.initConfiguration(configFile);
            allConfigNamesVector.add(configName);
        }
        if (allConfigNamesVector.contains(DEFAULT_CONFIG_NAME)) {
            allConfigNamesVector.remove(DEFAULT_CONFIG_NAME);
            allConfigNamesVector.setElementAt(DEFAULT_CONFIG_NAME, 0);
        }
        comboBoxModel = new DefaultComboBoxModel<String>(allConfigNamesVector);
    }

    class ObjectTypeItem {
        private String _objectName;
        private String _objectTypeParameterName;
        private String _objectTypeParameterDescription;

        public ObjectTypeItem(MessageAdaptor messageAdaptor) {
            this._objectName = messageAdaptor.getLabel();
            this._objectTypeParameterName = messageAdaptor.getName();
            this._objectTypeParameterDescription = messageAdaptor.getDescription() + " " + MessageAdaptors.getComparisonString((MessageAdaptor)messageAdaptor) + "\n" + messageAdaptor.getUsageInfo();
        }

        public String toString() {
            return this._objectName;
        }

        public String getMessageTypeParameterName() {
            return this._objectTypeParameterName;
        }

        public String getMessageTypeParameterDescription() {
            return this._objectTypeParameterDescription;
        }
    }

    private class ConfigurationNameDialog
    extends JDialog
    implements ActionListener {
        private JButton okButton;
        private JButton cancelButton;
        private JTextField nameField;
        private String returnedVal;

        public ConfigurationNameDialog(JFrame parentFrame, String title) {
            super(parentFrame, title, true);
            this.init();
            this.setSize(new Dimension(300, 120));
            this.setResizable(false);
        }

        private void init() {
            JLabel title = new JLabel("Please enter new configuration name:");
            Box titleBox = new Box(0);
            titleBox.add(Box.createHorizontalStrut(15));
            titleBox.add(title);
            titleBox.add(Box.createHorizontalGlue());
            Box renameFieldBox = this.createTextFieldBox();
            Box buttonsBox = this.createButtonBox();
            Container contentPane = this.getContentPane();
            contentPane.setLayout(new BoxLayout(contentPane, 1));
            contentPane.add(Box.createVerticalStrut(5));
            contentPane.add(titleBox);
            contentPane.add(Box.createVerticalStrut(3));
            contentPane.add(renameFieldBox);
            contentPane.add(Box.createVerticalStrut(5));
            contentPane.add(buttonsBox);
            contentPane.add(Box.createVerticalStrut(5));
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    ConfigurationNameDialog.this.returnedVal = null;
                    ConfigurationNameDialog.this.setVisible(false);
                }

                @Override
                public void windowOpened(WindowEvent e) {
                    ConfigurationNameDialog.this.nameField.setCaretPosition(ConfigurationNameDialog.this.nameField.getText().length());
                }
            });
        }

        public void setVisible(String curName) {
            this.nameField.setText(curName);
            this.nameField.selectAll();
            this.setVisible(true);
        }

        private Box createTextFieldBox() {
            this.nameField = new JTextField();
            Box renameFieldBox = new Box(0);
            renameFieldBox.add(Box.createHorizontalStrut(10));
            renameFieldBox.add(this.nameField);
            renameFieldBox.add(Box.createHorizontalStrut(10));
            Dimension fieldSize = new Dimension(270, 22);
            this.nameField.setPreferredSize(fieldSize);
            this.nameField.setMaximumSize(fieldSize);
            this.nameField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        ConfigurationNameDialog.this.createNewConfig();
                    }
                }
            });
            return renameFieldBox;
        }

        private Box createButtonBox() {
            this.okButton = new JButton("OK");
            this.cancelButton = new JButton("Cancel");
            this.okButton.setMnemonic('O');
            this.cancelButton.setMnemonic('C');
            Dimension buttonSize = new Dimension(70, 23);
            this.okButton.setPreferredSize(buttonSize);
            this.cancelButton.setPreferredSize(buttonSize);
            Box buttonsBox = new Box(0);
            buttonsBox.add(Box.createHorizontalGlue());
            buttonsBox.add(this.okButton);
            buttonsBox.add(Box.createHorizontalStrut(10));
            buttonsBox.add(this.cancelButton);
            buttonsBox.add(Box.createHorizontalGlue());
            this.okButton.addActionListener(this);
            this.cancelButton.addActionListener(this);
            return buttonsBox;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.okButton) {
                this.createNewConfig();
            } else if (source == this.cancelButton) {
                this.returnedVal = null;
                this.setVisible(false);
            }
        }

        public String getNewName() {
            return this.returnedVal;
        }

        private void createNewConfig() {
            if (JSpaceUtilities.isEmpty((String)this.nameField.getText(), (boolean)true)) {
                JOptionPane.showMessageDialog(this, "Name can not be empty. Please provide valid name.", "Configuration Name", 1);
            } else if (GigaBenchmark.this.isConfigNameExists(this.nameField.getText())) {
                JOptionPane.showMessageDialog(this, "Configuration with this name already exists.\nPlease provide another name.", "Configuration Name", 1);
            } else {
                this.returnedVal = this.nameField.getText();
                this.setVisible(false);
            }
        }
    }

    class FilteredStream
    extends FilterOutputStream {
        public FilteredStream(OutputStream aStream) {
            super(aStream);
        }

        @Override
        public void write(byte[] b) throws IOException {
            String aString = new String(b);
            GigaBenchmark.this.consoleOutput.append(aString);
            GigaBenchmark.this.consoleOutput.setCaretPosition(GigaBenchmark.this.consoleOutput.getDocument().getLength());
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            String aString = new String(b, off, len);
            GigaBenchmark.this.consoleOutput.append(aString);
            GigaBenchmark.this.consoleOutput.setCaretPosition(GigaBenchmark.this.consoleOutput.getDocument().getLength());
        }
    }

    class ResultsFileHandler
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            while (this.saveFile() == -1) {
            }
        }

        public int saveFile() {
            int returnVal;
            if (chooser == null) {
                try {
                    GigaBenchmark.this.parentFrame.setCursor(Cursor.getPredefinedCursor(3));
                    chooser = new JFileChooser();
                    chooser.setFileFilter(new FileFilter(){

                        @Override
                        public boolean accept(File f) {
                            boolean isAccept = false;
                            if (f != null && (f.getName().toLowerCase().endsWith(".xls") || f.isDirectory())) {
                                isAccept = true;
                            }
                            return isAccept;
                        }

                        @Override
                        public String getDescription() {
                            return "GigaBenchmark Results XLS";
                        }
                    });
                }
                finally {
                    GigaBenchmark.this.parentFrame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
            if ((returnVal = chooser.showSaveDialog(GigaBenchmark.this.parentFrame)) == 0) {
                File file = chooser.getSelectedFile();
                String fName = file.getName();
                if (!fName.toLowerCase().endsWith(".xls")) {
                    fName = fName + ".xls";
                    file = new File(file.getAbsolutePath() + ".xls");
                }
                if (file.exists() && (returnVal = JOptionPane.showConfirmDialog(GigaBenchmark.this.parentFrame, "The file \"" + file.getAbsolutePath() + "\" exists. Overwrite?", "Save", 0, 2)) != 0) {
                    return -1;
                }
                GigaBenchmark.this.fNameTextField.setText(file.getAbsolutePath());
            }
            return 0;
        }
    }
}

