/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser.benchmark.standalone;

import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.admin.ui.util.UIHelper;
import com.gigaspaces.logger.GSLogConfigLoader;
import com.gigaspaces.start.SystemInfo;
import com.j_spaces.core.IJSpace;
import com.j_spaces.tools.spacebrowser.benchmark.BenchMarkPanel;
import com.j_spaces.tools.spacebrowser.benchmark.standalone.tree.BenchmarkSpacesTree;
import com.j_spaces.tools.spacebrowser.benchmark.standalone.tree.BenchmarkTreeNodeType;
import com.j_spaces.tools.spacebrowser.benchmark.standalone.tree.BenchmarkTreePartitionUserObject;
import com.j_spaces.tools.spacebrowser.benchmark.standalone.tree.BenchmarkTreeUserObject;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.RootWindow;
import net.infonode.docking.SplitWindow;
import net.infonode.docking.View;
import net.infonode.docking.properties.RootWindowProperties;
import net.infonode.docking.theme.ShapedGradientDockingTheme;
import net.infonode.docking.util.AbstractViewMap;
import net.infonode.docking.util.DockingUtil;
import net.infonode.docking.util.ViewMap;
import net.jini.core.discovery.LookupLocator;
import org.openspaces.admin.Admin;
import org.openspaces.admin.AdminFactory;
import org.openspaces.admin.space.Space;
import org.openspaces.admin.space.SpacePartition;
import org.openspaces.admin.space.Spaces;

public class BenchmarkMain
extends JComponent {
    private static Logger LOGGER;
    private final JPanel benchmarkContainer;
    private final JFrame parentFrame;
    private final Map<String, BenchMarkPanel> benchmarkSpacesPanelsMap = new HashMap<String, BenchMarkPanel>();
    private final Map<String, Map<Integer, BenchMarkPanel>> benchmarkSpacesPartitionsPanelsMap = new HashMap<String, Map<Integer, BenchMarkPanel>>();
    private View treeView;
    private View benchmarkView;

    public BenchmarkMain(JFrame parentFrame) {
        this.parentFrame = parentFrame;
        Admin admin = this.createAdmin();
        Spaces spaces = admin.getSpaces();
        final BenchmarkSpacesTree benchmarkSpacesTree = new BenchmarkSpacesTree(spaces);
        benchmarkSpacesTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath selectionPath = benchmarkSpacesTree.getSelectionPath();
                BenchmarkMain.this.benchmarkContainer.removeAll();
                if (selectionPath != null) {
                    Object lastPathComponent = selectionPath.getLastPathComponent();
                    DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)lastPathComponent;
                    BenchmarkTreeUserObject benchmarkUserObject = (BenchmarkTreeUserObject)treeNode.getUserObject();
                    BenchMarkPanel benchmarkPanel = BenchmarkMain.this.getBenchmarkPanel(benchmarkUserObject);
                    benchmarkPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                    BenchmarkMain.this.benchmarkContainer.add((Component)benchmarkPanel, "Center");
                }
                BenchmarkMain.this.benchmarkContainer.revalidate();
                BenchmarkMain.this.benchmarkContainer.repaint();
            }
        });
        this.benchmarkContainer = new JPanel(new BorderLayout());
        this.setLayout(new BorderLayout());
        RootWindow rootWindow = this.createRootWindow(benchmarkSpacesTree);
        this.add((Component)rootWindow, "Center");
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        rootWindow.setWindow((DockingWindow)new SplitWindow(true, 0.15f, (DockingWindow)this.treeView, (DockingWindow)this.benchmarkView));
    }

    private RootWindow createRootWindow(BenchmarkSpacesTree benchmarkSpacesTree) {
        ViewMap viewMap = new ViewMap();
        Icon titleIcon = JSpaceUIUtils.getDockTitleIcon();
        JScrollPane benchmarkScrollPane = new JScrollPane(benchmarkSpacesTree);
        benchmarkScrollPane.setAutoscrolls(true);
        this.treeView = new View("Spaces Tree", titleIcon, (Component)benchmarkScrollPane);
        this.benchmarkView = new View("Benchmark", titleIcon, (Component)this.benchmarkContainer);
        ToolTipManager.sharedInstance().unregisterComponent((JComponent)this.benchmarkView);
        viewMap.addView(0, this.treeView);
        viewMap.addView(1, this.benchmarkView);
        RootWindow rootWindow = DockingUtil.createRootWindow((AbstractViewMap)viewMap, (boolean)false);
        RootWindowProperties rootWindowProperties = this.createRootWindowProperties();
        rootWindow.getRootWindowProperties().addSuperObject(rootWindowProperties);
        return rootWindow;
    }

    public BenchMarkPanel getBenchmarkPanel(BenchmarkTreeUserObject benchmarkUserObject) {
        BenchMarkPanel benchMarkPanel = null;
        BenchmarkTreeNodeType type = benchmarkUserObject.getType();
        Space space = benchmarkUserObject.getSpace();
        String spaceUid = space.getUid();
        if (type == BenchmarkTreeNodeType.SPACE) {
            benchMarkPanel = this.benchmarkSpacesPanelsMap.get(spaceUid);
            if (benchMarkPanel == null) {
                IJSpace clusteredSpace = space.getGigaSpace().getSpace();
                benchMarkPanel = new BenchMarkPanel(this.parentFrame, true, clusteredSpace);
                this.benchmarkSpacesPanelsMap.put(spaceUid, benchMarkPanel);
            }
        } else if (type == BenchmarkTreeNodeType.PARTITION) {
            SpacePartition partition = ((BenchmarkTreePartitionUserObject)benchmarkUserObject).getPartition();
            int partitionId = partition.getPartitionId();
            Map<Integer, BenchMarkPanel> benchmarkPartitionsPanelsMap = this.benchmarkSpacesPartitionsPanelsMap.get(spaceUid);
            if (benchmarkPartitionsPanelsMap == null) {
                benchmarkPartitionsPanelsMap = new HashMap<Integer, BenchMarkPanel>();
                this.benchmarkSpacesPartitionsPanelsMap.put(spaceUid, benchmarkPartitionsPanelsMap);
            }
            if ((benchMarkPanel = benchmarkPartitionsPanelsMap.get(partitionId)) == null) {
                IJSpace primarySpace = partition.getPrimary().getGigaSpace().getSpace();
                benchMarkPanel = new BenchMarkPanel(this.parentFrame, true, primarySpace);
                benchmarkPartitionsPanelsMap.put(partitionId, benchMarkPanel);
            }
        }
        return benchMarkPanel;
    }

    private RootWindowProperties createRootWindowProperties() {
        RootWindowProperties rootWindowProperties = new RootWindowProperties();
        ShapedGradientDockingTheme currentTheme = new ShapedGradientDockingTheme();
        rootWindowProperties.addSuperObject(currentTheme.getRootWindowProperties());
        rootWindowProperties.getDockingWindowProperties().setCloseEnabled(false);
        rootWindowProperties.getDockingWindowProperties().setMaximizeEnabled(true);
        return rootWindowProperties;
    }

    private Admin createAdmin() {
        GSLogConfigLoader.getLoader((String)"ui");
        LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");
        String[] groups = SystemInfo.singleton().lookup().groupsArray();
        LookupLocator[] locators = SystemInfo.singleton().lookup().locatorsArray();
        AdminFactory adminFactory = new AdminFactory();
        adminFactory.discoverUnmanagedSpaces();
        if (groups != null) {
            for (String string : groups) {
                adminFactory.addGroups(string);
            }
        }
        if (locators != null) {
            for (String string : locators) {
                adminFactory.addLocator(string.toString());
            }
        }
        return adminFactory.createAdmin();
    }

    public static void main(String[] args) {
        block2: {
            try {
                MainUI.setLookAndFeel();
            }
            catch (UnsupportedLookAndFeelException e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block2;
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
        Image logoImage = UIHelper.getImageIcon("image/browser/jspacesIcon.png").getImage();
        JFrame frame = new JFrame("Benchmark");
        BenchmarkMain benchmarkStandalone = new BenchmarkMain(frame);
        frame.getContentPane().add(benchmarkStandalone);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(1);
            }
        });
        frame.setIconImage(logoImage);
        frame.setSize(1200, 950);
        frame.setVisible(true);
    }
}

