/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser.benchmark.standalone.tree;

import com.j_spaces.tools.spacebrowser.benchmark.standalone.tree.BenchmarkSpacesTreeRenderer;
import com.j_spaces.tools.spacebrowser.benchmark.standalone.tree.BenchmarkTreePartitionUserObject;
import com.j_spaces.tools.spacebrowser.benchmark.standalone.tree.BenchmarkTreeSpaceUserObject;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.openspaces.admin.space.Space;
import org.openspaces.admin.space.SpaceInstance;
import org.openspaces.admin.space.SpacePartition;
import org.openspaces.admin.space.Spaces;
import org.openspaces.admin.space.events.SpaceInstanceLifecycleEventListener;
import org.openspaces.admin.space.events.SpaceLifecycleEventListener;

public class BenchmarkSpacesTree
extends JTree
implements SpaceLifecycleEventListener,
SpaceInstanceLifecycleEventListener {
    private static Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");
    private MutableTreeNode hiddenRoot;
    private Map<String, MutableTreeNode> spacesMap = new HashMap<String, MutableTreeNode>();
    private Map<String, Map<Integer, MutableTreeNode>> spacePartitionsMap = new HashMap<String, Map<Integer, MutableTreeNode>>();
    private TreePath rootTreePath;

    public BenchmarkSpacesTree(Spaces spaces) {
        super(new DefaultMutableTreeNode("Hidden Root"));
        spaces.addLifecycleListener((SpaceLifecycleEventListener)this);
        this.setRootVisible(false);
        this.hiddenRoot = (MutableTreeNode)this.treeModel.getRoot();
        ((DefaultTreeModel)this.treeModel).reload();
        this.setCellRenderer(new BenchmarkSpacesTreeRenderer());
        Object[] pn = ((DefaultTreeModel)this.treeModel).getPathToRoot(this.hiddenRoot);
        this.rootTreePath = new TreePath(pn);
    }

    private void expandRoot() {
        if (!this.isExpanded(this.rootTreePath)) {
            this.expandPath(this.rootTreePath);
        }
    }

    public void spaceAdded(Space space) {
        LOGGER.info("space added:" + space.getName());
        SpacePartition[] partitions = space.getPartitions();
        LOGGER.info("partitions amount:" + partitions.length);
        DefaultMutableTreeNode spaceTreeNode = new DefaultMutableTreeNode(new BenchmarkTreeSpaceUserObject(space), partitions.length > 1);
        this.spacesMap.put(space.getUid(), spaceTreeNode);
        ((DefaultTreeModel)this.treeModel).insertNodeInto(spaceTreeNode, this.hiddenRoot, this.hiddenRoot.getChildCount());
        this.expandRoot();
    }

    public void spaceRemoved(Space space) {
        LOGGER.info("space removed:" + space.getName());
        String spaceUid = space.getUid();
        MutableTreeNode removedSpaceTreeNode = this.spacesMap.remove(spaceUid);
        if (removedSpaceTreeNode != null) {
            ((DefaultTreeModel)this.treeModel).removeNodeFromParent(removedSpaceTreeNode);
        }
    }

    public void spaceInstanceAdded(SpaceInstance spaceInstance) {
        TreePath spaceTreePath;
        Space space = spaceInstance.getSpace();
        String spaceUid = space.getUid();
        MutableTreeNode spaceTreeNode = this.spacesMap.get(spaceUid);
        SpacePartition partition = spaceInstance.getPartition();
        int partitionId = partition.getPartitionId();
        boolean isExpandSpaceTreeNode = false;
        LOGGER.info("spaceInstanceAdded:" + spaceInstance.getSpaceInstanceName() + ", partitionId" + (partition == null ? "N/A" : Integer.valueOf(partition.getPartitionId())));
        Map<Integer, MutableTreeNode> partitionsTreeNodeMap = this.spacePartitionsMap.get(spaceUid);
        if (partitionsTreeNodeMap == null) {
            partitionsTreeNodeMap = new HashMap<Integer, MutableTreeNode>();
            this.spacePartitionsMap.put(spaceUid, partitionsTreeNodeMap);
            isExpandSpaceTreeNode = true;
        }
        if (!partitionsTreeNodeMap.containsKey(partitionId)) {
            DefaultMutableTreeNode partitionTreeNode = new DefaultMutableTreeNode(new BenchmarkTreePartitionUserObject(partition), false);
            partitionsTreeNodeMap.put(partitionId, partitionTreeNode);
            if (spaceTreeNode != null) {
                ((DefaultTreeModel)this.treeModel).insertNodeInto(partitionTreeNode, spaceTreeNode, spaceTreeNode.getChildCount());
            }
        }
        if (isExpandSpaceTreeNode && !this.isExpanded(spaceTreePath = new TreePath(((DefaultMutableTreeNode)spaceTreeNode).getPath()))) {
            this.expandPath(spaceTreePath);
        }
    }

    public void spaceInstanceRemoved(SpaceInstance spaceInstance) {
        SpacePartition partition = spaceInstance.getPartition();
        LOGGER.info("spaceInstanceRemoved:" + spaceInstance.getSpaceInstanceName() + ", partitionId" + (partition == null ? "N/A" : Integer.valueOf(partition.getPartitionId())));
    }
}

