/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser.benchmark.standalone.tree;

import com.j_spaces.tools.spacebrowser.benchmark.standalone.tree.BenchmarkTreeNodeType;
import com.j_spaces.tools.spacebrowser.benchmark.standalone.tree.BenchmarkTreeUserObject;
import com.j_spaces.tools.spacebrowser.utils.IconsRepository;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class BenchmarkSpacesTreeRenderer
extends DefaultTreeCellRenderer {
    final ImageIcon groupIcon;
    final ImageIcon spaceIcon;

    public BenchmarkSpacesTreeRenderer() {
        String[] treeIcons = JSpaceUIUtils.getResources("tree.icons");
        this.groupIcon = new ImageIcon(this.getClass().getResource("/image/cluster-wizard/cluster_groups.gif"));
        this.spaceIcon = IconsRepository.getInstance().getIcon(50);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object userObject = node.getUserObject();
        if (userObject instanceof BenchmarkTreeUserObject) {
            BenchmarkTreeUserObject benchmarkTreeUserObject = (BenchmarkTreeUserObject)userObject;
            ImageIcon icon = this.getIcon(benchmarkTreeUserObject);
            this.setIcon(icon);
            this.setText(benchmarkTreeUserObject.getName());
        }
        return this;
    }

    private ImageIcon getIcon(BenchmarkTreeUserObject benchmarkUserObject) {
        ImageIcon icon = null;
        BenchmarkTreeNodeType type = benchmarkUserObject.getType();
        switch (type) {
            case SPACE: {
                icon = this.spaceIcon;
                break;
            }
            case PARTITION: {
                icon = this.groupIcon;
            }
        }
        return icon;
    }
}

