/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser.statistics;

import com.gigaspaces.admin.ui.util.UIHelper;
import com.j_spaces.tools.cluster.FileFilterExt;
import com.j_spaces.tools.spacebrowser.statistics.AbstractTracesDefinition;
import com.j_spaces.tools.spacebrowser.statistics.IStatisticsPanelManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class GraphElements
extends JPanel
implements ActionListener {
    private JCheckBox enableHistoryGraphsCheckBox;
    public final AbstractTracesDefinition _tracesDefinitionsBox;
    protected JRadioButton opertionRadio = new JRadioButton("Display Total Operations Count History");
    public JRadioButton tpRadio = new JRadioButton("Display TP[Operations/Sec] History");
    private SpinnerNumberModel timeSpinnerModel;
    private JSpinner timeSpinner;
    private JButton applyButton;
    private JButton clearButton;
    private JButton exportButton;
    private Dimension buttonSize = new Dimension(85, 23);
    private JFileChooser _fileChooser;
    private JFrame _parentFrame;
    private IStatisticsPanelManager _statisticsPanelManager;

    public GraphElements(JFrame parentFrame, AbstractTracesDefinition tracesDefinitionsBox, IStatisticsPanelManager statisticPanelManager, boolean enableStatisticsHistory) {
        super(new BorderLayout());
        this._statisticsPanelManager = statisticPanelManager;
        this._parentFrame = parentFrame;
        this._tracesDefinitionsBox = tracesDefinitionsBox;
        Box centralBox = new Box(1);
        this.enableHistoryGraphsCheckBox = new JCheckBox("Enable History Graphs", enableStatisticsHistory);
        this.enableHistoryGraphsCheckBox.setToolTipText("Enables tracking statistics history.");
        ButtonGroup graphType = new ButtonGroup();
        graphType.add(this.opertionRadio);
        graphType.add(this.tpRadio);
        this._tracesDefinitionsBox.setBorder(BorderFactory.createTitledBorder("Color/Scale Definitions"));
        Box timeDefinitionBox = this.createTimeResolutionComponent();
        centralBox.setPreferredSize(new Dimension(240, 200));
        centralBox.setMaximumSize(new Dimension(240, 200));
        centralBox.add(this._tracesDefinitionsBox);
        centralBox.add(Box.createVerticalStrut(10));
        this.tpRadio.setSelected(true);
        Box cbBox = new Box(0);
        cbBox.add(this.enableHistoryGraphsCheckBox);
        cbBox.add(Box.createHorizontalGlue());
        Box rbBox1 = new Box(0);
        Box rbBox2 = new Box(0);
        rbBox1.add(this.tpRadio);
        rbBox1.add(Box.createHorizontalGlue());
        rbBox2.add(this.opertionRadio);
        rbBox2.add(Box.createHorizontalGlue());
        centralBox.add(Box.createVerticalGlue());
        centralBox.add(timeDefinitionBox);
        centralBox.add(Box.createVerticalStrut(15));
        centralBox.add(rbBox1);
        centralBox.add(Box.createVerticalStrut(1));
        centralBox.add(rbBox2);
        centralBox.add(Box.createVerticalStrut(20));
        centralBox.add(cbBox);
        centralBox.add(Box.createVerticalStrut(35));
        Box buttonsBox = this.createButtonBox();
        this.add((Component)centralBox, "Center");
        this.add((Component)buttonsBox, "South");
        centralBox.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 1));
    }

    public Box createTimeResolutionComponent() {
        this.timeSpinnerModel = new SpinnerNumberModel();
        this.timeSpinnerModel.setMaximum(null);
        this.timeSpinnerModel.setStepSize(10);
        this.timeSpinnerModel.setValue(10);
        this.timeSpinnerModel.setMinimum(Integer.valueOf(1));
        this.timeSpinner = new JSpinner(this.timeSpinnerModel);
        this.timeSpinner.setPreferredSize(new Dimension(70, 22));
        this.timeSpinner.setMaximumSize(new Dimension(70, 22));
        this.applyButton = new JButton("Apply");
        this.applyButton.setToolTipText("Apply measurement duration in minutes");
        this.applyButton.setMaximumSize(this.buttonSize);
        this.applyButton.setMaximumSize(this.buttonSize);
        this.applyButton.setMinimumSize(this.buttonSize);
        JLabel minutesLabel = new JLabel("minutes");
        Box timeResolutionBox = new Box(0);
        timeResolutionBox.add(this.timeSpinner);
        timeResolutionBox.add(Box.createHorizontalStrut(3));
        timeResolutionBox.add(minutesLabel);
        timeResolutionBox.add(Box.createHorizontalStrut(15));
        timeResolutionBox.add(this.applyButton);
        timeResolutionBox.setBorder(BorderFactory.createTitledBorder("History Measurement Duration"));
        timeResolutionBox.setPreferredSize(new Dimension(243, 55));
        timeResolutionBox.setMaximumSize(new Dimension(243, 55));
        this.applyButton.addActionListener(this);
        return timeResolutionBox;
    }

    private Box createButtonBox() {
        this.clearButton = new JButton("Clear Graph");
        this.exportButton = new JButton("Export");
        Box buttonsBox = new Box(0);
        buttonsBox.add(Box.createHorizontalGlue());
        buttonsBox.add(this.exportButton);
        buttonsBox.add(Box.createHorizontalStrut(10));
        buttonsBox.add(this.clearButton);
        buttonsBox.add(Box.createHorizontalGlue());
        this.exportButton.setPreferredSize(this.buttonSize);
        this.clearButton.setPreferredSize(this.buttonSize);
        this.exportButton.setMaximumSize(this.buttonSize);
        this.clearButton.setMaximumSize(this.buttonSize);
        this.exportButton.setMinimumSize(this.buttonSize);
        this.clearButton.setMinimumSize(this.buttonSize);
        this.exportButton.setToolTipText("Select Excel file for export history data");
        this.clearButton.setToolTipText("<HTML>Clear both Statistics History graphs<BR>and restart measurement</HTML>");
        this.clearButton.addActionListener(this);
        this.exportButton.addActionListener(this);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
        return buttonsBox;
    }

    public void updateBackgrounds() {
        this._tracesDefinitionsBox.updateBackgrounds();
    }

    public boolean isHistoryGraphsEnabled() {
        return this.enableHistoryGraphsCheckBox.isSelected();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.clearButton)) {
            int selOption = JOptionPane.showConfirmDialog(this._statisticsPanelManager.getParentFrame(), "Do you want to export graphs history to file before clearing?", "Clear History Graphs", 0, 1);
            if (selOption == 0) {
                this.performExportStatistics();
            }
            this._statisticsPanelManager.clearStatisticsHistoryGraphs((Integer)this.timeSpinnerModel.getValue());
        } else if (source.equals(this.exportButton)) {
            this.performExportStatistics();
        } else if (source.equals(this.applyButton)) {
            Map<Integer, Boolean> operationsSelectionMap = this._tracesDefinitionsBox.getOperationsSelectionMap();
            this._statisticsPanelManager.apply((Integer)this.timeSpinnerModel.getValue(), operationsSelectionMap);
        }
    }

    private void performExportStatistics() {
        int selOption;
        if (this._fileChooser == null) {
            try {
                this._parentFrame.setCursor(Cursor.getPredefinedCursor(3));
                File statisticsFolder = GraphElements.getUIStatisticsHistoryHomeDirectory();
                this._fileChooser = new JFileChooser(statisticsFolder);
                FileFilterExt xlsFilter = new FileFilterExt("xls", "Excel xls file");
                this._fileChooser.addChoosableFileFilter(xlsFilter);
            }
            finally {
                this._parentFrame.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        if ((selOption = this._fileChooser.showSaveDialog(this._parentFrame)) == 0) {
            File selectedFile = this._fileChooser.getSelectedFile();
            String selPath = selectedFile.getPath();
            if (!selPath.endsWith(".xls")) {
                selPath = selPath + ".xls";
            }
            this._statisticsPanelManager.saveStatisticsHistoryToFile(selPath);
        }
    }

    public static File getUIStatisticsHistoryHomeDirectory() {
        UIHelper.getProductUIHomeDirectory();
        String dirPath = UIHelper.getProductUIHomeDirectoryName() + File.separator + "statistics_history";
        File statisticsFolder = new File(dirPath);
        if (!statisticsFolder.exists()) {
            statisticsFolder.mkdir();
        }
        return statisticsFolder;
    }
}

