/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser.statistics;

import com.j_spaces.tools.spacebrowser.statistics.IColorMap;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class PieGraph
extends JComponent {
    private static final int Y_AXIS_X_START = 43;
    private static final int AXIS_HALF_WIDTH = 5;
    private static final int NUM_OF_INTERVALS = 10;
    private static final int X_AXIS_TEXT_START = 1;
    private static final int TEXT_X_OFFSET = 1;
    private static final double HEIGHT_OFFSET = 25.0;
    private static final int TEXT_Y_OFFSET = 15;
    private List _slicesList;
    private List _slicesTPList;
    private final IColorMap _colorMap;
    private static int timeTp = 1;
    private static NumberFormat nf = new DecimalFormat();

    public PieGraph(IColorMap colorMap) {
        this.setBackground(Color.WHITE);
        this._colorMap = colorMap;
    }

    public void setPie(ArrayList slicesList, int timeInterval) {
        timeTp = timeInterval;
        this._slicesTPList = this._slicesList;
        this._slicesList = slicesList;
        this.repaint();
    }

    public PieValue getPieValue(long arg, Color color) {
        return new PieValue(arg, color);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this._slicesList != null) {
            this.drawBar((Graphics2D)g, this.getBounds(), this._slicesList, this._slicesTPList, timeTp);
        }
    }

    public void drawBar(Graphics2D g, Rectangle2D area, List slices, List slicesTp, int timeTp) {
        long valueMax = 0L;
        long value = 0L;
        int size = slices.size();
        for (int i = 0; i < size; ++i) {
            value = ((PieValue)slices.get((int)i)).value;
            if (valueMax >= value) continue;
            valueMax = value;
        }
        if (valueMax == 0L) {
            valueMax = 1000L;
        }
        double logicHeight = area.getHeight() - 50.0;
        double scale = logicHeight / (double)valueMax;
        this.drawAxis(g, area, valueMax, scale);
        for (int i = 0; i < size; ++i) {
            value = ((PieValue)slices.get((int)i)).value;
            int yLength = (int)(scale * (double)value);
            int yStart = (int)(logicHeight - (double)yLength);
            int xWidth = (int)(area.getWidth() / (double)(2 * size + 1));
            int xStart = i == 0 ? 43 : (1 + 2 * i) * xWidth;
            g.setColor(((PieValue)slices.get((int)i)).color);
            String valueStr = JSpaceUIUtils.formatBigValue(value, true);
            String tp = "";
            if (slicesTp != null && slicesTp.size() > i) {
                PieValue pieValue = (PieValue)slicesTp.get(i);
                long valueTp = (value - pieValue.value) / (long)timeTp;
                tp = String.valueOf(valueTp) + " TP";
            }
            yStart = (int)((double)yStart + 25.0);
            g.drawString(valueStr, (float)(xStart + 1), (float)(yStart - 15));
            g.drawString(tp, (float)(xStart + 1), (float)(yStart - 2));
            g.fill3DRect(xStart, yStart, xWidth, yLength, true);
            g.setColor(Color.BLACK);
            String name = this._colorMap.getNameMapping().get(((PieValue)slices.get((int)i)).color);
            int strX = xStart;
            if (name != null && name.equals("Notify reg.")) {
                strX -= 4;
            }
            if (name != null) {
                g.drawString(name, strX + 1, (int)logicHeight + 15 + 25);
            }
            g.draw3DRect(xStart, yStart, xWidth, yLength, true);
            g.setColor(Color.GRAY);
        }
    }

    private void drawAxis(Graphics2D g, Rectangle2D area, long max, double scale) {
        int areaHeight = (int)(area.getHeight() - 25.0);
        g.setColor(Color.BLACK);
        g.drawLine(43, 0, 43, areaHeight);
        int xAxisYCoordinate = areaHeight;
        long eachIntervalValue = max / 10L;
        for (int index = 0; index <= 10; ++index) {
            int y = areaHeight - (int)(scale * (double)index * (double)eachIntervalValue);
            g.drawLine(38, y, 48, y);
            String value = String.valueOf(eachIntervalValue * (long)index);
            int oneK = 1000;
            if (value.length() > 10) {
                value = nf.format((double)eachIntervalValue * (double)index / (double)(oneK * oneK * oneK)) + "G";
            } else if (value.length() > 7) {
                value = nf.format((double)eachIntervalValue * (double)index / (double)(oneK * oneK)) + "M";
            } else if (value.length() > 4) {
                value = nf.format((double)eachIntervalValue * (double)index / (double)oneK) + "K";
            }
            g.drawString(value, 1, y + (index == 0 ? 5 : 10));
        }
        g.drawLine(43, xAxisYCoordinate, (int)area.getWidth(), xAxisYCoordinate);
    }

    static {
        nf.setMaximumFractionDigits(1);
    }

    private class PieValue {
        long value;
        Color color;

        public PieValue(long value, Color color) {
            this.value = value;
            this.color = color;
        }
    }
}

