/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser.statistics;

import com.gigaspaces.admin.ui.grid.Repository;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.tools.IRefreshable;
import com.j_spaces.tools.spacebrowser.statistics.blobstore.BlobStoreStatisticsPanel;
import com.j_spaces.tools.spacebrowser.statistics.space_operations.ISpaceStatistics;
import com.j_spaces.tools.spacebrowser.statistics.space_operations.SpaceStatisticsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class StatisticPanel
extends JPanel
implements IRefreshable,
ISpaceStatistics {
    private SpaceStatisticsPanel _spaceStatisticsPanel;
    private BlobStoreStatisticsPanel _blobStoreStatisticsPanel;
    protected final JFrame _parentFrame;
    private final boolean _enableStatisticsHistory;
    private JTabbedPane _tabPanel = new JTabbedPane();
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui.spacebrowser");
    private boolean _isBlobStoreEnabled;

    public StatisticPanel(JFrame parentFrame) {
        this(parentFrame, true);
    }

    public StatisticPanel(JFrame parentFrame, boolean enableStatisticsHistory) {
        this._parentFrame = parentFrame;
        this._enableStatisticsHistory = enableStatisticsHistory;
        this.initInnerStatisticsPanels();
    }

    private void initInnerStatisticsPanels() {
        this.setLayout(new BorderLayout());
        this._spaceStatisticsPanel = new SpaceStatisticsPanel(this._parentFrame, this._enableStatisticsHistory);
        this._blobStoreStatisticsPanel = new BlobStoreStatisticsPanel(this._parentFrame, this._enableStatisticsHistory);
        this.add((Component)this._tabPanel, "Center");
        this._tabPanel.addTab("Operations", this._spaceStatisticsPanel);
        this._tabPanel.addTab("MemoryXtend", this._blobStoreStatisticsPanel);
    }

    public void setSpace(IJSpace space, String spaceName) {
        int cachePolicyValue;
        block3: {
            cachePolicyValue = -1;
            try {
                IRemoteJSpaceAdmin adminObj = Repository.addSpaceAdminObjectToMap(space);
                SpaceConfig spaceConfig = Repository.addSpaceConfigToMap(adminObj);
                String cachePolicy = spaceConfig.getCachePolicy();
                cachePolicyValue = Integer.parseInt(cachePolicy);
            }
            catch (RemoteException e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block3;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
        this._isBlobStoreEnabled = cachePolicyValue == 3;
        this._tabPanel.setEnabledAt(this._tabPanel.indexOfComponent(this._blobStoreStatisticsPanel), this._isBlobStoreEnabled);
        this._spaceStatisticsPanel.setSpace(space, spaceName);
        if (this._isBlobStoreEnabled) {
            this._blobStoreStatisticsPanel.setSpace(space, spaceName);
        }
    }

    @Override
    public void refresh() {
        this._spaceStatisticsPanel.refresh();
        if (this._isBlobStoreEnabled) {
            this._blobStoreStatisticsPanel.refresh();
        }
    }

    @Override
    public boolean isRunning() {
        return false;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    public void stopRefresh() {
        this._spaceStatisticsPanel.stopRefresh();
        this._blobStoreStatisticsPanel.stopRefresh();
    }

    @Override
    public void setInvokeRefresh(boolean invokeRefresh) {
    }

    public JFrame getParentFrame() {
        return this._parentFrame;
    }
}

