/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser.statistics.blobstore;

import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.views.utils.BasicTable;
import com.gigaspaces.admin.ui.views.utils.BasicWrapper;
import com.gigaspaces.server.blobstore.BlobStoreStatistics;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.admin.StatisticsAdmin;
import com.j_spaces.core.filters.StatisticsHolder;
import com.j_spaces.tools.IRefreshable;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.statistics.blobstore.BlobStoreStatisticsWrapper;
import com.j_spaces.tools.spacebrowser.statistics.blobstore.BlobStoreTable;
import com.j_spaces.tools.spacebrowser.statistics.blobstore.BlobStoreTableModel;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import com.j_spaces.tools.spacebrowser.utils.RefreshPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class BlobStoreStatisticsPanel
extends JPanel
implements IRefreshable {
    private StatisticsAdmin stats;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui.spacebrowser");
    protected boolean isExceptionShown = false;
    private static final String ROCKS_DB_STATISTICS_MEMTABLE_HIT = "MemTable Hits";
    private static final String ROCKS_DB_STATISTICS_MEMTABLE_MISS = "MemTable Misses";
    private static final String ROCKS_DB_STATISTICS_GET_HIT_L0 = "Get Queries Served By L0";
    private static final String ROCKS_DB_STATISTICS_GET_HIT_L1 = "Get Queries Served By L1";
    private static final String ROCKS_DB_STATISTICS_GET_HIT_L2_AND_UP = "Get Queries Served By L2 And Up";
    private static final String ROCKS_DB_STATISTICS_NUMBER_KEYS_WRITTEN = "Keys Written";
    private static final String ROCKS_DB_STATISTICS_NUMBER_KEYS_READ = "Keys Read";
    private static final String ROCKS_DB_STATISTICS_NUMBER_KEYS_UPDATED = "Keys Updated";
    private static final String ROCKS_DB_STATISTICS_BYTES_WRITTEN = "Bytes Sent";
    private static final String ROCKS_DB_STATISTICS_BYTES_READ = "Bytes Received Via Get";
    private static final String ROCKS_DB_STATISTICS_ITER_BYTES_READ = "Bytes Received Via Iterator";
    private static final String ROCKS_DB_STATISTICS_NUMBER_MULTI_GET_CALLS = "MultiGet Calls";
    private static final String ROCKS_DB_STATISTICS_NUMBER_MULTI_GET_KEYS_READ = "Keys Read Via MultiGet";
    private static final String ROCKS_DB_STATISTICS_NUMBER_MULTI_GET_BYTES_READ = "Bytes Received Via MultiGet";
    private static final String ROCKS_DB_STATISTICS_MEMTABLE_HIT_TOOLTIP = "Number Of MemTable Hits";
    private static final String ROCKS_DB_STATISTICS_MEMTABLE_MISS_TOOLTIP = "Number Of MemTable Misses";
    private static final String ROCKS_DB_STATISTICS_GET_HIT_L0_TOOLTIP = "Number Of Get Queries Served By L0";
    private static final String ROCKS_DB_STATISTICS_GET_HIT_L1_TOOLTIP = "Number Of Get Queries Served By L1";
    private static final String ROCKS_DB_STATISTICS_GET_HIT_L2_AND_UP_TOOLTIP = "Number Of Get Queries Served By L2 And Up";
    private static final String ROCKS_DB_STATISTICS_NUMBER_KEYS_WRITTEN_TOOLTIP = "Number Of Keys Written To RocksDB";
    private static final String ROCKS_DB_STATISTICS_NUMBER_KEYS_READ_TOOLTIP = "Number Of Keys Read From RocksDB";
    private static final String ROCKS_DB_STATISTICS_NUMBER_KEYS_UPDATED_TOOLTIP = "Number Keys Updated, If In-Place Update Is Enable";
    private static final String ROCKS_DB_STATISTICS_BYTES_WRITTEN_TOOLTIP = "Number Of Uncompressed Bytes Issued By DB::Put(), DB::Delete(), DB::Merge(), And DB::Write()";
    private static final String ROCKS_DB_STATISTICS_BYTES_READ_TOOLTIP = "Number Of Uncompressed Bytes Read From DB::Get()";
    private static final String ROCKS_DB_STATISTICS_ITER_BYTES_READ_TOOLTIP = "Number Of Uncompressed Bytes Read From An Iterator (Initial Load)";
    private static final String ROCKS_DB_STATISTICS_NUMBER_MULTI_GET_CALLS_TOOLTIP = "Number Of MultiGet Calls";
    private static final String ROCKS_DB_STATISTICS_NUMBER_MULTI_GET_KEYS_READ_TOOLTIP = "Number Of Keys Read Via MultiGet Calls";
    private static final String ROCKS_DB_STATISTICS_NUMBER_MULTI_GET_BYTES_READ_TOOLTIP = "Number Of Bytes Received Via MultiGet Calls";
    private static final String CACHE_STATISTICS_USED_CACHE_SIZE = "Used Cache Size";
    private static final String CACHE_STATISTICS_CACHE_MISS = "Cache Miss";
    private static final String CACHE_STATISTICS_CACHE_HIT = "Cache Hit";
    private static final String CACHE_STATISTICS_HOT_DATA_CACHE_MISS = "Hot Data Cache Miss";
    private static final String CACHE_STATISTICS_OFFHEAP_CACHE_USED = "Used Off-Heap Cache";
    protected RefreshPanel refreshPanel;
    protected JFrame _parentFrame;
    private boolean _isStatisticsAvailable;
    private String _spaceName;
    protected final String blobStoreMetricsPrefix = "space_blobstore";
    private boolean _displayRocksDbStats;
    private final BlobStoreTableModel _cacheStatisticsTableModel;
    private final BlobStoreTableModel _rocksDbStatisticsTableModel;
    private final Box _tablesBox;
    private final BasicTable _rocksDbStatisticsTable;
    private final BasicTable _cacheStatisticsTable;
    private Long _totalCacheSize;
    private Long _offHeapCacheMemoryThreshold;

    public BlobStoreStatisticsPanel(JFrame parentFrame, boolean enableStatisticsHistory) {
        this._parentFrame = parentFrame;
        this.setBackground(Color.WHITE);
        this.setPreferredSize(new Dimension(800, 600));
        this.setBackground(Color.WHITE);
        this.setLayout(new BorderLayout());
        this.refreshPanel = new RefreshPanel(this, false);
        this.refreshPanel.setSelectedRefreshRate(3000);
        this._rocksDbStatisticsTableModel = new BlobStoreTableModel();
        this._rocksDbStatisticsTable = new BlobStoreTable(this._rocksDbStatisticsTableModel);
        this._cacheStatisticsTableModel = new BlobStoreTableModel();
        this._cacheStatisticsTable = new BlobStoreTable(this._cacheStatisticsTableModel);
        this.setTableProperties(this._rocksDbStatisticsTable);
        this.setTableProperties(this._cacheStatisticsTable);
        this._tablesBox = new Box(1);
        this.add((Component)this._tablesBox, "Center");
        this.add((Component)this.refreshPanel, "North");
    }

    private void addTables(boolean displayRocksDbStats) {
        JScrollPane cacheStatisticsScrollPane = new JScrollPane(this._cacheStatisticsTable);
        cacheStatisticsScrollPane.setBorder(BorderFactory.createTitledBorder("Cache Statistics"));
        this._tablesBox.add(cacheStatisticsScrollPane);
        if (displayRocksDbStats) {
            cacheStatisticsScrollPane.setMaximumSize(new Dimension(10000, 150));
            cacheStatisticsScrollPane.setPreferredSize(new Dimension(10000, 150));
            JScrollPane rocksDbStatisticsScrollPane = new JScrollPane(this._rocksDbStatisticsTable);
            rocksDbStatisticsScrollPane.setBorder(BorderFactory.createTitledBorder("RocksDB Statistics"));
            this._tablesBox.add(rocksDbStatisticsScrollPane);
        }
    }

    private void setTableProperties(JTable table) {
        JTableHeader header = table.getTableHeader();
        header.setReorderingAllowed(false);
        TableColumnModel tableColumnModel = table.getColumnModel();
        TableColumn nameColumn = tableColumnModel.getColumn(0);
        TableColumn valueColumn = tableColumnModel.getColumn(0);
        nameColumn.setPreferredWidth(135);
        valueColumn.setPreferredWidth(90);
        table.setAutoCreateColumnsFromModel(false);
        table.setSelectionMode(0);
        table.setAutoResizeMode(1);
        table.setAutoscrolls(true);
    }

    public void setSpace(IJSpace space, String spaceName) {
        try {
            IRemoteJSpaceAdmin admin = Repository.addSpaceAdminObjectToMap(space);
            this._spaceName = spaceName;
            SpaceConfig spaceConfig = Repository.addSpaceConfigToMap(admin);
            Properties blobStoreProperties = spaceConfig.getBlobStoreProperties();
            Object blobStoreHandler = blobStoreProperties.get("blobStoreHandler");
            String totalCacheSizeStr = (String)blobStoreProperties.get("space-config.engine.blobstore_cache_size");
            String offHeapCacheMemoryThresholdStr = (String)blobStoreProperties.get("off-heap-cache-memory-threshold");
            this._totalCacheSize = totalCacheSizeStr == null ? null : new Long(totalCacheSizeStr);
            this._offHeapCacheMemoryThreshold = offHeapCacheMemoryThresholdStr == null ? null : new Long(offHeapCacheMemoryThresholdStr);
            boolean bl = this._displayRocksDbStats = blobStoreHandler != null && blobStoreHandler.equals("RocksDBBlobStoreHandler");
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("> setSpace, blobStoreHandler=" + blobStoreHandler);
                _logger.fine("> setSpace, _displayRocksDbStats=" + this._displayRocksDbStats);
            }
            this.addTables(this._displayRocksDbStats);
            if (!(admin instanceof StatisticsAdmin)) {
                return;
            }
            this.stats = (StatisticsAdmin)admin;
            this._isStatisticsAvailable = this.stats.isStatisticsAvailable();
            if (!this._isStatisticsAvailable) {
                String message = "Blob Store Statistics for Space \"" + spaceName + "\" not Available. Please Start the Statistics Filter.";
                JOptionPane.showMessageDialog(this._parentFrame, message, "Blob Store Statistics", -1);
                return;
            }
            if (this.refreshPanel.isStop()) {
                this.refreshPanel.startStatusRuntime();
            }
        }
        catch (RemoteException e) {
            return;
        }
    }

    @Override
    public void refresh() {
        block15: {
            try {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("> REFRESH, space name=" + this._spaceName);
                }
                if (this._isStatisticsAvailable) {
                    BlobStoreStatistics blobStoreStatistics;
                    StatisticsHolder statisticsHolder;
                    if (this._displayRocksDbStats) {
                        ArrayList<BasicWrapper> rocksDbStatisticsWrappersList = new ArrayList<BasicWrapper>();
                        Map blobStoreStatisticsMap = this.stats.getMetricSnapshots(Arrays.asList("space_blobstore"));
                        Long memtableHit = (Long)blobStoreStatisticsMap.get("space_blobstore_memtable-hit");
                        Long memtableMiss = (Long)blobStoreStatisticsMap.get("space_blobstore_memtable-miss");
                        Long getHitL0 = (Long)blobStoreStatisticsMap.get("space_blobstore_get-hit-l0");
                        Long getHitL1 = (Long)blobStoreStatisticsMap.get("space_blobstore_get-hit-l1");
                        Long getHitL2AndUp = (Long)blobStoreStatisticsMap.get("space_blobstore_get-hit-l2-and-up");
                        Long numberKeysWritten = (Long)blobStoreStatisticsMap.get("space_blobstore_number-keys-written");
                        Long numberKeysRead = (Long)blobStoreStatisticsMap.get("space_blobstore_number-keys-read");
                        Long numberKeysUpdated = (Long)blobStoreStatisticsMap.get("space_blobstore_number-keys-updated");
                        Long bytesWritten = (Long)blobStoreStatisticsMap.get("space_blobstore_bytes-written");
                        Long bytesRead = (Long)blobStoreStatisticsMap.get("space_blobstore_bytes-read");
                        Long iterBytesRead = (Long)blobStoreStatisticsMap.get("space_blobstore_iter-bytes-read");
                        Long numberMultigetCalls = (Long)blobStoreStatisticsMap.get("space_blobstore_number-multiget-calls");
                        Long numberMultigetKeysRead = (Long)blobStoreStatisticsMap.get("space_blobstore_number-multiget-keys-read");
                        Long numberMultigetBytesRead = (Long)blobStoreStatisticsMap.get("space_blobstore_number-multiget-bytes-read");
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.fine("> memtableHit=" + memtableHit);
                            _logger.fine("> memtableMiss=" + memtableMiss);
                            _logger.fine("> getHitL0=" + getHitL0);
                            _logger.fine("> getHitL1=" + getHitL1);
                            _logger.fine("> getHitL2AndUp=" + getHitL2AndUp);
                            _logger.fine("> numberKeysWritten=" + numberKeysWritten);
                            _logger.fine("> numberKeysRead=" + numberKeysRead);
                            _logger.fine("> numberKeysUpdated=" + numberKeysUpdated);
                            _logger.fine("> bytesWritten=" + bytesWritten);
                            _logger.fine("> bytesRead=" + bytesRead);
                            _logger.fine("> iterBytesRead=" + iterBytesRead);
                            _logger.fine("> numberMultigetCalls=" + numberMultigetCalls);
                            _logger.fine("> numberMultigetKeysRead=" + numberMultigetKeysRead);
                            _logger.fine("> numberMultigetBytesRead=" + numberMultigetBytesRead);
                            _logger.fine(numberMultigetBytesRead.getClass().getName());
                            _logger.fine("\n");
                        }
                        rocksDbStatisticsWrappersList.add(new BlobStoreStatisticsWrapper(ROCKS_DB_STATISTICS_MEMTABLE_HIT, ROCKS_DB_STATISTICS_MEMTABLE_HIT_TOOLTIP, memtableHit, JSpaceUIUtils.formatBigValue(memtableHit.longValue())));
                        rocksDbStatisticsWrappersList.add(new BlobStoreStatisticsWrapper(ROCKS_DB_STATISTICS_MEMTABLE_MISS, ROCKS_DB_STATISTICS_MEMTABLE_MISS_TOOLTIP, memtableMiss, JSpaceUIUtils.formatBigValue(memtableMiss.longValue())));
                        rocksDbStatisticsWrappersList.add(new BlobStoreStatisticsWrapper(ROCKS_DB_STATISTICS_GET_HIT_L0, ROCKS_DB_STATISTICS_GET_HIT_L0_TOOLTIP, getHitL0, JSpaceUIUtils.formatBigValue(getHitL0.longValue())));
                        rocksDbStatisticsWrappersList.add(new BlobStoreStatisticsWrapper(ROCKS_DB_STATISTICS_GET_HIT_L1, ROCKS_DB_STATISTICS_GET_HIT_L1_TOOLTIP, getHitL1, JSpaceUIUtils.formatBigValue(getHitL1.longValue())));
                        rocksDbStatisticsWrappersList.add(new BlobStoreStatisticsWrapper(ROCKS_DB_STATISTICS_GET_HIT_L2_AND_UP, ROCKS_DB_STATISTICS_GET_HIT_L2_AND_UP_TOOLTIP, getHitL2AndUp, JSpaceUIUtils.formatBigValue(getHitL2AndUp.longValue())));
                        rocksDbStatisticsWrappersList.add(new BlobStoreStatisticsWrapper(ROCKS_DB_STATISTICS_NUMBER_KEYS_WRITTEN, ROCKS_DB_STATISTICS_NUMBER_KEYS_WRITTEN_TOOLTIP, numberKeysWritten, JSpaceUIUtils.formatBigValue(numberKeysWritten.longValue())));
                        rocksDbStatisticsWrappersList.add(new BlobStoreStatisticsWrapper(ROCKS_DB_STATISTICS_NUMBER_KEYS_READ, ROCKS_DB_STATISTICS_NUMBER_KEYS_READ_TOOLTIP, numberKeysRead, JSpaceUIUtils.formatBigValue(numberKeysRead.longValue())));
                        rocksDbStatisticsWrappersList.add(new BlobStoreStatisticsWrapper(ROCKS_DB_STATISTICS_NUMBER_KEYS_UPDATED, ROCKS_DB_STATISTICS_NUMBER_KEYS_UPDATED_TOOLTIP, numberKeysUpdated, JSpaceUIUtils.formatBigValue(numberKeysUpdated.longValue())));
                        JSpaceUIUtils.FormattedValue bytesWrittenFormattedValue = JSpaceUIUtils.formatBytesBigValue(bytesWritten.longValue());
                        rocksDbStatisticsWrappersList.add(new BlobStoreStatisticsWrapper(ROCKS_DB_STATISTICS_BYTES_WRITTEN, ROCKS_DB_STATISTICS_BYTES_WRITTEN_TOOLTIP, bytesWritten, bytesWrittenFormattedValue.toString()));
                        JSpaceUIUtils.FormattedValue bytesReadFormattedValue = JSpaceUIUtils.formatBytesBigValue(bytesRead.longValue());
                        rocksDbStatisticsWrappersList.add(new BlobStoreStatisticsWrapper(ROCKS_DB_STATISTICS_BYTES_READ, ROCKS_DB_STATISTICS_BYTES_READ_TOOLTIP, bytesRead, bytesReadFormattedValue.toString()));
                        JSpaceUIUtils.FormattedValue iterBytesReadFormattedValue = JSpaceUIUtils.formatBytesBigValue(iterBytesRead.longValue());
                        rocksDbStatisticsWrappersList.add(new BlobStoreStatisticsWrapper(ROCKS_DB_STATISTICS_ITER_BYTES_READ, ROCKS_DB_STATISTICS_ITER_BYTES_READ_TOOLTIP, iterBytesRead, iterBytesReadFormattedValue.toString()));
                        rocksDbStatisticsWrappersList.add(new BlobStoreStatisticsWrapper(ROCKS_DB_STATISTICS_NUMBER_MULTI_GET_CALLS, ROCKS_DB_STATISTICS_NUMBER_MULTI_GET_CALLS_TOOLTIP, numberMultigetCalls, JSpaceUIUtils.formatBigValue(numberMultigetCalls.longValue())));
                        rocksDbStatisticsWrappersList.add(new BlobStoreStatisticsWrapper(ROCKS_DB_STATISTICS_NUMBER_MULTI_GET_KEYS_READ, ROCKS_DB_STATISTICS_NUMBER_MULTI_GET_KEYS_READ_TOOLTIP, numberMultigetKeysRead, JSpaceUIUtils.formatBigValue(numberMultigetKeysRead.longValue())));
                        JSpaceUIUtils.FormattedValue numberMultigetBytesReadFormattedValue = JSpaceUIUtils.formatBytesBigValue(numberMultigetBytesRead.longValue());
                        rocksDbStatisticsWrappersList.add(new BlobStoreStatisticsWrapper(ROCKS_DB_STATISTICS_NUMBER_MULTI_GET_BYTES_READ, ROCKS_DB_STATISTICS_NUMBER_MULTI_GET_BYTES_READ_TOOLTIP, numberMultigetBytesRead, numberMultigetBytesReadFormattedValue.toString()));
                        this._rocksDbStatisticsTableModel.setWrappersList(rocksDbStatisticsWrappersList, true);
                    }
                    if ((statisticsHolder = this.stats.getHolder()) != null && (blobStoreStatistics = statisticsHolder.getBlobStoreStatistics()) != null) {
                        ArrayList<BasicWrapper> cacheStatisticsWrappersList = new ArrayList<BasicWrapper>(5);
                        long cacheMissCount = blobStoreStatistics.getCacheMissCount();
                        long cacheHitCount = blobStoreStatistics.getCacheHitCount();
                        long usedCacheSize = blobStoreStatistics.getCacheSize();
                        long offHeapCacheUsedBytes = blobStoreStatistics.getOffHeapCacheUsedBytes();
                        long hotDataCacheMissCount = blobStoreStatistics.getHotDataCacheMissCount();
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.fine("> cacheMissCount=" + cacheMissCount);
                            _logger.fine("> cacheHitCount=" + cacheHitCount);
                            _logger.fine("> usedCacheSize=" + usedCacheSize);
                            _logger.fine("> offHeapCacheUsedBytes=" + offHeapCacheUsedBytes);
                            _logger.fine("> hotDataCacheMissCount=" + hotDataCacheMissCount);
                            _logger.fine("\n");
                        }
                        cacheStatisticsWrappersList.add(new BlobStoreStatisticsWrapper(CACHE_STATISTICS_CACHE_HIT, CACHE_STATISTICS_CACHE_HIT, cacheHitCount, JSpaceUIUtils.formatBigValue(cacheHitCount)));
                        cacheStatisticsWrappersList.add(new BlobStoreStatisticsWrapper(CACHE_STATISTICS_CACHE_MISS, CACHE_STATISTICS_CACHE_MISS, cacheMissCount, JSpaceUIUtils.formatBigValue(cacheMissCount)));
                        cacheStatisticsWrappersList.add(new BlobStoreStatisticsWrapper(CACHE_STATISTICS_HOT_DATA_CACHE_MISS, CACHE_STATISTICS_HOT_DATA_CACHE_MISS, hotDataCacheMissCount, JSpaceUIUtils.formatBigValue(hotDataCacheMissCount)));
                        String val = JSpaceUIUtils.formatBigValue(usedCacheSize);
                        String total = JSpaceUIUtils.formatBigValue(this._totalCacheSize.longValue());
                        String usedCacheFullStr = val + " of " + total;
                        cacheStatisticsWrappersList.add(new BlobStoreStatisticsWrapper(CACHE_STATISTICS_USED_CACHE_SIZE, CACHE_STATISTICS_USED_CACHE_SIZE, usedCacheSize, usedCacheFullStr));
                        JSpaceUIUtils.FormattedValue offHeapCacheUsedBytesFormattedValue = JSpaceUIUtils.formatBytesBigValue(offHeapCacheUsedBytes);
                        String offHeapCacheUsedBytesFullStr = this._offHeapCacheMemoryThreshold == null ? offHeapCacheUsedBytesFormattedValue.toString() : offHeapCacheUsedBytesFormattedValue.toString() + " of " + JSpaceUIUtils.formatBytesBigValue(this._offHeapCacheMemoryThreshold.longValue());
                        cacheStatisticsWrappersList.add(new BlobStoreStatisticsWrapper(CACHE_STATISTICS_OFFHEAP_CACHE_USED, CACHE_STATISTICS_OFFHEAP_CACHE_USED, offHeapCacheUsedBytes, offHeapCacheUsedBytesFullStr));
                        this._cacheStatisticsTableModel.setWrappersList(cacheStatisticsWrappersList, true);
                    }
                }
            }
            catch (NoSuchObjectException e) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, e.toString(), e);
                }
            }
            catch (ConnectException e) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, e.toString(), e);
                }
            }
            catch (ConnectIOException e) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, e.toString(), e);
                }
            }
            catch (Exception e) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, e.toString(), e);
                }
                if (this.isExceptionShown) break block15;
                SpaceBrowser.showException(e.toString(), e);
                this.isExceptionShown = true;
            }
        }
    }

    @Override
    public boolean isRunning() {
        return false;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    public void stopRefresh() {
        if (this.refreshPanel != null) {
            this.refreshPanel.stopStatusRuntime();
        }
    }

    @Override
    public void setInvokeRefresh(boolean invokeRefresh) {
    }
}

