/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser.statistics.space_operations;

import com.gigaspaces.admin.ui.grid.Repository;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.StatisticsAdmin;
import com.j_spaces.core.filters.StatisticsContext;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.cluster.EditCluster;
import com.j_spaces.tools.cluster.view.ServiceManagerImpl;
import com.j_spaces.tools.spacebrowser.statistics.space_operations.SpaceStatisticsPanel;
import com.j_spaces.tools.spacebrowser.utils.ClusterUIUtils;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import net.jini.core.lookup.ServiceID;

public class ClusterSpaceStatisticPanel
extends SpaceStatisticsPanel {
    private ServiceID[] basicStats;
    private ServiceID[] notifyAndExecuteStats;
    private ServiceManagerImpl _serviceManager;
    private String _clusterName;
    private boolean _isInvokeRefresh = true;
    private Map<ServiceID, Boolean> _basicStatisticsMap = new HashMap<ServiceID, Boolean>();
    private Map<ServiceID, Boolean> _notifyAndExecuteStatisticsMap = new HashMap<ServiceID, Boolean>();
    private List<List<String>> _allReplicationGroups = new ArrayList<List<String>>();
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui.spacebrowser");

    public ClusterSpaceStatisticPanel(JFrame parentFrame, ServiceManagerImpl serviceManager, EditCluster editCluster) {
        super(parentFrame, true);
        this._clusterName = editCluster.getClusterName();
        this._serviceManager = serviceManager;
        this._allReplicationGroups = ClusterUIUtils.createReplicationsGroupsList(editCluster);
        this.refreshPanel.setSelectedRefreshRate(3000);
    }

    private void setClusterSpacesForBasicStatistics(IJSpace[] spaces) {
        ArrayList<ServiceID> basicStatsList = new ArrayList<ServiceID>(spaces.length);
        for (IJSpace space : spaces) {
            try {
                IRemoteJSpaceAdmin admin = Repository.addSpaceAdminObjectToMap(space);
                if (!(admin instanceof StatisticsAdmin)) continue;
                ServiceID spaceID = JSpaceUtilities.getSpaceServiceID((IJSpace)space);
                StatisticsAdmin statisticsAdmin = (StatisticsAdmin)admin;
                Boolean isStatisticsAvailable = this._basicStatisticsMap.get(spaceID);
                if (isStatisticsAvailable == null) {
                    boolean isStatAvailable = statisticsAdmin.isStatisticsAvailable();
                    this._basicStatisticsMap.put(spaceID, isStatAvailable);
                }
                basicStatsList.add(spaceID);
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) continue;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
        this.basicStats = basicStatsList.toArray(new ServiceID[0]);
    }

    private void setClusterSpacesForNotifyAndExecuteStatistics(IJSpace[] spaces) {
        ArrayList<ServiceID> list = new ArrayList<ServiceID>(spaces.length);
        for (IJSpace space : spaces) {
            try {
                IRemoteJSpaceAdmin admin = Repository.addSpaceAdminObjectToMap(space);
                if (!(admin instanceof StatisticsAdmin)) continue;
                ServiceID spaceID = JSpaceUtilities.getSpaceServiceID((IJSpace)space);
                StatisticsAdmin statisticsAdmin = (StatisticsAdmin)admin;
                Boolean isStatisticsAvailable = this._notifyAndExecuteStatisticsMap.get(spaceID);
                if (isStatisticsAvailable == null) {
                    boolean isStatAvailable = statisticsAdmin.isStatisticsAvailable();
                    this._notifyAndExecuteStatisticsMap.put(spaceID, isStatAvailable);
                }
                list.add(spaceID);
            }
            catch (Throwable t) {
                if (!_logger.isLoggable(Level.SEVERE)) continue;
                _logger.log(Level.SEVERE, t.toString(), t);
            }
        }
        this.notifyAndExecuteStats = list.toArray(new ServiceID[0]);
    }

    public void startRefresh() {
        if (this.refreshPanel.isStop()) {
            this.refreshPanel.startStatusRuntime();
        }
    }

    @Override
    public void refresh() {
        Map statisticsMap;
        IRemoteJSpaceAdmin spaceAdmin;
        Boolean isEnabled;
        int i;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Cluster Statistics Panel refresh, _isInvokeRefresh=" + this._isInvokeRefresh);
        }
        if (!this._isInvokeRefresh && !this.graphElements.isHistoryGraphsEnabled()) {
            return;
        }
        this.setClusterSpacesForBasicStatistics(ClusterUIUtils.getClusterSpacesForStatisticsCalculation(this._serviceManager, this._clusterName, this._allReplicationGroups));
        if (_logger.isLoggable(Level.FINER)) {
            _logger.finer("Cluster Statistics 1");
        }
        this.setClusterSpacesForNotifyAndExecuteStatistics(this._serviceManager.getClusterMemberProxies(this._clusterName, false));
        if (_logger.isLoggable(Level.FINER)) {
            _logger.finer("Cluster Statistics 2");
        }
        this.pieData = new ArrayList();
        long readValue = 0L;
        long readMValue = 0L;
        long writeValue = 0L;
        long updateValue = 0L;
        long takeValue = 0L;
        long takeMValue = 0L;
        long notifyRegistrationValue = 0L;
        long notifySentValue = 0L;
        long notifyAckValue = 0L;
        long executorsValue = 0L;
        long changeValue = 0L;
        this.graphElements.updateBackgrounds();
        if (_logger.isLoggable(Level.FINER)) {
            _logger.finer("basicStats length=" + this.basicStats);
        }
        for (i = 0; i < this.basicStats.length; ++i) {
            try {
                isEnabled = this._basicStatisticsMap.get(this.basicStats[i]);
                if (isEnabled == null || !isEnabled.booleanValue() || (spaceAdmin = Repository.getSpaceAdmin(this.basicStats[i])) == null) continue;
                statisticsMap = ((StatisticsAdmin)spaceAdmin).getStatistics(_statisticsCodes);
                StatisticsContext readStat = (StatisticsContext)statisticsMap.get(OC_BEFORE_READ);
                StatisticsContext readMStat = (StatisticsContext)statisticsMap.get(OC_AFTER_READ_MULTIPLE);
                StatisticsContext writeStat = (StatisticsContext)statisticsMap.get(OC_BEFORE_WRITE);
                StatisticsContext updateStat = (StatisticsContext)statisticsMap.get(OC_BEFORE_UPDATE);
                StatisticsContext takeStat = (StatisticsContext)statisticsMap.get(OC_BEFORE_TAKE);
                StatisticsContext takeMStat = (StatisticsContext)statisticsMap.get(OC_AFTER_TAKE_MULTIPLE);
                StatisticsContext changeStat = (StatisticsContext)statisticsMap.get(OC_AFTER_CHANGE);
                readValue = readStat == null ? readValue : readValue + readStat.getCurrentCount();
                readMValue = readMStat == null ? readMValue : readMValue + readMStat.getCurrentCount();
                writeValue = writeStat == null ? writeValue : writeValue + writeStat.getCurrentCount();
                updateValue = updateStat == null ? updateValue : updateValue + updateStat.getCurrentCount();
                takeValue = takeStat == null ? takeValue : takeValue + takeStat.getCurrentCount();
                takeMValue = takeMStat == null ? takeMValue : takeMValue + takeMStat.getCurrentCount();
                long l = changeValue = changeStat == null ? changeValue : changeValue + changeStat.getCurrentCount();
                if (!_logger.isLoggable(Level.FINER)) continue;
                _logger.finer("baisc cluster stats calculation, readValue=" + readValue + ", readMValue=" + readMValue + ", writeValue=" + writeValue + ", updateValue=" + updateValue + ", takeValue=" + takeValue + ", takeMValue=" + takeMValue + ", changeValue=" + changeValue);
                continue;
            }
            catch (RemoteException re) {
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.log(Level.FINE, "Failed to retrive statistics cluster member," + re.toString(), re);
            }
        }
        for (i = 0; i < this.notifyAndExecuteStats.length; ++i) {
            try {
                isEnabled = this._notifyAndExecuteStatisticsMap.get(this.notifyAndExecuteStats[i]);
                if (isEnabled == null || !isEnabled.booleanValue() || (spaceAdmin = Repository.getSpaceAdmin(this.notifyAndExecuteStats[i])) == null) continue;
                statisticsMap = ((StatisticsAdmin)spaceAdmin).getStatistics(_statisticsCodes);
                StatisticsContext notifyRegistrationStat = (StatisticsContext)statisticsMap.get(OC_BEFORE_NOTIFY);
                StatisticsContext notifySentStat = (StatisticsContext)statisticsMap.get(OC_BEFORE_NOTIFY_TRIGGER);
                StatisticsContext notifyAcknowledgeStat = (StatisticsContext)statisticsMap.get(OC_AFTER_NOTIFY_TRIGGER);
                StatisticsContext executorsStat = (StatisticsContext)statisticsMap.get(OC_BEFORE_EXECUTE);
                notifyRegistrationValue = notifyRegistrationStat == null ? notifyRegistrationValue : notifyRegistrationValue + notifyRegistrationStat.getCurrentCount();
                notifySentValue = notifySentStat == null ? notifySentValue : notifySentValue + notifySentStat.getCurrentCount();
                notifyAckValue = notifyAcknowledgeStat == null ? notifyAckValue : notifyAckValue + notifyAcknowledgeStat.getCurrentCount();
                long l = executorsValue = executorsStat == null ? executorsValue : executorsValue + executorsStat.getCurrentCount();
                if (!_logger.isLoggable(Level.FINER)) continue;
                _logger.finer("notify/execute cluster stats calculation, notifyRegistrationValue=" + notifyRegistrationValue + ", notifySentValue=" + notifySentValue + ", notifyAckValue=" + notifyAckValue + ", executorsValue=" + executorsValue);
                continue;
            }
            catch (RemoteException re) {
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.log(Level.FINE, "Failed to retrive statistics cluster member," + re.toString(), re);
            }
        }
        takeValue += takeMValue;
        readValue += readMValue;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Total cluster stats calculation:, readValue=" + readValue + ", readMValue=" + readMValue + ", writeValue=" + writeValue + ", updateValue=" + updateValue + ", takeValue=" + takeValue + ", takeMValue=" + takeMValue + ", notifyRegistrationValue=" + notifyRegistrationValue + ", notifySentValue=" + notifySentValue + ", notifyAckValue=" + notifyAckValue + ", executorsValue=" + executorsValue + ", changeValue=" + changeValue);
        }
        this.updateGraph(readValue, writeValue, updateValue, takeValue, notifyRegistrationValue, notifySentValue, notifyAckValue, executorsValue, changeValue, !this._isInvokeRefresh);
        if (this.graphElements.tpRadio.isSelected()) {
            this.replaceGraph(true);
        } else {
            this.replaceGraph(false);
        }
    }

    public void removedSpace(ServiceID spaceId) {
        this._basicStatisticsMap.remove(spaceId);
        this._notifyAndExecuteStatisticsMap.remove(spaceId);
    }

    @Override
    public void setInvokeRefresh(boolean invokeRefresh) {
        this._isInvokeRefresh = invokeRefresh;
    }
}

