/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser.statistics.space_operations;

import com.gigaspaces.admin.ui.grid.Repository;
import com.j_spaces.tools.spacebrowser.statistics.IColorMap;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class SpaceColorMap
implements IColorMap {
    public static final Color COLOR_READ_DEFAULT = Color.RED;
    public static final Color COLOR_WRITE_DEFAULT = Color.GREEN;
    public static final Color COLOR_UPDATE_DEFAULT = Color.BLUE;
    public static final Color COLOR_TAKE_DEFAULT = new Color(243, 165, 252);
    public static final Color COLOR_NOTIFY_REGISTRATION_DEFAULT = Color.ORANGE;
    public static final Color COLOR_NOTIFY_SENT_DEFAULT = new Color(90, 37, 80);
    public static final Color COLOR_NOTIFY_ACKNOWLEDGED_DEFAULT = new Color(46, 82, 46);
    public static final Color COLOR_EXECUTE_DEFAULT = new Color(57, 106, 166);
    public static final Color COLOR_CHANGE_DEFAULT = new Color(157, 126, 100);
    public static final String COLOR_READ_STR = "Read";
    public static final String COLOR_WRITE_STR = "Write";
    public static final String COLOR_UPDATE_STR = "Update";
    public static final String COLOR_TAKE_STR = "Take";
    public static final String COLOR_NOTIFY_REGISTRATION_STR = "Notify reg.";
    public static final String COLOR_NOTIFY_SENT_STR = "Notify sent";
    public static final String COLOR_NOTIFY_ACKNOWLEDGED_STR = "Notify ack.";
    public static final String COLOR_EXECUTE_STR = "Execute";
    public static final String COLOR_CHANGE_STR = "Change";
    private static SpaceColorMap instance = new SpaceColorMap();
    private Color colorRead = COLOR_READ_DEFAULT;
    private Color colorWrite = COLOR_WRITE_DEFAULT;
    private Color colorUpdate = COLOR_UPDATE_DEFAULT;
    private Color colorNotifyRegistration = COLOR_NOTIFY_REGISTRATION_DEFAULT;
    private Color colorNotifySent = COLOR_NOTIFY_SENT_DEFAULT;
    private Color colorNotifyAcknowledged = COLOR_NOTIFY_ACKNOWLEDGED_DEFAULT;
    private Color colorTake = COLOR_TAKE_DEFAULT;
    private Color colorExecute = COLOR_EXECUTE_DEFAULT;
    private Color colorChange = COLOR_CHANGE_DEFAULT;
    private Map<Color, String> nameMapping = null;
    private Map<String, Color> colorMapping = new HashMap<String, Color>();

    public static SpaceColorMap instance() {
        return instance;
    }

    private SpaceColorMap() {
        this.nameMapping = new HashMap<Color, String>();
        this.updateColorMapping();
        this.updateNameMapping();
        this.doLoad();
    }

    @Override
    public Map<Color, String> getNameMapping() {
        return this.nameMapping;
    }

    @Override
    public Map<String, Color> getColorMapping() {
        return this.colorMapping;
    }

    private void updateNameMapping() {
        this.nameMapping.clear();
        this.nameMapping.put(this.colorRead, COLOR_READ_STR);
        this.nameMapping.put(this.colorWrite, COLOR_WRITE_STR);
        this.nameMapping.put(this.colorUpdate, COLOR_UPDATE_STR);
        this.nameMapping.put(this.colorTake, COLOR_TAKE_STR);
        this.nameMapping.put(this.colorNotifyRegistration, COLOR_NOTIFY_REGISTRATION_STR);
        this.nameMapping.put(this.colorNotifySent, COLOR_NOTIFY_SENT_STR);
        this.nameMapping.put(this.colorNotifyAcknowledged, COLOR_NOTIFY_ACKNOWLEDGED_STR);
        this.nameMapping.put(this.colorExecute, COLOR_EXECUTE_STR);
        this.nameMapping.put(this.colorChange, COLOR_CHANGE_STR);
    }

    private void updateColorMapping() {
        this.colorMapping.put(COLOR_READ_STR, this.colorRead);
        this.colorMapping.put(COLOR_WRITE_STR, this.colorWrite);
        this.colorMapping.put(COLOR_UPDATE_STR, this.colorUpdate);
        this.colorMapping.put(COLOR_TAKE_STR, this.colorTake);
        this.colorMapping.put(COLOR_NOTIFY_REGISTRATION_STR, this.colorNotifyRegistration);
        this.colorMapping.put(COLOR_NOTIFY_SENT_STR, this.colorNotifySent);
        this.colorMapping.put(COLOR_NOTIFY_ACKNOWLEDGED_STR, this.colorNotifyAcknowledged);
        this.colorMapping.put(COLOR_EXECUTE_STR, this.colorExecute);
        this.colorMapping.put(COLOR_CHANGE_STR, this.colorChange);
    }

    @Override
    public void doSave() {
        this.updateVars();
        Properties serializing = new Properties();
        serializing.put(COLOR_READ_STR, "" + this.colorRead.getRGB());
        serializing.put(COLOR_WRITE_STR, "" + this.colorWrite.getRGB());
        serializing.put(COLOR_UPDATE_STR, "" + this.colorUpdate.getRGB());
        serializing.put(COLOR_NOTIFY_REGISTRATION_STR, "" + this.colorNotifyRegistration.getRGB());
        serializing.put(COLOR_NOTIFY_SENT_STR, "" + this.colorNotifySent.getRGB());
        serializing.put(COLOR_NOTIFY_ACKNOWLEDGED_STR, "" + this.colorNotifyAcknowledged.getRGB());
        serializing.put(COLOR_TAKE_STR, "" + this.colorTake.getRGB());
        serializing.put(COLOR_EXECUTE_STR, "" + this.colorExecute.getRGB());
        serializing.put(COLOR_CHANGE_STR, "" + this.colorChange.getRGB());
        Repository.getInstance().setProperties(serializing);
    }

    @Override
    public Properties getProperties() {
        Properties serializing = new Properties();
        serializing.put(COLOR_READ_STR, "" + this.colorRead.getRGB());
        serializing.put(COLOR_WRITE_STR, "" + this.colorWrite.getRGB());
        serializing.put(COLOR_UPDATE_STR, "" + this.colorUpdate.getRGB());
        serializing.put(COLOR_NOTIFY_REGISTRATION_STR, "" + this.colorNotifyRegistration.getRGB());
        serializing.put(COLOR_NOTIFY_SENT_STR, "" + this.colorNotifySent.getRGB());
        serializing.put(COLOR_NOTIFY_ACKNOWLEDGED_STR, "" + this.colorNotifyAcknowledged.getRGB());
        serializing.put(COLOR_TAKE_STR, "" + this.colorTake.getRGB());
        serializing.put(COLOR_EXECUTE_STR, "" + this.colorExecute.getRGB());
        serializing.put(COLOR_CHANGE_STR, "" + this.colorChange.getRGB());
        return serializing;
    }

    private void updateVars() {
        this.colorRead = this.colorMapping.get(COLOR_READ_STR);
        this.colorWrite = this.colorMapping.get(COLOR_WRITE_STR);
        this.colorUpdate = this.colorMapping.get(COLOR_UPDATE_STR);
        this.colorNotifyRegistration = this.colorMapping.get(COLOR_NOTIFY_REGISTRATION_STR);
        this.colorNotifySent = this.colorMapping.get(COLOR_NOTIFY_SENT_STR);
        this.colorNotifyAcknowledged = this.colorMapping.get(COLOR_NOTIFY_ACKNOWLEDGED_STR);
        this.colorTake = this.colorMapping.get(COLOR_TAKE_STR);
        this.colorExecute = this.colorMapping.get(COLOR_EXECUTE_STR);
        this.colorChange = this.colorMapping.get(COLOR_CHANGE_STR);
    }

    @Override
    public void doLoad() {
        Properties serializing = Repository.getInstance().getProperties();
        try {
            String readColorStr = (String)serializing.get(COLOR_READ_STR);
            this.colorRead = readColorStr != null ? new Color(Integer.parseInt(readColorStr)) : COLOR_READ_DEFAULT;
            String writeColorStr = (String)serializing.get(COLOR_WRITE_STR);
            this.colorWrite = writeColorStr != null ? new Color(Integer.parseInt(writeColorStr)) : COLOR_WRITE_DEFAULT;
            String updateColorStr = (String)serializing.get(COLOR_UPDATE_STR);
            this.colorUpdate = updateColorStr != null ? new Color(Integer.parseInt(updateColorStr)) : COLOR_UPDATE_DEFAULT;
            String notifyRegColorStr = (String)serializing.get(COLOR_NOTIFY_REGISTRATION_STR);
            this.colorNotifyRegistration = notifyRegColorStr != null ? new Color(Integer.parseInt(notifyRegColorStr)) : COLOR_NOTIFY_REGISTRATION_DEFAULT;
            String notifySentColorStr = (String)serializing.get(COLOR_NOTIFY_SENT_STR);
            this.colorNotifySent = notifySentColorStr != null ? new Color(Integer.parseInt(notifySentColorStr)) : COLOR_NOTIFY_SENT_DEFAULT;
            String notifyAcknowldgedColorStr = (String)serializing.get(COLOR_NOTIFY_ACKNOWLEDGED_STR);
            this.colorNotifyAcknowledged = notifyAcknowldgedColorStr != null ? new Color(Integer.parseInt(notifyAcknowldgedColorStr)) : COLOR_NOTIFY_ACKNOWLEDGED_DEFAULT;
            String takeColorStr = (String)serializing.get(COLOR_TAKE_STR);
            this.colorTake = takeColorStr != null ? new Color(Integer.parseInt(takeColorStr)) : COLOR_TAKE_DEFAULT;
            String executeColorStr = (String)serializing.get(COLOR_EXECUTE_STR);
            this.colorExecute = executeColorStr != null ? new Color(Integer.parseInt(executeColorStr)) : COLOR_EXECUTE_DEFAULT;
            String changeColorStr = (String)serializing.get(COLOR_CHANGE_STR);
            this.colorChange = changeColorStr != null ? new Color(Integer.parseInt(changeColorStr)) : COLOR_CHANGE_DEFAULT;
            this.updateColorMapping();
            this.updateNameMapping();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

