/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser.statistics.space_operations;

import com.gigaspaces.internal.utils.excel.ExcelWorkbook;
import com.j_spaces.tools.spacebrowser.statistics.space_operations.ISpaceStatistics;
import com.j_spaces.tools.spacebrowser.statistics.space_operations.SpaceColorMap;
import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.TracePoint2D;
import info.monitorenter.gui.chart.traces.Trace2DLtd;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JPanel;

public class SpaceLineGraph
extends JPanel
implements ISpaceStatistics {
    private Chart2D chart;
    private int xTime;
    private List<Trace2DLtd> TRACES;
    private Trace2DLtd trace1;
    private Trace2DLtd trace2;
    private Trace2DLtd trace3;
    private Trace2DLtd trace4;
    private Trace2DLtd trace5;
    private Trace2DLtd trace6;
    private Trace2DLtd trace7;
    private Trace2DLtd trace8;
    private Trace2DLtd trace9;
    private String _name;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui.spacebrowser");
    private static final DateFormat _dateFormat = DateFormat.getDateTimeInstance(2, 2);
    public static final int MAX_TRACES_MINUTES_SIZE = 10;
    private static final int MAX_TRACES_SIZE = 600;
    private List<Integer> _xValuesList;
    private List<Date> _datesList;

    public SpaceLineGraph(String name) {
        this._name = name.trim();
        this.setBackground(Color.WHITE);
        this.setLayout(new BorderLayout());
        this.initChart(1, 10);
    }

    private void initChart(int sampleRate, int maxMinutesDuration) {
        this.removeAll();
        int tracesSize = maxMinutesDuration * 60 / sampleRate;
        this.chart = new Chart2D();
        this._xValuesList = new LinkedList<Integer>();
        this._datesList = new LinkedList<Date>();
        this.chart.getAxisX().setPaintGrid(true);
        this.chart.getAxisY().setPaintGrid(true);
        this.xTime = 0;
        this._xValuesList.add(this.xTime);
        this._datesList.add(new Date());
        this.TRACES = new ArrayList<Trace2DLtd>();
        this.trace1 = new Trace2DLtd(tracesSize, "Read");
        this.trace2 = new Trace2DLtd(tracesSize, "Write");
        this.trace3 = new Trace2DLtd(tracesSize, "Update");
        this.trace4 = new Trace2DLtd(tracesSize, "Take");
        this.trace5 = new Trace2DLtd(tracesSize, "Notify reg.");
        this.trace6 = new Trace2DLtd(tracesSize, "Notify sent");
        this.trace7 = new Trace2DLtd(tracesSize, "Notify ack.");
        this.trace8 = new Trace2DLtd(tracesSize, "Execute");
        this.trace9 = new Trace2DLtd(tracesSize, "Change");
        this.updateColors();
        this.TRACES.add(0, this.trace1);
        this.TRACES.add(1, this.trace2);
        this.TRACES.add(2, this.trace3);
        this.TRACES.add(3, this.trace4);
        this.TRACES.add(4, this.trace5);
        this.TRACES.add(5, this.trace6);
        this.TRACES.add(6, this.trace7);
        this.TRACES.add(7, this.trace8);
        this.TRACES.add(8, this.trace9);
        this.chart.addTrace((ITrace2D)this.trace1);
        this.chart.addTrace((ITrace2D)this.trace2);
        this.chart.addTrace((ITrace2D)this.trace3);
        this.chart.addTrace((ITrace2D)this.trace4);
        this.chart.addTrace((ITrace2D)this.trace5);
        this.chart.addTrace((ITrace2D)this.trace6);
        this.chart.addTrace((ITrace2D)this.trace7);
        this.chart.addTrace((ITrace2D)this.trace8);
        this.chart.setGridColor(Color.DARK_GRAY);
        this.removeAll();
        this.add((Component)this.chart, "Center");
        this.revalidate();
        this.repaint();
    }

    public void updateColors() {
        Map<String, Color> colorMapping = SpaceColorMap.instance().getColorMapping();
        this.trace1.setColor(colorMapping.get("Read"));
        this.trace2.setColor(colorMapping.get("Write"));
        this.trace3.setColor(colorMapping.get("Update"));
        this.trace4.setColor(colorMapping.get("Take"));
        this.trace5.setColor(colorMapping.get("Notify reg."));
        this.trace6.setColor(colorMapping.get("Notify sent"));
        this.trace7.setColor(colorMapping.get("Notify ack."));
        this.trace8.setColor(colorMapping.get("Execute"));
        this.trace9.setColor(colorMapping.get("Change"));
    }

    public void doStep(int step, boolean isCollectDate) {
        this.xTime += step;
        this._xValuesList.add(this.xTime);
        if (isCollectDate) {
            this._datesList.add(new Date());
        }
    }

    public int getTime() {
        return this.xTime;
    }

    public void addTracepoint(int traceArg, long value, boolean drow, TracePoint2D tracePoint) {
        ITrace2D trace = (ITrace2D)this.TRACES.get(traceArg);
        if (tracePoint != null) {
            trace.addPoint(tracePoint);
        } else {
            trace.addPoint((double)this.xTime, (double)value);
        }
        Set l = this.chart.getTraces();
        boolean isContainsTrace = l.contains(trace);
        if (!drow && isContainsTrace) {
            this.chart.removeTrace(trace);
        }
        if (drow && !isContainsTrace) {
            this.chart.addTrace(trace);
        }
    }

    public void clearGraph(int sampleRate, int maxMinutesDuration) {
        this.initChart(sampleRate, maxMinutesDuration);
    }

    public void apply(int sampleRate, int maxMinutesDuration, boolean isReadTraceDrop, boolean isWriteTraceDrop, boolean isTakeTraceDrop, boolean isUpdateTraceDrop, boolean isNotifyRegistrDrop, boolean isNotifyAckDrop, boolean isNotifySentDrop, boolean isExecuteDrop, boolean isChangeDrop) {
        Trace2DLtd readTrace = this.TRACES.get(0);
        Trace2DLtd writeTrace = this.TRACES.get(1);
        Trace2DLtd takeTrace = this.TRACES.get(3);
        Trace2DLtd updateTrace = this.TRACES.get(2);
        Trace2DLtd notifyRegistrTrace = this.TRACES.get(4);
        Trace2DLtd notifyAckTrace = this.TRACES.get(6);
        Trace2DLtd notifySentTrace = this.TRACES.get(5);
        Trace2DLtd executorsTrace = this.TRACES.get(7);
        Trace2DLtd changeTrace = this.TRACES.get(8);
        Iterator readTracesIterator = readTrace.iterator();
        Iterator writeTracesIterator = writeTrace.iterator();
        Iterator takeTracesIterator = takeTrace.iterator();
        Iterator updateTracesIterator = updateTrace.iterator();
        Iterator notifyRegistrTracesIterator = notifyRegistrTrace.iterator();
        Iterator notifyAckTracesIterator = notifyAckTrace.iterator();
        Iterator notifySentTracesIterator = notifySentTrace.iterator();
        Iterator executorsTracesIterator = executorsTrace.iterator();
        Iterator changeTracesIterator = changeTrace.iterator();
        List<HistoyGraphSample> allTracesList = new LinkedList();
        while (readTracesIterator.hasNext() && writeTracesIterator.hasNext() && takeTracesIterator.hasNext() && updateTracesIterator.hasNext() && notifyRegistrTracesIterator.hasNext() && notifyAckTracesIterator.hasNext() && notifySentTracesIterator.hasNext() && executorsTracesIterator.hasNext() && changeTracesIterator.hasNext()) {
            HistoyGraphSample histoyGraphSample = new HistoyGraphSample((TracePoint2D)readTracesIterator.next(), (TracePoint2D)writeTracesIterator.next(), (TracePoint2D)takeTracesIterator.next(), (TracePoint2D)updateTracesIterator.next(), (TracePoint2D)notifyRegistrTracesIterator.next(), (TracePoint2D)notifyAckTracesIterator.next(), (TracePoint2D)notifySentTracesIterator.next(), (TracePoint2D)executorsTracesIterator.next(), (TracePoint2D)changeTracesIterator.next());
            allTracesList.add(histoyGraphSample);
        }
        List<Date> clonedDatesList = new LinkedList<Date>(this._datesList);
        this.clearGraph(sampleRate, maxMinutesDuration);
        int tracesSize = maxMinutesDuration * 60 / sampleRate;
        int datesListSize = clonedDatesList.size();
        if (tracesSize < datesListSize) {
            clonedDatesList = clonedDatesList.subList(datesListSize - tracesSize, datesListSize);
            allTracesList = allTracesList.subList(allTracesList.size() - tracesSize, allTracesList.size());
        }
        int listSize = allTracesList.size();
        for (int index = 0; index < listSize; ++index) {
            HistoyGraphSample histoyGraphSample = (HistoyGraphSample)allTracesList.get(index);
            histoyGraphSample._readTrace.x = index;
            this.addTracepoint(0, -1L, isReadTraceDrop, histoyGraphSample._readTrace);
            histoyGraphSample._writeTrace.x = index;
            this.addTracepoint(1, -1L, isWriteTraceDrop, histoyGraphSample._writeTrace);
            histoyGraphSample._takeTrace.x = index;
            this.addTracepoint(3, -1L, isTakeTraceDrop, histoyGraphSample._takeTrace);
            histoyGraphSample._updateTrace.x = index;
            this.addTracepoint(2, -1L, isUpdateTraceDrop, histoyGraphSample._updateTrace);
            histoyGraphSample._notifyRegistrTrace.x = index;
            this.addTracepoint(4, -1L, isNotifyRegistrDrop, histoyGraphSample._notifyRegistrTrace);
            histoyGraphSample._notifyAckTrace.x = index;
            this.addTracepoint(6, -1L, isNotifyAckDrop, histoyGraphSample._notifyAckTrace);
            histoyGraphSample._notifySentTrace.x = index;
            this.addTracepoint(5, -1L, isNotifySentDrop, histoyGraphSample._notifySentTrace);
            histoyGraphSample._executeTrace.x = index;
            this.addTracepoint(7, -1L, isExecuteDrop, histoyGraphSample._executeTrace);
            histoyGraphSample._changeTrace.x = index;
            this.addTracepoint(8, -1L, isChangeDrop, histoyGraphSample._changeTrace);
            this.doStep(1, false);
        }
        this._datesList = clonedDatesList;
    }

    public void exportToFile(ExcelWorkbook excelWorkbook) {
        Object[] title = new String[]{"Passed time (sec.)", "Date Time", "Read", "Write", "Take", "Update", "Notify reg.", "Notify sent", "Notify ack.", "Execute", "Change"};
        excelWorkbook.createTitleRow(this._name, title);
        Trace2DLtd readTrace = this.TRACES.get(0);
        Trace2DLtd writeTrace = this.TRACES.get(1);
        Trace2DLtd takeTrace = this.TRACES.get(3);
        Trace2DLtd updateTrace = this.TRACES.get(2);
        Trace2DLtd notifyRegistrTrace = this.TRACES.get(4);
        Trace2DLtd notifyAckTrace = this.TRACES.get(6);
        Trace2DLtd notifySentTrace = this.TRACES.get(5);
        Trace2DLtd executeTrace = this.TRACES.get(7);
        Trace2DLtd changeTrace = this.TRACES.get(8);
        Iterator readTracesIterator = readTrace.iterator();
        Iterator writeTracesIterator = writeTrace.iterator();
        Iterator takeTracesIterator = takeTrace.iterator();
        Iterator updateTracesIterator = updateTrace.iterator();
        Iterator notifyRegistrTracesIterator = notifyRegistrTrace.iterator();
        Iterator notifyAckTracesIterator = notifyAckTrace.iterator();
        Iterator notifySentTracesIterator = notifySentTrace.iterator();
        Iterator executeTracesIterator = executeTrace.iterator();
        Iterator changeTracesIterator = changeTrace.iterator();
        int listSize = readTrace.getSize();
        if (listSize < this._xValuesList.size()) {
            this._xValuesList = this._xValuesList.subList(this._xValuesList.size() - listSize, this._xValuesList.size());
            this._datesList = this._datesList.subList(this._datesList.size() - listSize, this._datesList.size());
        }
        for (int index = 0; index < listSize; ++index) {
            Integer xVal = this._xValuesList.get(index);
            Date date = this._datesList.get(index);
            if (!readTracesIterator.hasNext() || !writeTracesIterator.hasNext() || !takeTracesIterator.hasNext() || !updateTracesIterator.hasNext() || !notifyRegistrTracesIterator.hasNext() || !notifyAckTracesIterator.hasNext() || !notifySentTracesIterator.hasNext() || !executeTracesIterator.hasNext() || !changeTracesIterator.hasNext()) continue;
            Object[] rowArray = new Object[]{(int)xVal, _dateFormat.format(date), (int)((TracePoint2D)readTracesIterator.next()).getY(), (int)((TracePoint2D)writeTracesIterator.next()).getY(), (int)((TracePoint2D)takeTracesIterator.next()).getY(), (int)((TracePoint2D)updateTracesIterator.next()).getY(), (int)((TracePoint2D)notifyRegistrTracesIterator.next()).getY(), (int)((TracePoint2D)notifyAckTracesIterator.next()).getY(), (int)((TracePoint2D)notifySentTracesIterator.next()).getY(), (int)((TracePoint2D)executeTracesIterator.next()).getY(), (int)((TracePoint2D)changeTracesIterator.next()).getY()};
            excelWorkbook.createRow(this._name, rowArray);
        }
    }

    public class HistoyGraphSample {
        final TracePoint2D _readTrace;
        final TracePoint2D _writeTrace;
        final TracePoint2D _takeTrace;
        final TracePoint2D _updateTrace;
        final TracePoint2D _notifyRegistrTrace;
        final TracePoint2D _notifyAckTrace;
        final TracePoint2D _notifySentTrace;
        final TracePoint2D _executeTrace;
        final TracePoint2D _changeTrace;

        HistoyGraphSample(TracePoint2D readTrace, TracePoint2D writeTrace, TracePoint2D takeTrace, TracePoint2D updateTrace, TracePoint2D notifyRegistrTrace, TracePoint2D notifyAckTrace, TracePoint2D notifySentTrace, TracePoint2D executorTrace, TracePoint2D changeTrace) {
            this._readTrace = readTrace;
            this._writeTrace = writeTrace;
            this._takeTrace = takeTrace;
            this._updateTrace = updateTrace;
            this._notifyRegistrTrace = notifyRegistrTrace;
            this._notifyAckTrace = notifyAckTrace;
            this._notifySentTrace = notifySentTrace;
            this._executeTrace = executorTrace;
            this._changeTrace = changeTrace;
        }
    }
}

