/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser.statistics.space_operations;

import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.internal.utils.excel.ExcelWorkbook;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.StatisticsAdmin;
import com.j_spaces.core.filters.StatisticsContext;
import com.j_spaces.tools.IRefreshable;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.statistics.GraphElements;
import com.j_spaces.tools.spacebrowser.statistics.IStatisticsPanelManager;
import com.j_spaces.tools.spacebrowser.statistics.PieGraph;
import com.j_spaces.tools.spacebrowser.statistics.space_operations.ISpaceStatistics;
import com.j_spaces.tools.spacebrowser.statistics.space_operations.SpaceColorMap;
import com.j_spaces.tools.spacebrowser.statistics.space_operations.SpaceLineGraph;
import com.j_spaces.tools.spacebrowser.statistics.space_operations.SpaceTracesDefinition;
import com.j_spaces.tools.spacebrowser.utils.RefreshPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

public class SpaceStatisticsPanel
extends JPanel
implements IRefreshable,
ISpaceStatistics,
IStatisticsPanelManager {
    protected PieGraph pie;
    protected SpaceLineGraph lineGraph;
    protected SpaceLineGraph tpGraph;
    private JPanel chartsPanel;
    protected GraphElements graphElements;
    protected ArrayList pieData;
    private StatisticsAdmin stats;
    protected long readValueTP = 0L;
    protected long writeValueTP = 0L;
    protected long updateValueTP = 0L;
    protected long takeValueTP = 0L;
    protected long notifyRegistrationValueTP = 0L;
    protected long notifySentValueTP = 0L;
    protected long notifyAckValueTP = 0L;
    protected long executorsValueTP = 0L;
    protected long changeValueTP = 0L;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui.spacebrowser");
    protected boolean isExceptionShown = false;
    protected RefreshPanel refreshPanel;
    protected JFrame _parentFrame;
    private final SpaceTracesDefinition _spaceTracesDefinition;
    private boolean _isStatisticsAvailable;
    private boolean _isApplyInvoked = false;
    private boolean isFirstTPGraphUpdate = true;
    private long _prevRefreshRate;

    public SpaceStatisticsPanel(JFrame parentFrame, boolean enableStatisticsHistory) {
        this._parentFrame = parentFrame;
        this.setBackground(Color.WHITE);
        this.chartsPanel = new JPanel();
        this.chartsPanel.setLayout(new GridLayout(2, 1));
        this._spaceTracesDefinition = new SpaceTracesDefinition(parentFrame);
        this.graphElements = new GraphElements(parentFrame, this._spaceTracesDefinition, this, enableStatisticsHistory);
        this.setPreferredSize(new Dimension(800, 600));
        this.setBackground(Color.WHITE);
        this.setLayout(new BorderLayout());
        this.pie = new PieGraph(SpaceColorMap.instance());
        String shortLineGraphName = "Operations Statistics History";
        String lineGraphName = " Operations Statistics History (total operations) ";
        this.lineGraph = new SpaceLineGraph("Operations Statistics History");
        this.lineGraph.setBorder(new TitledBorder(" Operations Statistics History (total operations) "));
        String shortTpGraphName = "Throughput Statistics History";
        String tpGraphName = " Throughput Statistics History (operations/sec.) ";
        this.tpGraph = new SpaceLineGraph("Throughput Statistics History");
        this.tpGraph.setBorder(new TitledBorder(" Throughput Statistics History (operations/sec.) "));
        this.setBackground(Color.WHITE);
        this.pie.setBackground(Color.WHITE);
        this.chartsPanel.setBackground(Color.WHITE);
        JPanel chartControlPanel = new JPanel(new BorderLayout());
        chartControlPanel.add((Component)this.graphElements, "Center");
        this.refreshPanel = new RefreshPanel(this, false);
        this.refreshPanel.setSelectedRefreshRate(3000);
        JPanel barPanel = new JPanel();
        barPanel.setLayout(new BorderLayout());
        barPanel.setBackground(Color.WHITE);
        barPanel.setBorder(new TitledBorder(" Operations Statistics Status "));
        barPanel.add((Component)this.pie, "Center");
        this.chartsPanel.add(barPanel);
        this.chartsPanel.add(this.lineGraph);
        this.chartsPanel.setPreferredSize(new Dimension(650, 100));
        JScrollPane scrollPane = new JScrollPane(this.chartsPanel);
        this.add((Component)scrollPane, "Center");
        this.add((Component)this.refreshPanel, "North");
        this.add((Component)chartControlPanel, "East");
    }

    public void setSpace(IJSpace space, String spaceName) {
        try {
            IRemoteJSpaceAdmin admin = Repository.addSpaceAdminObjectToMap(space);
            if (!(admin instanceof StatisticsAdmin)) {
                return;
            }
            this.stats = (StatisticsAdmin)admin;
            this._isStatisticsAvailable = this.stats.isStatisticsAvailable();
            if (!this._isStatisticsAvailable) {
                String message = "Statistics for Space \"" + spaceName + "\" not Available. Please Start the Statistics Filter.";
                JOptionPane.showMessageDialog(this._parentFrame, message, "Space Statistics", -1);
                return;
            }
            if (this.refreshPanel.isStop()) {
                this.refreshPanel.startStatusRuntime();
            }
        }
        catch (RemoteException e) {
            return;
        }
    }

    public void replaceGraph(boolean tp) {
        if (tp) {
            if (this.lineGraph.isValid()) {
                this.chartsPanel.remove(this.lineGraph);
                this.chartsPanel.add(this.tpGraph);
                this.chartsPanel.validate();
            }
        } else if (this.tpGraph.isValid()) {
            this.chartsPanel.remove(this.tpGraph);
            this.chartsPanel.add(this.lineGraph);
            this.chartsPanel.validate();
        }
    }

    @Override
    public void refresh() {
        block13: {
            if (this._isApplyInvoked) {
                return;
            }
            this.pieData = new ArrayList();
            try {
                this.graphElements.updateBackgrounds();
                if (this._isStatisticsAvailable) {
                    Map statisticsMap = this.stats.getStatistics(_statisticsCodes);
                    StatisticsContext readStat = (StatisticsContext)statisticsMap.get(OC_BEFORE_READ);
                    StatisticsContext readMStat = (StatisticsContext)statisticsMap.get(OC_AFTER_READ_MULTIPLE);
                    StatisticsContext writeStat = (StatisticsContext)statisticsMap.get(OC_BEFORE_WRITE);
                    StatisticsContext updateStat = (StatisticsContext)statisticsMap.get(OC_BEFORE_UPDATE);
                    StatisticsContext notifyRegistrationStat = (StatisticsContext)statisticsMap.get(OC_BEFORE_NOTIFY);
                    StatisticsContext notifySentStat = (StatisticsContext)statisticsMap.get(OC_BEFORE_NOTIFY_TRIGGER);
                    StatisticsContext notifyAcknowledgeStat = (StatisticsContext)statisticsMap.get(OC_AFTER_NOTIFY_TRIGGER);
                    StatisticsContext takeStat = (StatisticsContext)statisticsMap.get(OC_BEFORE_TAKE);
                    StatisticsContext takeMStat = (StatisticsContext)statisticsMap.get(OC_AFTER_TAKE_MULTIPLE);
                    StatisticsContext executorsStat = (StatisticsContext)statisticsMap.get(OC_BEFORE_EXECUTE);
                    StatisticsContext changeStat = (StatisticsContext)statisticsMap.get(OC_AFTER_CHANGE);
                    long readValue = readStat == null ? 0L : readStat.getCurrentCount();
                    long readMValue = readMStat == null ? 0L : readMStat.getCurrentCount();
                    long writeValue = writeStat == null ? 0L : writeStat.getCurrentCount();
                    long updateValue = updateStat == null ? 0L : updateStat.getCurrentCount();
                    long takeValue = takeStat == null ? 0L : takeStat.getCurrentCount();
                    long takeMValue = takeMStat == null ? 0L : takeMStat.getCurrentCount();
                    long notifyRegistrationValue = notifyRegistrationStat == null ? 0L : notifyRegistrationStat.getCurrentCount();
                    long notifySentValue = notifySentStat == null ? 0L : notifySentStat.getCurrentCount();
                    long notifyAckValue = notifyAcknowledgeStat == null ? 0L : notifyAcknowledgeStat.getCurrentCount();
                    long executorsValue = executorsStat == null ? 0L : executorsStat.getCurrentCount();
                    long changeValue = changeStat == null ? 0L : changeStat.getCurrentCount();
                    this.updateGraph(readValue += readMValue, writeValue, updateValue, takeValue += takeMValue, notifyRegistrationValue, notifySentValue, notifyAckValue, executorsValue, changeValue, false);
                }
            }
            catch (NoSuchObjectException e) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, e.toString(), e);
                }
            }
            catch (ConnectException e) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, e.toString(), e);
                }
            }
            catch (ConnectIOException e) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, e.toString(), e);
                }
            }
            catch (Exception e) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, e.toString(), e);
                }
                if (this.isExceptionShown) break block13;
                SpaceBrowser.showException(e.toString(), e);
                this.isExceptionShown = true;
            }
        }
        if (this.graphElements.tpRadio.isSelected()) {
            this.replaceGraph(true);
        } else {
            this.replaceGraph(false);
        }
    }

    protected void updateGraph(long readValue, long writeValue, long updateValue, long takeValue, long notifyRegistrationValue, long notifySentValue, long notifyAckValue, long executorsValue, long changeValue, boolean updtateOnlyThroughput) {
        int refreshRate = this.refreshPanel.getSleepInterval() / 1000;
        if (!updtateOnlyThroughput) {
            Map<String, Color> mapping = SpaceColorMap.instance().getColorMapping();
            if (this._spaceTracesDefinition.writeCBox.isSelected()) {
                this.pieData.add(this.pie.getPieValue(writeValue, mapping.get("Write")));
            }
            if (this._spaceTracesDefinition.updateCBox.isSelected()) {
                this.pieData.add(this.pie.getPieValue(updateValue, mapping.get("Update")));
            }
            if (this._spaceTracesDefinition.readCBox.isSelected()) {
                this.pieData.add(this.pie.getPieValue(readValue, mapping.get("Read")));
            }
            if (this._spaceTracesDefinition.takeCBox.isSelected()) {
                this.pieData.add(this.pie.getPieValue(takeValue, mapping.get("Take")));
            }
            if (this._spaceTracesDefinition.notifySentCBox.isSelected()) {
                this.pieData.add(this.pie.getPieValue(notifySentValue, mapping.get("Notify sent")));
            }
            if (this._spaceTracesDefinition.notifyAcknowledgedCBox.isSelected()) {
                this.pieData.add(this.pie.getPieValue(notifyAckValue, mapping.get("Notify ack.")));
            }
            if (this._spaceTracesDefinition.notifyRegistrationCBox.isSelected()) {
                this.pieData.add(this.pie.getPieValue(notifyRegistrationValue, mapping.get("Notify reg.")));
            }
            if (this._spaceTracesDefinition.executorsCBox.isSelected()) {
                this.pieData.add(this.pie.getPieValue(executorsValue, mapping.get("Execute")));
            }
            if (this._spaceTracesDefinition.changeCBox.isSelected()) {
                this.pieData.add(this.pie.getPieValue(changeValue, mapping.get("Change")));
            }
            this.pie.setPie(this.pieData, refreshRate);
        }
        readValue = (long)(this._spaceTracesDefinition.readScalling.getSelected() * (float)readValue);
        writeValue = (long)(this._spaceTracesDefinition.writeScalling.getSelected() * (float)writeValue);
        updateValue = (long)(this._spaceTracesDefinition.updateScalling.getSelected() * (float)updateValue);
        takeValue = (long)(this._spaceTracesDefinition.takeScalling.getSelected() * (float)takeValue);
        notifyRegistrationValue = (long)(this._spaceTracesDefinition.notifyRegistrationScalling.getSelected() * (float)notifyRegistrationValue);
        notifySentValue = (long)(this._spaceTracesDefinition.notifySentScalling.getSelected() * (float)notifySentValue);
        notifyAckValue = (long)(this._spaceTracesDefinition.notifyAckScalling.getSelected() * (float)notifyAckValue);
        executorsValue = (long)(this._spaceTracesDefinition.executorsScalling.getSelected() * (float)executorsValue);
        changeValue = (long)(this._spaceTracesDefinition.changeScalling.getSelected() * (float)changeValue);
        if (this.graphElements.isHistoryGraphsEnabled()) {
            if (_logger.isLoggable(Level.FINER)) {
                _logger.finer(">>>>> readValue=" + readValue + ", writeValue=" + writeValue + ", updateValue=" + updateValue + ", takeValue=" + takeValue + ", notifyRegistrationValue=" + notifyRegistrationValue + ", notifySentValue=" + notifySentValue + ", notifyAckValue=" + notifyAckValue + ", refreshRate=" + refreshRate + ", executorsValue=" + executorsValue + ", changeValue=" + changeValue);
            }
            this.updateHistoryGraphs(readValue, writeValue, updateValue, takeValue, notifyRegistrationValue, notifySentValue, notifyAckValue, refreshRate, executorsValue, changeValue);
        }
        this.readValueTP = readValue;
        this.writeValueTP = writeValue;
        this.updateValueTP = updateValue;
        this.takeValueTP = takeValue;
        this.notifyRegistrationValueTP = notifyRegistrationValue;
        this.notifySentValueTP = notifySentValue;
        this.notifyAckValueTP = notifyAckValue;
        this.executorsValueTP = executorsValue;
        this.changeValueTP = changeValue;
        this.lineGraph.updateColors();
        this.lineGraph.doStep(1, true);
    }

    private void updateHistoryGraphs(long readValue, long writeValue, long updateValue, long takeValue, long notifyRegistrationValue, long notifySentValue, long notifyAckValue, long refreshRate, long executorsValue, long changeValue) {
        if (!this.isFirstTPGraphUpdate) {
            if (_logger.isLoggable(Level.FINER)) {
                _logger.finer("----TP------, refreshRate=" + refreshRate + ", prevRefreshRate=" + this._prevRefreshRate);
            }
            if (this._prevRefreshRate == refreshRate) {
                long tp = (readValue - this.readValueTP) / refreshRate;
                this.tpGraph.addTracepoint(0, tp < 0L ? 0L : tp, this._spaceTracesDefinition.readCBox.isSelected(), null);
                if (_logger.isLoggable(Level.FINER)) {
                    _logger.finer("-READ TP=" + tp + ", time=" + this.tpGraph.getTime() + ",readValue=" + readValue + ", readValueTP=" + this.readValueTP + ",refreshRate=" + refreshRate);
                }
                this.tpGraph.addTracepoint(1, (tp = (writeValue - this.writeValueTP) / refreshRate) < 0L ? 0L : tp, this._spaceTracesDefinition.writeCBox.isSelected(), null);
                tp = (updateValue - this.updateValueTP) / refreshRate;
                this.tpGraph.addTracepoint(2, tp < 0L ? 0L : tp, this._spaceTracesDefinition.updateCBox.isSelected(), null);
                tp = (takeValue - this.takeValueTP) / refreshRate;
                this.tpGraph.addTracepoint(3, tp < 0L ? 0L : tp, this._spaceTracesDefinition.takeCBox.isSelected(), null);
                tp = (notifyRegistrationValue - this.notifyRegistrationValueTP) / refreshRate;
                this.tpGraph.addTracepoint(4, tp < 0L ? 0L : tp, this._spaceTracesDefinition.notifyRegistrationCBox.isSelected(), null);
                tp = (notifySentValue - this.notifySentValueTP) / refreshRate;
                this.tpGraph.addTracepoint(5, tp < 0L ? 0L : tp, this._spaceTracesDefinition.notifySentCBox.isSelected(), null);
                tp = (notifyAckValue - this.notifyAckValueTP) / refreshRate;
                this.tpGraph.addTracepoint(6, tp < 0L ? 0L : tp, this._spaceTracesDefinition.notifyAcknowledgedCBox.isSelected(), null);
                tp = (executorsValue - this.executorsValueTP) / refreshRate;
                this.tpGraph.addTracepoint(7, tp < 0L ? 0L : tp, this._spaceTracesDefinition.executorsCBox.isSelected(), null);
                tp = (changeValue - this.changeValueTP) / refreshRate;
                this.tpGraph.addTracepoint(8, tp < 0L ? 0L : tp, this._spaceTracesDefinition.changeCBox.isSelected(), null);
            }
        } else {
            this.isFirstTPGraphUpdate = false;
        }
        this._prevRefreshRate = refreshRate;
        this.lineGraph.addTracepoint(0, readValue, this._spaceTracesDefinition.readCBox.isSelected(), null);
        this.lineGraph.addTracepoint(1, writeValue, this._spaceTracesDefinition.writeCBox.isSelected(), null);
        this.lineGraph.addTracepoint(2, updateValue, this._spaceTracesDefinition.updateCBox.isSelected(), null);
        this.lineGraph.addTracepoint(3, takeValue, this._spaceTracesDefinition.takeCBox.isSelected(), null);
        this.lineGraph.addTracepoint(4, notifyRegistrationValue, this._spaceTracesDefinition.notifyRegistrationCBox.isSelected(), null);
        this.lineGraph.addTracepoint(5, notifySentValue, this._spaceTracesDefinition.notifySentCBox.isSelected(), null);
        this.lineGraph.addTracepoint(6, notifyAckValue, this._spaceTracesDefinition.notifyAcknowledgedCBox.isSelected(), null);
        this.lineGraph.addTracepoint(7, executorsValue, this._spaceTracesDefinition.executorsCBox.isSelected(), null);
        this.lineGraph.addTracepoint(8, changeValue, this._spaceTracesDefinition.changeCBox.isSelected(), null);
        this.tpGraph.updateColors();
        this.tpGraph.doStep(1, true);
    }

    @Override
    public boolean isRunning() {
        return false;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    public void stopRefresh() {
        if (this.refreshPanel != null) {
            this.refreshPanel.stopStatusRuntime();
        }
    }

    @Override
    public void setInvokeRefresh(boolean invokeRefresh) {
    }

    @Override
    public void saveStatisticsHistoryToFile(String filePath) {
        ExcelWorkbook excelWorkbook = null;
        this._parentFrame.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this._isApplyInvoked = true;
            excelWorkbook = new ExcelWorkbook(filePath);
            this.lineGraph.exportToFile(excelWorkbook);
            this.tpGraph.exportToFile(excelWorkbook);
        }
        finally {
            excelWorkbook.close();
            this._parentFrame.setCursor(Cursor.getPredefinedCursor(0));
            this._isApplyInvoked = false;
        }
    }

    @Override
    public JFrame getParentFrame() {
        return this._parentFrame;
    }

    @Override
    public void clearStatisticsHistoryGraphs(int maxMinutesDuration) {
        int refreshInterval = this.refreshPanel.getSleepInterval() / 1000;
        this.lineGraph.clearGraph(refreshInterval, maxMinutesDuration);
        this.tpGraph.clearGraph(refreshInterval, maxMinutesDuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(int maxMinutesDuration, Map<Integer, Boolean> operationsSelectionMap) {
        try {
            this._isApplyInvoked = true;
            boolean isReadTraceDrop = operationsSelectionMap.get(0);
            boolean isWriteTraceDrop = operationsSelectionMap.get(1);
            boolean isTakeTraceDrop = operationsSelectionMap.get(3);
            boolean isUpdateTraceDrop = operationsSelectionMap.get(2);
            boolean isNotifyRegistrDrop = operationsSelectionMap.get(4);
            boolean isNotifyAckDrop = operationsSelectionMap.get(6);
            boolean isNotifySentDrop = operationsSelectionMap.get(5);
            boolean isExecutorDrop = operationsSelectionMap.get(7);
            boolean isChangeDrop = operationsSelectionMap.get(8);
            this.lineGraph.apply(this.refreshPanel.getSleepInterval() / 1000, maxMinutesDuration, isReadTraceDrop, isWriteTraceDrop, isTakeTraceDrop, isUpdateTraceDrop, isNotifyRegistrDrop, isNotifyAckDrop, isNotifySentDrop, isExecutorDrop, isChangeDrop);
            this.tpGraph.apply(this.refreshPanel.getSleepInterval() / 1000, maxMinutesDuration, isReadTraceDrop, isWriteTraceDrop, isTakeTraceDrop, isUpdateTraceDrop, isNotifyRegistrDrop, isNotifyAckDrop, isNotifySentDrop, isExecutorDrop, isChangeDrop);
        }
        finally {
            this._isApplyInvoked = false;
        }
    }
}

