/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser.utils;

import com.gigaspaces.cluster.activeelection.SpaceMode;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.cluster.ClusterMemberInfo;
import com.j_spaces.tools.PrimaryBackupIndicationListener;
import com.j_spaces.tools.cluster.EditCluster;
import com.j_spaces.tools.cluster.GroupInfo;
import com.j_spaces.tools.cluster.view.ServiceManagerImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClusterUIUtils {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui.spacebrowser");

    public static IJSpace[] getClusterSpacesForStatisticsCalculation(ServiceManagerImpl serviceManager, String clusterName, List<List<String>> allReplicationGroups) {
        ServiceManagerImpl.ClusterMember[] clusterMembers = serviceManager.getClusterMembers(clusterName, false);
        HashMap<String, ServiceManagerImpl.ClusterMember> clusterMemberMap = new HashMap<String, ServiceManagerImpl.ClusterMember>(clusterMembers.length);
        for (int i = 0; i < clusterMembers.length; ++i) {
            if (clusterMembers[i] == null) continue;
            String memberName = clusterMembers[i].getClusterMemberName();
            clusterMemberMap.put(memberName, clusterMembers[i]);
        }
        for (List<String> replicationGroupMembers : allReplicationGroups) {
            String foundMemberName = null;
            for (String memberName : replicationGroupMembers) {
                SpaceMode spaceMode;
                if (!clusterMemberMap.containsKey(memberName) || ((spaceMode = PrimaryBackupIndicationListener.getInstance().getSpaceMode(((ServiceManagerImpl.ClusterMember)clusterMemberMap.get(memberName)).getServiceID())) == null || spaceMode.equals((Object)SpaceMode.BACKUP)) && (spaceMode != null || !serviceManager.isAliveClusterMember(memberName))) continue;
                foundMemberName = memberName;
                break;
            }
            for (String memberName : replicationGroupMembers) {
                if (memberName.equals(foundMemberName)) continue;
                clusterMemberMap.remove(memberName);
            }
        }
        Iterator iterator = clusterMemberMap.values().iterator();
        IJSpace[] spaces = new IJSpace[clusterMemberMap.size()];
        int index = 0;
        while (iterator.hasNext()) {
            ServiceManagerImpl.ClusterMember clusterMember = (ServiceManagerImpl.ClusterMember)iterator.next();
            try {
                spaces[index++] = ServiceManagerImpl.retrieveSpaceProxy(clusterMember);
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) continue;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
        return spaces;
    }

    public static IJSpace[] getAllClusterSpacesExceptMirror(ServiceManagerImpl serviceManager, String clusterName, List<List<String>> allReplicationGroups) {
        ServiceManagerImpl.ClusterMember[] clusterMembers = serviceManager.getClusterMembers(clusterName, false);
        HashMap<String, ServiceManagerImpl.ClusterMember> clusterMemberMap = new HashMap<String, ServiceManagerImpl.ClusterMember>(clusterMembers.length);
        for (int i = 0; i < clusterMembers.length; ++i) {
            String memberName = clusterMembers[i].getClusterMemberName();
            clusterMemberMap.put(memberName, clusterMembers[i]);
        }
        Iterator iterator = clusterMemberMap.values().iterator();
        IJSpace[] spaces = new IJSpace[clusterMemberMap.size()];
        int index = 0;
        while (iterator.hasNext()) {
            ServiceManagerImpl.ClusterMember clusterMember = (ServiceManagerImpl.ClusterMember)iterator.next();
            try {
                spaces[index++] = ServiceManagerImpl.retrieveSpaceProxy(clusterMember);
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) continue;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
        return spaces;
    }

    public static List<List<String>> createReplicationsGroupsList(EditCluster editCluster) {
        GroupInfo[] clusterGroups = editCluster.getClusterGroups();
        ArrayList<List<String>> allReplicationGroups = new ArrayList<List<String>>();
        for (int i = 0; i < clusterGroups.length; ++i) {
            if (clusterGroups[i].repInfo == null) continue;
            ClusterMemberInfo[] clusterMemberInfoArray = clusterGroups[i].groupMembers;
            ArrayList<String> replicationGroup = new ArrayList<String>();
            for (ClusterMemberInfo clusterMemberInfo : clusterMemberInfoArray) {
                replicationGroup.add(clusterMemberInfo.memberName);
            }
            allReplicationGroups.add(replicationGroup);
        }
        return allReplicationGroups;
    }
}

