/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser.utils;

import com.gigaspaces.admin.ui.views.utils.BasicTextPane;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class FindTextComponent
extends JToolBar {
    private JTextField findTextField = new JTextField();
    private JButton findButton = new JButton("Find");
    private JTextComponent _textComponent;
    private JFrame _parentFrame;

    public FindTextComponent(JTextComponent textComponent) {
        this(null, textComponent, false);
    }

    public FindTextComponent(JFrame parentFrame, JTextComponent textComponent, boolean isSearchIncremental) {
        this._textComponent = textComponent;
        this._parentFrame = parentFrame;
        this.findTextField.setPreferredSize(new Dimension(120, 23));
        this.findTextField.setMaximumSize(new Dimension(120, 23));
        this.setFloatable(false);
        this.setRollover(true);
        this.setBorderPainted(false);
        if (isSearchIncremental) {
            this.findTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    FindTextComponent.this.invokeFind();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    FindTextComponent.this.invokeFind();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            });
        }
        this.add(Box.createHorizontalStrut(4));
        this.add(this.findTextField);
        this.add(Box.createHorizontalStrut(3));
        this.add(this.findButton);
        this.findTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.getKeyCode() == 10) {
                    FindTextComponent.this.invokeFind();
                }
            }
        });
        this.findButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FindTextComponent.this.invokeFind();
            }
        });
    }

    private void invokeFind() {
        final String findStr = this.findTextField.getText();
        if (this._textComponent instanceof JTextPane) {
            this.invokeFindInTextPane(findStr);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FindTextComponent.this.invokeFindInTextArea(findStr);
                }
            });
        }
    }

    private void invokeFindInTextArea(String findStr) {
        if (findStr.length() > 0) {
            int curCaretPosition = this._textComponent.getCaretPosition();
            String curText = this._textComponent.getText();
            int strIndex = curText.indexOf(findStr, curCaretPosition);
            if (strIndex < 0 && curCaretPosition != 0) {
                strIndex = curText.indexOf(findStr, 0);
            }
            if (strIndex >= 0) {
                this._textComponent.select(strIndex, strIndex + findStr.length());
                this._textComponent.grabFocus();
            }
        }
    }

    private void invokeFindInTextPane(String findStr) {
        if (this._textComponent instanceof BasicTextPane) {
            ((BasicTextPane)this._textComponent).search(findStr);
        }
    }
}

