/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser.utils;

import com.gigaspaces.admin.ui.util.UIHelper;
import com.gigaspaces.internal.jvm.JavaUtils;
import com.j_spaces.jmx.util.JConsoleUtilities;
import com.j_spaces.tools.spacebrowser.utils.JConsolePluginConfirmDialog;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;

public class JConsoleUIUtils {
    private static boolean _isConfirmationDialogDisplayed = false;
    private static boolean _usePlugin = false;
    private static final String JVISUAL_VM_FILE_NAME = "jvisualvm";
    private static final String FORMAT = "%-2s %-10.150s";

    public static String[] createJConsoleCommand(JFrame parentFrame, String jmxServiceUrl, String javaHomeDir, boolean useParameters) {
        if (!_isConfirmationDialogDisplayed) {
            JConsolePluginConfirmDialog dialog = new JConsolePluginConfirmDialog(parentFrame);
            dialog.setVisible(true);
            if (!dialog.isOkButtonPressed()) {
                return null;
            }
            _isConfirmationDialogDisplayed = true;
            _usePlugin = dialog.usePlugin();
        }
        return JConsoleUtilities.createJConsoleCommand((String)jmxServiceUrl, (String)javaHomeDir, (boolean)_usePlugin, (boolean)useParameters);
    }

    public static String[] createJVisualVmCommand(String jmxServiceUrl, String javaHomeDir, File visualVmFileLaunchFilePath) {
        return JConsoleUtilities.createJVisualVmCommand((String)jmxServiceUrl, (String)javaHomeDir, (File)visualVmFileLaunchFilePath);
    }

    public static String manageJConsoleMenuItem(final JFrame parentFrame, AbstractButton jconsole, final String jmxServiceUrl, final boolean useParameters, final Logger logger, boolean isAddActionListener, final boolean isPassExceptionToUIHelper, final Window parentWindow) {
        String opSys = System.getProperty("os.name");
        String ext = opSys.startsWith("Win") ? ".exe" : "";
        String javaHome = System.getProperty("java.home");
        String jconsoleApplPath = javaHome + File.separator + "bin" + File.separator + "jconsole" + ext;
        File jconsoleApp = new File(jconsoleApplPath);
        boolean jconsoleFound = false;
        if (!jconsoleApp.exists()) {
            logger.fine("jconsole was not found at: " + jconsoleApplPath);
            File javaHomeDir = new File(javaHome);
            javaHome = javaHomeDir.getParent();
            jconsoleApplPath = javaHome + File.separator + "bin" + File.separator + "jconsole" + ext;
            jconsoleApp = new File(jconsoleApplPath);
        } else {
            jconsoleFound = true;
            logger.fine("jconsole was found at: " + jconsoleApplPath);
        }
        if (!jconsoleFound) {
            if (!jconsoleApp.exists()) {
                logger.fine("jconsole also was not found at: " + jconsoleApplPath + " , jconsole option will be disabled");
            } else {
                logger.fine("jconsole was found at: " + jconsoleApplPath);
            }
        }
        if (!jconsoleApp.exists() || jmxServiceUrl == null) {
            jconsole.setEnabled(false);
        }
        if (isAddActionListener) {
            final String _javaHome = javaHome;
            ActionListener[] actionListeners = jconsole.getActionListeners();
            if (actionListeners != null) {
                for (ActionListener actionListener : actionListeners) {
                    jconsole.removeActionListener(actionListener);
                }
            }
            jconsole.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        parentWindow.setCursor(Cursor.getPredefinedCursor(3));
                        Object[] commandArray = JConsoleUIUtils.createJConsoleCommand(parentFrame, jmxServiceUrl, _javaHome, useParameters);
                        if (commandArray != null) {
                            if (logger.isLoggable(Level.INFO)) {
                                logger.log(Level.INFO, "JConsole command:" + Arrays.toString(commandArray));
                            }
                            Runtime.getRuntime().exec((String[])commandArray);
                        }
                    }
                    catch (IOException e1) {
                        if (isPassExceptionToUIHelper) {
                            UIHelper.showError((Throwable)e1, "Spawning jconsole");
                        }
                        logger.log(Level.SEVERE, e1.toString(), e1);
                    }
                    finally {
                        parentWindow.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            });
        }
        return javaHome;
    }

    public static String manageJVisualVmMenuItem(final JFrame parentFrame, AbstractButton jVisualVmButton, final String jmxServiceUrl, final Logger logger, boolean isAddActionListener, final boolean isPassExceptionToUIHelper, final Window parentWindow, boolean isManageButtonStateOnMissingVisualVmFile) {
        VisualVmFileVerifierWrapper visualVmFileVerifierWrapper = JConsoleUIUtils.checkJVisualVMFile(parentFrame, logger, false);
        String javaHome = visualVmFileVerifierWrapper.getJavaHome();
        if (!visualVmFileVerifierWrapper.exists() && isManageButtonStateOnMissingVisualVmFile || jmxServiceUrl == null) {
            jVisualVmButton.setEnabled(false);
        }
        if (isAddActionListener) {
            ActionListener[] actionListeners = jVisualVmButton.getActionListeners();
            if (actionListeners != null) {
                for (ActionListener actionListener : actionListeners) {
                    jVisualVmButton.removeActionListener(actionListener);
                }
            }
            jVisualVmButton.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        VisualVmFileVerifierWrapper visualVmFileVerifierWrapper = JConsoleUIUtils.checkJVisualVMFile(parentFrame, logger);
                        if (visualVmFileVerifierWrapper.exists()) {
                            parentWindow.setCursor(Cursor.getPredefinedCursor(3));
                            Object[] commandArray = JConsoleUIUtils.createJVisualVmCommand(jmxServiceUrl, visualVmFileVerifierWrapper.getJavaHome(), visualVmFileVerifierWrapper.getjVisualVmAppFile());
                            if (commandArray != null) {
                                if (logger.isLoggable(Level.INFO)) {
                                    logger.log(Level.INFO, "jvisualvm command:" + Arrays.toString(commandArray));
                                }
                                Runtime.getRuntime().exec((String[])commandArray);
                            }
                        } else if (visualVmFileVerifierWrapper.isShowMessage()) {
                            JConsoleUIUtils.showVisualVmFileNotFoundMessage(parentFrame, visualVmFileVerifierWrapper);
                        }
                    }
                    catch (IOException e1) {
                        if (isPassExceptionToUIHelper) {
                            UIHelper.showError((Throwable)e1, "Spawning jvisualvm");
                        }
                        logger.log(Level.SEVERE, e1.toString(), e1);
                    }
                    finally {
                        parentWindow.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            });
        }
        return javaHome;
    }

    public static VisualVmFileVerifierWrapper checkJVisualVMFile(JFrame parentFrame, Logger logger) {
        return JConsoleUIUtils.checkJVisualVMFile(parentFrame, logger, true);
    }

    public static VisualVmFileVerifierWrapper checkJVisualVMFile(JFrame parentFrame, Logger logger, boolean showMessage) {
        String visualVmLaunchPath = System.getProperty("com.gs.visualvm.binary");
        if (visualVmLaunchPath == null) {
            String javaHome = JConsoleUIUtils.getJavaHome();
            if (JavaUtils.greaterOrEquals((int)9)) {
                if (showMessage) {
                    JConsoleUIUtils.showVisualVmLaunchFilePathNotDefinedMessage(parentFrame);
                }
                return new VisualVmFileVerifierWrapper(javaHome, null, new String[0], false);
            }
            if (JavaUtils.greaterOrEquals((int)8)) {
                return JConsoleUIUtils.createVisualVmFileVerifierWrapper(logger, JConsoleUIUtils.getJVisualVmFile(javaHome));
            }
        }
        return JConsoleUIUtils.createVisualVmFileVerifierWrapper(logger, new File(visualVmLaunchPath));
    }

    private static VisualVmFileVerifierWrapper createVisualVmFileVerifierWrapper(Logger logger, File jVisualVmApp) {
        String javaHome = JConsoleUIUtils.getJavaHome();
        ArrayList<String> checkedJVisualVmFilePaths = new ArrayList<String>(2);
        checkedJVisualVmFilePaths.add(jVisualVmApp.getPath());
        if (!jVisualVmApp.exists()) {
            logger.fine("jvisualvm was not found at: " + jVisualVmApp.getPath());
            javaHome = new File(JConsoleUIUtils.getJavaHome()).getParent();
            jVisualVmApp = JConsoleUIUtils.getJVisualVmFile(javaHome);
            checkedJVisualVmFilePaths.add(jVisualVmApp.getPath());
        } else {
            logger.fine("jvisualvm was found at: " + jVisualVmApp.getPath());
        }
        return new VisualVmFileVerifierWrapper(javaHome, jVisualVmApp, checkedJVisualVmFilePaths.toArray(new String[checkedJVisualVmFilePaths.size()]), true);
    }

    private static String getJavaHome() {
        return System.getProperty("java.home");
    }

    private static String getExtension() {
        String opSys = System.getProperty("os.name");
        return opSys.startsWith("Win") ? ".exe" : "";
    }

    private static File getJVisualVmFile(String vmHome) {
        String jVisualVmApplPath = vmHome + File.separator + "bin" + File.separator + JVISUAL_VM_FILE_NAME + JConsoleUIUtils.getExtension();
        return new File(jVisualVmApplPath);
    }

    public static void showVisualVmFileNotFoundMessage(JFrame parentFrame, VisualVmFileVerifierWrapper visualVmFileVerifierWrapper) {
        String paths = "";
        for (String path : visualVmFileVerifierWrapper.getCheckedPaths()) {
            paths = paths + String.format(FORMAT, "", path) + "\n";
        }
        JOptionPane.showMessageDialog(parentFrame, "VisualVM file was not found at:\n" + paths, "VisualVM", 2);
    }

    public static void showVisualVmLaunchFilePathNotDefinedMessage(JFrame parentFrame) {
        JTextArea messageTextArea = new JTextArea();
        messageTextArea.setEditable(false);
        messageTextArea.setText("Starting from JDK 9, Java VisualVM is no longer available with the JDK distribution.\nDownload VisualVM and point the System property to the binary appropriate for your OS:\ncom.gs.visualvm.binary=\"visualvm\\bin\\visualvm.exe\" or \"visualvm/bin/visualvm\"");
        JOptionPane.showMessageDialog(parentFrame, messageTextArea, "VisualVM", 2);
    }

    public static class VisualVmFileVerifierWrapper {
        private final boolean exists;
        private final File jVisualVmAppFile;
        private final String[] checkedPaths;
        private final String javaHome;
        private final boolean showMessage;

        public VisualVmFileVerifierWrapper(String javaHome, File jVisualVmAppFile, String[] checkedPaths, boolean showMessage) {
            this.javaHome = javaHome;
            this.exists = jVisualVmAppFile == null ? false : jVisualVmAppFile.exists();
            this.jVisualVmAppFile = jVisualVmAppFile;
            this.checkedPaths = checkedPaths;
            this.showMessage = showMessage;
        }

        public boolean exists() {
            return this.exists;
        }

        public String[] getCheckedPaths() {
            return this.checkedPaths;
        }

        public String getJavaHome() {
            return this.javaHome;
        }

        public boolean isShowMessage() {
            return this.showMessage;
        }

        public File getjVisualVmAppFile() {
            return this.jVisualVmAppFile;
        }
    }
}

