/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser.utils;

import com.gigaspaces.admin.security.SecurityServicesRepository;
import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.util.UIHelper;
import com.gigaspaces.cluster.activeelection.SpaceMode;
import com.gigaspaces.grid.gsc.GSC;
import com.gigaspaces.internal.jvm.JVMDetails;
import com.gigaspaces.security.Authentication;
import com.gigaspaces.security.authorities.MonitorAuthority;
import com.gigaspaces.security.authorities.Privilege;
import com.gigaspaces.security.service.SecuredService;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.lookup.entry.ClusterName;
import com.j_spaces.lookup.entry.ContainerName;
import com.j_spaces.tools.spacebrowser.utils.IconsRepository;
import java.applet.Applet;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.net.URI;
import java.text.DecimalFormat;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.lookup.entry.Name;

public class JSpaceUIUtils {
    public static final String CLUSTER_NODE_ID_SEPARATOR = ":";
    public static final Color SELECTION_BACKGROUND_COLOR = new Color(164, 192, 221);
    public static final String CLASS_NOT_FOUND_MESSAGE = "The following class was not found. Please add it to the classpath:";
    public static final String CLASS_NOT_FOUND_TTILE = "Class Not Found";
    private static ImageIcon removedFromJiniLusSpaceIcon;
    private static ImageIcon jettyIcon;
    private static ImageIcon primaryPUInstanceIcon;
    private static ImageIcon backupPUInstanceIcon;
    private static ImageIcon regulPUInstanceIcon;
    public static final String RESOURCE_DIR = "/image/browser";
    public static final String TREE_ICONS = "tree.icons";
    private static ResourceBundle resource;
    private static DecimalFormat nf;
    public static final String VIEW_SPACE = "SpaceView";
    public static final String VIEW_CLUSTER_CLASSES = "ClusterClasses";
    public static final String VIEW_CLUSTER_TRANSACTIONS = "ClusterTransactions";
    public static final String VIEW_CLUSTER_CONNECTIONS = "ClusterConnections";
    public static final String VIEW_CLUSTER_QUERY = "ClusterQuery";
    public static final String VIEW_CLUSTER_STATISTICS = "ClusterStatistics";
    public static final String VIEW_CLUSTER_BENCHMARK = "ClusterBenchmark";
    public static final String VIEW_CLUSTER_GRAPH = "ClusterGraph";
    public static final String VIEW_SINGLE_SPACE_CLASSES = "SingleSpaceClasses";
    public static final String VIEW_SINGLE_SPACE_TRANSACTIONS = "SingleSpaceTransactions";
    public static final String VIEW_SINGLE_SPACE_QUERY = "SingleSpaceQuery";
    public static final String VIEW_SINGLE_SPACE_STATISTICS = "SingleSpaceStatistics";
    public static final String VIEW_SINGLE_SPACE_CONNECTIONS = "SingleSpaceConnections";
    public static final String VIEW_SINGLE_SPACE_BENCHMARK = "SingleSpaceBenchmark";
    public static final String VIEW_UNMANAGED_SPACES = "UnmanagedSpaces";
    public static final String VIEW_EVENT_CONTAINERS = "EventContaienrs";
    public static final String VIEW_REMOTE_SERVICES = "RemoteServices";
    public static final String VIEW_PU_INSTANCES = "PUInstances";
    public static final String VIEW_PU_CONFIGURATION = "PUConfiguration";
    public static final String VIEW_JEE_CONFIGURATION = "JEEConfiguration";
    public static final String VIEW_PU_INSTANCE_PROPERTIES = "PUInstanceProperties";
    public static final String VIEW_NO_PERMISSIONS = "ViewNoPermissions";
    public static final String VIEW_NO_SPACE_OPERATIONS_PERMISSIONS = "ViewNoSpaceOperationsPermissions";
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;
    private static final long GB = 0x40000000L;
    private static final long TB = 0x10000000000L;
    public static final String BYTES_NAME = "B";
    private static final String KB_NAME = "KB";
    private static final String MB_NAME = "MB";
    private static final String GB_NAME = "GB";
    private static final String TB_NAME = "TB";
    private static final long K = 1000L;
    private static final long M = 1000000L;
    private static final long G = 1000000000L;
    private static final long T = 1000000000000L;
    private static final DecimalFormat _numberFormat;
    private static final DecimalFormat _numberWithFloatFormat;
    private static final DecimalFormat _numberFloatFormat2Digits;
    private static final Logger LOGGER;

    public static ResourceBundle getResource() {
        return resource;
    }

    public static String[] getResources(String resourceName) {
        String prop = resource.getString(resourceName);
        StringTokenizer st = new StringTokenizer(prop, ",");
        String[] resources = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            resources[i] = st.nextToken().trim();
            ++i;
        }
        return resources;
    }

    public static void setAWTComponentsStatus(Container owner, boolean status) {
        Component comp = null;
        if (owner == null || owner.getComponentCount() == 0) {
            return;
        }
        for (int i = 0; i < owner.getComponentCount(); ++i) {
            comp = owner.getComponent(i);
            if (comp instanceof Container) {
                JSpaceUIUtils.setAWTComponentsStatus((Container)comp, status);
            }
            comp.setEnabled(status);
        }
    }

    public static void setCenterAWTWindow(Window window) {
        Toolkit toolKit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolKit.getScreenSize();
        Dimension size = window.getSize();
        int y = (int)(screenSize.getHeight() / 2.0) - (int)(size.getHeight() / 2.0);
        int x = (int)(screenSize.getWidth() / 2.0) - (int)(size.getWidth() / 2.0);
        window.setLocation(x, y);
        Window parent = window.getOwner();
        if (null != parent) {
            parent.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public static void cleanAWTContainer(Container owner) {
        Component comp = null;
        if (owner == null || owner.getComponentCount() == 0) {
            return;
        }
        for (int i = 0; i < owner.getComponentCount(); ++i) {
            comp = owner.getComponent(i);
            if (comp instanceof Container) {
                JSpaceUIUtils.cleanAWTContainer((Container)comp);
            }
            if (comp instanceof JTextField) {
                ((JTextField)comp).setText("");
                continue;
            }
            if (comp instanceof TextField) {
                ((TextField)comp).setText("");
                continue;
            }
            if (comp instanceof JCheckBox) {
                ((JCheckBox)comp).setSelected(false);
                continue;
            }
            if (!(comp instanceof Checkbox)) continue;
            ((Checkbox)comp).setState(false);
        }
    }

    public static void setLocationRelativeTo(Component child, Component c) {
        Container root = null;
        if (c != null) {
            if (c instanceof Window || c instanceof Applet) {
                root = (Container)c;
            } else {
                for (Container parent = c.getParent(); parent != null; parent = parent.getParent()) {
                    if (!(parent instanceof Window) && !(parent instanceof Applet)) continue;
                    root = parent;
                    break;
                }
            }
        }
        if (c != null && !c.isShowing() || root == null || !root.isShowing()) {
            Dimension paneSize = child.getSize();
            Dimension screenSize = child.getToolkit().getScreenSize();
            child.setLocation((screenSize.width - paneSize.width) / 2, (screenSize.height - paneSize.height) / 2);
        } else {
            Point invokerScreenLocation;
            Dimension invokerSize = c.getSize();
            if (root instanceof Applet) {
                invokerScreenLocation = c.getLocationOnScreen();
            } else {
                invokerScreenLocation = new Point(0, 0);
                for (Component tc = c; tc != null; tc = tc.getParent()) {
                    Point tcl = tc.getLocation();
                    invokerScreenLocation.x += tcl.x;
                    invokerScreenLocation.y += tcl.y;
                    if (tc == root) break;
                }
            }
            Rectangle windowBounds = child.getBounds();
            int dx = invokerScreenLocation.x + (invokerSize.width - windowBounds.width >> 1);
            int dy = invokerScreenLocation.y + (invokerSize.height - windowBounds.height >> 1);
            Dimension ss = child.getToolkit().getScreenSize();
            if (dy + windowBounds.height > ss.height) {
                dy = ss.height - windowBounds.height;
                int n = dx = invokerScreenLocation.x < ss.width >> 1 ? invokerScreenLocation.x + invokerSize.width : invokerScreenLocation.x - windowBounds.width;
            }
            if (dx + windowBounds.width > ss.width) {
                dx = ss.width - windowBounds.width;
            }
            if (dx < 0) {
                dx = 0;
            }
            if (dy < 0) {
                dy = 0;
            }
            child.setLocation(dx, dy);
        }
    }

    public static String createSpaceRepresentationName(String hostName, String containerName, String spaceName) {
        return hostName + CLUSTER_NODE_ID_SEPARATOR + containerName + CLUSTER_NODE_ID_SEPARATOR + spaceName;
    }

    public static String createClusterGuiId(TreePath treePath) {
        Object[] path = treePath.getPath();
        return JSpaceUIUtils.createClusterGuiId(path);
    }

    public static String createClusterGuiId(Object[] path) {
        String memberName = path[path.length - 1].toString();
        String clusterGroupName = path[path.length - 2].toString();
        String clusterName = path[path.length - 3].toString();
        return JSpaceUIUtils.createClusterGuiId(clusterName, clusterGroupName, memberName);
    }

    public static String createClusterGuiId(String clusterName, String clusterGroupName, String memberName) {
        if (clusterGroupName == null) {
            clusterGroupName = "";
        }
        StringBuilder strBuffer = new StringBuilder();
        strBuffer.append(clusterName);
        strBuffer.append(CLUSTER_NODE_ID_SEPARATOR);
        strBuffer.append(clusterGroupName);
        strBuffer.append(CLUSTER_NODE_ID_SEPARATOR);
        strBuffer.append(memberName);
        return strBuffer.toString();
    }

    public static String[] resolveClusterGuiId(String clusterNodeId) {
        int delimeterIndex1 = clusterNodeId.indexOf(CLUSTER_NODE_ID_SEPARATOR);
        String clusterName = clusterNodeId.substring(0, delimeterIndex1);
        int delimeterIndex2 = clusterNodeId.indexOf(CLUSTER_NODE_ID_SEPARATOR, delimeterIndex1 + 1);
        String groupName = clusterNodeId.substring(delimeterIndex1 + 1, delimeterIndex2);
        String memberName = clusterNodeId.substring(delimeterIndex2 + 1);
        return new String[]{clusterName, groupName, memberName};
    }

    public static Icon getDockTitleIcon() {
        return new Icon(){
            private static final int ICON_SIZE = 8;

            @Override
            public int getIconHeight() {
                return 8;
            }

            @Override
            public int getIconWidth() {
                return 8;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Color oldColor = g.getColor();
                g.setColor(new Color(70, 70, 70));
                g.fillRect(x, y, 8, 8);
                g.setColor(SELECTION_BACKGROUND_COLOR);
                g.fillRect(x + 1, y + 1, 6, 6);
                g.setColor(oldColor);
            }
        };
    }

    public static short getSpaceModeValue(SpaceMode spaceModeVal) {
        int spaceMode = 1;
        if (spaceModeVal == null) {
            spaceMode = 1;
        } else if (spaceModeVal.equals((Object)SpaceMode.PRIMARY)) {
            spaceMode = 2;
        } else if (spaceModeVal.equals((Object)SpaceMode.BACKUP)) {
            spaceMode = 3;
        }
        return (short)spaceMode;
    }

    public static ImageIcon getSpaceIcon(int spaceMode, boolean isSecured, ServiceID serviceID) {
        ImageIcon icon = null;
        icon = spaceMode == 4 ? removedFromJiniLusSpaceIcon : (spaceMode == 2 || spaceMode == 3 || spaceMode == 1 ? JSpaceUIUtils.getPrimaryBackupSpaceIcon(spaceMode, isSecured, serviceID) : IconsRepository.getInstance().getIcon(50));
        return icon;
    }

    public static ImageIcon getPrimaryBackupSpaceIcon(int spaceMode, boolean isSecured, ServiceID serviceID) {
        boolean isSpaceAuthenticated;
        ImageIcon icon = null;
        boolean bl = isSpaceAuthenticated = SecurityServicesRepository.getInstance().getSecurityAuthentication(serviceID) != null;
        if (isSecured) {
            if (isSpaceAuthenticated) {
                if (spaceMode == 2) {
                    icon = IconsRepository.getInstance().getIcon(55);
                } else if (spaceMode == 3) {
                    icon = IconsRepository.getInstance().getIcon(58);
                } else if (spaceMode == 1) {
                    icon = JSpaceUIUtils.isMirrorSpace(spaceMode, serviceID) ? IconsRepository.getInstance().getIcon(61) : IconsRepository.getInstance().getIcon(52);
                }
            } else if (spaceMode == 2) {
                icon = IconsRepository.getInstance().getIcon(54);
            } else if (spaceMode == 3) {
                icon = IconsRepository.getInstance().getIcon(57);
            } else if (spaceMode == 1) {
                icon = JSpaceUIUtils.isMirrorSpace(spaceMode, serviceID) ? IconsRepository.getInstance().getIcon(60) : IconsRepository.getInstance().getIcon(51);
            }
        } else if (spaceMode == 2) {
            icon = IconsRepository.getInstance().getIcon(53);
        } else if (spaceMode == 3) {
            icon = IconsRepository.getInstance().getIcon(56);
        } else if (spaceMode == 1) {
            icon = JSpaceUIUtils.isMirrorSpace(spaceMode, serviceID) ? IconsRepository.getInstance().getIcon(59) : IconsRepository.getInstance().getIcon(50);
        }
        return icon;
    }

    private static boolean isMirrorSpace(int spaceMode, ServiceID serviceID) {
        boolean isMirrorSpace;
        block4: {
            ServiceItem serviceItem;
            isMirrorSpace = false;
            if (spaceMode == 1 && (serviceItem = Repository.getInstance().getServiceItem(serviceID)) != null) {
                IJSpace space = (IJSpace)serviceItem.service;
                try {
                    IRemoteJSpaceAdmin spaceAdmin = Repository.addSpaceAdminObjectToMap(space);
                    if (spaceAdmin != null) {
                        SpaceConfig spaceConfig = Repository.addSpaceConfigToMap(spaceAdmin);
                        isMirrorSpace = spaceConfig.isMirrorServiceEnabled();
                    }
                }
                catch (Exception exc) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block4;
                    LOGGER.log(Level.SEVERE, exc.toString(), exc);
                }
            }
        }
        return isMirrorSpace;
    }

    public static ImageIcon getPUInstanceIcon(int spaceMode, int state) {
        ImageIcon icon = null;
        icon = spaceMode == 2 && state != 2 ? primaryPUInstanceIcon : (spaceMode == 3 && state != 2 ? backupPUInstanceIcon : regulPUInstanceIcon);
        return icon;
    }

    public static boolean hasPermittedPermission(SecuredService securedService, ServiceID securedServiceId, Privilege permittedPrivilege) {
        block3: {
            try {
                if (securedService != null && securedService.isServiceSecured()) {
                    return JSpaceUIUtils.hasPermittedPermission(securedService, securedServiceId, permittedPrivilege, true);
                }
            }
            catch (Exception exc) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block3;
                LOGGER.log(Level.SEVERE, exc.toString(), exc);
            }
        }
        return true;
    }

    public static boolean hasPermittedPermission(SecuredService securedService, ServiceID securedServiceId, Privilege permittedPrivilege, boolean isSecuredService) {
        block3: {
            try {
                Authentication authentication;
                if (securedService != null && isSecuredService && ((authentication = SecurityServicesRepository.getInstance().getSecurityAuthentication(securedServiceId)) == null || !authentication.getGrantedAuthorities().isGranted(permittedPrivilege))) {
                    return false;
                }
            }
            catch (Exception exc) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block3;
                LOGGER.log(Level.SEVERE, exc.toString(), exc);
            }
        }
        return true;
    }

    public static boolean isSpaceHasPermittedPermission(ServiceID serviceId, boolean isSpaceSecured, Privilege permittedPrivilege) {
        block6: {
            try {
                JVMDetails jvmDetails;
                Authentication authentication;
                if (isSpaceSecured && ((authentication = SecurityServicesRepository.getInstance().getSecurityAuthentication(serviceId)) == null || !authentication.getGrantedAuthorities().isGranted(permittedPrivilege))) {
                    return false;
                }
                if (permittedPrivilege.equals(MonitorAuthority.MonitorPrivilege.MONITOR_JVM) && (jvmDetails = Repository.getInstance().getJVMDetails(serviceId)) != null) {
                    long spacePid = jvmDetails.getPid();
                    ServiceItem gscServiceItem = Repository.getInstance().getGSCServiceItem(spacePid);
                    if (gscServiceItem != null && ((GSC)gscServiceItem.service).isServiceSecured()) {
                        ServiceID gscServiceID = gscServiceItem.serviceID;
                        Authentication gscAuthentication = SecurityServicesRepository.getInstance().getSecurityAuthentication(gscServiceID);
                        if (gscAuthentication == null || !gscAuthentication.getGrantedAuthorities().isGranted(permittedPrivilege)) {
                            return false;
                        }
                    }
                }
            }
            catch (Exception exc) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block6;
                LOGGER.log(Level.SEVERE, exc.toString(), exc);
            }
        }
        return true;
    }

    public static Properties createSecuredContextProperties() {
        Properties props = new Properties();
        if (SecurityServicesRepository.getInstance().isUserLoggedIn()) {
            String userName = SecurityServicesRepository.getInstance().getLoggedUserName();
            String password = SecurityServicesRepository.getInstance().getLoggedUserPassword();
            props.setProperty("user", userName);
            props.setProperty("password", password);
        }
        return props;
    }

    public static boolean isRootInHierarchyOfSelectedNode(DefaultMutableTreeNode root, JTree tree) {
        TreePath selTreePath = tree.getSelectionPath();
        if (selTreePath != null) {
            TreeNode selTreeNode = (TreeNode)selTreePath.getLastPathComponent();
            for (TreeNode parentNode = selTreeNode.getParent(); parentNode != null; parentNode = parentNode.getParent()) {
                if (!parentNode.equals(root)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isTreeNodeInPath(TreePath treePath, DefaultMutableTreeNode treeNode) {
        Object[] path;
        for (Object treeObj : path = treePath.getPath()) {
            if (!treeObj.equals(treeNode)) continue;
            return true;
        }
        return false;
    }

    public static TreeNode getChildTreeNode(TreeNode parentNode, String childName) {
        int childNum = parentNode.getChildCount();
        TreeNode childNode = null;
        for (int i = 0; i < childNum; ++i) {
            TreeNode node = parentNode.getChildAt(i);
            if (!node.toString().equals(childName)) continue;
            childNode = node;
            break;
        }
        return childNode;
    }

    public static boolean showInBrowser(JFrame parentFrame, String url, Logger LOGGER) {
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
            JOptionPane.showMessageDialog(parentFrame, "\n\n The system failed to invoke your default web browser while attempting to access: \n\n " + url + "\n\n", "Browser Error", 2);
            return false;
        }
        return true;
    }

    public static String getSpaceInstanceID(IJSpace space) {
        SpaceURL spaceURL = space.getURL();
        String primaryMemberId = spaceURL.getProperty("id");
        String backupMemberId = spaceURL.getProperty("backup_id");
        if (primaryMemberId == null) {
            primaryMemberId = "";
        }
        return primaryMemberId + (backupMemberId == null ? "" : "_" + backupMemberId);
    }

    public static String getFullTimeRepresentation(long msec, boolean showMiliSeconds) {
        long days = msec / 86400000L;
        long mSecInPassedDays = days == 0L ? 0L : days * 1000L * 60L * 60L * 24L;
        long hours = (msec - mSecInPassedDays) / 3600000L;
        long mSecInPassdHours = hours == 0L ? 0L : hours * 1000L * 60L * 60L;
        long minutes = (msec - mSecInPassdHours - mSecInPassedDays) / 60000L;
        long mSecInPassedMinutes = minutes == 0L ? 0L : minutes * 1000L * 60L;
        long sec = (msec - mSecInPassedMinutes - mSecInPassdHours - mSecInPassedDays) / 1000L;
        String result = "";
        if (days > 0L) {
            result = result + days + " days ";
        }
        if (hours > 0L) {
            result = result + hours + " hours ";
        }
        if (minutes > 0L) {
            result = result + minutes + " min. ";
        }
        if (days <= 0L && hours <= 0L) {
            result = result + sec + " sec. ";
        }
        if (showMiliSeconds && days <= 0L && hours <= 0L && minutes <= 0L) {
            result = nf.format((double)msec / 1000.0) + " sec.";
        }
        return result;
    }

    public static ServiceItem createSpaceServiceItem(IJSpace spaceProxy, ServiceID spaceID, String spaceName, String containerName, String clusterName) {
        Entry[] spaceAttributes = new Entry[]{new Name(spaceName), new ContainerName(containerName), new ClusterName(clusterName)};
        return new ServiceItem(spaceID, (Object)spaceProxy, spaceAttributes);
    }

    public static String getBlobStorePropertyLabel(String property) {
        String value = property.equals("mappingDir") ? "Mapping Dir" : (property.equals("space-config.engine.blobstore_persistent") ? "Persistent" : (property.equals("space-config.engine.blobstore_cache_size") ? "Space Cache Size" : (property.equals("cacheSize") ? "External Storage Cache Size" : (property.equals("path") ? "External Storage Path" : (property.equals("blobStoreHandler") ? "MemoryXtend Add-On Type" : property)))));
        return value;
    }

    public static String formatBigValue(double val) {
        return JSpaceUIUtils.formatBigValue(val, true);
    }

    public static String formatBigValue(double val, boolean withDigitsAfterFloat) {
        String unitOfMeasurement;
        double res;
        if (val < 1000.0) {
            res = val;
            unitOfMeasurement = "";
        } else if (val < 1000000.0 && val >= 1000.0) {
            res = val / 1000.0;
            unitOfMeasurement = "K";
        } else {
            res = val / 1000000.0;
            unitOfMeasurement = "M";
        }
        if (!withDigitsAfterFloat) {
            return JSpaceUIUtils.format(res) + unitOfMeasurement;
        }
        if (res == 0.0) {
            return JSpaceUIUtils.format(res) + unitOfMeasurement;
        }
        return (res < 10.0 && res != 0.0 ? JSpaceUIUtils.formatWith2DigitsAfterFloat(res) : JSpaceUIUtils.formatWith1DigitAfterFloat(res)) + unitOfMeasurement;
    }

    public static FormattedValue formatBytesBigValue(double val) {
        double res;
        String unitOfMeasurement;
        if (val < 1024.0) {
            unitOfMeasurement = BYTES_NAME;
            res = val;
        } else if (val < 1048576.0 && val >= 1024.0) {
            unitOfMeasurement = KB_NAME;
            res = val / 1024.0;
        } else if (val < 1.073741824E9 && val >= 1048576.0) {
            unitOfMeasurement = MB_NAME;
            res = val / 1048576.0;
        } else if (val < 1.099511627776E12 && val >= 1.073741824E9) {
            unitOfMeasurement = GB_NAME;
            res = val / 1.073741824E9;
        } else {
            unitOfMeasurement = TB_NAME;
            res = val / 1.099511627776E12;
        }
        return new FormattedValue(unitOfMeasurement, res < 10.0 && res != 0.0 ? JSpaceUIUtils.formatWith1DigitAfterFloat(res) : JSpaceUIUtils.format(res));
    }

    public static String format(double num) {
        return _numberFormat.format(num);
    }

    public static String formatWith2DigitsAfterFloat(double num) {
        return _numberFloatFormat2Digits.format(num);
    }

    public static String formatWith1DigitAfterFloat(double num) {
        return _numberWithFloatFormat.format(num);
    }

    static {
        _numberFormat = new DecimalFormat();
        _numberWithFloatFormat = new DecimalFormat();
        _numberFloatFormat2Digits = new DecimalFormat();
        _numberFormat.setMaximumFractionDigits(0);
        _numberWithFloatFormat.setMaximumFractionDigits(1);
        _numberFloatFormat2Digits.setMaximumFractionDigits(2);
        LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");
        nf = new DecimalFormat();
        nf.setMaximumFractionDigits(2);
        try {
            resource = ResourceBundle.getBundle("SpaceBrowserResources");
        }
        catch (MissingResourceException e) {
            System.err.println();
            System.err.println("Can't find the SpaceBrowserResources.properties file that contains all resource names.");
            System.exit(1);
        }
        String[] treeIcons = JSpaceUIUtils.getResources(TREE_ICONS);
        removedFromJiniLusSpaceIcon = new ImageIcon(JSpaceUIUtils.class.getResource("/image/browser/" + treeIcons[12]));
        String path = "com/gigaspaces/admin/ui/images/";
        backupPUInstanceIcon = UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/backup_pu_instance.png");
        primaryPUInstanceIcon = UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/primary_pu_instance.png");
        regulPUInstanceIcon = UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/pu_instance.png");
    }

    public static class FormattedValue {
        private String unitOfMeasurement;
        private String value;

        public FormattedValue(String unitOfMeasurement, String value) {
            this.unitOfMeasurement = unitOfMeasurement;
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String getUnitOfMeasurement() {
            return this.unitOfMeasurement;
        }

        public String toString() {
            return this.value.equals(String.valueOf(0)) ? this.value : this.value + " " + this.unitOfMeasurement;
        }
    }
}

