/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser.utils;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;

public class ProgressDialog
extends JDialog {
    private JProgressBar progressBar;
    private JLabel noteLabel = new JLabel();
    private JButton cancelButton = new JButton("Cancel");
    private int incrementIndex = 10;
    private boolean isCancel = false;
    private static final Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");

    public ProgressDialog(JFrame parentFrame, String note, int minValue, int maxValue) {
        super(parentFrame, "Progress...", true);
        this.progressBar = new JProgressBar(minValue * this.incrementIndex, maxValue * this.incrementIndex);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.noteLabel.setText(note);
        this.init();
        this.setLocationRelativeTo(parentFrame);
    }

    private void init() {
        this.progressBar.setBorder(BorderFactory.createEtchedBorder(1));
        this.progressBar.setMaximumSize(new Dimension(1000, 22));
        this.progressBar.setPreferredSize(new Dimension(1000, 22));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JLabel imageLabel = new JLabel(UIManager.getIcon("OptionPane.informationIcon"));
        Box noteBox = new Box(0);
        Box centralBox = new Box(0);
        Box buttonsBox = new Box(0);
        noteBox.add(Box.createHorizontalStrut(45));
        noteBox.add(this.noteLabel);
        noteBox.add(Box.createHorizontalGlue());
        centralBox.add(Box.createHorizontalStrut(5));
        centralBox.add(imageLabel);
        centralBox.add(Box.createHorizontalStrut(8));
        centralBox.add(this.progressBar);
        centralBox.add(Box.createHorizontalStrut(5));
        buttonsBox.add(Box.createHorizontalGlue());
        buttonsBox.add(this.cancelButton);
        buttonsBox.add(Box.createHorizontalGlue());
        contentPane.add(Box.createVerticalStrut(5));
        contentPane.add(noteBox);
        contentPane.add(Box.createVerticalStrut(4));
        contentPane.add(centralBox);
        contentPane.add(Box.createVerticalStrut(7));
        contentPane.add(buttonsBox);
        contentPane.add(Box.createVerticalStrut(10));
        this.setDefaultCloseOperation(0);
        this.setSize(250, 145);
        this.progressBar.setValue(1);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressDialog.this.isCancel = true;
                ProgressDialog.this.setVisible(false);
            }
        });
    }

    public void setProgress(int value) {
        this.progressBar.setValue(value * this.incrementIndex);
    }

    public void stopProgress() {
        this.setVisible(false);
    }

    public static void main(String[] args) {
        block3: {
            try {
                String laf = UIManager.getSystemLookAndFeelClassName();
                if (Boolean.getBoolean("com.gs.browser.laf.isCross")) {
                    laf = UIManager.getCrossPlatformLookAndFeelClassName();
                }
                System.out.println("Look and Feel:" + UIManager.getLookAndFeel());
            }
            catch (Exception ex) {
                if (!LOGGER.isLoggable(Level.FINE)) break block3;
                LOGGER.log(Level.FINE, ex.toString(), ex);
            }
        }
        JFrame frame = new JFrame("Test");
        frame.setSize(200, 200);
        frame.setVisible(true);
        ProgressDialog progressDialog = new ProgressDialog(frame, "Progress...", 0, 20);
        progressDialog.setVisible(true);
    }

    public boolean isCancel() {
        return this.isCancel;
    }
}

