/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser.utils;

import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.IJSpaceContainer;
import com.j_spaces.core.client.SpaceFinder;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.client.SpaceURLParser;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import java.awt.Component;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;

public class ProgressThread
extends GSThread {
    private int cnt = 0;
    private int progMax = 200;
    private String URL;
    private SpaceURL spaceUrl = null;
    private Exception exception = null;
    private String containerName;
    private Object proxy = null;
    private final MainUI _mainUI;
    private final Component _parentComponent;
    private static final Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");

    public ProgressThread(MainUI parentComponent) {
        this(parentComponent, parentComponent);
    }

    public ProgressThread(MainUI mainUI, Component parentComponent) {
        super("UI lookup progress");
        this._mainUI = mainUI;
        this._parentComponent = parentComponent;
    }

    public void setURL(String URL2) throws MalformedURLException {
        this.URL = URL2;
        this.spaceUrl = SpaceURLParser.parseURL((String)URL2);
        this.containerName = this.spaceUrl.getContainerName();
    }

    public void run() {
        Thread finderThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String url = SpaceURL.concatAttrIfNotExist((String)ProgressThread.this.URL, (String)"timeout", (String)String.valueOf(100000));
                    ProgressThread.this.proxy = SpaceFinder.find((String)url);
                }
                catch (Exception ex) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, ex.toString(), ex);
                    }
                    ProgressThread.this.exception = ex;
                }
            }
        }, "UI " + this.containerName + " lookup");
        ProgressMonitor pm = new ProgressMonitor(this._parentComponent, "Looking for Container:", this.containerName, 0, this.progMax);
        finderThread.start();
        while (this.proxy == null && this.exception == null && !pm.isCanceled() && this.cnt != this.progMax) {
            pm.setProgress(++this.cnt);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.log(Level.FINE, ex.toString(), ex);
            }
        }
        if (pm.isCanceled()) {
            pm.close();
            JOptionPane.showMessageDialog(this._parentComponent, "Container discovery process canceled!", "Cancellation", 0);
        }
        if (this.exception != null) {
            pm.close();
            SpaceBrowser.showException("discovering " + this.containerName + " container", this.exception);
        }
        if (this.cnt == this.progMax) {
            JOptionPane.showMessageDialog(this._parentComponent, "The " + this.containerName + " container can not be found!", "Time out", 2);
        }
        finderThread.interrupt();
        if (this.proxy != null) {
            this._mainUI.selectSpaceBrowserTab();
            String protocolName = this.spaceUrl.getProtocol();
            boolean isRMIProtocol = protocolName.equalsIgnoreCase("rmi:");
            if (this.proxy instanceof IJSpaceContainer) {
                SpaceBrowser.getInstance().addContainerTree((IJSpaceContainer)this.proxy, null, protocolName, true);
                if (isRMIProtocol) {
                    SpaceBrowser.getInstance().addRMIContainer((IJSpaceContainer)this.proxy, this.URL);
                    try {
                        Repository.getInstance().addNonJiniManagedService(this.proxy, ((IJSpaceContainer)this.proxy).getName());
                    }
                    catch (RemoteException re) {
                        if (LOGGER.isLoggable(Level.SEVERE)) {
                            LOGGER.log(Level.SEVERE, re.toString(), re);
                        }
                    }
                }
            } else if (this.proxy instanceof IJSpace) {
                SpaceBrowser.getInstance().addContainerTree(((IJSpace)this.proxy).getDirectProxy().getContainer(), null, "rmi:", true);
                if (isRMIProtocol) {
                    SpaceBrowser.getInstance().addRMIContainer(((IJSpace)this.proxy).getDirectProxy().getContainer(), this.URL);
                    Repository.getInstance().addNonJiniManagedService(this.proxy, ((IJSpace)this.proxy).getName());
                }
            }
        }
        pm.close();
    }
}

