/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser.utils;

import com.j_spaces.tools.IRefreshable;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RefreshPanel
extends JPanel
implements Runnable {
    private FlowLayout buttonsFlowLayout = new FlowLayout();
    private JLabel refreshLabel = new JLabel();
    private JComboBox updateComboBox = new JComboBox();
    private JPanel buttonPanel = new JPanel();
    private int sleepInterval;
    private static final String DIALOG_RUNTIME_LABEL = "dialog.runtime.labels";
    private static final String DIALOG_RUNTIME_EDITBOX = "dialog.runtime.editbox";
    private static final String DIALOG_RUNTIME_TOOLTIP = "dialog.runtime.tooltip";
    private static final String DIALOG_RUNTIME_ICONS = "dialog.runtime.icons";
    private static final String DIALOG_RUNTIME_BUTTON = "dialog.runtime.buttons";
    private JButton stopButton = new JButton();
    private JButton startButton = new JButton();
    private JLabel statusLabel = new JLabel();
    private boolean isStop = true;
    private Thread m_runtimeThread;
    private ImageIcon stopIcon;
    private ImageIcon startIcon;
    private ArrayList<IRefreshable> _refreshListenersList;
    public static final int RR_1_SEC = 1000;
    public static final int RR_3_SEC = 3000;
    public static final int RR_5_SEC = 5000;

    public RefreshPanel(IRefreshable refreshListener, boolean isStartRefreshImmediately) {
        this._refreshListenersList = new ArrayList(1);
        this._refreshListenersList.add(refreshListener);
        this.init();
        if (isStartRefreshImmediately) {
            this.startStatusRuntime();
        }
    }

    public RefreshPanel(ArrayList<IRefreshable> refreshListener, boolean isStartRefreshImmediately) {
        this._refreshListenersList = refreshListener;
        this.init();
        if (isStartRefreshImmediately) {
            this.startStatusRuntime();
        }
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 0));
        String[] resLabel = JSpaceUIUtils.getResources(DIALOG_RUNTIME_LABEL);
        String[] resEditbox = JSpaceUIUtils.getResources(DIALOG_RUNTIME_EDITBOX);
        String[] resTooltip = JSpaceUIUtils.getResources(DIALOG_RUNTIME_TOOLTIP);
        String[] resIcons = JSpaceUIUtils.getResources(DIALOG_RUNTIME_ICONS);
        String[] resButton = JSpaceUIUtils.getResources(DIALOG_RUNTIME_BUTTON);
        this.refreshLabel.setText(" " + resLabel[1] + " ");
        for (int i = 0; i < resEditbox.length; ++i) {
            this.updateComboBox.addItem(resEditbox[i]);
        }
        if (this.updateComboBox.getItemCount() > 0) {
            this.updateComboBox.setSelectedIndex(0);
        }
        this.updateComboBox.setPreferredSize(new Dimension(130, 20));
        this.updateComboBox.setMaximumSize(new Dimension(130, 20));
        this.stopIcon = new ImageIcon(this.getClass().getResource("/image/browser/" + resIcons[0]));
        this.startIcon = new ImageIcon(this.getClass().getResource("/image/browser/" + resIcons[1]));
        this.statusLabel = new JLabel("Stopped  ", this.stopIcon, 4);
        this.startButton.setText(resButton[0]);
        this.stopButton.setText(resButton[1]);
        this.buttonPanel.setLayout(this.buttonsFlowLayout);
        this.buttonPanel.add((Component)this.startButton, null);
        this.buttonPanel.add((Component)this.stopButton, null);
        this.add(Box.createHorizontalStrut(1));
        this.add(this.refreshLabel);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.updateComboBox);
        this.add(Box.createHorizontalGlue());
        this.add(this.buttonPanel);
        this.add(Box.createHorizontalGlue());
        this.add(this.statusLabel);
        this.add(Box.createHorizontalStrut(1));
        this.sleepInterval = this.calculateSleepInterval();
        this.updateComboBox.setToolTipText(resTooltip[0]);
        this.updateComboBox.setPreferredSize(new Dimension(130, 20));
        this.updateComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    RefreshPanel.this.sleepInterval = RefreshPanel.this.calculateSleepInterval();
                }
            }
        });
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RefreshPanel.this.startStatusRuntime();
            }
        });
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RefreshPanel.this.stopStatusRuntime();
            }
        });
        this.stopButton.setEnabled(false);
    }

    @Override
    public void run() {
        int i = 0;
        while (!this.isStop) {
            if (i >= 100) {
                i = 0;
            }
            for (IRefreshable refreshComponent : this._refreshListenersList) {
                refreshComponent.refresh();
            }
            try {
                Thread.sleep(this.sleepInterval);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        this.startButton.setEnabled(true);
        this.statusLabel.setIcon(this.stopIcon);
        this.statusLabel.setText("Stopped  ");
    }

    public void startStatusRuntime() {
        this.isStop = false;
        this.stopButton.setText("Stop");
        this.startButton.setEnabled(false);
        this.statusLabel.setIcon(this.startIcon);
        this.statusLabel.setText("Started  ");
        for (IRefreshable refreshComponent : this._refreshListenersList) {
            refreshComponent.start();
        }
        this.m_runtimeThread = new Thread((Runnable)this, "GS-RefreshPanel");
        this.m_runtimeThread.start();
        this.stopButton.setEnabled(true);
    }

    public void stopStatusRuntime() {
        this.isStop = true;
        if (!this.isStop) {
            this.statusLabel.setText("Stopping...");
        }
        this.stopButton.setEnabled(false);
        for (IRefreshable refreshComponent : this._refreshListenersList) {
            refreshComponent.stop();
        }
    }

    private int calculateSleepInterval() {
        int index = this.updateComboBox.getSelectedIndex();
        switch (index) {
            case 0: {
                this.sleepInterval = 1000;
                break;
            }
            case 1: {
                this.sleepInterval = 3000;
                break;
            }
            case 2: {
                this.sleepInterval = 5000;
            }
        }
        return this.sleepInterval;
    }

    public void setSelectedRefreshRate(int refreshRate) {
        switch (refreshRate) {
            case 1000: {
                this.updateComboBox.setSelectedIndex(0);
                break;
            }
            case 3000: {
                this.updateComboBox.setSelectedIndex(1);
                break;
            }
            case 5000: {
                this.updateComboBox.setSelectedIndex(2);
            }
        }
    }

    public boolean isStop() {
        return this.isStop;
    }

    public ImageIcon getStopIcon() {
        return this.stopIcon;
    }

    public ImageIcon getStartIcon() {
        return this.startIcon;
    }

    public void setStartButtonEnabled(boolean enabled) {
        this.startButton.setEnabled(enabled);
    }

    public int getSleepInterval() {
        return this.sleepInterval;
    }
}

