/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.zip.CRC32;
import org.isqlviewer.util.Base64Decoder;
import org.isqlviewer.util.Base64Encoder;
import org.isqlviewer.util.Base64FormatException;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringTokenizer;
import org.isqlviewer.util.StringUtilities;

public class HistoryItem
implements Comparator,
Comparable,
Cloneable {
    public static final int COMPARE_MODE_SQL = 1;
    public static final int COMPARE_MODE_TIME = 0;
    public static final int COMPARE_MODE_SERVICE = 2;
    private long execTime = 0L;
    private String sql = null;
    private String serviceRef = null;
    private Date dte = null;
    private static final String FIELD_SEPERATOR = "\u0006";
    private static int comparableMode = 0;
    private static boolean useCRC32 = false;

    public static synchronized void setComparableMode(int mode, boolean enableCRC32) {
        useCRC32 = enableCRC32;
        switch (comparableMode) {
            case 0: 
            case 1: 
            case 2: {
                comparableMode = mode;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public static HistoryItem decode(String s) {
        HistoryItem hi = new HistoryItem();
        try {
            Base64Decoder codec = new Base64Decoder(s, true);
            StringTokenizer st = new StringTokenizer(codec.processString(), FIELD_SEPERATOR, false, false);
            hi.execTime = Long.parseLong(st.nextToken());
            hi.serviceRef = st.nextToken();
            hi.sql = st.nextToken();
            return hi;
        }
        catch (Base64FormatException be) {
            try {
                Base64Decoder codec = new Base64Decoder(s);
                StringTokenizer st = new StringTokenizer(codec.processString(), FIELD_SEPERATOR, false, false);
                hi.execTime = Long.parseLong(st.nextToken());
                hi.serviceRef = st.nextToken();
                hi.sql = st.nextToken();
                return hi;
            }
            catch (Base64FormatException b64fe) {
                return null;
            }
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, "HistoryItem::decode(String)");
            return null;
        }
    }

    public static String encode(HistoryItem hi) {
        StringBuffer buff = new StringBuffer("");
        buff.append(Long.toString(hi.execTime));
        buff.append(FIELD_SEPERATOR);
        buff.append(hi.serviceRef);
        buff.append(FIELD_SEPERATOR);
        buff.append(hi.sql);
        buff.append(FIELD_SEPERATOR);
        Base64Encoder codec = new Base64Encoder(buff.toString(), true);
        return codec.processString();
    }

    public HistoryItem(String service, String sqlData) {
        if (service == null || sqlData == null) {
            throw new NullPointerException();
        }
        this.sql = sqlData;
        this.serviceRef = service;
        this.updateTimestamp();
    }

    protected HistoryItem() {
        this("", "");
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("HistoryItem[Service='");
        buff.append(this.serviceRef);
        buff.append("', executed='");
        buff.append(this.getTimeStamp());
        buff.append("', sql='");
        buff.append(this.getSQLData());
        buff.append("']");
        return buff.toString();
    }

    public Object clone() {
        HistoryItem copy = new HistoryItem();
        copy.execTime = this.execTime;
        copy.serviceRef = this.serviceRef;
        copy.sql = this.sql;
        return copy;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof HistoryItem) {
            HistoryItem item = (HistoryItem)obj;
            return this.compareTo(item) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.sql.hashCode() + this.serviceRef.hashCode();
    }

    public int compare(Object o1, Object o2) {
        if (!(o1 instanceof HistoryItem) && !(o2 instanceof HistoryItem)) {
            return 0;
        }
        HistoryItem src = (HistoryItem)o1;
        HistoryItem dst = (HistoryItem)o2;
        if (src == null && dst == null) {
            return 0;
        }
        if (src == null && dst != null) {
            return -1;
        }
        if (src != null && dst == null) {
            return 1;
        }
        switch (comparableMode) {
            case 2: {
                return src.serviceRef.compareTo(dst.serviceRef);
            }
            case 0: {
                return src.getTimeStamp().compareTo(dst.getTimeStamp());
            }
            case 1: {
                if (useCRC32) {
                    try {
                        String srcSQL = StringUtilities.stripCharacters(src.sql, "\r\t\n ").toLowerCase();
                        String dstSQL = StringUtilities.stripCharacters(dst.sql, "\r\t\n ").toLowerCase();
                        CRC32 src_crc = new CRC32();
                        CRC32 dst_crc = new CRC32();
                        src_crc.update(srcSQL.getBytes("UTF8"));
                        dst_crc.update(dstSQL.getBytes("UTF8"));
                        long one = src_crc.getValue();
                        long two = dst_crc.getValue();
                        return one == two ? 0 : (one < two ? -1 : 1);
                    }
                    catch (Throwable t) {
                        return src.sql.compareTo(dst.sql);
                    }
                }
                return src.sql.compareTo(dst.sql);
            }
        }
        return 0;
    }

    public int compareTo(Object o) {
        return this.compare(this, o);
    }

    public Date getTimeStamp() {
        if (this.dte == null) {
            this.dte = new Date(this.execTime);
        }
        return this.dte;
    }

    public String getServiceReference() {
        return this.serviceRef;
    }

    public String getSQLData() {
        return this.sql;
    }

    public String toMenuString() {
        StringTokenizer tok = new StringTokenizer(this.sql, "\t\r\n ");
        String command = tok.nextToken();
        String pattern = "{0}, {1}";
        String date = DateFormat.getDateTimeInstance(3, 3).format(this.getTimeStamp());
        Object[] p = new String[]{command, date};
        return MessageFormat.format(pattern, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTimestamp() {
        HistoryItem historyItem = this;
        synchronized (historyItem) {
            this.dte = null;
            this.execTime = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateSQL(String newSQL) {
        HistoryItem historyItem = this;
        synchronized (historyItem) {
            this.sql = newSQL;
        }
    }
}

