/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core;

import java.sql.DriverManager;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.ui.MainFrame;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.UserPreferences;

public final class Launcher {
    public static long startTime = 0L;
    public static final ThreadGroup SHUT_DOWN_THREAD_GROUP = new ThreadGroup("isql-shutdown-hooks");

    private Launcher() {
        UserPreferences prefs = SystemConfig.getInstance().getPreferences();
        BasicUtilities.setLookAndFeel(prefs.get("general.plaf-class"));
        if (BasicUtilities.isMac() && !Boolean.getBoolean("apple.laf.useScreenMenuBar")) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        MainFrame frame = new MainFrame();
        frame.setVisible(true);
    }

    private static void handCMDLine(String[] args) {
        if (args.length >= 1) {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (arg.equalsIgnoreCase(BasicUtilities.getString("Help_Version_A")) || arg.equalsIgnoreCase(BasicUtilities.getString("Help_Version_B"))) {
                    System.out.println(BasicUtilities.getString("Help_Line_1", "2.1.8"));
                    System.exit(1);
                    continue;
                }
                if (arg.equalsIgnoreCase(BasicUtilities.getString("Help_Script_A")) || arg.equalsIgnoreCase(BasicUtilities.getString("Help_Script_B"))) {
                    try {
                        System.exit(1);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        System.out.println(BasicUtilities.getString("No_Script_Provied"));
                        System.exit(-1);
                    }
                    catch (Throwable t) {
                        BasicUtilities.HandleException(t, BasicUtilities.getString("Script_Error", args[i]), true);
                        System.exit(-1);
                    }
                    continue;
                }
                if (!arg.equalsIgnoreCase(BasicUtilities.getString("Help_Help_A")) && !arg.equalsIgnoreCase(BasicUtilities.getString("Help_Help_B"))) continue;
                String[] p = new String[2];
                System.out.println(BasicUtilities.getString("Help_Line_1", "2.1.8"));
                p[0] = BasicUtilities.getString("Help_Help_A");
                p[1] = BasicUtilities.getString("Help_Help_B");
                System.out.println(BasicUtilities.getString("Help_Line_X", p));
                System.out.println(BasicUtilities.getString("Help_Line_H"));
                System.out.println();
                p[0] = BasicUtilities.getString("Help_Script_A");
                p[1] = BasicUtilities.getString("Help_Script_B");
                System.out.println(BasicUtilities.getString("Help_Line_X", p));
                System.out.println(BasicUtilities.getString("Help_Line_B"));
                System.out.println();
                p[0] = BasicUtilities.getString("Help_Version_A");
                p[1] = BasicUtilities.getString("Help_Version_B");
                System.out.println(BasicUtilities.getString("Help_Line_X", p));
                System.out.println(BasicUtilities.getString("Help_Line_V"));
                System.out.println();
                System.exit(0);
            }
        }
    }

    private static class BasicShutdownHook
    implements Runnable {
        private BasicShutdownHook() {
        }

        @Override
        public void run() {
            try {
                DriverManager.getLogWriter().close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                System.err.close();
            }
            catch (Throwable throwable) {
            }
            finally {
                BasicUtilities.restoreSystemErr();
            }
            try {
                System.out.close();
            }
            catch (Throwable throwable) {
            }
            finally {
                BasicUtilities.restoreSystemOut();
            }
            System.out.println(BasicUtilities.getString("Shutdown_Message"));
            try {
                SystemConfig.shutdown();
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t);
            }
        }
    }
}

