/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.isqlviewer.core.CorePlugin;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringTokenizer;
import org.isqlviewer.util.StringUtilities;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class PluginFactory {
    private static final String MANIFEST_PLUGIN_SECTION = "isql:plugins";
    private static final String CACHE_FILE = "isql-plugins.xml";
    private Hashtable mapPlugins = new Hashtable();
    private ArrayList entryList = new ArrayList();
    private long lastDetection = 0L;
    private boolean isLoaded = false;

    public Collection createTableFilters() {
        return this.createPluginsForType(1);
    }

    public Collection createDataRenderers() {
        return this.createPluginsForType(2);
    }

    public Collection createImportHandlers() {
        return this.createPluginsForType(3);
    }

    public Collection createPluginsForType(int type) {
        this.checkState();
        HashMap typeMap = (HashMap)this.mapPlugins.get(Integer.toString(type));
        if (typeMap != null) {
            ArrayList<CorePlugin> arr = new ArrayList<CorePlugin>(typeMap.size());
            for (String clazz : typeMap.keySet()) {
                PluginEntry entry = (PluginEntry)typeMap.get(clazz);
                try {
                    CorePlugin pi = entry.createInstance(clazz, true);
                    if (pi == null || pi.getType() != type) continue;
                    arr.add(pi);
                }
                catch (Throwable t) {
                    BasicUtilities.HandleException(t);
                }
            }
            return arr;
        }
        return Arrays.asList(new CorePlugin[0]);
    }

    public int getCountForType(int type) {
        this.checkState();
        HashMap map = (HashMap)this.mapPlugins.get(Integer.toString(type));
        return map.size();
    }

    public CorePlugin pluginForName(int type, String className) {
        this.checkState();
        HashMap map = (HashMap)this.mapPlugins.get(Integer.toString(type));
        PluginEntry entry = (PluginEntry)map.get(className);
        if (entry != null) {
            return entry.createInstance(className, true);
        }
        return null;
    }

    static PluginFactory createInstance() {
        return new PluginFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        File file = new File(PluginFactory.getPluginCacheDirectory(), CACHE_FILE);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            this.store(fos);
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException iOException) {}
            fos = null;
        }
        this.destroyEntries();
    }

    private void destroyEntries() {
        Iterator itr = this.mapPlugins.keySet().iterator();
        while (itr.hasNext()) {
            HashMap typeMap = (HashMap)this.mapPlugins.get(itr.next());
            Iterator itr2 = typeMap.keySet().iterator();
            while (itr2.hasNext()) {
                PluginEntry entry = (PluginEntry)typeMap.get(itr2.next());
                entry.pluginLoader = null;
                itr2.remove();
            }
            itr.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws IOException {
        File file = new File(PluginFactory.getPluginCacheDirectory(), CACHE_FILE);
        this.installDefaultPlugins();
        if (file.exists() && file.canRead()) {
            try (FileInputStream inputStream = new FileInputStream(file);){
                XMLReader xmlReader = SystemConfig.getInstance().getXMLReader();
                xmlReader.setContentHandler(new CacheLoader(this));
                xmlReader.parse(new InputSource(inputStream));
            }
        } else if (!file.exists()) {
            this.detectPlugins();
        }
        this.isLoaded = true;
    }

    private void checkState() {
        if (!this.isLoaded) {
            try {
                this.load();
            }
            catch (IOException ioe) {
                BasicUtilities.HandleException(ioe);
            }
        }
    }

    private void store(OutputStream os) {
        Charset charset = Charset.forName("UTF-8");
        OutputStreamWriter writer = new OutputStreamWriter(os, charset);
        PrintWriter pw = new PrintWriter((Writer)writer, true);
        pw.print("<?xml version=\"1.0\" encoding=\"");
        pw.print(charset.name());
        pw.println("\" ?>");
        pw.print("<");
        pw.print(CacheLoader.TAG_ROOT);
        pw.print(" ");
        pw.print(CacheLoader.ATTR_CACHE_TIMESTAMP);
        pw.print("=\"");
        pw.print(Long.toString(this.lastDetection));
        pw.println("\" >");
        for (PluginEntry entry : this.entryList) {
            Collection plugins = entry.getMetadata();
            if (entry.isInternal() || plugins.size() <= 0) continue;
            pw.print("\t<");
            pw.print(CacheLoader.TAG_PLUGIN);
            pw.print(" ");
            pw.print(CacheLoader.ATTR_PLUGIN_FILE);
            pw.print("=\"");
            pw.print(StringUtilities.encodeXMLEntities(entry.jarLocation.getAbsolutePath()));
            pw.println("\" >");
            for (PluginMetaInfo pmi : plugins) {
                pw.print("\t\t<");
                pw.print(CacheLoader.TAG_ENTRY);
                pw.print(" ");
                pw.print(CacheLoader.ATTR_PLUGIN_CLASS);
                pw.print("=\"");
                pw.print(StringUtilities.encodeXMLEntities(pmi.className));
                pw.print("\" ");
                pw.print(CacheLoader.ATTR_PLUGIN_NAME);
                pw.print("=\"");
                pw.print(StringUtilities.encodeXMLEntities(pmi.pluginName));
                pw.print("\" ");
                pw.print(CacheLoader.ATTR_PLUGIN_TYPE);
                pw.print("=\"");
                pw.print(Integer.toString(pmi.pluginType));
                pw.println("\" />");
            }
            if (entry.classPath.size() > 1) {
                pw.print("\t\t<");
                pw.print(CacheLoader.TAG_PLUGIN_CLASSPATH);
                pw.println(">");
                for (int i = 1; i < entry.classPath.size(); ++i) {
                    URL url = (URL)entry.classPath.get(i);
                    pw.print("\t\t\t<");
                    pw.print(CacheLoader.TAG_JAR);
                    pw.print(" ");
                    pw.print(CacheLoader.ATTR_PLUGIN_FILE);
                    pw.print("=\"");
                    pw.print(StringUtilities.encodeXMLEntities(url.toExternalForm()));
                    pw.println("\" />");
                }
                pw.print("\t\t</");
                pw.print(CacheLoader.TAG_PLUGIN_CLASSPATH);
                pw.println(">");
            }
            pw.print("\t</");
            pw.print(CacheLoader.TAG_PLUGIN);
            pw.println(">");
        }
        pw.print("</");
        pw.print(CacheLoader.TAG_ROOT);
        pw.println(">");
        pw.flush();
        pw.close();
        pw = null;
    }

    private void detectPlugins() {
        System.out.println(BasicUtilities.getString("Detecting_Plugins"));
        File[] pif = PluginFactory.getPluginFiles();
        if (pif != null) {
            for (int i = 0; i < pif.length; ++i) {
                try {
                    JarFile jf = new JarFile(pif[i]);
                    this.registerEntry(new PluginEntry(pif[i], jf));
                    continue;
                }
                catch (IOException ioe) {
                    BasicUtilities.HandleException(ioe);
                }
            }
        }
        this.lastDetection = System.currentTimeMillis();
    }

    private void installDefaultPlugins() {
        this.destroyEntries();
        PluginEntry entry = new PluginEntry(PluginFactory.getDefaultPlugins());
        this.registerEntry(entry);
    }

    private void registerEntry(PluginEntry entry) {
        Collection plugins = entry.getMetadata();
        for (PluginMetaInfo pmi : plugins) {
            String key = Integer.toString(pmi.pluginType);
            HashMap<String, PluginEntry> typeMap = (HashMap<String, PluginEntry>)this.mapPlugins.get(key);
            if (typeMap == null) {
                typeMap = new HashMap<String, PluginEntry>();
                this.mapPlugins.put(key, typeMap);
            }
            typeMap.put(pmi.className, entry);
        }
        if (!this.entryList.contains(entry) && !entry.isInternal()) {
            this.entryList.add(entry);
        }
    }

    private static File getPluginDirectory() {
        return SystemConfig.getiSQLSubDir(BasicUtilities.getString("Extension_Folder"));
    }

    private static File getPluginCacheDirectory() {
        File f = new File(SystemConfig.getBaseDirectory(), ".plugin-cache");
        if (!f.exists()) {
            f.mkdirs();
        }
        return f;
    }

    private static File[] getPluginFiles() {
        JarFileNameFilter fnf = new JarFileNameFilter();
        return PluginFactory.getPluginDirectory().listFiles(fnf);
    }

    private static String[] getDefaultPlugins() {
        return new String[]{"org.isqlviewer.core.jetfire.ColumnSkipPlugin", "org.isqlviewer.core.jetfire.MapperPlugin", "org.isqlviewer.core.jetfire.AutovaluePlugin", "org.isqlviewer.core.jetfire.LookupPlugin", "org.isqlviewer.core.filters.CSVTableFilter", "org.isqlviewer.core.filters.ExcelTableFilter", "org.isqlviewer.core.filters.HTMLTableFilter", "org.isqlviewer.core.filters.XMLTableFilter", "org.isqlviewer.core.filters.LOBTableFilter", "org.isqlviewer.core.filters.SolverTableFilter", "org.isqlviewer.core.renderers.BinaryRenderer", "org.isqlviewer.core.renderers.ImageRenderer", "org.isqlviewer.core.renderers.TextRenderer"};
    }

    private static class CacheLoader
    extends DefaultHandler {
        private static String TAG_ROOT = "isql-plugin-cache";
        private static String TAG_PLUGIN = "plugin-entry";
        private static String TAG_ENTRY = "plugin";
        private static String TAG_PLUGIN_CLASSPATH = "classpath";
        private static String TAG_JAR = "jar";
        private static String ATTR_CACHE_TIMESTAMP = "timestamp";
        private static String ATTR_PLUGIN_CLASS = "classname";
        private static String ATTR_PLUGIN_TYPE = "type";
        private static String ATTR_PLUGIN_NAME = "name";
        private static String ATTR_PLUGIN_FILE = "location";
        private PluginFactory instance = null;
        private PluginEntry currentEntry = null;
        private boolean loadOverride = false;

        @Override
        public void endDocument() {
            if (this.loadOverride) {
                this.instance.installDefaultPlugins();
                this.instance.detectPlugins();
            }
        }

        public CacheLoader(PluginFactory factory) {
            this.instance = factory;
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (!this.loadOverride && localName.equalsIgnoreCase(TAG_PLUGIN)) {
                this.instance.registerEntry(this.currentEntry);
                this.currentEntry = null;
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, org.xml.sax.Attributes attributes) {
            if (localName.equalsIgnoreCase(TAG_ROOT)) {
                long lastModified = Long.parseLong(attributes.getValue(ATTR_CACHE_TIMESTAMP));
                this.loadOverride = lastModified < PluginFactory.getPluginDirectory().lastModified();
                this.instance.lastDetection = lastModified;
            } else if (!this.loadOverride) {
                if (localName.equalsIgnoreCase(TAG_PLUGIN)) {
                    String location = attributes.getValue(ATTR_PLUGIN_FILE);
                    this.currentEntry = new PluginEntry(location);
                } else if (this.currentEntry != null && localName.equalsIgnoreCase(TAG_ENTRY)) {
                    try {
                        String clazz = attributes.getValue(ATTR_PLUGIN_CLASS);
                        String name = attributes.getValue(ATTR_PLUGIN_NAME);
                        int type = Integer.parseInt(attributes.getValue(ATTR_PLUGIN_TYPE));
                        PluginMetaInfo pmi = new PluginMetaInfo();
                        pmi.className = clazz;
                        pmi.pluginType = type;
                        pmi.pluginName = name;
                        this.currentEntry.addCachedMetadata(pmi);
                    }
                    catch (Throwable clazz) {}
                } else if (this.currentEntry != null && localName.equalsIgnoreCase(TAG_JAR)) {
                    try {
                        String file = attributes.getValue(ATTR_PLUGIN_FILE);
                        this.currentEntry.addCachedURL(new URL(file));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private static class JarFileNameFilter
    implements FilenameFilter {
        private JarFileNameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            int idx = name.lastIndexOf(46) + 1;
            String ext = name.substring(idx < 0 ? 0 : idx);
            return ext.equalsIgnoreCase("jar");
        }
    }

    private static class PluginEntry {
        private ClassLoader pluginLoader = null;
        private ArrayList classPath = new ArrayList();
        private ArrayList plugins = new ArrayList();
        private File jarLocation = null;

        public boolean equals(Object obj) {
            if (obj instanceof PluginEntry) {
                PluginEntry other = (PluginEntry)obj;
                if (this.isInternal()) {
                    return this.isInternal() == other.isInternal();
                }
                return other.jarLocation.equals(this.jarLocation);
            }
            return false;
        }

        public int hashCode() {
            return (this.jarLocation == null ? 0 : this.jarLocation.hashCode()) + (this.isInternal() ? 1 : 0);
        }

        public boolean isInternal() {
            return this.jarLocation == null;
        }

        public Collection getMetadata() {
            return (Collection)this.plugins.clone();
        }

        private PluginEntry(String[] classes) {
            this.pluginLoader = PluginEntry.class.getClassLoader();
            this.addInternalClasses(classes);
        }

        private PluginEntry(String cachedFileName) {
            this.jarLocation = new File(cachedFileName);
            if (!this.jarLocation.exists() || !this.jarLocation.canRead()) {
                throw new IllegalArgumentException();
            }
            try {
                this.classPath.add(this.jarLocation.toURL());
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t);
                throw new RuntimeException(t);
            }
        }

        private PluginEntry(File location, JarFile jarFile) {
            if (location.exists()) {
                try {
                    this.jarLocation = location;
                    this.classPath.add(location.toURL());
                    this.scanManifest(jarFile.getManifest());
                }
                catch (Throwable t) {
                    BasicUtilities.HandleException(t);
                    throw new RuntimeException(t);
                }
            }
        }

        private void addCachedMetadata(PluginMetaInfo metaInfo) {
            this.plugins.add(metaInfo);
        }

        private void addCachedURL(URL cachedURL) {
            this.classPath.add(cachedURL);
        }

        private void scanManifest(Manifest m) {
            int pluginCount = 0;
            Attributes attr = m.getAttributes(PluginFactory.MANIFEST_PLUGIN_SECTION);
            Iterator<Object> itr = attr.keySet().iterator();
            if (attr.containsKey(Attributes.Name.CLASS_PATH)) {
                try {
                    this.createClasspath(attr.getValue(Attributes.Name.CLASS_PATH));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            while (itr.hasNext()) {
                Attributes.Name id = (Attributes.Name)itr.next();
                if (id.equals(Attributes.Name.CLASS_PATH)) continue;
                String clazz = attr.getValue(id);
                try {
                    CorePlugin plugin = this.createInstance(clazz, false);
                    PluginMetaInfo md = new PluginMetaInfo();
                    md.className = clazz;
                    md.pluginName = plugin.getName();
                    md.pluginType = plugin.getType();
                    this.plugins.add(md);
                    plugin = null;
                    ++pluginCount;
                }
                catch (Throwable t) {
                    BasicUtilities.HandleException(t, clazz);
                }
            }
            String msg = BasicUtilities.getString("Plugins_Found", new String[]{Integer.toString(pluginCount), this.jarLocation.getAbsolutePath()});
            System.out.println(msg);
        }

        private void addInternalClasses(String[] classes) {
            for (int i = 0; i < classes.length; ++i) {
                try {
                    CorePlugin plugin = this.createInstance(classes[i], false);
                    PluginMetaInfo md = new PluginMetaInfo();
                    md.className = classes[i];
                    md.pluginName = plugin.getName();
                    md.pluginType = plugin.getType();
                    this.plugins.add(md);
                    plugin = null;
                    continue;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }

        protected ClassLoader getClassLoader() {
            if (this.pluginLoader == null) {
                try {
                    this.pluginLoader = new URLClassLoader(this.classPath.toArray(new URL[0]));
                }
                catch (Throwable t) {
                    BasicUtilities.HandleException(t);
                    this.pluginLoader = PluginEntry.class.getClassLoader();
                }
            }
            return this.pluginLoader;
        }

        protected URL getBaseURL() {
            try {
                return this.jarLocation.toURL();
            }
            catch (Throwable t) {
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void createClasspath(String libs) throws MalformedURLException {
            String jarPattern = "{0}.jar";
            String context = "jar:".concat(this.jarLocation.toURL().toExternalForm()).concat("!/");
            File cacheDirectory = PluginFactory.getPluginCacheDirectory();
            StringTokenizer st = new StringTokenizer(libs, " ,;:", false);
            while (st.hasMoreTokens()) {
                String path = st.nextToken();
                URL jarURL = new URL(context.concat(path));
                Object[] params = new Object[]{Long.toHexString(System.currentTimeMillis()).toUpperCase()};
                String jarName = MessageFormat.format(jarPattern, params);
                File jarFile = new File(cacheDirectory, jarName);
                InputStream jarInput = null;
                FileOutputStream jarOutput = null;
                try {
                    if (!jarFile.createNewFile()) continue;
                    jarOutput = new FileOutputStream(jarFile);
                    jarInput = jarURL.openStream();
                    BasicUtilities.copyStream(jarInput, jarOutput);
                    this.classPath.add(jarFile.toURL());
                }
                catch (Throwable t) {
                    BasicUtilities.HandleException(t);
                }
                finally {
                    try {
                        jarInput.close();
                    }
                    catch (Throwable throwable) {}
                    try {
                        jarOutput.close();
                    }
                    catch (Throwable throwable) {}
                    jarInput = null;
                    jarOutput = null;
                }
            }
        }

        protected CorePlugin createInstance(String className, boolean init) {
            try {
                return (CorePlugin)Class.forName(className, init, this.getClassLoader()).newInstance();
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t);
                return null;
            }
        }
    }

    private static class PluginMetaInfo {
        String className = null;
        String pluginName = null;
        int pluginType = -1;

        private PluginMetaInfo() {
        }
    }
}

