/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import org.isqlviewer.core.ServiceDefinition;
import org.isqlviewer.core.ServiceProvider;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringTokenizer;
import org.isqlviewer.util.StringUtilities;
import org.isqlviewer.util.UserPreferences;

class ServiceProviderImpl
implements ServiceProvider {
    private static final String CACHE_FILE = "services.cache";
    private static final String KEY_SERVICE_LIST = "SERVICE_ORDER";
    private static final String URL_ENCODING = "UTF8";
    private static final String SERVICE_SEPERATOR = "\u0001";
    private Properties serviceMap = null;
    private boolean isLoaded = false;

    ServiceProviderImpl() {
    }

    @Override
    public ServiceDefinition serviceForName(String name) {
        return this.serviceForName(name, true);
    }

    @Override
    public ServiceDefinition serviceForName(String service, boolean forceSync) {
        this.checkState();
        SystemConfig sysConfig = SystemConfig.getInstance();
        Properties defaults = sysConfig.getJDBCDefaults();
        UserPreferences userPrefs = sysConfig.getPreferences();
        boolean defaultSecurity = userPrefs.getBoolean("general.security-enabled");
        String serviceKey = service.toUpperCase();
        if (this.serviceMap.containsKey(serviceKey)) {
            ServiceDefinition newService = new ServiceDefinition(defaults, defaultSecurity);
            String url = this.serviceMap.getProperty(service.toUpperCase());
            try {
                URL serviceURL = new URL(url);
                InputStream inputStream = serviceURL.openStream();
                newService.load(inputStream);
                inputStream.close();
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException(uee);
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t, url);
                return null;
            }
            if (forceSync && newService.isRemote()) {
                try {
                    if (newService.synchronize()) {
                        System.out.println(BasicUtilities.getString("Service_Sync_Success", service));
                        try {
                            this.saveService(newService);
                        }
                        catch (IOException ioe) {
                            BasicUtilities.HandleException(ioe);
                        }
                    }
                }
                catch (Throwable t) {
                    BasicUtilities.HandleException(t, BasicUtilities.getString("Service_Sync_Error", service));
                    return null;
                }
            }
            return newService;
        }
        String reason = BasicUtilities.getString("Service_Not_Registered_Error", service);
        throw new IllegalArgumentException(reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveService(ServiceDefinition service) throws IOException {
        this.checkState();
        String url = this.serviceMap.getProperty(service.getName().toUpperCase());
        if (url == null) {
            String reason = BasicUtilities.getString("Service_Not_Registered_Error", service.getName());
            throw new IllegalArgumentException(reason);
        }
        File file = null;
        try {
            URL location = new URL(url);
            file = new File(location.getPath());
            if (file.exists()) {
                if (!file.canWrite()) {
                    throw new IOException(BasicUtilities.getString("Error_Writing_File", url));
                }
            } else {
                file.createNewFile();
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, BasicUtilities.getString("Error_Writing_File", url));
            return false;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            service.store(fos);
            this.store();
            fos.flush();
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            BasicUtilities.HandleException(ioe, BasicUtilities.getString("Error_Writing_File", url));
            throw ioe;
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, "ServiceProvider::saveService(ServiceDefinition)");
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                fos.close();
            }
            catch (Throwable throwable) {}
            fos = null;
            file = null;
            url = null;
        }
    }

    @Override
    public boolean registerService(String service, URL location) {
        this.checkState();
        if (service == null) {
            String reason = BasicUtilities.getString("Service_Null_Register_Error");
            throw new IllegalArgumentException(reason);
        }
        if ((service = service.trim()).indexOf(SERVICE_SEPERATOR) >= 0) {
            String reason = BasicUtilities.getString("Service_Register_Error");
            throw new IllegalArgumentException(reason);
        }
        if (location == null) {
            try {
                location = new File(SystemConfig.getBaseDirectory(), service.concat(".service")).toURL();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        if (this.isURLRegistered(location)) {
            String reason = BasicUtilities.getString("Service_URL_Registered_Error", location.toExternalForm());
            throw new IllegalArgumentException(reason);
        }
        if (service.equalsIgnoreCase(KEY_SERVICE_LIST)) {
            throw new IllegalArgumentException(BasicUtilities.getString("Service_Registered_Reservered_Error", service));
        }
        String key = service.trim().toUpperCase();
        String val = null;
        val = location.toExternalForm();
        if (this.isRegistered(service) && !this.deregisterService(service)) {
            return false;
        }
        this.serviceMap.setProperty(key, val);
        this.addNewServiceTolist(service);
        return true;
    }

    @Override
    public boolean registerService(ServiceDefinition service, URL location) {
        if (service == null) {
            String reason = BasicUtilities.getString("Service_Null_Register_Error");
            throw new IllegalArgumentException(reason);
        }
        return this.registerService(service.getName(), location);
    }

    @Override
    public boolean deregisterService(String service) {
        if (service != null) {
            this.checkState();
            String serviceKey = service.toUpperCase();
            if (this.serviceMap.containsKey(serviceKey)) {
                String serviceURL = (String)this.serviceMap.remove(serviceKey);
                this.removeNameFromServerList(service);
                return serviceURL != null;
            }
        }
        return false;
    }

    @Override
    public boolean deregisterService(ServiceDefinition service) {
        if (service != null) {
            return this.deregisterService(service.getName());
        }
        return false;
    }

    @Override
    public boolean isRegistered(ServiceDefinition service) {
        if (service != null) {
            return this.isRegistered(service.getName());
        }
        return false;
    }

    @Override
    public boolean isRegistered(String service) {
        if (service != null) {
            this.checkState();
            String serviceKey = service.toUpperCase();
            return this.serviceMap.containsKey(serviceKey);
        }
        return false;
    }

    @Override
    public boolean isURLRegistered(URL location) {
        if (location != null) {
            this.checkState();
            Iterator<Object> itr = this.serviceMap.keySet().iterator();
            String key = null;
            try {
                key = URLEncoder.encode(location.toExternalForm(), URL_ENCODING);
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException(uee);
            }
            while (itr.hasNext()) {
                String uri = (String)this.serviceMap.get(itr.next());
                if (!uri.equals(key)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String nameForURL(URL location) {
        if (location != null) {
            this.checkState();
            Iterator<Object> itr = this.serviceMap.keySet().iterator();
            String key = null;
            try {
                key = URLEncoder.encode(location.toExternalForm(), URL_ENCODING);
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException(uee);
            }
            while (itr.hasNext()) {
                String name = (String)itr.next();
                String uri = (String)this.serviceMap.get(name);
                if (!uri.equals(key)) continue;
                return name;
            }
        }
        return null;
    }

    @Override
    public URI uriForService(String name) {
        this.checkState();
        String serviceKey = name.toUpperCase();
        if (this.serviceMap.containsKey(serviceKey)) {
            try {
                String url = this.serviceMap.getProperty(serviceKey);
                URL location = new URL(url);
                return new URI(location.toString());
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        String reason = BasicUtilities.getString("Service_Not_Registered_Error", name);
        throw new IllegalArgumentException(reason);
    }

    @Override
    public URI uriForService(ServiceDefinition service) {
        return this.uriForService(service.getName());
    }

    @Override
    public void detectServices() {
        this.checkState();
        StringBuffer key = new StringBuffer("");
        this.serviceMap.clear();
        File[] paths = this.getPathLocations();
        for (int i = 0; i < paths.length; ++i) {
            try {
                this.scanDirectory(paths[i], key);
                continue;
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t);
            }
        }
        paths = null;
        this.serviceMap.put(KEY_SERVICE_LIST, key.toString());
        try {
            this.store();
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, "ServiceProviderImpl::store()");
        }
    }

    @Override
    public Collection getRegisteredServices() {
        return this.getRegisteredServices(false);
    }

    @Override
    public Collection getRegisteredServices(boolean preferredOrder) {
        this.checkState();
        if (preferredOrder) {
            ArrayList<String> list = new ArrayList<String>();
            String order = this.serviceMap.getProperty(KEY_SERVICE_LIST);
            if (order != null) {
                StringTokenizer st = new StringTokenizer(order, SERVICE_SEPERATOR, false, true);
                while (st.hasMoreTokens()) {
                    list.add(st.nextToken());
                }
            }
            return list;
        }
        ArrayList<Object> list = new ArrayList<Object>(this.serviceMap.keySet());
        list.remove(KEY_SERVICE_LIST);
        return list;
    }

    @Override
    public void setPreferredServiceOrder(Collection services) {
        if (services != null) {
            Iterator itr = services.iterator();
            StringBuffer order = new StringBuffer("");
            while (itr.hasNext()) {
                Object next = itr.next();
                String service = next.toString();
                if (!this.isRegistered(service)) continue;
                order.append(next.toString());
                order.append(SERVICE_SEPERATOR);
            }
            this.serviceMap.setProperty(KEY_SERVICE_LIST, order.toString());
            order.setLength(0);
            order = null;
            itr = null;
            try {
                this.store();
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t, "ServiceProviderImpl::store()");
            }
        }
    }

    @Override
    public boolean removeService(ServiceDefinition service) throws IOException {
        return this.removeService(service.getName());
    }

    @Override
    public boolean removeService(String service) throws IOException {
        this.checkState();
        if (service == null) {
            String reason = BasicUtilities.getString("Service_Null_Remove_Error");
            throw new IllegalArgumentException(reason);
        }
        String serviceKey = service.toUpperCase();
        if (this.serviceMap.containsKey(serviceKey)) {
            URL url = new URL(this.serviceMap.getProperty(service.toUpperCase()));
            File file = new File(url.getPath());
            boolean deleted = true;
            if (file.exists()) {
                file.delete();
            }
            this.deregisterService(service);
            try {
                this.store();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return deleted;
        }
        String reason = BasicUtilities.getString("Service_Not_Found_Error", service);
        throw new IllegalArgumentException(reason);
    }

    private void checkState() {
        if (!this.isLoaded) {
            try {
                this.load();
            }
            catch (IOException ioe) {
                BasicUtilities.HandleException(ioe, "ServiceProviderImpl::load()");
            }
        }
    }

    private void load() throws IOException {
        this.serviceMap = null;
        this.serviceMap = new Properties();
        File file = new File(SystemConfig.getBaseDirectory(), CACHE_FILE);
        if (file.exists() && file.canRead()) {
            FileInputStream inputStream = new FileInputStream(file);
            this.serviceMap.load(inputStream);
            String order = this.serviceMap.getProperty(KEY_SERVICE_LIST, SERVICE_SEPERATOR);
            StringTokenizer st = new StringTokenizer(order, SERVICE_SEPERATOR, false, true);
            if (st.countTokens() != this.serviceMap.size() - 1) {
                this.serviceMap.clear();
            }
            this.isLoaded = true;
        } else if (!file.exists()) {
            this.isLoaded = true;
            this.detectServices();
        }
    }

    private void store() throws IOException {
        File file = new File(SystemConfig.getBaseDirectory(), CACHE_FILE);
        if (!file.exists() && !file.createNewFile()) {
            return;
        }
        if (file.canWrite()) {
            FileOutputStream outputStream = new FileOutputStream(file);
            this.serviceMap.store(outputStream, "2.1.8");
        }
    }

    private void removeNameFromServerList(String service) {
        String list = this.serviceMap.getProperty(KEY_SERVICE_LIST, "");
        service = service.concat(SERVICE_SEPERATOR);
        list = StringUtilities.removeSubString(list, service);
        this.serviceMap.setProperty(KEY_SERVICE_LIST, list);
    }

    private void addNewServiceTolist(String service) {
        String list = this.serviceMap.getProperty(KEY_SERVICE_LIST, "");
        list = list.concat(service);
        list = list.concat(SERVICE_SEPERATOR);
        this.serviceMap.setProperty(KEY_SERVICE_LIST, list);
    }

    private File[] getPathLocations() {
        UserPreferences userPrefs = SystemConfig.getInstance().getPreferences();
        String path = userPrefs.get("advanced.servicepath");
        StringTokenizer st = new StringTokenizer(path, File.pathSeparator, false);
        ArrayList<File> paths = new ArrayList<File>();
        paths.add(SystemConfig.getBaseDirectory());
        while (st.hasMoreTokens()) {
            String loc = st.nextToken();
            if (loc == null) continue;
            paths.add(new File(loc));
        }
        return paths.toArray(new File[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanDirectory(File dir, StringBuffer list) {
        File[] files = dir.listFiles(ServiceDefinition.getFileNameFilter());
        if (files == null) {
            return;
        }
        Properties defaults = new Properties(null);
        UserPreferences userPrefs = SystemConfig.getInstance().getPreferences();
        boolean defaultSecurity = userPrefs.getBoolean("general.security-enabled");
        ServiceDefinition sd = new ServiceDefinition(defaults, defaultSecurity);
        for (int i = 0; i < files.length; ++i) {
            FileInputStream fis = null;
            boolean addKeyToList = false;
            try {
                fis = new FileInputStream(files[i]);
                sd.load(fis);
                fis.close();
                String service = sd.getName().toUpperCase().trim();
                addKeyToList = !this.serviceMap.containsKey(service);
                this.serviceMap.setProperty(service, files[i].toURL().toString());
            }
            catch (Throwable t) {
                String msg = BasicUtilities.getString("Error_Reading_File", files[i].getAbsolutePath());
                BasicUtilities.HandleException(t, msg, true);
                continue;
            }
            finally {
                try {
                    fis.close();
                }
                catch (Throwable service) {}
            }
            if (!addKeyToList) continue;
            try {
                String[] p = new String[]{sd.getName(), files[i].toURL().toExternalForm()};
                System.out.println(BasicUtilities.getString("Service_Detected_Message", p));
                list.append(sd.getName());
                list.append(SERVICE_SEPERATOR);
                continue;
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t);
            }
        }
        defaults = null;
        userPrefs = null;
        sd = null;
    }
}

