/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core;

import com.gigaspaces.admin.ui.util.UIHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.UIManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.isqlviewer.core.ConfigConstants;
import org.isqlviewer.core.HistoryManager;
import org.isqlviewer.core.IPCService;
import org.isqlviewer.core.PluginFactory;
import org.isqlviewer.core.ServiceProvider;
import org.isqlviewer.core.model.BookmarkTreeModel;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringTokenizer;
import org.isqlviewer.util.StringUtilities;
import org.isqlviewer.util.UserPreferences;
import org.xml.sax.XMLReader;

public final class SystemConfig {
    public static final int VERSION_MAJOR = 2;
    public static final int VERSION_MINOR = 1;
    public static final int VERSION_BUILD = 8;
    public static final String ISQL_VERSION = "2.1.8";
    public static final String PROPERTY_MRJ_ENABLED = "isql.mrj.enabled";
    public static final String PROPERTY_HOME = "isql.home";
    public static final String PROPERTY_PLUGIN_HOME = "isql.home.plugins";
    public static final String PROPERTY_SCRIPT_HOME = "isql.home.scripts";
    public static final String PROPERTY_LIBRARY_HOME = "isql.home.library";
    public static final String PROPERTY_VERSION = "isql.version";
    public static final String PROPERTY_SERVICE_PROVIDER = "isql.service.provider";
    public static final String PROPERTY_DEBUG = "isql.debug";
    public static final String PROPERTY_DEBUG_THREADS = "isql.debug.threads";
    public static final String PROPERTY_JAVA_WEBSTART = "isql.jnlp";
    public static final String PROPERTY_PROXY_ENABLED = "isql.proxy.enabled";
    public static final String PROPERTY_STANDALONE = "isql.stand-alone";
    public static final String PROPERTY_DEFAULTS_ROOT = "isql.prefs.root";
    private static final String preferencesRoot = System.getProperty("isql.prefs.root", "/org/isqlviewer/core/Preferences");
    private static final String fileBookmarks = "bookmarks.xml";
    private static File baseDirectory = null;
    private static File scriptDirectory = null;
    private static File pluginDirectory = null;
    private static File libraryDirectory = null;
    private static SystemConfig instance = new SystemConfig();
    private final String serviceProviderClass = System.getProperty("isql.service.provider", "org.isqlviewer.core.ServiceProviderImpl");
    private final String fileDrivers = "driver.properties";
    private UserPreferences userPreferences = new UserPreferences(SystemConfig.getDefaults(), preferencesRoot);
    private IPCService ipcService = new IPCService();
    private PluginFactory pluginFactory = PluginFactory.createInstance();
    private HistoryManager historyManager = HistoryManager.createInstance(this);
    private ServiceProvider serviceProvider = null;
    private EventHandlerSupport eventSupport = new EventHandlerSupport();
    private ClassLoader rtClassLoader = null;
    private Thread threadBookmarkSaver = null;
    private Thread threadIPC = null;
    private BookmarkTreeModel bookmarks = null;
    private long sessionTime = 0L;

    public static File getBaseDirectory() {
        File defaultBase;
        File userUIHomeDirectory = UIHelper.getProductUIHomeDirectory();
        if (baseDirectory == null && !(baseDirectory = new File(System.getProperty(PROPERTY_HOME, (defaultBase = new File(userUIHomeDirectory, ".iSQL-Viewer")).getAbsolutePath()))).exists()) {
            baseDirectory.mkdirs();
        }
        return baseDirectory;
    }

    public static File getScriptsDirectory() {
        if (scriptDirectory == null) {
            File defaultBase = new File(SystemConfig.getBaseDirectory(), "scripts");
            scriptDirectory = new File(System.getProperty(PROPERTY_SCRIPT_HOME, defaultBase.getAbsolutePath()));
        }
        return scriptDirectory;
    }

    public static File getLibraryDirectory() {
        if (libraryDirectory == null) {
            File defaultBase = new File(SystemConfig.getBaseDirectory(), "lib");
            libraryDirectory = new File(System.getProperty(PROPERTY_LIBRARY_HOME, defaultBase.getAbsolutePath()));
        }
        return libraryDirectory;
    }

    public static File getPluginDirectory() {
        if (pluginDirectory == null) {
            File defaultBase = new File(SystemConfig.getBaseDirectory(), "plugins");
            pluginDirectory = new File(System.getProperty(PROPERTY_PLUGIN_HOME, defaultBase.getAbsolutePath()));
        }
        return pluginDirectory;
    }

    public static File getiSQLSubDir(String sub) {
        File f = new File(baseDirectory, sub);
        if (!f.exists()) {
            f.mkdirs();
        }
        return f;
    }

    public static synchronized SystemConfig getInstance() {
        return instance;
    }

    private SystemConfig() {
        System.setProperty(PROPERTY_HOME, SystemConfig.getBaseDirectory().getAbsolutePath());
        System.setProperty(PROPERTY_LIBRARY_HOME, SystemConfig.getLibraryDirectory().getAbsolutePath());
        System.setProperty(PROPERTY_SCRIPT_HOME, SystemConfig.getScriptsDirectory().getAbsolutePath());
        System.setProperty(PROPERTY_PLUGIN_HOME, SystemConfig.getPluginDirectory().getAbsolutePath());
        System.setProperty(PROPERTY_VERSION, ISQL_VERSION);
        System.setProperty(PROPERTY_SERVICE_PROVIDER, this.serviceProviderClass);
        System.setProperty(PROPERTY_DEFAULTS_ROOT, preferencesRoot);
        this.createServiceProvider();
        if (Boolean.valueOf(System.getProperty(PROPERTY_STANDALONE, "true")).booleanValue()) {
            System.setProperty(PROPERTY_STANDALONE, "true");
        }
        if (Boolean.valueOf(System.getProperty(PROPERTY_PROXY_ENABLED, "true")).booleanValue()) {
            Authenticator.setDefault(new ProxyAuthenticator());
            System.setProperty(PROPERTY_PROXY_ENABLED, "true");
        }
        String s = this.userPreferences.get("iSQL-Version");
        boolean update = this.userPreferences.getBoolean("general.driverupdate-enabled");
        this.initDriverDefinitions(update && !s.equalsIgnoreCase(ISQL_VERSION));
        this.userPreferences.put("iSQL-Version", ISQL_VERSION);
        this.threadIPC = new Thread((Runnable)this.ipcService, "isql-ipc-service");
        this.threadIPC.start();
        this.sessionTime = System.currentTimeMillis();
        this.killSessionPreferences();
    }

    public UserPreferences getPreferences() {
        return this.userPreferences;
    }

    public ServiceProvider getServiceProvider() {
        return this.serviceProvider;
    }

    public File[] getRuntimeClasspaths() {
        String Srv = this.userPreferences.get("advanced.classpath");
        StringTokenizer st = new StringTokenizer(Srv, File.pathSeparator, false);
        File[] servers = new File[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            servers[i++] = new File(st.nextToken());
        }
        return servers;
    }

    public Properties getDriverDefinitions() {
        File fdDrivers = new File(baseDirectory, "driver.properties");
        Properties props = new Properties();
        if (fdDrivers.exists()) {
            try {
                props.load(new FileInputStream(fdDrivers));
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t, "SystemConfig::getDriverDefinitions()");
            }
        } else {
            try {
                URL url = BasicUtilities.getResourceURL("driver.properties");
                props.load(url.openStream());
                url = null;
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t, "SystemConfig::getDriverDefinitions()");
            }
        }
        fdDrivers = null;
        return props;
    }

    public ClassLoader getRuntimeClassLoader(boolean reload) {
        if (reload || this.rtClassLoader == null) {
            this.initRuntimeClasspath();
        }
        return this.rtClassLoader;
    }

    public ClassLoader getRuntimeClassLoader() {
        return this.getRuntimeClassLoader(false);
    }

    public BookmarkTreeModel getBookmarks() {
        if (this.bookmarks == null) {
            this.bookmarks = new BookmarkTreeModel();
            this.bookmarks.addTreeModelListener(this.eventSupport);
            try {
                File f = new File(SystemConfig.getBaseDirectory(), fileBookmarks);
                if (!f.exists()) {
                    return this.bookmarks;
                }
                this.bookmarks.load(this.getXMLReader(), new FileInputStream(f));
                Thread saver = new Thread((Runnable)this.eventSupport, "bookmark-saver");
                saver.setDaemon(true);
                saver.setPriority(1);
                saver.start();
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t);
            }
        }
        return this.bookmarks;
    }

    public Properties getJDBCDefaults() {
        String[] keys = new String[]{"jdbc.autocommit-enabled", "jdbc.debug-enabled", "jdbc.escapeProc-enabled", "jdbc.keepalive-enabled", "jdbc.max-fieldsize", "jdbc.max-rows", "jdbc.reverseFetch-enabled", "jdbc.trace-enabled", "jdbc.verbose-enabled", "jdbc.echo-query", "jdbc.echo-rowcount", "jdbc.resultsetkeys-enabled"};
        return this.userPreferences.toPropertiesWithKeys(Arrays.asList(keys));
    }

    public XMLReader getXMLReader() {
        XMLReader reader = null;
        try {
            try {
                SAXParserFactory spf = SAXParserFactory.newInstance();
                spf.setValidating(false);
                reader = spf.newSAXParser().getXMLReader();
            }
            catch (ParserConfigurationException pce) {
                BasicUtilities.HandleException(pce);
            }
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t);
            reader = null;
        }
        return reader;
    }

    public HistoryManager getHistoryManager() {
        return this.historyManager;
    }

    public PluginFactory getPluginFactory() {
        return this.pluginFactory;
    }

    public IPCService getIPCService() {
        return this.ipcService;
    }

    public String getFormatForSQLType(int type) {
        switch (type) {
            case 91: {
                return this.userPreferences.get("general.date-format");
            }
            case 92: {
                return this.userPreferences.get("general.time-format");
            }
            case 93: {
                return this.userPreferences.get("general.timestamp-format");
            }
        }
        return null;
    }

    public Object[] performWebCheck() throws Exception {
        int localchecksum;
        int webbuild;
        Object[] returns = new Object[]{null, null, Boolean.FALSE};
        if (Boolean.getBoolean(PROPERTY_JAVA_WEBSTART)) {
            return returns;
        }
        URL homeURL = new URL("http://isql.sourceforge.net/version.php");
        URLConnection httpConnection = homeURL.openConnection();
        httpConnection.connect();
        returns[1] = httpConnection.getHeaderField("iSQL-Version");
        returns[0] = httpConnection.getHeaderField("Version-Type");
        if (returns[1] == null) {
            throw new IOException(BasicUtilities.getString("Web_Check_Proxy_Warning"));
        }
        String webver = returns[1].toString();
        int idxa = 0;
        int idxb = webver.indexOf(46, idxa);
        int webmaj = Integer.parseInt(webver.substring(idxa, idxb));
        idxa = idxb + 1;
        idxb = webver.indexOf(46, idxa);
        int webmin = Integer.parseInt(webver.substring(idxa, idxb));
        int webchecksum = 100 * webmaj + 10 * webmin + (webbuild = Integer.parseInt(webver.substring(idxa = idxb + 1)));
        returns[2] = new Boolean(webchecksum > (localchecksum = 218));
        return returns;
    }

    long getSessionTime() {
        return this.sessionTime;
    }

    static synchronized void shutdown() {
        if (instance == null) {
            return;
        }
        instance.killSessionPreferences();
        SystemConfig.instance.threadIPC.interrupt();
        instance.getHistoryManager().shutdown(instance);
        SystemConfig.instance.pluginFactory.shutdown();
        if (SystemConfig.instance.threadBookmarkSaver != null) {
            SystemConfig.instance.threadBookmarkSaver.interrupt();
            try {
                SystemConfig.instance.threadBookmarkSaver.join(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        SystemConfig.storeBookmarks(instance.getBookmarks());
        if (!Boolean.getBoolean(PROPERTY_STANDALONE)) {
            try {
                Preferences p = Preferences.userRoot().node(preferencesRoot);
                p.removeNode();
                p.flush();
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeBookmarks(BookmarkTreeModel model) {
        if (model != null && model.isModified()) {
            File bookmarkFile = new File(SystemConfig.getBaseDirectory(), fileBookmarks);
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(bookmarkFile, false);
                PrintStream printer = new PrintStream(fos, true);
                BookmarkTreeModel bookmarkTreeModel = model;
                synchronized (bookmarkTreeModel) {
                    model.store(printer);
                }
                printer.flush();
                fos.close();
            }
            catch (IOException ioe) {
                BasicUtilities.HandleException(ioe, BasicUtilities.getString("CFG_SAVE_ERROR"), true);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                    fos = null;
                }
            }
        }
    }

    private void killSessionPreferences() {
        if (!this.userPreferences.getBoolean("general.metrics-enabled")) {
            Preferences prefs = this.userPreferences.toPreferences();
            try {
                String[] keys = prefs.keys();
                for (int i = 0; i < keys.length; ++i) {
                    if (!keys[i].startsWith("session.")) continue;
                    prefs.remove(keys[i]);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void initRuntimeClasspath() {
        block13: {
            Vector urls = new Vector();
            if (!urls.isEmpty()) {
                URL[] xClassPath = urls.toArray(new URL[urls.size()]);
                this.rtClassLoader = new URLClassLoader(xClassPath, SystemConfig.class.getClassLoader());
            } else {
                this.rtClassLoader = SystemConfig.class.getClassLoader();
            }
            StringBuffer classPathTxt = new StringBuffer("");
            Enumeration enum1 = urls.elements();
            while (enum1.hasMoreElements()) {
                URL url = (URL)enum1.nextElement();
                classPathTxt.append(url.getFile());
                classPathTxt.append(File.pathSeparatorChar);
            }
            UIManager.put("ClassLoader", this.rtClassLoader);
            Thread.currentThread().setContextClassLoader(this.rtClassLoader);
            try {
                Class<?> c = Class.forName("com.incors.plaf.kunststoff.KunststoffLookAndFeel", true, this.rtClassLoader);
                c.newInstance();
                c = null;
            }
            catch (Throwable c) {}
            break block13;
            catch (Throwable t) {
                try {
                    BasicUtilities.HandleException(t);
                    this.rtClassLoader = SystemConfig.class.getClassLoader();
                }
                catch (Throwable throwable) {
                    UIManager.put("ClassLoader", this.rtClassLoader);
                    Thread.currentThread().setContextClassLoader(this.rtClassLoader);
                    try {
                        Class<?> c = Class.forName("com.incors.plaf.kunststoff.KunststoffLookAndFeel", true, this.rtClassLoader);
                        c.newInstance();
                        c = null;
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    throw throwable;
                }
                UIManager.put("ClassLoader", this.rtClassLoader);
                Thread.currentThread().setContextClassLoader(this.rtClassLoader);
                try {
                    Class<?> c = Class.forName("com.incors.plaf.kunststoff.KunststoffLookAndFeel", true, this.rtClassLoader);
                    c.newInstance();
                    Object var1_4 = null;
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private void initDriverDefinitions(boolean override) {
        File driverFile = new File(baseDirectory, "driver.properties");
        if (driverFile.exists() && override && !driverFile.delete()) {
            System.out.println("Could not reset driver definitions from file (" + driverFile + ")");
        }
    }

    private void createServiceProvider() {
        try {
            Class<?> clazz = Class.forName(this.serviceProviderClass, true, this.getRuntimeClassLoader());
            this.serviceProvider = (ServiceProvider)clazz.newInstance();
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, "");
            System.exit(-1);
            return;
        }
    }

    private static Preferences getDefaults() {
        Preferences defaults = Preferences.userRoot().node("/org/isqlviewer/core/Defaults");
        defaults.put("iSQL-Version", ISQL_VERSION);
        defaults.put("advanced.xml-parser", "org.apache.xerces.parsers.SAXParser");
        defaults.putBoolean("general.security-enabled", true);
        defaults.putInt("print.table-style", 0);
        defaults.putBoolean("print.grid-enabled", true);
        defaults.putBoolean("print.header-enabled", true);
        defaults.putBoolean("print.footer-enabled", true);
        defaults.putBoolean("print.color-enabled", true);
        defaults.putBoolean("general.servicescan-enabled", false);
        defaults.putBoolean("general.alldrivers-visible", false);
        defaults.putBoolean("servicemanager.switchtab-enabled", true);
        defaults.putBoolean("general.driversort-enabled", true);
        defaults.putBoolean("general.driverupdate-enabled", true);
        defaults.putBoolean("general.showupdatetab-enabled", false);
        defaults.put("advanced.httpproxy-host", System.getProperty("http.proxyHost", ""));
        defaults.put("advanced.httpproxy-port", System.getProperty("http.proxyPort", "80"));
        defaults.put("advanced.httpproxy-user", "");
        defaults.put("advanced.httpproxy-pass", "");
        defaults.putInt("general.max-resultsets", 10);
        defaults.putBoolean("general.hiddenfiles-enabled", false);
        String fmt = BasicUtilities.getString("Preferred_Date_Format");
        defaults.put("general.date-format", fmt);
        fmt = BasicUtilities.getString("Preferred_Time_Format");
        defaults.put("general.time-format", fmt);
        fmt = BasicUtilities.getString("Preferred_Timestamp_Format");
        defaults.put("general.timestamp-format", fmt);
        defaults.putBoolean("general.ascii2native-enabled", false);
        defaults.putBoolean("toolbar.file-visible", true);
        defaults.putBoolean("toolbar.history-visible", true);
        defaults.putBoolean("toolbar.resultset-visible", true);
        defaults.put("toolbar.history-dock", "North");
        defaults.put("toolbar.file-dock", "North");
        defaults.put("toolbar.resultset-dock", "West");
        defaults.put("general.results-format", "%s (%r,%c)");
        defaults.put("general.plaf-class", UIManager.getSystemLookAndFeelClassName());
        defaults.putBoolean("general.1clicksort-enabled", BasicUtilities.isMac());
        defaults.putInt("history.style", 0);
        defaults.putInt("history.max-count", 256);
        defaults.putInt("history.max-days", 30);
        defaults.putBoolean("history.sessionclear-enabled", true);
        defaults.putBoolean("history.circular-enabled", true);
        defaults.putBoolean("history.duplicates-enabled", true);
        defaults.putBoolean("history.crc32-enabled", true);
        defaults.putBoolean("history.persistent-enabled", false);
        defaults.put("bookmark.location", BasicUtilities.getString("Bookmark_Pref_Loc_Right"));
        defaults.putBoolean("bookmark.activation-style", false);
        defaults.putBoolean("bookmarks.deletewarning-enabled", true);
        defaults.putInt("general.tablepage-size", 4096);
        defaults.putBoolean("general.refresh-reuse", true);
        defaults.putBoolean("general.large-icons", true);
        defaults.putBoolean("general.metrics-enabled", false);
        defaults.put("advanced.classpath", "");
        defaults.put("general.null-color", "#FF0000");
        defaults.putInt("advanced.versioncheck-type", 0);
        defaults.putBoolean("advanced.versioncheck-enabled", false);
        defaults.putBoolean("editor.syntax-help.enabled", true);
        defaults.putBoolean("editor.context-help.enabled", true);
        defaults.put("editor.font", "Default,11");
        String defaultColor = StringUtilities.getHTMLColor(UIManager.getColor("TextArea.background"));
        defaults.put("editor.background-color", defaultColor);
        defaultColor = StringUtilities.getHTMLColor(UIManager.getColor("TextArea.foreground"));
        defaults.put("editor.default-color", defaultColor);
        String prefKey = null;
        prefKey = ConfigConstants.createStyleKey("editor.sql-keywords", "color");
        defaults.put(prefKey, "#0000FF");
        prefKey = ConfigConstants.createStyleKey("editor.sql-keywords", "bolded");
        defaults.putBoolean(prefKey, false);
        prefKey = ConfigConstants.createStyleKey("editor.sql-keywords", "italics");
        defaults.putBoolean(prefKey, false);
        prefKey = ConfigConstants.createStyleKey("editor.functions", "color");
        defaults.put(prefKey, "#000808");
        prefKey = ConfigConstants.createStyleKey("editor.functions", "bolded");
        defaults.putBoolean(prefKey, false);
        prefKey = ConfigConstants.createStyleKey("editor.functions", "italics");
        defaults.putBoolean(prefKey, false);
        prefKey = ConfigConstants.createStyleKey("editor.literals", "color");
        defaults.put(prefKey, "#0000FF");
        prefKey = ConfigConstants.createStyleKey("editor.literals", "bolded");
        defaults.putBoolean(prefKey, false);
        prefKey = ConfigConstants.createStyleKey("editor.literals", "italics");
        defaults.putBoolean(prefKey, false);
        prefKey = ConfigConstants.createStyleKey("editor.local-obj", "color");
        defaults.put(prefKey, "#810558");
        prefKey = ConfigConstants.createStyleKey("editor.local-obj", "bolded");
        defaults.putBoolean(prefKey, false);
        prefKey = ConfigConstants.createStyleKey("editor.local-obj", "italics");
        defaults.putBoolean(prefKey, false);
        prefKey = ConfigConstants.createStyleKey("editor.foreign-obj", "color");
        defaults.put(prefKey, "#6666FF");
        prefKey = ConfigConstants.createStyleKey("editor.foreign-obj", "bolded");
        defaults.putBoolean(prefKey, false);
        prefKey = ConfigConstants.createStyleKey("editor.foreign-obj", "italics");
        defaults.putBoolean(prefKey, true);
        prefKey = ConfigConstants.createStyleKey("editor.procedures", "color");
        defaults.put(prefKey, "#000808");
        prefKey = ConfigConstants.createStyleKey("editor.procedures", "bolded");
        defaults.putBoolean(prefKey, false);
        prefKey = ConfigConstants.createStyleKey("editor.procedures", "italics");
        defaults.putBoolean(prefKey, false);
        prefKey = ConfigConstants.createStyleKey("editor.parameters", "color");
        defaults.put(prefKey, "#808080");
        prefKey = ConfigConstants.createStyleKey("editor.parameters", "bolded");
        defaults.putBoolean(prefKey, true);
        prefKey = ConfigConstants.createStyleKey("editor.parameters", "italics");
        defaults.putBoolean(prefKey, false);
        prefKey = ConfigConstants.createStyleKey("editor.sline-comments", "color");
        defaults.put(prefKey, "#808080");
        prefKey = ConfigConstants.createStyleKey("editor.sline-comments", "bolded");
        defaults.putBoolean(prefKey, false);
        prefKey = ConfigConstants.createStyleKey("editor.sline-comments", "italics");
        defaults.putBoolean(prefKey, true);
        prefKey = ConfigConstants.createStyleKey("editor.multicomment-color", "color");
        defaults.put(prefKey, "#5F9479");
        prefKey = ConfigConstants.createStyleKey("editor.multicomment-color", "bolded");
        defaults.putBoolean(prefKey, false);
        prefKey = ConfigConstants.createStyleKey("editor.multicomment-color", "italics");
        defaults.putBoolean(prefKey, true);
        prefKey = ConfigConstants.createStyleKey("editor.tablespace", "color");
        defaults.put(prefKey, "#000088");
        prefKey = ConfigConstants.createStyleKey("editor.tablespace", "bolded");
        defaults.putBoolean(prefKey, false);
        prefKey = ConfigConstants.createStyleKey("editor.tablespace", "italics");
        defaults.putBoolean(prefKey, true);
        defaults.putBoolean("editor.caretoffset-enabled", false);
        defaults.putBoolean("editor.autoclear-enabled", false);
        defaults.put("console.timestamp-format", "[HH:mm:ss]");
        defaults.put("console.err-color", "#FF0000");
        defaults.put("console.sql-color", "#0000FF");
        defaultColor = StringUtilities.getHTMLColor(UIManager.getColor("TextArea.background"));
        defaults.put("console.background-color", defaultColor);
        defaultColor = StringUtilities.getHTMLColor(UIManager.getColor("TextArea.foreground"));
        defaults.put("console.foreground-color", defaultColor);
        defaults.put("console.font", "Monospaced,9");
        defaults.putBoolean("jdbc.verbose-enabled", false);
        defaults.putBoolean("jdbc.reverseFetch-enabled", false);
        defaults.putBoolean("jdbc.debug-enabled", false);
        defaults.putBoolean("jdbc.trace-enabled", false);
        defaults.putBoolean("jdbc.escapeProc-enabled", false);
        defaults.putBoolean("jdbc.echo-query", true);
        defaults.putBoolean("jdbc.echo-rowcount", true);
        defaults.putBoolean("jdbc.keepalive-enabled", true);
        defaults.putBoolean("jdbc.autocommit-enabled", true);
        defaults.putBoolean("general.security-enabled", false);
        defaults.putInt("jdbc.timeout-login", 0);
        defaults.putInt("jdbc.timeout-query", 0);
        defaults.putInt("jdbc.max-fieldsize", 0);
        defaults.putInt("jdbc.max-rows", 0);
        defaults.putInt("jdbc.max-warnings", 10);
        defaults.put("batch.comment-char", "#");
        defaults.put("batch.literal-char", "\"");
        defaults.put("batch.seperator-char", ";");
        defaults.putInt("batch.comment-style", 0);
        defaults.putInt("batch.literal-style", 0);
        defaults.putInt("batch.seperator-style", 0);
        defaults.put("batch.lowercase-enable", "false");
        return defaults;
    }

    private static class ProxyAuthenticator
    extends Authenticator {
        private ProxyAuthenticator() {
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            SystemConfig systemConfig = SystemConfig.getInstance();
            UserPreferences prefs = systemConfig.getPreferences();
            String user = prefs.get("advanced.httpproxy-user");
            char[] pass = prefs.get("advanced.httpproxy-pass").toCharArray();
            return new PasswordAuthentication(user, pass);
        }
    }

    private static class EventHandlerSupport
    implements TreeModelListener,
    Runnable {
        private static final long SAVE_THRESHOLD = 300000L;
        private long lastSave = 0L;

        private EventHandlerSupport() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            EventHandlerSupport eventHandlerSupport = this;
            synchronized (eventHandlerSupport) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            EventHandlerSupport eventHandlerSupport = this;
            synchronized (eventHandlerSupport) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            EventHandlerSupport eventHandlerSupport = this;
            synchronized (eventHandlerSupport) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            EventHandlerSupport eventHandlerSupport = this;
            synchronized (eventHandlerSupport) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!Thread.interrupted()) {
                EventHandlerSupport eventHandlerSupport = this;
                synchronized (eventHandlerSupport) {
                    try {
                        this.wait(300000L);
                    }
                    catch (InterruptedException ie) {
                        return;
                    }
                }
                if (instance == null || this.lastSave + 300000L < System.currentTimeMillis()) continue;
                BookmarkTreeModel mdl = instance.getBookmarks();
                SystemConfig.storeBookmarks(mdl);
                this.lastSave = System.currentTimeMillis();
            }
        }
    }
}

